{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Points at a location inside a CSS stream.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.CssLocation
    ( 

-- * Exported types
    CssLocation(..)                         ,
    newZeroCssLocation                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveCssLocationMethod                ,
#endif



 -- * Properties


-- ** bytes #attr:bytes#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    cssLocation_bytes                       ,
#endif
    getCssLocationBytes                     ,
    setCssLocationBytes                     ,


-- ** chars #attr:chars#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    cssLocation_chars                       ,
#endif
    getCssLocationChars                     ,
    setCssLocationChars                     ,


-- ** lineBytes #attr:lineBytes#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    cssLocation_lineBytes                   ,
#endif
    getCssLocationLineBytes                 ,
    setCssLocationLineBytes                 ,


-- ** lineChars #attr:lineChars#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    cssLocation_lineChars                   ,
#endif
    getCssLocationLineChars                 ,
    setCssLocationLineChars                 ,


-- ** lines #attr:lines#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    cssLocation_lines                       ,
#endif
    getCssLocationLines                     ,
    setCssLocationLines                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype CssLocation = CssLocation (SP.ManagedPtr CssLocation)
    deriving (Eq)

instance SP.ManagedPtrNewtype CssLocation where
    toManagedPtr (CssLocation p) = p

instance BoxedPtr CssLocation where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr CssLocation)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr CssLocation where
    boxedPtrCalloc = callocBytes 40


-- | Construct a t'CssLocation' struct initialized to zero.
newZeroCssLocation :: MonadIO m => m CssLocation
newZeroCssLocation = liftIO $ boxedPtrCalloc >>= wrapPtr CssLocation

instance tag ~ 'AttrSet => Constructible CssLocation tag where
    new _ attrs = do
        o <- newZeroCssLocation
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cssLocation #bytes
-- @
getCssLocationBytes :: MonadIO m => CssLocation -> m FCT.CSize
getCssLocationBytes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CSize
    return val

-- | Set the value of the “@bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cssLocation [ #bytes 'Data.GI.Base.Attributes.:=' value ]
-- @
setCssLocationBytes :: MonadIO m => CssLocation -> FCT.CSize -> m ()
setCssLocationBytes s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data CssLocationBytesFieldInfo
instance AttrInfo CssLocationBytesFieldInfo where
    type AttrBaseTypeConstraint CssLocationBytesFieldInfo = (~) CssLocation
    type AttrAllowedOps CssLocationBytesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint CssLocationBytesFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint CssLocationBytesFieldInfo = (~)FCT.CSize
    type AttrTransferType CssLocationBytesFieldInfo = FCT.CSize
    type AttrGetType CssLocationBytesFieldInfo = FCT.CSize
    type AttrLabel CssLocationBytesFieldInfo = "bytes"
    type AttrOrigin CssLocationBytesFieldInfo = CssLocation
    attrGet = getCssLocationBytes
    attrSet = setCssLocationBytes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.CssLocation.bytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-CssLocation.html#g:attr:bytes"
        })

cssLocation_bytes :: AttrLabelProxy "bytes"
cssLocation_bytes = AttrLabelProxy

#endif


-- | Get the value of the “@chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cssLocation #chars
-- @
getCssLocationChars :: MonadIO m => CssLocation -> m FCT.CSize
getCssLocationChars s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO FCT.CSize
    return val

-- | Set the value of the “@chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cssLocation [ #chars 'Data.GI.Base.Attributes.:=' value ]
-- @
setCssLocationChars :: MonadIO m => CssLocation -> FCT.CSize -> m ()
setCssLocationChars s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data CssLocationCharsFieldInfo
instance AttrInfo CssLocationCharsFieldInfo where
    type AttrBaseTypeConstraint CssLocationCharsFieldInfo = (~) CssLocation
    type AttrAllowedOps CssLocationCharsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint CssLocationCharsFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint CssLocationCharsFieldInfo = (~)FCT.CSize
    type AttrTransferType CssLocationCharsFieldInfo = FCT.CSize
    type AttrGetType CssLocationCharsFieldInfo = FCT.CSize
    type AttrLabel CssLocationCharsFieldInfo = "chars"
    type AttrOrigin CssLocationCharsFieldInfo = CssLocation
    attrGet = getCssLocationChars
    attrSet = setCssLocationChars
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.CssLocation.chars"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-CssLocation.html#g:attr:chars"
        })

cssLocation_chars :: AttrLabelProxy "chars"
cssLocation_chars = AttrLabelProxy

#endif


-- | Get the value of the “@lines@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cssLocation #lines
-- @
getCssLocationLines :: MonadIO m => CssLocation -> m FCT.CSize
getCssLocationLines s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO FCT.CSize
    return val

-- | Set the value of the “@lines@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cssLocation [ #lines 'Data.GI.Base.Attributes.:=' value ]
-- @
setCssLocationLines :: MonadIO m => CssLocation -> FCT.CSize -> m ()
setCssLocationLines s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data CssLocationLinesFieldInfo
instance AttrInfo CssLocationLinesFieldInfo where
    type AttrBaseTypeConstraint CssLocationLinesFieldInfo = (~) CssLocation
    type AttrAllowedOps CssLocationLinesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint CssLocationLinesFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint CssLocationLinesFieldInfo = (~)FCT.CSize
    type AttrTransferType CssLocationLinesFieldInfo = FCT.CSize
    type AttrGetType CssLocationLinesFieldInfo = FCT.CSize
    type AttrLabel CssLocationLinesFieldInfo = "lines"
    type AttrOrigin CssLocationLinesFieldInfo = CssLocation
    attrGet = getCssLocationLines
    attrSet = setCssLocationLines
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.CssLocation.lines"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-CssLocation.html#g:attr:lines"
        })

cssLocation_lines :: AttrLabelProxy "lines"
cssLocation_lines = AttrLabelProxy

#endif


-- | Get the value of the “@line_bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cssLocation #lineBytes
-- @
getCssLocationLineBytes :: MonadIO m => CssLocation -> m FCT.CSize
getCssLocationLineBytes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO FCT.CSize
    return val

-- | Set the value of the “@line_bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cssLocation [ #lineBytes 'Data.GI.Base.Attributes.:=' value ]
-- @
setCssLocationLineBytes :: MonadIO m => CssLocation -> FCT.CSize -> m ()
setCssLocationLineBytes s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data CssLocationLineBytesFieldInfo
instance AttrInfo CssLocationLineBytesFieldInfo where
    type AttrBaseTypeConstraint CssLocationLineBytesFieldInfo = (~) CssLocation
    type AttrAllowedOps CssLocationLineBytesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint CssLocationLineBytesFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint CssLocationLineBytesFieldInfo = (~)FCT.CSize
    type AttrTransferType CssLocationLineBytesFieldInfo = FCT.CSize
    type AttrGetType CssLocationLineBytesFieldInfo = FCT.CSize
    type AttrLabel CssLocationLineBytesFieldInfo = "line_bytes"
    type AttrOrigin CssLocationLineBytesFieldInfo = CssLocation
    attrGet = getCssLocationLineBytes
    attrSet = setCssLocationLineBytes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.CssLocation.lineBytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-CssLocation.html#g:attr:lineBytes"
        })

cssLocation_lineBytes :: AttrLabelProxy "lineBytes"
cssLocation_lineBytes = AttrLabelProxy

#endif


-- | Get the value of the “@line_chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cssLocation #lineChars
-- @
getCssLocationLineChars :: MonadIO m => CssLocation -> m FCT.CSize
getCssLocationLineChars s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO FCT.CSize
    return val

-- | Set the value of the “@line_chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cssLocation [ #lineChars 'Data.GI.Base.Attributes.:=' value ]
-- @
setCssLocationLineChars :: MonadIO m => CssLocation -> FCT.CSize -> m ()
setCssLocationLineChars s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data CssLocationLineCharsFieldInfo
instance AttrInfo CssLocationLineCharsFieldInfo where
    type AttrBaseTypeConstraint CssLocationLineCharsFieldInfo = (~) CssLocation
    type AttrAllowedOps CssLocationLineCharsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint CssLocationLineCharsFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint CssLocationLineCharsFieldInfo = (~)FCT.CSize
    type AttrTransferType CssLocationLineCharsFieldInfo = FCT.CSize
    type AttrGetType CssLocationLineCharsFieldInfo = FCT.CSize
    type AttrLabel CssLocationLineCharsFieldInfo = "line_chars"
    type AttrOrigin CssLocationLineCharsFieldInfo = CssLocation
    attrGet = getCssLocationLineChars
    attrSet = setCssLocationLineChars
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.CssLocation.lineChars"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-CssLocation.html#g:attr:lineChars"
        })

cssLocation_lineChars :: AttrLabelProxy "lineChars"
cssLocation_lineChars = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CssLocation
type instance O.AttributeList CssLocation = CssLocationAttributeList
type CssLocationAttributeList = ('[ '("bytes", CssLocationBytesFieldInfo), '("chars", CssLocationCharsFieldInfo), '("lines", CssLocationLinesFieldInfo), '("lineBytes", CssLocationLineBytesFieldInfo), '("lineChars", CssLocationLineCharsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveCssLocationMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCssLocationMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCssLocationMethod t CssLocation, O.OverloadedMethod info CssLocation p) => OL.IsLabel t (CssLocation -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCssLocationMethod t CssLocation, O.OverloadedMethod info CssLocation p, R.HasField t CssLocation p) => R.HasField t CssLocation p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCssLocationMethod t CssLocation, O.OverloadedMethodInfo info CssLocation) => OL.IsLabel t (O.MethodProxy info CssLocation) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


