{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GTlsConnection@ is the base TLS connection class type, which wraps
-- a t'GI.Gio.Objects.IOStream.IOStream' and provides TLS encryption on top of it. Its
-- subclasses, t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection' and
-- t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection', implement client-side and server-side TLS,
-- respectively.
-- 
-- For DTLS (Datagram TLS) support, see t'GI.Gio.Interfaces.DtlsConnection.DtlsConnection'.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.TlsConnection
    ( 
#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetChannelBindingDataMethodInfo,
#endif

-- * Exported types
    TlsConnection(..)                       ,
    IsTlsConnection                         ,
    toTlsConnection                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [emitAcceptCertificate]("GI.Gio.Objects.TlsConnection#g:method:emitAcceptCertificate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [handshake]("GI.Gio.Objects.TlsConnection#g:method:handshake"), [handshakeAsync]("GI.Gio.Objects.TlsConnection#g:method:handshakeAsync"), [handshakeFinish]("GI.Gio.Objects.TlsConnection#g:method:handshakeFinish"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCertificate]("GI.Gio.Objects.TlsConnection#g:method:getCertificate"), [getChannelBindingData]("GI.Gio.Objects.TlsConnection#g:method:getChannelBindingData"), [getCiphersuiteName]("GI.Gio.Objects.TlsConnection#g:method:getCiphersuiteName"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDatabase]("GI.Gio.Objects.TlsConnection#g:method:getDatabase"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getInteraction]("GI.Gio.Objects.TlsConnection#g:method:getInteraction"), [getNegotiatedProtocol]("GI.Gio.Objects.TlsConnection#g:method:getNegotiatedProtocol"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getPeerCertificate]("GI.Gio.Objects.TlsConnection#g:method:getPeerCertificate"), [getPeerCertificateErrors]("GI.Gio.Objects.TlsConnection#g:method:getPeerCertificateErrors"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getProtocolVersion]("GI.Gio.Objects.TlsConnection#g:method:getProtocolVersion"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRehandshakeMode]("GI.Gio.Objects.TlsConnection#g:method:getRehandshakeMode"), [getRequireCloseNotify]("GI.Gio.Objects.TlsConnection#g:method:getRequireCloseNotify"), [getUseSystemCertdb]("GI.Gio.Objects.TlsConnection#g:method:getUseSystemCertdb").
-- 
-- ==== Setters
-- [setAdvertisedProtocols]("GI.Gio.Objects.TlsConnection#g:method:setAdvertisedProtocols"), [setCertificate]("GI.Gio.Objects.TlsConnection#g:method:setCertificate"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDatabase]("GI.Gio.Objects.TlsConnection#g:method:setDatabase"), [setInteraction]("GI.Gio.Objects.TlsConnection#g:method:setInteraction"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRehandshakeMode]("GI.Gio.Objects.TlsConnection#g:method:setRehandshakeMode"), [setRequireCloseNotify]("GI.Gio.Objects.TlsConnection#g:method:setRequireCloseNotify"), [setUseSystemCertdb]("GI.Gio.Objects.TlsConnection#g:method:setUseSystemCertdb").

#if defined(ENABLE_OVERLOADING)
    ResolveTlsConnectionMethod              ,
#endif

-- ** emitAcceptCertificate #method:emitAcceptCertificate#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionEmitAcceptCertificateMethodInfo,
#endif
    tlsConnectionEmitAcceptCertificate      ,


-- ** getCertificate #method:getCertificate#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetCertificateMethodInfo   ,
#endif
    tlsConnectionGetCertificate             ,


-- ** getCiphersuiteName #method:getCiphersuiteName#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetCiphersuiteNameMethodInfo,
#endif
    tlsConnectionGetCiphersuiteName         ,


-- ** getDatabase #method:getDatabase#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetDatabaseMethodInfo      ,
#endif
    tlsConnectionGetDatabase                ,


-- ** getInteraction #method:getInteraction#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetInteractionMethodInfo   ,
#endif
    tlsConnectionGetInteraction             ,


-- ** getNegotiatedProtocol #method:getNegotiatedProtocol#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetNegotiatedProtocolMethodInfo,
#endif
    tlsConnectionGetNegotiatedProtocol      ,


-- ** getPeerCertificate #method:getPeerCertificate#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetPeerCertificateMethodInfo,
#endif
    tlsConnectionGetPeerCertificate         ,


-- ** getPeerCertificateErrors #method:getPeerCertificateErrors#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetPeerCertificateErrorsMethodInfo,
#endif
    tlsConnectionGetPeerCertificateErrors   ,


-- ** getProtocolVersion #method:getProtocolVersion#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetProtocolVersionMethodInfo,
#endif
    tlsConnectionGetProtocolVersion         ,


-- ** getRehandshakeMode #method:getRehandshakeMode#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetRehandshakeModeMethodInfo,
#endif
    tlsConnectionGetRehandshakeMode         ,


-- ** getRequireCloseNotify #method:getRequireCloseNotify#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetRequireCloseNotifyMethodInfo,
#endif
    tlsConnectionGetRequireCloseNotify      ,


-- ** getUseSystemCertdb #method:getUseSystemCertdb#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionGetUseSystemCertdbMethodInfo,
#endif
    tlsConnectionGetUseSystemCertdb         ,


-- ** handshake #method:handshake#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionHandshakeMethodInfo        ,
#endif
    tlsConnectionHandshake                  ,


-- ** handshakeAsync #method:handshakeAsync#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionHandshakeAsyncMethodInfo   ,
#endif
    tlsConnectionHandshakeAsync             ,


-- ** handshakeFinish #method:handshakeFinish#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionHandshakeFinishMethodInfo  ,
#endif
    tlsConnectionHandshakeFinish            ,


-- ** setAdvertisedProtocols #method:setAdvertisedProtocols#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionSetAdvertisedProtocolsMethodInfo,
#endif
    tlsConnectionSetAdvertisedProtocols     ,


-- ** setCertificate #method:setCertificate#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionSetCertificateMethodInfo   ,
#endif
    tlsConnectionSetCertificate             ,


-- ** setDatabase #method:setDatabase#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionSetDatabaseMethodInfo      ,
#endif
    tlsConnectionSetDatabase                ,


-- ** setInteraction #method:setInteraction#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionSetInteractionMethodInfo   ,
#endif
    tlsConnectionSetInteraction             ,


-- ** setRehandshakeMode #method:setRehandshakeMode#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionSetRehandshakeModeMethodInfo,
#endif
    tlsConnectionSetRehandshakeMode         ,


-- ** setRequireCloseNotify #method:setRequireCloseNotify#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionSetRequireCloseNotifyMethodInfo,
#endif
    tlsConnectionSetRequireCloseNotify      ,


-- ** setUseSystemCertdb #method:setUseSystemCertdb#

#if defined(ENABLE_OVERLOADING)
    TlsConnectionSetUseSystemCertdbMethodInfo,
#endif
    tlsConnectionSetUseSystemCertdb         ,




 -- * Properties


-- ** advertisedProtocols #attr:advertisedProtocols#
-- | The list of application-layer protocols that the connection
-- advertises that it is willing to speak. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetAdvertisedProtocols'.
-- 
-- /Since: 2.60/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionAdvertisedProtocolsPropertyInfo,
#endif
    clearTlsConnectionAdvertisedProtocols   ,
    constructTlsConnectionAdvertisedProtocols,
    getTlsConnectionAdvertisedProtocols     ,
    setTlsConnectionAdvertisedProtocols     ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionAdvertisedProtocols        ,
#endif


-- ** baseIoStream #attr:baseIoStream#
-- | The t'GI.Gio.Objects.IOStream.IOStream' that the connection wraps. The connection holds a reference
-- to this stream, and may run operations on the stream from other threads
-- throughout its lifetime. Consequently, after the t'GI.Gio.Objects.IOStream.IOStream' has been
-- constructed, application code may only run its own operations on this
-- stream when no t'GI.Gio.Objects.IOStream.IOStream' operations are running.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionBaseIoStreamPropertyInfo   ,
#endif
    constructTlsConnectionBaseIoStream      ,
    getTlsConnectionBaseIoStream            ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionBaseIoStream               ,
#endif


-- ** certificate #attr:certificate#
-- | The connection\'s certificate; see
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetCertificate'.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionCertificatePropertyInfo    ,
#endif
    constructTlsConnectionCertificate       ,
    getTlsConnectionCertificate             ,
    setTlsConnectionCertificate             ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionCertificate                ,
#endif


-- ** ciphersuiteName #attr:ciphersuiteName#
-- | The name of the TLS ciphersuite in use. See 'GI.Gio.Objects.TlsConnection.tlsConnectionGetCiphersuiteName'.
-- 
-- /Since: 2.70/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionCiphersuiteNamePropertyInfo,
#endif
    getTlsConnectionCiphersuiteName         ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionCiphersuiteName            ,
#endif


-- ** database #attr:database#
-- | The certificate database to use when verifying this TLS connection.
-- If no certificate database is set, then the default database will be
-- used. See 'GI.Gio.Interfaces.TlsBackend.tlsBackendGetDefaultDatabase'.
-- 
-- When using a non-default database, t'GI.Gio.Objects.TlsConnection.TlsConnection' must fall back to using
-- the t'GI.Gio.Objects.TlsDatabase.TlsDatabase' to perform certificate verification using
-- 'GI.Gio.Objects.TlsDatabase.tlsDatabaseVerifyChain', which means certificate verification will
-- not be able to make use of TLS session context. This may be less secure.
-- For example, if you create your own t'GI.Gio.Objects.TlsDatabase.TlsDatabase' that just wraps the
-- default t'GI.Gio.Objects.TlsDatabase.TlsDatabase', you might expect that you have not changed anything,
-- but this is not true because you may have altered the behavior of
-- t'GI.Gio.Objects.TlsConnection.TlsConnection' by causing it to use 'GI.Gio.Objects.TlsDatabase.tlsDatabaseVerifyChain'. See the
-- documentation of 'GI.Gio.Objects.TlsDatabase.tlsDatabaseVerifyChain' for more details on specific
-- security checks that may not be performed. Accordingly, setting a
-- non-default database is discouraged except for specialty applications with
-- unusual security requirements.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionDatabasePropertyInfo       ,
#endif
    clearTlsConnectionDatabase              ,
    constructTlsConnectionDatabase          ,
    getTlsConnectionDatabase                ,
    setTlsConnectionDatabase                ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionDatabase                   ,
#endif


-- ** interaction #attr:interaction#
-- | A t'GI.Gio.Objects.TlsInteraction.TlsInteraction' object to be used when the connection or certificate
-- database need to interact with the user. This will be used to prompt the
-- user for passwords where necessary.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionInteractionPropertyInfo    ,
#endif
    clearTlsConnectionInteraction           ,
    constructTlsConnectionInteraction       ,
    getTlsConnectionInteraction             ,
    setTlsConnectionInteraction             ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionInteraction                ,
#endif


-- ** negotiatedProtocol #attr:negotiatedProtocol#
-- | The application-layer protocol negotiated during the TLS
-- handshake. See 'GI.Gio.Objects.TlsConnection.tlsConnectionGetNegotiatedProtocol'.
-- 
-- /Since: 2.60/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionNegotiatedProtocolPropertyInfo,
#endif
    getTlsConnectionNegotiatedProtocol      ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionNegotiatedProtocol         ,
#endif


-- ** peerCertificate #attr:peerCertificate#
-- | The connection\'s peer\'s certificate, after the TLS handshake has
-- completed or failed. Note in particular that this is not yet set
-- during the emission of [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate").
-- 
-- (You can watch for a [Object::notify]("GI.GObject.Objects.Object#g:signal:notify") signal on this property to
-- detect when a handshake has occurred.)
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionPeerCertificatePropertyInfo,
#endif
    getTlsConnectionPeerCertificate         ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionPeerCertificate            ,
#endif


-- ** peerCertificateErrors #attr:peerCertificateErrors#
-- | The errors noticed while verifying
-- [TlsConnection:peerCertificate]("GI.Gio.Objects.TlsConnection#g:attr:peerCertificate"). Normally this should be 0, but
-- it may not be if [TlsClientConnection:validationFlags]("GI.Gio.Interfaces.TlsClientConnection#g:attr:validationFlags") is not
-- 'GI.Gio.Flags.TlsCertificateFlagsValidateAll', or if
-- [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate") overrode the default
-- behavior.
-- 
-- GLib guarantees that if certificate verification fails, at least
-- one error will be set, but it does not guarantee that all possible
-- errors will be set. Accordingly, you may not safely decide to
-- ignore any particular type of error. For example, it would be
-- incorrect to mask 'GI.Gio.Flags.TlsCertificateFlagsExpired' if you want to allow
-- expired certificates, because this could potentially be the only
-- error flag set even if other problems exist with the certificate.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionPeerCertificateErrorsPropertyInfo,
#endif
    getTlsConnectionPeerCertificateErrors   ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionPeerCertificateErrors      ,
#endif


-- ** protocolVersion #attr:protocolVersion#
-- | The TLS protocol version in use. See 'GI.Gio.Objects.TlsConnection.tlsConnectionGetProtocolVersion'.
-- 
-- /Since: 2.70/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionProtocolVersionPropertyInfo,
#endif
    getTlsConnectionProtocolVersion         ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionProtocolVersion            ,
#endif


-- ** rehandshakeMode #attr:rehandshakeMode#
-- | The rehandshaking mode. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetRehandshakeMode'.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionRehandshakeModePropertyInfo,
#endif
    constructTlsConnectionRehandshakeMode   ,
    getTlsConnectionRehandshakeMode         ,
    setTlsConnectionRehandshakeMode         ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionRehandshakeMode            ,
#endif


-- ** requireCloseNotify #attr:requireCloseNotify#
-- | Whether or not proper TLS close notification is required.
-- See 'GI.Gio.Objects.TlsConnection.tlsConnectionSetRequireCloseNotify'.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsConnectionRequireCloseNotifyPropertyInfo,
#endif
    constructTlsConnectionRequireCloseNotify,
    getTlsConnectionRequireCloseNotify      ,
    setTlsConnectionRequireCloseNotify      ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionRequireCloseNotify         ,
#endif


-- ** useSystemCertdb #attr:useSystemCertdb#
-- | Whether or not the system certificate database will be used to
-- verify peer certificates. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetUseSystemCertdb'.

#if defined(ENABLE_OVERLOADING)
    TlsConnectionUseSystemCertdbPropertyInfo,
#endif
    constructTlsConnectionUseSystemCertdb   ,
    getTlsConnectionUseSystemCertdb         ,
    setTlsConnectionUseSystemCertdb         ,
#if defined(ENABLE_OVERLOADING)
    tlsConnectionUseSystemCertdb            ,
#endif




 -- * Signals


-- ** acceptCertificate #signal:acceptCertificate#

    TlsConnectionAcceptCertificateCallback  ,
#if defined(ENABLE_OVERLOADING)
    TlsConnectionAcceptCertificateSignalInfo,
#endif
    afterTlsConnectionAcceptCertificate     ,
    onTlsConnectionAcceptCertificate        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsInteraction as Gio.TlsInteraction
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsPassword as Gio.TlsPassword
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsInteraction as Gio.TlsInteraction

#endif

-- | Memory-managed wrapper type.
newtype TlsConnection = TlsConnection (SP.ManagedPtr TlsConnection)
    deriving (Eq)

instance SP.ManagedPtrNewtype TlsConnection where
    toManagedPtr (TlsConnection p) = p

foreign import ccall "g_tls_connection_get_type"
    c_g_tls_connection_get_type :: IO B.Types.GType

instance B.Types.TypedObject TlsConnection where
    glibType = c_g_tls_connection_get_type

instance B.Types.GObject TlsConnection

-- | Type class for types which can be safely cast to t'TlsConnection', for instance with `toTlsConnection`.
class (SP.GObject o, O.IsDescendantOf TlsConnection o) => IsTlsConnection o
instance (SP.GObject o, O.IsDescendantOf TlsConnection o) => IsTlsConnection o

instance O.HasParentTypes TlsConnection
type instance O.ParentTypes TlsConnection = '[Gio.IOStream.IOStream, GObject.Object.Object]

-- | Cast to t'TlsConnection', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTlsConnection :: (MIO.MonadIO m, IsTlsConnection o) => o -> m TlsConnection
toTlsConnection = MIO.liftIO . B.ManagedPtr.unsafeCastTo TlsConnection

-- | Convert t'TlsConnection' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TlsConnection) where
    gvalueGType_ = c_g_tls_connection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TlsConnection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TlsConnection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TlsConnection ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTlsConnectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTlsConnectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTlsConnectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTlsConnectionMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveTlsConnectionMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveTlsConnectionMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveTlsConnectionMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveTlsConnectionMethod "emitAcceptCertificate" o = TlsConnectionEmitAcceptCertificateMethodInfo
    ResolveTlsConnectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTlsConnectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTlsConnectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTlsConnectionMethod "handshake" o = TlsConnectionHandshakeMethodInfo
    ResolveTlsConnectionMethod "handshakeAsync" o = TlsConnectionHandshakeAsyncMethodInfo
    ResolveTlsConnectionMethod "handshakeFinish" o = TlsConnectionHandshakeFinishMethodInfo
    ResolveTlsConnectionMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveTlsConnectionMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveTlsConnectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTlsConnectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTlsConnectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTlsConnectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTlsConnectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTlsConnectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTlsConnectionMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveTlsConnectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTlsConnectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTlsConnectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTlsConnectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTlsConnectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTlsConnectionMethod "getCertificate" o = TlsConnectionGetCertificateMethodInfo
    ResolveTlsConnectionMethod "getChannelBindingData" o = TlsConnectionGetChannelBindingDataMethodInfo
    ResolveTlsConnectionMethod "getCiphersuiteName" o = TlsConnectionGetCiphersuiteNameMethodInfo
    ResolveTlsConnectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTlsConnectionMethod "getDatabase" o = TlsConnectionGetDatabaseMethodInfo
    ResolveTlsConnectionMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveTlsConnectionMethod "getInteraction" o = TlsConnectionGetInteractionMethodInfo
    ResolveTlsConnectionMethod "getNegotiatedProtocol" o = TlsConnectionGetNegotiatedProtocolMethodInfo
    ResolveTlsConnectionMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveTlsConnectionMethod "getPeerCertificate" o = TlsConnectionGetPeerCertificateMethodInfo
    ResolveTlsConnectionMethod "getPeerCertificateErrors" o = TlsConnectionGetPeerCertificateErrorsMethodInfo
    ResolveTlsConnectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTlsConnectionMethod "getProtocolVersion" o = TlsConnectionGetProtocolVersionMethodInfo
    ResolveTlsConnectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTlsConnectionMethod "getRehandshakeMode" o = TlsConnectionGetRehandshakeModeMethodInfo
    ResolveTlsConnectionMethod "getRequireCloseNotify" o = TlsConnectionGetRequireCloseNotifyMethodInfo
    ResolveTlsConnectionMethod "getUseSystemCertdb" o = TlsConnectionGetUseSystemCertdbMethodInfo
    ResolveTlsConnectionMethod "setAdvertisedProtocols" o = TlsConnectionSetAdvertisedProtocolsMethodInfo
    ResolveTlsConnectionMethod "setCertificate" o = TlsConnectionSetCertificateMethodInfo
    ResolveTlsConnectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTlsConnectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTlsConnectionMethod "setDatabase" o = TlsConnectionSetDatabaseMethodInfo
    ResolveTlsConnectionMethod "setInteraction" o = TlsConnectionSetInteractionMethodInfo
    ResolveTlsConnectionMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveTlsConnectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTlsConnectionMethod "setRehandshakeMode" o = TlsConnectionSetRehandshakeModeMethodInfo
    ResolveTlsConnectionMethod "setRequireCloseNotify" o = TlsConnectionSetRequireCloseNotifyMethodInfo
    ResolveTlsConnectionMethod "setUseSystemCertdb" o = TlsConnectionSetUseSystemCertdbMethodInfo
    ResolveTlsConnectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTlsConnectionMethod t TlsConnection, O.OverloadedMethod info TlsConnection p) => OL.IsLabel t (TlsConnection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTlsConnectionMethod t TlsConnection, O.OverloadedMethod info TlsConnection p, R.HasField t TlsConnection p) => R.HasField t TlsConnection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTlsConnectionMethod t TlsConnection, O.OverloadedMethodInfo info TlsConnection) => OL.IsLabel t (O.MethodProxy info TlsConnection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal TlsConnection::accept-certificate
-- | Emitted during the TLS handshake after the peer certificate has
-- been received. You can examine /@peerCert@/\'s certification path by
-- calling 'GI.Gio.Objects.TlsCertificate.tlsCertificateGetIssuer' on it.
-- 
-- For a client-side connection, /@peerCert@/ is the server\'s
-- certificate, and the signal will only be emitted if the
-- certificate was not acceptable according to /@conn@/\'s
-- t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection':@/validation_flags/@. If you would like the
-- certificate to be accepted despite /@errors@/, return 'P.True' from the
-- signal handler. Otherwise, if no handler accepts the certificate,
-- the handshake will fail with 'GI.Gio.Enums.TlsErrorBadCertificate'.
-- 
-- GLib guarantees that if certificate verification fails, this signal
-- will be emitted with at least one error will be set in /@errors@/, but
-- it does not guarantee that all possible errors will be set.
-- Accordingly, you may not safely decide to ignore any particular
-- type of error. For example, it would be incorrect to ignore
-- 'GI.Gio.Flags.TlsCertificateFlagsExpired' if you want to allow expired
-- certificates, because this could potentially be the only error flag
-- set even if other problems exist with the certificate.
-- 
-- For a server-side connection, /@peerCert@/ is the certificate
-- presented by the client, if this was requested via the server\'s
-- t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection':@/authentication_mode/@. On the server side,
-- the signal is always emitted when the client presents a
-- certificate, and the certificate will only be accepted if a
-- handler returns 'P.True'.
-- 
-- Note that if this signal is emitted as part of asynchronous I\/O
-- in the main thread, then you should not attempt to interact with
-- the user before returning from the signal handler. If you want to
-- let the user decide whether or not to accept the certificate, you
-- would have to return 'P.False' from the signal handler on the first
-- attempt, and then after the connection attempt returns a
-- 'GI.Gio.Enums.TlsErrorBadCertificate', you can interact with the user, and
-- if the user decides to accept the certificate, remember that fact,
-- create a new connection, and return 'P.True' from the signal handler
-- the next time.
-- 
-- If you are doing I\/O in another thread, you do not
-- need to worry about this, and can simply block in the signal
-- handler until the UI thread returns an answer.
-- 
-- /Since: 2.28/
type TlsConnectionAcceptCertificateCallback =
    Gio.TlsCertificate.TlsCertificate
    -- ^ /@peerCert@/: the peer\'s t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> [Gio.Flags.TlsCertificateFlags]
    -- ^ /@errors@/: the problems with /@peerCert@/.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to accept /@peerCert@/ (which will also
    -- immediately end the signal emission). 'P.False' to allow the signal
    -- emission to continue, which will cause the handshake to fail if
    -- no one else overrides it.

type C_TlsConnectionAcceptCertificateCallback =
    Ptr TlsConnection ->                    -- object
    Ptr Gio.TlsCertificate.TlsCertificate ->
    CUInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_TlsConnectionAcceptCertificateCallback`.
foreign import ccall "wrapper"
    mk_TlsConnectionAcceptCertificateCallback :: C_TlsConnectionAcceptCertificateCallback -> IO (FunPtr C_TlsConnectionAcceptCertificateCallback)

wrap_TlsConnectionAcceptCertificateCallback :: 
    GObject a => (a -> TlsConnectionAcceptCertificateCallback) ->
    C_TlsConnectionAcceptCertificateCallback
wrap_TlsConnectionAcceptCertificateCallback gi'cb gi'selfPtr peerCert errors _ = do
    peerCert' <- (newObject Gio.TlsCertificate.TlsCertificate) peerCert
    let errors' = wordToGFlags errors
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  peerCert' errors'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [acceptCertificate](#signal:acceptCertificate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' tlsConnection #acceptCertificate callback
-- @
-- 
-- 
onTlsConnectionAcceptCertificate :: (IsTlsConnection a, MonadIO m) => a -> ((?self :: a) => TlsConnectionAcceptCertificateCallback) -> m SignalHandlerId
onTlsConnectionAcceptCertificate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TlsConnectionAcceptCertificateCallback wrapped
    wrapped'' <- mk_TlsConnectionAcceptCertificateCallback wrapped'
    connectSignalFunPtr obj "accept-certificate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [acceptCertificate](#signal:acceptCertificate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' tlsConnection #acceptCertificate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTlsConnectionAcceptCertificate :: (IsTlsConnection a, MonadIO m) => a -> ((?self :: a) => TlsConnectionAcceptCertificateCallback) -> m SignalHandlerId
afterTlsConnectionAcceptCertificate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TlsConnectionAcceptCertificateCallback wrapped
    wrapped'' <- mk_TlsConnectionAcceptCertificateCallback wrapped'
    connectSignalFunPtr obj "accept-certificate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TlsConnectionAcceptCertificateSignalInfo
instance SignalInfo TlsConnectionAcceptCertificateSignalInfo where
    type HaskellCallbackType TlsConnectionAcceptCertificateSignalInfo = TlsConnectionAcceptCertificateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TlsConnectionAcceptCertificateCallback cb
        cb'' <- mk_TlsConnectionAcceptCertificateCallback cb'
        connectSignalFunPtr obj "accept-certificate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection::accept-certificate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:signal:acceptCertificate"})

#endif

-- VVV Prop "advertised-protocols"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@advertised-protocols@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #advertisedProtocols
-- @
getTlsConnectionAdvertisedProtocols :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe [T.Text])
getTlsConnectionAdvertisedProtocols obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "advertised-protocols"

-- | Set the value of the “@advertised-protocols@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsConnection [ #advertisedProtocols 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsConnectionAdvertisedProtocols :: (MonadIO m, IsTlsConnection o) => o -> [T.Text] -> m ()
setTlsConnectionAdvertisedProtocols obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "advertised-protocols" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@advertised-protocols@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionAdvertisedProtocols :: (IsTlsConnection o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructTlsConnectionAdvertisedProtocols val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "advertised-protocols" (P.Just val)

-- | Set the value of the “@advertised-protocols@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #advertisedProtocols
-- @
clearTlsConnectionAdvertisedProtocols :: (MonadIO m, IsTlsConnection o) => o -> m ()
clearTlsConnectionAdvertisedProtocols obj = liftIO $ B.Properties.setObjectPropertyStringArray obj "advertised-protocols" (Nothing :: Maybe [T.Text])

#if defined(ENABLE_OVERLOADING)
data TlsConnectionAdvertisedProtocolsPropertyInfo
instance AttrInfo TlsConnectionAdvertisedProtocolsPropertyInfo where
    type AttrAllowedOps TlsConnectionAdvertisedProtocolsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsConnectionAdvertisedProtocolsPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionAdvertisedProtocolsPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint TlsConnectionAdvertisedProtocolsPropertyInfo = (~) [T.Text]
    type AttrTransferType TlsConnectionAdvertisedProtocolsPropertyInfo = [T.Text]
    type AttrGetType TlsConnectionAdvertisedProtocolsPropertyInfo = (Maybe [T.Text])
    type AttrLabel TlsConnectionAdvertisedProtocolsPropertyInfo = "advertised-protocols"
    type AttrOrigin TlsConnectionAdvertisedProtocolsPropertyInfo = TlsConnection
    attrGet = getTlsConnectionAdvertisedProtocols
    attrSet = setTlsConnectionAdvertisedProtocols
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsConnectionAdvertisedProtocols
    attrClear = clearTlsConnectionAdvertisedProtocols
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.advertisedProtocols"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:advertisedProtocols"
        })
#endif

-- VVV Prop "base-io-stream"
   -- Type: TInterface (Name {namespace = "Gio", name = "IOStream"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@base-io-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #baseIoStream
-- @
getTlsConnectionBaseIoStream :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe Gio.IOStream.IOStream)
getTlsConnectionBaseIoStream obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "base-io-stream" Gio.IOStream.IOStream

-- | Construct a t'GValueConstruct' with valid value for the “@base-io-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionBaseIoStream :: (IsTlsConnection o, MIO.MonadIO m, Gio.IOStream.IsIOStream a) => a -> m (GValueConstruct o)
constructTlsConnectionBaseIoStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "base-io-stream" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsConnectionBaseIoStreamPropertyInfo
instance AttrInfo TlsConnectionBaseIoStreamPropertyInfo where
    type AttrAllowedOps TlsConnectionBaseIoStreamPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsConnectionBaseIoStreamPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionBaseIoStreamPropertyInfo = Gio.IOStream.IsIOStream
    type AttrTransferTypeConstraint TlsConnectionBaseIoStreamPropertyInfo = Gio.IOStream.IsIOStream
    type AttrTransferType TlsConnectionBaseIoStreamPropertyInfo = Gio.IOStream.IOStream
    type AttrGetType TlsConnectionBaseIoStreamPropertyInfo = (Maybe Gio.IOStream.IOStream)
    type AttrLabel TlsConnectionBaseIoStreamPropertyInfo = "base-io-stream"
    type AttrOrigin TlsConnectionBaseIoStreamPropertyInfo = TlsConnection
    attrGet = getTlsConnectionBaseIoStream
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.IOStream.IOStream v
    attrConstruct = constructTlsConnectionBaseIoStream
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.baseIoStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:baseIoStream"
        })
#endif

-- VVV Prop "certificate"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@certificate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #certificate
-- @
getTlsConnectionCertificate :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe Gio.TlsCertificate.TlsCertificate)
getTlsConnectionCertificate obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "certificate" Gio.TlsCertificate.TlsCertificate

-- | Set the value of the “@certificate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsConnection [ #certificate 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsConnectionCertificate :: (MonadIO m, IsTlsConnection o, Gio.TlsCertificate.IsTlsCertificate a) => o -> a -> m ()
setTlsConnectionCertificate obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "certificate" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@certificate@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionCertificate :: (IsTlsConnection o, MIO.MonadIO m, Gio.TlsCertificate.IsTlsCertificate a) => a -> m (GValueConstruct o)
constructTlsConnectionCertificate val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "certificate" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsConnectionCertificatePropertyInfo
instance AttrInfo TlsConnectionCertificatePropertyInfo where
    type AttrAllowedOps TlsConnectionCertificatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsConnectionCertificatePropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionCertificatePropertyInfo = Gio.TlsCertificate.IsTlsCertificate
    type AttrTransferTypeConstraint TlsConnectionCertificatePropertyInfo = Gio.TlsCertificate.IsTlsCertificate
    type AttrTransferType TlsConnectionCertificatePropertyInfo = Gio.TlsCertificate.TlsCertificate
    type AttrGetType TlsConnectionCertificatePropertyInfo = (Maybe Gio.TlsCertificate.TlsCertificate)
    type AttrLabel TlsConnectionCertificatePropertyInfo = "certificate"
    type AttrOrigin TlsConnectionCertificatePropertyInfo = TlsConnection
    attrGet = getTlsConnectionCertificate
    attrSet = setTlsConnectionCertificate
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.TlsCertificate.TlsCertificate v
    attrConstruct = constructTlsConnectionCertificate
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.certificate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:certificate"
        })
#endif

-- VVV Prop "ciphersuite-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@ciphersuite-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #ciphersuiteName
-- @
getTlsConnectionCiphersuiteName :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe T.Text)
getTlsConnectionCiphersuiteName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "ciphersuite-name"

#if defined(ENABLE_OVERLOADING)
data TlsConnectionCiphersuiteNamePropertyInfo
instance AttrInfo TlsConnectionCiphersuiteNamePropertyInfo where
    type AttrAllowedOps TlsConnectionCiphersuiteNamePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsConnectionCiphersuiteNamePropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionCiphersuiteNamePropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsConnectionCiphersuiteNamePropertyInfo = (~) ()
    type AttrTransferType TlsConnectionCiphersuiteNamePropertyInfo = ()
    type AttrGetType TlsConnectionCiphersuiteNamePropertyInfo = (Maybe T.Text)
    type AttrLabel TlsConnectionCiphersuiteNamePropertyInfo = "ciphersuite-name"
    type AttrOrigin TlsConnectionCiphersuiteNamePropertyInfo = TlsConnection
    attrGet = getTlsConnectionCiphersuiteName
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.ciphersuiteName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:ciphersuiteName"
        })
#endif

-- VVV Prop "database"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsDatabase"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@database@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #database
-- @
getTlsConnectionDatabase :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe Gio.TlsDatabase.TlsDatabase)
getTlsConnectionDatabase obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "database" Gio.TlsDatabase.TlsDatabase

-- | Set the value of the “@database@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsConnection [ #database 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsConnectionDatabase :: (MonadIO m, IsTlsConnection o, Gio.TlsDatabase.IsTlsDatabase a) => o -> a -> m ()
setTlsConnectionDatabase obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "database" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@database@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionDatabase :: (IsTlsConnection o, MIO.MonadIO m, Gio.TlsDatabase.IsTlsDatabase a) => a -> m (GValueConstruct o)
constructTlsConnectionDatabase val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "database" (P.Just val)

-- | Set the value of the “@database@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #database
-- @
clearTlsConnectionDatabase :: (MonadIO m, IsTlsConnection o) => o -> m ()
clearTlsConnectionDatabase obj = liftIO $ B.Properties.setObjectPropertyObject obj "database" (Nothing :: Maybe Gio.TlsDatabase.TlsDatabase)

#if defined(ENABLE_OVERLOADING)
data TlsConnectionDatabasePropertyInfo
instance AttrInfo TlsConnectionDatabasePropertyInfo where
    type AttrAllowedOps TlsConnectionDatabasePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsConnectionDatabasePropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionDatabasePropertyInfo = Gio.TlsDatabase.IsTlsDatabase
    type AttrTransferTypeConstraint TlsConnectionDatabasePropertyInfo = Gio.TlsDatabase.IsTlsDatabase
    type AttrTransferType TlsConnectionDatabasePropertyInfo = Gio.TlsDatabase.TlsDatabase
    type AttrGetType TlsConnectionDatabasePropertyInfo = (Maybe Gio.TlsDatabase.TlsDatabase)
    type AttrLabel TlsConnectionDatabasePropertyInfo = "database"
    type AttrOrigin TlsConnectionDatabasePropertyInfo = TlsConnection
    attrGet = getTlsConnectionDatabase
    attrSet = setTlsConnectionDatabase
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.TlsDatabase.TlsDatabase v
    attrConstruct = constructTlsConnectionDatabase
    attrClear = clearTlsConnectionDatabase
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.database"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:database"
        })
#endif

-- VVV Prop "interaction"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsInteraction"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@interaction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #interaction
-- @
getTlsConnectionInteraction :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe Gio.TlsInteraction.TlsInteraction)
getTlsConnectionInteraction obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "interaction" Gio.TlsInteraction.TlsInteraction

-- | Set the value of the “@interaction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsConnection [ #interaction 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsConnectionInteraction :: (MonadIO m, IsTlsConnection o, Gio.TlsInteraction.IsTlsInteraction a) => o -> a -> m ()
setTlsConnectionInteraction obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "interaction" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@interaction@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionInteraction :: (IsTlsConnection o, MIO.MonadIO m, Gio.TlsInteraction.IsTlsInteraction a) => a -> m (GValueConstruct o)
constructTlsConnectionInteraction val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "interaction" (P.Just val)

-- | Set the value of the “@interaction@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #interaction
-- @
clearTlsConnectionInteraction :: (MonadIO m, IsTlsConnection o) => o -> m ()
clearTlsConnectionInteraction obj = liftIO $ B.Properties.setObjectPropertyObject obj "interaction" (Nothing :: Maybe Gio.TlsInteraction.TlsInteraction)

#if defined(ENABLE_OVERLOADING)
data TlsConnectionInteractionPropertyInfo
instance AttrInfo TlsConnectionInteractionPropertyInfo where
    type AttrAllowedOps TlsConnectionInteractionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsConnectionInteractionPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionInteractionPropertyInfo = Gio.TlsInteraction.IsTlsInteraction
    type AttrTransferTypeConstraint TlsConnectionInteractionPropertyInfo = Gio.TlsInteraction.IsTlsInteraction
    type AttrTransferType TlsConnectionInteractionPropertyInfo = Gio.TlsInteraction.TlsInteraction
    type AttrGetType TlsConnectionInteractionPropertyInfo = (Maybe Gio.TlsInteraction.TlsInteraction)
    type AttrLabel TlsConnectionInteractionPropertyInfo = "interaction"
    type AttrOrigin TlsConnectionInteractionPropertyInfo = TlsConnection
    attrGet = getTlsConnectionInteraction
    attrSet = setTlsConnectionInteraction
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.TlsInteraction.TlsInteraction v
    attrConstruct = constructTlsConnectionInteraction
    attrClear = clearTlsConnectionInteraction
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.interaction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:interaction"
        })
#endif

-- VVV Prop "negotiated-protocol"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@negotiated-protocol@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #negotiatedProtocol
-- @
getTlsConnectionNegotiatedProtocol :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe T.Text)
getTlsConnectionNegotiatedProtocol obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "negotiated-protocol"

#if defined(ENABLE_OVERLOADING)
data TlsConnectionNegotiatedProtocolPropertyInfo
instance AttrInfo TlsConnectionNegotiatedProtocolPropertyInfo where
    type AttrAllowedOps TlsConnectionNegotiatedProtocolPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsConnectionNegotiatedProtocolPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionNegotiatedProtocolPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsConnectionNegotiatedProtocolPropertyInfo = (~) ()
    type AttrTransferType TlsConnectionNegotiatedProtocolPropertyInfo = ()
    type AttrGetType TlsConnectionNegotiatedProtocolPropertyInfo = (Maybe T.Text)
    type AttrLabel TlsConnectionNegotiatedProtocolPropertyInfo = "negotiated-protocol"
    type AttrOrigin TlsConnectionNegotiatedProtocolPropertyInfo = TlsConnection
    attrGet = getTlsConnectionNegotiatedProtocol
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.negotiatedProtocol"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:negotiatedProtocol"
        })
#endif

-- VVV Prop "peer-certificate"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@peer-certificate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #peerCertificate
-- @
getTlsConnectionPeerCertificate :: (MonadIO m, IsTlsConnection o) => o -> m (Maybe Gio.TlsCertificate.TlsCertificate)
getTlsConnectionPeerCertificate obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "peer-certificate" Gio.TlsCertificate.TlsCertificate

#if defined(ENABLE_OVERLOADING)
data TlsConnectionPeerCertificatePropertyInfo
instance AttrInfo TlsConnectionPeerCertificatePropertyInfo where
    type AttrAllowedOps TlsConnectionPeerCertificatePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsConnectionPeerCertificatePropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionPeerCertificatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsConnectionPeerCertificatePropertyInfo = (~) ()
    type AttrTransferType TlsConnectionPeerCertificatePropertyInfo = ()
    type AttrGetType TlsConnectionPeerCertificatePropertyInfo = (Maybe Gio.TlsCertificate.TlsCertificate)
    type AttrLabel TlsConnectionPeerCertificatePropertyInfo = "peer-certificate"
    type AttrOrigin TlsConnectionPeerCertificatePropertyInfo = TlsConnection
    attrGet = getTlsConnectionPeerCertificate
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.peerCertificate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:peerCertificate"
        })
#endif

-- VVV Prop "peer-certificate-errors"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@peer-certificate-errors@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #peerCertificateErrors
-- @
getTlsConnectionPeerCertificateErrors :: (MonadIO m, IsTlsConnection o) => o -> m [Gio.Flags.TlsCertificateFlags]
getTlsConnectionPeerCertificateErrors obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "peer-certificate-errors"

#if defined(ENABLE_OVERLOADING)
data TlsConnectionPeerCertificateErrorsPropertyInfo
instance AttrInfo TlsConnectionPeerCertificateErrorsPropertyInfo where
    type AttrAllowedOps TlsConnectionPeerCertificateErrorsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TlsConnectionPeerCertificateErrorsPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionPeerCertificateErrorsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsConnectionPeerCertificateErrorsPropertyInfo = (~) ()
    type AttrTransferType TlsConnectionPeerCertificateErrorsPropertyInfo = ()
    type AttrGetType TlsConnectionPeerCertificateErrorsPropertyInfo = [Gio.Flags.TlsCertificateFlags]
    type AttrLabel TlsConnectionPeerCertificateErrorsPropertyInfo = "peer-certificate-errors"
    type AttrOrigin TlsConnectionPeerCertificateErrorsPropertyInfo = TlsConnection
    attrGet = getTlsConnectionPeerCertificateErrors
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.peerCertificateErrors"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:peerCertificateErrors"
        })
#endif

-- VVV Prop "protocol-version"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsProtocolVersion"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@protocol-version@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #protocolVersion
-- @
getTlsConnectionProtocolVersion :: (MonadIO m, IsTlsConnection o) => o -> m Gio.Enums.TlsProtocolVersion
getTlsConnectionProtocolVersion obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "protocol-version"

#if defined(ENABLE_OVERLOADING)
data TlsConnectionProtocolVersionPropertyInfo
instance AttrInfo TlsConnectionProtocolVersionPropertyInfo where
    type AttrAllowedOps TlsConnectionProtocolVersionPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TlsConnectionProtocolVersionPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionProtocolVersionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsConnectionProtocolVersionPropertyInfo = (~) ()
    type AttrTransferType TlsConnectionProtocolVersionPropertyInfo = ()
    type AttrGetType TlsConnectionProtocolVersionPropertyInfo = Gio.Enums.TlsProtocolVersion
    type AttrLabel TlsConnectionProtocolVersionPropertyInfo = "protocol-version"
    type AttrOrigin TlsConnectionProtocolVersionPropertyInfo = TlsConnection
    attrGet = getTlsConnectionProtocolVersion
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.protocolVersion"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:protocolVersion"
        })
#endif

-- VVV Prop "rehandshake-mode"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsRehandshakeMode"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@rehandshake-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #rehandshakeMode
-- @
getTlsConnectionRehandshakeMode :: (MonadIO m, IsTlsConnection o) => o -> m Gio.Enums.TlsRehandshakeMode
getTlsConnectionRehandshakeMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "rehandshake-mode"

-- | Set the value of the “@rehandshake-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsConnection [ #rehandshakeMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsConnectionRehandshakeMode :: (MonadIO m, IsTlsConnection o) => o -> Gio.Enums.TlsRehandshakeMode -> m ()
setTlsConnectionRehandshakeMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "rehandshake-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@rehandshake-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionRehandshakeMode :: (IsTlsConnection o, MIO.MonadIO m) => Gio.Enums.TlsRehandshakeMode -> m (GValueConstruct o)
constructTlsConnectionRehandshakeMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "rehandshake-mode" val

#if defined(ENABLE_OVERLOADING)
data TlsConnectionRehandshakeModePropertyInfo
instance AttrInfo TlsConnectionRehandshakeModePropertyInfo where
    type AttrAllowedOps TlsConnectionRehandshakeModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint TlsConnectionRehandshakeModePropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionRehandshakeModePropertyInfo = (~) Gio.Enums.TlsRehandshakeMode
    type AttrTransferTypeConstraint TlsConnectionRehandshakeModePropertyInfo = (~) Gio.Enums.TlsRehandshakeMode
    type AttrTransferType TlsConnectionRehandshakeModePropertyInfo = Gio.Enums.TlsRehandshakeMode
    type AttrGetType TlsConnectionRehandshakeModePropertyInfo = Gio.Enums.TlsRehandshakeMode
    type AttrLabel TlsConnectionRehandshakeModePropertyInfo = "rehandshake-mode"
    type AttrOrigin TlsConnectionRehandshakeModePropertyInfo = TlsConnection
    attrGet = getTlsConnectionRehandshakeMode
    attrSet = setTlsConnectionRehandshakeMode
    attrPut = setTlsConnectionRehandshakeMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsConnectionRehandshakeMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.rehandshakeMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:rehandshakeMode"
        })
#endif

-- VVV Prop "require-close-notify"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@require-close-notify@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #requireCloseNotify
-- @
getTlsConnectionRequireCloseNotify :: (MonadIO m, IsTlsConnection o) => o -> m Bool
getTlsConnectionRequireCloseNotify obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "require-close-notify"

-- | Set the value of the “@require-close-notify@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsConnection [ #requireCloseNotify 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsConnectionRequireCloseNotify :: (MonadIO m, IsTlsConnection o) => o -> Bool -> m ()
setTlsConnectionRequireCloseNotify obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "require-close-notify" val

-- | Construct a t'GValueConstruct' with valid value for the “@require-close-notify@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionRequireCloseNotify :: (IsTlsConnection o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTlsConnectionRequireCloseNotify val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "require-close-notify" val

#if defined(ENABLE_OVERLOADING)
data TlsConnectionRequireCloseNotifyPropertyInfo
instance AttrInfo TlsConnectionRequireCloseNotifyPropertyInfo where
    type AttrAllowedOps TlsConnectionRequireCloseNotifyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint TlsConnectionRequireCloseNotifyPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionRequireCloseNotifyPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TlsConnectionRequireCloseNotifyPropertyInfo = (~) Bool
    type AttrTransferType TlsConnectionRequireCloseNotifyPropertyInfo = Bool
    type AttrGetType TlsConnectionRequireCloseNotifyPropertyInfo = Bool
    type AttrLabel TlsConnectionRequireCloseNotifyPropertyInfo = "require-close-notify"
    type AttrOrigin TlsConnectionRequireCloseNotifyPropertyInfo = TlsConnection
    attrGet = getTlsConnectionRequireCloseNotify
    attrSet = setTlsConnectionRequireCloseNotify
    attrPut = setTlsConnectionRequireCloseNotify
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsConnectionRequireCloseNotify
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.requireCloseNotify"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:requireCloseNotify"
        })
#endif

-- VVV Prop "use-system-certdb"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-system-certdb@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsConnection #useSystemCertdb
-- @
getTlsConnectionUseSystemCertdb :: (MonadIO m, IsTlsConnection o) => o -> m Bool
getTlsConnectionUseSystemCertdb obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-system-certdb"

-- | Set the value of the “@use-system-certdb@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsConnection [ #useSystemCertdb 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsConnectionUseSystemCertdb :: (MonadIO m, IsTlsConnection o) => o -> Bool -> m ()
setTlsConnectionUseSystemCertdb obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-system-certdb" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-system-certdb@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsConnectionUseSystemCertdb :: (IsTlsConnection o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTlsConnectionUseSystemCertdb val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-system-certdb" val

#if defined(ENABLE_OVERLOADING)
data TlsConnectionUseSystemCertdbPropertyInfo
instance AttrInfo TlsConnectionUseSystemCertdbPropertyInfo where
    type AttrAllowedOps TlsConnectionUseSystemCertdbPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint TlsConnectionUseSystemCertdbPropertyInfo = IsTlsConnection
    type AttrSetTypeConstraint TlsConnectionUseSystemCertdbPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TlsConnectionUseSystemCertdbPropertyInfo = (~) Bool
    type AttrTransferType TlsConnectionUseSystemCertdbPropertyInfo = Bool
    type AttrGetType TlsConnectionUseSystemCertdbPropertyInfo = Bool
    type AttrLabel TlsConnectionUseSystemCertdbPropertyInfo = "use-system-certdb"
    type AttrOrigin TlsConnectionUseSystemCertdbPropertyInfo = TlsConnection
    attrGet = getTlsConnectionUseSystemCertdb
    attrSet = setTlsConnectionUseSystemCertdb
    attrPut = setTlsConnectionUseSystemCertdb
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsConnectionUseSystemCertdb
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.useSystemCertdb"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#g:attr:useSystemCertdb"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TlsConnection
type instance O.AttributeList TlsConnection = TlsConnectionAttributeList
type TlsConnectionAttributeList = ('[ '("advertisedProtocols", TlsConnectionAdvertisedProtocolsPropertyInfo), '("baseIoStream", TlsConnectionBaseIoStreamPropertyInfo), '("certificate", TlsConnectionCertificatePropertyInfo), '("ciphersuiteName", TlsConnectionCiphersuiteNamePropertyInfo), '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("database", TlsConnectionDatabasePropertyInfo), '("inputStream", Gio.IOStream.IOStreamInputStreamPropertyInfo), '("interaction", TlsConnectionInteractionPropertyInfo), '("negotiatedProtocol", TlsConnectionNegotiatedProtocolPropertyInfo), '("outputStream", Gio.IOStream.IOStreamOutputStreamPropertyInfo), '("peerCertificate", TlsConnectionPeerCertificatePropertyInfo), '("peerCertificateErrors", TlsConnectionPeerCertificateErrorsPropertyInfo), '("protocolVersion", TlsConnectionProtocolVersionPropertyInfo), '("rehandshakeMode", TlsConnectionRehandshakeModePropertyInfo), '("requireCloseNotify", TlsConnectionRequireCloseNotifyPropertyInfo), '("useSystemCertdb", TlsConnectionUseSystemCertdbPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tlsConnectionAdvertisedProtocols :: AttrLabelProxy "advertisedProtocols"
tlsConnectionAdvertisedProtocols = AttrLabelProxy

tlsConnectionBaseIoStream :: AttrLabelProxy "baseIoStream"
tlsConnectionBaseIoStream = AttrLabelProxy

tlsConnectionCertificate :: AttrLabelProxy "certificate"
tlsConnectionCertificate = AttrLabelProxy

tlsConnectionCiphersuiteName :: AttrLabelProxy "ciphersuiteName"
tlsConnectionCiphersuiteName = AttrLabelProxy

tlsConnectionDatabase :: AttrLabelProxy "database"
tlsConnectionDatabase = AttrLabelProxy

tlsConnectionInteraction :: AttrLabelProxy "interaction"
tlsConnectionInteraction = AttrLabelProxy

tlsConnectionNegotiatedProtocol :: AttrLabelProxy "negotiatedProtocol"
tlsConnectionNegotiatedProtocol = AttrLabelProxy

tlsConnectionPeerCertificate :: AttrLabelProxy "peerCertificate"
tlsConnectionPeerCertificate = AttrLabelProxy

tlsConnectionPeerCertificateErrors :: AttrLabelProxy "peerCertificateErrors"
tlsConnectionPeerCertificateErrors = AttrLabelProxy

tlsConnectionProtocolVersion :: AttrLabelProxy "protocolVersion"
tlsConnectionProtocolVersion = AttrLabelProxy

tlsConnectionRehandshakeMode :: AttrLabelProxy "rehandshakeMode"
tlsConnectionRehandshakeMode = AttrLabelProxy

tlsConnectionRequireCloseNotify :: AttrLabelProxy "requireCloseNotify"
tlsConnectionRequireCloseNotify = AttrLabelProxy

tlsConnectionUseSystemCertdb :: AttrLabelProxy "useSystemCertdb"
tlsConnectionUseSystemCertdb = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TlsConnection = TlsConnectionSignalList
type TlsConnectionSignalList = ('[ '("acceptCertificate", TlsConnectionAcceptCertificateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TlsConnection::emit_accept_certificate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "peer_cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the peer's #GTlsCertificate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "errors"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsCertificateFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the problems with @peer_cert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_emit_accept_certificate" g_tls_connection_emit_accept_certificate :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Ptr Gio.TlsCertificate.TlsCertificate -> -- peer_cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    CUInt ->                                -- errors : TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
    IO CInt

-- | Used by t'GI.Gio.Objects.TlsConnection.TlsConnection' implementations to emit the
-- [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate") signal.
-- 
-- /Since: 2.28/
tlsConnectionEmitAcceptCertificate ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a, Gio.TlsCertificate.IsTlsCertificate b) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> b
    -- ^ /@peerCert@/: the peer\'s t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> [Gio.Flags.TlsCertificateFlags]
    -- ^ /@errors@/: the problems with /@peerCert@/
    -> m Bool
    -- ^ __Returns:__ 'P.True' if one of the signal handlers has returned
    --     'P.True' to accept /@peerCert@/
tlsConnectionEmitAcceptCertificate conn peerCert errors = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    peerCert' <- unsafeManagedPtrCastPtr peerCert
    let errors' = gflagsToWord errors
    result <- g_tls_connection_emit_accept_certificate conn' peerCert' errors'
    let result' = (/= 0) result
    touchManagedPtr conn
    touchManagedPtr peerCert
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsConnectionEmitAcceptCertificateMethodInfo
instance (signature ~ (b -> [Gio.Flags.TlsCertificateFlags] -> m Bool), MonadIO m, IsTlsConnection a, Gio.TlsCertificate.IsTlsCertificate b) => O.OverloadedMethod TlsConnectionEmitAcceptCertificateMethodInfo a signature where
    overloadedMethod = tlsConnectionEmitAcceptCertificate

instance O.OverloadedMethodInfo TlsConnectionEmitAcceptCertificateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionEmitAcceptCertificate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionEmitAcceptCertificate"
        })


#endif

-- method TlsConnection::get_certificate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_certificate" g_tls_connection_get_certificate :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO (Ptr Gio.TlsCertificate.TlsCertificate)

-- | Gets /@conn@/\'s certificate, as set by
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetCertificate'.
-- 
-- /Since: 2.28/
tlsConnectionGetCertificate ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m (Maybe Gio.TlsCertificate.TlsCertificate)
    -- ^ __Returns:__ /@conn@/\'s certificate, or 'P.Nothing'
tlsConnectionGetCertificate conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_certificate conn'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.TlsCertificate.TlsCertificate) result'
        return result''
    touchManagedPtr conn
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetCertificateMethodInfo
instance (signature ~ (m (Maybe Gio.TlsCertificate.TlsCertificate)), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetCertificateMethodInfo a signature where
    overloadedMethod = tlsConnectionGetCertificate

instance O.OverloadedMethodInfo TlsConnectionGetCertificateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetCertificate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetCertificate"
        })


#endif

-- XXX Could not generate method TlsConnection::get_channel_binding_data
-- Not implemented: Don't know how to allocate "data" of type TByteArray
#if defined(ENABLE_OVERLOADING)
-- XXX: Dummy instance, since code generation failed.
-- Please file a bug at http://github.com/haskell-gi/haskell-gi.
data TlsConnectionGetChannelBindingDataMethodInfo
instance (p ~ (), o ~ O.UnsupportedMethodError "getChannelBindingData" TlsConnection) => O.OverloadedMethod TlsConnectionGetChannelBindingDataMethodInfo o p where
    overloadedMethod = undefined

instance (o ~ O.UnsupportedMethodError "getChannelBindingData" TlsConnection) => O.OverloadedMethodInfo TlsConnectionGetChannelBindingDataMethodInfo o where
    overloadedMethodInfo = undefined

#endif

-- method TlsConnection::get_ciphersuite_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_ciphersuite_name" g_tls_connection_get_ciphersuite_name :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO CString

-- | Returns the name of the current TLS ciphersuite, or 'P.Nothing' if the
-- connection has not handshaked or has been closed. Beware that the TLS
-- backend may use any of multiple different naming conventions, because
-- OpenSSL and GnuTLS have their own ciphersuite naming conventions that
-- are different from each other and different from the standard, IANA-
-- registered ciphersuite names. The ciphersuite name is intended to be
-- displayed to the user for informative purposes only, and parsing it
-- is not recommended.
-- 
-- /Since: 2.70/
tlsConnectionGetCiphersuiteName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The name of the current TLS ciphersuite, or 'P.Nothing'
tlsConnectionGetCiphersuiteName conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_ciphersuite_name conn'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr conn
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetCiphersuiteNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetCiphersuiteNameMethodInfo a signature where
    overloadedMethod = tlsConnectionGetCiphersuiteName

instance O.OverloadedMethodInfo TlsConnectionGetCiphersuiteNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetCiphersuiteName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetCiphersuiteName"
        })


#endif

-- method TlsConnection::get_database
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "TlsDatabase" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_database" g_tls_connection_get_database :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO (Ptr Gio.TlsDatabase.TlsDatabase)

-- | Gets the certificate database that /@conn@/ uses to verify
-- peer certificates. See 'GI.Gio.Objects.TlsConnection.tlsConnectionSetDatabase'.
-- 
-- /Since: 2.30/
tlsConnectionGetDatabase ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m (Maybe Gio.TlsDatabase.TlsDatabase)
    -- ^ __Returns:__ the certificate database that /@conn@/ uses or 'P.Nothing'
tlsConnectionGetDatabase conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_database conn'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.TlsDatabase.TlsDatabase) result'
        return result''
    touchManagedPtr conn
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetDatabaseMethodInfo
instance (signature ~ (m (Maybe Gio.TlsDatabase.TlsDatabase)), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetDatabaseMethodInfo a signature where
    overloadedMethod = tlsConnectionGetDatabase

instance O.OverloadedMethodInfo TlsConnectionGetDatabaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetDatabase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetDatabase"
        })


#endif

-- method TlsConnection::get_interaction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a connection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsInteraction" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_interaction" g_tls_connection_get_interaction :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO (Ptr Gio.TlsInteraction.TlsInteraction)

-- | Get the object that will be used to interact with the user. It will be used
-- for things like prompting the user for passwords. If 'P.Nothing' is returned, then
-- no user interaction will occur for this connection.
-- 
-- /Since: 2.30/
tlsConnectionGetInteraction ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a connection
    -> m (Maybe Gio.TlsInteraction.TlsInteraction)
    -- ^ __Returns:__ The interaction object.
tlsConnectionGetInteraction conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_interaction conn'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.TlsInteraction.TlsInteraction) result'
        return result''
    touchManagedPtr conn
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetInteractionMethodInfo
instance (signature ~ (m (Maybe Gio.TlsInteraction.TlsInteraction)), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetInteractionMethodInfo a signature where
    overloadedMethod = tlsConnectionGetInteraction

instance O.OverloadedMethodInfo TlsConnectionGetInteractionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetInteraction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetInteraction"
        })


#endif

-- method TlsConnection::get_negotiated_protocol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_negotiated_protocol" g_tls_connection_get_negotiated_protocol :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO CString

-- | Gets the name of the application-layer protocol negotiated during
-- the handshake.
-- 
-- If the peer did not use the ALPN extension, or did not advertise a
-- protocol that matched one of /@conn@/\'s protocols, or the TLS backend
-- does not support ALPN, then this will be 'P.Nothing'. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetAdvertisedProtocols'.
-- 
-- /Since: 2.60/
tlsConnectionGetNegotiatedProtocol ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the negotiated protocol, or 'P.Nothing'
tlsConnectionGetNegotiatedProtocol conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_negotiated_protocol conn'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr conn
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetNegotiatedProtocolMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetNegotiatedProtocolMethodInfo a signature where
    overloadedMethod = tlsConnectionGetNegotiatedProtocol

instance O.OverloadedMethodInfo TlsConnectionGetNegotiatedProtocolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetNegotiatedProtocol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetNegotiatedProtocol"
        })


#endif

-- method TlsConnection::get_peer_certificate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_peer_certificate" g_tls_connection_get_peer_certificate :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO (Ptr Gio.TlsCertificate.TlsCertificate)

-- | Gets /@conn@/\'s peer\'s certificate after the handshake has completed
-- or failed. (It is not set during the emission of
-- [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate").)
-- 
-- /Since: 2.28/
tlsConnectionGetPeerCertificate ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m (Maybe Gio.TlsCertificate.TlsCertificate)
    -- ^ __Returns:__ /@conn@/\'s peer\'s certificate, or 'P.Nothing'
tlsConnectionGetPeerCertificate conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_peer_certificate conn'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.TlsCertificate.TlsCertificate) result'
        return result''
    touchManagedPtr conn
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetPeerCertificateMethodInfo
instance (signature ~ (m (Maybe Gio.TlsCertificate.TlsCertificate)), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetPeerCertificateMethodInfo a signature where
    overloadedMethod = tlsConnectionGetPeerCertificate

instance O.OverloadedMethodInfo TlsConnectionGetPeerCertificateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetPeerCertificate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetPeerCertificate"
        })


#endif

-- method TlsConnection::get_peer_certificate_errors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsCertificateFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_peer_certificate_errors" g_tls_connection_get_peer_certificate_errors :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO CUInt

-- | Gets the errors associated with validating /@conn@/\'s peer\'s
-- certificate, after the handshake has completed or failed. (It is
-- not set during the emission of [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate").)
-- 
-- See [TlsConnection:peerCertificateErrors]("GI.Gio.Objects.TlsConnection#g:attr:peerCertificateErrors") for more information.
-- 
-- /Since: 2.28/
tlsConnectionGetPeerCertificateErrors ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m [Gio.Flags.TlsCertificateFlags]
    -- ^ __Returns:__ /@conn@/\'s peer\'s certificate errors
tlsConnectionGetPeerCertificateErrors conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_peer_certificate_errors conn'
    let result' = wordToGFlags result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetPeerCertificateErrorsMethodInfo
instance (signature ~ (m [Gio.Flags.TlsCertificateFlags]), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetPeerCertificateErrorsMethodInfo a signature where
    overloadedMethod = tlsConnectionGetPeerCertificateErrors

instance O.OverloadedMethodInfo TlsConnectionGetPeerCertificateErrorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetPeerCertificateErrors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetPeerCertificateErrors"
        })


#endif

-- method TlsConnection::get_protocol_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsProtocolVersion" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_protocol_version" g_tls_connection_get_protocol_version :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO CUInt

-- | Returns the current TLS protocol version, which may be
-- 'GI.Gio.Enums.TlsProtocolVersionUnknown' if the connection has not handshaked, or
-- has been closed, or if the TLS backend has implemented a protocol version
-- that is not a recognized t'GI.Gio.Enums.TlsProtocolVersion'.
-- 
-- /Since: 2.70/
tlsConnectionGetProtocolVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m Gio.Enums.TlsProtocolVersion
    -- ^ __Returns:__ The current TLS protocol version
tlsConnectionGetProtocolVersion conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_protocol_version conn'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetProtocolVersionMethodInfo
instance (signature ~ (m Gio.Enums.TlsProtocolVersion), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetProtocolVersionMethodInfo a signature where
    overloadedMethod = tlsConnectionGetProtocolVersion

instance O.OverloadedMethodInfo TlsConnectionGetProtocolVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetProtocolVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetProtocolVersion"
        })


#endif

-- method TlsConnection::get_rehandshake_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsRehandshakeMode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_rehandshake_mode" g_tls_connection_get_rehandshake_mode :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO CUInt

{-# DEPRECATED tlsConnectionGetRehandshakeMode ["(Since version 2.60.)","Changing the rehandshake mode is no longer","  required for compatibility. Also, rehandshaking has been removed","  from the TLS protocol in TLS 1.3."] #-}
-- | Gets /@conn@/ rehandshaking mode. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetRehandshakeMode' for details.
-- 
-- /Since: 2.28/
tlsConnectionGetRehandshakeMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m Gio.Enums.TlsRehandshakeMode
    -- ^ __Returns:__ 'GI.Gio.Enums.TlsRehandshakeModeSafely'
tlsConnectionGetRehandshakeMode conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_rehandshake_mode conn'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetRehandshakeModeMethodInfo
instance (signature ~ (m Gio.Enums.TlsRehandshakeMode), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetRehandshakeModeMethodInfo a signature where
    overloadedMethod = tlsConnectionGetRehandshakeMode

instance O.OverloadedMethodInfo TlsConnectionGetRehandshakeModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetRehandshakeMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetRehandshakeMode"
        })


#endif

-- method TlsConnection::get_require_close_notify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_require_close_notify" g_tls_connection_get_require_close_notify :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO CInt

-- | Tests whether or not /@conn@/ expects a proper TLS close notification
-- when the connection is closed. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionSetRequireCloseNotify' for details.
-- 
-- /Since: 2.28/
tlsConnectionGetRequireCloseNotify ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@conn@/ requires a proper TLS close
    -- notification.
tlsConnectionGetRequireCloseNotify conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_require_close_notify conn'
    let result' = (/= 0) result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetRequireCloseNotifyMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetRequireCloseNotifyMethodInfo a signature where
    overloadedMethod = tlsConnectionGetRequireCloseNotify

instance O.OverloadedMethodInfo TlsConnectionGetRequireCloseNotifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetRequireCloseNotify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetRequireCloseNotify"
        })


#endif

-- method TlsConnection::get_use_system_certdb
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_get_use_system_certdb" g_tls_connection_get_use_system_certdb :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    IO CInt

{-# DEPRECATED tlsConnectionGetUseSystemCertdb ["(Since version 2.30)","Use 'GI.Gio.Objects.TlsConnection.tlsConnectionGetDatabase' instead"] #-}
-- | Gets whether /@conn@/ uses the system certificate database to verify
-- peer certificates. See 'GI.Gio.Objects.TlsConnection.tlsConnectionSetUseSystemCertdb'.
tlsConnectionGetUseSystemCertdb ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> m Bool
    -- ^ __Returns:__ whether /@conn@/ uses the system certificate database
tlsConnectionGetUseSystemCertdb conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_connection_get_use_system_certdb conn'
    let result' = (/= 0) result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsConnectionGetUseSystemCertdbMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionGetUseSystemCertdbMethodInfo a signature where
    overloadedMethod = tlsConnectionGetUseSystemCertdb

instance O.OverloadedMethodInfo TlsConnectionGetUseSystemCertdbMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionGetUseSystemCertdb",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionGetUseSystemCertdb"
        })


#endif

-- method TlsConnection::handshake
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_connection_handshake" g_tls_connection_handshake :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Attempts a TLS handshake on /@conn@/.
-- 
-- On the client side, it is never necessary to call this method;
-- although the connection needs to perform a handshake after
-- connecting (or after sending a \"STARTTLS\"-type command),
-- t'GI.Gio.Objects.TlsConnection.TlsConnection' will handle this for you automatically when you try
-- to send or receive data on the connection. You can call
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionHandshake' manually if you want to know whether
-- the initial handshake succeeded or failed (as opposed to just
-- immediately trying to use /@conn@/ to read or write, in which case,
-- if it fails, it may not be possible to tell if it failed before or
-- after completing the handshake), but beware that servers may reject
-- client authentication after the handshake has completed, so a
-- successful handshake does not indicate the connection will be usable.
-- 
-- Likewise, on the server side, although a handshake is necessary at
-- the beginning of the communication, you do not need to call this
-- function explicitly unless you want clearer error reporting.
-- 
-- Previously, calling 'GI.Gio.Objects.TlsConnection.tlsConnectionHandshake' after the initial
-- handshake would trigger a rehandshake; however, this usage was
-- deprecated in GLib 2.60 because rehandshaking was removed from the
-- TLS protocol in TLS 1.3. Since GLib 2.64, calling this function after
-- the initial handshake will no longer do anything.
-- 
-- When using a t'GI.Gio.Objects.TlsConnection.TlsConnection' created by t'GI.Gio.Objects.SocketClient.SocketClient', the
-- t'GI.Gio.Objects.SocketClient.SocketClient' performs the initial handshake, so calling this
-- function manually is not recommended.
-- 
-- t'GI.Gio.Objects.TlsConnection.TlsConnection'::@/accept_certificate/@ may be emitted during the
-- handshake.
-- 
-- /Since: 2.28/
tlsConnectionHandshake ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
tlsConnectionHandshake conn cancellable = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_tls_connection_handshake conn' maybeCancellable
        touchManagedPtr conn
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data TlsConnectionHandshakeMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTlsConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod TlsConnectionHandshakeMethodInfo a signature where
    overloadedMethod = tlsConnectionHandshake

instance O.OverloadedMethodInfo TlsConnectionHandshakeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionHandshake",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionHandshake"
        })


#endif

-- method TlsConnection::handshake_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "callback to call when the handshake is complete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to the callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_handshake_async" g_tls_connection_handshake_async :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously performs a TLS handshake on /@conn@/. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionHandshake' for more information.
-- 
-- /Since: 2.28/
tlsConnectionHandshakeAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: callback to call when the handshake is complete
    -> m ()
tlsConnectionHandshakeAsync conn ioPriority cancellable callback = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_tls_connection_handshake_async conn' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr conn
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionHandshakeAsyncMethodInfo
instance (signature ~ (Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsTlsConnection a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod TlsConnectionHandshakeAsyncMethodInfo a signature where
    overloadedMethod = tlsConnectionHandshakeAsync

instance O.OverloadedMethodInfo TlsConnectionHandshakeAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionHandshakeAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionHandshakeAsync"
        })


#endif

-- method TlsConnection::handshake_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_connection_handshake_finish" g_tls_connection_handshake_finish :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finish an asynchronous TLS handshake operation. See
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionHandshake' for more information.
-- 
-- /Since: 2.28/
tlsConnectionHandshakeFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
tlsConnectionHandshakeFinish conn result_ = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_tls_connection_handshake_finish conn' result_'
        touchManagedPtr conn
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data TlsConnectionHandshakeFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTlsConnection a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod TlsConnectionHandshakeFinishMethodInfo a signature where
    overloadedMethod = tlsConnectionHandshakeFinish

instance O.OverloadedMethodInfo TlsConnectionHandshakeFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionHandshakeFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionHandshakeFinish"
        })


#endif

-- method TlsConnection::set_advertised_protocols
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "protocols"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a %NULL-terminated\n  array of ALPN protocol names (eg, \"http/1.1\", \"h2\"), or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_set_advertised_protocols" g_tls_connection_set_advertised_protocols :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Ptr CString ->                          -- protocols : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the list of application-layer protocols to advertise that the
-- caller is willing to speak on this connection. The
-- Application-Layer Protocol Negotiation (ALPN) extension will be
-- used to negotiate a compatible protocol with the peer; use
-- 'GI.Gio.Objects.TlsConnection.tlsConnectionGetNegotiatedProtocol' to find the negotiated
-- protocol after the handshake.  Specifying 'P.Nothing' for the the value
-- of /@protocols@/ will disable ALPN negotiation.
-- 
-- See <https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids IANA TLS ALPN Protocol IDs>
-- for a list of registered protocol IDs.
-- 
-- /Since: 2.60/
tlsConnectionSetAdvertisedProtocols ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> Maybe ([T.Text])
    -- ^ /@protocols@/: a 'P.Nothing'-terminated
    --   array of ALPN protocol names (eg, \"http\/1.1\", \"h2\"), or 'P.Nothing'
    -> m ()
tlsConnectionSetAdvertisedProtocols conn protocols = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    maybeProtocols <- case protocols of
        Nothing -> return FP.nullPtr
        Just jProtocols -> do
            jProtocols' <- packZeroTerminatedUTF8CArray jProtocols
            return jProtocols'
    g_tls_connection_set_advertised_protocols conn' maybeProtocols
    touchManagedPtr conn
    mapZeroTerminatedCArray freeMem maybeProtocols
    freeMem maybeProtocols
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionSetAdvertisedProtocolsMethodInfo
instance (signature ~ (Maybe ([T.Text]) -> m ()), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionSetAdvertisedProtocolsMethodInfo a signature where
    overloadedMethod = tlsConnectionSetAdvertisedProtocols

instance O.OverloadedMethodInfo TlsConnectionSetAdvertisedProtocolsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionSetAdvertisedProtocols",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionSetAdvertisedProtocols"
        })


#endif

-- method TlsConnection::set_certificate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "certificate"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the certificate to use for @conn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_set_certificate" g_tls_connection_set_certificate :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Ptr Gio.TlsCertificate.TlsCertificate -> -- certificate : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO ()

-- | This sets the certificate that /@conn@/ will present to its peer
-- during the TLS handshake. For a t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection', it is
-- mandatory to set this, and that will normally be done at construct
-- time.
-- 
-- For a t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection', this is optional. If a handshake fails
-- with 'GI.Gio.Enums.TlsErrorCertificateRequired', that means that the server
-- requires a certificate, and if you try connecting again, you should
-- call this method first. You can call
-- 'GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionGetAcceptedCas' on the failed connection
-- to get a list of Certificate Authorities that the server will
-- accept certificates from.
-- 
-- (It is also possible that a server will allow the connection with
-- or without a certificate; in that case, if you don\'t provide a
-- certificate, you can tell that the server requested one by the fact
-- that 'GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionGetAcceptedCas' will return
-- non-'P.Nothing'.)
-- 
-- /Since: 2.28/
tlsConnectionSetCertificate ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a, Gio.TlsCertificate.IsTlsCertificate b) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> b
    -- ^ /@certificate@/: the certificate to use for /@conn@/
    -> m ()
tlsConnectionSetCertificate conn certificate = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    certificate' <- unsafeManagedPtrCastPtr certificate
    g_tls_connection_set_certificate conn' certificate'
    touchManagedPtr conn
    touchManagedPtr certificate
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionSetCertificateMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTlsConnection a, Gio.TlsCertificate.IsTlsCertificate b) => O.OverloadedMethod TlsConnectionSetCertificateMethodInfo a signature where
    overloadedMethod = tlsConnectionSetCertificate

instance O.OverloadedMethodInfo TlsConnectionSetCertificateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionSetCertificate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionSetCertificate"
        })


#endif

-- method TlsConnection::set_database
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "database"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsDatabase" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsDatabase" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_set_database" g_tls_connection_set_database :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Ptr Gio.TlsDatabase.TlsDatabase ->      -- database : TInterface (Name {namespace = "Gio", name = "TlsDatabase"})
    IO ()

-- | Sets the certificate database that is used to verify peer certificates.
-- This is set to the default database by default. See
-- 'GI.Gio.Interfaces.TlsBackend.tlsBackendGetDefaultDatabase'. If set to 'P.Nothing', then
-- peer certificate validation will always set the
-- 'GI.Gio.Flags.TlsCertificateFlagsUnknownCa' error (meaning
-- [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate") will always be emitted on
-- client-side connections, unless that bit is not set in
-- [TlsClientConnection:validationFlags]("GI.Gio.Interfaces.TlsClientConnection#g:attr:validationFlags")).
-- 
-- There are nonintuitive security implications when using a non-default
-- database. See [TlsConnection:database]("GI.Gio.Objects.TlsConnection#g:attr:database") for details.
-- 
-- /Since: 2.30/
tlsConnectionSetDatabase ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a, Gio.TlsDatabase.IsTlsDatabase b) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> Maybe (b)
    -- ^ /@database@/: a t'GI.Gio.Objects.TlsDatabase.TlsDatabase'
    -> m ()
tlsConnectionSetDatabase conn database = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    maybeDatabase <- case database of
        Nothing -> return FP.nullPtr
        Just jDatabase -> do
            jDatabase' <- unsafeManagedPtrCastPtr jDatabase
            return jDatabase'
    g_tls_connection_set_database conn' maybeDatabase
    touchManagedPtr conn
    whenJust database touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionSetDatabaseMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTlsConnection a, Gio.TlsDatabase.IsTlsDatabase b) => O.OverloadedMethod TlsConnectionSetDatabaseMethodInfo a signature where
    overloadedMethod = tlsConnectionSetDatabase

instance O.OverloadedMethodInfo TlsConnectionSetDatabaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionSetDatabase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionSetDatabase"
        })


#endif

-- method TlsConnection::set_interaction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a connection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interaction"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsInteraction" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an interaction object, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_set_interaction" g_tls_connection_set_interaction :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    Ptr Gio.TlsInteraction.TlsInteraction -> -- interaction : TInterface (Name {namespace = "Gio", name = "TlsInteraction"})
    IO ()

-- | Set the object that will be used to interact with the user. It will be used
-- for things like prompting the user for passwords.
-- 
-- The /@interaction@/ argument will normally be a derived subclass of
-- t'GI.Gio.Objects.TlsInteraction.TlsInteraction'. 'P.Nothing' can also be provided if no user interaction
-- should occur for this connection.
-- 
-- /Since: 2.30/
tlsConnectionSetInteraction ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a, Gio.TlsInteraction.IsTlsInteraction b) =>
    a
    -- ^ /@conn@/: a connection
    -> Maybe (b)
    -- ^ /@interaction@/: an interaction object, or 'P.Nothing'
    -> m ()
tlsConnectionSetInteraction conn interaction = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    maybeInteraction <- case interaction of
        Nothing -> return FP.nullPtr
        Just jInteraction -> do
            jInteraction' <- unsafeManagedPtrCastPtr jInteraction
            return jInteraction'
    g_tls_connection_set_interaction conn' maybeInteraction
    touchManagedPtr conn
    whenJust interaction touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionSetInteractionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTlsConnection a, Gio.TlsInteraction.IsTlsInteraction b) => O.OverloadedMethod TlsConnectionSetInteractionMethodInfo a signature where
    overloadedMethod = tlsConnectionSetInteraction

instance O.OverloadedMethodInfo TlsConnectionSetInteractionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionSetInteraction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionSetInteraction"
        })


#endif

-- method TlsConnection::set_rehandshake_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsRehandshakeMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the rehandshaking mode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_set_rehandshake_mode" g_tls_connection_set_rehandshake_mode :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Gio", name = "TlsRehandshakeMode"})
    IO ()

{-# DEPRECATED tlsConnectionSetRehandshakeMode ["(Since version 2.60.)","Changing the rehandshake mode is no longer","  required for compatibility. Also, rehandshaking has been removed","  from the TLS protocol in TLS 1.3."] #-}
-- | Since GLib 2.64, changing the rehandshake mode is no longer supported
-- and will have no effect. With TLS 1.3, rehandshaking has been removed from
-- the TLS protocol, replaced by separate post-handshake authentication and
-- rekey operations.
-- 
-- /Since: 2.28/
tlsConnectionSetRehandshakeMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> Gio.Enums.TlsRehandshakeMode
    -- ^ /@mode@/: the rehandshaking mode
    -> m ()
tlsConnectionSetRehandshakeMode conn mode = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    let mode' = (fromIntegral . fromEnum) mode
    g_tls_connection_set_rehandshake_mode conn' mode'
    touchManagedPtr conn
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionSetRehandshakeModeMethodInfo
instance (signature ~ (Gio.Enums.TlsRehandshakeMode -> m ()), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionSetRehandshakeModeMethodInfo a signature where
    overloadedMethod = tlsConnectionSetRehandshakeMode

instance O.OverloadedMethodInfo TlsConnectionSetRehandshakeModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionSetRehandshakeMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionSetRehandshakeMode"
        })


#endif

-- method TlsConnection::set_require_close_notify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "require_close_notify"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether or not to require close notification"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_set_require_close_notify" g_tls_connection_set_require_close_notify :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    CInt ->                                 -- require_close_notify : TBasicType TBoolean
    IO ()

-- | Sets whether or not /@conn@/ expects a proper TLS close notification
-- before the connection is closed. If this is 'P.True' (the default),
-- then /@conn@/ will expect to receive a TLS close notification from its
-- peer before the connection is closed, and will return a
-- 'GI.Gio.Enums.TlsErrorEof' error if the connection is closed without proper
-- notification (since this may indicate a network error, or
-- man-in-the-middle attack).
-- 
-- In some protocols, the application will know whether or not the
-- connection was closed cleanly based on application-level data
-- (because the application-level data includes a length field, or is
-- somehow self-delimiting); in this case, the close notify is
-- redundant and sometimes omitted. (TLS 1.1 explicitly allows this;
-- in TLS 1.0 it is technically an error, but often done anyway.) You
-- can use 'GI.Gio.Objects.TlsConnection.tlsConnectionSetRequireCloseNotify' to tell /@conn@/
-- to allow an \"unannounced\" connection close, in which case the close
-- will show up as a 0-length read, as in a non-TLS
-- t'GI.Gio.Objects.SocketConnection.SocketConnection', and it is up to the application to check that
-- the data has been fully received.
-- 
-- Note that this only affects the behavior when the peer closes the
-- connection; when the application calls 'GI.Gio.Objects.IOStream.iOStreamClose' itself
-- on /@conn@/, this will send a close notification regardless of the
-- setting of this property. If you explicitly want to do an unclean
-- close, you can close /@conn@/\'s [TlsConnection:baseIoStream]("GI.Gio.Objects.TlsConnection#g:attr:baseIoStream") rather
-- than closing /@conn@/ itself, but note that this may only be done when no other
-- operations are pending on /@conn@/ or the base I\/O stream.
-- 
-- /Since: 2.28/
tlsConnectionSetRequireCloseNotify ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> Bool
    -- ^ /@requireCloseNotify@/: whether or not to require close notification
    -> m ()
tlsConnectionSetRequireCloseNotify conn requireCloseNotify = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    let requireCloseNotify' = (P.fromIntegral . P.fromEnum) requireCloseNotify
    g_tls_connection_set_require_close_notify conn' requireCloseNotify'
    touchManagedPtr conn
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionSetRequireCloseNotifyMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionSetRequireCloseNotifyMethodInfo a signature where
    overloadedMethod = tlsConnectionSetRequireCloseNotify

instance O.OverloadedMethodInfo TlsConnectionSetRequireCloseNotifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionSetRequireCloseNotify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionSetRequireCloseNotify"
        })


#endif

-- method TlsConnection::set_use_system_certdb
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_system_certdb"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to use the system certificate database"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_connection_set_use_system_certdb" g_tls_connection_set_use_system_certdb :: 
    Ptr TlsConnection ->                    -- conn : TInterface (Name {namespace = "Gio", name = "TlsConnection"})
    CInt ->                                 -- use_system_certdb : TBasicType TBoolean
    IO ()

{-# DEPRECATED tlsConnectionSetUseSystemCertdb ["(Since version 2.30)","Use 'GI.Gio.Objects.TlsConnection.tlsConnectionSetDatabase' instead"] #-}
-- | Sets whether /@conn@/ uses the system certificate database to verify
-- peer certificates. This is 'P.True' by default. If set to 'P.False', then
-- peer certificate validation will always set the
-- 'GI.Gio.Flags.TlsCertificateFlagsUnknownCa' error (meaning
-- [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate") will always be emitted on
-- client-side connections, unless that bit is not set in
-- [TlsClientConnection:validationFlags]("GI.Gio.Interfaces.TlsClientConnection#g:attr:validationFlags")).
tlsConnectionSetUseSystemCertdb ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TlsConnection.TlsConnection'
    -> Bool
    -- ^ /@useSystemCertdb@/: whether to use the system certificate database
    -> m ()
tlsConnectionSetUseSystemCertdb conn useSystemCertdb = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    let useSystemCertdb' = (P.fromIntegral . P.fromEnum) useSystemCertdb
    g_tls_connection_set_use_system_certdb conn' useSystemCertdb'
    touchManagedPtr conn
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsConnectionSetUseSystemCertdbMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTlsConnection a) => O.OverloadedMethod TlsConnectionSetUseSystemCertdbMethodInfo a signature where
    overloadedMethod = tlsConnectionSetUseSystemCertdb

instance O.OverloadedMethodInfo TlsConnectionSetUseSystemCertdbMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsConnection.tlsConnectionSetUseSystemCertdb",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TlsConnection.html#v:tlsConnectionSetUseSystemCertdb"
        })


#endif


