{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Monitors a file or directory for changes.
-- 
-- To obtain a @GFileMonitor@ for a file or directory, use
-- 'GI.Gio.Interfaces.File.fileMonitor', 'GI.Gio.Interfaces.File.fileMonitorFile', or
-- 'GI.Gio.Interfaces.File.fileMonitorDirectory'.
-- 
-- To get informed about changes to the file or directory you are
-- monitoring, connect to the [FileMonitor::changed]("GI.Gio.Objects.FileMonitor#g:signal:changed") signal. The
-- signal will be emitted in the thread-default main context (see
-- 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault') of the thread that the monitor
-- was created in (though if the global default main context is blocked, this
-- may cause notifications to be blocked even if the thread-default
-- context is still running).

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.FileMonitor
    ( 

-- * Exported types
    FileMonitor(..)                         ,
    IsFileMonitor                           ,
    toFileMonitor                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [cancel]("GI.Gio.Objects.FileMonitor#g:method:cancel"), [emitEvent]("GI.Gio.Objects.FileMonitor#g:method:emitEvent"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isCancelled]("GI.Gio.Objects.FileMonitor#g:method:isCancelled"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRateLimit]("GI.Gio.Objects.FileMonitor#g:method:setRateLimit").

#if defined(ENABLE_OVERLOADING)
    ResolveFileMonitorMethod                ,
#endif

-- ** cancel #method:cancel#

#if defined(ENABLE_OVERLOADING)
    FileMonitorCancelMethodInfo             ,
#endif
    fileMonitorCancel                       ,


-- ** emitEvent #method:emitEvent#

#if defined(ENABLE_OVERLOADING)
    FileMonitorEmitEventMethodInfo          ,
#endif
    fileMonitorEmitEvent                    ,


-- ** isCancelled #method:isCancelled#

#if defined(ENABLE_OVERLOADING)
    FileMonitorIsCancelledMethodInfo        ,
#endif
    fileMonitorIsCancelled                  ,


-- ** setRateLimit #method:setRateLimit#

#if defined(ENABLE_OVERLOADING)
    FileMonitorSetRateLimitMethodInfo       ,
#endif
    fileMonitorSetRateLimit                 ,




 -- * Properties


-- ** cancelled #attr:cancelled#
-- | Whether the monitor has been cancelled.

#if defined(ENABLE_OVERLOADING)
    FileMonitorCancelledPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    fileMonitorCancelled                    ,
#endif
    getFileMonitorCancelled                 ,


-- ** rateLimit #attr:rateLimit#
-- | The limit of the monitor to watch for changes, in milliseconds.

#if defined(ENABLE_OVERLOADING)
    FileMonitorRateLimitPropertyInfo        ,
#endif
    constructFileMonitorRateLimit           ,
#if defined(ENABLE_OVERLOADING)
    fileMonitorRateLimit                    ,
#endif
    getFileMonitorRateLimit                 ,
    setFileMonitorRateLimit                 ,




 -- * Signals


-- ** changed #signal:changed#

    FileMonitorChangedCallback              ,
#if defined(ENABLE_OVERLOADING)
    FileMonitorChangedSignalInfo            ,
#endif
    afterFileMonitorChanged                 ,
    onFileMonitorChanged                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File

#endif

-- | Memory-managed wrapper type.
newtype FileMonitor = FileMonitor (SP.ManagedPtr FileMonitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileMonitor where
    toManagedPtr (FileMonitor p) = p

foreign import ccall "g_file_monitor_get_type"
    c_g_file_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileMonitor where
    glibType = c_g_file_monitor_get_type

instance B.Types.GObject FileMonitor

-- | Type class for types which can be safely cast to t'FileMonitor', for instance with `toFileMonitor`.
class (SP.GObject o, O.IsDescendantOf FileMonitor o) => IsFileMonitor o
instance (SP.GObject o, O.IsDescendantOf FileMonitor o) => IsFileMonitor o

instance O.HasParentTypes FileMonitor
type instance O.ParentTypes FileMonitor = '[GObject.Object.Object]

-- | Cast to t'FileMonitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFileMonitor :: (MIO.MonadIO m, IsFileMonitor o) => o -> m FileMonitor
toFileMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileMonitor

-- | Convert t'FileMonitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileMonitor) where
    gvalueGType_ = c_g_file_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileMonitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileMonitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileMonitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFileMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileMonitorMethod "cancel" o = FileMonitorCancelMethodInfo
    ResolveFileMonitorMethod "emitEvent" o = FileMonitorEmitEventMethodInfo
    ResolveFileMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileMonitorMethod "isCancelled" o = FileMonitorIsCancelledMethodInfo
    ResolveFileMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileMonitorMethod "setRateLimit" o = FileMonitorSetRateLimitMethodInfo
    ResolveFileMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileMonitorMethod t FileMonitor, O.OverloadedMethod info FileMonitor p) => OL.IsLabel t (FileMonitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileMonitorMethod t FileMonitor, O.OverloadedMethod info FileMonitor p, R.HasField t FileMonitor p) => R.HasField t FileMonitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileMonitorMethod t FileMonitor, O.OverloadedMethodInfo info FileMonitor) => OL.IsLabel t (O.MethodProxy info FileMonitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal FileMonitor::changed
-- | Emitted when /@file@/ has been changed.
-- 
-- If using 'GI.Gio.Flags.FileMonitorFlagsWatchMoves' on a directory monitor, and
-- the information is available (and if supported by the backend),
-- /@eventType@/ may be 'GI.Gio.Enums.FileMonitorEventRenamed',
-- 'GI.Gio.Enums.FileMonitorEventMovedIn' or 'GI.Gio.Enums.FileMonitorEventMovedOut'.
-- 
-- In all cases /@file@/ will be a child of the monitored directory.  For
-- renames, /@file@/ will be the old name and /@otherFile@/ is the new
-- name.  For \"moved in\" events, /@file@/ is the name of the file that
-- appeared and /@otherFile@/ is the old name that it was moved from (in
-- another directory).  For \"moved out\" events, /@file@/ is the name of
-- the file that used to be in this directory and /@otherFile@/ is the
-- name of the file at its new location.
-- 
-- It makes sense to treat 'GI.Gio.Enums.FileMonitorEventMovedIn' as
-- equivalent to 'GI.Gio.Enums.FileMonitorEventCreated' and
-- 'GI.Gio.Enums.FileMonitorEventMovedOut' as equivalent to
-- 'GI.Gio.Enums.FileMonitorEventDeleted', with extra information.
-- 'GI.Gio.Enums.FileMonitorEventRenamed' is equivalent to a delete\/create
-- pair.  This is exactly how the events will be reported in the case
-- that the 'GI.Gio.Flags.FileMonitorFlagsWatchMoves' flag is not in use.
-- 
-- If using the deprecated flag 'GI.Gio.Flags.FileMonitorFlagsSendMoved' flag and /@eventType@/ is
-- 'GI.Gio.Enums.FileMonitorEventMoved', /@file@/ will be set to a t'GI.Gio.Interfaces.File.File' containing the
-- old path, and /@otherFile@/ will be set to a t'GI.Gio.Interfaces.File.File' containing the new path.
-- 
-- In all the other cases, /@otherFile@/ will be set to @/NULL/@.
type FileMonitorChangedCallback =
    Gio.File.File
    -- ^ /@file@/: a t'GI.Gio.Interfaces.File.File'.
    -> Maybe Gio.File.File
    -- ^ /@otherFile@/: a t'GI.Gio.Interfaces.File.File' or @/NULL/@.
    -> Gio.Enums.FileMonitorEvent
    -- ^ /@eventType@/: a t'GI.Gio.Enums.FileMonitorEvent'.
    -> IO ()

type C_FileMonitorChangedCallback =
    Ptr FileMonitor ->                      -- object
    Ptr Gio.File.File ->
    Ptr Gio.File.File ->
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileMonitorChangedCallback`.
foreign import ccall "wrapper"
    mk_FileMonitorChangedCallback :: C_FileMonitorChangedCallback -> IO (FunPtr C_FileMonitorChangedCallback)

wrap_FileMonitorChangedCallback :: 
    GObject a => (a -> FileMonitorChangedCallback) ->
    C_FileMonitorChangedCallback
wrap_FileMonitorChangedCallback gi'cb gi'selfPtr file otherFile eventType _ = do
    file' <- (newObject Gio.File.File) file
    maybeOtherFile <-
        if otherFile == FP.nullPtr
        then return Nothing
        else do
            otherFile' <- (newObject Gio.File.File) otherFile
            return $ Just otherFile'
    let eventType' = (toEnum . fromIntegral) eventType
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  file' maybeOtherFile eventType'


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileMonitor #changed callback
-- @
-- 
-- 
onFileMonitorChanged :: (IsFileMonitor a, MonadIO m) => a -> ((?self :: a) => FileMonitorChangedCallback) -> m SignalHandlerId
onFileMonitorChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileMonitorChangedCallback wrapped
    wrapped'' <- mk_FileMonitorChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileMonitor #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileMonitorChanged :: (IsFileMonitor a, MonadIO m) => a -> ((?self :: a) => FileMonitorChangedCallback) -> m SignalHandlerId
afterFileMonitorChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileMonitorChangedCallback wrapped
    wrapped'' <- mk_FileMonitorChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileMonitorChangedSignalInfo
instance SignalInfo FileMonitorChangedSignalInfo where
    type HaskellCallbackType FileMonitorChangedSignalInfo = FileMonitorChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileMonitorChangedCallback cb
        cb'' <- mk_FileMonitorChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileMonitor::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileMonitor.html#g:signal:changed"})

#endif

-- VVV Prop "cancelled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@cancelled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileMonitor #cancelled
-- @
getFileMonitorCancelled :: (MonadIO m, IsFileMonitor o) => o -> m Bool
getFileMonitorCancelled obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "cancelled"

#if defined(ENABLE_OVERLOADING)
data FileMonitorCancelledPropertyInfo
instance AttrInfo FileMonitorCancelledPropertyInfo where
    type AttrAllowedOps FileMonitorCancelledPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FileMonitorCancelledPropertyInfo = IsFileMonitor
    type AttrSetTypeConstraint FileMonitorCancelledPropertyInfo = (~) ()
    type AttrTransferTypeConstraint FileMonitorCancelledPropertyInfo = (~) ()
    type AttrTransferType FileMonitorCancelledPropertyInfo = ()
    type AttrGetType FileMonitorCancelledPropertyInfo = Bool
    type AttrLabel FileMonitorCancelledPropertyInfo = "cancelled"
    type AttrOrigin FileMonitorCancelledPropertyInfo = FileMonitor
    attrGet = getFileMonitorCancelled
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileMonitor.cancelled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileMonitor.html#g:attr:cancelled"
        })
#endif

-- VVV Prop "rate-limit"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@rate-limit@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileMonitor #rateLimit
-- @
getFileMonitorRateLimit :: (MonadIO m, IsFileMonitor o) => o -> m Int32
getFileMonitorRateLimit obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "rate-limit"

-- | Set the value of the “@rate-limit@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileMonitor [ #rateLimit 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileMonitorRateLimit :: (MonadIO m, IsFileMonitor o) => o -> Int32 -> m ()
setFileMonitorRateLimit obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "rate-limit" val

-- | Construct a t'GValueConstruct' with valid value for the “@rate-limit@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileMonitorRateLimit :: (IsFileMonitor o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructFileMonitorRateLimit val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "rate-limit" val

#if defined(ENABLE_OVERLOADING)
data FileMonitorRateLimitPropertyInfo
instance AttrInfo FileMonitorRateLimitPropertyInfo where
    type AttrAllowedOps FileMonitorRateLimitPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint FileMonitorRateLimitPropertyInfo = IsFileMonitor
    type AttrSetTypeConstraint FileMonitorRateLimitPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint FileMonitorRateLimitPropertyInfo = (~) Int32
    type AttrTransferType FileMonitorRateLimitPropertyInfo = Int32
    type AttrGetType FileMonitorRateLimitPropertyInfo = Int32
    type AttrLabel FileMonitorRateLimitPropertyInfo = "rate-limit"
    type AttrOrigin FileMonitorRateLimitPropertyInfo = FileMonitor
    attrGet = getFileMonitorRateLimit
    attrSet = setFileMonitorRateLimit
    attrPut = setFileMonitorRateLimit
    attrTransfer _ v = do
        return v
    attrConstruct = constructFileMonitorRateLimit
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileMonitor.rateLimit"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileMonitor.html#g:attr:rateLimit"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileMonitor
type instance O.AttributeList FileMonitor = FileMonitorAttributeList
type FileMonitorAttributeList = ('[ '("cancelled", FileMonitorCancelledPropertyInfo), '("rateLimit", FileMonitorRateLimitPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fileMonitorCancelled :: AttrLabelProxy "cancelled"
fileMonitorCancelled = AttrLabelProxy

fileMonitorRateLimit :: AttrLabelProxy "rateLimit"
fileMonitorRateLimit = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileMonitor = FileMonitorSignalList
type FileMonitorSignalList = ('[ '("changed", FileMonitorChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FileMonitor::cancel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_monitor_cancel" g_file_monitor_cancel :: 
    Ptr FileMonitor ->                      -- monitor : TInterface (Name {namespace = "Gio", name = "FileMonitor"})
    IO CInt

-- | Cancels a file monitor.
fileMonitorCancel ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gio.Objects.FileMonitor.FileMonitor'.
    -> m Bool
    -- ^ __Returns:__ always 'P.True'
fileMonitorCancel monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- g_file_monitor_cancel monitor'
    let result' = (/= 0) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data FileMonitorCancelMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileMonitor a) => O.OverloadedMethod FileMonitorCancelMethodInfo a signature where
    overloadedMethod = fileMonitorCancel

instance O.OverloadedMethodInfo FileMonitorCancelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileMonitor.fileMonitorCancel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileMonitor.html#v:fileMonitorCancel"
        })


#endif

-- method FileMonitor::emit_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFile." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "other_file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFile, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileMonitorEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a set of #GFileMonitorEvent flags."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_monitor_emit_event" g_file_monitor_emit_event :: 
    Ptr FileMonitor ->                      -- monitor : TInterface (Name {namespace = "Gio", name = "FileMonitor"})
    Ptr Gio.File.File ->                    -- child : TInterface (Name {namespace = "Gio", name = "File"})
    Ptr Gio.File.File ->                    -- other_file : TInterface (Name {namespace = "Gio", name = "File"})
    CUInt ->                                -- event_type : TInterface (Name {namespace = "Gio", name = "FileMonitorEvent"})
    IO ()

-- | Emits the [FileMonitor::changed]("GI.Gio.Objects.FileMonitor#g:signal:changed") signal if a change
-- has taken place. Should be called from file monitor
-- implementations only.
-- 
-- Implementations are responsible to call this method from the
-- thread-default main context (see 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault')
-- of the thread that the monitor was created in.
fileMonitorEmitEvent ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileMonitor a, Gio.File.IsFile b, Gio.File.IsFile c) =>
    a
    -- ^ /@monitor@/: a t'GI.Gio.Objects.FileMonitor.FileMonitor'.
    -> b
    -- ^ /@child@/: a t'GI.Gio.Interfaces.File.File'.
    -> Maybe (c)
    -- ^ /@otherFile@/: a t'GI.Gio.Interfaces.File.File', or 'P.Nothing'.
    -> Gio.Enums.FileMonitorEvent
    -- ^ /@eventType@/: a set of t'GI.Gio.Enums.FileMonitorEvent' flags.
    -> m ()
fileMonitorEmitEvent monitor child otherFile eventType = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    child' <- unsafeManagedPtrCastPtr child
    maybeOtherFile <- case otherFile of
        Nothing -> return FP.nullPtr
        Just jOtherFile -> do
            jOtherFile' <- unsafeManagedPtrCastPtr jOtherFile
            return jOtherFile'
    let eventType' = (fromIntegral . fromEnum) eventType
    g_file_monitor_emit_event monitor' child' maybeOtherFile eventType'
    touchManagedPtr monitor
    touchManagedPtr child
    whenJust otherFile touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FileMonitorEmitEventMethodInfo
instance (signature ~ (b -> Maybe (c) -> Gio.Enums.FileMonitorEvent -> m ()), MonadIO m, IsFileMonitor a, Gio.File.IsFile b, Gio.File.IsFile c) => O.OverloadedMethod FileMonitorEmitEventMethodInfo a signature where
    overloadedMethod = fileMonitorEmitEvent

instance O.OverloadedMethodInfo FileMonitorEmitEventMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileMonitor.fileMonitorEmitEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileMonitor.html#v:fileMonitorEmitEvent"
        })


#endif

-- method FileMonitor::is_cancelled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileMonitor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_monitor_is_cancelled" g_file_monitor_is_cancelled :: 
    Ptr FileMonitor ->                      -- monitor : TInterface (Name {namespace = "Gio", name = "FileMonitor"})
    IO CInt

-- | Returns whether the monitor is canceled.
fileMonitorIsCancelled ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gio.Objects.FileMonitor.FileMonitor'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if monitor is canceled. 'P.False' otherwise.
fileMonitorIsCancelled monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- g_file_monitor_is_cancelled monitor'
    let result' = (/= 0) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data FileMonitorIsCancelledMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileMonitor a) => O.OverloadedMethod FileMonitorIsCancelledMethodInfo a signature where
    overloadedMethod = fileMonitorIsCancelled

instance O.OverloadedMethodInfo FileMonitorIsCancelledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileMonitor.fileMonitorIsCancelled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileMonitor.html#v:fileMonitorIsCancelled"
        })


#endif

-- method FileMonitor::set_rate_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "limit_msecs"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a non-negative integer with the limit in milliseconds\n    to poll for changes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_monitor_set_rate_limit" g_file_monitor_set_rate_limit :: 
    Ptr FileMonitor ->                      -- monitor : TInterface (Name {namespace = "Gio", name = "FileMonitor"})
    Int32 ->                                -- limit_msecs : TBasicType TInt
    IO ()

-- | Sets the rate limit to which the /@monitor@/ will report
-- consecutive change events to the same file.
fileMonitorSetRateLimit ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gio.Objects.FileMonitor.FileMonitor'.
    -> Int32
    -- ^ /@limitMsecs@/: a non-negative integer with the limit in milliseconds
    --     to poll for changes
    -> m ()
fileMonitorSetRateLimit monitor limitMsecs = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    g_file_monitor_set_rate_limit monitor' limitMsecs
    touchManagedPtr monitor
    return ()

#if defined(ENABLE_OVERLOADING)
data FileMonitorSetRateLimitMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsFileMonitor a) => O.OverloadedMethod FileMonitorSetRateLimitMethodInfo a signature where
    overloadedMethod = fileMonitorSetRateLimit

instance O.OverloadedMethodInfo FileMonitorSetRateLimitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileMonitor.fileMonitorSetRateLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileMonitor.html#v:fileMonitorSetRateLimit"
        })


#endif


