/* StyleManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from StyleManager.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "granite-7.h"
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_STYLE_MANAGER_0_PROPERTY,
	GRANITE_STYLE_MANAGER_COLOR_SCHEME_PROPERTY,
	GRANITE_STYLE_MANAGER_DISPLAY_PROPERTY,
	GRANITE_STYLE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* granite_style_manager_properties[GRANITE_STYLE_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GraniteStyleManagerPrivate {
	GraniteSettingsColorScheme _color_scheme;
	GdkDisplay* _display;
};

static gint GraniteStyleManager_private_offset;
static gpointer granite_style_manager_parent_class = NULL;
static GtkCssProvider* granite_style_manager_accent_provider;
static GtkCssProvider* granite_style_manager_accent_provider = NULL;
static GtkCssProvider* granite_style_manager_base_provider;
static GtkCssProvider* granite_style_manager_base_provider = NULL;
static GtkCssProvider* granite_style_manager_dark_provider;
static GtkCssProvider* granite_style_manager_dark_provider = NULL;
static GtkCssProvider* granite_style_manager_app_provider;
static GtkCssProvider* granite_style_manager_app_provider = NULL;
static GHashTable* granite_style_manager_style_managers_by_displays;
static GHashTable* granite_style_manager_style_managers_by_displays = NULL;

 G_GNUC_INTERNAL void granite_style_manager_init_for_display (GdkDisplay* display);
static void _g_object_unref0_ (gpointer var);
static GraniteStyleManager* granite_style_manager_new (GdkDisplay* display);
static GraniteStyleManager* granite_style_manager_construct (GType object_type,
                                                      GdkDisplay* display);
static void granite_style_manager_set_provider_for_display (GraniteStyleManager* self);
static GtkCssProvider* granite_style_manager_init_provider_from_file (GraniteStyleManager* self,
                                                               GFile* file);
static void granite_style_manager_update_color_scheme (GraniteStyleManager* self);
static void granite_style_manager_update_accent_color (GraniteStyleManager* self);
static GObject * granite_style_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _granite_style_manager_set_provider_for_display_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void _granite_style_manager_update_color_scheme_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _granite_style_manager_update_accent_color_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void granite_style_manager_finalize (GObject * obj);
static GType granite_style_manager_get_type_once (void);
static void _vala_granite_style_manager_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_granite_style_manager_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
granite_style_manager_get_instance_private (GraniteStyleManager* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteStyleManager_private_offset);
}

/**
     * Returns the {@link Granite.StyleManager} that handles the default display
     * as gotten by {@link Gdk.Display.get_default}.
     */
GraniteStyleManager*
granite_style_manager_get_default (void)
{
	GHashTable* _tmp0_;
	GdkDisplay* _tmp1_;
	gconstpointer _tmp2_;
	GraniteStyleManager* result;
	_tmp0_ = granite_style_manager_style_managers_by_displays;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	result = (GraniteStyleManager*) _tmp2_;
	return result;
}

/**
     * Returns the {@link Granite.StyleManager} that handles the given {@link Gdk.Display}.
     */
GraniteStyleManager*
granite_style_manager_get_for_display (GdkDisplay* display)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GraniteStyleManager* result;
	g_return_val_if_fail (display != NULL, NULL);
	_tmp0_ = granite_style_manager_style_managers_by_displays;
	_tmp1_ = g_hash_table_lookup (_tmp0_, display);
	result = (GraniteStyleManager*) _tmp1_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

 G_GNUC_INTERNAL void
granite_style_manager_init_for_display (GdkDisplay* display)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	GdkDisplay* _tmp3_;
	GraniteStyleManager* _tmp4_;
	g_return_if_fail (display != NULL);
	_tmp0_ = granite_style_manager_style_managers_by_displays;
	if (_tmp0_ == NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
		_g_hash_table_unref0 (granite_style_manager_style_managers_by_displays);
		granite_style_manager_style_managers_by_displays = _tmp1_;
	}
	_tmp2_ = granite_style_manager_style_managers_by_displays;
	_tmp3_ = _g_object_ref0 (display);
	_tmp4_ = granite_style_manager_new (display);
	g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
}

GraniteSettingsColorScheme
granite_style_manager_get_color_scheme (GraniteStyleManager* self)
{
	GraniteSettingsColorScheme result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_color_scheme;
	return result;
}

void
granite_style_manager_set_color_scheme (GraniteStyleManager* self,
                                        GraniteSettingsColorScheme value)
{
	GraniteSettingsColorScheme old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_style_manager_get_color_scheme (self);
	if (old_value != value) {
		self->priv->_color_scheme = value;
		g_object_notify_by_pspec ((GObject *) self, granite_style_manager_properties[GRANITE_STYLE_MANAGER_COLOR_SCHEME_PROPERTY]);
	}
}

GdkDisplay*
granite_style_manager_get_display (GraniteStyleManager* self)
{
	GdkDisplay* result;
	GdkDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
granite_style_manager_set_display (GraniteStyleManager* self,
                                   GdkDisplay* value)
{
	GdkDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_style_manager_get_display (self);
	if (old_value != value) {
		GdkDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_style_manager_properties[GRANITE_STYLE_MANAGER_DISPLAY_PROPERTY]);
	}
}

static GraniteStyleManager*
granite_style_manager_construct (GType object_type,
                                 GdkDisplay* display)
{
	GraniteStyleManager * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GraniteStyleManager*) g_object_new (object_type, "display", display, NULL);
	return self;
}

static GraniteStyleManager*
granite_style_manager_new (GdkDisplay* display)
{
	return granite_style_manager_construct (GRANITE_TYPE_STYLE_MANAGER, display);
}

static void
granite_style_manager_set_provider_for_display (GraniteStyleManager* self)
{
	GtkCssProvider* _tmp0_;
	GdkDisplay* _tmp19_;
	GtkSettings* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_style_manager_app_provider;
	if (_tmp0_ == NULL) {
		GApplication* app = NULL;
		GApplication* _tmp1_;
		GApplication* _tmp2_;
		GtkCssProvider* _tmp16_;
		_tmp1_ = g_application_get_default ();
		app = _tmp1_;
		_tmp2_ = app;
		if (_tmp2_ != NULL) {
			gchar* base_path = NULL;
			GApplication* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp3_ = app;
			_tmp4_ = g_application_get_resource_base_path (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			base_path = _tmp6_;
			_tmp7_ = base_path;
			if (_tmp7_ != NULL) {
				gchar* base_uri = NULL;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				GFile* base_file = NULL;
				const gchar* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				GtkCssProvider* _tmp15_;
				_tmp8_ = base_path;
				_tmp9_ = g_strconcat ("resource://", _tmp8_, NULL);
				base_uri = _tmp9_;
				_tmp10_ = base_uri;
				_tmp11_ = g_file_new_for_uri (_tmp10_);
				base_file = _tmp11_;
				_tmp12_ = base_file;
				_tmp13_ = g_file_get_child (_tmp12_, "Application.css");
				_tmp14_ = _tmp13_;
				_tmp15_ = granite_style_manager_init_provider_from_file (self, _tmp14_);
				_g_object_unref0 (granite_style_manager_app_provider);
				granite_style_manager_app_provider = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (base_file);
				_g_free0 (base_uri);
			}
			_g_free0 (base_path);
		}
		_tmp16_ = granite_style_manager_app_provider;
		if (_tmp16_ != NULL) {
			GdkDisplay* _tmp17_;
			GtkCssProvider* _tmp18_;
			_tmp17_ = self->priv->_display;
			_tmp18_ = granite_style_manager_app_provider;
			gtk_style_context_add_provider_for_display (_tmp17_, (GtkStyleProvider*) _tmp18_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		}
	}
	_tmp19_ = self->priv->_display;
	_tmp20_ = gtk_settings_get_for_display (_tmp19_);
	g_object_get (_tmp20_, "gtk-application-prefer-dark-theme", &_tmp21_, NULL);
	_tmp22_ = _tmp21_;
	if (_tmp22_) {
		GtkCssProvider* _tmp23_;
		GtkCssProvider* _tmp26_;
		GdkDisplay* _tmp29_;
		GtkCssProvider* _tmp30_;
		_tmp23_ = granite_style_manager_base_provider;
		if (_tmp23_ != NULL) {
			GdkDisplay* _tmp24_;
			GtkCssProvider* _tmp25_;
			_tmp24_ = self->priv->_display;
			_tmp25_ = granite_style_manager_base_provider;
			gtk_style_context_remove_provider_for_display (_tmp24_, (GtkStyleProvider*) _tmp25_);
		}
		_tmp26_ = granite_style_manager_dark_provider;
		if (_tmp26_ == NULL) {
			GtkCssProvider* _tmp27_;
			GtkCssProvider* _tmp28_;
			_tmp27_ = gtk_css_provider_new ();
			_g_object_unref0 (granite_style_manager_dark_provider);
			granite_style_manager_dark_provider = _tmp27_;
			_tmp28_ = granite_style_manager_dark_provider;
			gtk_css_provider_load_from_resource (_tmp28_, "/io/elementary/granite/Granite-dark.css");
		}
		_tmp29_ = self->priv->_display;
		_tmp30_ = granite_style_manager_dark_provider;
		gtk_style_context_add_provider_for_display (_tmp29_, (GtkStyleProvider*) _tmp30_, (guint) GTK_STYLE_PROVIDER_PRIORITY_THEME);
	} else {
		GtkCssProvider* _tmp31_;
		GtkCssProvider* _tmp34_;
		GdkDisplay* _tmp37_;
		GtkCssProvider* _tmp38_;
		_tmp31_ = granite_style_manager_dark_provider;
		if (_tmp31_ != NULL) {
			GdkDisplay* _tmp32_;
			GtkCssProvider* _tmp33_;
			_tmp32_ = self->priv->_display;
			_tmp33_ = granite_style_manager_dark_provider;
			gtk_style_context_remove_provider_for_display (_tmp32_, (GtkStyleProvider*) _tmp33_);
		}
		_tmp34_ = granite_style_manager_base_provider;
		if (_tmp34_ == NULL) {
			GtkCssProvider* _tmp35_;
			GtkCssProvider* _tmp36_;
			_tmp35_ = gtk_css_provider_new ();
			_g_object_unref0 (granite_style_manager_base_provider);
			granite_style_manager_base_provider = _tmp35_;
			_tmp36_ = granite_style_manager_base_provider;
			gtk_css_provider_load_from_resource (_tmp36_, "/io/elementary/granite/Granite.css");
		}
		_tmp37_ = self->priv->_display;
		_tmp38_ = granite_style_manager_base_provider;
		gtk_style_context_add_provider_for_display (_tmp37_, (GtkStyleProvider*) _tmp38_, (guint) GTK_STYLE_PROVIDER_PRIORITY_THEME);
	}
}

static GtkCssProvider*
granite_style_manager_init_provider_from_file (GraniteStyleManager* self,
                                               GFile* file)
{
	GtkCssProvider* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	if (g_file_query_exists (file, NULL)) {
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp0_;
		GtkCssProvider* _tmp1_;
		_tmp0_ = gtk_css_provider_new ();
		provider = _tmp0_;
		_tmp1_ = provider;
		gtk_css_provider_load_from_file (_tmp1_, file);
		result = provider;
		return result;
	}
	result = NULL;
	return result;
}

static void
granite_style_manager_update_color_scheme (GraniteStyleManager* self)
{
	GtkSettings* gtk_settings = NULL;
	GdkDisplay* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GraniteSettingsColorScheme _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = gtk_settings_get_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gtk_settings = _tmp2_;
	_tmp3_ = self->priv->_color_scheme;
	if (_tmp3_ == GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE) {
		GraniteSettings* granite_settings = NULL;
		GraniteSettings* _tmp4_;
		GraniteSettings* _tmp5_;
		GtkSettings* _tmp6_;
		GraniteSettings* _tmp7_;
		GraniteSettingsColorScheme _tmp8_;
		GraniteSettingsColorScheme _tmp9_;
		_tmp4_ = granite_settings_get_default ();
		_tmp5_ = _g_object_ref0 (_tmp4_);
		granite_settings = _tmp5_;
		_tmp6_ = gtk_settings;
		_tmp7_ = granite_settings;
		_tmp8_ = granite_settings_get_prefers_color_scheme (_tmp7_);
		_tmp9_ = _tmp8_;
		g_object_set (_tmp6_, "gtk-application-prefer-dark-theme", _tmp9_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
		_g_object_unref0 (granite_settings);
	} else {
		GtkSettings* _tmp10_;
		GraniteSettingsColorScheme _tmp11_;
		_tmp10_ = gtk_settings;
		_tmp11_ = self->priv->_color_scheme;
		g_object_set (_tmp10_, "gtk-application-prefer-dark-theme", _tmp11_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	}
	_g_object_unref0 (gtk_settings);
}

static void
granite_style_manager_update_accent_color (GraniteStyleManager* self)
{
	GtkCssProvider* _tmp0_;
	gchar* accent_color = NULL;
	GraniteSettings* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_;
	gchar* _tmp5_;
	GdkDisplay* _tmp6_;
	GtkCssProvider* _tmp7_;
	GtkCssProvider* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GdkDisplay* _tmp11_;
	GtkCssProvider* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_style_manager_accent_provider;
	if (_tmp0_ == NULL) {
		GtkCssProvider* _tmp1_;
		_tmp1_ = gtk_css_provider_new ();
		_g_object_unref0 (granite_style_manager_accent_provider);
		granite_style_manager_accent_provider = _tmp1_;
	}
	_tmp2_ = granite_settings_get_default ();
	granite_settings_get_accent_color (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gdk_rgba_to_string (&_tmp4_);
	accent_color = _tmp5_;
	_tmp6_ = self->priv->_display;
	_tmp7_ = granite_style_manager_accent_provider;
	gtk_style_context_remove_provider_for_display (_tmp6_, (GtkStyleProvider*) _tmp7_);
	_tmp8_ = granite_style_manager_accent_provider;
	_tmp9_ = g_strdup_printf ("@define-color accent_color %s;", accent_color);
	_tmp10_ = _tmp9_;
	gtk_css_provider_load_from_string (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->_display;
	_tmp12_ = granite_style_manager_accent_provider;
	gtk_style_context_add_provider_for_display (_tmp11_, (GtkStyleProvider*) _tmp12_, (guint) (GTK_STYLE_PROVIDER_PRIORITY_THEME + 2));
	_g_free0 (accent_color);
}

static void
_granite_style_manager_set_provider_for_display_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	granite_style_manager_set_provider_for_display ((GraniteStyleManager*) self);
}

static void
_granite_style_manager_update_color_scheme_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	granite_style_manager_update_color_scheme ((GraniteStyleManager*) self);
}

static void
_granite_style_manager_update_accent_color_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	granite_style_manager_update_accent_color ((GraniteStyleManager*) self);
}

static GObject *
granite_style_manager_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteStyleManager * self;
	GtkSettings* gtk_settings = NULL;
	GdkDisplay* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GtkSettings* _tmp3_;
	GraniteSettings* granite_settings = NULL;
	GraniteSettings* _tmp4_;
	GraniteSettings* _tmp5_;
	GraniteSettings* _tmp6_;
	GraniteSettings* _tmp7_;
	GtkIconTheme* icon_theme = NULL;
	GdkDisplay* _tmp8_;
	GtkIconTheme* _tmp9_;
	GtkIconTheme* _tmp10_;
	GtkIconTheme* _tmp11_;
	parent_class = G_OBJECT_CLASS (granite_style_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_STYLE_MANAGER, GraniteStyleManager);
	_tmp0_ = self->priv->_display;
	_tmp1_ = gtk_settings_get_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gtk_settings = _tmp2_;
	_tmp3_ = gtk_settings;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::gtk-application-prefer-dark-theme", (GCallback) _granite_style_manager_set_provider_for_display_g_object_notify, self, 0);
	granite_style_manager_set_provider_for_display (self);
	_tmp4_ = granite_settings_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	granite_settings = _tmp5_;
	_tmp6_ = granite_settings;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::prefers-color-scheme", (GCallback) _granite_style_manager_update_color_scheme_g_object_notify, self, 0);
	_tmp7_ = granite_settings;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::accent-color", (GCallback) _granite_style_manager_update_accent_color_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::color-scheme", (GCallback) _granite_style_manager_update_color_scheme_g_object_notify, self, 0);
	granite_style_manager_update_color_scheme (self);
	granite_style_manager_update_accent_color (self);
	_tmp8_ = self->priv->_display;
	_tmp9_ = gtk_icon_theme_get_for_display (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	icon_theme = _tmp10_;
	_tmp11_ = icon_theme;
	gtk_icon_theme_add_resource_path (_tmp11_, "/io/elementary/granite");
	_g_object_unref0 (icon_theme);
	_g_object_unref0 (granite_settings);
	_g_object_unref0 (gtk_settings);
	return obj;
}

static void
granite_style_manager_class_init (GraniteStyleManagerClass * klass,
                                  gpointer klass_data)
{
	granite_style_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteStyleManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_style_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_style_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_style_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_style_manager_finalize;
	/**
	     * The {@link Granite.Settings.ColorScheme} requested by the application
	     * Uses value from {@link Granite.Settings.prefers_color_scheme} when set to {@link Granite.Settings.ColorScheme.NO_PREFERENCE}.
	     * Default value is {@link Granite.Settings.ColorScheme.NO_PREFERENCE}
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_STYLE_MANAGER_COLOR_SCHEME_PROPERTY, granite_style_manager_properties[GRANITE_STYLE_MANAGER_COLOR_SCHEME_PROPERTY] = g_param_spec_enum ("color-scheme", "color-scheme", "color-scheme", GRANITE_SETTINGS_TYPE_COLOR_SCHEME, GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The {@link Gdk.Display} handled by #this.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_STYLE_MANAGER_DISPLAY_PROPERTY, granite_style_manager_properties[GRANITE_STYLE_MANAGER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", gdk_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
granite_style_manager_instance_init (GraniteStyleManager * self,
                                     gpointer klass)
{
	self->priv = granite_style_manager_get_instance_private (self);
	self->priv->_color_scheme = GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE;
}

static void
granite_style_manager_finalize (GObject * obj)
{
	GraniteStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_STYLE_MANAGER, GraniteStyleManager);
	_g_object_unref0 (self->priv->_display);
	G_OBJECT_CLASS (granite_style_manager_parent_class)->finalize (obj);
}

/**
 * A class for managing the style of the application. This handles switching light and dark mode based
 * based on system preference or application preference (see {@link color_scheme}), etc.
 */
static GType
granite_style_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteStyleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_style_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteStyleManager), 0, (GInstanceInitFunc) granite_style_manager_instance_init, NULL };
	GType granite_style_manager_type_id;
	granite_style_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteStyleManager", &g_define_type_info, 0);
	GraniteStyleManager_private_offset = g_type_add_instance_private (granite_style_manager_type_id, sizeof (GraniteStyleManagerPrivate));
	return granite_style_manager_type_id;
}

GType
granite_style_manager_get_type (void)
{
	static volatile gsize granite_style_manager_type_id__once = 0;
	if (g_once_init_enter (&granite_style_manager_type_id__once)) {
		GType granite_style_manager_type_id;
		granite_style_manager_type_id = granite_style_manager_get_type_once ();
		g_once_init_leave (&granite_style_manager_type_id__once, granite_style_manager_type_id);
	}
	return granite_style_manager_type_id__once;
}

static void
_vala_granite_style_manager_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GraniteStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_STYLE_MANAGER, GraniteStyleManager);
	switch (property_id) {
		case GRANITE_STYLE_MANAGER_COLOR_SCHEME_PROPERTY:
		g_value_set_enum (value, granite_style_manager_get_color_scheme (self));
		break;
		case GRANITE_STYLE_MANAGER_DISPLAY_PROPERTY:
		g_value_set_object (value, granite_style_manager_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_style_manager_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GraniteStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_STYLE_MANAGER, GraniteStyleManager);
	switch (property_id) {
		case GRANITE_STYLE_MANAGER_COLOR_SCHEME_PROPERTY:
		granite_style_manager_set_color_scheme (self, g_value_get_enum (value));
		break;
		case GRANITE_STYLE_MANAGER_DISPLAY_PROPERTY:
		granite_style_manager_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

