/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_corr_est_cc = R"doc(

Constructor Specific Documentation:

Make a block that correlates against the  vector and outputs a phase and symbol timing estimate.

Args:
    symbols : Set of symbols to correlate against (e.g., a sync word).
    sps : Samples per symbol
    mark_delay : tag marking delay in samples after the corr_start tag
    threshold : Threshold of correlator. The meaning of this parameter depends on the threshold method used. For DYNAMIC threshold method, this parameter is actually 1 - Probability of False Alarm (under some inaccurate assumptions). The code performs the check |r[k]|^2 + |r[k+1]|^2 <> -log(1-threshold)*2*E, where r[k] is the correlated incoming signal, and E is the average sample energy of the correlated signal. For ABSOLUTE threshold method, this parameter sets the threshold to a fraction of the maximum squared autocorrelation. The code performs the check |r[k]|^2 <> threshold * R^2, where R is the precomputed max autocorrelation of the given sync word. Default is 0.9
    threshold_method : Method for computing threshold.)doc";


static const char* __doc_gr_digital_corr_est_cc_corr_est_cc_0 = R"doc()doc";


static const char* __doc_gr_digital_corr_est_cc_corr_est_cc_1 = R"doc()doc";


static const char* __doc_gr_digital_corr_est_cc_make = R"doc(

Constructor Specific Documentation:

Make a block that correlates against the  vector and outputs a phase and symbol timing estimate.

Args:
    symbols : Set of symbols to correlate against (e.g., a sync word).
    sps : Samples per symbol
    mark_delay : tag marking delay in samples after the corr_start tag
    threshold : Threshold of correlator. The meaning of this parameter depends on the threshold method used. For DYNAMIC threshold method, this parameter is actually 1 - Probability of False Alarm (under some inaccurate assumptions). The code performs the check |r[k]|^2 + |r[k+1]|^2 <> -log(1-threshold)*2*E, where r[k] is the correlated incoming signal, and E is the average sample energy of the correlated signal. For ABSOLUTE threshold method, this parameter sets the threshold to a fraction of the maximum squared autocorrelation. The code performs the check |r[k]|^2 <> threshold * R^2, where R is the precomputed max autocorrelation of the given sync word. Default is 0.9
    threshold_method : Method for computing threshold.)doc";


static const char* __doc_gr_digital_corr_est_cc_symbols = R"doc()doc";


static const char* __doc_gr_digital_corr_est_cc_set_symbols = R"doc()doc";


static const char* __doc_gr_digital_corr_est_cc_mark_delay = R"doc()doc";


static const char* __doc_gr_digital_corr_est_cc_set_mark_delay = R"doc()doc";


static const char* __doc_gr_digital_corr_est_cc_threshold = R"doc()doc";


static const char* __doc_gr_digital_corr_est_cc_set_threshold = R"doc()doc";
