/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_framer_sink_1 = R"doc(Given a stream of bits and access_code flags, assemble packets.

input: stream of bytes from digital_correlate_access_code_bb output: none. Pushes assembled packet into target queue


The framer expects a fixed length header of 2 16-bit shorts containing the payload length, followed by the payload. If the 2 16-bit shorts are not identical, this packet is ignored. Better algs are welcome.


The input data consists of bytes that have two bits used. Bit 0, the LSB, contains the data bit. Bit 1 if set, indicates that the corresponding bit is the the first bit of the packet. That is, this bit is the first one after the access code.

Constructor Specific Documentation:

Make a framer_sink_1 block.

Args:
    target_queue : The message queue where frames go.)doc";


static const char* __doc_gr_digital_framer_sink_1_framer_sink_1 = R"doc()doc";


static const char* __doc_gr_digital_framer_sink_1_make = R"doc(Given a stream of bits and access_code flags, assemble packets.

input: stream of bytes from digital_correlate_access_code_bb output: none. Pushes assembled packet into target queue


The framer expects a fixed length header of 2 16-bit shorts containing the payload length, followed by the payload. If the 2 16-bit shorts are not identical, this packet is ignored. Better algs are welcome.


The input data consists of bytes that have two bits used. Bit 0, the LSB, contains the data bit. Bit 1 if set, indicates that the corresponding bit is the the first bit of the packet. That is, this bit is the first one after the access code.

Constructor Specific Documentation:

Make a framer_sink_1 block.

Args:
    target_queue : The message queue where frames go.)doc";
