#define NLANGUAGES 812
struct LanguageScripts
{
  const gchar *language;
  const gchar *scripts[6];
  const guint32 iso15924[6];
};
struct LanguageScripts language_scripts[NLANGUAGES] =
  {
    { "aa", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ab", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "abq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "abr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ace", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ach", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ada", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ady", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "ae", { N_("Avestan"), NULL }, { 0x41767374, 0 } },
    { "aeb", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "af", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "agq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "aii", { N_("Syriac"), NULL }, { 0x53797263, 0 } },
    { "ain", { N_("Katakana"), N_("Latin"), NULL }, { 0x4b616e61, 0x4c61746e, 0 } },
    { "ak", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "akk", { N_("Cuneiform"), NULL }, { 0x58737578, 0 } },
    { "akz", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ale", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "aln", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "alt", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "am", { N_("Ethiopic"), NULL }, { 0x45746869, 0 } },
    { "amo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "an", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ang", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ann", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "anp", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "aoz", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "apc", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "apd", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "ar", { N_("Syriac"), NULL }, { 0x53797263, 0 } },
    { "arc", { N_("Imperial_Aramaic"), N_("Nabataean"), N_("Palmyrene"), NULL }, { 0x41726d69, 0x4e626174, 0x50616c6d, 0 } },
    { "arn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "aro", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "arp", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "arq", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "ars", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "arw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ary", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "arz", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "as", { N_("Bengali"), NULL }, { 0x42656e67, 0 } },
    { "asa", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ast", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "atj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "av", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "avk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "awa", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "ay", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "az", { N_("Arabic"), N_("Cyrillic"), NULL }, { 0x41726162, 0x4379726c, 0 } },
    { "ba", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "bal", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ban", { N_("Balinese"), NULL }, { 0x42616c69, 0 } },
    { "bap", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bar", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bas", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bax", { N_("Bamum"), NULL }, { 0x42616d75, 0 } },
    { "bbc", { N_("Batak"), NULL }, { 0x4261746b, 0 } },
    { "bbj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bci", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "be", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "bej", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "bem", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bew", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bez", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bfd", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bfq", { N_("Tamil"), NULL }, { 0x54616d6c, 0 } },
    { "bft", { N_("Tibetan"), NULL }, { 0x54696274, 0 } },
    { "bfy", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bg", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "bgc", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bgn", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "bgx", { N_("Greek"), NULL }, { 0x4772656b, 0 } },
    { "bhb", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bhi", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bho", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bik", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bin", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bjj", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bjn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bjt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bkm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bku", { N_("Buhid"), NULL }, { 0x42756864, 0 } },
    { "bla", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "blo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "blt", { N_("Tai_Viet"), NULL }, { 0x54617674, 0 } },
    { "bm", { N_("Latin"), N_("Nko"), NULL }, { 0x4c61746e, 0x4e6b6f6f, 0 } },
    { "bmq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bn", { N_("Bengali"), NULL }, { 0x42656e67, 0 } },
    { "bo", { N_("Tibetan"), NULL }, { 0x54696274, 0 } },
    { "bpy", { N_("Bengali"), NULL }, { 0x42656e67, 0 } },
    { "bqi", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "bqv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "br", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bra", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "brh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "brx", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bs", { N_("Cyrillic"), N_("Latin"), NULL }, { 0x4379726c, 0x4c61746e, 0 } },
    { "bsc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bsq", { N_("Bassa_Vah"), NULL }, { 0x42617373, 0 } },
    { "bss", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bto", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "btv", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "bua", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "buc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bug", { N_("Buginese"), NULL }, { 0x42756769, 0 } },
    { "bum", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bvb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "byn", { N_("Ethiopic"), NULL }, { 0x45746869, 0 } },
    { "byv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bze", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "bzx", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ca", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cad", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "car", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cay", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cch", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ccp", { N_("Bengali"), N_("Chakma"), NULL }, { 0x42656e67, 0x43616b6d, 0 } },
    { "ccr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ce", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "ceb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cgg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ch", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "chk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "chm", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "chn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cho", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "chp", { N_("Canadian_Aboriginal"), NULL }, { 0x43616e73, 0 } },
    { "chr", { N_("Cherokee"), NULL }, { 0x43686572, 0 } },
    { "chy", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cic", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cja", { N_("Cham"), NULL }, { 0x4368616d, 0 } },
    { "cjm", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "cjs", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "ckb", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "ckt", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "clc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "co", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cop", { N_("Arabic"), N_("Coptic"), N_("Greek"), NULL }, { 0x41726162, 0x436f7074, 0x4772656b, 0 } },
    { "cps", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cr", { N_("Canadian_Aboriginal"), N_("Latin"), NULL }, { 0x43616e73, 0x4c61746e, 0 } },
    { "crg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "crh", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "crj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "crk", { N_("Canadian_Aboriginal"), NULL }, { 0x43616e73, 0 } },
    { "crl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "crm", { N_("Canadian_Aboriginal"), NULL }, { 0x43616e73, 0 } },
    { "crs", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cs", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "csb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "csw", { N_("Canadian_Aboriginal"), NULL }, { 0x43616e73, 0 } },
    { "ctd", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "cu", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "cv", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "cy", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "da", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dak", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dar", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "dav", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dcc", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "de", { N_("Runic"), NULL }, { 0x52756e72, 0 } },
    { "del", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "den", { N_("Canadian_Aboriginal"), NULL }, { 0x43616e73, 0 } },
    { "dgr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "din", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dje", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dng", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "dnj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "doi", { N_("Arabic"), N_("Takri"), NULL }, { 0x41726162, 0x54616b72, 0 } },
    { "dsb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dtm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dtp", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dty", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "dua", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dum", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dv", { N_("Thaana"), NULL }, { 0x54686161, 0 } },
    { "dyo", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "dyu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "dz", { N_("Tibetan"), NULL }, { 0x54696274, 0 } },
    { "ebu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ecy", { N_("Cypriot"), NULL }, { 0x43707274, 0 } },
    { "ee", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "efi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "egl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "egy", { N_("Egyptian_Hieroglyphs"), NULL }, { 0x45677970, 0 } },
    { "eka", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "eky", { N_("Kayah_Li"), NULL }, { 0x4b616c69, 0 } },
    { "el", { N_("Greek"), NULL }, { 0x4772656b, 0 } },
    { "en", { N_("Deseret"), N_("Shavian"), NULL }, { 0x44737274, 0x53686177, 0 } },
    { "enm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "eo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "es", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "esu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "et", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ett", { N_("Latin"), N_("Old_Italic"), NULL }, { 0x4974616c, 0x4c61746e, 0 } },
    { "eu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "evn", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "ewo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ext", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fa", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "fan", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ff", { N_("Adlam"), NULL }, { 0x41646c6d, 0 } },
    { "ffm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fia", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "fil", { N_("Tagalog"), NULL }, { 0x54676c67, 0 } },
    { "fit", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fon", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fr", { N_("Duployan"), NULL }, { 0x4475706c, 0 } },
    { "frc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "frm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fro", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "frp", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "frr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "frs", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fud", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fuq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fur", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fuv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fvr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "fy", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ga", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gaa", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gag", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "gan", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "gay", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gba", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gbm", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "gbz", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "gcr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gd", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gez", { N_("Ethiopic"), NULL }, { 0x45746869, 0 } },
    { "gil", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gjk", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "gju", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "gl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gld", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "glk", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "gmh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gmy", { N_("Linear_B"), NULL }, { 0x4c696e62, 0 } },
    { "gn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "goh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gon", { N_("Devanagari"), N_("Telugu"), NULL }, { 0x44657661, 0x54656c75, 0 } },
    { "gor", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gos", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "got", { N_("Gothic"), NULL }, { 0x476f7468, 0 } },
    { "grb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "grc", { N_("Greek"), NULL }, { 0x4772656b, 0 } },
    { "grr", { N_("Tifinagh"), NULL }, { 0x54666e67, 0 } },
    { "grt", { N_("Bengali"), NULL }, { 0x42656e67, 0 } },
    { "gsw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gu", { N_("Gujarati"), NULL }, { 0x47756a72, 0 } },
    { "gub", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "guc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gur", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "guz", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "gvr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "gwi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ha", { N_("Arabic"), N_("Latin"), NULL }, { 0x41726162, 0x4c61746e, 0 } },
    { "hai", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hak", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "haw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "haz", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "he", { N_("Hebrew"), NULL }, { 0x48656272, 0 } },
    { "hi", { N_("Latin"), N_("Mahajani"), NULL }, { 0x4c61746e, 0x4d61686a, 0 } },
    { "hif", { N_("Devanagari"), N_("Latin"), NULL }, { 0x44657661, 0x4c61746e, 0 } },
    { "hil", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hit", { N_("Cuneiform"), NULL }, { 0x58737578, 0 } },
    { "hmd", { N_("Miao"), NULL }, { 0x506c7264, 0 } },
    { "hmn", { N_("Pahawh_Hmong"), NULL }, { 0x486d6e67, 0 } },
    { "hnd", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "hne", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "hnj", { N_("Lao"), NULL }, { 0x4c616f6f, 0 } },
    { "hnn", { N_("Hanunoo"), NULL }, { 0x48616e6f, 0 } },
    { "hno", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "ho", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hoc", { N_("Warang_Citi"), NULL }, { 0x57617261, 0 } },
    { "hoj", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "hop", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hsb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hsn", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "ht", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hup", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hur", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "hy", { N_("Armenian"), NULL }, { 0x41726d6e, 0 } },
    { "hz", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ia", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "iba", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ibb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "id", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "ie", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ife", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ig", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ii", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ik", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ikt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ilo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "inh", { N_("Arabic"), N_("Latin"), NULL }, { 0x41726162, 0x4c61746e, 0 } },
    { "io", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "is", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "it", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "iu", { N_("Canadian_Aboriginal"), N_("Latin"), NULL }, { 0x43616e73, 0x4c61746e, 0 } },
    { "izh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ja", { N_("Hiragana"), N_("Katakana"), NULL }, { 0x48726b74, 0 } },
    { "jam", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "jbo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "jgo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "jmc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "jml", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "jpr", { N_("Hebrew"), NULL }, { 0x48656272, 0 } },
    { "jrb", { N_("Hebrew"), NULL }, { 0x48656272, 0 } },
    { "jut", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "jv", { N_("Javanese"), NULL }, { 0x4a617661, 0 } },
    { "ka", { N_("Georgian"), NULL }, { 0x47656f72, 0 } },
    { "kaa", { N_("Cyrillic"), N_("Latin"), NULL }, { 0x4379726c, 0x4c61746e, 0 } },
    { "kab", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kac", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kaj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kam", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kao", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kaw", { N_("Javanese"), N_("Kawi"), NULL }, { 0x4a617661, 0x4b617769, 0 } },
    { "kbd", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "kca", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "kcg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kck", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kde", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kdt", { N_("Thai"), NULL }, { 0x54686169, 0 } },
    { "kea", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ken", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kfo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kfr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "kfy", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "kg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kge", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kgp", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kha", { N_("Bengali"), NULL }, { 0x42656e67, 0 } },
    { "khb", { N_("New_Tai_Lue"), NULL }, { 0x54616c75, 0 } },
    { "khn", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "khq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kht", { N_("Myanmar"), NULL }, { 0x4d796d72, 0 } },
    { "khw", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "ki", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kiu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kjg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kjh", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "kk", { N_("Arabic"), N_("Cyrillic"), NULL }, { 0x41726162, 0x4379726c, 0 } },
    { "kkj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kln", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "km", { N_("Khmer"), NULL }, { 0x4b686d72, 0 } },
    { "kmb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kn", { N_("Kannada"), NULL }, { 0x4b6e6461, 0 } },
    { "knf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "knn", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "ko", { N_("Hangul"), NULL }, { 0x48616e67, 0 } },
    { "koi", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "kok", { N_("Devanagari"), N_("Latin"), NULL }, { 0x44657661, 0x4c61746e, 0 } },
    { "kos", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kpe", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kpy", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "kr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "krc", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "kri", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "krj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "krl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kro", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kru", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "ks", { N_("Arabic"), N_("Devanagari"), NULL }, { 0x41726162, 0x44657661, 0 } },
    { "ksb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ksf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ksh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ku", { N_("Arabic"), N_("Cyrillic"), NULL }, { 0x41726162, 0x4379726c, 0 } },
    { "kum", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "kut", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kv", { N_("Old_Permic"), NULL }, { 0x5065726d, 0 } },
    { "kvr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kvx", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "kw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kwk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "kxm", { N_("Thai"), NULL }, { 0x54686169, 0 } },
    { "kxp", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "kxv", { N_("Devanagari"), N_("Oriya"), N_("Telugu"), NULL }, { 0x44657661, 0x4f727961, 0x54656c75, 0 } },
    { "ky", { N_("Arabic"), N_("Cyrillic"), N_("Latin"), NULL }, { 0x41726162, 0x4379726c, 0x4c61746e, 0 } },
    { "kyu", { N_("Kayah_Li"), NULL }, { 0x4b616c69, 0 } },
    { "la", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lab", { N_("Linear_A"), NULL }, { 0x4c696e61, 0 } },
    { "lad", { N_("Hebrew"), NULL }, { 0x48656272, 0 } },
    { "lag", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lah", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "laj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lam", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lbe", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "lbw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lcp", { N_("Thai"), NULL }, { 0x54686169, 0 } },
    { "len", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lep", { N_("Lepcha"), NULL }, { 0x4c657063, 0 } },
    { "lez", { N_("Caucasian_Albanian"), NULL }, { 0x41676862, 0 } },
    { "lfn", { N_("Cyrillic"), N_("Latin"), NULL }, { 0x4379726c, 0x4c61746e, 0 } },
    { "lg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "li", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lif", { N_("Devanagari"), N_("Limbu"), NULL }, { 0x44657661, 0x4c696d62, 0 } },
    { "lij", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lil", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lis", { N_("Lisu"), NULL }, { 0x4c697375, 0 } },
    { "liv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ljp", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lki", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "lkt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lld", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lmn", { N_("Telugu"), NULL }, { 0x54656c75, 0 } },
    { "lmo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ln", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lo", { N_("Lao"), NULL }, { 0x4c616f6f, 0 } },
    { "lol", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "loz", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lrc", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "lt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ltg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lua", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lui", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lun", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "luo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lus", { N_("Bengali"), NULL }, { 0x42656e67, 0 } },
    { "lut", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "luy", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "luz", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "lv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "lwl", { N_("Thai"), NULL }, { 0x54686169, 0 } },
    { "lzh", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "lzz", { N_("Georgian"), NULL }, { 0x47656f72, 0 } },
    { "mad", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "maf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mag", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "mai", { N_("Tirhuta"), NULL }, { 0x54697268, 0 } },
    { "mak", { N_("Buginese"), NULL }, { 0x42756769, 0 } },
    { "man", { N_("Latin"), N_("Nko"), NULL }, { 0x4c61746e, 0x4e6b6f6f, 0 } },
    { "mas", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "maz", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mdf", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "mdh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mdr", { N_("Buginese"), NULL }, { 0x42756769, 0 } },
    { "mdt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "men", { N_("Mende_Kikakui"), NULL }, { 0x4d656e64, 0 } },
    { "mer", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mey", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mfa", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "mfe", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mfv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mgh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mgo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mgp", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "mgy", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mhn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mic", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "min", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mk", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "ml", { N_("Malayalam"), NULL }, { 0x4d6c796d, 0 } },
    { "mls", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mn", { N_("Mongolian"), N_("Phags_Pa"), NULL }, { 0x4d6f6e67, 0x50686167, 0 } },
    { "mnc", { N_("Mongolian"), NULL }, { 0x4d6f6e67, 0 } },
    { "mni", { N_("Meetei_Mayek"), NULL }, { 0x4d746569, 0 } },
    { "mns", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "mnw", { N_("Myanmar"), NULL }, { 0x4d796d72, 0 } },
    { "moe", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "moh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mos", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mr", { N_("Modi"), NULL }, { 0x4d6f6469, 0 } },
    { "mrd", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "mrj", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "mro", { N_("Mro"), NULL }, { 0x4d726f6f, 0 } },
    { "ms", { N_("Arabic"), N_("Latin"), NULL }, { 0x41726162, 0x4c61746e, 0 } },
    { "mt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mtr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "mua", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mus", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mvy", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "mwk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mwl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mwr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "mwv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mww", { N_("Nyiakeng_Puachue_Hmong"), NULL }, { 0x486d6e70, 0 } },
    { "mxc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "my", { N_("Myanmar"), NULL }, { 0x4d796d72, 0 } },
    { "myv", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "myx", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "myz", { N_("Mandaic"), NULL }, { 0x4d616e64, 0 } },
    { "mzb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "mzn", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "na", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nan", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "nap", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "naq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nch", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nd", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ndc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nds", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ne", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "new", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "ng", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ngl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nhe", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nhw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nia", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nij", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "niu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "njo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nmg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nnh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "no", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nod", { N_("Tai_Tham"), NULL }, { 0x4c616e61, 0 } },
    { "noe", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "nog", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "non", { N_("Runic"), NULL }, { 0x52756e72, 0 } },
    { "nov", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nqo", { N_("Nko"), NULL }, { 0x4e6b6f6f, 0 } },
    { "nr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nsk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nso", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nus", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nxq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ny", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nym", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nyn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nyo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "nzi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "oc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "oj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ojs", { N_("Canadian_Aboriginal"), NULL }, { 0x43616e73, 0 } },
    { "ojw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "oka", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "om", { N_("Ethiopic"), NULL }, { 0x45746869, 0 } },
    { "or", { N_("Oriya"), NULL }, { 0x4f727961, 0 } },
    { "os", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "osa", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "osc", { N_("Latin"), N_("Old_Italic"), NULL }, { 0x4974616c, 0x4c61746e, 0 } },
    { "otk", { N_("Old_Turkic"), NULL }, { 0x4f726b68, 0 } },
    { "pa", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "pag", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pal", { N_("Inscriptional_Pahlavi"), N_("Psalter_Pahlavi"), NULL }, { 0x50686c69, 0x50686c70, 0 } },
    { "pam", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pap", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pau", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pcd", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pcm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pdc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pdt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "peo", { N_("Old_Persian"), NULL }, { 0x5870656f, 0 } },
    { "pfl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "phn", { N_("Phoenician"), NULL }, { 0x50686e78, 0 } },
    { "pi", { N_("Devanagari"), N_("Myanmar"), N_("Sinhala"), N_("Thai"), NULL }, { 0x44657661, 0x4d796d72, 0x53696e68, 0x54686169, 0 } },
    { "pis", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pko", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pms", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pnt", { N_("Cyrillic"), N_("Latin"), NULL }, { 0x4379726c, 0x4c61746e, 0 } },
    { "pon", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ppl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pqm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "prd", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "prg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "pro", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ps", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "pt", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "puu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "qu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "quc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "qug", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "raj", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "rap", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rar", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rcf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rej", { N_("Rejang"), NULL }, { 0x526a6e67, 0 } },
    { "rgn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rhg", { N_("Arabic"), N_("Latin"), NULL }, { 0x41726162, 0x4c61746e, 0 } },
    { "ria", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rif", { N_("Latin"), N_("Tifinagh"), NULL }, { 0x4c61746e, 0x54666e67, 0 } },
    { "rjs", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "rkt", { N_("Bengali"), NULL }, { 0x42656e67, 0 } },
    { "rm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rmf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rmo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rmt", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "rmu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rng", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ro", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "rob", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rof", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rom", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "rtm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ru", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "rue", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "rug", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rup", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "rwk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ryu", { N_("Katakana"), NULL }, { 0x4b616e61, 0 } },
    { "sa", { N_("Devanagari"), N_("Grantha"), N_("Sharada"), N_("Siddham"), N_("Sinhala"), NULL }, { 0x44657661, 0x4772616e, 0x53687264, 0x53696464, 0x53696e68, 0 } },
    { "sad", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "saf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sah", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "sam", { N_("Hebrew"), N_("Samaritan"), NULL }, { 0x48656272, 0x53616d72, 0 } },
    { "saq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sas", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sat", { N_("Bengali"), N_("Devanagari"), N_("Latin"), N_("Oriya"), NULL }, { 0x42656e67, 0x44657661, 0x4c61746e, 0x4f727961, 0 } },
    { "saz", { N_("Saurashtra"), NULL }, { 0x53617572, 0 } },
    { "sbp", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sck", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "scn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sco", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "scs", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sd", { N_("Khojki"), N_("Khudawadi"), NULL }, { 0x4b686f6a, 0x53696e64, 0 } },
    { "sdc", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sdh", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "se", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "see", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sef", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "seh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sei", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sel", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "ses", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sga", { N_("Ogham"), NULL }, { 0x4f67616d, 0 } },
    { "sgs", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "shi", { N_("Arabic"), N_("Latin"), N_("Tifinagh"), NULL }, { 0x41726162, 0x4c61746e, 0x54666e67, 0 } },
    { "shn", { N_("Myanmar"), NULL }, { 0x4d796d72, 0 } },
    { "si", { N_("Sinhala"), NULL }, { 0x53696e68, 0 } },
    { "sid", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "skr", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "sl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sli", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sly", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sma", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "smj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "smn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "smp", { N_("Samaritan"), NULL }, { 0x53616d72, 0 } },
    { "sms", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "snf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "snk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "so", { N_("Arabic"), N_("Osmanya"), NULL }, { 0x41726162, 0x4f736d61, 0 } },
    { "sou", { N_("Thai"), NULL }, { 0x54686169, 0 } },
    { "sq", { N_("Elbasan"), NULL }, { 0x456c6261, 0 } },
    { "sr", { N_("Cyrillic"), N_("Latin"), NULL }, { 0x4379726c, 0x4c61746e, 0 } },
    { "srb", { N_("Sora_Sompeng"), NULL }, { 0x536f7261, 0 } },
    { "srn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "srr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "srx", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "ss", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ssy", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "st", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "stq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "stu", { N_("Tai_Le"), NULL }, { 0x54616c65, 0 } },
    { "su", { N_("Sundanese"), NULL }, { 0x53756e64, 0 } },
    { "suk", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sus", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "suz", { N_("Sunuwar"), NULL }, { 0x53756e75, 0 } },
    { "sv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "sw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "swb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "swg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "swv", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "sxn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "syi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "syl", { N_("Syloti_Nagri"), NULL }, { 0x53796c6f, 0 } },
    { "syr", { N_("Syriac"), NULL }, { 0x53797263, 0 } },
    { "szl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ta", { N_("Tamil"), NULL }, { 0x54616d6c, 0 } },
    { "tab", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "taj", { N_("Tibetan"), NULL }, { 0x54696274, 0 } },
    { "tbw", { N_("Tagbanwa"), NULL }, { 0x54616762, 0 } },
    { "tcy", { N_("Kannada"), NULL }, { 0x4b6e6461, 0 } },
    { "tdd", { N_("Tai_Le"), NULL }, { 0x54616c65, 0 } },
    { "tdg", { N_("Tibetan"), NULL }, { 0x54696274, 0 } },
    { "tdh", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "te", { N_("Telugu"), NULL }, { 0x54656c75, 0 } },
    { "tem", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "teo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ter", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tet", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tg", { N_("Arabic"), N_("Cyrillic"), N_("Latin"), NULL }, { 0x41726162, 0x4379726c, 0x4c61746e, 0 } },
    { "th", { N_("Thai"), NULL }, { 0x54686169, 0 } },
    { "thl", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "thq", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "thr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "ti", { N_("Ethiopic"), NULL }, { 0x45746869, 0 } },
    { "tig", { N_("Ethiopic"), NULL }, { 0x45746869, 0 } },
    { "tiv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tk", { N_("Arabic"), N_("Cyrillic"), N_("Latin"), NULL }, { 0x41726162, 0x4379726c, 0x4c61746e, 0 } },
    { "tkl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tkr", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "tkt", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "tli", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tly", { N_("Arabic"), N_("Cyrillic"), NULL }, { 0x41726162, 0x4379726c, 0 } },
    { "tmh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tn", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tnr", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "to", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tog", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tok", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tpi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tr", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "tru", { N_("Syriac"), NULL }, { 0x53797263, 0 } },
    { "trv", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "trw", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "ts", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tsd", { N_("Greek"), NULL }, { 0x4772656b, 0 } },
    { "tsg", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tsi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tsj", { N_("Tibetan"), NULL }, { 0x54696274, 0 } },
    { "tt", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "ttj", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tts", { N_("Thai"), NULL }, { 0x54686169, 0 } },
    { "ttt", { N_("Arabic"), N_("Cyrillic"), NULL }, { 0x41726162, 0x4379726c, 0 } },
    { "tum", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tvl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "twq", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ty", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "tyv", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "tzm", { N_("Latin"), N_("Tifinagh"), NULL }, { 0x4c61746e, 0x54666e67, 0 } },
    { "ude", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "udm", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ug", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "uga", { N_("Ugaritic"), NULL }, { 0x55676172, 0 } },
    { "uk", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "uli", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "umb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "unr", { N_("Bengali"), N_("Devanagari"), NULL }, { 0x42656e67, 0x44657661, 0 } },
    { "unx", { N_("Bengali"), N_("Devanagari"), NULL }, { 0x42656e67, 0x44657661, 0 } },
    { "ur", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "uz", { N_("Arabic"), N_("Cyrillic"), N_("Latin"), NULL }, { 0x41726162, 0x4379726c, 0x4c61746e, 0 } },
    { "vai", { N_("Latin"), N_("Vai"), NULL }, { 0x4c61746e, 0x56616969, 0 } },
    { "ve", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vec", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vep", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vi", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "vic", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vls", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vmf", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vmw", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vot", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vro", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "vun", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "wa", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "wae", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "wal", { N_("Ethiopic"), NULL }, { 0x45746869, 0 } },
    { "war", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "was", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "wbp", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "wbq", { N_("Telugu"), NULL }, { 0x54656c75, 0 } },
    { "wbr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "wls", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "wni", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "wo", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "wtm", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "wuu", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "xal", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "xav", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "xcr", { N_("Carian"), NULL }, { 0x43617269, 0 } },
    { "xh", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "xlc", { N_("Lycian"), NULL }, { 0x4c796369, 0 } },
    { "xld", { N_("Lydian"), NULL }, { 0x4c796469, 0 } },
    { "xmf", { N_("Georgian"), NULL }, { 0x47656f72, 0 } },
    { "xmn", { N_("Manichaean"), NULL }, { 0x4d616e69, 0 } },
    { "xmr", { N_("Meroitic_Cursive"), NULL }, { 0x4d657263, 0 } },
    { "xna", { N_("Old_North_Arabian"), NULL }, { 0x4e617262, 0 } },
    { "xnr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "xog", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "xpr", { N_("Inscriptional_Parthian"), NULL }, { 0x50727469, 0 } },
    { "xsa", { N_("Old_South_Arabian"), NULL }, { 0x53617262, 0 } },
    { "xsr", { N_("Devanagari"), NULL }, { 0x44657661, 0 } },
    { "xum", { N_("Latin"), N_("Old_Italic"), NULL }, { 0x4974616c, 0x4c61746e, 0 } },
    { "yao", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "yap", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "yav", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "ybb", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "yi", { N_("Hebrew"), NULL }, { 0x48656272, 0 } },
    { "yo", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "yrk", { N_("Cyrillic"), NULL }, { 0x4379726c, 0 } },
    { "yrl", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "yua", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "yue", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "za", { N_("Han"), NULL }, { 0x48616e69, 0 } },
    { "zag", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "zap", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "zdj", { N_("Arabic"), NULL }, { 0x41726162, 0 } },
    { "zea", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "zen", { N_("Tifinagh"), NULL }, { 0x54666e67, 0 } },
    { "zgh", { N_("Tifinagh"), NULL }, { 0x54666e67, 0 } },
    { "zh", { N_("Bopomofo"), N_("Han"), N_("Latin"), N_("Phags_Pa"), NULL }, { 0x426f706f, 0x48616e69, 0x4c61746e, 0x50686167, 0 } },
    { "zmi", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "zu", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "zun", { N_("Latin"), NULL }, { 0x4c61746e, 0 } },
    { "zza", { N_("Latin"), NULL }, { 0x4c61746e, 0 } }
};
