/* gitg-ref-action-rename.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ref-action-rename.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>

#define GITG_REF_ACTION_RENAME_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_REF_ACTION_RENAME (gitg_ref_action_rename_get_type ())
#define GITG_REF_ACTION_RENAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_RENAME, GitgRefActionRename))
#define GITG_REF_ACTION_RENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_RENAME, GitgRefActionRenameClass))
#define GITG_IS_REF_ACTION_RENAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_RENAME))
#define GITG_IS_REF_ACTION_RENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_RENAME))
#define GITG_REF_ACTION_RENAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_RENAME, GitgRefActionRenameClass))

typedef struct _GitgRefActionRename GitgRefActionRename;
typedef struct _GitgRefActionRenameClass GitgRefActionRenameClass;
typedef struct _GitgRefActionRenamePrivate GitgRefActionRenamePrivate;
enum  {
	GITG_REF_ACTION_RENAME_0_PROPERTY,
	GITG_REF_ACTION_RENAME_APPLICATION_PROPERTY,
	GITG_REF_ACTION_RENAME_ACTION_INTERFACE_PROPERTY,
	GITG_REF_ACTION_RENAME_REFERENCE_PROPERTY,
	GITG_REF_ACTION_RENAME_ID_PROPERTY,
	GITG_REF_ACTION_RENAME_DISPLAY_NAME_PROPERTY,
	GITG_REF_ACTION_RENAME_DESCRIPTION_PROPERTY,
	GITG_REF_ACTION_RENAME_ENABLED_PROPERTY,
	GITG_REF_ACTION_RENAME_NUM_PROPERTIES
};
static GParamSpec* gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgRefActionRename {
	GObject parent_instance;
	GitgRefActionRenamePrivate * priv;
};

struct _GitgRefActionRenameClass {
	GObjectClass parent_class;
};

struct _GitgRefActionRenamePrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
	GitgRef* _reference;
};

static gint GitgRefActionRename_private_offset;
static gpointer gitg_ref_action_rename_parent_class = NULL;
static GitgExtUIElementIface * gitg_ref_action_rename_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_ref_action_rename_gitg_ext_action_parent_iface = NULL;
static GitgExtRefActionIface * gitg_ref_action_rename_gitg_ext_ref_action_parent_iface = NULL;

VALA_EXTERN GType gitg_ref_action_rename_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRefActionRename, g_object_unref)
VALA_EXTERN GitgRefActionRename* gitg_ref_action_rename_new (GitgExtApplication* application,
                                                 GitgExtRefActionInterface* action_interface,
                                                 GitgRef* reference);
VALA_EXTERN GitgRefActionRename* gitg_ref_action_rename_construct (GType object_type,
                                                       GitgExtApplication* application,
                                                       GitgExtRefActionInterface* action_interface,
                                                       GitgRef* reference);
static void gitg_ref_action_rename_real_activate (GitgExtUIElement* base);
static void gitg_ref_action_rename_on_ref_name_editing_done (GitgRefActionRename* self,
                                                      const gchar* new_text,
                                                      gboolean cancelled);
static void _gitg_ref_action_rename_on_ref_name_editing_done_gitg_ext_ref_name_editing_done (const gchar* new_name,
                                                                                      gboolean cancelled,
                                                                                      gpointer self);
static void gitg_ref_action_rename_finalize (GObject * obj);
static GType gitg_ref_action_rename_get_type_once (void);
static void _vala_gitg_ref_action_rename_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gitg_ref_action_rename_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
gitg_ref_action_rename_get_instance_private (GitgRefActionRename* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRefActionRename_private_offset);
}

GitgRefActionRename*
gitg_ref_action_rename_construct (GType object_type,
                                  GitgExtApplication* application,
                                  GitgExtRefActionInterface* action_interface,
                                  GitgRef* reference)
{
	GitgRefActionRename * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	self = (GitgRefActionRename*) g_object_new (object_type, "application", application, "action-interface", action_interface, "reference", reference, NULL);
	return self;
}

GitgRefActionRename*
gitg_ref_action_rename_new (GitgExtApplication* application,
                            GitgExtRefActionInterface* action_interface,
                            GitgRef* reference)
{
	return gitg_ref_action_rename_construct (GITG_TYPE_REF_ACTION_RENAME, application, action_interface, reference);
}

static void
_gitg_ref_action_rename_on_ref_name_editing_done_gitg_ext_ref_name_editing_done (const gchar* new_name,
                                                                                 gboolean cancelled,
                                                                                 gpointer self)
{
	gitg_ref_action_rename_on_ref_name_editing_done ((GitgRefActionRename*) self, new_name, cancelled);
}

static void
gitg_ref_action_rename_real_activate (GitgExtUIElement* base)
{
	GitgRefActionRename * self;
	GitgExtRefActionInterface* _tmp0_;
	GitgExtRefActionInterface* _tmp1_;
	GitgRef* _tmp2_;
	GitgRef* _tmp3_;
	self = (GitgRefActionRename*) base;
	_tmp0_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp3_ = _tmp2_;
	gitg_ext_ref_action_interface_edit_ref_name (_tmp1_, _tmp3_, _gitg_ref_action_rename_on_ref_name_editing_done_gitg_ext_ref_name_editing_done, g_object_ref (self), g_object_unref);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_ref_action_rename_on_ref_name_editing_done (GitgRefActionRename* self,
                                                 const gchar* new_text,
                                                 gboolean cancelled)
{
	gchar* orig = NULL;
	gchar* prefix = NULL;
	GitgParsedRefName* pn = NULL;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgParsedRefName* _tmp4_;
	GitgRefType _tmp5_;
	GitgRefType _tmp6_;
	const gchar* _tmp29_;
	gchar** split = NULL;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint split_length1;
	gint _split_size_;
	gchar* branchname = NULL;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gboolean _tmp66_;
	GgitBranch* branch = NULL;
	GitgRef* _tmp74_;
	GitgRef* _tmp75_;
	GgitBranch* _tmp76_;
	GitgRef* new_ref = NULL;
	GitgExtRefActionInterface* _tmp99_;
	GitgExtRefActionInterface* _tmp100_;
	GitgRef* _tmp101_;
	GitgRef* _tmp102_;
	GitgRef* _tmp103_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_text != NULL);
	if (cancelled) {
		return;
	}
	_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_ref_get_parsed_name (_tmp1_);
	_tmp3_ = _tmp2_;
	pn = _tmp3_;
	_tmp4_ = pn;
	_tmp5_ = gitg_parsed_ref_name_get_rtype (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == GITG_REF_TYPE_REMOTE) {
		GitgParsedRefName* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GitgParsedRefName* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GitgParsedRefName* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp7_ = pn;
		_tmp8_ = gitg_parsed_ref_name_get_remote_branch (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (orig);
		orig = _tmp9_;
		_tmp10_ = pn;
		_tmp11_ = gitg_parsed_ref_name_get_prefix (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, "/", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = pn;
		_tmp16_ = gitg_parsed_ref_name_get_remote_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp14_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
		_g_free0 (prefix);
		prefix = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp14_);
	} else {
		GitgParsedRefName* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GitgParsedRefName* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp22_ = pn;
		_tmp23_ = gitg_parsed_ref_name_get_shortname (_tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (orig);
		orig = _tmp24_;
		_tmp25_ = pn;
		_tmp26_ = gitg_parsed_ref_name_get_prefix (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (prefix);
		prefix = _tmp28_;
	}
	_tmp29_ = orig;
	if (g_strcmp0 (_tmp29_, new_text) == 0) {
		_g_object_unref0 (pn);
		_g_free0 (prefix);
		_g_free0 (orig);
		return;
	}
	_tmp31_ = _tmp30_ = g_strsplit (new_text, "/", 0);
	split = _tmp31_;
	split_length1 = _vala_array_length (_tmp30_);
	_split_size_ = split_length1;
	_tmp32_ = g_strdup ("");
	branchname = _tmp32_;
	_tmp33_ = split;
	_tmp33__length1 = split_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp33_;
		str_collection_length1 = _tmp33__length1;
		for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
			const gchar* str = NULL;
			str = str_collection[str_it];
			{
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				const gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp34_ = branchname;
				_tmp35_ = str;
				_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
				_g_free0 (branchname);
				branchname = _tmp36_;
				{
					GitgExtApplication* _tmp37_;
					GitgExtApplication* _tmp38_;
					GitgExtApplication* _tmp39_;
					GitgRepository* _tmp40_;
					GitgRepository* _tmp41_;
					GitgRepository* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					GitgRef* _tmp49_;
					GitgRef* _tmp50_;
					gchar* msg = NULL;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					GitgExtRefActionInterface* _tmp53_;
					GitgExtRefActionInterface* _tmp54_;
					GitgExtApplication* _tmp55_;
					GitgExtApplication* _tmp56_;
					GitgExtApplication* _tmp57_;
					const gchar* _tmp58_;
					_tmp37_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
					_tmp38_ = _tmp37_;
					_tmp39_ = _tmp38_;
					_tmp40_ = gitg_ext_application_get_repository (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = _tmp41_;
					_tmp43_ = prefix;
					_tmp44_ = string_to_string (_tmp43_);
					_tmp45_ = branchname;
					_tmp46_ = string_to_string (_tmp45_);
					_tmp47_ = g_strconcat (_tmp44_, _tmp46_, NULL);
					_tmp48_ = _tmp47_;
					_tmp49_ = gitg_repository_lookup_reference (_tmp42_, _tmp48_, &_inner_error0_);
					_tmp50_ = _tmp49_;
					_g_object_unref0 (_tmp50_);
					_g_free0 (_tmp48_);
					_g_object_unref0 (_tmp42_);
					_g_object_unref0 (_tmp39_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp51_ = branchname;
					_tmp52_ = g_strdup_printf (_ ("The specified name “%s” match with existing branch “%s”"), new_text, _tmp51_);
					msg = _tmp52_;
					_tmp53_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
					_tmp54_ = _tmp53_;
					_tmp55_ = gitg_ext_ref_action_interface_get_application (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = _tmp56_;
					_tmp58_ = msg;
					gitg_ext_application_show_infobar (_tmp57_, _ ("Invalid name"), _tmp58_, GTK_MESSAGE_ERROR);
					_g_object_unref0 (_tmp57_);
					_g_free0 (msg);
					_g_free0 (branchname);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (pn);
					_g_free0 (prefix);
					_g_free0 (orig);
					return;
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (branchname);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (pn);
					_g_free0 (prefix);
					_g_free0 (orig);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp59_ = branchname;
				_tmp60_ = g_strconcat (_tmp59_, "/", NULL);
				_g_free0 (branchname);
				branchname = _tmp60_;
			}
		}
	}
	_tmp61_ = prefix;
	_tmp62_ = string_to_string (_tmp61_);
	_tmp63_ = string_to_string (new_text);
	_tmp64_ = g_strconcat (_tmp62_, _tmp63_, NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = !ggit_ref_is_valid_name (_tmp65_);
	_g_free0 (_tmp65_);
	if (_tmp66_) {
		gchar* msg = NULL;
		gchar* _tmp67_;
		GitgExtRefActionInterface* _tmp68_;
		GitgExtRefActionInterface* _tmp69_;
		GitgExtApplication* _tmp70_;
		GitgExtApplication* _tmp71_;
		GitgExtApplication* _tmp72_;
		const gchar* _tmp73_;
		_tmp67_ = g_strdup_printf (_ ("The specified name “%s” contains invalid characters"), new_text);
		msg = _tmp67_;
		_tmp68_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
		_tmp69_ = _tmp68_;
		_tmp70_ = gitg_ext_ref_action_interface_get_application (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = _tmp71_;
		_tmp73_ = msg;
		gitg_ext_application_show_infobar (_tmp72_, _ ("Invalid name"), _tmp73_, GTK_MESSAGE_ERROR);
		_g_object_unref0 (_tmp72_);
		_g_free0 (msg);
		_g_free0 (branchname);
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (pn);
		_g_free0 (prefix);
		_g_free0 (orig);
		return;
	}
	_tmp74_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, ggit_branch_get_type ()) ? ((GgitBranch*) _tmp75_) : NULL);
	branch = _tmp76_;
	new_ref = NULL;
	{
		GgitBranch* _tmp77_;
		_tmp77_ = branch;
		if (_tmp77_ != NULL) {
			GgitBranch* _tmp78_ = NULL;
			GgitBranch* _tmp79_;
			GgitBranch* _tmp80_;
			GitgRef* _tmp81_;
			_tmp79_ = branch;
			_tmp80_ = ggit_branch_move (_tmp79_, new_text, GGIT_CREATE_NONE, &_inner_error0_);
			_tmp78_ = _tmp80_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, GITG_TYPE_REF) ? ((GitgRef*) _tmp78_) : NULL);
			_g_object_unref0 (new_ref);
			new_ref = _tmp81_;
			_g_object_unref0 (_tmp78_);
		} else {
			gchar* msg = NULL;
			GitgRef* _tmp82_;
			GitgRef* _tmp83_;
			const gchar* _tmp84_;
			gchar* _tmp85_;
			GgitRef* _tmp86_ = NULL;
			GitgRef* _tmp87_;
			GitgRef* _tmp88_;
			const gchar* _tmp89_;
			GgitRef* _tmp90_;
			GitgRef* _tmp91_;
			_tmp82_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
			_tmp83_ = _tmp82_;
			_tmp84_ = ggit_ref_get_name ((GgitRef*) _tmp83_);
			_tmp85_ = g_strdup_printf ("rename: ref %s to %s", _tmp84_, new_text);
			msg = _tmp85_;
			_tmp87_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = msg;
			_tmp90_ = ggit_ref_rename ((GgitRef*) _tmp88_, new_text, FALSE, _tmp89_, &_inner_error0_);
			_tmp86_ = _tmp90_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (msg);
				goto __catch1_g_error;
			}
			_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, GITG_TYPE_REF) ? ((GitgRef*) _tmp86_) : NULL);
			_g_object_unref0 (new_ref);
			new_ref = _tmp91_;
			_g_object_unref0 (_tmp86_);
			_g_free0 (msg);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GitgExtRefActionInterface* _tmp92_;
		GitgExtRefActionInterface* _tmp93_;
		GitgExtApplication* _tmp94_;
		GitgExtApplication* _tmp95_;
		GitgExtApplication* _tmp96_;
		GError* _tmp97_;
		const gchar* _tmp98_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp92_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
		_tmp93_ = _tmp92_;
		_tmp94_ = gitg_ext_ref_action_interface_get_application (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = _tmp95_;
		_tmp97_ = e;
		_tmp98_ = _tmp97_->message;
		gitg_ext_application_show_infobar (_tmp96_, _ ("Failed to rename"), _tmp98_, GTK_MESSAGE_ERROR);
		_g_object_unref0 (_tmp96_);
		_g_error_free0 (e);
		_g_object_unref0 (new_ref);
		_g_object_unref0 (branch);
		_g_free0 (branchname);
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (pn);
		_g_free0 (prefix);
		_g_free0 (orig);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (new_ref);
		_g_object_unref0 (branch);
		_g_free0 (branchname);
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (pn);
		_g_free0 (prefix);
		_g_free0 (orig);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp99_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
	_tmp100_ = _tmp99_;
	_tmp101_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp102_ = _tmp101_;
	_tmp103_ = new_ref;
	gitg_ext_ref_action_interface_replace_ref (_tmp100_, _tmp102_, _tmp103_);
	_g_object_unref0 (new_ref);
	_g_object_unref0 (branch);
	_g_free0 (branchname);
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (pn);
	_g_free0 (prefix);
	_g_free0 (orig);
}

static GitgExtApplication*
gitg_ref_action_rename_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgRefActionRename* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgRefActionRename*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_ref_action_rename_real_set_application (GitgExtUIElement* base,
                                             GitgExtApplication* value)
{
	GitgRefActionRename* self;
	GitgExtApplication* old_value;
	self = (GitgRefActionRename*) base;
	old_value = gitg_ref_action_rename_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtRefActionInterface*
gitg_ref_action_rename_real_get_action_interface (GitgExtRefAction* base)
{
	GitgExtRefActionInterface* result;
	GitgRefActionRename* self;
	GitgExtRefActionInterface* _tmp0_;
	self = (GitgRefActionRename*) base;
	_tmp0_ = self->priv->_action_interface;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_rename_real_set_action_interface (GitgExtRefAction* base,
                                                  GitgExtRefActionInterface* value)
{
	GitgRefActionRename* self;
	GitgExtRefActionInterface* old_value;
	self = (GitgRefActionRename*) base;
	old_value = gitg_ref_action_rename_real_get_action_interface (base);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_ACTION_INTERFACE_PROPERTY]);
	}
}

static GitgRef*
gitg_ref_action_rename_real_get_reference (GitgExtRefAction* base)
{
	GitgRef* result;
	GitgRefActionRename* self;
	GitgRef* _tmp0_;
	self = (GitgRefActionRename*) base;
	_tmp0_ = self->priv->_reference;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_rename_real_set_reference (GitgExtRefAction* base,
                                           GitgRef* value)
{
	GitgRefActionRename* self;
	GitgRef* old_value;
	self = (GitgRefActionRename*) base;
	old_value = gitg_ref_action_rename_real_get_reference (base);
	if (old_value != value) {
		GitgRef* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_reference);
		self->priv->_reference = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_REFERENCE_PROPERTY]);
	}
}

static gchar*
gitg_ref_action_rename_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionRename* self;
	gchar* _tmp0_;
	self = (GitgRefActionRename*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/ref-actions/rename");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_ref_action_rename_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionRename* self;
	gchar* _tmp0_;
	self = (GitgRefActionRename*) base;
	_tmp0_ = g_strdup (_ ("Rename"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_ref_action_rename_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionRename* self;
	gchar* _tmp0_;
	self = (GitgRefActionRename*) base;
	_tmp0_ = g_strdup (_ ("Rename the selected reference"));
	result = _tmp0_;
	return result;
}

static gboolean
gitg_ref_action_rename_real_get_enabled (GitgExtUIElement* base)
{
	gboolean result;
	GitgRefActionRename* self;
	gboolean _tmp0_ = FALSE;
	GitgRef* _tmp1_;
	GitgRef* _tmp2_;
	self = (GitgRefActionRename*) base;
	_tmp1_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp2_ = _tmp1_;
	if (ggit_ref_is_branch ((GgitRef*) _tmp2_)) {
		_tmp0_ = TRUE;
	} else {
		GitgRef* _tmp3_;
		GitgRef* _tmp4_;
		_tmp3_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = ggit_ref_is_tag ((GgitRef*) _tmp4_);
	}
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_rename_class_init (GitgRefActionRenameClass * klass,
                                   gpointer klass_data)
{
	gitg_ref_action_rename_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRefActionRename_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_ref_action_rename_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_ref_action_rename_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_ref_action_rename_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_RENAME_APPLICATION_PROPERTY, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_RENAME_ACTION_INTERFACE_PROPERTY, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_RENAME_REFERENCE_PROPERTY, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_REFERENCE_PROPERTY] = g_param_spec_object ("reference", "reference", "reference", GITG_TYPE_REF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_RENAME_ID_PROPERTY, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_RENAME_DISPLAY_NAME_PROPERTY, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_RENAME_DESCRIPTION_PROPERTY, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_RENAME_ENABLED_PROPERTY, gitg_ref_action_rename_properties[GITG_REF_ACTION_RENAME_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_ref_action_rename_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                           gpointer iface_data)
{
	gitg_ref_action_rename_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (GitgExtUIElement*)) gitg_ref_action_rename_real_activate;
	iface->get_application = gitg_ref_action_rename_real_get_application;
	iface->set_application = gitg_ref_action_rename_real_set_application;
	iface->get_id = gitg_ref_action_rename_real_get_id;
	iface->get_display_name = gitg_ref_action_rename_real_get_display_name;
	iface->get_description = gitg_ref_action_rename_real_get_description;
	iface->get_enabled = gitg_ref_action_rename_real_get_enabled;
}

static void
gitg_ref_action_rename_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                       gpointer iface_data)
{
	gitg_ref_action_rename_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gitg_ref_action_rename_gitg_ext_ref_action_interface_init (GitgExtRefActionIface * iface,
                                                           gpointer iface_data)
{
	gitg_ref_action_rename_gitg_ext_ref_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_action_interface = gitg_ref_action_rename_real_get_action_interface;
	iface->set_action_interface = gitg_ref_action_rename_real_set_action_interface;
	iface->get_reference = gitg_ref_action_rename_real_get_reference;
	iface->set_reference = gitg_ref_action_rename_real_set_reference;
}

static void
gitg_ref_action_rename_instance_init (GitgRefActionRename * self,
                                      gpointer klass)
{
	self->priv = gitg_ref_action_rename_get_instance_private (self);
}

static void
gitg_ref_action_rename_finalize (GObject * obj)
{
	GitgRefActionRename * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REF_ACTION_RENAME, GitgRefActionRename);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	_g_object_unref0 (self->priv->_reference);
	G_OBJECT_CLASS (gitg_ref_action_rename_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_ref_action_rename_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRefActionRenameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ref_action_rename_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRefActionRename), 0, (GInstanceInitFunc) gitg_ref_action_rename_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_ref_action_rename_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_ref_action_rename_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_ref_action_info = { (GInterfaceInitFunc) gitg_ref_action_rename_gitg_ext_ref_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_ref_action_rename_type_id;
	gitg_ref_action_rename_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgRefActionRename", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_ref_action_rename_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_ref_action_rename_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	g_type_add_interface_static (gitg_ref_action_rename_type_id, GITG_EXT_TYPE_REF_ACTION, &gitg_ext_ref_action_info);
	GitgRefActionRename_private_offset = g_type_add_instance_private (gitg_ref_action_rename_type_id, sizeof (GitgRefActionRenamePrivate));
	return gitg_ref_action_rename_type_id;
}

GType
gitg_ref_action_rename_get_type (void)
{
	static gsize gitg_ref_action_rename_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_action_rename_type_id__once)) {
		GType gitg_ref_action_rename_type_id;
		gitg_ref_action_rename_type_id = gitg_ref_action_rename_get_type_once ();
		g_once_init_leave (&gitg_ref_action_rename_type_id__once, gitg_ref_action_rename_type_id);
	}
	return gitg_ref_action_rename_type_id__once;
}

static void
_vala_gitg_ref_action_rename_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GitgRefActionRename * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_RENAME, GitgRefActionRename);
	switch (property_id) {
		case GITG_REF_ACTION_RENAME_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_RENAME_ACTION_INTERFACE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_RENAME_REFERENCE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_RENAME_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_RENAME_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_RENAME_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_RENAME_ENABLED_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_ref_action_rename_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GitgRefActionRename * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_RENAME, GitgRefActionRename);
	switch (property_id) {
		case GITG_REF_ACTION_RENAME_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_RENAME_ACTION_INTERFACE_PROPERTY:
		gitg_ext_ref_action_set_action_interface ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_RENAME_REFERENCE_PROPERTY:
		gitg_ext_ref_action_set_reference ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

