/* gitg-commit-action-cherry-pick.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-commit-action-cherry-pick.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include "libgitg.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gee.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>

#define GITG_COMMIT_ACTION_CHERRY_PICK_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_COMMIT_ACTION_CHERRY_PICK (gitg_commit_action_cherry_pick_get_type ())
#define GITG_COMMIT_ACTION_CHERRY_PICK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPick))
#define GITG_COMMIT_ACTION_CHERRY_PICK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPickClass))
#define GITG_IS_COMMIT_ACTION_CHERRY_PICK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK))
#define GITG_IS_COMMIT_ACTION_CHERRY_PICK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK))
#define GITG_COMMIT_ACTION_CHERRY_PICK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPickClass))

typedef struct _GitgCommitActionCherryPick GitgCommitActionCherryPick;
typedef struct _GitgCommitActionCherryPickClass GitgCommitActionCherryPickClass;
typedef struct _GitgCommitActionCherryPickPrivate GitgCommitActionCherryPickPrivate;

#define GITG_TYPE_ACTION_SUPPORT (gitg_action_support_get_type ())
#define GITG_ACTION_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_ACTION_SUPPORT, GitgActionSupport))
#define GITG_ACTION_SUPPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_ACTION_SUPPORT, GitgActionSupportClass))
#define GITG_IS_ACTION_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_ACTION_SUPPORT))
#define GITG_IS_ACTION_SUPPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_ACTION_SUPPORT))
#define GITG_ACTION_SUPPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_ACTION_SUPPORT, GitgActionSupportClass))

typedef struct _GitgActionSupport GitgActionSupport;
typedef struct _GitgActionSupportClass GitgActionSupportClass;
enum  {
	GITG_COMMIT_ACTION_CHERRY_PICK_0_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_APPLICATION_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_ACTION_INTERFACE_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_COMMIT_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_ID_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_DISPLAY_NAME_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_DESCRIPTION_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_AVAILABLE_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_ENABLED_PROPERTY,
	GITG_COMMIT_ACTION_CHERRY_PICK_NUM_PROPERTIES
};
static GParamSpec* gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_SIMPLE_NOTIFICATION (gitg_simple_notification_get_type ())
#define GITG_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotification))
#define GITG_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))
#define GITG_IS_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_IS_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_SIMPLE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))

typedef struct _GitgSimpleNotification GitgSimpleNotification;
typedef struct _GitgSimpleNotificationClass GitgSimpleNotificationClass;
typedef struct _Block5Data Block5Data;
#define __vala_GgitMergeOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitMergeOptions_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgCommitActionCherryPickCreateIndexData GitgCommitActionCherryPickCreateIndexData;
typedef struct _GitgCommitActionCherryPickCheckoutConflictsData GitgCommitActionCherryPickCheckoutConflictsData;
typedef struct _GitgCommitActionCherryPickCherryPickData GitgCommitActionCherryPickCherryPickData;
typedef struct _Block6Data Block6Data;

struct _GitgCommitActionCherryPick {
	GObject parent_instance;
	GitgCommitActionCherryPickPrivate * priv;
};

struct _GitgCommitActionCherryPickClass {
	GObjectClass parent_class;
};

struct _GitgCommitActionCherryPickPrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
	GitgCommit* _commit;
	GitgRef** d_destinations;
	gint d_destinations_length1;
	gint _d_destinations_size_;
	GitgActionSupport* d_support;
};

struct _Block5Data {
	int _ref_count_;
	GitgCommitActionCherryPick* self;
	GitgCommit* theirs;
	GgitMergeOptions* merge_options;
	GgitIndex* index;
	gpointer _async_data_;
};

struct _GitgCommitActionCherryPickCreateIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgCommitActionCherryPick* self;
	GitgSimpleNotification* notification;
	GitgRef* destination;
	GgitIndex* result;
	Block5Data* _data5_;
	gchar* theirs_name;
	GitgParsedRefName* _tmp0_;
	GitgParsedRefName* _tmp1_;
	GitgParsedRefName* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GgitObject* _tmp6_;
	GgitObject* _tmp7_;
	GitgCommit* _tmp8_;
	GError* e;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GgitMergeOptions* _tmp14_;
	GError* _vala1_e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GgitIndex* _tmp19_;
	GgitIndex* _tmp20_;
	GError* _inner_error0_;
};

struct _GitgCommitActionCherryPickCheckoutConflictsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgCommitActionCherryPick* self;
	GitgSimpleNotification* notification;
	GgitIndex* index;
	GitgRef* destination;
	gboolean result;
	gchar* ours_name;
	GitgCommit* _tmp0_;
	GitgCommit* _tmp1_;
	GgitOId* _tmp2_;
	GgitOId* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* theirs_name;
	GitgParsedRefName* _tmp8_;
	GitgParsedRefName* _tmp9_;
	GitgParsedRefName* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GitgRef* head;
	gboolean ishead;
	GitgActionSupport* _tmp14_;
	gboolean _tmp15_;
	gchar* message;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GitgExtUserQuery* q;
	const gchar* _tmp23_;
	GitgExtUserQuery* _tmp24_;
	GitgExtApplication* _tmp25_;
	GitgExtApplication* _tmp26_;
	GitgExtApplication* _tmp27_;
	GitgExtUserQuery* _tmp28_;
	gboolean _tmp29_;
	GitgActionSupport* _tmp30_;
	GitgRef* _tmp31_;
};

struct _GitgCommitActionCherryPickCherryPickData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgCommitActionCherryPick* self;
	GitgRef* destination;
	GgitOId* id;
	GitgCommit* _tmp0_;
	GitgCommit* _tmp1_;
	GgitOId* _tmp2_;
	gchar* shortid;
	GgitOId* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* name;
	GitgParsedRefName* _tmp8_;
	GitgParsedRefName* _tmp9_;
	GitgParsedRefName* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GitgSimpleNotification* notification;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GitgSimpleNotification* _tmp18_;
	GitgSimpleNotification* _tmp19_;
	GitgExtApplication* _tmp20_;
	GitgExtApplication* _tmp21_;
	GitgExtApplication* _tmp22_;
	GitgExtNotifications* _tmp23_;
	GitgExtNotifications* _tmp24_;
	GitgExtNotifications* _tmp25_;
	GitgSimpleNotification* _tmp26_;
	GgitIndex* index;
	GitgSimpleNotification* _tmp27_;
	GgitIndex* _tmp28_;
	GgitIndex* _tmp29_;
	GgitIndex* _tmp30_;
	GitgSimpleNotification* _tmp31_;
	GgitIndex* _tmp32_;
	GgitOId* oid;
	GitgActionSupport* _tmp33_;
	GitgSimpleNotification* _tmp34_;
	GgitIndex* _tmp35_;
	GitgCommit* _tmp36_;
	GitgCommit* _tmp37_;
	GgitSignature* _tmp38_;
	GgitSignature* _tmp39_;
	GitgCommit* _tmp40_;
	GitgCommit* _tmp41_;
	const gchar* _tmp42_;
	GgitOId* _tmp43_;
	GgitOId* _tmp44_;
	GgitOId* _tmp45_;
	GitgSimpleNotification* _tmp46_;
};

struct _Block6Data {
	int _ref_count_;
	GitgCommitActionCherryPick* self;
	GitgRef* dest;
};

static gint GitgCommitActionCherryPick_private_offset;
static gpointer gitg_commit_action_cherry_pick_parent_class = NULL;
static GitgExtUIElementIface * gitg_commit_action_cherry_pick_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_commit_action_cherry_pick_gitg_ext_action_parent_iface = NULL;
static GitgExtCommitActionIface * gitg_commit_action_cherry_pick_gitg_ext_commit_action_parent_iface = NULL;

VALA_EXTERN GType gitg_commit_action_cherry_pick_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgCommitActionCherryPick, g_object_unref)
VALA_EXTERN GType gitg_action_support_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgActionSupport, g_object_unref)
VALA_EXTERN GitgCommitActionCherryPick* gitg_commit_action_cherry_pick_new (GitgExtApplication* application,
                                                                GitgExtRefActionInterface* action_interface,
                                                                GitgCommit* commit);
VALA_EXTERN GitgCommitActionCherryPick* gitg_commit_action_cherry_pick_construct (GType object_type,
                                                                      GitgExtApplication* application,
                                                                      GitgExtRefActionInterface* action_interface,
                                                                      GitgCommit* commit);
VALA_EXTERN GitgActionSupport* gitg_action_support_new (GitgExtApplication* application,
                                            GitgExtRefActionInterface* action_interface);
VALA_EXTERN GitgActionSupport* gitg_action_support_construct (GType object_type,
                                                  GitgExtApplication* application,
                                                  GitgExtRefActionInterface* action_interface);
static void gitg_commit_action_cherry_pick_ensure_destinations (GitgCommitActionCherryPick* self);
static void _vala_GgitOId_free (GgitOId* self);
static void _vala_array_add1 (GitgRef** * array,
                       gint* length,
                       gint* size,
                       GitgRef* value);
static void gitg_commit_action_cherry_pick_create_index_data_free (gpointer _data);
VALA_EXTERN GType gitg_simple_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgSimpleNotification, g_object_unref)
static void gitg_commit_action_cherry_pick_create_index (GitgCommitActionCherryPick* self,
                                                  GitgSimpleNotification* notification,
                                                  GitgRef* destination,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static GgitIndex* gitg_commit_action_cherry_pick_create_index_finish (GitgCommitActionCherryPick* self,
                                                               GAsyncResult* _res_);
static gboolean gitg_commit_action_cherry_pick_create_index_co (GitgCommitActionCherryPickCreateIndexData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void _vala_GgitMergeOptions_free (GgitMergeOptions* self);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN void gitg_simple_notification_error (GitgSimpleNotification* self,
                                     const gchar* message);
static void ___lambda20_ (Block5Data* _data5_,
                   GError** error);
static void ____lambda20__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_commit_action_cherry_pick_create_index_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void gitg_commit_action_cherry_pick_checkout_conflicts_data_free (gpointer _data);
static void gitg_commit_action_cherry_pick_checkout_conflicts (GitgCommitActionCherryPick* self,
                                                        GitgSimpleNotification* notification,
                                                        GgitIndex* index,
                                                        GitgRef* destination,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean gitg_commit_action_cherry_pick_checkout_conflicts_finish (GitgCommitActionCherryPick* self,
                                                                   GAsyncResult* _res_);
static gboolean gitg_commit_action_cherry_pick_checkout_conflicts_co (GitgCommitActionCherryPickCheckoutConflictsData* _data_);
VALA_EXTERN void gitg_simple_notification_set_message (GitgSimpleNotification* self,
                                           const gchar* value);
VALA_EXTERN gboolean gitg_action_support_reference_is_head (GitgActionSupport* self,
                                                GitgRef* reference,
                                                GitgRef** head);
static void gitg_commit_action_cherry_pick_checkout_conflicts_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
VALA_EXTERN void gitg_action_support_checkout_conflicts (GitgActionSupport* self,
                                             GitgSimpleNotification* notification,
                                             GitgRef* reference,
                                             GgitIndex* index,
                                             GitgRef* head,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN gboolean gitg_action_support_checkout_conflicts_finish (GitgActionSupport* self,
                                                        GAsyncResult* _res_);
static void gitg_commit_action_cherry_pick_write_cherry_pick_state_files (GitgCommitActionCherryPick* self);
VALA_EXTERN void gitg_simple_notification_success (GitgSimpleNotification* self,
                                       const gchar* message);
static void gitg_commit_action_cherry_pick_cherry_pick_data_free (gpointer _data);
VALA_EXTERN void gitg_commit_action_cherry_pick_cherry_pick (GitgCommitActionCherryPick* self,
                                                 GitgRef* destination,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void gitg_commit_action_cherry_pick_cherry_pick_finish (GitgCommitActionCherryPick* self,
                                                        GAsyncResult* _res_);
static gboolean gitg_commit_action_cherry_pick_cherry_pick_co (GitgCommitActionCherryPickCherryPickData* _data_);
VALA_EXTERN GitgSimpleNotification* gitg_simple_notification_new (const gchar* title,
                                                      const gchar* message);
VALA_EXTERN GitgSimpleNotification* gitg_simple_notification_construct (GType object_type,
                                                            const gchar* title,
                                                            const gchar* message);
static void gitg_commit_action_cherry_pick_cherry_pick_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
VALA_EXTERN void gitg_action_support_commit_index (GitgActionSupport* self,
                                       GitgSimpleNotification* notification,
                                       GitgRef* reference,
                                       GgitIndex* index,
                                       GgitOId** parents,
                                       gint parents_length1,
                                       GgitSignature* author,
                                       const gchar* message,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN GgitOId* gitg_action_support_commit_index_finish (GitgActionSupport* self,
                                                  GAsyncResult* _res_);
static void gitg_commit_action_cherry_pick_activate_destination (GitgCommitActionCherryPick* self,
                                                          GitgRef* destination);
static void __lambda21_ (GitgCommitActionCherryPick* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda21__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void gitg_commit_action_cherry_pick_real_populate_menu (GitgExtAction* base,
                                                        GtkMenu* menu);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ____lambda22_ (Block6Data* _data6_);
static void _____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void gitg_commit_action_cherry_pick_real_activate (GitgExtUIElement* base);
static void gitg_commit_action_cherry_pick_finalize (GObject * obj);
static GType gitg_commit_action_cherry_pick_get_type_once (void);
static void _vala_gitg_commit_action_cherry_pick_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_gitg_commit_action_cherry_pick_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_commit_action_cherry_pick_get_instance_private (GitgCommitActionCherryPick* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCommitActionCherryPick_private_offset);
}

GitgCommitActionCherryPick*
gitg_commit_action_cherry_pick_construct (GType object_type,
                                          GitgExtApplication* application,
                                          GitgExtRefActionInterface* action_interface,
                                          GitgCommit* commit)
{
	GitgCommitActionCherryPick * self = NULL;
	GitgActionSupport* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	g_return_val_if_fail (commit != NULL, NULL);
	self = (GitgCommitActionCherryPick*) g_object_new (object_type, "application", application, "action-interface", action_interface, "commit", commit, NULL);
	_tmp0_ = gitg_action_support_new (application, action_interface);
	_g_object_unref0 (self->priv->d_support);
	self->priv->d_support = _tmp0_;
	return self;
}

GitgCommitActionCherryPick*
gitg_commit_action_cherry_pick_new (GitgExtApplication* application,
                                    GitgExtRefActionInterface* action_interface,
                                    GitgCommit* commit)
{
	return gitg_commit_action_cherry_pick_construct (GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, application, action_interface, commit);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
_vala_array_add1 (GitgRef** * array,
                  gint* length,
                  gint* size,
                  GitgRef* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
gitg_commit_action_cherry_pick_ensure_destinations (GitgCommitActionCherryPick* self)
{
	GitgRef** _tmp0_;
	gint _tmp0__length1;
	GitgRef** _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_destinations;
	_tmp0__length1 = self->priv->d_destinations_length1;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_new0 (GitgRef*, 0 + 1);
	self->priv->d_destinations = (_vala_array_free (self->priv->d_destinations, self->priv->d_destinations_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_destinations = _tmp1_;
	self->priv->d_destinations_length1 = 0;
	self->priv->_d_destinations_size_ = self->priv->d_destinations_length1;
	{
		GeeList* _r_list = NULL;
		GitgExtRefActionInterface* _tmp2_;
		GitgExtRefActionInterface* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		gint _r_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _r_index = 0;
		_tmp2_ = gitg_ext_commit_action_get_action_interface ((GitgExtCommitAction*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gitg_ext_ref_action_interface_get_references (_tmp3_);
		_tmp5_ = _tmp4_;
		_r_list = _tmp5_;
		_tmp6_ = _r_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_r_size = _tmp8_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			GitgRef* r = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			GitgRef* _tmp13_;
			_r_index = _r_index + 1;
			_tmp9_ = _r_index;
			_tmp10_ = _r_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _r_list;
			_tmp12_ = gee_list_get (_tmp11_, _r_index);
			r = (GitgRef*) _tmp12_;
			_tmp13_ = r;
			if (ggit_ref_is_branch ((GgitRef*) _tmp13_)) {
				{
					GgitObject* _tmp14_ = NULL;
					GitgRef* _tmp15_;
					GgitObject* _tmp16_;
					GgitCommit* c = NULL;
					GgitCommit* _tmp17_;
					GgitCommit* _tmp18_;
					GgitOId* _tmp19_;
					GgitOId* _tmp20_;
					GitgCommit* _tmp21_;
					GitgCommit* _tmp22_;
					GgitOId* _tmp23_;
					GgitOId* _tmp24_;
					gboolean _tmp25_;
					_tmp15_ = r;
					_tmp16_ = ggit_ref_lookup ((GgitRef*) _tmp15_, &_inner_error0_);
					_tmp14_ = _tmp16_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, ggit_commit_get_type ()) ? ((GgitCommit*) _tmp14_) : NULL);
					c = _tmp17_;
					_tmp18_ = c;
					_tmp19_ = ggit_object_get_id ((GgitObject*) _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
					_tmp22_ = _tmp21_;
					_tmp23_ = ggit_object_get_id ((GgitObject*) _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = !ggit_oid_equal (_tmp20_, _tmp24_);
					__vala_GgitOId_free0 (_tmp24_);
					__vala_GgitOId_free0 (_tmp20_);
					if (_tmp25_) {
						GitgRef* _tmp26_;
						GitgRef* _tmp27_;
						_tmp26_ = r;
						_tmp27_ = _g_object_ref0 (_tmp26_);
						_vala_array_add1 (&self->priv->d_destinations, &self->priv->d_destinations_length1, &self->priv->_d_destinations_size_, _tmp27_);
					}
					_g_object_unref0 (c);
					_g_object_unref0 (_tmp14_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (r);
					_g_object_unref0 (_r_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_list);
	}
}

static void
gitg_commit_action_cherry_pick_create_index_data_free (gpointer _data)
{
	GitgCommitActionCherryPickCreateIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notification);
	_g_object_unref0 (_data_->destination);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgCommitActionCherryPickCreateIndexData, _data_);
}

static void
gitg_commit_action_cherry_pick_create_index (GitgCommitActionCherryPick* self,
                                             GitgSimpleNotification* notification,
                                             GitgRef* destination,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GitgCommitActionCherryPickCreateIndexData* _data_;
	GitgCommitActionCherryPick* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GitgRef* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_return_if_fail (destination != NULL);
	_data_ = g_slice_new0 (GitgCommitActionCherryPickCreateIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_commit_action_cherry_pick_create_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (destination);
	_g_object_unref0 (_data_->destination);
	_data_->destination = _tmp2_;
	gitg_commit_action_cherry_pick_create_index_co (_data_);
}

static GgitIndex*
gitg_commit_action_cherry_pick_create_index_finish (GitgCommitActionCherryPick* self,
                                                    GAsyncResult* _res_)
{
	GgitIndex* result;
	GitgCommitActionCherryPickCreateIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
_vala_GgitMergeOptions_free (GgitMergeOptions* self)
{
	g_boxed_free (ggit_merge_options_get_type (), self);
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GitgCommitActionCherryPick* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->index);
		__vala_GgitMergeOptions_free0 (_data5_->merge_options);
		_g_object_unref0 (_data5_->theirs);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda20_ (Block5Data* _data5_,
              GError** error)
{
	GitgCommitActionCherryPick* self;
	GgitIndex* _tmp0_ = NULL;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgExtApplication* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GitgRepository* _tmp6_;
	GitgCommit* _tmp7_;
	GitgCommit* _tmp8_;
	GitgCommit* _tmp9_;
	GgitMergeOptions* _tmp10_;
	GgitIndex* _tmp11_;
	GgitIndex* _tmp12_;
	GgitIndex* _tmp13_;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	_tmp1_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_ext_application_get_repository (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _data5_->theirs;
	_tmp10_ = _data5_->merge_options;
	_tmp11_ = ggit_repository_cherry_pick_commit ((GgitRepository*) _tmp6_, (GgitCommit*) _tmp8_, (GgitCommit*) _tmp9_, (guint) 0, _tmp10_, &_inner_error0_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	_tmp0_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp13_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (_data5_->index);
	_data5_->index = _tmp13_;
	_g_object_unref0 (_tmp0_);
}

static void
____lambda20__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda20_ (self, error);
}

static void
gitg_commit_action_cherry_pick_create_index_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	GitgCommitActionCherryPickCreateIndexData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_commit_action_cherry_pick_create_index_co (_data_);
}

static gboolean
gitg_commit_action_cherry_pick_create_index_co (GitgCommitActionCherryPickCreateIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	_data_->_data5_->theirs = NULL;
	_data_->_tmp0_ = gitg_ref_get_parsed_name (_data_->destination);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->theirs_name = _data_->_tmp5_;
	{
		_data_->_tmp7_ = ggit_ref_lookup ((GgitRef*) _data_->destination, &_data_->_inner_error0_);
		_data_->_tmp6_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, GITG_TYPE_COMMIT) ? ((GitgCommit*) _data_->_tmp6_) : NULL);
		_g_object_unref0 (_data_->_data5_->theirs);
		_data_->_data5_->theirs = _data_->_tmp8_;
		_g_object_unref0 (_data_->_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->theirs_name;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		_data_->_tmp12_ = g_strdup_printf (_ ("Failed to lookup the commit for branch “%s”: %s"), _data_->_tmp9_, _data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		gitg_simple_notification_error (_data_->notification, _data_->_tmp13_);
		_g_free0 (_data_->_tmp13_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_free0 (_data_->theirs_name);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->theirs_name);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = ggit_merge_options_new ();
	_data_->_data5_->merge_options = _data_->_tmp14_;
	_data_->_data5_->index = NULL;
	{
		_data_->_state_ = 1;
		gitg_async_thread (____lambda20__gitg_async_thread_func, _data_->_data5_, gitg_commit_action_cherry_pick_create_index_ready, _data_);
		return FALSE;
		_state_1:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->_vala1_e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		_data_->_tmp17_ = g_strdup_printf (_ ("Failed to cherry-pick the commit: %s"), _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		gitg_simple_notification_error (_data_->notification, _data_->_tmp18_);
		_g_free0 (_data_->_tmp18_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_vala1_e);
		_g_free0 (_data_->theirs_name);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->theirs_name);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->_data5_->index;
	_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
	_data_->result = _data_->_tmp20_;
	_g_free0 (_data_->theirs_name);
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_commit_action_cherry_pick_checkout_conflicts_data_free (gpointer _data)
{
	GitgCommitActionCherryPickCheckoutConflictsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notification);
	_g_object_unref0 (_data_->index);
	_g_object_unref0 (_data_->destination);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgCommitActionCherryPickCheckoutConflictsData, _data_);
}

static void
gitg_commit_action_cherry_pick_checkout_conflicts (GitgCommitActionCherryPick* self,
                                                   GitgSimpleNotification* notification,
                                                   GgitIndex* index,
                                                   GitgRef* destination,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GitgCommitActionCherryPickCheckoutConflictsData* _data_;
	GitgCommitActionCherryPick* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GgitIndex* _tmp2_;
	GitgRef* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_return_if_fail (index != NULL);
	g_return_if_fail (destination != NULL);
	_data_ = g_slice_new0 (GitgCommitActionCherryPickCheckoutConflictsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_commit_action_cherry_pick_checkout_conflicts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (index);
	_g_object_unref0 (_data_->index);
	_data_->index = _tmp2_;
	_tmp3_ = _g_object_ref0 (destination);
	_g_object_unref0 (_data_->destination);
	_data_->destination = _tmp3_;
	gitg_commit_action_cherry_pick_checkout_conflicts_co (_data_);
}

static gboolean
gitg_commit_action_cherry_pick_checkout_conflicts_finish (GitgCommitActionCherryPick* self,
                                                          GAsyncResult* _res_)
{
	gboolean result;
	GitgCommitActionCherryPickCheckoutConflictsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
gitg_commit_action_cherry_pick_checkout_conflicts_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GitgCommitActionCherryPickCheckoutConflictsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_commit_action_cherry_pick_checkout_conflicts_co (_data_);
}

static gboolean
gitg_commit_action_cherry_pick_checkout_conflicts_co (GitgCommitActionCherryPickCheckoutConflictsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = ggit_object_get_id ((GgitObject*) _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = ggit_oid_to_string (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = string_slice (_data_->_tmp5_, (glong) 0, (glong) 6);
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	__vala_GgitOId_free0 (_data_->_tmp3_);
	_data_->ours_name = _data_->_tmp7_;
	_data_->_tmp8_ = gitg_ref_get_parsed_name (_data_->destination);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp10_);
	_data_->theirs_name = _data_->_tmp13_;
	gitg_simple_notification_set_message (_data_->notification, _ ("Cherry pick has conflicts"));
	_data_->head = NULL;
	_data_->_tmp14_ = _data_->self->priv->d_support;
	_data_->_tmp15_ = gitg_action_support_reference_is_head (_data_->_tmp14_, _data_->destination, &_data_->head);
	_data_->ishead = _data_->_tmp15_;
	if (_data_->ishead) {
		_data_->_tmp16_ = _data_->ours_name;
		_data_->_tmp17_ = _data_->theirs_name;
		_data_->_tmp18_ = _data_->theirs_name;
		_data_->_tmp19_ = g_strdup_printf (_ ("The cherry pick of “%s” onto “%s” has caused conflicts, would you like" \
" to checkout branch “%s” with the cherry pick to your working director" \
"y to resolve the conflicts?"), _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp19_;
	} else {
		_data_->_tmp20_ = _data_->ours_name;
		_data_->_tmp21_ = _data_->theirs_name;
		_data_->_tmp22_ = g_strdup_printf (_ ("The cherry-pick of “%s” onto “%s” has caused conflicts, would you like" \
" to checkout the cherry pick to your working directory to resolve the " \
"conflicts?"), _data_->_tmp20_, _data_->_tmp21_);
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp22_;
	}
	_data_->_tmp23_ = _data_->message;
	_data_->_tmp24_ = gitg_ext_user_query_new_full (_ ("Cherry pick has conflicts"), _data_->_tmp23_, GTK_MESSAGE_QUESTION, _ ("Cancel"), GTK_RESPONSE_CANCEL, _ ("Checkout"), GTK_RESPONSE_OK, NULL);
	_data_->q = _data_->_tmp24_;
	_data_->_tmp25_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = _data_->q;
	_data_->_state_ = 1;
	gitg_ext_application_user_query_async (_data_->_tmp27_, _data_->_tmp28_, gitg_commit_action_cherry_pick_checkout_conflicts_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp29_ = gitg_ext_application_user_query_finish (_data_->_tmp27_, _data_->_res_) != GTK_RESPONSE_OK;
	_g_object_unref0 (_data_->_tmp27_);
	if (_data_->_tmp29_) {
		gitg_simple_notification_error (_data_->notification, _ ("Cherry pick failed with conflicts"));
		_data_->result = FALSE;
		_g_object_unref0 (_data_->q);
		_g_free0 (_data_->message);
		_g_object_unref0 (_data_->head);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = _data_->self->priv->d_support;
	_data_->_tmp31_ = _data_->head;
	_data_->_state_ = 2;
	gitg_action_support_checkout_conflicts (_data_->_tmp30_, _data_->notification, _data_->destination, _data_->index, _data_->_tmp31_, gitg_commit_action_cherry_pick_checkout_conflicts_ready, _data_);
	return FALSE;
	_state_2:
	if (!gitg_action_support_checkout_conflicts_finish (_data_->_tmp30_, _data_->_res_)) {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->q);
		_g_free0 (_data_->message);
		_g_object_unref0 (_data_->head);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	gitg_commit_action_cherry_pick_write_cherry_pick_state_files (_data_->self);
	gitg_simple_notification_success (_data_->notification, _ ("Cherry pick finished with conflicts in working directory"));
	_data_->result = TRUE;
	_g_object_unref0 (_data_->q);
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->head);
	_g_free0 (_data_->theirs_name);
	_g_free0 (_data_->ours_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_commit_action_cherry_pick_write_cherry_pick_state_files (GitgCommitActionCherryPick* self)
{
	gchar* wd = NULL;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gitg_ext_application_get_repository (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	wd = _tmp9_;
	{
		gchar* _tmp10_;
		gchar* _tmp11_;
		GitgCommit* _tmp12_;
		GitgCommit* _tmp13_;
		GgitOId* _tmp14_;
		GgitOId* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp10_ = g_build_filename (wd, "CHERRY_PICK_HEAD", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = ggit_object_get_id ((GgitObject*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = ggit_oid_to_string (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%s\n", _tmp17_);
		_tmp19_ = _tmp18_;
		g_file_set_contents (_tmp11_, _tmp19_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		__vala_GgitOId_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (wd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (wd);
}

static void
gitg_commit_action_cherry_pick_cherry_pick_data_free (gpointer _data)
{
	GitgCommitActionCherryPickCherryPickData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->destination);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgCommitActionCherryPickCherryPickData, _data_);
}

void
gitg_commit_action_cherry_pick_cherry_pick (GitgCommitActionCherryPick* self,
                                            GitgRef* destination,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GitgCommitActionCherryPickCherryPickData* _data_;
	GitgCommitActionCherryPick* _tmp0_;
	GitgRef* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_data_ = g_slice_new0 (GitgCommitActionCherryPickCherryPickData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_commit_action_cherry_pick_cherry_pick_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (destination);
	_g_object_unref0 (_data_->destination);
	_data_->destination = _tmp1_;
	gitg_commit_action_cherry_pick_cherry_pick_co (_data_);
}

void
gitg_commit_action_cherry_pick_cherry_pick_finish (GitgCommitActionCherryPick* self,
                                                   GAsyncResult* _res_)
{
	GitgCommitActionCherryPickCherryPickData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gitg_commit_action_cherry_pick_cherry_pick_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GitgCommitActionCherryPickCherryPickData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_commit_action_cherry_pick_cherry_pick_co (_data_);
}

static gboolean
gitg_commit_action_cherry_pick_cherry_pick_co (GitgCommitActionCherryPickCherryPickData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = ggit_object_get_id ((GgitObject*) _data_->_tmp1_);
	_data_->id = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->id;
	_data_->_tmp4_ = ggit_oid_to_string (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = string_slice (_data_->_tmp5_, (glong) 0, (glong) 6);
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	_data_->shortid = _data_->_tmp7_;
	_data_->_tmp8_ = gitg_ref_get_parsed_name (_data_->destination);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp10_);
	_data_->name = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->shortid;
	_data_->_tmp15_ = _data_->name;
	_data_->_tmp16_ = g_strdup_printf (_ ("Cherry pick “%s” onto “%s”"), _data_->_tmp14_, _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = gitg_simple_notification_new (_data_->_tmp17_, NULL);
	g_object_ref_sink (_data_->_tmp18_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_g_free0 (_data_->_tmp17_);
	_data_->notification = _data_->_tmp19_;
	_data_->_tmp20_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = gitg_ext_application_get_notifications (_data_->_tmp22_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = _data_->notification;
	gitg_ext_notifications_add (_data_->_tmp25_, (GitgExtNotification*) _data_->_tmp26_);
	_g_object_unref0 (_data_->_tmp25_);
	_g_object_unref0 (_data_->_tmp22_);
	_data_->_tmp27_ = _data_->notification;
	_data_->_state_ = 1;
	gitg_commit_action_cherry_pick_create_index (_data_->self, _data_->_tmp27_, _data_->destination, gitg_commit_action_cherry_pick_cherry_pick_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp28_ = gitg_commit_action_cherry_pick_create_index_finish (_data_->self, _data_->_res_);
	_data_->index = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->index;
	if (_data_->_tmp29_ == NULL) {
		_g_object_unref0 (_data_->index);
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->name);
		_g_free0 (_data_->shortid);
		__vala_GgitOId_free0 (_data_->id);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = _data_->index;
	if (ggit_index_has_conflicts (_data_->_tmp30_)) {
		_data_->_tmp31_ = _data_->notification;
		_data_->_tmp32_ = _data_->index;
		_data_->_state_ = 2;
		gitg_commit_action_cherry_pick_checkout_conflicts (_data_->self, _data_->_tmp31_, _data_->_tmp32_, _data_->destination, gitg_commit_action_cherry_pick_cherry_pick_ready, _data_);
		return FALSE;
		_state_2:
		gitg_commit_action_cherry_pick_checkout_conflicts_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->index);
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->name);
		_g_free0 (_data_->shortid);
		__vala_GgitOId_free0 (_data_->id);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp33_ = _data_->self->priv->d_support;
	_data_->_tmp34_ = _data_->notification;
	_data_->_tmp35_ = _data_->index;
	_data_->_tmp36_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) _data_->self);
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = ggit_commit_get_author ((GgitCommit*) _data_->_tmp37_);
	_data_->_tmp39_ = _data_->_tmp38_;
	_data_->_tmp40_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) _data_->self);
	_data_->_tmp41_ = _data_->_tmp40_;
	_data_->_tmp42_ = ggit_commit_get_message ((GgitCommit*) _data_->_tmp41_);
	_data_->_state_ = 3;
	gitg_action_support_commit_index (_data_->_tmp33_, _data_->_tmp34_, _data_->destination, _data_->_tmp35_, NULL, (gint) 0, _data_->_tmp39_, _data_->_tmp42_, gitg_commit_action_cherry_pick_cherry_pick_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp43_ = gitg_action_support_commit_index_finish (_data_->_tmp33_, _data_->_res_);
	_data_->_tmp44_ = _data_->_tmp43_;
	_g_object_unref0 (_data_->_tmp39_);
	_data_->oid = _data_->_tmp44_;
	_data_->_tmp45_ = _data_->oid;
	if (_data_->_tmp45_ != NULL) {
		_data_->_tmp46_ = _data_->notification;
		gitg_simple_notification_success (_data_->_tmp46_, _ ("Successfully cherry picked"));
	}
	__vala_GgitOId_free0 (_data_->oid);
	_g_object_unref0 (_data_->index);
	_g_object_unref0 (_data_->notification);
	_g_free0 (_data_->name);
	_g_free0 (_data_->shortid);
	__vala_GgitOId_free0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda21_ (GitgCommitActionCherryPick* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	gitg_commit_action_cherry_pick_cherry_pick_finish (self, res);
}

static void
___lambda21__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda21_ ((GitgCommitActionCherryPick*) self, source_object, res);
	g_object_unref (self);
}

static void
gitg_commit_action_cherry_pick_activate_destination (GitgCommitActionCherryPick* self,
                                                     GitgRef* destination)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	gitg_commit_action_cherry_pick_cherry_pick (self, destination, ___lambda21__gasync_ready_callback, g_object_ref (self));
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GitgCommitActionCherryPick* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->dest);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
____lambda22_ (Block6Data* _data6_)
{
	GitgCommitActionCherryPick* self;
	GitgRef* _tmp0_;
	self = _data6_->self;
	_tmp0_ = _data6_->dest;
	gitg_commit_action_cherry_pick_activate_destination (self, _tmp0_);
}

static void
_____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda22_ (self);
}

static void
gitg_commit_action_cherry_pick_real_populate_menu (GitgExtAction* base,
                                                   GtkMenu* menu)
{
	GitgCommitActionCherryPick * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkMenuItem* item = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkMenuItem* _tmp13_;
	GtkMenu* submenu = NULL;
	GtkMenu* _tmp14_;
	GtkMenu* _tmp15_;
	GitgRef** _tmp16_;
	gint _tmp16__length1;
	GtkMenuItem* _tmp35_;
	GtkMenu* _tmp36_;
	GtkMenuItem* _tmp37_;
	self = (GitgCommitActionCherryPick*) base;
	g_return_if_fail (menu != NULL);
	_tmp0_ = gitg_ext_ui_element_get_available ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	gitg_commit_action_cherry_pick_ensure_destinations (self);
	_tmp2_ = gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	item = _tmp8_;
	_tmp9_ = item;
	_tmp10_ = gitg_ext_ui_element_get_description ((GitgExtUIElement*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = item;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp14_);
	submenu = _tmp14_;
	_tmp15_ = submenu;
	gtk_widget_show ((GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->d_destinations;
	_tmp16__length1 = self->priv->d_destinations_length1;
	{
		GitgRef** dest_collection = NULL;
		gint dest_collection_length1 = 0;
		gint _dest_collection_size_ = 0;
		gint dest_it = 0;
		dest_collection = _tmp16_;
		dest_collection_length1 = _tmp16__length1;
		for (dest_it = 0; dest_it < dest_collection_length1; dest_it = dest_it + 1) {
			GitgRef* _tmp17_;
			GitgRef* dest = NULL;
			_tmp17_ = _g_object_ref0 (dest_collection[dest_it]);
			dest = _tmp17_;
			{
				Block6Data* _data6_;
				gchar* name = NULL;
				GitgRef* _tmp18_;
				GitgParsedRefName* _tmp19_;
				GitgParsedRefName* _tmp20_;
				GitgParsedRefName* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				GtkMenuItem* subitem = NULL;
				const gchar* _tmp25_;
				GtkMenuItem* _tmp26_;
				GtkMenuItem* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GtkMenuItem* _tmp31_;
				GtkMenuItem* _tmp32_;
				GtkMenu* _tmp33_;
				GtkMenuItem* _tmp34_;
				_data6_ = g_slice_new0 (Block6Data);
				_data6_->_ref_count_ = 1;
				_data6_->self = g_object_ref (self);
				_data6_->dest = dest;
				_tmp18_ = _data6_->dest;
				_tmp19_ = gitg_ref_get_parsed_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = gitg_parsed_ref_name_get_shortname (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp21_);
				name = _tmp24_;
				_tmp25_ = name;
				_tmp26_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp25_);
				g_object_ref_sink (_tmp26_);
				subitem = _tmp26_;
				_tmp27_ = subitem;
				_tmp28_ = name;
				_tmp29_ = g_strdup_printf (_ ("Cherry pick onto “%s”"), _tmp28_);
				_tmp30_ = _tmp29_;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _tmp30_);
				_g_free0 (_tmp30_);
				_tmp31_ = subitem;
				gtk_widget_show ((GtkWidget*) _tmp31_);
				_tmp32_ = subitem;
				g_signal_connect_data (_tmp32_, "activate", (GCallback) _____lambda22__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
				_tmp33_ = submenu;
				_tmp34_ = subitem;
				gtk_menu_shell_append ((GtkMenuShell*) _tmp33_, _tmp34_);
				_g_object_unref0 (subitem);
				_g_free0 (name);
				block6_data_unref (_data6_);
				_data6_ = NULL;
			}
		}
	}
	_tmp35_ = item;
	_tmp36_ = submenu;
	gtk_menu_item_set_submenu (_tmp35_, _tmp36_);
	_tmp37_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp37_);
	_g_object_unref0 (submenu);
	_g_object_unref0 (item);
}

static void
gitg_commit_action_cherry_pick_real_activate (GitgExtUIElement* base)
{
	GitgCommitActionCherryPick * self;
	self = (GitgCommitActionCherryPick*) base;
}

static GitgExtApplication*
gitg_commit_action_cherry_pick_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgCommitActionCherryPick* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgCommitActionCherryPick*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_commit_action_cherry_pick_real_set_application (GitgExtUIElement* base,
                                                     GitgExtApplication* value)
{
	GitgCommitActionCherryPick* self;
	GitgExtApplication* old_value;
	self = (GitgCommitActionCherryPick*) base;
	old_value = gitg_commit_action_cherry_pick_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtRefActionInterface*
gitg_commit_action_cherry_pick_real_get_action_interface (GitgExtCommitAction* base)
{
	GitgExtRefActionInterface* result;
	GitgCommitActionCherryPick* self;
	GitgExtRefActionInterface* _tmp0_;
	self = (GitgCommitActionCherryPick*) base;
	_tmp0_ = self->priv->_action_interface;
	result = _tmp0_;
	return result;
}

static void
gitg_commit_action_cherry_pick_real_set_action_interface (GitgExtCommitAction* base,
                                                          GitgExtRefActionInterface* value)
{
	GitgCommitActionCherryPick* self;
	GitgExtRefActionInterface* old_value;
	self = (GitgCommitActionCherryPick*) base;
	old_value = gitg_commit_action_cherry_pick_real_get_action_interface (base);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_ACTION_INTERFACE_PROPERTY]);
	}
}

static GitgCommit*
gitg_commit_action_cherry_pick_real_get_commit (GitgExtCommitAction* base)
{
	GitgCommit* result;
	GitgCommitActionCherryPick* self;
	GitgCommit* _tmp0_;
	self = (GitgCommitActionCherryPick*) base;
	_tmp0_ = self->priv->_commit;
	result = _tmp0_;
	return result;
}

static void
gitg_commit_action_cherry_pick_real_set_commit (GitgExtCommitAction* base,
                                                GitgCommit* value)
{
	GitgCommitActionCherryPick* self;
	GitgCommit* old_value;
	self = (GitgCommitActionCherryPick*) base;
	old_value = gitg_commit_action_cherry_pick_real_get_commit (base);
	if (old_value != value) {
		GitgCommit* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_commit);
		self->priv->_commit = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_COMMIT_PROPERTY]);
	}
}

static gchar*
gitg_commit_action_cherry_pick_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgCommitActionCherryPick* self;
	gchar* _tmp0_;
	self = (GitgCommitActionCherryPick*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/commit-actions/cherry-pick");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_commit_action_cherry_pick_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgCommitActionCherryPick* self;
	gchar* _tmp0_;
	self = (GitgCommitActionCherryPick*) base;
	_tmp0_ = g_strdup (_ ("Cherry pick onto"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_commit_action_cherry_pick_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgCommitActionCherryPick* self;
	gchar* _tmp0_;
	self = (GitgCommitActionCherryPick*) base;
	_tmp0_ = g_strdup (_ ("Cherry pick this commit onto a branch"));
	result = _tmp0_;
	return result;
}

static gboolean
gitg_commit_action_cherry_pick_real_get_available (GitgExtUIElement* base)
{
	gboolean result;
	GitgCommitActionCherryPick* self;
	self = (GitgCommitActionCherryPick*) base;
	result = TRUE;
	return result;
}

static gboolean
gitg_commit_action_cherry_pick_real_get_enabled (GitgExtUIElement* base)
{
	gboolean result;
	GitgCommitActionCherryPick* self;
	GitgCommit* _tmp0_;
	GitgCommit* _tmp1_;
	GgitCommitParents* _tmp2_;
	GgitCommitParents* _tmp3_;
	gboolean _tmp4_;
	GitgRef** _tmp5_;
	gint _tmp5__length1;
	self = (GitgCommitActionCherryPick*) base;
	_tmp0_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_commit_get_parents ((GgitCommit*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = ggit_commit_parents_get_size (_tmp3_) > ((guint) 1);
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	gitg_commit_action_cherry_pick_ensure_destinations (self);
	_tmp5_ = self->priv->d_destinations;
	_tmp5__length1 = self->priv->d_destinations_length1;
	result = _tmp5__length1 != 0;
	return result;
}

static void
gitg_commit_action_cherry_pick_class_init (GitgCommitActionCherryPickClass * klass,
                                           gpointer klass_data)
{
	gitg_commit_action_cherry_pick_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCommitActionCherryPick_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_commit_action_cherry_pick_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_action_cherry_pick_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_action_cherry_pick_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_APPLICATION_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_ACTION_INTERFACE_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_COMMIT_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_COMMIT_PROPERTY] = g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_ID_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_DISPLAY_NAME_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_DESCRIPTION_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_AVAILABLE_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_AVAILABLE_PROPERTY] = g_param_spec_boolean ("available", "available", "available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CHERRY_PICK_ENABLED_PROPERTY, gitg_commit_action_cherry_pick_properties[GITG_COMMIT_ACTION_CHERRY_PICK_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_commit_action_cherry_pick_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                                   gpointer iface_data)
{
	gitg_commit_action_cherry_pick_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (GitgExtUIElement*)) gitg_commit_action_cherry_pick_real_activate;
	iface->get_application = gitg_commit_action_cherry_pick_real_get_application;
	iface->set_application = gitg_commit_action_cherry_pick_real_set_application;
	iface->get_id = gitg_commit_action_cherry_pick_real_get_id;
	iface->get_display_name = gitg_commit_action_cherry_pick_real_get_display_name;
	iface->get_description = gitg_commit_action_cherry_pick_real_get_description;
	iface->get_available = gitg_commit_action_cherry_pick_real_get_available;
	iface->get_enabled = gitg_commit_action_cherry_pick_real_get_enabled;
}

static void
gitg_commit_action_cherry_pick_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                               gpointer iface_data)
{
	gitg_commit_action_cherry_pick_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->populate_menu = (void (*) (GitgExtAction*, GtkMenu*)) gitg_commit_action_cherry_pick_real_populate_menu;
}

static void
gitg_commit_action_cherry_pick_gitg_ext_commit_action_interface_init (GitgExtCommitActionIface * iface,
                                                                      gpointer iface_data)
{
	gitg_commit_action_cherry_pick_gitg_ext_commit_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_action_interface = gitg_commit_action_cherry_pick_real_get_action_interface;
	iface->set_action_interface = gitg_commit_action_cherry_pick_real_set_action_interface;
	iface->get_commit = gitg_commit_action_cherry_pick_real_get_commit;
	iface->set_commit = gitg_commit_action_cherry_pick_real_set_commit;
}

static void
gitg_commit_action_cherry_pick_instance_init (GitgCommitActionCherryPick * self,
                                              gpointer klass)
{
	self->priv = gitg_commit_action_cherry_pick_get_instance_private (self);
}

static void
gitg_commit_action_cherry_pick_finalize (GObject * obj)
{
	GitgCommitActionCherryPick * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPick);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	_g_object_unref0 (self->priv->_commit);
	self->priv->d_destinations = (_vala_array_free (self->priv->d_destinations, self->priv->d_destinations_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_support);
	G_OBJECT_CLASS (gitg_commit_action_cherry_pick_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_commit_action_cherry_pick_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCommitActionCherryPickClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_action_cherry_pick_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommitActionCherryPick), 0, (GInstanceInitFunc) gitg_commit_action_cherry_pick_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_commit_action_cherry_pick_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_commit_action_cherry_pick_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_commit_action_info = { (GInterfaceInitFunc) gitg_commit_action_cherry_pick_gitg_ext_commit_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_commit_action_cherry_pick_type_id;
	gitg_commit_action_cherry_pick_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgCommitActionCherryPick", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_commit_action_cherry_pick_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_commit_action_cherry_pick_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	g_type_add_interface_static (gitg_commit_action_cherry_pick_type_id, GITG_EXT_TYPE_COMMIT_ACTION, &gitg_ext_commit_action_info);
	GitgCommitActionCherryPick_private_offset = g_type_add_instance_private (gitg_commit_action_cherry_pick_type_id, sizeof (GitgCommitActionCherryPickPrivate));
	return gitg_commit_action_cherry_pick_type_id;
}

GType
gitg_commit_action_cherry_pick_get_type (void)
{
	static gsize gitg_commit_action_cherry_pick_type_id__once = 0;
	if (g_once_init_enter (&gitg_commit_action_cherry_pick_type_id__once)) {
		GType gitg_commit_action_cherry_pick_type_id;
		gitg_commit_action_cherry_pick_type_id = gitg_commit_action_cherry_pick_get_type_once ();
		g_once_init_leave (&gitg_commit_action_cherry_pick_type_id__once, gitg_commit_action_cherry_pick_type_id);
	}
	return gitg_commit_action_cherry_pick_type_id__once;
}

static void
_vala_gitg_commit_action_cherry_pick_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GitgCommitActionCherryPick * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPick);
	switch (property_id) {
		case GITG_COMMIT_ACTION_CHERRY_PICK_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_ACTION_INTERFACE_PROPERTY:
		g_value_set_object (value, gitg_ext_commit_action_get_action_interface ((GitgExtCommitAction*) self));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_COMMIT_PROPERTY:
		g_value_set_object (value, gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_available ((GitgExtUIElement*) self));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_ENABLED_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_commit_action_cherry_pick_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GitgCommitActionCherryPick * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPick);
	switch (property_id) {
		case GITG_COMMIT_ACTION_CHERRY_PICK_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_ACTION_INTERFACE_PROPERTY:
		gitg_ext_commit_action_set_action_interface ((GitgExtCommitAction*) self, g_value_get_object (value));
		break;
		case GITG_COMMIT_ACTION_CHERRY_PICK_COMMIT_PROPERTY:
		gitg_ext_commit_action_set_commit ((GitgExtCommitAction*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

