/* PositionedWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PositionedWindow.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/window.h>
#include <glib.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <stdlib.h>
#include <string.h>
#include <mtk/mtk.h>
#include <meta/display.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;
typedef struct _GalaPositionedWindowPrivate GalaPositionedWindowPrivate;
typedef enum  {
	GALA_POSITIONED_WINDOW_POSITION_TOP,
	GALA_POSITIONED_WINDOW_POSITION_BOTTOM,
	GALA_POSITIONED_WINDOW_POSITION_CENTER
} GalaPositionedWindowPosition;

#define GALA_POSITIONED_WINDOW_TYPE_POSITION (gala_positioned_window_position_get_type ())
enum  {
	GALA_POSITIONED_WINDOW_0_PROPERTY,
	GALA_POSITIONED_WINDOW_WINDOW_PROPERTY,
	GALA_POSITIONED_WINDOW_POSITION_PROPERTY,
	GALA_POSITIONED_WINDOW_POSITION_DATA_PROPERTY,
	GALA_POSITIONED_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_positioned_window_properties[GALA_POSITIONED_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _GalaPositionedWindow {
	GObject parent_instance;
	GalaPositionedWindowPrivate * priv;
};

struct _GalaPositionedWindowClass {
	GObjectClass parent_class;
};

struct _GalaPositionedWindowPrivate {
	MetaWindow* _window;
	GalaPositionedWindowPosition _position;
	GVariant* _position_data;
	gint width;
	gint height;
	gulong position_changed_id;
};

static gint GalaPositionedWindow_private_offset;
static gpointer gala_positioned_window_parent_class = NULL;

VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_positioned_window_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaPositionedWindowPosition gala_positioned_window_position_from_anchor (enum io_elementary_pantheon_panel_v1_anchor anchor);
static const char* _pantheon_desktop_anchor_to_string (enum io_elementary_pantheon_panel_v1_anchor value);
VALA_EXTERN GalaPositionedWindow* gala_positioned_window_new (MetaWindow* window,
                                                  GalaPositionedWindowPosition position,
                                                  GVariant* position_data);
VALA_EXTERN GalaPositionedWindow* gala_positioned_window_construct (GType object_type,
                                                        MetaWindow* window,
                                                        GalaPositionedWindowPosition position,
                                                        GVariant* position_data);
VALA_EXTERN void gala_positioned_window_get_custom_window_rect (GalaPositionedWindow* self,
                                                    MtkRectangle* result);
VALA_EXTERN MetaWindow* gala_positioned_window_get_window (GalaPositionedWindow* self);
VALA_EXTERN GalaPositionedWindowPosition gala_positioned_window_get_position (GalaPositionedWindow* self);
VALA_EXTERN void gala_positioned_window_set_size (GalaPositionedWindow* self,
                                      gint width,
                                      gint height);
static void gala_positioned_window_position_window (GalaPositionedWindow* self);
static void gala_positioned_window_set_window (GalaPositionedWindow* self,
                                        MetaWindow* value);
VALA_EXTERN void gala_positioned_window_set_position (GalaPositionedWindow* self,
                                          GalaPositionedWindowPosition value);
VALA_EXTERN GVariant* gala_positioned_window_get_position_data (GalaPositionedWindow* self);
VALA_EXTERN void gala_positioned_window_set_position_data (GalaPositionedWindow* self,
                                               GVariant* value);
static GObject * gala_positioned_window_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _gala_positioned_window_position_window_meta_window_size_changed (MetaWindow* _sender,
                                                                       gpointer self);
static void _gala_positioned_window_position_window_meta_window_position_changed (MetaWindow* _sender,
                                                                           gpointer self);
static void _gala_positioned_window_position_window_meta_window_shown (MetaWindow* _sender,
                                                                gpointer self);
static void _gala_positioned_window_position_window_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                    gpointer self);
static void _gala_positioned_window_position_window_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                             gpointer self);
static void _gala_positioned_window_position_window_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void gala_positioned_window_finalize (GObject * obj);
static GType gala_positioned_window_get_type_once (void);
static void _vala_gala_positioned_window_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_positioned_window_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
gala_positioned_window_get_instance_private (GalaPositionedWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPositionedWindow_private_offset);
}

static const char*
_pantheon_desktop_anchor_to_string (enum io_elementary_pantheon_panel_v1_anchor value)
{
	switch (value) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT";
	}
	return NULL;
}

GalaPositionedWindowPosition
gala_positioned_window_position_from_anchor (enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	GalaPositionedWindowPosition result;
	if (anchor > 1) {
		const gchar* _tmp0_;
		_tmp0_ = _pantheon_desktop_anchor_to_string (anchor);
		g_warning ("PositionedWindow.vala:16: Position %s not supported yet", _tmp0_);
		result = GALA_POSITIONED_WINDOW_POSITION_CENTER;
		return result;
	}
	result = (GalaPositionedWindowPosition) anchor;
	return result;
}

 G_GNUC_NO_INLINE static GType
gala_positioned_window_position_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_POSITIONED_WINDOW_POSITION_TOP, "GALA_POSITIONED_WINDOW_POSITION_TOP", "top"}, {GALA_POSITIONED_WINDOW_POSITION_BOTTOM, "GALA_POSITIONED_WINDOW_POSITION_BOTTOM", "bottom"}, {GALA_POSITIONED_WINDOW_POSITION_CENTER, "GALA_POSITIONED_WINDOW_POSITION_CENTER", "center"}, {0, NULL, NULL}};
	GType gala_positioned_window_position_type_id;
	gala_positioned_window_position_type_id = g_enum_register_static ("GalaPositionedWindowPosition", values);
	return gala_positioned_window_position_type_id;
}

GType
gala_positioned_window_position_get_type (void)
{
	static gsize gala_positioned_window_position_type_id__once = 0;
	if (g_once_init_enter (&gala_positioned_window_position_type_id__once)) {
		GType gala_positioned_window_position_type_id;
		gala_positioned_window_position_type_id = gala_positioned_window_position_get_type_once ();
		g_once_init_leave (&gala_positioned_window_position_type_id__once, gala_positioned_window_position_type_id);
	}
	return gala_positioned_window_position_type_id__once;
}

GalaPositionedWindow*
gala_positioned_window_construct (GType object_type,
                                  MetaWindow* window,
                                  GalaPositionedWindowPosition position,
                                  GVariant* position_data)
{
	GalaPositionedWindow * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaPositionedWindow*) g_object_new (object_type, "window", window, "position", position, "position-data", position_data, NULL);
	return self;
}

GalaPositionedWindow*
gala_positioned_window_new (MetaWindow* window,
                            GalaPositionedWindowPosition position,
                            GVariant* position_data)
{
	return gala_positioned_window_construct (GALA_TYPE_POSITIONED_WINDOW, window, position, position_data);
}

void
gala_positioned_window_get_custom_window_rect (GalaPositionedWindow* self,
                                               MtkRectangle* result)
{
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp0_;
	MtkRectangle _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp0_, &_tmp1_);
	window_rect = _tmp1_;
	if (self->priv->width > 0) {
		window_rect.width = self->priv->width;
	}
	if (self->priv->height > 0) {
		GalaPositionedWindowPosition _tmp2_;
		window_rect.height = self->priv->height;
		_tmp2_ = self->priv->_position;
		if (_tmp2_ == GALA_POSITIONED_WINDOW_POSITION_BOTTOM) {
			MtkRectangle geom = {0};
			MetaWindow* _tmp3_;
			MetaDisplay* _tmp4_;
			MetaDisplay* _tmp5_;
			MetaWindow* _tmp6_;
			MtkRectangle _tmp7_ = {0};
			MtkRectangle _tmp8_;
			MtkRectangle _tmp9_;
			_tmp3_ = self->priv->_window;
			_tmp4_ = meta_window_get_display (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->priv->_window;
			meta_display_get_monitor_geometry (_tmp5_, meta_window_get_monitor (_tmp6_), &_tmp7_);
			geom = _tmp7_;
			_tmp8_ = geom;
			_tmp9_ = geom;
			window_rect.y = (_tmp8_.y + _tmp9_.height) - self->priv->height;
		}
	}
	*result = window_rect;
	return;
}

void
gala_positioned_window_set_size (GalaPositionedWindow* self,
                                 gint width,
                                 gint height)
{
	g_return_if_fail (self != NULL);
	self->priv->width = width;
	self->priv->height = height;
}

static void
gala_positioned_window_position_window (GalaPositionedWindow* self)
{
	gint x = 0;
	gint y = 0;
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp0_;
	MtkRectangle _tmp1_ = {0};
	MetaDisplay* display = NULL;
	MetaWindow* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	GalaPositionedWindowPosition _tmp5_;
	MetaWindow* _tmp31_;
	MetaWindow* _tmp32_;
	MetaWindow* _tmp33_;
	g_return_if_fail (self != NULL);
	x = 0;
	y = 0;
	_tmp0_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp0_, &_tmp1_);
	window_rect = _tmp1_;
	_tmp2_ = self->priv->_window;
	_tmp3_ = meta_window_get_display (_tmp2_);
	_tmp4_ = _tmp3_;
	display = _tmp4_;
	_tmp5_ = self->priv->_position;
	switch (_tmp5_) {
		case GALA_POSITIONED_WINDOW_POSITION_CENTER:
		{
			MtkRectangle monitor_geom = {0};
			MetaDisplay* _tmp6_;
			MetaDisplay* _tmp7_;
			MtkRectangle _tmp8_ = {0};
			MtkRectangle _tmp9_;
			MtkRectangle _tmp10_;
			MtkRectangle _tmp11_;
			MtkRectangle _tmp12_;
			MtkRectangle _tmp13_;
			MtkRectangle _tmp14_;
			_tmp6_ = display;
			_tmp7_ = display;
			meta_display_get_monitor_geometry (_tmp6_, meta_display_get_primary_monitor (_tmp7_), &_tmp8_);
			monitor_geom = _tmp8_;
			_tmp9_ = monitor_geom;
			_tmp10_ = monitor_geom;
			_tmp11_ = window_rect;
			x = _tmp9_.x + ((_tmp10_.width - _tmp11_.width) / 2);
			_tmp12_ = monitor_geom;
			_tmp13_ = monitor_geom;
			_tmp14_ = window_rect;
			y = _tmp12_.y + ((_tmp13_.height - _tmp14_.height) / 2);
			break;
		}
		case GALA_POSITIONED_WINDOW_POSITION_TOP:
		{
			MtkRectangle monitor_geom = {0};
			MetaDisplay* _tmp15_;
			MetaDisplay* _tmp16_;
			MtkRectangle _tmp17_ = {0};
			MtkRectangle _tmp18_;
			MtkRectangle _tmp19_;
			MtkRectangle _tmp20_;
			MtkRectangle _tmp21_;
			_tmp15_ = display;
			_tmp16_ = display;
			meta_display_get_monitor_geometry (_tmp15_, meta_display_get_primary_monitor (_tmp16_), &_tmp17_);
			monitor_geom = _tmp17_;
			_tmp18_ = monitor_geom;
			_tmp19_ = monitor_geom;
			_tmp20_ = window_rect;
			x = _tmp18_.x + ((_tmp19_.width - _tmp20_.width) / 2);
			_tmp21_ = monitor_geom;
			y = _tmp21_.y;
			break;
		}
		case GALA_POSITIONED_WINDOW_POSITION_BOTTOM:
		{
			MtkRectangle monitor_geom = {0};
			MetaDisplay* _tmp22_;
			MetaDisplay* _tmp23_;
			MtkRectangle _tmp24_ = {0};
			MtkRectangle _tmp25_;
			MtkRectangle _tmp26_;
			MtkRectangle _tmp27_;
			MtkRectangle _tmp28_;
			MtkRectangle _tmp29_;
			MtkRectangle _tmp30_;
			_tmp22_ = display;
			_tmp23_ = display;
			meta_display_get_monitor_geometry (_tmp22_, meta_display_get_primary_monitor (_tmp23_), &_tmp24_);
			monitor_geom = _tmp24_;
			_tmp25_ = monitor_geom;
			_tmp26_ = monitor_geom;
			_tmp27_ = window_rect;
			x = _tmp25_.x + ((_tmp26_.width - _tmp27_.width) / 2);
			_tmp28_ = monitor_geom;
			_tmp29_ = monitor_geom;
			_tmp30_ = window_rect;
			y = (_tmp28_.y + _tmp29_.height) - _tmp30_.height;
			break;
		}
		default:
		break;
	}
	_tmp31_ = self->priv->_window;
	g_signal_handler_block (_tmp31_, self->priv->position_changed_id);
	_tmp32_ = self->priv->_window;
	meta_window_move_frame (_tmp32_, FALSE, x, y);
	_tmp33_ = self->priv->_window;
	g_signal_handler_unblock (_tmp33_, self->priv->position_changed_id);
}

MetaWindow*
gala_positioned_window_get_window (GalaPositionedWindow* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_positioned_window_set_window (GalaPositionedWindow* self,
                                   MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_positioned_window_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_positioned_window_properties[GALA_POSITIONED_WINDOW_WINDOW_PROPERTY]);
	}
}

GalaPositionedWindowPosition
gala_positioned_window_get_position (GalaPositionedWindow* self)
{
	GalaPositionedWindowPosition result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_position;
	return result;
}

void
gala_positioned_window_set_position (GalaPositionedWindow* self,
                                     GalaPositionedWindowPosition value)
{
	GalaPositionedWindowPosition old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_positioned_window_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, gala_positioned_window_properties[GALA_POSITIONED_WINDOW_POSITION_PROPERTY]);
	}
}

GVariant*
gala_positioned_window_get_position_data (GalaPositionedWindow* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_position_data;
	result = _tmp0_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
gala_positioned_window_set_position_data (GalaPositionedWindow* self,
                                          GVariant* value)
{
	GVariant* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_positioned_window_get_position_data (self);
	if (old_value != value) {
		GVariant* _tmp0_;
		_tmp0_ = _g_variant_ref0 (value);
		_g_variant_unref0 (self->priv->_position_data);
		self->priv->_position_data = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_positioned_window_properties[GALA_POSITIONED_WINDOW_POSITION_DATA_PROPERTY]);
	}
}

static void
_gala_positioned_window_position_window_meta_window_size_changed (MetaWindow* _sender,
                                                                  gpointer self)
{
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

static void
_gala_positioned_window_position_window_meta_window_position_changed (MetaWindow* _sender,
                                                                      gpointer self)
{
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

static void
_gala_positioned_window_position_window_meta_window_shown (MetaWindow* _sender,
                                                           gpointer self)
{
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

static void
_gala_positioned_window_position_window_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                               gpointer self)
{
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

static void
_gala_positioned_window_position_window_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                        gpointer self)
{
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

static void
_gala_positioned_window_position_window_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

static GObject *
gala_positioned_window_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPositionedWindow * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	gulong _tmp3_;
	MetaWindow* _tmp4_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaWindow* _tmp5_;
	MetaDisplay* _tmp6_;
	MetaDisplay* _tmp7_;
	MetaContext* _tmp8_;
	MetaBackend* _tmp9_;
	MetaMonitorManager* _tmp10_;
	MetaMonitorManager* _tmp11_;
	MetaMonitorManager* _tmp12_;
	parent_class = G_OBJECT_CLASS (gala_positioned_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow);
	_tmp0_ = self->priv->_window;
	meta_window_stick (_tmp0_);
	_tmp1_ = self->priv->_window;
	g_signal_connect_object (_tmp1_, "size-changed", (GCallback) _gala_positioned_window_position_window_meta_window_size_changed, self, 0);
	_tmp2_ = self->priv->_window;
	_tmp3_ = g_signal_connect_object (_tmp2_, "position-changed", (GCallback) _gala_positioned_window_position_window_meta_window_position_changed, self, 0);
	self->priv->position_changed_id = _tmp3_;
	_tmp4_ = self->priv->_window;
	g_signal_connect_object (_tmp4_, "shown", (GCallback) _gala_positioned_window_position_window_meta_window_shown, self, 0);
	_tmp5_ = self->priv->_window;
	_tmp6_ = meta_window_get_display (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = meta_display_get_context (_tmp7_);
	_tmp9_ = meta_context_get_backend (_tmp8_);
	_tmp10_ = meta_backend_get_monitor_manager (_tmp9_);
	monitor_manager = _tmp10_;
	_tmp11_ = monitor_manager;
	g_signal_connect_object (_tmp11_, "monitors-changed", (GCallback) _gala_positioned_window_position_window_meta_monitor_manager_monitors_changed, self, 0);
	_tmp12_ = monitor_manager;
	g_signal_connect_object (_tmp12_, "monitors-changed-internal", (GCallback) _gala_positioned_window_position_window_meta_monitor_manager_monitors_changed_internal, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::position", (GCallback) _gala_positioned_window_position_window_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::position-data", (GCallback) _gala_positioned_window_position_window_g_object_notify, self, 0);
	return obj;
}

static void
gala_positioned_window_class_init (GalaPositionedWindowClass * klass,
                                   gpointer klass_data)
{
	gala_positioned_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPositionedWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_positioned_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_positioned_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_positioned_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_positioned_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_POSITIONED_WINDOW_WINDOW_PROPERTY, gala_positioned_window_properties[GALA_POSITIONED_WINDOW_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * This may only be set after the window was shown.
	     * The initial position should only be given in the constructor.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_POSITIONED_WINDOW_POSITION_PROPERTY, gala_positioned_window_properties[GALA_POSITIONED_WINDOW_POSITION_PROPERTY] = g_param_spec_enum ("position", "position", "position", GALA_POSITIONED_WINDOW_TYPE_POSITION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_POSITIONED_WINDOW_POSITION_DATA_PROPERTY, gala_positioned_window_properties[GALA_POSITIONED_WINDOW_POSITION_DATA_PROPERTY] = g_param_spec_variant ("position-data", "position-data", "position-data", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gala_positioned_window_instance_init (GalaPositionedWindow * self,
                                      gpointer klass)
{
	self->priv = gala_positioned_window_get_instance_private (self);
	self->priv->width = -1;
	self->priv->height = -1;
}

static void
gala_positioned_window_finalize (GObject * obj)
{
	GalaPositionedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow);
	_g_object_unref0 (self->priv->_window);
	_g_variant_unref0 (self->priv->_position_data);
	G_OBJECT_CLASS (gala_positioned_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_positioned_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPositionedWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_positioned_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPositionedWindow), 0, (GInstanceInitFunc) gala_positioned_window_instance_init, NULL };
	GType gala_positioned_window_type_id;
	gala_positioned_window_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaPositionedWindow", &g_define_type_info, 0);
	GalaPositionedWindow_private_offset = g_type_add_instance_private (gala_positioned_window_type_id, sizeof (GalaPositionedWindowPrivate));
	return gala_positioned_window_type_id;
}

GType
gala_positioned_window_get_type (void)
{
	static gsize gala_positioned_window_type_id__once = 0;
	if (g_once_init_enter (&gala_positioned_window_type_id__once)) {
		GType gala_positioned_window_type_id;
		gala_positioned_window_type_id = gala_positioned_window_get_type_once ();
		g_once_init_leave (&gala_positioned_window_type_id__once, gala_positioned_window_type_id);
	}
	return gala_positioned_window_type_id__once;
}

static void
_vala_gala_positioned_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaPositionedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow);
	switch (property_id) {
		case GALA_POSITIONED_WINDOW_WINDOW_PROPERTY:
		g_value_set_object (value, gala_positioned_window_get_window (self));
		break;
		case GALA_POSITIONED_WINDOW_POSITION_PROPERTY:
		g_value_set_enum (value, gala_positioned_window_get_position (self));
		break;
		case GALA_POSITIONED_WINDOW_POSITION_DATA_PROPERTY:
		g_value_set_variant (value, gala_positioned_window_get_position_data (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_positioned_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaPositionedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow);
	switch (property_id) {
		case GALA_POSITIONED_WINDOW_WINDOW_PROPERTY:
		gala_positioned_window_set_window (self, g_value_get_object (value));
		break;
		case GALA_POSITIONED_WINDOW_POSITION_PROPERTY:
		gala_positioned_window_set_position (self, g_value_get_enum (value));
		break;
		case GALA_POSITIONED_WINDOW_POSITION_DATA_PROPERTY:
		gala_positioned_window_set_position_data (self, g_value_get_variant (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

