/* ActorTarget.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ActorTarget.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;
typedef struct _GalaActorTargetPrivate GalaActorTargetPrivate;
enum  {
	GALA_ACTOR_TARGET_0_PROPERTY,
	GALA_ACTOR_TARGET_ACTOR_PROPERTY,
	GALA_ACTOR_TARGET_ANIMATING_PROPERTY,
	GALA_ACTOR_TARGET_NUM_PROPERTIES
};
static GParamSpec* gala_actor_target_properties[GALA_ACTOR_TARGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaActorTarget {
	ClutterActor parent_instance;
	GalaActorTargetPrivate * priv;
};

struct _GalaActorTargetClass {
	ClutterActorClass parent_class;
	void (*start_progress) (GalaActorTarget* self, GalaGestureAction action);
	void (*update_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble progress);
	void (*commit_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble to);
	void (*end_progress) (GalaActorTarget* self, GalaGestureAction action);
};

struct _GalaActorTargetPrivate {
	gdouble* current_progress;
	gint current_progress_length1;
	gint _current_progress_size_;
	gdouble* current_commit;
	gint current_commit_length1;
	gint _current_commit_size_;
	GeeList* targets;
	gint ongoing_animations;
};

static gint GalaActorTarget_private_offset;
static gpointer gala_actor_target_parent_class = NULL;
static GalaGestureTargetIface * gala_actor_target_gala_gesture_target_parent_iface = NULL;

VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN void gala_actor_target_start_progress (GalaActorTarget* self,
                                       GalaGestureAction action);
VALA_EXTERN void gala_actor_target_update_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble progress);
VALA_EXTERN void gala_actor_target_commit_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble to);
VALA_EXTERN void gala_actor_target_end_progress (GalaActorTarget* self,
                                     GalaGestureAction action);
static void gala_actor_target_sync_target (GalaActorTarget* self,
                                    GalaGestureTarget* target);
VALA_EXTERN void gala_gesture_target_propagate (GalaGestureTarget* self,
                                    GalaGestureTargetUpdateType update_type,
                                    GalaGestureAction action,
                                    gdouble progress);
VALA_EXTERN void gala_actor_target_add_target (GalaActorTarget* self,
                                   GalaGestureTarget* target);
VALA_EXTERN void gala_actor_target_remove_target (GalaActorTarget* self,
                                      GalaGestureTarget* target);
VALA_EXTERN void gala_actor_target_remove_all_targets (GalaActorTarget* self);
VALA_EXTERN gdouble gala_actor_target_get_current_progress (GalaActorTarget* self,
                                                GalaGestureAction action);
VALA_EXTERN gdouble gala_actor_target_get_current_commit (GalaActorTarget* self,
                                              GalaGestureAction action);
static void gala_actor_target_real_start_progress (GalaActorTarget* self,
                                            GalaGestureAction action);
static void gala_actor_target_real_update_progress (GalaActorTarget* self,
                                             GalaGestureAction action,
                                             gdouble progress);
static void gala_actor_target_real_commit_progress (GalaActorTarget* self,
                                             GalaGestureAction action,
                                             gdouble to);
static void gala_actor_target_real_end_progress (GalaActorTarget* self,
                                          GalaGestureAction action);
static void gala_actor_target_real_propagate (GalaGestureTarget* base,
                                       GalaGestureTargetUpdateType update_type,
                                       GalaGestureAction action,
                                       gdouble progress);
static void gala_actor_target_on_child_added (GalaActorTarget* self,
                                       ClutterActor* child);
VALA_EXTERN GalaActorTarget* gala_actor_target_new (void);
VALA_EXTERN GalaActorTarget* gala_actor_target_construct (GType object_type);
VALA_EXTERN gboolean gala_actor_target_get_animating (GalaActorTarget* self);
static GObject * gala_actor_target_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _gala_actor_target_on_child_added_clutter_actor_child_added (ClutterActor* _sender,
                                                                  ClutterActor* child,
                                                                  gpointer self);
VALA_EXTERN ClutterActor* gala_gesture_target_get_actor (GalaGestureTarget* self);
static void gala_actor_target_finalize (GObject * obj);
static GType gala_actor_target_get_type_once (void);
static void _vala_gala_actor_target_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_actor_target_get_instance_private (GalaActorTarget* self)
{
	return G_STRUCT_MEMBER_P (self, GalaActorTarget_private_offset);
}

static void
gala_actor_target_sync_target (GalaActorTarget* self,
                               GalaGestureTarget* target)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	{
		gint action = 0;
		action = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble* _tmp2_;
				gint _tmp2__length1;
				gdouble* _tmp3_;
				gint _tmp3__length1;
				gdouble _tmp4_;
				gdouble* _tmp5_;
				gint _tmp5__length1;
				gdouble _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = action;
					action = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->current_progress;
				_tmp2__length1 = self->priv->current_progress_length1;
				if (!(action < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->current_commit;
				_tmp3__length1 = self->priv->current_commit_length1;
				_tmp4_ = _tmp3_[action];
				gala_gesture_target_propagate (target, GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT, action, _tmp4_);
				_tmp5_ = self->priv->current_progress;
				_tmp5__length1 = self->priv->current_progress_length1;
				_tmp6_ = _tmp5_[action];
				gala_gesture_target_propagate (target, GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE, action, _tmp6_);
			}
		}
	}
}

void
gala_actor_target_add_target (GalaActorTarget* self,
                              GalaGestureTarget* target)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	_tmp0_ = self->priv->targets;
	gee_collection_add ((GeeCollection*) _tmp0_, target);
	gala_actor_target_sync_target (self, target);
}

void
gala_actor_target_remove_target (GalaActorTarget* self,
                                 GalaGestureTarget* target)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	_tmp0_ = self->priv->targets;
	gee_collection_remove ((GeeCollection*) _tmp0_, target);
}

void
gala_actor_target_remove_all_targets (GalaActorTarget* self)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->targets;
	gee_collection_clear ((GeeCollection*) _tmp0_);
}

gdouble
gala_actor_target_get_current_progress (GalaActorTarget* self,
                                        GalaGestureAction action)
{
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->current_progress;
	_tmp0__length1 = self->priv->current_progress_length1;
	_tmp1_ = _tmp0_[action];
	result = _tmp1_;
	return result;
}

gdouble
gala_actor_target_get_current_commit (GalaActorTarget* self,
                                      GalaGestureAction action)
{
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->current_commit;
	_tmp0__length1 = self->priv->current_commit_length1;
	_tmp1_ = _tmp0_[action];
	result = _tmp1_;
	return result;
}

static void
gala_actor_target_real_start_progress (GalaActorTarget* self,
                                       GalaGestureAction action)
{
}

void
gala_actor_target_start_progress (GalaActorTarget* self,
                                  GalaGestureAction action)
{
	GalaActorTargetClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_ACTOR_TARGET_GET_CLASS (self);
	if (_klass_->start_progress) {
		_klass_->start_progress (self, action);
	}
}

static void
gala_actor_target_real_update_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble progress)
{
}

void
gala_actor_target_update_progress (GalaActorTarget* self,
                                   GalaGestureAction action,
                                   gdouble progress)
{
	GalaActorTargetClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_ACTOR_TARGET_GET_CLASS (self);
	if (_klass_->update_progress) {
		_klass_->update_progress (self, action, progress);
	}
}

static void
gala_actor_target_real_commit_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble to)
{
}

void
gala_actor_target_commit_progress (GalaActorTarget* self,
                                   GalaGestureAction action,
                                   gdouble to)
{
	GalaActorTargetClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_ACTOR_TARGET_GET_CLASS (self);
	if (_klass_->commit_progress) {
		_klass_->commit_progress (self, action, to);
	}
}

static void
gala_actor_target_real_end_progress (GalaActorTarget* self,
                                     GalaGestureAction action)
{
}

void
gala_actor_target_end_progress (GalaActorTarget* self,
                                GalaGestureAction action)
{
	GalaActorTargetClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_ACTOR_TARGET_GET_CLASS (self);
	if (_klass_->end_progress) {
		_klass_->end_progress (self, action);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_actor_target_real_propagate (GalaGestureTarget* base,
                                  GalaGestureTargetUpdateType update_type,
                                  GalaGestureAction action,
                                  gdouble progress)
{
	GalaActorTarget * self;
	self = (GalaActorTarget*) base;
	if (update_type == GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT) {
		gdouble* _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = self->priv->current_commit;
		_tmp0__length1 = self->priv->current_commit_length1;
		_tmp0_[action] = progress;
	} else {
		gdouble* _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->current_progress;
		_tmp1__length1 = self->priv->current_progress_length1;
		_tmp1_[action] = progress;
	}
	{
		GeeList* _target_list = NULL;
		GeeList* _tmp2_;
		gint _target_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _target_index = 0;
		_tmp2_ = self->priv->targets;
		_target_list = _tmp2_;
		_tmp3_ = _target_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_target_size = _tmp5_;
		_target_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			GalaGestureTarget* target = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			GalaGestureTarget* _tmp10_;
			_target_index = _target_index + 1;
			_tmp6_ = _target_index;
			_tmp7_ = _target_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _target_list;
			_tmp9_ = gee_list_get (_tmp8_, _target_index);
			target = (GalaGestureTarget*) _tmp9_;
			_tmp10_ = target;
			gala_gesture_target_propagate (_tmp10_, update_type, action, progress);
			_g_object_unref0 (target);
		}
	}
	{
		ClutterActor* child = NULL;
		ClutterActor* _tmp11_;
		ClutterActor* _tmp12_;
		_tmp11_ = clutter_actor_get_first_child ((ClutterActor*) self);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		child = _tmp12_;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				ClutterActor* _tmp17_;
				ClutterActor* _tmp18_;
				if (!_tmp13_) {
					ClutterActor* _tmp14_;
					ClutterActor* _tmp15_;
					ClutterActor* _tmp16_;
					_tmp14_ = child;
					_tmp15_ = clutter_actor_get_next_sibling (_tmp14_);
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (child);
					child = _tmp16_;
				}
				_tmp13_ = FALSE;
				_tmp17_ = child;
				if (!(_tmp17_ != NULL)) {
					break;
				}
				_tmp18_ = child;
				if (GALA_IS_ACTOR_TARGET (_tmp18_)) {
					ClutterActor* _tmp19_;
					_tmp19_ = child;
					gala_gesture_target_propagate ((GalaGestureTarget*) _tmp19_, update_type, action, progress);
				}
			}
		}
		_g_object_unref0 (child);
	}
	switch (update_type) {
		case GALA_GESTURE_TARGET_UPDATE_TYPE_START:
		{
			gint _tmp20_;
			_tmp20_ = self->priv->ongoing_animations;
			self->priv->ongoing_animations = _tmp20_ + 1;
			gala_actor_target_start_progress (self, action);
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE:
		{
			gala_actor_target_update_progress (self, action, progress);
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT:
		{
			gala_actor_target_commit_progress (self, action, progress);
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_END:
		{
			gint _tmp21_;
			_tmp21_ = self->priv->ongoing_animations;
			self->priv->ongoing_animations = _tmp21_ - 1;
			gala_actor_target_end_progress (self, action);
			break;
		}
		default:
		break;
	}
}

static void
gala_actor_target_on_child_added (GalaActorTarget* self,
                                  ClutterActor* child)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	if (GALA_IS_ACTOR_TARGET (child)) {
		gala_actor_target_sync_target (self, G_TYPE_CHECK_INSTANCE_CAST (child, GALA_TYPE_GESTURE_TARGET, GalaGestureTarget));
	}
}

GalaActorTarget*
gala_actor_target_construct (GType object_type)
{
	GalaActorTarget * self = NULL;
	self = (GalaActorTarget*) g_object_new (object_type, NULL);
	return self;
}

GalaActorTarget*
gala_actor_target_new (void)
{
	return gala_actor_target_construct (GALA_TYPE_ACTOR_TARGET);
}

static ClutterActor*
gala_actor_target_real_get_actor (GalaGestureTarget* base)
{
	ClutterActor* result;
	GalaActorTarget* self;
	self = (GalaActorTarget*) base;
	result = (ClutterActor*) self;
	return result;
}

gboolean
gala_actor_target_get_animating (GalaActorTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->ongoing_animations > 0;
	return result;
}

static void
_gala_actor_target_on_child_added_clutter_actor_child_added (ClutterActor* _sender,
                                                             ClutterActor* child,
                                                             gpointer self)
{
	gala_actor_target_on_child_added ((GalaActorTarget*) self, child);
}

static GObject *
gala_actor_target_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaActorTarget * self;
	gdouble* _tmp0_;
	gdouble* _tmp1_;
	GeeArrayList* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_actor_target_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ACTOR_TARGET, GalaActorTarget);
	_tmp0_ = g_new0 (gdouble, GALA_GESTURE_ACTION_N_ACTIONS);
	self->priv->current_progress = (g_free (self->priv->current_progress), NULL);
	self->priv->current_progress = _tmp0_;
	self->priv->current_progress_length1 = GALA_GESTURE_ACTION_N_ACTIONS;
	self->priv->_current_progress_size_ = self->priv->current_progress_length1;
	_tmp1_ = g_new0 (gdouble, GALA_GESTURE_ACTION_N_ACTIONS);
	self->priv->current_commit = (g_free (self->priv->current_commit), NULL);
	self->priv->current_commit = _tmp1_;
	self->priv->current_commit_length1 = GALA_GESTURE_ACTION_N_ACTIONS;
	self->priv->_current_commit_size_ = self->priv->current_commit_length1;
	_tmp2_ = gee_array_list_new (GALA_TYPE_GESTURE_TARGET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->targets);
	self->priv->targets = (GeeList*) _tmp2_;
	g_signal_connect_object ((ClutterActor*) self, "child-added", (GCallback) _gala_actor_target_on_child_added_clutter_actor_child_added, self, 0);
	return obj;
}

static void
gala_actor_target_class_init (GalaActorTargetClass * klass,
                              gpointer klass_data)
{
	gala_actor_target_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaActorTarget_private_offset);
	((GalaActorTargetClass *) klass)->start_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_actor_target_real_start_progress;
	((GalaActorTargetClass *) klass)->update_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_actor_target_real_update_progress;
	((GalaActorTargetClass *) klass)->commit_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_actor_target_real_commit_progress;
	((GalaActorTargetClass *) klass)->end_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_actor_target_real_end_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_actor_target_get_property;
	G_OBJECT_CLASS (klass)->constructor = gala_actor_target_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_actor_target_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACTOR_TARGET_ACTOR_PROPERTY, gala_actor_target_properties[GALA_ACTOR_TARGET_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACTOR_TARGET_ANIMATING_PROPERTY, gala_actor_target_properties[GALA_ACTOR_TARGET_ANIMATING_PROPERTY] = g_param_spec_boolean ("animating", "animating", "animating", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_actor_target_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                                      gpointer iface_data)
{
	gala_actor_target_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_actor_target_real_propagate;
	iface->get_actor = gala_actor_target_real_get_actor;
}

static void
gala_actor_target_instance_init (GalaActorTarget * self,
                                 gpointer klass)
{
	self->priv = gala_actor_target_get_instance_private (self);
	self->priv->ongoing_animations = 0;
}

static void
gala_actor_target_finalize (GObject * obj)
{
	GalaActorTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ACTOR_TARGET, GalaActorTarget);
	self->priv->current_progress = (g_free (self->priv->current_progress), NULL);
	self->priv->current_commit = (g_free (self->priv->current_commit), NULL);
	_g_object_unref0 (self->priv->targets);
	G_OBJECT_CLASS (gala_actor_target_parent_class)->finalize (obj);
}

/**
 * An {@link GestureTarget} implementation that derives from a {@link Clutter.Actor}.
 * It will propagate gesture events to all direct descendants that are also {@link ActorTarget}s.
 * If a new child (or target via {@link add_target}) is added, its progress will be synced.
 */
 G_GNUC_NO_INLINE static GType
gala_actor_target_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaActorTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_actor_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaActorTarget), 0, (GInstanceInitFunc) gala_actor_target_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_actor_target_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_actor_target_type_id;
	gala_actor_target_type_id = g_type_register_static (clutter_actor_get_type (), "GalaActorTarget", &g_define_type_info, 0);
	g_type_add_interface_static (gala_actor_target_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	GalaActorTarget_private_offset = g_type_add_instance_private (gala_actor_target_type_id, sizeof (GalaActorTargetPrivate));
	return gala_actor_target_type_id;
}

GType
gala_actor_target_get_type (void)
{
	static gsize gala_actor_target_type_id__once = 0;
	if (g_once_init_enter (&gala_actor_target_type_id__once)) {
		GType gala_actor_target_type_id;
		gala_actor_target_type_id = gala_actor_target_get_type_once ();
		g_once_init_leave (&gala_actor_target_type_id__once, gala_actor_target_type_id);
	}
	return gala_actor_target_type_id__once;
}

static void
_vala_gala_actor_target_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaActorTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ACTOR_TARGET, GalaActorTarget);
	switch (property_id) {
		case GALA_ACTOR_TARGET_ACTOR_PROPERTY:
		g_value_set_object (value, gala_gesture_target_get_actor ((GalaGestureTarget*) self));
		break;
		case GALA_ACTOR_TARGET_ANIMATING_PROPERTY:
		g_value_set_boolean (value, gala_actor_target_get_animating (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

