/* DBus.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DBus.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2024-2025 elementary, Inc. (https://elementary.io)
 *                         2012-2014 Tom Beckmann
 *                         2012-2014 Jacob Parker
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <meta/meta-plugin.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <meta/display.h>
#include "gala.h"
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_DBUS (gala_dbus_get_type ())
#define GALA_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DBUS, GalaDBus))
#define GALA_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DBUS, GalaDBusClass))
#define GALA_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DBUS))
#define GALA_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DBUS))
#define GALA_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DBUS, GalaDBusClass))

typedef struct _GalaDBus GalaDBus;
typedef struct _GalaDBusClass GalaDBusClass;
typedef struct _GalaDBusPrivate GalaDBusPrivate;

#define GALA_TYPE_WINDOW_MANAGER_GALA (gala_window_manager_gala_get_type ())
#define GALA_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala))
#define GALA_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))
#define GALA_IS_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_IS_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_WINDOW_MANAGER_GALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))

typedef struct _GalaWindowManagerGala GalaWindowManagerGala;
typedef struct _GalaWindowManagerGalaClass GalaWindowManagerGalaClass;

#define GALA_TYPE_NOTIFICATIONS_MANAGER (gala_notifications_manager_get_type ())
#define GALA_NOTIFICATIONS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_NOTIFICATIONS_MANAGER, GalaNotificationsManager))
#define GALA_NOTIFICATIONS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_NOTIFICATIONS_MANAGER, GalaNotificationsManagerClass))
#define GALA_IS_NOTIFICATIONS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_NOTIFICATIONS_MANAGER))
#define GALA_IS_NOTIFICATIONS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_NOTIFICATIONS_MANAGER))
#define GALA_NOTIFICATIONS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_NOTIFICATIONS_MANAGER, GalaNotificationsManagerClass))

typedef struct _GalaNotificationsManager GalaNotificationsManager;
typedef struct _GalaNotificationsManagerClass GalaNotificationsManagerClass;

#define GALA_TYPE_SCREENSHOT_MANAGER (gala_screenshot_manager_get_type ())
#define GALA_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SCREENSHOT_MANAGER, GalaScreenshotManager))
#define GALA_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SCREENSHOT_MANAGER, GalaScreenshotManagerClass))
#define GALA_IS_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SCREENSHOT_MANAGER))
#define GALA_IS_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SCREENSHOT_MANAGER))
#define GALA_SCREENSHOT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SCREENSHOT_MANAGER, GalaScreenshotManagerClass))

typedef struct _GalaScreenshotManager GalaScreenshotManager;
typedef struct _GalaScreenshotManagerClass GalaScreenshotManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _gala_dbus_unref0(var) ((var == NULL) ? NULL : (var = (gala_dbus_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GALA_TYPE_DESKTOP_INTEGRATION (gala_desktop_integration_get_type ())
#define GALA_DESKTOP_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegration))
#define GALA_DESKTOP_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegrationClass))
#define GALA_IS_DESKTOP_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DESKTOP_INTEGRATION))
#define GALA_IS_DESKTOP_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DESKTOP_INTEGRATION))
#define GALA_DESKTOP_INTEGRATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegrationClass))

typedef struct _GalaDesktopIntegration GalaDesktopIntegration;
typedef struct _GalaDesktopIntegrationClass GalaDesktopIntegrationClass;

#define GALA_TYPE_DBUS_ACCELERATOR (gala_dbus_accelerator_get_type ())
#define GALA_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DBUS_ACCELERATOR, GalaDBusAccelerator))
#define GALA_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DBUS_ACCELERATOR, GalaDBusAcceleratorClass))
#define GALA_IS_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DBUS_ACCELERATOR))
#define GALA_IS_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DBUS_ACCELERATOR))
#define GALA_DBUS_ACCELERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DBUS_ACCELERATOR, GalaDBusAcceleratorClass))

typedef struct _GalaDBusAccelerator GalaDBusAccelerator;
typedef struct _GalaDBusAcceleratorClass GalaDBusAcceleratorClass;
#define _gala_dbus_accelerator_unref0(var) ((var == NULL) ? NULL : (var = (gala_dbus_accelerator_unref (var), NULL)))

#define GALA_TYPE_SESSION_MANAGER (gala_session_manager_get_type ())
#define GALA_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SESSION_MANAGER, GalaSessionManager))
#define GALA_SESSION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SESSION_MANAGER, GalaSessionManagerClass))
#define GALA_IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SESSION_MANAGER))
#define GALA_IS_SESSION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SESSION_MANAGER))
#define GALA_SESSION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SESSION_MANAGER, GalaSessionManagerClass))

typedef struct _GalaSessionManager GalaSessionManager;
typedef struct _GalaSessionManagerClass GalaSessionManagerClass;

#define GALA_TYPE_SCREEN_SAVER_MANAGER (gala_screen_saver_manager_get_type ())
#define GALA_SCREEN_SAVER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SCREEN_SAVER_MANAGER, GalaScreenSaverManager))
#define GALA_SCREEN_SAVER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SCREEN_SAVER_MANAGER, GalaScreenSaverManagerClass))
#define GALA_IS_SCREEN_SAVER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SCREEN_SAVER_MANAGER))
#define GALA_IS_SCREEN_SAVER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SCREEN_SAVER_MANAGER))
#define GALA_SCREEN_SAVER_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SCREEN_SAVER_MANAGER, GalaScreenSaverManagerClass))

typedef struct _GalaScreenSaverManager GalaScreenSaverManager;
typedef struct _GalaScreenSaverManagerClass GalaScreenSaverManagerClass;
typedef struct _GalaParamSpecDBus GalaParamSpecDBus;

struct _GalaDBus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaDBusPrivate * priv;
};

struct _GalaDBusClass {
	GTypeClass parent_class;
	void (*finalize) (GalaDBus *self);
};

struct _Block1Data {
	int _ref_count_;
	GalaNotificationsManager* notifications_manager;
	GalaScreenshotManager* screenshot_manager;
};

struct _GalaParamSpecDBus {
	GParamSpec parent_instance;
};

static gpointer gala_dbus_parent_class = NULL;
static GalaDBus* gala_dbus_instance;
static GalaDBus* gala_dbus_instance = NULL;
static GalaWindowManagerGala* gala_dbus_wm;
static GalaWindowManagerGala* gala_dbus_wm = NULL;

VALA_EXTERN gpointer gala_dbus_ref (gpointer instance);
VALA_EXTERN void gala_dbus_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_dbus (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void gala_value_set_dbus (GValue* value,
                          gpointer v_object);
VALA_EXTERN void gala_value_take_dbus (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer gala_value_get_dbus (const GValue* value);
VALA_EXTERN GType gala_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDBus, gala_dbus_unref)
VALA_EXTERN guint gala_dbus_register_object (void* object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error);
VALA_EXTERN GType gala_window_manager_gala_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowManagerGala, g_object_unref)
VALA_EXTERN GType gala_notifications_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaNotificationsManager, g_object_unref)
VALA_EXTERN GType gala_screenshot_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaScreenshotManager, g_object_unref)
VALA_EXTERN guint gala_screenshot_manager_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN void gala_dbus_init (GalaWindowManagerGala* _wm,
                     GalaNotificationsManager* notifications_manager,
                     GalaScreenshotManager* screenshot_manager);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda111_ (GDBusConnection* connection);
VALA_EXTERN GalaDBus* gala_dbus_new (void);
VALA_EXTERN GalaDBus* gala_dbus_construct (GType object_type);
VALA_EXTERN GalaDesktopIntegration* gala_desktop_integration_new (GalaWindowManagerGala* wm);
VALA_EXTERN GalaDesktopIntegration* gala_desktop_integration_construct (GType object_type,
                                                            GalaWindowManagerGala* wm);
VALA_EXTERN GType gala_desktop_integration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDesktopIntegration, g_object_unref)
VALA_EXTERN guint gala_desktop_integration_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
static void ___lambda111__gbus_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void __lambda121_ (void);
static void ___lambda121__gbus_name_acquired_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self);
static void __lambda122_ (void);
static void ___lambda122__gbus_name_lost_callback (GDBusConnection* connection,
                                            const gchar* name,
                                            gpointer self);
static void __lambda123_ (Block1Data* _data1_,
                   GDBusConnection* connection);
VALA_EXTERN GalaDBusAccelerator* gala_dbus_accelerator_new (MetaDisplay* _display,
                                                GalaNotificationsManager* _notifications_manager);
VALA_EXTERN GalaDBusAccelerator* gala_dbus_accelerator_construct (GType object_type,
                                                      MetaDisplay* _display,
                                                      GalaNotificationsManager* _notifications_manager);
VALA_EXTERN gpointer gala_dbus_accelerator_ref (gpointer instance);
VALA_EXTERN void gala_dbus_accelerator_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_dbus_accelerator (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void gala_value_set_dbus_accelerator (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void gala_value_take_dbus_accelerator (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer gala_value_get_dbus_accelerator (const GValue* value);
VALA_EXTERN GType gala_dbus_accelerator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDBusAccelerator, gala_dbus_accelerator_unref)
VALA_EXTERN guint gala_dbus_accelerator_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
static void ___lambda123__gbus_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void __lambda124_ (void);
static void ___lambda124__gbus_name_acquired_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self);
static void __lambda125_ (void);
static void ___lambda125__gbus_name_lost_callback (GDBusConnection* connection,
                                            const gchar* name,
                                            gpointer self);
static void __lambda126_ (void);
static void ___lambda126__gbus_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void __lambda127_ (void);
static void ___lambda127__gbus_name_acquired_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self);
static void __lambda128_ (void);
static void ___lambda128__gbus_name_lost_callback (GDBusConnection* connection,
                                            const gchar* name,
                                            gpointer self);
static void __lambda129_ (GDBusConnection* connection);
VALA_EXTERN GType gala_session_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSessionManager, g_object_unref)
VALA_EXTERN guint gala_session_manager_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GalaSessionManager* gala_session_manager_init (void);
static void ___lambda129__gbus_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void __lambda135_ (void);
static void ___lambda135__gbus_name_acquired_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self);
static void __lambda136_ (void);
static void ___lambda136__gbus_name_lost_callback (GDBusConnection* connection,
                                            const gchar* name,
                                            gpointer self);
static void __lambda137_ (GDBusConnection* connection);
VALA_EXTERN GType gala_screen_saver_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaScreenSaverManager, g_object_unref)
VALA_EXTERN guint gala_screen_saver_manager_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GalaScreenSaverManager* gala_window_manager_gala_get_screensaver (GalaWindowManagerGala* self);
static void ___lambda137__gbus_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void __lambda138_ (void);
static void ___lambda138__gbus_name_acquired_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self);
static void __lambda139_ (void);
static void ___lambda139__gbus_name_lost_callback (GDBusConnection* connection,
                                            const gchar* name,
                                            gpointer self);
VALA_EXTERN void gala_dbus_perform_action (GalaDBus* self,
                               GalaActionType type,
                               GError** error);
static void gala_dbus_finalize (GalaDBus * obj);
static GType gala_dbus_get_type_once (void);
static void _dbus_gala_dbus_perform_action (GalaDBus* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void gala_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data);
static GVariant* gala_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data);
static gboolean gala_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data);
static void _gala_dbus_unregister_object (gpointer user_data);

static const GDBusArgInfo _gala_dbus_dbus_arg_info_perform_action_type = {-1, "type", "i", NULL};
static const GDBusArgInfo * const _gala_dbus_dbus_arg_info_perform_action_in[] = {&_gala_dbus_dbus_arg_info_perform_action_type, NULL};
static const GDBusArgInfo * const _gala_dbus_dbus_arg_info_perform_action_out[] = {NULL};
static const GDBusMethodInfo _gala_dbus_dbus_method_info_perform_action = {-1, "PerformAction", (GDBusArgInfo **) (&_gala_dbus_dbus_arg_info_perform_action_in), (GDBusArgInfo **) (&_gala_dbus_dbus_arg_info_perform_action_out), NULL};
static const GDBusMethodInfo * const _gala_dbus_dbus_method_info[] = {&_gala_dbus_dbus_method_info_perform_action, NULL};
static const GDBusSignalInfo * const _gala_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_dbus_dbus_interface_info = {-1, "org.pantheon.gala", (GDBusMethodInfo **) (&_gala_dbus_dbus_method_info), (GDBusSignalInfo **) (&_gala_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_dbus_dbus_interface_vtable = {gala_dbus_dbus_interface_method_call, gala_dbus_dbus_interface_get_property, gala_dbus_dbus_interface_set_property};

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->notifications_manager);
		_g_object_unref0 (_data1_->screenshot_manager);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda111_ (GDBusConnection* connection)
{
	GalaDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	_tmp0_ = gala_dbus_instance;
	if (_tmp0_ == NULL) {
		GalaDBus* _tmp1_;
		_tmp1_ = gala_dbus_new ();
		_gala_dbus_unref0 (gala_dbus_instance);
		gala_dbus_instance = _tmp1_;
	}
	{
		GalaDBus* _tmp2_;
		_tmp2_ = gala_dbus_instance;
		gala_dbus_register_object (_tmp2_, connection, "/org/pantheon/gala", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("DBus.vala:24: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GalaWindowManagerGala* _tmp5_;
		GalaDesktopIntegration* _tmp6_;
		GalaDesktopIntegration* _tmp7_;
		_tmp5_ = gala_dbus_wm;
		_tmp6_ = gala_desktop_integration_new (_tmp5_);
		_tmp7_ = _tmp6_;
		gala_desktop_integration_register_object (_tmp7_, connection, "/org/pantheon/gala/DesktopInterface", &_inner_error0_);
		_g_object_unref0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("DBus.vala:28: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda111__gbus_acquired_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda111_ (connection);
}

static void
__lambda121_ (void)
{
}

static void
___lambda121__gbus_name_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self)
{
	__lambda121_ ();
}

static void
__lambda122_ (void)
{
	g_warning ("DBus.vala:31: Could not acquire name\n");
}

static void
___lambda122__gbus_name_lost_callback (GDBusConnection* connection,
                                       const gchar* name,
                                       gpointer self)
{
	__lambda122_ ();
}

static void
__lambda123_ (Block1Data* _data1_,
              GDBusConnection* connection)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	{
		GalaWindowManagerGala* _tmp0_;
		MetaDisplay* _tmp1_;
		GalaDBusAccelerator* _tmp2_;
		GalaDBusAccelerator* _tmp3_;
		_tmp0_ = gala_dbus_wm;
		_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
		_tmp2_ = gala_dbus_accelerator_new (_tmp1_, _data1_->notifications_manager);
		_tmp3_ = _tmp2_;
		gala_dbus_accelerator_register_object (_tmp3_, connection, "/org/gnome/Shell", &_inner_error0_);
		_gala_dbus_accelerator_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gala_screenshot_manager_register_object (_data1_->screenshot_manager, connection, "/org/gnome/Shell/Screenshot", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("DBus.vala:38: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda123__gbus_acquired_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda123_ (self, connection);
}

static void
__lambda124_ (void)
{
}

static void
___lambda124__gbus_name_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self)
{
	__lambda124_ ();
}

static void
__lambda125_ (void)
{
	g_critical ("DBus.vala:41: Could not acquire name");
}

static void
___lambda125__gbus_name_lost_callback (GDBusConnection* connection,
                                       const gchar* name,
                                       gpointer self)
{
	__lambda125_ ();
}

static void
__lambda126_ (void)
{
}

static void
___lambda126__gbus_acquired_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda126_ ();
}

static void
__lambda127_ (void)
{
}

static void
___lambda127__gbus_name_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self)
{
	__lambda127_ ();
}

static void
__lambda128_ (void)
{
	g_critical ("DBus.vala:46: Could not acquire name");
}

static void
___lambda128__gbus_name_lost_callback (GDBusConnection* connection,
                                       const gchar* name,
                                       gpointer self)
{
	__lambda128_ ();
}

static void
__lambda129_ (GDBusConnection* connection)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	{
		GalaSessionManager* _tmp0_;
		_tmp0_ = gala_session_manager_init ();
		gala_session_manager_register_object (_tmp0_, connection, "/org/gnome/SessionManager/EndSessionDialog", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("DBus.vala:52: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda129__gbus_acquired_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda129_ (connection);
}

static void
__lambda135_ (void)
{
}

static void
___lambda135__gbus_name_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self)
{
	__lambda135_ ();
}

static void
__lambda136_ (void)
{
	g_critical ("DBus.vala:55: Could not acquire name");
}

static void
___lambda136__gbus_name_lost_callback (GDBusConnection* connection,
                                       const gchar* name,
                                       gpointer self)
{
	__lambda136_ ();
}

static void
__lambda137_ (GDBusConnection* connection)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	{
		GalaWindowManagerGala* _tmp0_;
		GalaScreenSaverManager* _tmp1_;
		GalaScreenSaverManager* _tmp2_;
		_tmp0_ = gala_dbus_wm;
		_tmp1_ = gala_window_manager_gala_get_screensaver (_tmp0_);
		_tmp2_ = _tmp1_;
		gala_screen_saver_manager_register_object (_tmp2_, connection, "/org/gnome/ScreenSaver", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("DBus.vala:61: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda137__gbus_acquired_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda137_ (connection);
}

static void
__lambda138_ (void)
{
}

static void
___lambda138__gbus_name_acquired_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self)
{
	__lambda138_ ();
}

static void
__lambda139_ (void)
{
	g_critical ("DBus.vala:64: Could not acquire ScreenSaver bus");
}

static void
___lambda139__gbus_name_lost_callback (GDBusConnection* connection,
                                       const gchar* name,
                                       gpointer self)
{
	__lambda139_ ();
}

void
gala_dbus_init (GalaWindowManagerGala* _wm,
                GalaNotificationsManager* notifications_manager,
                GalaScreenshotManager* screenshot_manager)
{
	Block1Data* _data1_;
	GalaNotificationsManager* _tmp0_;
	GalaScreenshotManager* _tmp1_;
	GalaWindowManagerGala* _tmp2_;
	g_return_if_fail (_wm != NULL);
	g_return_if_fail (notifications_manager != NULL);
	g_return_if_fail (screenshot_manager != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (notifications_manager);
	_g_object_unref0 (_data1_->notifications_manager);
	_data1_->notifications_manager = _tmp0_;
	_tmp1_ = _g_object_ref0 (screenshot_manager);
	_g_object_unref0 (_data1_->screenshot_manager);
	_data1_->screenshot_manager = _tmp1_;
	_tmp2_ = _g_object_ref0 (_wm);
	_g_object_unref0 (gala_dbus_wm);
	gala_dbus_wm = _tmp2_;
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.pantheon.gala", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda111__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda111__gbus_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda121__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda121__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda122__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda122__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.Shell", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda123__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda123__gbus_acquired_callback, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref)), (GClosure*) ((___lambda124__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda124__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda125__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda125__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.Shell.Screenshot", G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((___lambda126__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda126__gbus_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda127__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda127__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda128__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda128__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.SessionManager.EndSessionDialog", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda129__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda129__gbus_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda135__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda135__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda136__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda136__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.ScreenSaver", G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((___lambda137__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda137__gbus_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda138__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda138__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda139__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda139__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

void
gala_dbus_perform_action (GalaDBus* self,
                          GalaActionType type,
                          GError** error)
{
	GalaWindowManagerGala* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_dbus_wm;
	gala_window_manager_perform_action ((GalaWindowManager*) _tmp0_, type);
}

GalaDBus*
gala_dbus_construct (GType object_type)
{
	GalaDBus* self = NULL;
	self = (GalaDBus*) g_type_create_instance (object_type);
	return self;
}

GalaDBus*
gala_dbus_new (void)
{
	return gala_dbus_construct (GALA_TYPE_DBUS);
}

static void
gala_value_dbus_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_value_dbus_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_dbus_unref (value->data[0].v_pointer);
	}
}

static void
gala_value_dbus_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_dbus_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_value_dbus_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_value_dbus_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaDBus * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_dbus_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_value_dbus_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	GalaDBus ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_dbus_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gala_param_spec_dbus (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	GalaParamSpecDBus* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_TYPE_DBUS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gala_value_get_dbus (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_DBUS), NULL);
	return value->data[0].v_pointer;
}

void
gala_value_set_dbus (GValue* value,
                     gpointer v_object)
{
	GalaDBus * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_DBUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_DBUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_dbus_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_dbus_unref (old);
	}
}

void
gala_value_take_dbus (GValue* value,
                      gpointer v_object)
{
	GalaDBus * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_DBUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_DBUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_dbus_unref (old);
	}
}

static void
gala_dbus_class_init (GalaDBusClass * klass,
                      gpointer klass_data)
{
	gala_dbus_parent_class = g_type_class_peek_parent (klass);
	((GalaDBusClass *) klass)->finalize = gala_dbus_finalize;
}

static void
gala_dbus_instance_init (GalaDBus * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_dbus_finalize (GalaDBus * obj)
{
	GalaDBus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DBUS, GalaDBus);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gala_dbus_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_value_dbus_init, gala_value_dbus_free_value, gala_value_dbus_copy_value, gala_value_dbus_peek_pointer, "p", gala_value_dbus_collect_value, "p", gala_value_dbus_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaDBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_dbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDBus), 0, (GInstanceInitFunc) gala_dbus_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_dbus_type_id;
	gala_dbus_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaDBus", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (gala_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_dbus_register_object);
	return gala_dbus_type_id;
}

GType
gala_dbus_get_type (void)
{
	static gsize gala_dbus_type_id__once = 0;
	if (g_once_init_enter (&gala_dbus_type_id__once)) {
		GType gala_dbus_type_id;
		gala_dbus_type_id = gala_dbus_get_type_once ();
		g_once_init_leave (&gala_dbus_type_id__once, gala_dbus_type_id);
	}
	return gala_dbus_type_id__once;
}

gpointer
gala_dbus_ref (gpointer instance)
{
	GalaDBus * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gala_dbus_unref (gpointer instance)
{
	GalaDBus * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_DBUS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_gala_dbus_perform_action (GalaDBus* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaActionType type = 0;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	gala_dbus_perform_action (self, type, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                      const gchar* sender,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* method_name,
                                      GVariant* parameters,
                                      GDBusMethodInvocation* invocation,
                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PerformAction") == 0) {
		_dbus_gala_dbus_perform_action (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* property_name,
                                       GError** error,
                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* property_name,
                                       GVariant* value,
                                       GError** error,
                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_dbus_register_object (gpointer object,
                           GDBusConnection* connection,
                           const gchar* path,
                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = gala_dbus_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_dbus_dbus_interface_info), &_gala_dbus_dbus_interface_vtable, data, _gala_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	gala_dbus_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

