/* BackgroundCache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundCache.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <meta/display.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_CACHE (gala_background_cache_get_type ())
#define GALA_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache))
#define GALA_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))
#define GALA_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))

typedef struct _GalaBackgroundCache GalaBackgroundCache;
typedef struct _GalaBackgroundCacheClass GalaBackgroundCacheClass;
typedef struct _GalaBackgroundCachePrivate GalaBackgroundCachePrivate;

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;

#define GALA_TYPE_ANIMATION (gala_animation_get_type ())
#define GALA_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ANIMATION, GalaAnimation))
#define GALA_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ANIMATION, GalaAnimationClass))
#define GALA_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ANIMATION))
#define GALA_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ANIMATION))
#define GALA_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ANIMATION, GalaAnimationClass))

typedef struct _GalaAnimation GalaAnimation;
typedef struct _GalaAnimationClass GalaAnimationClass;
enum  {
	GALA_BACKGROUND_CACHE_0_PROPERTY,
	GALA_BACKGROUND_CACHE_NUM_PROPERTIES
};
static GParamSpec* gala_background_cache_properties[GALA_BACKGROUND_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block41Data Block41Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block42Data Block42Data;
typedef struct _GalaBackgroundCacheGetAnimationData GalaBackgroundCacheGetAnimationData;
enum  {
	GALA_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL,
	GALA_BACKGROUND_CACHE_NUM_SIGNALS
};
static guint gala_background_cache_signals[GALA_BACKGROUND_CACHE_NUM_SIGNALS] = {0};

struct _GalaBackgroundCache {
	GObject parent_instance;
	GalaBackgroundCachePrivate * priv;
};

struct _GalaBackgroundCacheClass {
	GObjectClass parent_class;
};

struct _GalaBackgroundCachePrivate {
	GeeHashMap* file_monitors;
	GalaBackgroundSource* background_source;
	GalaAnimation* animation;
};

struct _Block41Data {
	int _ref_count_;
	GalaBackgroundCache* self;
	gchar* filename;
};

struct _Block42Data {
	int _ref_count_;
	GalaBackgroundCache* self;
	gpointer _async_data_;
};

struct _GalaBackgroundCacheGetAnimationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaBackgroundCache* self;
	gchar* filename;
	GalaAnimation* result;
	Block42Data* _data42_;
	gboolean _tmp0_;
	GalaAnimation* _tmp1_;
	GalaAnimation* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GalaAnimation* _tmp5_;
	GalaAnimation* _tmp6_;
	GalaAnimation* animation;
	GalaAnimation* _tmp7_;
	GalaAnimation* _tmp8_;
};

static gint GalaBackgroundCache_private_offset;
static gpointer gala_background_cache_parent_class = NULL;
static GalaBackgroundCache* gala_background_cache_instance;
static GalaBackgroundCache* gala_background_cache_instance = NULL;

VALA_EXTERN GType gala_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundCache, g_object_unref)
VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GType gala_animation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAnimation, g_object_unref)
VALA_EXTERN GalaBackgroundCache* gala_background_cache_get_default (void);
VALA_EXTERN GalaBackgroundCache* gala_background_cache_new (void);
VALA_EXTERN GalaBackgroundCache* gala_background_cache_construct (GType object_type);
VALA_EXTERN void gala_background_cache_monitor_file (GalaBackgroundCache* self,
                                         const gchar* filename);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void ___lambda19_ (Block41Data* _data41_);
static void ____lambda19__g_file_monitor_changed (GFileMonitor* _sender,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type,
                                           gpointer self);
static void gala_background_cache_get_animation_data_free (gpointer _data);
VALA_EXTERN void gala_background_cache_get_animation (GalaBackgroundCache* self,
                                          const gchar* filename,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN GalaAnimation* gala_background_cache_get_animation_finish (GalaBackgroundCache* self,
                                                           GAsyncResult* _res_);
static gboolean gala_background_cache_get_animation_co (GalaBackgroundCacheGetAnimationData* _data_);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
VALA_EXTERN const gchar* gala_animation_get_filename (GalaAnimation* self);
static gboolean ___lambda20_ (Block42Data* _data42_);
static gboolean ____lambda20__gsource_func (gpointer self);
VALA_EXTERN GalaAnimation* gala_animation_new (const gchar* filename);
VALA_EXTERN GalaAnimation* gala_animation_construct (GType object_type,
                                         const gchar* filename);
VALA_EXTERN void gala_animation_load (GalaAnimation* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void gala_animation_load_finish (GalaAnimation* self,
                                 GAsyncResult* _res_);
static void gala_background_cache_get_animation_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static gboolean __lambda21_ (Block42Data* _data42_);
static gboolean ___lambda21__gsource_func (gpointer self);
VALA_EXTERN GalaBackgroundSource* gala_background_cache_get_background_source (GalaBackgroundCache* self,
                                                                   MetaDisplay* display);
VALA_EXTERN GalaBackgroundSource* gala_background_source_new (MetaDisplay* display);
VALA_EXTERN GalaBackgroundSource* gala_background_source_construct (GType object_type,
                                                        MetaDisplay* display);
 G_GNUC_INTERNAL void gala_background_source_set_use_count (GalaBackgroundSource* self,
                                           gint value);
 G_GNUC_INTERNAL gint gala_background_source_get_use_count (GalaBackgroundSource* self);
VALA_EXTERN void gala_background_cache_release_background_source (GalaBackgroundCache* self);
VALA_EXTERN void gala_background_source_destroy (GalaBackgroundSource* self);
static GObject * gala_background_cache_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void gala_background_cache_finalize (GObject * obj);
static GType gala_background_cache_get_type_once (void);

static inline gpointer
gala_background_cache_get_instance_private (GalaBackgroundCache* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundCache_private_offset);
}

GalaBackgroundCache*
gala_background_cache_get_default (void)
{
	GalaBackgroundCache* _tmp0_;
	GalaBackgroundCache* _tmp2_;
	GalaBackgroundCache* result;
	_tmp0_ = gala_background_cache_instance;
	if (_tmp0_ == NULL) {
		GalaBackgroundCache* _tmp1_;
		_tmp1_ = gala_background_cache_new ();
		_g_object_unref0 (gala_background_cache_instance);
		gala_background_cache_instance = _tmp1_;
	}
	_tmp2_ = gala_background_cache_instance;
	result = _tmp2_;
	return result;
}

GalaBackgroundCache*
gala_background_cache_construct (GType object_type)
{
	GalaBackgroundCache * self = NULL;
	self = (GalaBackgroundCache*) g_object_new (object_type, NULL);
	return self;
}

GalaBackgroundCache*
gala_background_cache_new (void)
{
	return gala_background_cache_construct (GALA_TYPE_BACKGROUND_CACHE);
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		GalaBackgroundCache* self;
		self = _data41_->self;
		_g_free0 (_data41_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static void
___lambda19_ (Block41Data* _data41_)
{
	GalaBackgroundCache* self;
	self = _data41_->self;
	g_signal_emit (self, gala_background_cache_signals[GALA_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL], 0, _data41_->filename);
}

static void
____lambda19__g_file_monitor_changed (GFileMonitor* _sender,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event_type,
                                      gpointer self)
{
	___lambda19_ (self);
}

void
gala_background_cache_monitor_file (GalaBackgroundCache* self,
                                    const gchar* filename)
{
	Block41Data* _data41_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GFile* file = NULL;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data41_->filename);
	_data41_->filename = _tmp0_;
	_tmp1_ = self->priv->file_monitors;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _data41_->filename)) {
		block41_data_unref (_data41_);
		_data41_ = NULL;
		return;
	}
	_tmp2_ = g_file_new_for_path (_data41_->filename);
	file = _tmp2_;
	{
		GFileMonitor* monitor = NULL;
		GFile* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GeeHashMap* _tmp6_;
		GFileMonitor* _tmp7_;
		_tmp3_ = file;
		_tmp4_ = g_file_monitor (_tmp3_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		monitor = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = monitor;
		g_signal_connect_data (_tmp5_, "changed", (GCallback) ____lambda19__g_file_monitor_changed, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
		_tmp6_ = self->priv->file_monitors;
		_tmp7_ = monitor;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _data41_->filename, _tmp7_);
		_g_object_unref0 (monitor);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("BackgroundCache.vala:45: Failed to monitor %s: %s", _data41_->filename, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		block41_data_unref (_data41_);
		_data41_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}

static void
gala_background_cache_get_animation_data_free (gpointer _data)
{
	GalaBackgroundCacheGetAnimationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaBackgroundCacheGetAnimationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_background_cache_get_animation (GalaBackgroundCache* self,
                                     const gchar* filename,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GalaBackgroundCacheGetAnimationData* _data_;
	GalaBackgroundCache* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (GalaBackgroundCacheGetAnimationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_background_cache_get_animation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	gala_background_cache_get_animation_co (_data_);
}

GalaAnimation*
gala_background_cache_get_animation_finish (GalaBackgroundCache* self,
                                            GAsyncResult* _res_)
{
	GalaAnimation* result;
	GalaBackgroundCacheGetAnimationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		GalaBackgroundCache* self;
		self = _data42_->self;
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static gboolean
___lambda20_ (Block42Data* _data42_)
{
	GalaBackgroundCache* self;
	gboolean result;
	self = _data42_->self;
	gala_background_cache_get_animation_co (_data42_->_async_data_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda20_ (self);
	return result;
}

static void
gala_background_cache_get_animation_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GalaBackgroundCacheGetAnimationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_background_cache_get_animation_co (_data_);
}

static gboolean
__lambda21_ (Block42Data* _data42_)
{
	GalaBackgroundCache* self;
	gboolean result;
	self = _data42_->self;
	gala_background_cache_get_animation_co (_data42_->_async_data_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda21_ (self);
	return result;
}

static gboolean
gala_background_cache_get_animation_co (GalaBackgroundCacheGetAnimationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data42_ = g_slice_new0 (Block42Data);
	_data_->_data42_->_ref_count_ = 1;
	_data_->_data42_->self = g_object_ref (_data_->self);
	_data_->_data42_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->priv->animation;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->animation;
		_data_->_tmp3_ = gala_animation_get_filename (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = g_strcmp0 (_data_->_tmp4_, _data_->filename) == 0;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda20__gsource_func, block42_data_ref (_data_->_data42_), block42_data_unref);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp5_ = _data_->self->priv->animation;
		_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
		_data_->result = _data_->_tmp6_;
		block42_data_unref (_data_->_data42_);
		_data_->_data42_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = gala_animation_new (_data_->filename);
	_data_->animation = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->animation;
	_data_->_state_ = 2;
	gala_animation_load (_data_->_tmp8_, gala_background_cache_get_animation_ready, _data_);
	return FALSE;
	_state_2:
	gala_animation_load_finish (_data_->_tmp8_, _data_->_res_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda21__gsource_func, block42_data_ref (_data_->_data42_), block42_data_unref);
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	_data_->result = _data_->animation;
	block42_data_unref (_data_->_data42_);
	_data_->_data42_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GalaBackgroundSource*
gala_background_cache_get_background_source (GalaBackgroundCache* self,
                                             MetaDisplay* display)
{
	GalaBackgroundSource* _tmp0_;
	GalaBackgroundSource* _tmp6_;
	GalaBackgroundSource* _tmp7_;
	GalaBackgroundSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	_tmp0_ = self->priv->background_source;
	if (_tmp0_ == NULL) {
		GalaBackgroundSource* _tmp1_;
		GalaBackgroundSource* _tmp2_;
		_tmp1_ = gala_background_source_new (display);
		_g_object_unref0 (self->priv->background_source);
		self->priv->background_source = _tmp1_;
		_tmp2_ = self->priv->background_source;
		gala_background_source_set_use_count (_tmp2_, 1);
	} else {
		GalaBackgroundSource* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->background_source;
		_tmp4_ = gala_background_source_get_use_count (_tmp3_);
		_tmp5_ = _tmp4_;
		gala_background_source_set_use_count (_tmp3_, _tmp5_ + 1);
	}
	_tmp6_ = self->priv->background_source;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

void
gala_background_cache_release_background_source (GalaBackgroundCache* self)
{
	GalaBackgroundSource* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background_source;
	_tmp1_ = gala_background_source_get_use_count (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2_ = _tmp2_ - 1;
	_tmp3_ = _tmp2_;
	gala_background_source_set_use_count (_tmp0_, _tmp3_);
	if (_tmp3_ == 0) {
		GalaBackgroundSource* _tmp4_;
		_tmp4_ = self->priv->background_source;
		gala_background_source_destroy (_tmp4_);
	}
}

static GObject *
gala_background_cache_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackgroundCache * self;
	GeeHashMap* _tmp0_;
	parent_class = G_OBJECT_CLASS (gala_background_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_monitors);
	self->priv->file_monitors = _tmp0_;
	return obj;
}

static void
gala_background_cache_class_init (GalaBackgroundCacheClass * klass,
                                  gpointer klass_data)
{
	gala_background_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundCache_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_background_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_cache_finalize;
	gala_background_cache_signals[GALA_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL] = g_signal_new ("file-changed", GALA_TYPE_BACKGROUND_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
gala_background_cache_instance_init (GalaBackgroundCache * self,
                                     gpointer klass)
{
	self->priv = gala_background_cache_get_instance_private (self);
}

static void
gala_background_cache_finalize (GObject * obj)
{
	GalaBackgroundCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache);
	_g_object_unref0 (self->priv->file_monitors);
	_g_object_unref0 (self->priv->background_source);
	_g_object_unref0 (self->priv->animation);
	G_OBJECT_CLASS (gala_background_cache_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_background_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundCache), 0, (GInstanceInitFunc) gala_background_cache_instance_init, NULL };
	GType gala_background_cache_type_id;
	gala_background_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaBackgroundCache", &g_define_type_info, 0);
	GalaBackgroundCache_private_offset = g_type_add_instance_private (gala_background_cache_type_id, sizeof (GalaBackgroundCachePrivate));
	return gala_background_cache_type_id;
}

GType
gala_background_cache_get_type (void)
{
	static gsize gala_background_cache_type_id__once = 0;
	if (g_once_init_enter (&gala_background_cache_type_id__once)) {
		GType gala_background_cache_type_id;
		gala_background_cache_type_id = gala_background_cache_get_type_once ();
		g_once_init_leave (&gala_background_cache_type_id__once, gala_background_cache_type_id);
	}
	return gala_background_cache_type_id__once;
}

