/* CloseButton.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CloseButton.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <graphene-gobject.h>

#define GALA_CLOSE_BUTTON_ANIMATION_DURATION ((guint) 100)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_CLOSE_BUTTON_0_PROPERTY,
	GALA_CLOSE_BUTTON_SCALE_PROPERTY,
	GALA_CLOSE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* gala_close_button_properties[GALA_CLOSE_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GALA_CLOSE_BUTTON_TRIGGERED_SIGNAL,
	GALA_CLOSE_BUTTON_NUM_SIGNALS
};
static guint gala_close_button_signals[GALA_CLOSE_BUTTON_NUM_SIGNALS] = {0};

struct _GalaCloseButtonPrivate {
	gfloat _scale;
	ClutterActor* pixbuf_actor;
	gboolean is_pressed;
};

static gint GalaCloseButton_private_offset;
static gpointer gala_close_button_parent_class = NULL;
static GeeHashMap* gala_close_button_close_pixbufs;
static GeeHashMap* gala_close_button_close_pixbufs = NULL;

static GdkPixbuf* gala_close_button_get_close_button_pixbuf (gfloat scale);
static void gala_close_button_create_error_texture (GalaCloseButton* self);
static gboolean gala_close_button_real_button_press_event (ClutterActor* base,
                                                    ClutterEvent* e);
static gboolean gala_close_button_real_button_release_event (ClutterActor* base,
                                                      ClutterEvent* e);
static void gala_close_button_reset_scale (GalaCloseButton* self);
static gboolean gala_close_button_real_leave_event (ClutterActor* base,
                                             ClutterEvent* event);
static GObject * gala_close_button_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void gala_close_button_finalize (GObject * obj);
static GType gala_close_button_get_type_once (void);
static void _vala_gala_close_button_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_close_button_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_close_button_get_instance_private (GalaCloseButton* self)
{
	return G_STRUCT_MEMBER_P (self, GalaCloseButton_private_offset);
}

GalaCloseButton*
gala_close_button_construct (GType object_type,
                             gfloat scale)
{
	GalaCloseButton * self = NULL;
	self = (GalaCloseButton*) g_object_new (object_type, "scale", scale, NULL);
	return self;
}

GalaCloseButton*
gala_close_button_new (gfloat scale)
{
	return gala_close_button_construct (GALA_TYPE_CLOSE_BUTTON, scale);
}

static GdkPixbuf*
gala_close_button_get_close_button_pixbuf (gfloat scale)
{
	gint height = 0;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_;
	GeeHashMap* _tmp9_;
	gpointer _tmp10_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	height = gala_utils_scale_to_int (36, scale);
	_tmp0_ = gala_close_button_close_pixbufs;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) height));
	_tmp2_ = (GdkPixbuf*) _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		{
			GdkPixbuf* _tmp4_ = NULL;
			GdkPixbuf* _tmp5_;
			GeeHashMap* _tmp6_;
			_tmp5_ = gdk_pixbuf_new_from_resource_at_scale (RESOURCEPATH "/buttons/close.svg", -1, height, TRUE, &_inner_error0_);
			_tmp4_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = gala_close_button_close_pixbufs;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, (gpointer) ((gintptr) height), _tmp4_);
			_g_object_unref0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_critical ("CloseButton.vala:60: %s", _tmp8_);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = gala_close_button_close_pixbufs;
	_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, (gpointer) ((gintptr) height));
	result = (GdkPixbuf*) _tmp10_;
	return result;
}

static void
gala_close_button_create_error_texture (GalaCloseButton* self)
{
	gint size = 0;
	gfloat _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterColor _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	g_critical ("CloseButton.vala:72: Could not create close button");
	_tmp0_ = self->priv->_scale;
	size = gala_utils_scale_to_int (36, _tmp0_);
	_tmp1_ = self->priv->pixbuf_actor;
	clutter_actor_set_size (_tmp1_, (gfloat) size, (gfloat) size);
	_tmp2_ = self->priv->pixbuf_actor;
	_tmp3_.red = (guint8) 255;
	_tmp3_.green = (guint8) 0;
	_tmp3_.blue = (guint8) 0;
	_tmp3_.alpha = (guint8) 255;
	clutter_actor_set_background_color (_tmp2_, &_tmp3_);
}

static gboolean
gala_close_button_real_button_press_event (ClutterActor* base,
                                           ClutterEvent* e)
{
	GalaCloseButton * self;
	guint estimated_duration = 0U;
	gdouble _tmp0_;
	gdouble _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	gboolean result;
	self = (GalaCloseButton*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	g_object_get ((ClutterActor*) self, "scale-x", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	estimated_duration = (guint) ((GALA_CLOSE_BUTTON_ANIMATION_DURATION * (_tmp1_ - 0.8)) / 0.2);
	_tmp2_ = self->priv->pixbuf_actor;
	clutter_actor_save_easing_state (_tmp2_);
	_tmp3_ = self->priv->pixbuf_actor;
	clutter_actor_set_easing_duration (_tmp3_, estimated_duration);
	_tmp4_ = self->priv->pixbuf_actor;
	clutter_actor_set_easing_mode (_tmp4_, CLUTTER_EASE_IN_OUT);
	_tmp5_ = self->priv->pixbuf_actor;
	clutter_actor_set_scale (_tmp5_, 0.8, 0.8);
	_tmp6_ = self->priv->pixbuf_actor;
	clutter_actor_restore_easing_state (_tmp6_);
	self->priv->is_pressed = TRUE;
	result = CLUTTER_EVENT_STOP;
	return result;
}

static gboolean
gala_close_button_real_button_release_event (ClutterActor* base,
                                             ClutterEvent* e)
{
	GalaCloseButton * self;
	gboolean result;
	self = (GalaCloseButton*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	gala_close_button_reset_scale (self);
	if (self->priv->is_pressed) {
		g_signal_emit (self, gala_close_button_signals[GALA_CLOSE_BUTTON_TRIGGERED_SIGNAL], 0, clutter_event_get_time (e));
		self->priv->is_pressed = FALSE;
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

static gboolean
gala_close_button_real_leave_event (ClutterActor* base,
                                    ClutterEvent* event)
{
	GalaCloseButton * self;
	gboolean result;
	self = (GalaCloseButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gala_close_button_reset_scale (self);
	self->priv->is_pressed = FALSE;
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static void
gala_close_button_reset_scale (GalaCloseButton* self)
{
	guint estimated_duration = 0U;
	gdouble _tmp0_;
	gdouble _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	g_return_if_fail (self != NULL);
	g_object_get ((ClutterActor*) self, "scale-x", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	estimated_duration = (guint) ((GALA_CLOSE_BUTTON_ANIMATION_DURATION * (1.0 - _tmp1_)) / 0.2);
	_tmp2_ = self->priv->pixbuf_actor;
	clutter_actor_save_easing_state (_tmp2_);
	_tmp3_ = self->priv->pixbuf_actor;
	clutter_actor_set_easing_duration (_tmp3_, estimated_duration);
	_tmp4_ = self->priv->pixbuf_actor;
	clutter_actor_set_easing_mode (_tmp4_, CLUTTER_EASE_IN_OUT);
	_tmp5_ = self->priv->pixbuf_actor;
	clutter_actor_set_scale (_tmp5_, 1.0, 1.0);
	_tmp6_ = self->priv->pixbuf_actor;
	clutter_actor_restore_easing_state (_tmp6_);
}

gfloat
gala_close_button_get_scale (GalaCloseButton* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale;
	return result;
}

void
gala_close_button_set_scale (GalaCloseButton* self,
                             gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_close_button_get_scale (self);
	if (old_value != value) {
		self->priv->_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_close_button_properties[GALA_CLOSE_BUTTON_SCALE_PROPERTY]);
	}
}

static GObject *
gala_close_button_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaCloseButton * self;
	graphene_point_t _tmp0_ = {0};
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_;
	GdkPixbuf* pixbuf = NULL;
	gfloat _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (gala_close_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_CLOSE_BUTTON, GalaCloseButton);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_.x = 0.5f;
	_tmp0_.y = 0.5f;
	_tmp1_ = clutter_actor_new ();
	g_object_set (_tmp1_, "pivot-point", &_tmp0_, NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->pixbuf_actor);
	self->priv->pixbuf_actor = _tmp1_;
	_tmp2_ = self->priv->pixbuf_actor;
	clutter_actor_add_child ((ClutterActor*) self, _tmp2_);
	_tmp3_ = self->priv->_scale;
	_tmp4_ = gala_close_button_get_close_button_pixbuf (_tmp3_);
	pixbuf = _tmp4_;
	_tmp5_ = pixbuf;
	if (_tmp5_ != NULL) {
		{
			GalaImage* image = NULL;
			GdkPixbuf* _tmp6_;
			GalaImage* _tmp7_;
			ClutterActor* _tmp8_;
			GalaImage* _tmp9_;
			ClutterActor* _tmp10_;
			GdkPixbuf* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GdkPixbuf* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GdkPixbuf* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GdkPixbuf* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp6_ = pixbuf;
			_tmp7_ = gala_image_new_from_pixbuf (_tmp6_);
			image = _tmp7_;
			_tmp8_ = self->priv->pixbuf_actor;
			_tmp9_ = image;
			clutter_actor_set_content (_tmp8_, (ClutterContent*) _tmp9_);
			_tmp10_ = self->priv->pixbuf_actor;
			_tmp11_ = pixbuf;
			_tmp12_ = gdk_pixbuf_get_width (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = pixbuf;
			_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
			_tmp16_ = _tmp15_;
			clutter_actor_set_size (_tmp10_, (gfloat) _tmp13_, (gfloat) _tmp16_);
			_tmp17_ = pixbuf;
			_tmp18_ = gdk_pixbuf_get_width (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = pixbuf;
			_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
			_tmp22_ = _tmp21_;
			clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp19_, (gfloat) _tmp22_);
			_g_object_unref0 (image);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			gala_close_button_create_error_texture (self);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	} else {
		gala_close_button_create_error_texture (self);
	}
	_g_object_unref0 (pixbuf);
	return obj;
}

static void
gala_close_button_class_init (GalaCloseButtonClass * klass,
                              gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	gala_close_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaCloseButton_private_offset);
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_close_button_real_button_press_event;
	((ClutterActorClass *) klass)->button_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_close_button_real_button_release_event;
	((ClutterActorClass *) klass)->leave_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_close_button_real_leave_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_close_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_close_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_close_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_close_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_CLOSE_BUTTON_SCALE_PROPERTY, gala_close_button_properties[GALA_CLOSE_BUTTON_SCALE_PROPERTY] = g_param_spec_float ("scale", "scale", "scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gala_close_button_signals[GALA_CLOSE_BUTTON_TRIGGERED_SIGNAL] = g_signal_new ("triggered", GALA_TYPE_CLOSE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	_tmp0_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_close_button_close_pixbufs);
	gala_close_button_close_pixbufs = _tmp0_;
}

static void
gala_close_button_instance_init (GalaCloseButton * self,
                                 gpointer klass)
{
	self->priv = gala_close_button_get_instance_private (self);
	self->priv->is_pressed = FALSE;
}

static void
gala_close_button_finalize (GObject * obj)
{
	GalaCloseButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_CLOSE_BUTTON, GalaCloseButton);
	_g_object_unref0 (self->priv->pixbuf_actor);
	G_OBJECT_CLASS (gala_close_button_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_close_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaCloseButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_close_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaCloseButton), 0, (GInstanceInitFunc) gala_close_button_instance_init, NULL };
	GType gala_close_button_type_id;
	gala_close_button_type_id = g_type_register_static (clutter_actor_get_type (), "GalaCloseButton", &g_define_type_info, 0);
	GalaCloseButton_private_offset = g_type_add_instance_private (gala_close_button_type_id, sizeof (GalaCloseButtonPrivate));
	return gala_close_button_type_id;
}

GType
gala_close_button_get_type (void)
{
	static gsize gala_close_button_type_id__once = 0;
	if (g_once_init_enter (&gala_close_button_type_id__once)) {
		GType gala_close_button_type_id;
		gala_close_button_type_id = gala_close_button_get_type_once ();
		g_once_init_leave (&gala_close_button_type_id__once, gala_close_button_type_id);
	}
	return gala_close_button_type_id__once;
}

static void
_vala_gala_close_button_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaCloseButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_CLOSE_BUTTON, GalaCloseButton);
	switch (property_id) {
		case GALA_CLOSE_BUTTON_SCALE_PROPERTY:
		g_value_set_float (value, gala_close_button_get_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_close_button_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaCloseButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_CLOSE_BUTTON, GalaCloseButton);
	switch (property_id) {
		case GALA_CLOSE_BUTTON_SCALE_PROPERTY:
		gala_close_button_set_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

