/* avatar-details.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from avatar-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksAvatarDetailsChangeAvatarData FolksAvatarDetailsChangeAvatarData;

struct _FolksAvatarDetailsChangeAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksAvatarDetails* self;
	GLoadableIcon* avatar;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static void folks_avatar_details_real_change_avatar_data_free (gpointer _data);
static void folks_avatar_details_real_change_avatar (FolksAvatarDetails* self,
                                              GLoadableIcon* avatar,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean folks_avatar_details_real_change_avatar_co (FolksAvatarDetailsChangeAvatarData* _data_);
static GType folks_avatar_details_get_type_once (void);

static void
folks_avatar_details_real_change_avatar_data_free (gpointer _data)
{
	FolksAvatarDetailsChangeAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->avatar);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarDetailsChangeAvatarData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_avatar_details_real_change_avatar (FolksAvatarDetails* self,
                                         GLoadableIcon* avatar,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	FolksAvatarDetailsChangeAvatarData* _data_;
	FolksAvatarDetails* _tmp0_;
	GLoadableIcon* _tmp1_;
	_data_ = g_slice_new0 (FolksAvatarDetailsChangeAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_avatar_details_real_change_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (avatar);
	_g_object_unref0 (_data_->avatar);
	_data_->avatar = _tmp1_;
	folks_avatar_details_real_change_avatar_co (_data_);
}

static void
folks_avatar_details_real_change_avatar_finish (FolksAvatarDetails* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	FolksAvatarDetailsChangeAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's avatar.
   *
   * It's preferred to call this rather than setting
   * {@link AvatarDetails.avatar} directly, as this method gives error
   * notification and will only return once the avatar has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param avatar the new avatar (or ``null`` to unset the avatar)
   * @throws PropertyError if setting the avatar failed
   * @since 0.6.2
   */
static gboolean
folks_avatar_details_real_change_avatar_co (FolksAvatarDetailsChangeAvatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Avatar is not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_avatar_details_change_avatar (FolksAvatarDetails* self,
                                    GLoadableIcon* avatar,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksAvatarDetailsIface* _iface_;
	_iface_ = FOLKS_AVATAR_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_avatar) {
		_iface_->change_avatar (self, avatar, _callback_, _user_data_);
	}
}

void
folks_avatar_details_change_avatar_finish (FolksAvatarDetails* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	FolksAvatarDetailsIface* _iface_;
	_iface_ = FOLKS_AVATAR_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_avatar_finish) {
		_iface_->change_avatar_finish (self, _res_, error);
	}
}

GLoadableIcon*
folks_avatar_details_get_avatar (FolksAvatarDetails* self)
{
	FolksAvatarDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_AVATAR_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_avatar) {
		return _iface_->get_avatar (self);
	}
	return NULL;
}

void
folks_avatar_details_set_avatar (FolksAvatarDetails* self,
                                 GLoadableIcon* value)
{
	FolksAvatarDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_AVATAR_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_avatar) {
		_iface_->set_avatar (self, value);
	}
}

static void
folks_avatar_details_default_init (FolksAvatarDetailsIface * iface,
                                   gpointer iface_data)
{
	/**
	   * An avatar for the contact.
	   *
	   * The avatar may be ``null`` if unset. Otherwise, the image data may be
	   * asynchronously loaded using the methods of the {@link GLib.LoadableIcon}
	   * implementation.
	   *
	   * @since 0.6.0
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_avatar = folks_avatar_details_real_change_avatar;
	iface->change_avatar_finish = folks_avatar_details_real_change_avatar_finish;
}

/**
 * Avatar for a contact.
 *
 * This allows avatars to be associated with contacts. An avatar is a small
 * image file which represents the contact, such as a photo of them.
 *
 * @since 0.6.0
 */
static GType
folks_avatar_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksAvatarDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_avatar_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_avatar_details_type_id;
	folks_avatar_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksAvatarDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_avatar_details_type_id, G_TYPE_OBJECT);
	return folks_avatar_details_type_id;
}

GType
folks_avatar_details_get_type (void)
{
	static volatile gsize folks_avatar_details_type_id__once = 0;
	if (g_once_init_enter (&folks_avatar_details_type_id__once)) {
		GType folks_avatar_details_type_id;
		folks_avatar_details_type_id = folks_avatar_details_get_type_once ();
		g_once_init_leave (&folks_avatar_details_type_id__once, folks_avatar_details_type_id);
	}
	return folks_avatar_details_type_id__once;
}

