// Generated from libavcodec/vulkan/ffv1_dec_setup.comp
const char *ff_source_ffv1_dec_setup_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"uint8_t setup_state[CONTEXT_SIZE];\n"
"\n"
"uint get_usymbol(inout RangeCoder c)\n"
"{\n"
"    if (get_rac_direct(c, setup_state[0]))\n"
"        return 0;\n"
"\n"
"    int e = 0;\n"
"    while (get_rac_direct(c, setup_state[1 + min(e, 9)])) { // 1..10\n"
"        e++;\n"
"        if (e > 31) {\n"
"            corrupt = true;\n"
"            return 0;\n"
"        }\n"
"    }\n"
"\n"
"    uint a = 1;\n"
"    for (int i = e - 1; i >= 0; i--) {\n"
"        a <<= 1;\n"
"        a |= uint(get_rac_direct(c, setup_state[22 + min(i, 9)]));  // 22..31\n"
"    }\n"
"\n"
"    return a;\n"
"}\n"
"\n"
"bool decode_slice_header(inout SliceContext sc)\n"
"{\n"
"    [[unroll]]\n"
"    for (int i = 0; i < CONTEXT_SIZE; i++)\n"
"        setup_state[i] = uint8_t(128);\n"
"\n"
"    uint sx = get_usymbol(sc.c);\n"
"    uint sy = get_usymbol(sc.c);\n"
"    uint sw = get_usymbol(sc.c) + 1;\n"
"    uint sh = get_usymbol(sc.c) + 1;\n"
"\n"
"    if (sx < 0 || sy < 0 || sw <= 0 || sh <= 0 ||\n"
"        sx > (gl_NumWorkGroups.x - sw) || sy > (gl_NumWorkGroups.y - sh) ||\n"
"        corrupt) {\n"
"        return true;\n"
"    }\n"
"\n"
"    /* Set coordinates */\n"
"    uint sxs = slice_coord(img_size.x, sx     , gl_NumWorkGroups.x, chroma_shift.x);\n"
"    uint sxe = slice_coord(img_size.x, sx + sw, gl_NumWorkGroups.x, chroma_shift.x);\n"
"    uint sys = slice_coord(img_size.y, sy     , gl_NumWorkGroups.y, chroma_shift.y);\n"
"    uint sye = slice_coord(img_size.y, sy + sh, gl_NumWorkGroups.y, chroma_shift.y);\n"
"\n"
"    sc.slice_pos = ivec2(sxs, sys);\n"
"    sc.slice_dim = ivec2(sxe - sxs, sye - sys);\n"
"    sc.slice_rct_coef = ivec2(1, 1);\n"
"    sc.slice_coding_mode = int(0);\n"
"\n"
"    for (uint i = 0; i < codec_planes; i++) {\n"
"        uint idx = get_usymbol(sc.c);\n"
"        if (idx >= quant_table_count)\n"
"            return true;\n"
"        sc.quant_table_idx[i] = uint8_t(idx);\n"
"    }\n"
"\n"
"    get_usymbol(sc.c);\n"
"    get_usymbol(sc.c);\n"
"    get_usymbol(sc.c);\n"
"\n"
"    if (version >= 4) {\n"
"        sc.slice_reset_contexts = get_rac_direct(sc.c, setup_state[0]);\n"
"        sc.slice_coding_mode = get_usymbol(sc.c);\n"
"        if (sc.slice_coding_mode != 1 && colorspace == 1) {\n"
"            sc.slice_rct_coef.x = int(get_usymbol(sc.c));\n"
"            sc.slice_rct_coef.y = int(get_usymbol(sc.c));\n"
"            if (sc.slice_rct_coef.x + sc.slice_rct_coef.y > 4)\n"
"                return true;\n"
"        }\n"
"    }\n"
"\n"
"    return false;\n"
"}\n"
"\n"
"void golomb_init(inout SliceContext sc)\n"
"{\n"
"    if (version == 3 && micro_version > 1 || version > 3) {\n"
"        setup_state[0] = uint8_t(129);\n"
"        get_rac_direct(sc.c, setup_state[0]);\n"
"    }\n"
"\n"
"    uint64_t ac_byte_count = sc.c.bytestream - sc.c.bytestream_start - 1;\n"
"    init_get_bits(sc.gb, u8buf(sc.c.bytestream_start + ac_byte_count),\n"
"                  int(sc.c.bytestream_end - sc.c.bytestream_start - ac_byte_count));\n"
"}\n"
"\n"
"void main(void)\n"
"{\n"
"    const uint slice_idx = gl_WorkGroupID.y*gl_NumWorkGroups.x + gl_WorkGroupID.x;\n"
"\n"
"    u8buf bs = u8buf(slice_data + slice_offsets[2*slice_idx + 0]);\n"
"    uint32_t slice_size = slice_offsets[2*slice_idx + 1];\n"
"\n"
"    rac_init_dec(slice_ctx[slice_idx].c,\n"
"                 bs, slice_size);\n"
"\n"
"    if (slice_idx == (gl_NumWorkGroups.x*gl_NumWorkGroups.y - 1))\n"
"        get_rac_equi(slice_ctx[slice_idx].c);\n"
"\n"
"    decode_slice_header(slice_ctx[slice_idx]);\n"
"\n"
"    if (golomb == 1)\n"
"        golomb_init(slice_ctx[slice_idx]);\n"
"\n"
"    if (ec != 0 && check_crc != 0) {\n"
"        uint32_t crc = crcref;\n"
"        for (int i = 0; i < slice_size; i++)\n"
"            crc = crc_ieee[(crc & 0xFF) ^ uint32_t(bs[i].v)] ^ (crc >> 8);\n"
"\n"
"        slice_status[2*slice_idx + 0] = crc;\n"
"    }\n"
"\n"
"    slice_status[2*slice_idx + 1] = corrupt ? uint32_t(corrupt) : overread;\n"
"}\n"
;
