// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	context "context"

	ciliumiov2 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CiliumNodesGetter has a method to return a CiliumNodeInterface.
// A group's client should implement this interface.
type CiliumNodesGetter interface {
	CiliumNodes() CiliumNodeInterface
}

// CiliumNodeInterface has methods to work with CiliumNode resources.
type CiliumNodeInterface interface {
	Create(ctx context.Context, ciliumNode *ciliumiov2.CiliumNode, opts v1.CreateOptions) (*ciliumiov2.CiliumNode, error)
	Update(ctx context.Context, ciliumNode *ciliumiov2.CiliumNode, opts v1.UpdateOptions) (*ciliumiov2.CiliumNode, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, ciliumNode *ciliumiov2.CiliumNode, opts v1.UpdateOptions) (*ciliumiov2.CiliumNode, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*ciliumiov2.CiliumNode, error)
	List(ctx context.Context, opts v1.ListOptions) (*ciliumiov2.CiliumNodeList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *ciliumiov2.CiliumNode, err error)
	CiliumNodeExpansion
}

// ciliumNodes implements CiliumNodeInterface
type ciliumNodes struct {
	*gentype.ClientWithList[*ciliumiov2.CiliumNode, *ciliumiov2.CiliumNodeList]
}

// newCiliumNodes returns a CiliumNodes
func newCiliumNodes(c *CiliumV2Client) *ciliumNodes {
	return &ciliumNodes{
		gentype.NewClientWithList[*ciliumiov2.CiliumNode, *ciliumiov2.CiliumNodeList](
			"ciliumnodes",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *ciliumiov2.CiliumNode { return &ciliumiov2.CiliumNode{} },
			func() *ciliumiov2.CiliumNodeList { return &ciliumiov2.CiliumNodeList{} },
		),
	}
}
