/* src/bazaar.p/bz-main-config.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>
#include "bz-hook.h"

G_BEGIN_DECLS



#define BZ_TYPE_MAIN_CONFIG (bz_main_config_get_type ())
G_DECLARE_FINAL_TYPE (BzMainConfig, bz_main_config, BZ, MAIN_CONFIG, GObject)

BzMainConfig *
bz_main_config_new (void);

GListModel *
bz_main_config_get_txt_blocklist_paths (BzMainConfig *self);

int
bz_main_config_get_blocklist_version (BzMainConfig *self);

GListModel *
bz_main_config_get_yaml_blocklist_paths (BzMainConfig *self);

int
bz_main_config_get_curated_config_version (BzMainConfig *self);

GListModel *
bz_main_config_get_curated_config_paths (BzMainConfig *self);

GListModel *
bz_main_config_get_hooks (BzMainConfig *self);

void
bz_main_config_set_txt_blocklist_paths (BzMainConfig *self,
    GListModel *txt_blocklist_paths);

void
bz_main_config_set_blocklist_version (BzMainConfig *self,
    int blocklist_version);

void
bz_main_config_set_yaml_blocklist_paths (BzMainConfig *self,
    GListModel *yaml_blocklist_paths);

void
bz_main_config_set_curated_config_version (BzMainConfig *self,
    int curated_config_version);

void
bz_main_config_set_curated_config_paths (BzMainConfig *self,
    GListModel *curated_config_paths);

void
bz_main_config_set_hooks (BzMainConfig *self,
    GListModel *hooks);

G_END_DECLS

/* End of src/bazaar.p/bz-main-config.h */
