/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_SCREEN_EDGE_V1_SERVER_PROTOCOL_H
#define KDE_SCREEN_EDGE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_screen_edge_v1 The kde_screen_edge_v1 protocol
 * @section page_ifaces_kde_screen_edge_v1 Interfaces
 * - @subpage page_iface_kde_screen_edge_manager_v1 - screen edge manager
 * - @subpage page_iface_kde_auto_hide_screen_edge_v1 - auto hide screen edge
 * @section page_copyright_kde_screen_edge_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2023 Vlad Zahorodnii
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_auto_hide_screen_edge_v1;
struct kde_screen_edge_manager_v1;
struct wl_surface;

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_INTERFACE
#define KDE_SCREEN_EDGE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_kde_screen_edge_manager_v1 kde_screen_edge_manager_v1
 * @section page_iface_kde_screen_edge_manager_v1_desc Description
 *
 * This interface allows clients to associate actions with screen edges. For
 * example, showing a surface by moving the pointer to a screen edge.
 *
 * Potential ways to trigger the screen edge are subject to compositor
 * policies. As an example, the compositor may consider the screen edge to be
 * triggered if the pointer hits its associated screen border. Other ways may
 * include using touchscreen or touchpad gestures.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 * @section page_iface_kde_screen_edge_manager_v1_api API
 * See @ref iface_kde_screen_edge_manager_v1.
 */
/**
 * @defgroup iface_kde_screen_edge_manager_v1 The kde_screen_edge_manager_v1 interface
 *
 * This interface allows clients to associate actions with screen edges. For
 * example, showing a surface by moving the pointer to a screen edge.
 *
 * Potential ways to trigger the screen edge are subject to compositor
 * policies. As an example, the compositor may consider the screen edge to be
 * triggered if the pointer hits its associated screen border. Other ways may
 * include using touchscreen or touchpad gestures.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 */
extern const struct wl_interface kde_screen_edge_manager_v1_interface;
#endif
#ifndef KDE_AUTO_HIDE_SCREEN_EDGE_V1_INTERFACE
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_INTERFACE
/**
 * @page page_iface_kde_auto_hide_screen_edge_v1 kde_auto_hide_screen_edge_v1
 * @section page_iface_kde_auto_hide_screen_edge_v1_desc Description
 *
 * The auto hide screen edge object allows to hide the surface and make it
 * visible by triggering the screen edge. The screen edge is inactive and
 * the surface is visible by default.
 *
 * This interface can be used to implement user interface elements such as
 * auto-hide panels or docks.
 *
 * kde_auto_hide_screen_edge_v1.activate activates the screen edge and makes
 * the surface hidden. The surface can be made visible by triggering the
 * screen edge or calling kde_auto_hide_screen_edge_v1.deactivate.
 *
 * If the screen edge has been triggered, it won't be re-activated again.
 * Another kde_auto_hide_screen_edge_v1.activate request must be made by the
 * client to activate the screen edge.
 * @section page_iface_kde_auto_hide_screen_edge_v1_api API
 * See @ref iface_kde_auto_hide_screen_edge_v1.
 */
/**
 * @defgroup iface_kde_auto_hide_screen_edge_v1 The kde_auto_hide_screen_edge_v1 interface
 *
 * The auto hide screen edge object allows to hide the surface and make it
 * visible by triggering the screen edge. The screen edge is inactive and
 * the surface is visible by default.
 *
 * This interface can be used to implement user interface elements such as
 * auto-hide panels or docks.
 *
 * kde_auto_hide_screen_edge_v1.activate activates the screen edge and makes
 * the surface hidden. The surface can be made visible by triggering the
 * screen edge or calling kde_auto_hide_screen_edge_v1.deactivate.
 *
 * If the screen edge has been triggered, it won't be re-activated again.
 * Another kde_auto_hide_screen_edge_v1.activate request must be made by the
 * client to activate the screen edge.
 */
extern const struct wl_interface kde_auto_hide_screen_edge_v1_interface;
#endif

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM
#define KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM
enum kde_screen_edge_manager_v1_error {
	/**
	 * the specified border value is invalid
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_ERROR_INVALID_BORDER = 0,
	/**
	 * the surface has invalid role
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_ERROR_INVALID_ROLE = 1,
	/**
	 * the surface already has a screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ALREADY_CONSTRUCTED = 2,
};
#endif /* KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM */

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM_IS_VALID
#define KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_kde_screen_edge_manager_v1
 * Validate a kde_screen_edge_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref kde_screen_edge_manager_v1_error
 */
static inline bool
kde_screen_edge_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_SCREEN_EDGE_MANAGER_V1_ERROR_INVALID_BORDER:
		return version >= 1;
	case KDE_SCREEN_EDGE_MANAGER_V1_ERROR_INVALID_ROLE:
		return version >= 1;
	case KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ALREADY_CONSTRUCTED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM_IS_VALID */

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM
#define KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM
/**
 * @ingroup iface_kde_screen_edge_manager_v1
 * screen border
 *
 * These values describe possible screen borders.
 */
enum kde_screen_edge_manager_v1_border {
	/**
	 * top screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_TOP = 1,
	/**
	 * bottom screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_BOTTOM = 2,
	/**
	 * left screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_LEFT = 3,
	/**
	 * right screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_RIGHT = 4,
};
#endif /* KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM */

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM_IS_VALID
#define KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM_IS_VALID
/**
 * @ingroup iface_kde_screen_edge_manager_v1
 * Validate a kde_screen_edge_manager_v1 border value.
 *
 * @return true on success, false on error.
 * @ref kde_screen_edge_manager_v1_border
 */
static inline bool
kde_screen_edge_manager_v1_border_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_SCREEN_EDGE_MANAGER_V1_BORDER_TOP:
		return version >= 1;
	case KDE_SCREEN_EDGE_MANAGER_V1_BORDER_BOTTOM:
		return version >= 1;
	case KDE_SCREEN_EDGE_MANAGER_V1_BORDER_LEFT:
		return version >= 1;
	case KDE_SCREEN_EDGE_MANAGER_V1_BORDER_RIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM_IS_VALID */

/**
 * @ingroup iface_kde_screen_edge_manager_v1
 * @struct kde_screen_edge_manager_v1_interface
 */
struct kde_screen_edge_manager_v1_interface {
	/**
	 * destroy the screen edge manager
	 *
	 * Destroy the screen edge manager. This doesn't destroy objects
	 * created with this manager.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create an auto hide edge
	 *
	 * Create a new auto hide screen edge object associated with the
	 * specified surface and the border.
	 *
	 * Creating a kde_auto_hide_screen_edge_v1 object does not change
	 * the visibility of the surface. The
	 * kde_auto_hide_screen_edge_v1.activate request must be issued in
	 * order to hide the surface.
	 *
	 * The "border" argument must be a valid enum entry, otherwise the
	 * invalid_border protocol error is raised.
	 *
	 * The invalid_role protocol error will be raised if the specified
	 * surface does not have layer_surface role.
	 * @param id the new screen edge
	 * @param border the associated screen border
	 * @param surface the surface
	 */
	void (*get_auto_hide_screen_edge)(struct wl_client *client,
					  struct wl_resource *resource,
					  uint32_t id,
					  uint32_t border,
					  struct wl_resource *surface);
};


/**
 * @ingroup iface_kde_screen_edge_manager_v1
 */
#define KDE_SCREEN_EDGE_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_screen_edge_manager_v1
 */
#define KDE_SCREEN_EDGE_MANAGER_V1_GET_AUTO_HIDE_SCREEN_EDGE_SINCE_VERSION 1

/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 * @struct kde_auto_hide_screen_edge_v1_interface
 */
struct kde_auto_hide_screen_edge_v1_interface {
	/**
	 * destroy the auto hide screen edge object
	 *
	 * Destroy the auto hide screen edge object. If the screen edge
	 * is active, it will be deactivated and the surface will be made
	 * visible.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * deactivate the screen edge
	 *
	 * Deactivate the screen edge. The surface will be made visible.
	 */
	void (*deactivate)(struct wl_client *client,
			   struct wl_resource *resource);
	/**
	 * activate the screen edge
	 *
	 * Activate the screen edge. The surface will be hidden until the
	 * screen edge is triggered.
	 */
	void (*activate)(struct wl_client *client,
			 struct wl_resource *resource);
};


/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 */
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 */
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_DEACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 */
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_ACTIVATE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
