[![Build Status](https://github.com/gap-packages/nq/workflows/CI/badge.svg?branch=master)](https://github.com/gap-packages/nq/actions?query=workflow%3ACI+branch%3Amaster)
[![Code Coverage](https://codecov.io/github/gap-packages/nq/coverage.svg?branch=master&token=)](https://codecov.io/gh/gap-packages/nq)

The ANU Nilpotent Quotient Program
==================================


Nilpotent quotients
-------------------

The lower  central series G_i of a  group G can be defined inductively
as G_0 = G, G_i = [G_(i-1),G]. G is said to have nilpotency class c if
c is the smallest non-zero integer such that G_c = 1. If N is a normal
subgroup  of G and G/N   is nilpotent, then  N  contains G_i for  some
non-negative integer i. G has infinite nilpotent quotients if and only
if G/G_1  is infinite.  The  i-th (i  > 1)  factor G_(i-1)/G_i of  the
lower central series  is generated by  the elements [g,h]G_i,  where g
runs through a  set of representatives of  G/G_1 and h runs  through a
set of representatives of G_(i-2)/G_(i-1).

Any  finitely generated nilpotent group  is polycyclic and, therefore,
has  a subnormal series with  cyclic factors.  Such a subnormal series
can be used   to  represent  the group  in   terms of   a   polycyclic
presentation.    The ANU NQ  computes  successively  the factor groups
modulo  the terms of the lower  central series.   Each factor group is
represented by a special  form of polycyclic presentation, a nilpotent
presentation, that makes use of the  nilpotent structure of the factor
group.  Chapters  9 and 11 of the  book by C.C.  Sims, "Computing with
finitely presented groups", discusses  polycyclic presentations  and a
nilpotent quotient algorithm.  A description of this implementation is
contained in 

Werner  Nickel  (1996) "Computing    Nilpotent Quotients   of Finitely
Presented    Groups" in  Dimacs  Series  in   Discrete Mathematics and
Theoretical Computer Science, Volume 25, pp 175-191.


About this version
------------------

This directory  contains the Australian National  University Nilpotent
Quotient Program (ANU  NQ), an implementation of  a nilpotent quotient
algorithm  in C.  This implementation  has  been developed  in a  Unix
environment and Unix is currently the only operating system supported.
It runs on a number of  different Unix versions. An earlier version of
the ANU NQ is also available as  part of quotpic (Derek F. Holt, Sarah
Rees: A  graphics system for  displaying finite quotients  of finitely
presented groups.  DIMACS Workshop on Groups  and Computation, AMS-ACM
1991).


How to install the ANU NQ
-------------------------

Please refer to the manual for installation instructions.
 
How to use the ANU NQ
---------------------

Please refer to the manual for instructions on how to use ANU NQ via
the GAP interface or directly via the command line interface.


Acknowledgements
----------------
The author of ANU NQ is Werner Nickel.

The   development of this  program  was started  while  the author was
supported by an Australian National University  PhD scholarship and an
Overseas Postgraduate Research Scholarship.

Further  development  of  this  program  was  done  while  the  author
was  supported   by   the   DFG-Schwerpunkt-Projekt   "Algorithmische
Zahlentheorie und Algebra".

Since then, maintenance of ANU NQ has been taken over by Max Horn. All
credit for creating ANU NQ still goes to Werner Nickel as sole author.
However, bug reports and other  inquiries should be sent to Max  Horn.


Contact addresses
-----------------
Bug reports and other requests should be sent to the issue tracker
 <https://github.com/gap-packages/nq/issues>
