# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## ClosedMonoidalLeftCoevaluationMorphism
InstallMethod( AddClosedMonoidalLeftCoevaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalLeftCoevaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalLeftCoevaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalLeftCoevaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ClosedMonoidalLeftCoevaluationMorphismWithGivenRange
InstallMethod( AddClosedMonoidalLeftCoevaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalLeftCoevaluationMorphismWithGivenRange", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalLeftCoevaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalLeftCoevaluationMorphismWithGivenRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ClosedMonoidalLeftCoevaluationMorphismWithGivenRange,
                    "ClosedMonoidalLeftCoevaluationMorphismWithGivenRange by calling ClosedMonoidalLeftCoevaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ ClosedMonoidalLeftCoevaluationMorphism, 1 ],
                    ],
  function( cat, a, b, r )
    
    return ClosedMonoidalLeftCoevaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ClosedMonoidalLeftCoevaluationMorphism,
                    "ClosedMonoidalLeftCoevaluationMorphism by calling ClosedMonoidalLeftCoevaluationMorphismWithGivenRange with the WithGiven object(s)",
                    [
                        [ ClosedMonoidalLeftCoevaluationMorphismWithGivenRange, 1 ],
                        [ InternalHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return ClosedMonoidalLeftCoevaluationMorphismWithGivenRange( cat, a, b, InternalHomOnObjects( cat, a, TensorProductOnObjects( cat, b, a ) ) );
    
end : is_with_given_derivation := true );

## ClosedMonoidalLeftEvaluationMorphism
InstallMethod( AddClosedMonoidalLeftEvaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalLeftEvaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalLeftEvaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalLeftEvaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ClosedMonoidalLeftEvaluationMorphismWithGivenSource
InstallMethod( AddClosedMonoidalLeftEvaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalLeftEvaluationMorphismWithGivenSource", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalLeftEvaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalLeftEvaluationMorphismWithGivenSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ClosedMonoidalLeftEvaluationMorphismWithGivenSource,
                    "ClosedMonoidalLeftEvaluationMorphismWithGivenSource by calling ClosedMonoidalLeftEvaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ ClosedMonoidalLeftEvaluationMorphism, 1 ],
                    ],
  function( cat, a, b, s )
    
    return ClosedMonoidalLeftEvaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ClosedMonoidalLeftEvaluationMorphism,
                    "ClosedMonoidalLeftEvaluationMorphism by calling ClosedMonoidalLeftEvaluationMorphismWithGivenSource with the WithGiven object(s)",
                    [
                        [ ClosedMonoidalLeftEvaluationMorphismWithGivenSource, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ InternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return ClosedMonoidalLeftEvaluationMorphismWithGivenSource( cat, a, b, TensorProductOnObjects( cat, InternalHomOnObjects( cat, a, b ), a ) );
    
end : is_with_given_derivation := true );

## ClosedMonoidalRightCoevaluationMorphism
InstallMethod( AddClosedMonoidalRightCoevaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalRightCoevaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalRightCoevaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalRightCoevaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ClosedMonoidalRightCoevaluationMorphismWithGivenRange
InstallMethod( AddClosedMonoidalRightCoevaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalRightCoevaluationMorphismWithGivenRange", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalRightCoevaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalRightCoevaluationMorphismWithGivenRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ClosedMonoidalRightCoevaluationMorphismWithGivenRange,
                    "ClosedMonoidalRightCoevaluationMorphismWithGivenRange by calling ClosedMonoidalRightCoevaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ ClosedMonoidalRightCoevaluationMorphism, 1 ],
                    ],
  function( cat, a, b, r )
    
    return ClosedMonoidalRightCoevaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ClosedMonoidalRightCoevaluationMorphism,
                    "ClosedMonoidalRightCoevaluationMorphism by calling ClosedMonoidalRightCoevaluationMorphismWithGivenRange with the WithGiven object(s)",
                    [
                        [ ClosedMonoidalRightCoevaluationMorphismWithGivenRange, 1 ],
                        [ InternalHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return ClosedMonoidalRightCoevaluationMorphismWithGivenRange( cat, a, b, InternalHomOnObjects( cat, a, TensorProductOnObjects( cat, a, b ) ) );
    
end : is_with_given_derivation := true );

## ClosedMonoidalRightEvaluationMorphism
InstallMethod( AddClosedMonoidalRightEvaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalRightEvaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalRightEvaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalRightEvaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ClosedMonoidalRightEvaluationMorphismWithGivenSource
InstallMethod( AddClosedMonoidalRightEvaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ClosedMonoidalRightEvaluationMorphismWithGivenSource", category, func, -1 );
    
end );

InstallMethod( AddClosedMonoidalRightEvaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ClosedMonoidalRightEvaluationMorphismWithGivenSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ClosedMonoidalRightEvaluationMorphismWithGivenSource,
                    "ClosedMonoidalRightEvaluationMorphismWithGivenSource by calling ClosedMonoidalRightEvaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ ClosedMonoidalRightEvaluationMorphism, 1 ],
                    ],
  function( cat, a, b, s )
    
    return ClosedMonoidalRightEvaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ClosedMonoidalRightEvaluationMorphism,
                    "ClosedMonoidalRightEvaluationMorphism by calling ClosedMonoidalRightEvaluationMorphismWithGivenSource with the WithGiven object(s)",
                    [
                        [ ClosedMonoidalRightEvaluationMorphismWithGivenSource, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ InternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return ClosedMonoidalRightEvaluationMorphismWithGivenSource( cat, a, b, TensorProductOnObjects( cat, a, InternalHomOnObjects( cat, a, b ) ) );
    
end : is_with_given_derivation := true );

## DualOnMorphisms
InstallMethod( AddDualOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DualOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddDualOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DualOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## DualOnMorphismsWithGivenDuals
InstallMethod( AddDualOnMorphismsWithGivenDuals,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DualOnMorphismsWithGivenDuals", category, func, -1 );
    
end );

InstallMethod( AddDualOnMorphismsWithGivenDuals,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DualOnMorphismsWithGivenDuals", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( DualOnMorphismsWithGivenDuals,
                    "DualOnMorphismsWithGivenDuals by calling DualOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ DualOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, r )
    
    return DualOnMorphisms( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( DualOnMorphisms,
                    "DualOnMorphisms by calling DualOnMorphismsWithGivenDuals with the WithGiven object(s)",
                    [
                        [ DualOnMorphismsWithGivenDuals, 1 ],
                        [ DualOnObjects, 2 ],
                    ],
  function( cat, alpha )
    
    return DualOnMorphismsWithGivenDuals( cat, DualOnObjects( cat, Range( alpha ) ), alpha, DualOnObjects( cat, Source( alpha ) ) );
    
end : is_with_given_derivation := true );

## DualOnObjects
InstallMethod( AddDualOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DualOnObjects", category, func, -1 );
    
end );

InstallMethod( AddDualOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DualOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EvaluationForDual
InstallMethod( AddEvaluationForDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EvaluationForDual", category, func, -1 );
    
end );

InstallMethod( AddEvaluationForDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EvaluationForDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EvaluationForDualWithGivenTensorProduct
InstallMethod( AddEvaluationForDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EvaluationForDualWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddEvaluationForDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EvaluationForDualWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( EvaluationForDualWithGivenTensorProduct,
                    "EvaluationForDualWithGivenTensorProduct by calling EvaluationForDual with the WithGiven argument(s) dropped",
                    [
                        [ EvaluationForDual, 1 ],
                    ],
  function( cat, s, a, r )
    
    return EvaluationForDual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( EvaluationForDual,
                    "EvaluationForDual by calling EvaluationForDualWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ EvaluationForDualWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ DualOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return EvaluationForDualWithGivenTensorProduct( cat, TensorProductOnObjects( cat, DualOnObjects( cat, a ), a ), a, TensorUnit( cat ) );
    
end : is_with_given_derivation := true );

## InternalHomOnMorphisms
InstallMethod( AddInternalHomOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddInternalHomOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalHomOnMorphismsWithGivenInternalHoms
InstallMethod( AddInternalHomOnMorphismsWithGivenInternalHoms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomOnMorphismsWithGivenInternalHoms", category, func, -1 );
    
end );

InstallMethod( AddInternalHomOnMorphismsWithGivenInternalHoms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomOnMorphismsWithGivenInternalHoms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalHomOnMorphismsWithGivenInternalHoms,
                    "InternalHomOnMorphismsWithGivenInternalHoms by calling InternalHomOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ InternalHomOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, beta, r )
    
    return InternalHomOnMorphisms( cat, alpha, beta );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalHomOnMorphisms,
                    "InternalHomOnMorphisms by calling InternalHomOnMorphismsWithGivenInternalHoms with the WithGiven object(s)",
                    [
                        [ InternalHomOnMorphismsWithGivenInternalHoms, 1 ],
                        [ InternalHomOnObjects, 2 ],
                    ],
  function( cat, alpha, beta )
    
    return InternalHomOnMorphismsWithGivenInternalHoms( cat, InternalHomOnObjects( cat, Range( alpha ), Source( beta ) ), alpha, beta, InternalHomOnObjects( cat, Source( alpha ), Range( beta ) ) );
    
end : is_with_given_derivation := true );

## InternalHomOnObjects
InstallMethod( AddInternalHomOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomOnObjects", category, func, -1 );
    
end );

InstallMethod( AddInternalHomOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalHomToTensorProductLeftAdjunctMorphism
InstallMethod( AddInternalHomToTensorProductLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductLeftAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductLeftAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct
InstallMethod( AddInternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct,
                    "InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct by calling InternalHomToTensorProductLeftAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ InternalHomToTensorProductLeftAdjunctMorphism, 1 ],
                    ],
  function( cat, b, c, g, s )
    
    return InternalHomToTensorProductLeftAdjunctMorphism( cat, b, c, g );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalHomToTensorProductLeftAdjunctMorphism,
                    "InternalHomToTensorProductLeftAdjunctMorphism by calling InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, b, c, g )
    
    return InternalHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct( cat, b, c, g, TensorProductOnObjects( cat, Source( g ), b ) );
    
end : is_with_given_derivation := true );

## InternalHomToTensorProductLeftAdjunctionIsomorphism
InstallMethod( AddInternalHomToTensorProductLeftAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductLeftAdjunctionIsomorphism", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductLeftAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductLeftAdjunctionIsomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects
InstallMethod( AddInternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects,
                    "InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects by calling InternalHomToTensorProductLeftAdjunctionIsomorphism with the WithGiven argument(s) dropped",
                    [
                        [ InternalHomToTensorProductLeftAdjunctionIsomorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return InternalHomToTensorProductLeftAdjunctionIsomorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalHomToTensorProductLeftAdjunctionIsomorphism,
                    "InternalHomToTensorProductLeftAdjunctionIsomorphism by calling InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects, 1 ],
                        [ InternalHomOnObjects, 1 ],
                        [ HomomorphismStructureOnObjects, 2 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return InternalHomToTensorProductLeftAdjunctionIsomorphismWithGivenObjects( cat, HomomorphismStructureOnObjects( cat, a, InternalHomOnObjects( cat, b, c ) ), a, b, c, HomomorphismStructureOnObjects( cat, TensorProductOnObjects( cat, a, b ), c ) );
    
end : is_with_given_derivation := true );

## InternalHomToTensorProductRightAdjunctMorphism
InstallMethod( AddInternalHomToTensorProductRightAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductRightAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductRightAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductRightAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct
InstallMethod( AddInternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct,
                    "InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct by calling InternalHomToTensorProductRightAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ InternalHomToTensorProductRightAdjunctMorphism, 1 ],
                    ],
  function( cat, a, c, g, s )
    
    return InternalHomToTensorProductRightAdjunctMorphism( cat, a, c, g );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalHomToTensorProductRightAdjunctMorphism,
                    "InternalHomToTensorProductRightAdjunctMorphism by calling InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, c, g )
    
    return InternalHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct( cat, a, c, g, TensorProductOnObjects( cat, a, Source( g ) ) );
    
end : is_with_given_derivation := true );

## InternalHomToTensorProductRightAdjunctionIsomorphism
InstallMethod( AddInternalHomToTensorProductRightAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductRightAdjunctionIsomorphism", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductRightAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductRightAdjunctionIsomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects
InstallMethod( AddInternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddInternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects,
                    "InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects by calling InternalHomToTensorProductRightAdjunctionIsomorphism with the WithGiven argument(s) dropped",
                    [
                        [ InternalHomToTensorProductRightAdjunctionIsomorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return InternalHomToTensorProductRightAdjunctionIsomorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalHomToTensorProductRightAdjunctionIsomorphism,
                    "InternalHomToTensorProductRightAdjunctionIsomorphism by calling InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects, 1 ],
                        [ InternalHomOnObjects, 1 ],
                        [ HomomorphismStructureOnObjects, 2 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return InternalHomToTensorProductRightAdjunctionIsomorphismWithGivenObjects( cat, HomomorphismStructureOnObjects( cat, b, InternalHomOnObjects( cat, a, c ) ), a, b, c, HomomorphismStructureOnObjects( cat, TensorProductOnObjects( cat, a, b ), c ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromDualObjectToInternalHomIntoTensorUnit
InstallMethod( AddIsomorphismFromDualObjectToInternalHomIntoTensorUnit,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromDualObjectToInternalHomIntoTensorUnit", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromDualObjectToInternalHomIntoTensorUnit,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromDualObjectToInternalHomIntoTensorUnit", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromInternalHomIntoTensorUnitToDualObject
InstallMethod( AddIsomorphismFromInternalHomIntoTensorUnitToDualObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalHomIntoTensorUnitToDualObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalHomIntoTensorUnitToDualObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalHomIntoTensorUnitToDualObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromInternalHomToObject
InstallMethod( AddIsomorphismFromInternalHomToObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalHomToObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalHomToObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalHomToObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromInternalHomToObjectWithGivenInternalHom
InstallMethod( AddIsomorphismFromInternalHomToObjectWithGivenInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalHomToObjectWithGivenInternalHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalHomToObjectWithGivenInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalHomToObjectWithGivenInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromInternalHomToObjectWithGivenInternalHom,
                    "IsomorphismFromInternalHomToObjectWithGivenInternalHom by calling IsomorphismFromInternalHomToObject with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromInternalHomToObject, 1 ],
                    ],
  function( cat, a, s )
    
    return IsomorphismFromInternalHomToObject( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromInternalHomToObject,
                    "IsomorphismFromInternalHomToObject by calling IsomorphismFromInternalHomToObjectWithGivenInternalHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromInternalHomToObjectWithGivenInternalHom, 1 ],
                        [ InternalHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromInternalHomToObjectWithGivenInternalHom( cat, a, InternalHomOnObjects( cat, TensorUnit( cat ), a ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromObjectToInternalHom
InstallMethod( AddIsomorphismFromObjectToInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToInternalHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromObjectToInternalHomWithGivenInternalHom
InstallMethod( AddIsomorphismFromObjectToInternalHomWithGivenInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToInternalHomWithGivenInternalHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToInternalHomWithGivenInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToInternalHomWithGivenInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromObjectToInternalHomWithGivenInternalHom,
                    "IsomorphismFromObjectToInternalHomWithGivenInternalHom by calling IsomorphismFromObjectToInternalHom with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromObjectToInternalHom, 1 ],
                    ],
  function( cat, a, r )
    
    return IsomorphismFromObjectToInternalHom( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromObjectToInternalHom,
                    "IsomorphismFromObjectToInternalHom by calling IsomorphismFromObjectToInternalHomWithGivenInternalHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromObjectToInternalHomWithGivenInternalHom, 1 ],
                        [ InternalHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromObjectToInternalHomWithGivenInternalHom( cat, a, InternalHomOnObjects( cat, TensorUnit( cat ), a ) );
    
end : is_with_given_derivation := true );

## LambdaElimination
InstallMethod( AddLambdaElimination,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LambdaElimination", category, func, -1 );
    
end );

InstallMethod( AddLambdaElimination,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LambdaElimination", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LambdaIntroduction
InstallMethod( AddLambdaIntroduction,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LambdaIntroduction", category, func, -1 );
    
end );

InstallMethod( AddLambdaIntroduction,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LambdaIntroduction", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonoidalPostComposeMorphism
InstallMethod( AddMonoidalPostComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPostComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPostComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPostComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonoidalPostComposeMorphismWithGivenObjects
InstallMethod( AddMonoidalPostComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPostComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPostComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPostComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MonoidalPostComposeMorphismWithGivenObjects,
                    "MonoidalPostComposeMorphismWithGivenObjects by calling MonoidalPostComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ MonoidalPostComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return MonoidalPostComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MonoidalPostComposeMorphism,
                    "MonoidalPostComposeMorphism by calling MonoidalPostComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MonoidalPostComposeMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ InternalHomOnObjects, 3 ],
                    ],
  function( cat, a, b, c )
    
    return MonoidalPostComposeMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, InternalHomOnObjects( cat, b, c ), InternalHomOnObjects( cat, a, b ) ), a, b, c, InternalHomOnObjects( cat, a, c ) );
    
end : is_with_given_derivation := true );

## MonoidalPreComposeMorphism
InstallMethod( AddMonoidalPreComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPreComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPreComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPreComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonoidalPreComposeMorphismWithGivenObjects
InstallMethod( AddMonoidalPreComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPreComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPreComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPreComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MonoidalPreComposeMorphismWithGivenObjects,
                    "MonoidalPreComposeMorphismWithGivenObjects by calling MonoidalPreComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ MonoidalPreComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return MonoidalPreComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MonoidalPreComposeMorphism,
                    "MonoidalPreComposeMorphism by calling MonoidalPreComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MonoidalPreComposeMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ InternalHomOnObjects, 3 ],
                    ],
  function( cat, a, b, c )
    
    return MonoidalPreComposeMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, InternalHomOnObjects( cat, a, b ), InternalHomOnObjects( cat, b, c ) ), a, b, c, InternalHomOnObjects( cat, a, c ) );
    
end : is_with_given_derivation := true );

## MorphismFromTensorProductToInternalHom
InstallMethod( AddMorphismFromTensorProductToInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromTensorProductToInternalHom", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromTensorProductToInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromTensorProductToInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromTensorProductToInternalHomWithGivenObjects
InstallMethod( AddMorphismFromTensorProductToInternalHomWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromTensorProductToInternalHomWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromTensorProductToInternalHomWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromTensorProductToInternalHomWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromTensorProductToInternalHomWithGivenObjects,
                    "MorphismFromTensorProductToInternalHomWithGivenObjects by calling MorphismFromTensorProductToInternalHom with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromTensorProductToInternalHom, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return MorphismFromTensorProductToInternalHom( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromTensorProductToInternalHom,
                    "MorphismFromTensorProductToInternalHom by calling MorphismFromTensorProductToInternalHomWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MorphismFromTensorProductToInternalHomWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ DualOnObjects, 1 ],
                        [ InternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return MorphismFromTensorProductToInternalHomWithGivenObjects( cat, TensorProductOnObjects( cat, DualOnObjects( cat, a ), b ), a, b, InternalHomOnObjects( cat, a, b ) );
    
end : is_with_given_derivation := true );

## MorphismToBidual
InstallMethod( AddMorphismToBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismToBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismToBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismToBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismToBidualWithGivenBidual
InstallMethod( AddMorphismToBidualWithGivenBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismToBidualWithGivenBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismToBidualWithGivenBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismToBidualWithGivenBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismToBidualWithGivenBidual,
                    "MorphismToBidualWithGivenBidual by calling MorphismToBidual with the WithGiven argument(s) dropped",
                    [
                        [ MorphismToBidual, 1 ],
                    ],
  function( cat, a, r )
    
    return MorphismToBidual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismToBidual,
                    "MorphismToBidual by calling MorphismToBidualWithGivenBidual with the WithGiven object(s)",
                    [
                        [ MorphismToBidualWithGivenBidual, 1 ],
                        [ DualOnObjects, 2 ],
                    ],
  function( cat, a )
    
    return MorphismToBidualWithGivenBidual( cat, a, DualOnObjects( cat, DualOnObjects( cat, a ) ) );
    
end : is_with_given_derivation := true );

## TensorProductDualityCompatibilityMorphism
InstallMethod( AddTensorProductDualityCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductDualityCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductDualityCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductDualityCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductDualityCompatibilityMorphismWithGivenObjects
InstallMethod( AddTensorProductDualityCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductDualityCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddTensorProductDualityCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductDualityCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductDualityCompatibilityMorphismWithGivenObjects,
                    "TensorProductDualityCompatibilityMorphismWithGivenObjects by calling TensorProductDualityCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductDualityCompatibilityMorphism, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return TensorProductDualityCompatibilityMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductDualityCompatibilityMorphism,
                    "TensorProductDualityCompatibilityMorphism by calling TensorProductDualityCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ TensorProductDualityCompatibilityMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 2 ],
                        [ DualOnObjects, 3 ],
                    ],
  function( cat, a, b )
    
    return TensorProductDualityCompatibilityMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, DualOnObjects( cat, a ), DualOnObjects( cat, b ) ), a, b, DualOnObjects( cat, TensorProductOnObjects( cat, a, b ) ) );
    
end : is_with_given_derivation := true );

## TensorProductInternalHomCompatibilityMorphism
InstallMethod( AddTensorProductInternalHomCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductInternalHomCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductInternalHomCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductInternalHomCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductInternalHomCompatibilityMorphismWithGivenObjects
InstallMethod( AddTensorProductInternalHomCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductInternalHomCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddTensorProductInternalHomCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductInternalHomCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductInternalHomCompatibilityMorphismWithGivenObjects,
                    "TensorProductInternalHomCompatibilityMorphismWithGivenObjects by calling TensorProductInternalHomCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductInternalHomCompatibilityMorphism, 1 ],
                    ],
  function( cat, source, list, range )
    
    return TensorProductInternalHomCompatibilityMorphism( cat, list );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductInternalHomCompatibilityMorphism,
                    "TensorProductInternalHomCompatibilityMorphism by calling TensorProductInternalHomCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ TensorProductInternalHomCompatibilityMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 3 ],
                        [ InternalHomOnObjects, 3 ],
                    ],
  function( cat, list )
    
    return TensorProductInternalHomCompatibilityMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, InternalHomOnObjects( cat, list[1], list[2] ), InternalHomOnObjects( cat, list[3], list[4] ) ), list, InternalHomOnObjects( cat, TensorProductOnObjects( cat, list[1], list[3] ), TensorProductOnObjects( cat, list[2], list[4] ) ) );
    
end : is_with_given_derivation := true );

## TensorProductToInternalHomLeftAdjunctMorphism
InstallMethod( AddTensorProductToInternalHomLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomLeftAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomLeftAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom
InstallMethod( AddTensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom,
                    "TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom by calling TensorProductToInternalHomLeftAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToInternalHomLeftAdjunctMorphism, 1 ],
                    ],
  function( cat, a, b, f, i )
    
    return TensorProductToInternalHomLeftAdjunctMorphism( cat, a, b, f );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToInternalHomLeftAdjunctMorphism,
                    "TensorProductToInternalHomLeftAdjunctMorphism by calling TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom with the WithGiven object(s)",
                    [
                        [ TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom, 1 ],
                        [ InternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b, f )
    
    return TensorProductToInternalHomLeftAdjunctMorphismWithGivenInternalHom( cat, a, b, f, InternalHomOnObjects( cat, b, Range( f ) ) );
    
end : is_with_given_derivation := true );

## TensorProductToInternalHomLeftAdjunctionIsomorphism
InstallMethod( AddTensorProductToInternalHomLeftAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomLeftAdjunctionIsomorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomLeftAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomLeftAdjunctionIsomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects
InstallMethod( AddTensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects,
                    "TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects by calling TensorProductToInternalHomLeftAdjunctionIsomorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToInternalHomLeftAdjunctionIsomorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return TensorProductToInternalHomLeftAdjunctionIsomorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToInternalHomLeftAdjunctionIsomorphism,
                    "TensorProductToInternalHomLeftAdjunctionIsomorphism by calling TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ HomomorphismStructureOnObjects, 2 ],
                        [ InternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return TensorProductToInternalHomLeftAdjunctionIsomorphismWithGivenObjects( cat, HomomorphismStructureOnObjects( cat, TensorProductOnObjects( cat, a, b ), c ), a, b, c, HomomorphismStructureOnObjects( cat, a, InternalHomOnObjects( cat, b, c ) ) );
    
end : is_with_given_derivation := true );

## TensorProductToInternalHomRightAdjunctMorphism
InstallMethod( AddTensorProductToInternalHomRightAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomRightAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomRightAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomRightAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom
InstallMethod( AddTensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom,
                    "TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom by calling TensorProductToInternalHomRightAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToInternalHomRightAdjunctMorphism, 1 ],
                    ],
  function( cat, a, b, f, i )
    
    return TensorProductToInternalHomRightAdjunctMorphism( cat, a, b, f );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToInternalHomRightAdjunctMorphism,
                    "TensorProductToInternalHomRightAdjunctMorphism by calling TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom with the WithGiven object(s)",
                    [
                        [ TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom, 1 ],
                        [ InternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b, f )
    
    return TensorProductToInternalHomRightAdjunctMorphismWithGivenInternalHom( cat, a, b, f, InternalHomOnObjects( cat, a, Range( f ) ) );
    
end : is_with_given_derivation := true );

## TensorProductToInternalHomRightAdjunctionIsomorphism
InstallMethod( AddTensorProductToInternalHomRightAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomRightAdjunctionIsomorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomRightAdjunctionIsomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomRightAdjunctionIsomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects
InstallMethod( AddTensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects,
                    "TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects by calling TensorProductToInternalHomRightAdjunctionIsomorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToInternalHomRightAdjunctionIsomorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return TensorProductToInternalHomRightAdjunctionIsomorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToInternalHomRightAdjunctionIsomorphism,
                    "TensorProductToInternalHomRightAdjunctionIsomorphism by calling TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ HomomorphismStructureOnObjects, 2 ],
                        [ InternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return TensorProductToInternalHomRightAdjunctionIsomorphismWithGivenObjects( cat, HomomorphismStructureOnObjects( cat, TensorProductOnObjects( cat, a, b ), c ), a, b, c, HomomorphismStructureOnObjects( cat, b, InternalHomOnObjects( cat, a, c ) ) );
    
end : is_with_given_derivation := true );

## UniversalPropertyOfDual
InstallMethod( AddUniversalPropertyOfDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalPropertyOfDual", category, func, -1 );
    
end );

InstallMethod( AddUniversalPropertyOfDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalPropertyOfDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);
