/* DeviceManagerWidget.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DeviceManagerWidget.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Sean Davis <sean@bluesabre.org>
 */

#include "sound.h"
#include <pulse/pulseaudio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_0_PROPERTY,
	SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_DIRECTION_PROPERTY,
	SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* sound_widgets_device_manager_widget_properties[SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

struct _SoundWidgetsDeviceManagerWidgetPrivate {
	pa_direction_t _direction;
	GtkListBox* device_list;
	GtkRevealer* devices_revealer;
	SoundPulseAudioManager* pam;
};

struct _Block4Data {
	int _ref_count_;
	SoundWidgetsDeviceManagerWidget* self;
	SoundWidgetsDeviceItem* device_item;
	SoundDevice* device;
};

static gint SoundWidgetsDeviceManagerWidget_private_offset;
static gpointer sound_widgets_device_manager_widget_parent_class = NULL;

static void sound_widgets_device_manager_widget_add_device (SoundWidgetsDeviceManagerWidget* self,
                                                     SoundDevice* device);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda55_ (Block4Data* _data4_);
static void sound_widgets_device_manager_widget_update_preferred_devices (SoundWidgetsDeviceManagerWidget* self,
                                                                   SoundDevice* device);
static void ___lambda55__sound_widgets_device_item_activated (SoundWidgetsDeviceItem* _sender,
                                                       gpointer self);
static void __lambda56_ (Block4Data* _data4_);
static void sound_widgets_device_manager_widget_update_showable (SoundWidgetsDeviceManagerWidget* self);
static void ___lambda56__sound_device_removed (SoundDevice* _sender,
                                        gpointer self);
static void __lambda57_ (Block4Data* _data4_);
static void ___lambda57__sound_device_defaulted (SoundDevice* _sender,
                                          gpointer self);
static void sound_widgets_device_manager_widget_default_output_changed (SoundWidgetsDeviceManagerWidget* self);
static void sound_widgets_device_manager_widget_default_input_changed (SoundWidgetsDeviceManagerWidget* self);
static GObject * sound_widgets_device_manager_widget_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void _sound_widgets_device_manager_widget_add_device_sound_pulse_audio_manager_new_device (SoundPulseAudioManager* _sender,
                                                                                           SoundDevice* dev,
                                                                                           gpointer self);
static void _sound_widgets_device_manager_widget_default_output_changed_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void _sound_widgets_device_manager_widget_default_input_changed_g_object_notify (GObject* _sender,
                                                                                 GParamSpec* pspec,
                                                                                 gpointer self);
static void sound_widgets_device_manager_widget_finalize (GObject * obj);
static GType sound_widgets_device_manager_widget_get_type_once (void);
static void _vala_sound_widgets_device_manager_widget_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_sound_widgets_device_manager_widget_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);

static inline gpointer
sound_widgets_device_manager_widget_get_instance_private (SoundWidgetsDeviceManagerWidget* self)
{
	return G_STRUCT_MEMBER_P (self, SoundWidgetsDeviceManagerWidget_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SoundWidgetsDeviceManagerWidget* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->device_item);
		_g_object_unref0 (_data4_->device);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda55_ (Block4Data* _data4_)
{
	SoundWidgetsDeviceManagerWidget* self;
	SoundPulseAudioManager* _tmp0_;
	self = _data4_->self;
	_tmp0_ = self->priv->pam;
	sound_pulse_audio_manager_set_default_device (_tmp0_, _data4_->device, NULL, NULL);
	sound_widgets_device_manager_widget_update_preferred_devices (self, _data4_->device);
}

static void
___lambda55__sound_widgets_device_item_activated (SoundWidgetsDeviceItem* _sender,
                                                  gpointer self)
{
	__lambda55_ (self);
}

static void
__lambda56_ (Block4Data* _data4_)
{
	SoundWidgetsDeviceManagerWidget* self;
	GtkListBox* _tmp0_;
	SoundWidgetsDeviceItem* _tmp1_;
	GtkListBox* _tmp2_;
	self = _data4_->self;
	_tmp0_ = self->priv->device_list;
	_tmp1_ = _data4_->device_item;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->device_list;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
	sound_widgets_device_manager_widget_update_showable (self);
}

static void
___lambda56__sound_device_removed (SoundDevice* _sender,
                                   gpointer self)
{
	__lambda56_ (self);
}

static void
__lambda57_ (Block4Data* _data4_)
{
	SoundWidgetsDeviceManagerWidget* self;
	SoundWidgetsDeviceItem* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->device_item;
	sound_widgets_device_item_set_default (_tmp0_);
	sound_widgets_device_manager_widget_update_preferred_devices (self, _data4_->device);
	sound_widgets_device_manager_widget_update_showable (self);
}

static void
___lambda57__sound_device_defaulted (SoundDevice* _sender,
                                     gpointer self)
{
	__lambda57_ (self);
}

static void
sound_widgets_device_manager_widget_add_device (SoundWidgetsDeviceManagerWidget* self,
                                                SoundDevice* device)
{
	Block4Data* _data4_;
	SoundDevice* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	pa_direction_t _tmp3_;
	pa_direction_t _tmp4_;
	pa_direction_t _tmp5_;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp10_;
	GtkListBoxRow* _tmp11_;
	GtkListBoxRow* _tmp12_;
	GtkListBoxRow* _tmp13_;
	SoundWidgetsDeviceItem* _tmp14_;
	GtkListBox* _tmp15_;
	SoundWidgetsDeviceItem* _tmp16_;
	SoundWidgetsDeviceItem* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data4_->device);
	_data4_->device = _tmp0_;
	_tmp3_ = sound_device_get_direction (_data4_->device);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_direction;
	if (_tmp4_ != _tmp5_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = sound_device_get_port_name (_data4_->device);
		_tmp7_ = _tmp6_;
		_tmp2_ = g_strcmp0 (_tmp7_, "analog-output") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = sound_device_get_port_name (_data4_->device);
		_tmp9_ = _tmp8_;
		_tmp1_ = g_strcmp0 (_tmp9_, "analog-input") == 0;
	}
	if (_tmp1_) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp10_ = self->priv->device_list;
	_tmp11_ = gtk_list_box_get_row_at_index (_tmp10_, 0);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	row = _tmp12_;
	_tmp13_ = row;
	_tmp14_ = sound_widgets_device_item_new (_data4_->device, _tmp13_);
	g_object_ref_sink (_tmp14_);
	_data4_->device_item = _tmp14_;
	_tmp15_ = self->priv->device_list;
	_tmp16_ = _data4_->device_item;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = _data4_->device_item;
	g_signal_connect_data (_tmp17_, "activated", (GCallback) ___lambda55__sound_widgets_device_item_activated, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_signal_connect_data (_data4_->device, "removed", (GCallback) ___lambda56__sound_device_removed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_signal_connect_data (_data4_->device, "defaulted", (GCallback) ___lambda57__sound_device_defaulted, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	sound_widgets_device_manager_widget_update_showable (self);
	_g_object_unref0 (row);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

/**
     * Preferred devices are stored as:
     * {
     *   device_a: last_used_unix_timestamp,
     *   device_b: last_used_unix_timestamp
     * }
     * If a device hasn't been selected in 7 days, it is removed from preferred devices.
     * Device selection happens when the user selects the device, and when the plugin
     * is initialized.
     */
static void
sound_widgets_device_manager_widget_update_preferred_devices (SoundWidgetsDeviceManagerWidget* self,
                                                              SoundDevice* device)
{
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariant* preferred_devices = NULL;
	GSettings* _tmp4_;
	GVariant* _tmp5_;
	gint32 now = 0;
	gint32 preferred_expiry = 0;
	GVariantBuilder* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GVariant* dictionary = NULL;
	GVariantBuilder* _tmp29_;
	GVariant* _tmp30_;
	GSettings* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = g_variant_type_new ("a{si}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	_tmp4_ = sound_indicator_settings;
	_tmp5_ = g_settings_get_value (_tmp4_, "preferred-devices");
	preferred_devices = _tmp5_;
	now = (gint32) (g_get_real_time () / 1000000);
	preferred_expiry = now - (86400 * 7);
	_tmp6_ = builder;
	_tmp7_ = sound_device_get_id (device);
	_tmp8_ = _tmp7_;
	g_variant_builder_add (_tmp6_, "{si}", _tmp8_, now, NULL);
	{
		GVariantIter* _dev_it = NULL;
		GVariant* _tmp9_;
		GVariantIter* _tmp10_;
		GVariant* dev = NULL;
		_tmp9_ = preferred_devices;
		_tmp10_ = g_variant_iter_new (_tmp9_);
		_dev_it = _tmp10_;
		while (TRUE) {
			GVariantIter* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			gchar* name = NULL;
			GVariant* _tmp14_;
			GVariant* _tmp15_;
			GVariant* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gint32 last_used = 0;
			GVariant* _tmp20_;
			GVariant* _tmp21_;
			GVariant* _tmp22_;
			gint32 _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			GVariantBuilder* _tmp27_;
			const gchar* _tmp28_;
			_tmp11_ = _dev_it;
			_tmp12_ = g_variant_iter_next_value (_tmp11_);
			_g_variant_unref0 (dev);
			dev = _tmp12_;
			_tmp13_ = dev;
			if (!(_tmp13_ != NULL)) {
				break;
			}
			_tmp14_ = dev;
			_tmp15_ = g_variant_get_child_value (_tmp14_, (gsize) 0);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_variant_get_string (_tmp16_, NULL);
			_tmp18_ = g_strdup (_tmp17_);
			_tmp19_ = _tmp18_;
			_g_variant_unref0 (_tmp16_);
			name = _tmp19_;
			_tmp20_ = dev;
			_tmp21_ = g_variant_get_child_value (_tmp20_, (gsize) 1);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_variant_get_int32 (_tmp22_);
			_g_variant_unref0 (_tmp22_);
			last_used = _tmp23_;
			_tmp24_ = name;
			_tmp25_ = sound_device_get_id (device);
			_tmp26_ = _tmp25_;
			if (g_strcmp0 (_tmp24_, _tmp26_) == 0) {
				_g_free0 (name);
				continue;
			}
			if (last_used < preferred_expiry) {
				_g_free0 (name);
				continue;
			}
			_tmp27_ = builder;
			_tmp28_ = name;
			g_variant_builder_add (_tmp27_, "{si}", _tmp28_, last_used, NULL);
			_g_free0 (name);
		}
		_g_variant_unref0 (dev);
		_g_variant_iter_free0 (_dev_it);
	}
	_tmp29_ = builder;
	_tmp30_ = g_variant_builder_end (_tmp29_);
	g_variant_ref_sink (_tmp30_);
	dictionary = _tmp30_;
	sound_device_set_is_priority (device, TRUE);
	_tmp31_ = sound_indicator_settings;
	g_settings_set_value (_tmp31_, "preferred-devices", dictionary);
	_g_variant_unref0 (dictionary);
	_g_variant_unref0 (preferred_devices);
	_g_variant_builder_unref0 (builder);
}

static void
sound_widgets_device_manager_widget_update_showable (SoundWidgetsDeviceManagerWidget* self)
{
	GtkRevealer* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices_revealer;
	_tmp1_ = self->priv->device_list;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, 1);
	gtk_revealer_set_reveal_child (_tmp0_, _tmp2_ != NULL);
}

static void
sound_widgets_device_manager_widget_default_output_changed (SoundWidgetsDeviceManagerWidget* self)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	SoundDevice* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pam;
	_tmp1_ = sound_pulse_audio_manager_get_default_output (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (_tmp2_, "defaulted");
}

static void
sound_widgets_device_manager_widget_default_input_changed (SoundWidgetsDeviceManagerWidget* self)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	SoundDevice* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pam;
	_tmp1_ = sound_pulse_audio_manager_get_default_input (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (_tmp2_, "defaulted");
}

SoundWidgetsDeviceManagerWidget*
sound_widgets_device_manager_widget_construct (GType object_type)
{
	SoundWidgetsDeviceManagerWidget * self = NULL;
	self = (SoundWidgetsDeviceManagerWidget*) g_object_new (object_type, NULL);
	return self;
}

SoundWidgetsDeviceManagerWidget*
sound_widgets_device_manager_widget_new (void)
{
	return sound_widgets_device_manager_widget_construct (SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET);
}

pa_direction_t
sound_widgets_device_manager_widget_get_direction (SoundWidgetsDeviceManagerWidget* self)
{
	pa_direction_t result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_direction;
	return result;
}

void
sound_widgets_device_manager_widget_set_direction (SoundWidgetsDeviceManagerWidget* self,
                                                   pa_direction_t value)
{
	pa_direction_t old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_widgets_device_manager_widget_get_direction (self);
	if (old_value != value) {
		self->priv->_direction = value;
		g_object_notify_by_pspec ((GObject *) self, sound_widgets_device_manager_widget_properties[SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_DIRECTION_PROPERTY]);
	}
}

static void
_sound_widgets_device_manager_widget_add_device_sound_pulse_audio_manager_new_device (SoundPulseAudioManager* _sender,
                                                                                      SoundDevice* dev,
                                                                                      gpointer self)
{
	sound_widgets_device_manager_widget_add_device ((SoundWidgetsDeviceManagerWidget*) self, dev);
}

static void
_sound_widgets_device_manager_widget_default_output_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	sound_widgets_device_manager_widget_default_output_changed ((SoundWidgetsDeviceManagerWidget*) self);
}

static void
_sound_widgets_device_manager_widget_default_input_changed_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self)
{
	sound_widgets_device_manager_widget_default_input_changed ((SoundWidgetsDeviceManagerWidget*) self);
}

static GObject *
sound_widgets_device_manager_widget_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundWidgetsDeviceManagerWidget * self;
	SoundPulseAudioManager* _tmp0_;
	SoundPulseAudioManager* _tmp1_;
	SoundPulseAudioManager* _tmp2_;
	SoundPulseAudioManager* _tmp3_;
	SoundPulseAudioManager* _tmp4_;
	GtkListBox* _tmp5_ = NULL;
	GtkScrolledWindow* scrolled_box = NULL;
	GtkListBox* _tmp6_;
	GtkWidget* _tmp7_;
	GtkScrolledWindow* _tmp8_ = NULL;
	GtkScrolledWindow* _tmp9_;
	GtkWidget* _tmp10_;
	GtkRevealer* _tmp11_ = NULL;
	GtkRevealer* _tmp12_;
	parent_class = G_OBJECT_CLASS (sound_widgets_device_manager_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET, SoundWidgetsDeviceManagerWidget);
	_tmp0_ = sound_pulse_audio_manager_get_default ();
	self->priv->pam = _tmp0_;
	_tmp1_ = self->priv->pam;
	g_signal_connect_object (_tmp1_, "new-device", (GCallback) _sound_widgets_device_manager_widget_add_device_sound_pulse_audio_manager_new_device, self, 0);
	_tmp2_ = self->priv->pam;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::default-output", (GCallback) _sound_widgets_device_manager_widget_default_output_changed_g_object_notify, self, 0);
	_tmp3_ = self->priv->pam;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::default-input", (GCallback) _sound_widgets_device_manager_widget_default_input_changed_g_object_notify, self, 0);
	_tmp4_ = self->priv->pam;
	sound_pulse_audio_manager_start (_tmp4_);
	_tmp5_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp5_, TRUE);
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->device_list);
	self->priv->device_list = _tmp5_;
	_tmp6_ = self->priv->device_list;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp8_, "child", _tmp7_, NULL);
	_g_object_unref0 (_tmp7_);
	g_object_set (_tmp8_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_propagate_natural_height (_tmp8_, TRUE);
	gtk_scrolled_window_set_max_content_height (_tmp8_, 256);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp8_, 3);
	g_object_ref_sink (_tmp8_);
	scrolled_box = _tmp8_;
	_tmp9_ = scrolled_box;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp11_, "child", _tmp10_, NULL);
	_g_object_unref0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->devices_revealer);
	self->priv->devices_revealer = _tmp11_;
	_tmp12_ = self->priv->devices_revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp12_);
	sound_widgets_device_manager_widget_update_showable (self);
	_g_object_unref0 (scrolled_box);
	return obj;
}

static void
sound_widgets_device_manager_widget_class_init (SoundWidgetsDeviceManagerWidgetClass * klass,
                                                gpointer klass_data)
{
	sound_widgets_device_manager_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundWidgetsDeviceManagerWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_widgets_device_manager_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_widgets_device_manager_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_widgets_device_manager_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_widgets_device_manager_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_DIRECTION_PROPERTY, sound_widgets_device_manager_widget_properties[SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_DIRECTION_PROPERTY] = g_param_spec_uint ("direction", "direction", "direction", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sound_widgets_device_manager_widget_instance_init (SoundWidgetsDeviceManagerWidget * self,
                                                   gpointer klass)
{
	self->priv = sound_widgets_device_manager_widget_get_instance_private (self);
}

static void
sound_widgets_device_manager_widget_finalize (GObject * obj)
{
	SoundWidgetsDeviceManagerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET, SoundWidgetsDeviceManagerWidget);
	_g_object_unref0 (self->priv->device_list);
	_g_object_unref0 (self->priv->devices_revealer);
	G_OBJECT_CLASS (sound_widgets_device_manager_widget_parent_class)->finalize (obj);
}

static GType
sound_widgets_device_manager_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundWidgetsDeviceManagerWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_widgets_device_manager_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundWidgetsDeviceManagerWidget), 0, (GInstanceInitFunc) sound_widgets_device_manager_widget_instance_init, NULL };
	GType sound_widgets_device_manager_widget_type_id;
	sound_widgets_device_manager_widget_type_id = g_type_register_static (gtk_box_get_type (), "SoundWidgetsDeviceManagerWidget", &g_define_type_info, 0);
	SoundWidgetsDeviceManagerWidget_private_offset = g_type_add_instance_private (sound_widgets_device_manager_widget_type_id, sizeof (SoundWidgetsDeviceManagerWidgetPrivate));
	return sound_widgets_device_manager_widget_type_id;
}

GType
sound_widgets_device_manager_widget_get_type (void)
{
	static volatile gsize sound_widgets_device_manager_widget_type_id__once = 0;
	if (g_once_init_enter (&sound_widgets_device_manager_widget_type_id__once)) {
		GType sound_widgets_device_manager_widget_type_id;
		sound_widgets_device_manager_widget_type_id = sound_widgets_device_manager_widget_get_type_once ();
		g_once_init_leave (&sound_widgets_device_manager_widget_type_id__once, sound_widgets_device_manager_widget_type_id);
	}
	return sound_widgets_device_manager_widget_type_id__once;
}

static void
_vala_sound_widgets_device_manager_widget_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	SoundWidgetsDeviceManagerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET, SoundWidgetsDeviceManagerWidget);
	switch (property_id) {
		case SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_DIRECTION_PROPERTY:
		g_value_set_uint (value, sound_widgets_device_manager_widget_get_direction (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_widgets_device_manager_widget_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	SoundWidgetsDeviceManagerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET, SoundWidgetsDeviceManagerWidget);
	switch (property_id) {
		case SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_DIRECTION_PROPERTY:
		sound_widgets_device_manager_widget_set_direction (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

