/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSOMColor.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMColorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMColor_colorSpace);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOMColor_colorSpace);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMColor_alpha);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOMColor_alpha);

class JSCSSOMColorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSOMColorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSOMColorPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSOMColorPrototype>(vm)) JSCSSOMColorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOMColorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSOMColorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOMColorPrototype, JSCSSOMColorPrototype::Base);

using JSCSSOMColorDOMConstructor = JSDOMConstructor<JSCSSOMColor>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSOMColorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSOMColorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto colorSpaceConversionResult = convert<IDLUnion<IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument0.value());
    if (colorSpaceConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto channelsConversionResult = convert<IDLSequence<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>>(*lexicalGlobalObject, argument1.value());
    if (channelsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto alphaConversionResult = convertOptionalWithDefault<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>> { return Converter<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>::ReturnType { 1.0 }; });
    if (alphaConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = CSSOMColor::create(colorSpaceConversionResult.releaseReturnValue(), channelsConversionResult.releaseReturnValue(), alphaConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSOMColor>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSOMColor>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSOMColorDOMConstructorConstruct, JSCSSOMColorDOMConstructor::construct);

template<> const ClassInfo JSCSSOMColorDOMConstructor::s_info = { "CSSColor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMColorDOMConstructor) };

template<> JSValue JSCSSOMColorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSOMColorValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSOMColorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSColor"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSOMColor::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSCSSOMColorPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMColorConstructor, 0 } },
    HashTableValue { "colorSpace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMColor_colorSpace, setJSCSSOMColor_colorSpace } },
    HashTableValue { "alpha"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMColor_alpha, setJSCSSOMColor_alpha } },
};

const ClassInfo JSCSSOMColorPrototype::s_info = { "CSSColor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMColorPrototype) };

void JSCSSOMColorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSOMColor::info(), JSCSSOMColorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSOMColor::s_info = { "CSSColor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMColor) };

JSCSSOMColor::JSCSSOMColor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSOMColor>&& impl)
    : JSCSSOMColorValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSOMColor> JSCSSOMColor::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSOMColor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSOMColor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSOMColorPrototype::createStructure(vm, &globalObject, JSCSSOMColorValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSOMColorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSOMColor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSOMColor>(vm, globalObject);
}

JSValue JSCSSOMColor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSOMColorDOMConstructor, DOMConstructorID::CSSOMColor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMColorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSOMColorPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSOMColor::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSOMColor_colorSpaceGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMColor& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.colorSpace())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMColor_colorSpace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMColor>::get<jsCSSOMColor_colorSpaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOMColor_colorSpaceSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMColor& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setColorSpace(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOMColor_colorSpace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMColor>::set<setJSCSSOMColor_colorSpaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOMColor_alphaGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMColor& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.alpha())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMColor_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMColor>::get<jsCSSOMColor_alphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOMColor_alphaSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMColor& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlpha(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOMColor_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMColor>::set<setJSCSSOMColor_alphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSOMColor::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSOMColor, UseCustomHeapCellType::No>(vm, "JSCSSOMColor"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSOMColor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSOMColor = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSOMColor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSOMColor = std::forward<decltype(space)>(space); }
    );
}

void JSCSSOMColor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSOMColor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSOMColor@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10CSSOMColorE[]; }
#endif
template<std::same_as<CSSOMColor> T>
static inline void verifyVTable(CSSOMColor* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSOMColor@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10CSSOMColorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSOMColor has subclasses. If CSSOMColor has subclasses that get passed
        // to toJS() we currently require CSSOMColor you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSOMColor>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSOMColor>(impl.ptr());
#endif
    return createWrapper<CSSOMColor>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSOMColor& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSOMColor* JSCSSOMColor::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSOMColor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
