// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

DOM

This domain exposes DOM read/write operations. Each DOM Node is represented with its mirror object
that has an `id`. This `id` can be used to get additional information on the Node, resolve it into
the JavaScript object wrapper, etc. It is important that client receives DOM events only for the
nodes that are known to the client. Backend keeps track of the nodes that were sent to the client
and never sends the same node twice. It is client's responsibility to collect information about
the nodes that were sent to the client. Note that `iframe` owner elements will return
corresponding document elements as their child nodes.

*/

// DOMNodeID Unique DOM node identifier.
type DOMNodeID int

// DOMBackendNodeID Unique DOM node identifier used to reference a node that may not have been pushed to the
// front-end.
type DOMBackendNodeID int

// DOMBackendNode Backend node with a friendly name.
type DOMBackendNode struct {
	// NodeType `Node`'s nodeType.
	NodeType int `json:"nodeType"`

	// NodeName `Node`'s nodeName.
	NodeName string `json:"nodeName"`

	// BackendNodeID ...
	BackendNodeID DOMBackendNodeID `json:"backendNodeId"`
}

// DOMPseudoType Pseudo element type.
type DOMPseudoType string

const (
	// DOMPseudoTypeFirstLine enum const.
	DOMPseudoTypeFirstLine DOMPseudoType = "first-line"

	// DOMPseudoTypeFirstLetter enum const.
	DOMPseudoTypeFirstLetter DOMPseudoType = "first-letter"

	// DOMPseudoTypeBefore enum const.
	DOMPseudoTypeBefore DOMPseudoType = "before"

	// DOMPseudoTypeAfter enum const.
	DOMPseudoTypeAfter DOMPseudoType = "after"

	// DOMPseudoTypeMarker enum const.
	DOMPseudoTypeMarker DOMPseudoType = "marker"

	// DOMPseudoTypeBackdrop enum const.
	DOMPseudoTypeBackdrop DOMPseudoType = "backdrop"

	// DOMPseudoTypeSelection enum const.
	DOMPseudoTypeSelection DOMPseudoType = "selection"

	// DOMPseudoTypeSearchText enum const.
	DOMPseudoTypeSearchText DOMPseudoType = "search-text"

	// DOMPseudoTypeTargetText enum const.
	DOMPseudoTypeTargetText DOMPseudoType = "target-text"

	// DOMPseudoTypeSpellingError enum const.
	DOMPseudoTypeSpellingError DOMPseudoType = "spelling-error"

	// DOMPseudoTypeGrammarError enum const.
	DOMPseudoTypeGrammarError DOMPseudoType = "grammar-error"

	// DOMPseudoTypeHighlight enum const.
	DOMPseudoTypeHighlight DOMPseudoType = "highlight"

	// DOMPseudoTypeFirstLineInherited enum const.
	DOMPseudoTypeFirstLineInherited DOMPseudoType = "first-line-inherited"

	// DOMPseudoTypeScrollMarker enum const.
	DOMPseudoTypeScrollMarker DOMPseudoType = "scroll-marker"

	// DOMPseudoTypeScrollMarkerGroup enum const.
	DOMPseudoTypeScrollMarkerGroup DOMPseudoType = "scroll-marker-group"

	// DOMPseudoTypeScrollbar enum const.
	DOMPseudoTypeScrollbar DOMPseudoType = "scrollbar"

	// DOMPseudoTypeScrollbarThumb enum const.
	DOMPseudoTypeScrollbarThumb DOMPseudoType = "scrollbar-thumb"

	// DOMPseudoTypeScrollbarButton enum const.
	DOMPseudoTypeScrollbarButton DOMPseudoType = "scrollbar-button"

	// DOMPseudoTypeScrollbarTrack enum const.
	DOMPseudoTypeScrollbarTrack DOMPseudoType = "scrollbar-track"

	// DOMPseudoTypeScrollbarTrackPiece enum const.
	DOMPseudoTypeScrollbarTrackPiece DOMPseudoType = "scrollbar-track-piece"

	// DOMPseudoTypeScrollbarCorner enum const.
	DOMPseudoTypeScrollbarCorner DOMPseudoType = "scrollbar-corner"

	// DOMPseudoTypeResizer enum const.
	DOMPseudoTypeResizer DOMPseudoType = "resizer"

	// DOMPseudoTypeInputListButton enum const.
	DOMPseudoTypeInputListButton DOMPseudoType = "input-list-button"

	// DOMPseudoTypeViewTransition enum const.
	DOMPseudoTypeViewTransition DOMPseudoType = "view-transition"

	// DOMPseudoTypeViewTransitionGroup enum const.
	DOMPseudoTypeViewTransitionGroup DOMPseudoType = "view-transition-group"

	// DOMPseudoTypeViewTransitionImagePair enum const.
	DOMPseudoTypeViewTransitionImagePair DOMPseudoType = "view-transition-image-pair"

	// DOMPseudoTypeViewTransitionOld enum const.
	DOMPseudoTypeViewTransitionOld DOMPseudoType = "view-transition-old"

	// DOMPseudoTypeViewTransitionNew enum const.
	DOMPseudoTypeViewTransitionNew DOMPseudoType = "view-transition-new"
)

// DOMShadowRootType Shadow root type.
type DOMShadowRootType string

const (
	// DOMShadowRootTypeUserAgent enum const.
	DOMShadowRootTypeUserAgent DOMShadowRootType = "user-agent"

	// DOMShadowRootTypeOpen enum const.
	DOMShadowRootTypeOpen DOMShadowRootType = "open"

	// DOMShadowRootTypeClosed enum const.
	DOMShadowRootTypeClosed DOMShadowRootType = "closed"
)

// DOMCompatibilityMode Document compatibility mode.
type DOMCompatibilityMode string

const (
	// DOMCompatibilityModeQuirksMode enum const.
	DOMCompatibilityModeQuirksMode DOMCompatibilityMode = "QuirksMode"

	// DOMCompatibilityModeLimitedQuirksMode enum const.
	DOMCompatibilityModeLimitedQuirksMode DOMCompatibilityMode = "LimitedQuirksMode"

	// DOMCompatibilityModeNoQuirksMode enum const.
	DOMCompatibilityModeNoQuirksMode DOMCompatibilityMode = "NoQuirksMode"
)

// DOMPhysicalAxes ContainerSelector physical axes.
type DOMPhysicalAxes string

const (
	// DOMPhysicalAxesHorizontal enum const.
	DOMPhysicalAxesHorizontal DOMPhysicalAxes = "Horizontal"

	// DOMPhysicalAxesVertical enum const.
	DOMPhysicalAxesVertical DOMPhysicalAxes = "Vertical"

	// DOMPhysicalAxesBoth enum const.
	DOMPhysicalAxesBoth DOMPhysicalAxes = "Both"
)

// DOMLogicalAxes ContainerSelector logical axes.
type DOMLogicalAxes string

const (
	// DOMLogicalAxesInline enum const.
	DOMLogicalAxesInline DOMLogicalAxes = "Inline"

	// DOMLogicalAxesBlock enum const.
	DOMLogicalAxesBlock DOMLogicalAxes = "Block"

	// DOMLogicalAxesBoth enum const.
	DOMLogicalAxesBoth DOMLogicalAxes = "Both"
)

// DOMScrollOrientation Physical scroll orientation.
type DOMScrollOrientation string

const (
	// DOMScrollOrientationHorizontal enum const.
	DOMScrollOrientationHorizontal DOMScrollOrientation = "horizontal"

	// DOMScrollOrientationVertical enum const.
	DOMScrollOrientationVertical DOMScrollOrientation = "vertical"
)

// DOMNode DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes.
// DOMNode is a base node mirror type.
type DOMNode struct {
	// NodeID Node identifier that is passed into the rest of the DOM messages as the `nodeId`. Backend
	// will only push node with given `id` once. It is aware of all requested nodes and will only
	// fire DOM events for nodes known to the client.
	NodeID DOMNodeID `json:"nodeId"`

	// ParentID (optional) The id of the parent node if any.
	ParentID DOMNodeID `json:"parentId,omitempty"`

	// BackendNodeID The BackendNodeId for this node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId"`

	// NodeType `Node`'s nodeType.
	NodeType int `json:"nodeType"`

	// NodeName `Node`'s nodeName.
	NodeName string `json:"nodeName"`

	// LocalName `Node`'s localName.
	LocalName string `json:"localName"`

	// NodeValue `Node`'s nodeValue.
	NodeValue string `json:"nodeValue"`

	// ChildNodeCount (optional) Child count for `Container` nodes.
	ChildNodeCount *int `json:"childNodeCount,omitempty"`

	// Children (optional) Child nodes of this node when requested with children.
	Children []*DOMNode `json:"children,omitempty"`

	// Attributes (optional) Attributes of the `Element` node in the form of flat array `[name1, value1, name2, value2]`.
	Attributes []string `json:"attributes,omitempty"`

	// DocumentURL (optional) Document URL that `Document` or `FrameOwner` node points to.
	DocumentURL string `json:"documentURL,omitempty"`

	// BaseURL (optional) Base URL that `Document` or `FrameOwner` node uses for URL completion.
	BaseURL string `json:"baseURL,omitempty"`

	// PublicID (optional) `DocumentType`'s publicId.
	PublicID string `json:"publicId,omitempty"`

	// SystemID (optional) `DocumentType`'s systemId.
	SystemID string `json:"systemId,omitempty"`

	// InternalSubset (optional) `DocumentType`'s internalSubset.
	InternalSubset string `json:"internalSubset,omitempty"`

	// XMLVersion (optional) `Document`'s XML version in case of XML documents.
	XMLVersion string `json:"xmlVersion,omitempty"`

	// Name (optional) `Attr`'s name.
	Name string `json:"name,omitempty"`

	// Value (optional) `Attr`'s value.
	Value string `json:"value,omitempty"`

	// PseudoType (optional) Pseudo element type for this node.
	PseudoType DOMPseudoType `json:"pseudoType,omitempty"`

	// PseudoIdentifier (optional) Pseudo element identifier for this node. Only present if there is a
	// valid pseudoType.
	PseudoIdentifier string `json:"pseudoIdentifier,omitempty"`

	// ShadowRootType (optional) Shadow root type.
	ShadowRootType DOMShadowRootType `json:"shadowRootType,omitempty"`

	// FrameID (optional) Frame ID for frame owner elements.
	FrameID PageFrameID `json:"frameId,omitempty"`

	// ContentDocument (optional) Content document for frame owner elements.
	ContentDocument *DOMNode `json:"contentDocument,omitempty"`

	// ShadowRoots (optional) Shadow root list for given element host.
	ShadowRoots []*DOMNode `json:"shadowRoots,omitempty"`

	// TemplateContent (optional) Content document fragment for template elements.
	TemplateContent *DOMNode `json:"templateContent,omitempty"`

	// PseudoElements (optional) Pseudo elements associated with this node.
	PseudoElements []*DOMNode `json:"pseudoElements,omitempty"`

	// ImportedDocument (deprecated) (optional) Deprecated, as the HTML Imports API has been removed (crbug.com/937746).
	// This property used to return the imported document for the HTMLImport links.
	// The property is always undefined now.
	ImportedDocument *DOMNode `json:"importedDocument,omitempty"`

	// DistributedNodes (optional) Distributed nodes for given insertion point.
	DistributedNodes []*DOMBackendNode `json:"distributedNodes,omitempty"`

	// IsSVG (optional) Whether the node is SVG.
	IsSVG bool `json:"isSVG,omitempty"`

	// CompatibilityMode (optional) ...
	CompatibilityMode DOMCompatibilityMode `json:"compatibilityMode,omitempty"`

	// AssignedSlot (optional) ...
	AssignedSlot *DOMBackendNode `json:"assignedSlot,omitempty"`
}

// DOMRGBA A structure holding an RGBA color.
type DOMRGBA struct {
	// R The red component, in the [0-255] range.
	R int `json:"r"`

	// G The green component, in the [0-255] range.
	G int `json:"g"`

	// B The blue component, in the [0-255] range.
	B int `json:"b"`

	// A (optional) The alpha component, in the [0-1] range (default: 1).
	A *float64 `json:"a,omitempty"`
}

// DOMQuad An array of quad vertices, x immediately followed by y for each point, points clock-wise.
type DOMQuad []float64

// DOMBoxModel Box model.
type DOMBoxModel struct {
	// Content box
	Content DOMQuad `json:"content"`

	// Padding box
	Padding DOMQuad `json:"padding"`

	// Border box
	Border DOMQuad `json:"border"`

	// Margin box
	Margin DOMQuad `json:"margin"`

	// Width Node width
	Width int `json:"width"`

	// Height Node height
	Height int `json:"height"`

	// ShapeOutside (optional) Shape outside coordinates
	ShapeOutside *DOMShapeOutsideInfo `json:"shapeOutside,omitempty"`
}

// DOMShapeOutsideInfo CSS Shape Outside details.
type DOMShapeOutsideInfo struct {
	// Bounds Shape bounds
	Bounds DOMQuad `json:"bounds"`

	// Shape coordinate details
	Shape []gson.JSON `json:"shape"`

	// MarginShape Margin shape bounds
	MarginShape []gson.JSON `json:"marginShape"`
}

// DOMRect Rectangle.
type DOMRect struct {
	// X coordinate
	X float64 `json:"x"`

	// Y coordinate
	Y float64 `json:"y"`

	// Width Rectangle width
	Width float64 `json:"width"`

	// Height Rectangle height
	Height float64 `json:"height"`
}

// DOMCSSComputedStyleProperty ...
type DOMCSSComputedStyleProperty struct {
	// Name Computed style property name.
	Name string `json:"name"`

	// Value Computed style property value.
	Value string `json:"value"`
}

// DOMCollectClassNamesFromSubtree (experimental) Collects class names for the node with given id and all of it's child nodes.
type DOMCollectClassNamesFromSubtree struct {
	// NodeID Id of the node to collect class names.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m DOMCollectClassNamesFromSubtree) ProtoReq() string { return "DOM.collectClassNamesFromSubtree" }

// Call the request.
func (m DOMCollectClassNamesFromSubtree) Call(c Client) (*DOMCollectClassNamesFromSubtreeResult, error) {
	var res DOMCollectClassNamesFromSubtreeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMCollectClassNamesFromSubtreeResult (experimental) ...
type DOMCollectClassNamesFromSubtreeResult struct {
	// ClassNames Class name list.
	ClassNames []string `json:"classNames"`
}

// DOMCopyTo (experimental) Creates a deep copy of the specified node and places it into the target container before the
// given anchor.
type DOMCopyTo struct {
	// NodeID Id of the node to copy.
	NodeID DOMNodeID `json:"nodeId"`

	// TargetNodeID Id of the element to drop the copy into.
	TargetNodeID DOMNodeID `json:"targetNodeId"`

	// InsertBeforeNodeID (optional) Drop the copy before this node (if absent, the copy becomes the last child of
	// `targetNodeId`).
	InsertBeforeNodeID DOMNodeID `json:"insertBeforeNodeId,omitempty"`
}

// ProtoReq name.
func (m DOMCopyTo) ProtoReq() string { return "DOM.copyTo" }

// Call the request.
func (m DOMCopyTo) Call(c Client) (*DOMCopyToResult, error) {
	var res DOMCopyToResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMCopyToResult (experimental) ...
type DOMCopyToResult struct {
	// NodeID Id of the node clone.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMDescribeNode Describes node given its id, does not require domain to be enabled. Does not start tracking any
// objects, can be used for automation.
type DOMDescribeNode struct {
	// NodeID (optional) Identifier of the node.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Identifier of the backend node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectID (optional) JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`

	// Depth (optional) The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
	// entire subtree or provide an integer larger than 0.
	Depth *int `json:"depth,omitempty"`

	// Pierce (optional) Whether or not iframes and shadow roots should be traversed when returning the subtree
	// (default is false).
	Pierce bool `json:"pierce,omitempty"`
}

// ProtoReq name.
func (m DOMDescribeNode) ProtoReq() string { return "DOM.describeNode" }

// Call the request.
func (m DOMDescribeNode) Call(c Client) (*DOMDescribeNodeResult, error) {
	var res DOMDescribeNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMDescribeNodeResult ...
type DOMDescribeNodeResult struct {
	// Node description.
	Node *DOMNode `json:"node"`
}

// DOMScrollIntoViewIfNeeded Scrolls the specified rect of the given node into view if not already visible.
// Note: exactly one between nodeId, backendNodeId and objectId should be passed
// to identify the node.
type DOMScrollIntoViewIfNeeded struct {
	// NodeID (optional) Identifier of the node.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Identifier of the backend node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectID (optional) JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`

	// Rect (optional) The rect to be scrolled into view, relative to the node's border box, in CSS pixels.
	// When omitted, center of the node will be used, similar to Element.scrollIntoView.
	Rect *DOMRect `json:"rect,omitempty"`
}

// ProtoReq name.
func (m DOMScrollIntoViewIfNeeded) ProtoReq() string { return "DOM.scrollIntoViewIfNeeded" }

// Call sends the request.
func (m DOMScrollIntoViewIfNeeded) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDisable Disables DOM agent for the given page.
type DOMDisable struct{}

// ProtoReq name.
func (m DOMDisable) ProtoReq() string { return "DOM.disable" }

// Call sends the request.
func (m DOMDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDiscardSearchResults (experimental) Discards search results from the session with the given id. `getSearchResults` should no longer
// be called for that search.
type DOMDiscardSearchResults struct {
	// SearchID Unique search session identifier.
	SearchID string `json:"searchId"`
}

// ProtoReq name.
func (m DOMDiscardSearchResults) ProtoReq() string { return "DOM.discardSearchResults" }

// Call sends the request.
func (m DOMDiscardSearchResults) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMEnableIncludeWhitespace enum.
type DOMEnableIncludeWhitespace string

const (
	// DOMEnableIncludeWhitespaceNone enum const.
	DOMEnableIncludeWhitespaceNone DOMEnableIncludeWhitespace = "none"

	// DOMEnableIncludeWhitespaceAll enum const.
	DOMEnableIncludeWhitespaceAll DOMEnableIncludeWhitespace = "all"
)

// DOMEnable Enables DOM agent for the given page.
type DOMEnable struct {
	// IncludeWhitespace (experimental) (optional) Whether to include whitespaces in the children array of returned Nodes.
	IncludeWhitespace DOMEnableIncludeWhitespace `json:"includeWhitespace,omitempty"`
}

// ProtoReq name.
func (m DOMEnable) ProtoReq() string { return "DOM.enable" }

// Call sends the request.
func (m DOMEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMFocus Focuses the given element.
type DOMFocus struct {
	// NodeID (optional) Identifier of the node.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Identifier of the backend node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectID (optional) JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`
}

// ProtoReq name.
func (m DOMFocus) ProtoReq() string { return "DOM.focus" }

// Call sends the request.
func (m DOMFocus) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMGetAttributes Returns attributes for the specified node.
type DOMGetAttributes struct {
	// NodeID Id of the node to retrieve attributes for.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m DOMGetAttributes) ProtoReq() string { return "DOM.getAttributes" }

// Call the request.
func (m DOMGetAttributes) Call(c Client) (*DOMGetAttributesResult, error) {
	var res DOMGetAttributesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetAttributesResult ...
type DOMGetAttributesResult struct {
	// Attributes An interleaved array of node attribute names and values.
	Attributes []string `json:"attributes"`
}

// DOMGetBoxModel Returns boxes for the given node.
type DOMGetBoxModel struct {
	// NodeID (optional) Identifier of the node.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Identifier of the backend node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectID (optional) JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`
}

// ProtoReq name.
func (m DOMGetBoxModel) ProtoReq() string { return "DOM.getBoxModel" }

// Call the request.
func (m DOMGetBoxModel) Call(c Client) (*DOMGetBoxModelResult, error) {
	var res DOMGetBoxModelResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetBoxModelResult ...
type DOMGetBoxModelResult struct {
	// Model Box model for the node.
	Model *DOMBoxModel `json:"model"`
}

// DOMGetContentQuads (experimental) Returns quads that describe node position on the page. This method
// might return multiple quads for inline nodes.
type DOMGetContentQuads struct {
	// NodeID (optional) Identifier of the node.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Identifier of the backend node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectID (optional) JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`
}

// ProtoReq name.
func (m DOMGetContentQuads) ProtoReq() string { return "DOM.getContentQuads" }

// Call the request.
func (m DOMGetContentQuads) Call(c Client) (*DOMGetContentQuadsResult, error) {
	var res DOMGetContentQuadsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetContentQuadsResult (experimental) ...
type DOMGetContentQuadsResult struct {
	// Quads that describe node layout relative to viewport.
	Quads []DOMQuad `json:"quads"`
}

// DOMGetDocument Returns the root DOM node (and optionally the subtree) to the caller.
// Implicitly enables the DOM domain events for the current target.
type DOMGetDocument struct {
	// Depth (optional) The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
	// entire subtree or provide an integer larger than 0.
	Depth *int `json:"depth,omitempty"`

	// Pierce (optional) Whether or not iframes and shadow roots should be traversed when returning the subtree
	// (default is false).
	Pierce bool `json:"pierce,omitempty"`
}

// ProtoReq name.
func (m DOMGetDocument) ProtoReq() string { return "DOM.getDocument" }

// Call the request.
func (m DOMGetDocument) Call(c Client) (*DOMGetDocumentResult, error) {
	var res DOMGetDocumentResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetDocumentResult ...
type DOMGetDocumentResult struct {
	// Root Resulting node.
	Root *DOMNode `json:"root"`
}

// DOMGetFlattenedDocument (deprecated) Returns the root DOM node (and optionally the subtree) to the caller.
// Deprecated, as it is not designed to work well with the rest of the DOM agent.
// Use DOMSnapshot.captureSnapshot instead.
type DOMGetFlattenedDocument struct {
	// Depth (optional) The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
	// entire subtree or provide an integer larger than 0.
	Depth *int `json:"depth,omitempty"`

	// Pierce (optional) Whether or not iframes and shadow roots should be traversed when returning the subtree
	// (default is false).
	Pierce bool `json:"pierce,omitempty"`
}

// ProtoReq name.
func (m DOMGetFlattenedDocument) ProtoReq() string { return "DOM.getFlattenedDocument" }

// Call the request.
func (m DOMGetFlattenedDocument) Call(c Client) (*DOMGetFlattenedDocumentResult, error) {
	var res DOMGetFlattenedDocumentResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetFlattenedDocumentResult (deprecated) ...
type DOMGetFlattenedDocumentResult struct {
	// Nodes Resulting node.
	Nodes []*DOMNode `json:"nodes"`
}

// DOMGetNodesForSubtreeByStyle (experimental) Finds nodes with a given computed style in a subtree.
type DOMGetNodesForSubtreeByStyle struct {
	// NodeID Node ID pointing to the root of a subtree.
	NodeID DOMNodeID `json:"nodeId"`

	// ComputedStyles The style to filter nodes by (includes nodes if any of properties matches).
	ComputedStyles []*DOMCSSComputedStyleProperty `json:"computedStyles"`

	// Pierce (optional) Whether or not iframes and shadow roots in the same target should be traversed when returning the
	// results (default is false).
	Pierce bool `json:"pierce,omitempty"`
}

// ProtoReq name.
func (m DOMGetNodesForSubtreeByStyle) ProtoReq() string { return "DOM.getNodesForSubtreeByStyle" }

// Call the request.
func (m DOMGetNodesForSubtreeByStyle) Call(c Client) (*DOMGetNodesForSubtreeByStyleResult, error) {
	var res DOMGetNodesForSubtreeByStyleResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetNodesForSubtreeByStyleResult (experimental) ...
type DOMGetNodesForSubtreeByStyleResult struct {
	// NodeIDs Resulting nodes.
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// DOMGetNodeForLocation Returns node id at given location. Depending on whether DOM domain is enabled, nodeId is
// either returned or not.
type DOMGetNodeForLocation struct {
	// X coordinate.
	X int `json:"x"`

	// Y coordinate.
	Y int `json:"y"`

	// IncludeUserAgentShadowDOM (optional) False to skip to the nearest non-UA shadow root ancestor (default: false).
	IncludeUserAgentShadowDOM bool `json:"includeUserAgentShadowDOM,omitempty"`

	// IgnorePointerEventsNone (optional) Whether to ignore pointer-events: none on elements and hit test them.
	IgnorePointerEventsNone bool `json:"ignorePointerEventsNone,omitempty"`
}

// ProtoReq name.
func (m DOMGetNodeForLocation) ProtoReq() string { return "DOM.getNodeForLocation" }

// Call the request.
func (m DOMGetNodeForLocation) Call(c Client) (*DOMGetNodeForLocationResult, error) {
	var res DOMGetNodeForLocationResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetNodeForLocationResult ...
type DOMGetNodeForLocationResult struct {
	// BackendNodeID Resulting node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId"`

	// FrameID Frame this node belongs to.
	FrameID PageFrameID `json:"frameId"`

	// NodeID (optional) Id of the node at given coordinates, only when enabled and requested document.
	NodeID DOMNodeID `json:"nodeId,omitempty"`
}

// DOMGetOuterHTML Returns node's HTML markup.
type DOMGetOuterHTML struct {
	// NodeID (optional) Identifier of the node.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Identifier of the backend node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectID (optional) JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`
}

// ProtoReq name.
func (m DOMGetOuterHTML) ProtoReq() string { return "DOM.getOuterHTML" }

// Call the request.
func (m DOMGetOuterHTML) Call(c Client) (*DOMGetOuterHTMLResult, error) {
	var res DOMGetOuterHTMLResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetOuterHTMLResult ...
type DOMGetOuterHTMLResult struct {
	// OuterHTML Outer HTML markup.
	OuterHTML string `json:"outerHTML"`
}

// DOMGetRelayoutBoundary (experimental) Returns the id of the nearest ancestor that is a relayout boundary.
type DOMGetRelayoutBoundary struct {
	// NodeID Id of the node.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m DOMGetRelayoutBoundary) ProtoReq() string { return "DOM.getRelayoutBoundary" }

// Call the request.
func (m DOMGetRelayoutBoundary) Call(c Client) (*DOMGetRelayoutBoundaryResult, error) {
	var res DOMGetRelayoutBoundaryResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetRelayoutBoundaryResult (experimental) ...
type DOMGetRelayoutBoundaryResult struct {
	// NodeID Relayout boundary node id for the given node.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMGetSearchResults (experimental) Returns search results from given `fromIndex` to given `toIndex` from the search with the given
// identifier.
type DOMGetSearchResults struct {
	// SearchID Unique search session identifier.
	SearchID string `json:"searchId"`

	// FromIndex Start index of the search result to be returned.
	FromIndex int `json:"fromIndex"`

	// ToIndex End index of the search result to be returned.
	ToIndex int `json:"toIndex"`
}

// ProtoReq name.
func (m DOMGetSearchResults) ProtoReq() string { return "DOM.getSearchResults" }

// Call the request.
func (m DOMGetSearchResults) Call(c Client) (*DOMGetSearchResultsResult, error) {
	var res DOMGetSearchResultsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetSearchResultsResult (experimental) ...
type DOMGetSearchResultsResult struct {
	// NodeIDs Ids of the search result nodes.
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// DOMHideHighlight Hides any highlight.
type DOMHideHighlight struct{}

// ProtoReq name.
func (m DOMHideHighlight) ProtoReq() string { return "DOM.hideHighlight" }

// Call sends the request.
func (m DOMHideHighlight) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMHighlightNode Highlights DOM node.
type DOMHighlightNode struct{}

// ProtoReq name.
func (m DOMHighlightNode) ProtoReq() string { return "DOM.highlightNode" }

// Call sends the request.
func (m DOMHighlightNode) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMHighlightRect Highlights given rectangle.
type DOMHighlightRect struct{}

// ProtoReq name.
func (m DOMHighlightRect) ProtoReq() string { return "DOM.highlightRect" }

// Call sends the request.
func (m DOMHighlightRect) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMMarkUndoableState (experimental) Marks last undoable state.
type DOMMarkUndoableState struct{}

// ProtoReq name.
func (m DOMMarkUndoableState) ProtoReq() string { return "DOM.markUndoableState" }

// Call sends the request.
func (m DOMMarkUndoableState) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMMoveTo Moves node into the new container, places it before the given anchor.
type DOMMoveTo struct {
	// NodeID Id of the node to move.
	NodeID DOMNodeID `json:"nodeId"`

	// TargetNodeID Id of the element to drop the moved node into.
	TargetNodeID DOMNodeID `json:"targetNodeId"`

	// InsertBeforeNodeID (optional) Drop node before this one (if absent, the moved node becomes the last child of
	// `targetNodeId`).
	InsertBeforeNodeID DOMNodeID `json:"insertBeforeNodeId,omitempty"`
}

// ProtoReq name.
func (m DOMMoveTo) ProtoReq() string { return "DOM.moveTo" }

// Call the request.
func (m DOMMoveTo) Call(c Client) (*DOMMoveToResult, error) {
	var res DOMMoveToResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMMoveToResult ...
type DOMMoveToResult struct {
	// NodeID New id of the moved node.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMPerformSearch (experimental) Searches for a given string in the DOM tree. Use `getSearchResults` to access search results or
// `cancelSearch` to end this search session.
type DOMPerformSearch struct {
	// Query Plain text or query selector or XPath search query.
	Query string `json:"query"`

	// IncludeUserAgentShadowDOM (optional) True to search in user agent shadow DOM.
	IncludeUserAgentShadowDOM bool `json:"includeUserAgentShadowDOM,omitempty"`
}

// ProtoReq name.
func (m DOMPerformSearch) ProtoReq() string { return "DOM.performSearch" }

// Call the request.
func (m DOMPerformSearch) Call(c Client) (*DOMPerformSearchResult, error) {
	var res DOMPerformSearchResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMPerformSearchResult (experimental) ...
type DOMPerformSearchResult struct {
	// SearchID Unique search session identifier.
	SearchID string `json:"searchId"`

	// ResultCount Number of search results.
	ResultCount int `json:"resultCount"`
}

// DOMPushNodeByPathToFrontend (experimental) Requests that the node is sent to the caller given its path. // FIXME, use XPath.
type DOMPushNodeByPathToFrontend struct {
	// Path to node in the proprietary format.
	Path string `json:"path"`
}

// ProtoReq name.
func (m DOMPushNodeByPathToFrontend) ProtoReq() string { return "DOM.pushNodeByPathToFrontend" }

// Call the request.
func (m DOMPushNodeByPathToFrontend) Call(c Client) (*DOMPushNodeByPathToFrontendResult, error) {
	var res DOMPushNodeByPathToFrontendResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMPushNodeByPathToFrontendResult (experimental) ...
type DOMPushNodeByPathToFrontendResult struct {
	// NodeID Id of the node for given path.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMPushNodesByBackendIDsToFrontend (experimental) Requests that a batch of nodes is sent to the caller given their backend node ids.
type DOMPushNodesByBackendIDsToFrontend struct {
	// BackendNodeIDs The array of backend node ids.
	BackendNodeIDs []DOMBackendNodeID `json:"backendNodeIds"`
}

// ProtoReq name.
func (m DOMPushNodesByBackendIDsToFrontend) ProtoReq() string {
	return "DOM.pushNodesByBackendIdsToFrontend"
}

// Call the request.
func (m DOMPushNodesByBackendIDsToFrontend) Call(c Client) (*DOMPushNodesByBackendIDsToFrontendResult, error) {
	var res DOMPushNodesByBackendIDsToFrontendResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMPushNodesByBackendIDsToFrontendResult (experimental) ...
type DOMPushNodesByBackendIDsToFrontendResult struct {
	// NodeIDs The array of ids of pushed nodes that correspond to the backend ids specified in
	// backendNodeIds.
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// DOMQuerySelector Executes `querySelector` on a given node.
type DOMQuerySelector struct {
	// NodeID Id of the node to query upon.
	NodeID DOMNodeID `json:"nodeId"`

	// Selector string.
	Selector string `json:"selector"`
}

// ProtoReq name.
func (m DOMQuerySelector) ProtoReq() string { return "DOM.querySelector" }

// Call the request.
func (m DOMQuerySelector) Call(c Client) (*DOMQuerySelectorResult, error) {
	var res DOMQuerySelectorResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMQuerySelectorResult ...
type DOMQuerySelectorResult struct {
	// NodeID Query selector result.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMQuerySelectorAll Executes `querySelectorAll` on a given node.
type DOMQuerySelectorAll struct {
	// NodeID Id of the node to query upon.
	NodeID DOMNodeID `json:"nodeId"`

	// Selector string.
	Selector string `json:"selector"`
}

// ProtoReq name.
func (m DOMQuerySelectorAll) ProtoReq() string { return "DOM.querySelectorAll" }

// Call the request.
func (m DOMQuerySelectorAll) Call(c Client) (*DOMQuerySelectorAllResult, error) {
	var res DOMQuerySelectorAllResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMQuerySelectorAllResult ...
type DOMQuerySelectorAllResult struct {
	// NodeIDs Query selector result.
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// DOMGetTopLayerElements (experimental) Returns NodeIds of current top layer elements.
// Top layer is rendered closest to the user within a viewport, therefore its elements always
// appear on top of all other content.
type DOMGetTopLayerElements struct{}

// ProtoReq name.
func (m DOMGetTopLayerElements) ProtoReq() string { return "DOM.getTopLayerElements" }

// Call the request.
func (m DOMGetTopLayerElements) Call(c Client) (*DOMGetTopLayerElementsResult, error) {
	var res DOMGetTopLayerElementsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetTopLayerElementsResult (experimental) ...
type DOMGetTopLayerElementsResult struct {
	// NodeIDs NodeIds of top layer elements
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// DOMGetElementByRelationRelation enum.
type DOMGetElementByRelationRelation string

const (
	// DOMGetElementByRelationRelationPopoverTarget enum const.
	DOMGetElementByRelationRelationPopoverTarget DOMGetElementByRelationRelation = "PopoverTarget"
)

// DOMGetElementByRelation (experimental) Returns the NodeId of the matched element according to certain relations.
type DOMGetElementByRelation struct {
	// NodeID Id of the node from which to query the relation.
	NodeID DOMNodeID `json:"nodeId"`

	// Relation Type of relation to get.
	Relation DOMGetElementByRelationRelation `json:"relation"`
}

// ProtoReq name.
func (m DOMGetElementByRelation) ProtoReq() string { return "DOM.getElementByRelation" }

// Call the request.
func (m DOMGetElementByRelation) Call(c Client) (*DOMGetElementByRelationResult, error) {
	var res DOMGetElementByRelationResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetElementByRelationResult (experimental) ...
type DOMGetElementByRelationResult struct {
	// NodeID NodeId of the element matching the queried relation.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMRedo (experimental) Re-does the last undone action.
type DOMRedo struct{}

// ProtoReq name.
func (m DOMRedo) ProtoReq() string { return "DOM.redo" }

// Call sends the request.
func (m DOMRedo) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMRemoveAttribute Removes attribute with given name from an element with given id.
type DOMRemoveAttribute struct {
	// NodeID Id of the element to remove attribute from.
	NodeID DOMNodeID `json:"nodeId"`

	// Name of the attribute to remove.
	Name string `json:"name"`
}

// ProtoReq name.
func (m DOMRemoveAttribute) ProtoReq() string { return "DOM.removeAttribute" }

// Call sends the request.
func (m DOMRemoveAttribute) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMRemoveNode Removes node with given id.
type DOMRemoveNode struct {
	// NodeID Id of the node to remove.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m DOMRemoveNode) ProtoReq() string { return "DOM.removeNode" }

// Call sends the request.
func (m DOMRemoveNode) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMRequestChildNodes Requests that children of the node with given id are returned to the caller in form of
// `setChildNodes` events where not only immediate children are retrieved, but all children down to
// the specified depth.
type DOMRequestChildNodes struct {
	// NodeID Id of the node to get children for.
	NodeID DOMNodeID `json:"nodeId"`

	// Depth (optional) The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
	// entire subtree or provide an integer larger than 0.
	Depth *int `json:"depth,omitempty"`

	// Pierce (optional) Whether or not iframes and shadow roots should be traversed when returning the sub-tree
	// (default is false).
	Pierce bool `json:"pierce,omitempty"`
}

// ProtoReq name.
func (m DOMRequestChildNodes) ProtoReq() string { return "DOM.requestChildNodes" }

// Call sends the request.
func (m DOMRequestChildNodes) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMRequestNode Requests that the node is sent to the caller given the JavaScript node object reference. All
// nodes that form the path from the node to the root are also sent to the client as a series of
// `setChildNodes` notifications.
type DOMRequestNode struct {
	// ObjectID JavaScript object id to convert into node.
	ObjectID RuntimeRemoteObjectID `json:"objectId"`
}

// ProtoReq name.
func (m DOMRequestNode) ProtoReq() string { return "DOM.requestNode" }

// Call the request.
func (m DOMRequestNode) Call(c Client) (*DOMRequestNodeResult, error) {
	var res DOMRequestNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMRequestNodeResult ...
type DOMRequestNodeResult struct {
	// NodeID Node id for given object.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMResolveNode Resolves the JavaScript node object for a given NodeId or BackendNodeId.
type DOMResolveNode struct {
	// NodeID (optional) Id of the node to resolve.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Backend identifier of the node to resolve.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectGroup (optional) Symbolic group name that can be used to release multiple objects.
	ObjectGroup string `json:"objectGroup,omitempty"`

	// ExecutionContextID (optional) Execution context in which to resolve the node.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`
}

// ProtoReq name.
func (m DOMResolveNode) ProtoReq() string { return "DOM.resolveNode" }

// Call the request.
func (m DOMResolveNode) Call(c Client) (*DOMResolveNodeResult, error) {
	var res DOMResolveNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMResolveNodeResult ...
type DOMResolveNodeResult struct {
	// Object JavaScript object wrapper for given node.
	Object *RuntimeRemoteObject `json:"object"`
}

// DOMSetAttributeValue Sets attribute for an element with given id.
type DOMSetAttributeValue struct {
	// NodeID Id of the element to set attribute for.
	NodeID DOMNodeID `json:"nodeId"`

	// Name Attribute name.
	Name string `json:"name"`

	// Value Attribute value.
	Value string `json:"value"`
}

// ProtoReq name.
func (m DOMSetAttributeValue) ProtoReq() string { return "DOM.setAttributeValue" }

// Call sends the request.
func (m DOMSetAttributeValue) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMSetAttributesAsText Sets attributes on element with given id. This method is useful when user edits some existing
// attribute value and types in several attribute name/value pairs.
type DOMSetAttributesAsText struct {
	// NodeID Id of the element to set attributes for.
	NodeID DOMNodeID `json:"nodeId"`

	// Text with a number of attributes. Will parse this text using HTML parser.
	Text string `json:"text"`

	// Name (optional) Attribute name to replace with new attributes derived from text in case text parsed
	// successfully.
	Name string `json:"name,omitempty"`
}

// ProtoReq name.
func (m DOMSetAttributesAsText) ProtoReq() string { return "DOM.setAttributesAsText" }

// Call sends the request.
func (m DOMSetAttributesAsText) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMSetFileInputFiles Sets files for the given file input element.
type DOMSetFileInputFiles struct {
	// Files Array of file paths to set.
	Files []string `json:"files"`

	// NodeID (optional) Identifier of the node.
	NodeID DOMNodeID `json:"nodeId,omitempty"`

	// BackendNodeID (optional) Identifier of the backend node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`

	// ObjectID (optional) JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`
}

// ProtoReq name.
func (m DOMSetFileInputFiles) ProtoReq() string { return "DOM.setFileInputFiles" }

// Call sends the request.
func (m DOMSetFileInputFiles) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMSetNodeStackTracesEnabled (experimental) Sets if stack traces should be captured for Nodes. See `Node.getNodeStackTraces`. Default is disabled.
type DOMSetNodeStackTracesEnabled struct {
	// Enable or disable.
	Enable bool `json:"enable"`
}

// ProtoReq name.
func (m DOMSetNodeStackTracesEnabled) ProtoReq() string { return "DOM.setNodeStackTracesEnabled" }

// Call sends the request.
func (m DOMSetNodeStackTracesEnabled) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMGetNodeStackTraces (experimental) Gets stack traces associated with a Node. As of now, only provides stack trace for Node creation.
type DOMGetNodeStackTraces struct {
	// NodeID Id of the node to get stack traces for.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m DOMGetNodeStackTraces) ProtoReq() string { return "DOM.getNodeStackTraces" }

// Call the request.
func (m DOMGetNodeStackTraces) Call(c Client) (*DOMGetNodeStackTracesResult, error) {
	var res DOMGetNodeStackTracesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetNodeStackTracesResult (experimental) ...
type DOMGetNodeStackTracesResult struct {
	// Creation (optional) Creation stack trace, if available.
	Creation *RuntimeStackTrace `json:"creation,omitempty"`
}

// DOMGetFileInfo (experimental) Returns file information for the given
// File wrapper.
type DOMGetFileInfo struct {
	// ObjectID JavaScript object id of the node wrapper.
	ObjectID RuntimeRemoteObjectID `json:"objectId"`
}

// ProtoReq name.
func (m DOMGetFileInfo) ProtoReq() string { return "DOM.getFileInfo" }

// Call the request.
func (m DOMGetFileInfo) Call(c Client) (*DOMGetFileInfoResult, error) {
	var res DOMGetFileInfoResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetFileInfoResult (experimental) ...
type DOMGetFileInfoResult struct {
	// Path ...
	Path string `json:"path"`
}

// DOMSetInspectedNode (experimental) Enables console to refer to the node with given id via $x (see Command Line API for more details
// $x functions).
type DOMSetInspectedNode struct {
	// NodeID DOM node id to be accessible by means of $x command line API.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m DOMSetInspectedNode) ProtoReq() string { return "DOM.setInspectedNode" }

// Call sends the request.
func (m DOMSetInspectedNode) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMSetNodeName Sets node name for a node with given id.
type DOMSetNodeName struct {
	// NodeID Id of the node to set name for.
	NodeID DOMNodeID `json:"nodeId"`

	// Name New node's name.
	Name string `json:"name"`
}

// ProtoReq name.
func (m DOMSetNodeName) ProtoReq() string { return "DOM.setNodeName" }

// Call the request.
func (m DOMSetNodeName) Call(c Client) (*DOMSetNodeNameResult, error) {
	var res DOMSetNodeNameResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMSetNodeNameResult ...
type DOMSetNodeNameResult struct {
	// NodeID New node's id.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMSetNodeValue Sets node value for a node with given id.
type DOMSetNodeValue struct {
	// NodeID Id of the node to set value for.
	NodeID DOMNodeID `json:"nodeId"`

	// Value New node's value.
	Value string `json:"value"`
}

// ProtoReq name.
func (m DOMSetNodeValue) ProtoReq() string { return "DOM.setNodeValue" }

// Call sends the request.
func (m DOMSetNodeValue) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMSetOuterHTML Sets node HTML markup, returns new node id.
type DOMSetOuterHTML struct {
	// NodeID Id of the node to set markup for.
	NodeID DOMNodeID `json:"nodeId"`

	// OuterHTML Outer HTML markup to set.
	OuterHTML string `json:"outerHTML"`
}

// ProtoReq name.
func (m DOMSetOuterHTML) ProtoReq() string { return "DOM.setOuterHTML" }

// Call sends the request.
func (m DOMSetOuterHTML) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMUndo (experimental) Undoes the last performed action.
type DOMUndo struct{}

// ProtoReq name.
func (m DOMUndo) ProtoReq() string { return "DOM.undo" }

// Call sends the request.
func (m DOMUndo) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMGetFrameOwner (experimental) Returns iframe node that owns iframe with the given domain.
type DOMGetFrameOwner struct {
	// FrameID ...
	FrameID PageFrameID `json:"frameId"`
}

// ProtoReq name.
func (m DOMGetFrameOwner) ProtoReq() string { return "DOM.getFrameOwner" }

// Call the request.
func (m DOMGetFrameOwner) Call(c Client) (*DOMGetFrameOwnerResult, error) {
	var res DOMGetFrameOwnerResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetFrameOwnerResult (experimental) ...
type DOMGetFrameOwnerResult struct {
	// BackendNodeID Resulting node.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId"`

	// NodeID (optional) Id of the node at given coordinates, only when enabled and requested document.
	NodeID DOMNodeID `json:"nodeId,omitempty"`
}

// DOMGetContainerForNode (experimental) Returns the query container of the given node based on container query
// conditions: containerName, physical, and logical axes. If no axes are
// provided, the style container is returned, which is the direct parent or the
// closest element with a matching container-name.
type DOMGetContainerForNode struct {
	// NodeID ...
	NodeID DOMNodeID `json:"nodeId"`

	// ContainerName (optional) ...
	ContainerName string `json:"containerName,omitempty"`

	// PhysicalAxes (optional) ...
	PhysicalAxes DOMPhysicalAxes `json:"physicalAxes,omitempty"`

	// LogicalAxes (optional) ...
	LogicalAxes DOMLogicalAxes `json:"logicalAxes,omitempty"`
}

// ProtoReq name.
func (m DOMGetContainerForNode) ProtoReq() string { return "DOM.getContainerForNode" }

// Call the request.
func (m DOMGetContainerForNode) Call(c Client) (*DOMGetContainerForNodeResult, error) {
	var res DOMGetContainerForNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetContainerForNodeResult (experimental) ...
type DOMGetContainerForNodeResult struct {
	// NodeID (optional) The container node for the given node, or null if not found.
	NodeID DOMNodeID `json:"nodeId,omitempty"`
}

// DOMGetQueryingDescendantsForContainer (experimental) Returns the descendants of a container query container that have
// container queries against this container.
type DOMGetQueryingDescendantsForContainer struct {
	// NodeID Id of the container node to find querying descendants from.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m DOMGetQueryingDescendantsForContainer) ProtoReq() string {
	return "DOM.getQueryingDescendantsForContainer"
}

// Call the request.
func (m DOMGetQueryingDescendantsForContainer) Call(c Client) (*DOMGetQueryingDescendantsForContainerResult, error) {
	var res DOMGetQueryingDescendantsForContainerResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetQueryingDescendantsForContainerResult (experimental) ...
type DOMGetQueryingDescendantsForContainerResult struct {
	// NodeIDs Descendant nodes with container queries against the given container.
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// DOMGetAnchorElement (experimental) Returns the target anchor element of the given anchor query according to
// https://www.w3.org/TR/css-anchor-position-1/#target.
type DOMGetAnchorElement struct {
	// NodeID Id of the positioned element from which to find the anchor.
	NodeID DOMNodeID `json:"nodeId"`

	// AnchorSpecifier (optional) An optional anchor specifier, as defined in
	// https://www.w3.org/TR/css-anchor-position-1/#anchor-specifier.
	// If not provided, it will return the implicit anchor element for
	// the given positioned element.
	AnchorSpecifier string `json:"anchorSpecifier,omitempty"`
}

// ProtoReq name.
func (m DOMGetAnchorElement) ProtoReq() string { return "DOM.getAnchorElement" }

// Call the request.
func (m DOMGetAnchorElement) Call(c Client) (*DOMGetAnchorElementResult, error) {
	var res DOMGetAnchorElementResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMGetAnchorElementResult (experimental) ...
type DOMGetAnchorElementResult struct {
	// NodeID The anchor element of the given anchor query.
	NodeID DOMNodeID `json:"nodeId"`
}

// DOMAttributeModified Fired when `Element`'s attribute is modified.
type DOMAttributeModified struct {
	// NodeID Id of the node that has changed.
	NodeID DOMNodeID `json:"nodeId"`

	// Name Attribute name.
	Name string `json:"name"`

	// Value Attribute value.
	Value string `json:"value"`
}

// ProtoEvent name.
func (evt DOMAttributeModified) ProtoEvent() string {
	return "DOM.attributeModified"
}

// DOMAttributeRemoved Fired when `Element`'s attribute is removed.
type DOMAttributeRemoved struct {
	// NodeID Id of the node that has changed.
	NodeID DOMNodeID `json:"nodeId"`

	// Name A ttribute name.
	Name string `json:"name"`
}

// ProtoEvent name.
func (evt DOMAttributeRemoved) ProtoEvent() string {
	return "DOM.attributeRemoved"
}

// DOMCharacterDataModified Mirrors `DOMCharacterDataModified` event.
type DOMCharacterDataModified struct {
	// NodeID Id of the node that has changed.
	NodeID DOMNodeID `json:"nodeId"`

	// CharacterData New text value.
	CharacterData string `json:"characterData"`
}

// ProtoEvent name.
func (evt DOMCharacterDataModified) ProtoEvent() string {
	return "DOM.characterDataModified"
}

// DOMChildNodeCountUpdated Fired when `Container`'s child node count has changed.
type DOMChildNodeCountUpdated struct {
	// NodeID Id of the node that has changed.
	NodeID DOMNodeID `json:"nodeId"`

	// ChildNodeCount New node count.
	ChildNodeCount int `json:"childNodeCount"`
}

// ProtoEvent name.
func (evt DOMChildNodeCountUpdated) ProtoEvent() string {
	return "DOM.childNodeCountUpdated"
}

// DOMChildNodeInserted Mirrors `DOMNodeInserted` event.
type DOMChildNodeInserted struct {
	// ParentNodeID Id of the node that has changed.
	ParentNodeID DOMNodeID `json:"parentNodeId"`

	// PreviousNodeID Id of the previous sibling.
	PreviousNodeID DOMNodeID `json:"previousNodeId"`

	// Node Inserted node data.
	Node *DOMNode `json:"node"`
}

// ProtoEvent name.
func (evt DOMChildNodeInserted) ProtoEvent() string {
	return "DOM.childNodeInserted"
}

// DOMChildNodeRemoved Mirrors `DOMNodeRemoved` event.
type DOMChildNodeRemoved struct {
	// ParentNodeID Parent id.
	ParentNodeID DOMNodeID `json:"parentNodeId"`

	// NodeID Id of the node that has been removed.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoEvent name.
func (evt DOMChildNodeRemoved) ProtoEvent() string {
	return "DOM.childNodeRemoved"
}

// DOMDistributedNodesUpdated (experimental) Called when distribution is changed.
type DOMDistributedNodesUpdated struct {
	// InsertionPointID Insertion point where distributed nodes were updated.
	InsertionPointID DOMNodeID `json:"insertionPointId"`

	// DistributedNodes Distributed nodes for given insertion point.
	DistributedNodes []*DOMBackendNode `json:"distributedNodes"`
}

// ProtoEvent name.
func (evt DOMDistributedNodesUpdated) ProtoEvent() string {
	return "DOM.distributedNodesUpdated"
}

// DOMDocumentUpdated Fired when `Document` has been totally updated. Node ids are no longer valid.
type DOMDocumentUpdated struct{}

// ProtoEvent name.
func (evt DOMDocumentUpdated) ProtoEvent() string {
	return "DOM.documentUpdated"
}

// DOMInlineStyleInvalidated (experimental) Fired when `Element`'s inline style is modified via a CSS property modification.
type DOMInlineStyleInvalidated struct {
	// NodeIDs Ids of the nodes for which the inline styles have been invalidated.
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// ProtoEvent name.
func (evt DOMInlineStyleInvalidated) ProtoEvent() string {
	return "DOM.inlineStyleInvalidated"
}

// DOMPseudoElementAdded (experimental) Called when a pseudo element is added to an element.
type DOMPseudoElementAdded struct {
	// ParentID Pseudo element's parent element id.
	ParentID DOMNodeID `json:"parentId"`

	// PseudoElement The added pseudo element.
	PseudoElement *DOMNode `json:"pseudoElement"`
}

// ProtoEvent name.
func (evt DOMPseudoElementAdded) ProtoEvent() string {
	return "DOM.pseudoElementAdded"
}

// DOMTopLayerElementsUpdated (experimental) Called when top layer elements are changed.
type DOMTopLayerElementsUpdated struct{}

// ProtoEvent name.
func (evt DOMTopLayerElementsUpdated) ProtoEvent() string {
	return "DOM.topLayerElementsUpdated"
}

// DOMPseudoElementRemoved (experimental) Called when a pseudo element is removed from an element.
type DOMPseudoElementRemoved struct {
	// ParentID Pseudo element's parent element id.
	ParentID DOMNodeID `json:"parentId"`

	// PseudoElementID The removed pseudo element id.
	PseudoElementID DOMNodeID `json:"pseudoElementId"`
}

// ProtoEvent name.
func (evt DOMPseudoElementRemoved) ProtoEvent() string {
	return "DOM.pseudoElementRemoved"
}

// DOMSetChildNodes Fired when backend wants to provide client with the missing DOM structure. This happens upon
// most of the calls requesting node ids.
type DOMSetChildNodes struct {
	// ParentID Parent node id to populate with children.
	ParentID DOMNodeID `json:"parentId"`

	// Nodes Child nodes array.
	Nodes []*DOMNode `json:"nodes"`
}

// ProtoEvent name.
func (evt DOMSetChildNodes) ProtoEvent() string {
	return "DOM.setChildNodes"
}

// DOMShadowRootPopped (experimental) Called when shadow root is popped from the element.
type DOMShadowRootPopped struct {
	// HostID Host element id.
	HostID DOMNodeID `json:"hostId"`

	// RootID Shadow root id.
	RootID DOMNodeID `json:"rootId"`
}

// ProtoEvent name.
func (evt DOMShadowRootPopped) ProtoEvent() string {
	return "DOM.shadowRootPopped"
}

// DOMShadowRootPushed (experimental) Called when shadow root is pushed into the element.
type DOMShadowRootPushed struct {
	// HostID Host element id.
	HostID DOMNodeID `json:"hostId"`

	// Root Shadow root.
	Root *DOMNode `json:"root"`
}

// ProtoEvent name.
func (evt DOMShadowRootPushed) ProtoEvent() string {
	return "DOM.shadowRootPushed"
}
