/* Plug.c generated by valac 0.56.18, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2019-2024 elementary, Inc. (https://elementary.io)
 */

#include "wacom.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_PLUG_0_PROPERTY,
	WACOM_PLUG_NUM_PROPERTIES
};
static GParamSpec* wacom_plug_properties[WACOM_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _WacomPlugSearchData WacomPlugSearchData;

struct _WacomPlugPrivate {
	GtkBox* box;
};

struct _WacomPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	WacomPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
};

static gint WacomPlug_private_offset;
static gpointer wacom_plug_parent_class = NULL;

static GtkWidget* wacom_plug_real_get_widget (SwitchboardPlug* base);
static void wacom_plug_real_shown (SwitchboardPlug* base);
static void wacom_plug_real_hidden (SwitchboardPlug* base);
static void wacom_plug_real_search_callback (SwitchboardPlug* base,
                                      const gchar* location);
static void wacom_plug_real_search_data_free (gpointer _data);
static void wacom_plug_real_search (SwitchboardPlug* base,
                             const gchar* search,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static gboolean wacom_plug_real_search_co (WacomPlugSearchData* _data_);
static void wacom_plug_finalize (GObject * obj);
static GType wacom_plug_get_type_once (void);

static inline gpointer
wacom_plug_get_instance_private (WacomPlug* self)
{
	return G_STRUCT_MEMBER_P (self, WacomPlug_private_offset);
}

WacomPlug*
wacom_plug_construct (GType object_type)
{
	WacomPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/pointing/stylus", "general");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/wacom", "general");
	self = (WacomPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "pantheon-wacom", "display-name", _ ("Wacom"), "description", _ ("Configure Wacom tablet"), "icon", "input-tablet", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

WacomPlug*
wacom_plug_new (void)
{
	return wacom_plug_construct (WACOM_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
wacom_plug_real_get_widget (SwitchboardPlug* base)
{
	WacomPlug * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* result;
	self = (WacomPlug*) base;
	_tmp0_ = self->priv->box;
	if (_tmp0_ == NULL) {
		AdwHeaderBar* headerbar = NULL;
		AdwHeaderBar* _tmp1_ = NULL;
		AdwHeaderBar* _tmp2_;
		WacomMainPage* main_page = NULL;
		WacomMainPage* _tmp3_ = NULL;
		GtkBox* _tmp4_;
		GtkBox* _tmp5_;
		AdwHeaderBar* _tmp6_;
		GtkBox* _tmp7_;
		WacomMainPage* _tmp8_;
		_tmp1_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_show_title (_tmp1_, FALSE);
		g_object_ref_sink (_tmp1_);
		headerbar = _tmp1_;
		_tmp2_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_FLAT);
		_tmp3_ = wacom_main_page_new ();
		gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
		g_object_ref_sink (_tmp3_);
		main_page = _tmp3_;
		_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->box);
		self->priv->box = _tmp4_;
		_tmp5_ = self->priv->box;
		_tmp6_ = headerbar;
		gtk_box_append (_tmp5_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->box;
		_tmp8_ = main_page;
		gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
		_g_object_unref0 (main_page);
		_g_object_unref0 (headerbar);
	}
	_tmp9_ = self->priv->box;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	result = _tmp10_;
	return result;
}

static void
wacom_plug_real_shown (SwitchboardPlug* base)
{
	WacomPlug * self;
	self = (WacomPlug*) base;
}

static void
wacom_plug_real_hidden (SwitchboardPlug* base)
{
	WacomPlug * self;
	self = (WacomPlug*) base;
}

static void
wacom_plug_real_search_callback (SwitchboardPlug* base,
                                 const gchar* location)
{
	WacomPlug * self;
	self = (WacomPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
wacom_plug_real_search_data_free (gpointer _data)
{
	WacomPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (WacomPlugSearchData, _data_);
}

static void
wacom_plug_real_search (SwitchboardPlug* base,
                        const gchar* search,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	WacomPlug * self;
	WacomPlugSearchData* _data_;
	WacomPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (WacomPlug*) base;
	_data_ = g_slice_new0 (WacomPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, wacom_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	wacom_plug_real_search_co (_data_);
}

static GeeTreeMap*
wacom_plug_search_finish (SwitchboardPlug* base,
                          GAsyncResult* _res_)
{
	GeeTreeMap* result;
	WacomPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
wacom_plug_real_search_co (WacomPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
wacom_plug_class_init (WacomPlugClass * klass,
                       gpointer klass_data)
{
	wacom_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) wacom_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) wacom_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) wacom_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) wacom_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) wacom_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) wacom_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = wacom_plug_finalize;
}

static void
wacom_plug_instance_init (WacomPlug * self,
                          gpointer klass)
{
	self->priv = wacom_plug_get_instance_private (self);
}

static void
wacom_plug_finalize (GObject * obj)
{
	WacomPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_TYPE_PLUG, WacomPlug);
	_g_object_unref0 (self->priv->box);
	G_OBJECT_CLASS (wacom_plug_parent_class)->finalize (obj);
}

static GType
wacom_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomPlug), 0, (GInstanceInitFunc) wacom_plug_instance_init, NULL };
	GType wacom_plug_type_id;
	wacom_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "WacomPlug", &g_define_type_info, 0);
	WacomPlug_private_offset = g_type_add_instance_private (wacom_plug_type_id, sizeof (WacomPlugPrivate));
	return wacom_plug_type_id;
}

GType
wacom_plug_get_type (void)
{
	static volatile gsize wacom_plug_type_id__once = 0;
	if (g_once_init_enter (&wacom_plug_type_id__once)) {
		GType wacom_plug_type_id;
		wacom_plug_type_id = wacom_plug_get_type_once ();
		g_once_init_leave (&wacom_plug_type_id__once, wacom_plug_type_id);
	}
	return wacom_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	WacomPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:68: Activating Wacom plug");
	_tmp0_ = wacom_plug_new ();
	result = (SwitchboardPlug*) _tmp0_;
	return result;
}

