/*
   Unix SMB/CIFS implementation.
   test suite for spoolss ndr operations

   Copyright (C) Jelmer Vernooij 2007
   Copyright (C) Guenther Deschner 2013

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_winspool.h"
#include "torture/ndr/proto.h"

static const uint8_t registerforremotenotifications_req_data[] = {
	0x00, 0x00, 0x00, 0x00, 0x6e, 0x61, 0x4c, 0x7b, 0xc1, 0x46, 0xde, 0x4b,
	0x81, 0x29, 0xcb, 0xa4, 0xd2, 0xf4, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x65, 0x00,
	0x6d, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x65, 0x00, 0x4e, 0x00, 0x6f, 0x00,
	0x74, 0x00, 0x69, 0x00, 0x66, 0x00, 0x79, 0x00, 0x46, 0x00, 0x69, 0x00,
	0x6c, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x46, 0x00,
	0x6c, 0x00, 0x61, 0x00, 0x67, 0x00, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x6f, 0x00,
	0x74, 0x00, 0x65, 0x00, 0x4e, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x69, 0x00,
	0x66, 0x00, 0x79, 0x00, 0x46, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x74, 0x00,
	0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x4f, 0x00, 0x70, 0x00, 0x74, 0x00,
	0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x65, 0x00,
	0x4e, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x69, 0x00, 0x66, 0x00, 0x79, 0x00,
	0x46, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x20, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x72, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x65, 0x00,
	0x6d, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x65, 0x00, 0x4e, 0x00, 0x6f, 0x00,
	0x74, 0x00, 0x69, 0x00, 0x66, 0x00, 0x79, 0x00, 0x46, 0x00, 0x69, 0x00,
	0x6c, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x4e, 0x00,
	0x6f, 0x00, 0x74, 0x00, 0x69, 0x00, 0x66, 0x00, 0x79, 0x00, 0x4f, 0x00,
	0x70, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x73, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00,
	0x06, 0x00, 0x0d, 0x00, 0x12, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x08, 0x00, 0x0a, 0x00, 0x0b, 0x00,
	0x0d, 0x00, 0x0f, 0x00, 0x10, 0x00, 0x13, 0x00, 0x14, 0x00, 0x15, 0x00,
	0x16, 0x00, 0x17, 0x00
};

static bool registerforremotenotifications_req_check(struct torture_context *tctx,
						     struct winspool_SyncRegisterForRemoteNotifications *r)
{
	struct winspool_PrintNamedProperty *p = r->in.pNotifyFilter->propertiesCollection;
	struct spoolss_NotifyOption *o;

	/* r->in.hPrinter */
	torture_assert(tctx, r->in.pNotifyFilter, "pNotifyFilter NULL");

	torture_assert_int_equal(tctx, r->in.pNotifyFilter->numberOfProperties, 4, "numberOfProperties");

	torture_assert_str_equal(tctx, p[0].propertyName, "RemoteNotifyFilter Flags", "propertyName");
	torture_assert_int_equal(tctx, p[0].propertyValue.PropertyType, winspool_PropertyTypeInt32, "PropertyType");
	torture_assert_int_equal(tctx, p[0].propertyValue.value.propertyInt32, 255, "propertyInt32");

	torture_assert_str_equal(tctx, p[1].propertyName, "RemoteNotifyFilter Options", "propertyName");
	torture_assert_int_equal(tctx, p[1].propertyValue.PropertyType, winspool_PropertyTypeInt32, "PropertyType");
	torture_assert_int_equal(tctx, p[1].propertyValue.value.propertyInt32, 0, "propertyInt32");

	torture_assert_str_equal(tctx, p[2].propertyName, "RemoteNotifyFilter Color", "propertyName");
	torture_assert_int_equal(tctx, p[2].propertyValue.PropertyType, winspool_PropertyTypeInt32, "PropertyType");
	torture_assert_int_equal(tctx, p[2].propertyValue.value.propertyInt32, 0, "propertyInt32");

	torture_assert_str_equal(tctx, p[3].propertyName, "RemoteNotifyFilter NotifyOptions", "propertyName");
	torture_assert_int_equal(tctx, p[3].propertyValue.PropertyType, winspool_PropertyTypeNotificationOptions, "PropertyType");

	o = p[3].propertyValue.value.propertyOptionsContainer.pOptions;

	torture_assert_int_equal(tctx, o->version, 2, "version");
	torture_assert_int_equal(tctx, o->flags, 0, "flags");
	torture_assert_int_equal(tctx, o->count, 2, "count");

	torture_assert_int_equal(tctx, o->types[0].type, PRINTER_NOTIFY_TYPE, "type");
	torture_assert_int_equal(tctx, o->types[0].u1, 0, "u1");
	torture_assert_int_equal(tctx, o->types[0].u2, 0, "u2");
	torture_assert_int_equal(tctx, o->types[0].u3, 0, "u3");
	torture_assert_int_equal(tctx, o->types[0].count, 10, "count");

	torture_assert_int_equal(tctx, o->types[0].fields[0].field, PRINTER_NOTIFY_FIELD_SERVER_NAME, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[1].field, PRINTER_NOTIFY_FIELD_PRINTER_NAME, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[2].field, PRINTER_NOTIFY_FIELD_SHARE_NAME, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[3].field, PRINTER_NOTIFY_FIELD_PORT_NAME, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[4].field, PRINTER_NOTIFY_FIELD_DRIVER_NAME, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[5].field, PRINTER_NOTIFY_FIELD_COMMENT, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[6].field, PRINTER_NOTIFY_FIELD_LOCATION, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[7].field, PRINTER_NOTIFY_FIELD_ATTRIBUTES, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[8].field, PRINTER_NOTIFY_FIELD_STATUS, "field");
	torture_assert_int_equal(tctx, o->types[0].fields[9].field, PRINTER_NOTIFY_FIELD_CJOBS, "field");

	torture_assert_int_equal(tctx, o->types[1].type, JOB_NOTIFY_TYPE, "type");
	torture_assert_int_equal(tctx, o->types[1].u1, 0, "u1");
	torture_assert_int_equal(tctx, o->types[1].u2, 0, "u2");
	torture_assert_int_equal(tctx, o->types[1].u3, 0, "u3");
	torture_assert_int_equal(tctx, o->types[1].count, 16, "count");

	torture_assert_int_equal(tctx, o->types[1].fields[0].field, JOB_NOTIFY_FIELD_PRINTER_NAME, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[1].field, JOB_NOTIFY_FIELD_MACHINE_NAME, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[2].field, JOB_NOTIFY_FIELD_PORT_NAME, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[3].field, JOB_NOTIFY_FIELD_USER_NAME, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[4].field, JOB_NOTIFY_FIELD_NOTIFY_NAME, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[5].field, JOB_NOTIFY_FIELD_DRIVER_NAME, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[6].field, JOB_NOTIFY_FIELD_STATUS, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[7].field, JOB_NOTIFY_FIELD_STATUS_STRING, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[8].field, JOB_NOTIFY_FIELD_DOCUMENT, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[9].field, JOB_NOTIFY_FIELD_POSITION, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[10].field, JOB_NOTIFY_FIELD_SUBMITTED, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[11].field, JOB_NOTIFY_FIELD_TIME, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[12].field, JOB_NOTIFY_FIELD_TOTAL_PAGES, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[13].field, JOB_NOTIFY_FIELD_PAGES_PRINTED, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[14].field, JOB_NOTIFY_FIELD_TOTAL_BYTES, "field");
	torture_assert_int_equal(tctx, o->types[1].fields[15].field, JOB_NOTIFY_FIELD_BYTES_PRINTED, "field");

	return true;
}

struct torture_suite *ndr_winspool_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "winspool");

	torture_suite_add_ndr_pull_fn_test_flags(suite,
						 winspool_SyncRegisterForRemoteNotifications,
						 registerforremotenotifications_req_data,
						 NDR_IN,
						 LIBNDR_FLAG_NDR64,
						 registerforremotenotifications_req_check);

	return suite;
}
