/*
 * Unix SMB/CIFS implementation.
 *
 * HRESULT Error definitions
 *
 * Copyright (C) Noel Power <noel.power@suse.com> 2014
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "includes.h"
#include "hresult.h"
/*
 * The following error codes and descriptions are autogenerated from [MS-ERREF]
 * see http://msdn.microsoft.com/en-us/library/cc704587.aspx
 */

const char *hresult_errstr_const(HRESULT err_code)
{
	const char *result = NULL;

	switch (HRES_ERROR_V(err_code)) {
            case 0x30200:
                result = "The underlying file was converted to compound file format.";
                break;
            case 0x30201:
                result = "The storage operation should block until more data is available.";
                break;
            case 0x30202:
                result = "The storage operation should retry immediately.";
                break;
            case 0x30203:
                result = "The notified event sink will not influence the storage operation.";
                break;
            case 0x30204:
                result = "Multiple opens prevent consolidated (commit succeeded).";
                break;
            case 0x30205:
                result = "Consolidation of the storage file failed (commit succeeded).";
                break;
            case 0x30206:
                result = "Consolidation of the storage file is inappropriate (commit succeeded).";
                break;
            case 0x40000:
                result = "Use the registry database to provide the requested information.";
                break;
            case 0x40001:
                result = "Success, but static.";
                break;
            case 0x40002:
                result = "Macintosh clipboard format.";
                break;
            case 0x40100:
                result = "Successful drop took place.";
                break;
            case 0x40101:
                result = "Drag-drop operation canceled.";
                break;
            case 0x40102:
                result = "Use the default cursor.";
                break;
            case 0x40130:
                result = "Data has same FORMATETC.";
                break;
            case 0x40140:
                result = "View is already frozen.";
                break;
            case 0x40170:
                result = "FORMATETC not supported.";
                break;
            case 0x40171:
                result = "Same cache.";
                break;
            case 0x40172:
                result = "Some caches are not updated.";
                break;
            case 0x40180:
                result = "Invalid verb for OLE object.";
                break;
            case 0x40181:
                result = "Verb number is valid but verb cannot be done now.";
                break;
            case 0x40182:
                result = "Invalid window handle passed.";
                break;
            case 0x401A0:
                result = "Message is too long; some of it had to be truncated before displaying.";
                break;
            case 0x401C0:
                result = "Unable to convert OLESTREAM to IStorage.";
                break;
            case 0x401E2:
                result = "Moniker reduced to itself.";
                break;
            case 0x401E4:
                result = "Common prefix is this moniker.";
                break;
            case 0x401E5:
                result = "Common prefix is input moniker.";
                break;
            case 0x401E6:
                result = "Common prefix is both monikers.";
                break;
            case 0x401E7:
                result = "Moniker is already registered in running object table.";
                break;
            case 0x40200:
                result = "An event was able to invoke some, but not all, of the subscribers.";
                break;
            case 0x40202:
                result = "An event was delivered, but there were no subscribers.";
                break;
            case 0x41300:
                result = "The task is ready to run at its next scheduled time.";
                break;
            case 0x41301:
                result = "The task is currently running.";
                break;
            case 0x41302:
                result = "The task will not run at the scheduled times because it has been disabled.";
                break;
            case 0x41303:
                result = "The task has not yet run.";
                break;
            case 0x41304:
                result = "There are no more runs scheduled for this task.";
                break;
            case 0x41305:
                result = "One or more of the properties that are needed to run this task on a schedule have not been set.";
                break;
            case 0x41306:
                result = "The last run of the task was terminated by the user.";
                break;
            case 0x41307:
                result = "Either the task has no triggers, or the existing triggers are disabled or not set.";
                break;
            case 0x41308:
                result = "Event triggers do not have set run times.";
                break;
            case 0x4131B:
                result = "The task is registered, but not all specified triggers will start the task.";
                break;
            case 0x4131C:
                result = "The task is registered, but it might fail to start. Batch logon privilege needs to be enabled for the task principal.";
                break;
            case 0x4D000:
                result = "An asynchronous operation was specified. The operation has begun, but its outcome is not known yet.";
                break;
            case 0x4D002:
                result = "The method call succeeded because the transaction was read-only.";
                break;
            case 0x4D003:
                result = "The transaction was successfully aborted. However, this is a coordinated transaction, and a number of enlisted resources were aborted outright because they could not support abort-retaining semantics.";
                break;
            case 0x4D004:
                result = "No changes were made during this call, but the sink wants another chance to look if any other sinks make further changes.";
                break;
            case 0x4D005:
                result = "The sink is content and wants the transaction to proceed. Changes were made to one or more resources during this call.";
                break;
            case 0x4D006:
                result = "The sink is for the moment and wants the transaction to proceed, but if other changes are made following this return by other event sinks, this sink wants another chance to look.";
                break;
            case 0x4D007:
                result = "The transaction was successfully aborted. However, the abort was nonretaining.";
                break;
            case 0x4D008:
                result = "An abort operation was already in progress.";
                break;
            case 0x4D009:
                result = "The resource manager has performed a single-phase commit of the transaction.";
                break;
            case 0x4D00A:
                result = "The local transaction has not aborted.";
                break;
            case 0x4D010:
                result = "The resource manager has requested to be the coordinator (last resource manager) for the transaction.";
                break;
            case 0x80012:
                result = "Not all the requested interfaces were available.";
                break;
            case 0x80013:
                result = "The specified machine name was not found in the cache.";
                break;
            case 0x90312:
                result = "The function completed successfully, but it must be called again to complete the context.";
                break;
            case 0x90313:
                result = "The function completed successfully, but CompleteToken must be called.";
                break;
            case 0x90314:
                result = "The function completed successfully, but both CompleteToken and this function must be called to complete the context.";
                break;
            case 0x90315:
                result = "The logon was completed, but no network authority was available. The logon was made using locally known information.";
                break;
            case 0x90317:
                result = "The context has expired and can no longer be used.";
                break;
            case 0x90320:
                result = "The credentials supplied were not complete and could not be verified. Additional information can be returned from the context.";
                break;
            case 0x90321:
                result = "The context data must be renegotiated with the peer.";
                break;
            case 0x90323:
                result = "There is no LSA mode context associated with this context.";
                break;
            case 0x9035C:
                result = "A signature operation must be performed before the user can authenticate.";
                break;
            case 0x91012:
                result = "The protected data needs to be reprotected.";
                break;
            case 0xD0000:
                result = "The requested operation is pending completion.";
                break;
            case 0xD0001:
                result = "The requested operation was aborted by the client.";
                break;
            case 0xD0002:
                result = "The stream was purposefully stopped before completion.";
                break;
            case 0xD0BC8:
                result = "The requested operation has caused the source to rebuffer.";
                break;
            case 0xD0BC9:
                result = "The requested operation has caused the source to degrade codec quality.";
                break;
            case 0xD0BDB:
                result = "The transcryptor object has reached end of file.";
                break;
            case 0xD0FE8:
                result = "An upgrade is needed for the theme manager to correctly show this skin. Skin reports version: %.1f.";
                break;
            case 0xD0FE9:
                result = "An error occurred in one of the UI components.";
                break;
            case 0xD1040:
                result = "Successfully loaded a GIF file.";
                break;
            case 0xD1041:
                result = "Successfully loaded a PNG file.";
                break;
            case 0xD1042:
                result = "Successfully loaded a BMP file.";
                break;
            case 0xD1043:
                result = "Successfully loaded a JPG file.";
                break;
            case 0xD104F:
                result = "Drop this frame.";
                break;
            case 0xD105F:
                result = "The specified stream has already been rendered.";
                break;
            case 0xD1060:
                result = "The specified type partially matches this pin type.";
                break;
            case 0xD1061:
                result = "The specified type fully matches this pin type.";
                break;
            case 0xD1066:
                result = "The timestamp is late compared to the current render position. Advise dropping this frame.";
                break;
            case 0xD1067:
                result = "The timestamp is severely late compared to the current render position. Advise dropping everything up to the next key frame.";
                break;
            case 0xD10DB:
                result = "No burn rights. You will be prompted to buy burn rights when you try to burn this file to an audio CD.";
                break;
            case 0xD10FE:
                result = "Failed to clear playlist because it was aborted by user.";
                break;
            case 0xD10FF:
                result = "Failed to remove item in the playlist since it was aborted by user.";
                break;
            case 0xD1102:
                result = "Playlist is being generated asynchronously.";
                break;
            case 0xD1103:
                result = "Validation of the media is pending.";
                break;
            case 0xD1104:
                result = "Encountered more than one Repeat block during ASX processing.";
                break;
            case 0xD1105:
                result = "Current state of WMP disallows calling this method or property.";
                break;
            case 0xD1106:
                result = "Name for the playlist has been auto generated.";
                break;
            case 0xD1107:
                result = "The imported playlist does not contain all items from the original.";
                break;
            case 0xD1108:
                result = "The M3U playlist has been ignored because it only contains one item.";
                break;
            case 0xD1109:
                result = "The open for the child playlist associated with this media is pending.";
                break;
            case 0xD110A:
                result = "More nodes support the interface requested, but the array for returning them is full.";
                break;
            case 0xD1135:
                result = "Backup or Restore successful!.";
                break;
            case 0xD1136:
                result = "Transfer complete with limitations.";
                break;
            case 0xD1144:
                result = "Request to the effects control to change transparency status to transparent.";
                break;
            case 0xD1145:
                result = "Request to the effects control to change transparency status to opaque.";
                break;
            case 0xD114E:
                result = "The requested application pane is performing an operation and will not be released.";
                break;
            case 0xD1359:
                result = "The file is only available for purchase when you buy the entire album.";
                break;
            case 0xD135E:
                result = "There were problems completing the requested navigation. There are identifiers missing in the catalog.";
                break;
            case 0xD1361:
                result = "Track already downloaded.";
                break;
            case 0xD1519:
                result = "The publishing point successfully started, but one or more of the requested data writer plug-ins failed.";
                break;
            case 0xD2726:
                result = "Status message: The license was acquired.";
                break;
            case 0xD2727:
                result = "Status message: The security upgrade has been completed.";
                break;
            case 0xD2746:
                result = "Status message: License monitoring has been canceled.";
                break;
            case 0xD2747:
                result = "Status message: License acquisition has been canceled.";
                break;
            case 0xD276E:
                result = "The track is burnable and had no playlist burn limit.";
                break;
            case 0xD276F:
                result = "The track is burnable but has a playlist burn limit.";
                break;
            case 0xD27DE:
                result = "A security upgrade is required to perform the operation on this media file.";
                break;
            case 0xD2AF8:
                result = "Installation was successful; however, some file cleanup is not complete. For best results, restart your computer.";
                break;
            case 0xD2AF9:
                result = "Installation was successful; however, some file cleanup is not complete. To continue, you must restart your computer.";
                break;
            case 0xD2F09:
                result = "EOS hit during rewinding.";
                break;
            case 0xD2F0D:
                result = "Internal.";
                break;
            case 0x1F0001:
                result = "The IO was completed by a filter.";
                break;
            case 0x262307:
                result = "No mode is pinned on the specified VidPN source or target.";
                break;
            case 0x26231E:
                result = "Specified mode set does not specify preference for one of its modes.";
                break;
            case 0x26234B:
                result = "Specified data set (for example, mode set, frequency range set, descriptor set, and topology) is empty.";
                break;
            case 0x26234C:
                result = "Specified data set (for example, mode set, frequency range set, descriptor set, and topology) does not contain any more elements.";
                break;
            case 0x262351:
                result = "Specified content transformation is not pinned on the specified VidPN present path.";
                break;
            case 0x300100:
                result = "Property value will be ignored.";
                break;
            case 0x340001:
                result = "The request will be completed later by a Network Driver Interface Specification (NDIS) status indication.";
                break;
            case 0xDEAD100:
                result = "The VolumeSequenceNumber of a MOVE_NOTIFICATION request is incorrect.";
                break;
            case 0xDEAD102:
                result = "The VolumeID in a request was not found in the server's ServerVolumeTable.";
                break;
            case 0xDEAD103:
                result = "A notification was sent to the LnkSvrMessage method, but the RequestMachine for the request was not the VolumeOwner for a VolumeID in the request.";
                break;
            case 0xDEAD107:
                result = "The server received a MOVE_NOTIFICATION request, but the FileTable size limit has already been reached.";
                break;
            case 0x400D004F:
                result = "The Title Server %1 is running.";
                break;
            case 0x400D0051:
                result = "Content Server %1 (%2) is starting.";
                break;
            case 0x400D0052:
                result = "Content Server %1 (%2) is running.";
                break;
            case 0x400D0054:
                result = "Disk %1 ( %2 ) on Content Server %3, is running.";
                break;
            case 0x400D0056:
                result = "Started rebuilding disk %1 ( %2 ) on Content Server %3.";
                break;
            case 0x400D0057:
                result = "Finished rebuilding disk %1 ( %2 ) on Content Server %3.";
                break;
            case 0x400D0058:
                result = "Aborted rebuilding disk %1 ( %2 ) on Content Server %3.";
                break;
            case 0x400D0059:
                result = "A NetShow administrator at network location %1 set the data stream limit to %2 streams.";
                break;
            case 0x400D005A:
                result = "A NetShow administrator at network location %1 started disk %2.";
                break;
            case 0x400D005B:
                result = "A NetShow administrator at network location %1 stopped disk %2.";
                break;
            case 0x400D005C:
                result = "A NetShow administrator at network location %1 stopped Content Server %2.";
                break;
            case 0x400D005D:
                result = "A NetShow administrator at network location %1 aborted user session %2 from the system.";
                break;
            case 0x400D005E:
                result = "A NetShow administrator at network location %1 aborted obsolete connection %2 from the system.";
                break;
            case 0x400D005F:
                result = "A NetShow administrator at network location %1 started rebuilding disk %2.";
                break;
            case 0x400D0069:
                result = "Event initialization failed, there will be no MCM events.";
                break;
            case 0x400D006E:
                result = "The logging operation failed.";
                break;
            case 0x400D0070:
                result = "A NetShow administrator at network location %1 set the maximum bandwidth limit to %2 bps.";
                break;
            case 0x400D0191:
                result = "Content Server %1 (%2) has established its link to Content Server %3.";
                break;
            case 0x400D0193:
                result = "Restripe operation has started.";
                break;
            case 0x400D0194:
                result = "Restripe operation has completed.";
                break;
            case 0x400D0196:
                result = "Content disk %1 (%2) on Content Server %3 has been restriped out.";
                break;
            case 0x400D0197:
                result = "Content server %1 (%2) has been restriped out.";
                break;
            case 0x400D0198:
                result = "Disk %1 ( %2 ) on Content Server %3, has been offlined.";
                break;
            case 0x400D14BE:
                result = "The playlist change occurred while receding.";
                break;
            case 0x400D2EFF:
                result = "The client is reconnected.";
                break;
            case 0x400D2F01:
                result = "Forcing a switch to a pending header on start.";
                break;
            case 0x400D2F03:
                result = "There is already an existing packetizer plugin for the stream.";
                break;
            case 0x400D2F04:
                result = "The proxy setting is manual.";
                break;
            case 0x40262009:
                result = "The kernel driver detected a version mismatch between it and the user mode driver.";
                break;
            case 0x4026242F:
                result = "Child device presence was not reliably detected.";
                break;
            case 0x40262437:
                result = "Starting the lead-link adapter has been deferred temporarily.";
                break;
            case 0x40262439:
                result = "The display adapter is being polled for children too frequently at the same polling level.";
                break;
            case 0x4026243A:
                result = "Starting the adapter has been deferred temporarily.";
                break;
            case 0x8000000A:
                result = "The data necessary to complete this operation is not yet available.";
                break;
            case 0x80004001:
                result = "Not implemented.";
                break;
            case 0x80004002:
                result = "No such interface supported.";
                break;
            case 0x80004003:
                result = "Invalid pointer.";
                break;
            case 0x80004004:
                result = "Operation aborted.";
                break;
            case 0x80004005:
                result = "Unspecified error.";
                break;
            case 0x80004006:
                result = "Thread local storage failure.";
                break;
            case 0x80004007:
                result = "Get shared memory allocator failure.";
                break;
            case 0x80004008:
                result = "Get memory allocator failure.";
                break;
            case 0x80004009:
                result = "Unable to initialize class cache.";
                break;
            case 0x8000400A:
                result = "Unable to initialize remote procedure call (RPC) services.";
                break;
            case 0x8000400B:
                result = "Cannot set thread local storage channel control.";
                break;
            case 0x8000400C:
                result = "Could not allocate thread local storage channel control.";
                break;
            case 0x8000400D:
                result = "The user-supplied memory allocator is unacceptable.";
                break;
            case 0x8000400E:
                result = "The OLE service mutex already exists.";
                break;
            case 0x8000400F:
                result = "The OLE service file mapping already exists.";
                break;
            case 0x80004010:
                result = "Unable to map view of file for OLE service.";
                break;
            case 0x80004011:
                result = "Failure attempting to launch OLE service.";
                break;
            case 0x80004012:
                result = "There was an attempt to call CoInitialize a second time while single-threaded.";
                break;
            case 0x80004013:
                result = "A Remote activation was necessary but was not allowed.";
                break;
            case 0x80004014:
                result = "A Remote activation was necessary, but the server name provided was invalid.";
                break;
            case 0x80004015:
                result = "The class is configured to run as a security ID different from the caller.";
                break;
            case 0x80004016:
                result = "Use of OLE1 services requiring Dynamic Data Exchange (DDE) Windows is disabled.";
                break;
            case 0x80004017:
                result = "A RunAs specification must be <domain name>\\<user name> or simply <user name>.";
                break;
            case 0x80004018:
                result = "The server process could not be started. The path name might be incorrect.";
                break;
            case 0x80004019:
                result = "The server process could not be started as the configured identity. The path name might be incorrect or unavailable.";
                break;
            case 0x8000401A:
                result = "The server process could not be started because the configured identity is incorrect. Check the user name and password.";
                break;
            case 0x8000401B:
                result = "The client is not allowed to launch this server.";
                break;
            case 0x8000401C:
                result = "The service providing this server could not be started.";
                break;
            case 0x8000401D:
                result = "This computer was unable to communicate with the computer providing the server.";
                break;
            case 0x8000401E:
                result = "The server did not respond after being launched.";
                break;
            case 0x8000401F:
                result = "The registration information for this server is inconsistent or incomplete.";
                break;
            case 0x80004020:
                result = "The registration information for this interface is inconsistent or incomplete.";
                break;
            case 0x80004021:
                result = "The operation attempted is not supported.";
                break;
            case 0x80004022:
                result = "A DLL must be loaded.";
                break;
            case 0x80004023:
                result = "A Microsoft Software Installer error was encountered.";
                break;
            case 0x80004024:
                result = "The specified activation could not occur in the client context as specified.";
                break;
            case 0x80004025:
                result = "Activations on the server are paused.";
                break;
            case 0x80004026:
                result = "Activations on the server are not paused.";
                break;
            case 0x80004027:
                result = "The component or application containing the component has been disabled.";
                break;
            case 0x80004028:
                result = "The common language runtime is not available.";
                break;
            case 0x80004029:
                result = "The thread-pool rejected the submitted asynchronous work.";
                break;
            case 0x8000402A:
                result = "The server started, but it did not finish initializing in a timely fashion.";
                break;
            case 0x8000402B:
                result = "Unable to complete the call because there is no COM+ security context inside IObjectControl.Activate.";
                break;
            case 0x80004030:
                result = "The provided tracker configuration is invalid.";
                break;
            case 0x80004031:
                result = "The provided thread pool configuration is invalid.";
                break;
            case 0x80004032:
                result = "The provided side-by-side configuration is invalid.";
                break;
            case 0x80004033:
                result = "The server principal name (SPN) obtained during security negotiation is malformed.";
                break;
            case 0x8000FFFF:
                result = "Catastrophic failure.";
                break;
            case 0x80010001:
                result = "Call was rejected by callee.";
                break;
            case 0x80010002:
                result = "Call was canceled by the message filter.";
                break;
            case 0x80010003:
                result = "The caller is dispatching an intertask SendMessage call and cannot call out via PostMessage.";
                break;
            case 0x80010004:
                result = "The caller is dispatching an asynchronous call and cannot make an outgoing call on behalf of this call.";
                break;
            case 0x80010005:
                result = "It is illegal to call out while inside message filter.";
                break;
            case 0x80010006:
                result = "The connection terminated or is in a bogus state and can no longer be used. Other connections are still valid.";
                break;
            case 0x80010007:
                result = "The callee (the server, not the server application) is not available and disappeared; all connections are invalid. The call might have executed.";
                break;
            case 0x80010008:
                result = "The caller (client) disappeared while the callee (server) was processing a call.";
                break;
            case 0x80010009:
                result = "The data packet with the marshaled parameter data is incorrect.";
                break;
            case 0x8001000A:
                result = "The call was not transmitted properly; the message queue was full and was not emptied after yielding.";
                break;
            case 0x8001000B:
                result = "The client RPC caller cannot marshal the parameter data due to errors (such as low memory).";
                break;
            case 0x8001000C:
                result = "The client RPC caller cannot unmarshal the return data due to errors (such as low memory).";
                break;
            case 0x8001000D:
                result = "The server RPC callee cannot marshal the return data due to errors (such as low memory).";
                break;
            case 0x8001000E:
                result = "The server RPC callee cannot unmarshal the parameter data due to errors (such as low memory).";
                break;
            case 0x8001000F:
                result = "Received data is invalid. The data might be server or client data.";
                break;
            case 0x80010010:
                result = "A particular parameter is invalid and cannot be (un)marshaled.";
                break;
            case 0x80010011:
                result = "There is no second outgoing call on same channel in DDE conversation.";
                break;
            case 0x80010012:
                result = "The callee (the server, not the server application) is not available and disappeared; all connections are invalid. The call did not execute.";
                break;
            case 0x80010100:
                result = "System call failed.";
                break;
            case 0x80010101:
                result = "Could not allocate some required resource (such as memory or events)";
                break;
            case 0x80010102:
                result = "Attempted to make calls on more than one thread in single-threaded mode.";
                break;
            case 0x80010103:
                result = "The requested interface is not registered on the server object.";
                break;
            case 0x80010104:
                result = "RPC could not call the server or could not return the results of calling the server.";
                break;
            case 0x80010105:
                result = "The server threw an exception.";
                break;
            case 0x80010106:
                result = "Cannot change thread mode after it is set.";
                break;
            case 0x80010107:
                result = "The method called does not exist on the server.";
                break;
            case 0x80010108:
                result = "The object invoked has disconnected from its clients.";
                break;
            case 0x80010109:
                result = "The object invoked chose not to process the call now. Try again later.";
                break;
            case 0x8001010A:
                result = "The message filter indicated that the application is busy.";
                break;
            case 0x8001010B:
                result = "The message filter rejected the call.";
                break;
            case 0x8001010C:
                result = "A call control interface was called with invalid data.";
                break;
            case 0x8001010D:
                result = "An outgoing call cannot be made because the application is dispatching an input-synchronous call.";
                break;
            case 0x8001010E:
                result = "The application called an interface that was marshaled for a different thread.";
                break;
            case 0x8001010F:
                result = "CoInitialize has not been called on the current thread.";
                break;
            case 0x80010110:
                result = "The version of OLE on the client and server machines does not match.";
                break;
            case 0x80010111:
                result = "OLE received a packet with an invalid header.";
                break;
            case 0x80010112:
                result = "OLE received a packet with an invalid extension.";
                break;
            case 0x80010113:
                result = "The requested object or interface does not exist.";
                break;
            case 0x80010114:
                result = "The requested object does not exist.";
                break;
            case 0x80010115:
                result = "OLE has sent a request and is waiting for a reply.";
                break;
            case 0x80010116:
                result = "OLE is waiting before retrying a request.";
                break;
            case 0x80010117:
                result = "Call context cannot be accessed after call completed.";
                break;
            case 0x80010118:
                result = "Impersonate on unsecure calls is not supported.";
                break;
            case 0x80010119:
                result = "Security must be initialized before any interfaces are marshaled or unmarshaled. It cannot be changed after initialized.";
                break;
            case 0x8001011A:
                result = "No security packages are installed on this machine, the user is not logged on, or there are no compatible security packages between the client and server.";
                break;
            case 0x8001011B:
                result = "Access is denied.";
                break;
            case 0x8001011C:
                result = "Remote calls are not allowed for this process.";
                break;
            case 0x8001011D:
                result = "The marshaled interface data packet (OBJREF) has an invalid or unknown format.";
                break;
            case 0x8001011E:
                result = "No context is associated with this call. This happens for some custom marshaled calls and on the client side of the call.";
                break;
            case 0x8001011F:
                result = "This operation returned because the time-out period expired.";
                break;
            case 0x80010120:
                result = "There are no synchronize objects to wait on.";
                break;
            case 0x80010121:
                result = "Full subject issuer chain Secure Sockets Layer (SSL) principal name expected from the server.";
                break;
            case 0x80010122:
                result = "Principal name is not a valid Microsoft standard (msstd) name.";
                break;
            case 0x80010123:
                result = "Unable to impersonate DCOM client.";
                break;
            case 0x80010124:
                result = "Unable to obtain server's security context.";
                break;
            case 0x80010125:
                result = "Unable to open the access token of the current thread.";
                break;
            case 0x80010126:
                result = "Unable to obtain user information from an access token.";
                break;
            case 0x80010127:
                result = "The client who called IAccessControl::IsAccessPermitted was not the trustee provided to the method.";
                break;
            case 0x80010128:
                result = "Unable to obtain the client's security blanket.";
                break;
            case 0x80010129:
                result = "Unable to set a discretionary access control list (ACL) into a security descriptor.";
                break;
            case 0x8001012A:
                result = "The system function AccessCheck returned false.";
                break;
            case 0x8001012B:
                result = "Either NetAccessDel or NetAccessAdd returned an error code.";
                break;
            case 0x8001012C:
                result = "One of the trustee strings provided by the user did not conform to the <Domain>\\<Name> syntax and it was not the *\" string\".";
                break;
            case 0x8001012D:
                result = "One of the security identifiers provided by the user was invalid.";
                break;
            case 0x8001012E:
                result = "Unable to convert a wide character trustee string to a multiple-byte trustee string.";
                break;
            case 0x8001012F:
                result = "Unable to find a security identifier that corresponds to a trustee string provided by the user.";
                break;
            case 0x80010130:
                result = "The system function LookupAccountSID failed.";
                break;
            case 0x80010131:
                result = "Unable to find a trustee name that corresponds to a security identifier provided by the user.";
                break;
            case 0x80010132:
                result = "The system function LookupAccountName failed.";
                break;
            case 0x80010133:
                result = "Unable to set or reset a serialization handle.";
                break;
            case 0x80010134:
                result = "Unable to obtain the Windows directory.";
                break;
            case 0x80010135:
                result = "Path too long.";
                break;
            case 0x80010136:
                result = "Unable to generate a UUID.";
                break;
            case 0x80010137:
                result = "Unable to create file.";
                break;
            case 0x80010138:
                result = "Unable to close a serialization handle or a file handle.";
                break;
            case 0x80010139:
                result = "The number of access control entries (ACEs) in an ACL exceeds the system limit.";
                break;
            case 0x8001013A:
                result = "Not all the DENY_ACCESS ACEs are arranged in front of the GRANT_ACCESS ACEs in the stream.";
                break;
            case 0x8001013B:
                result = "The version of ACL format in the stream is not supported by this implementation of IAccessControl.";
                break;
            case 0x8001013C:
                result = "Unable to open the access token of the server process.";
                break;
            case 0x8001013D:
                result = "Unable to decode the ACL in the stream provided by the user.";
                break;
            case 0x8001013F:
                result = "The COM IAccessControl object is not initialized.";
                break;
            case 0x80010140:
                result = "Call Cancellation is disabled.";
                break;
            case 0x8001FFFF:
                result = "An internal error occurred.";
                break;
            case 0x80020001:
                result = "Unknown interface.";
                break;
            case 0x80020003:
                result = "Member not found.";
                break;
            case 0x80020004:
                result = "Parameter not found.";
                break;
            case 0x80020005:
                result = "Type mismatch.";
                break;
            case 0x80020006:
                result = "Unknown name.";
                break;
            case 0x80020007:
                result = "No named arguments.";
                break;
            case 0x80020008:
                result = "Bad variable type.";
                break;
            case 0x80020009:
                result = "Exception occurred.";
                break;
            case 0x8002000A:
                result = "Out of present range.";
                break;
            case 0x8002000B:
                result = "Invalid index.";
                break;
            case 0x8002000C:
                result = "Unknown language.";
                break;
            case 0x8002000D:
                result = "Memory is locked.";
                break;
            case 0x8002000E:
                result = "Invalid number of parameters.";
                break;
            case 0x8002000F:
                result = "Parameter not optional.";
                break;
            case 0x80020010:
                result = "Invalid callee.";
                break;
            case 0x80020011:
                result = "Does not support a collection.";
                break;
            case 0x80020012:
                result = "Division by zero.";
                break;
            case 0x80020013:
                result = "Buffer too small.";
                break;
            case 0x80028016:
                result = "Buffer too small.";
                break;
            case 0x80028017:
                result = "Field name not defined in the record.";
                break;
            case 0x80028018:
                result = "Old format or invalid type library.";
                break;
            case 0x80028019:
                result = "Old format or invalid type library.";
                break;
            case 0x8002801C:
                result = "Error accessing the OLE registry.";
                break;
            case 0x8002801D:
                result = "Library not registered.";
                break;
            case 0x80028027:
                result = "Bound to unknown type.";
                break;
            case 0x80028028:
                result = "Qualified name disallowed.";
                break;
            case 0x80028029:
                result = "Invalid forward reference, or reference to uncompiled type.";
                break;
            case 0x8002802A:
                result = "Type mismatch.";
                break;
            case 0x8002802B:
                result = "Element not found.";
                break;
            case 0x8002802C:
                result = "Ambiguous name.";
                break;
            case 0x8002802D:
                result = "Name already exists in the library.";
                break;
            case 0x8002802E:
                result = "Unknown language code identifier (LCID).";
                break;
            case 0x8002802F:
                result = "Function not defined in specified DLL.";
                break;
            case 0x800288BD:
                result = "Wrong module kind for the operation.";
                break;
            case 0x800288C5:
                result = "Size cannot exceed 64 KB.";
                break;
            case 0x800288C6:
                result = "Duplicate ID in inheritance hierarchy.";
                break;
            case 0x800288CF:
                result = "Incorrect inheritance depth in standard OLE hmember.";
                break;
            case 0x80028CA0:
                result = "Type mismatch.";
                break;
            case 0x80028CA1:
                result = "Invalid number of arguments.";
                break;
            case 0x80028CA2:
                result = "I/O error.";
                break;
            case 0x80028CA3:
                result = "Error creating unique .tmp file.";
                break;
            case 0x80029C4A:
                result = "Error loading type library or DLL.";
                break;
            case 0x80029C83:
                result = "Inconsistent property functions.";
                break;
            case 0x80029C84:
                result = "Circular dependency between types and modules.";
                break;
            case 0x80030001:
                result = "Unable to perform requested operation.";
                break;
            case 0x80030002:
                result = "%1 could not be found.";
                break;
            case 0x80030003:
                result = "The path %1 could not be found.";
                break;
            case 0x80030004:
                result = "There are insufficient resources to open another file.";
                break;
            case 0x80030005:
                result = "Access denied.";
                break;
            case 0x80030006:
                result = "Attempted an operation on an invalid object.";
                break;
            case 0x80030008:
                result = "There is insufficient memory available to complete operation.";
                break;
            case 0x80030009:
                result = "Invalid pointer error.";
                break;
            case 0x80030012:
                result = "There are no more entries to return.";
                break;
            case 0x80030013:
                result = "Disk is write-protected.";
                break;
            case 0x80030019:
                result = "An error occurred during a seek operation.";
                break;
            case 0x8003001D:
                result = "A disk error occurred during a write operation.";
                break;
            case 0x8003001E:
                result = "A disk error occurred during a read operation.";
                break;
            case 0x80030020:
                result = "A share violation has occurred.";
                break;
            case 0x80030021:
                result = "A lock violation has occurred.";
                break;
            case 0x80030050:
                result = "%1 already exists.";
                break;
            case 0x80030057:
                result = "Invalid parameter error.";
                break;
            case 0x80030070:
                result = "There is insufficient disk space to complete operation.";
                break;
            case 0x800300F0:
                result = "Illegal write of non-simple property to simple property set.";
                break;
            case 0x800300FA:
                result = "An application programming interface (API) call exited abnormally.";
                break;
            case 0x800300FB:
                result = "The file %1 is not a valid compound file.";
                break;
            case 0x800300FC:
                result = "The name %1 is not valid.";
                break;
            case 0x800300FD:
                result = "An unexpected error occurred.";
                break;
            case 0x800300FE:
                result = "That function is not implemented.";
                break;
            case 0x800300FF:
                result = "Invalid flag error.";
                break;
            case 0x80030100:
                result = "Attempted to use an object that is busy.";
                break;
            case 0x80030101:
                result = "The storage has been changed since the last commit.";
                break;
            case 0x80030102:
                result = "Attempted to use an object that has ceased to exist.";
                break;
            case 0x80030103:
                result = "Cannot save.";
                break;
            case 0x80030104:
                result = "The compound file %1 was produced with an incompatible version of storage.";
                break;
            case 0x80030105:
                result = "The compound file %1 was produced with a newer version of storage.";
                break;
            case 0x80030106:
                result = "Share.exe or equivalent is required for operation.";
                break;
            case 0x80030107:
                result = "Illegal operation called on non-file based storage.";
                break;
            case 0x80030108:
                result = "Illegal operation called on object with extant marshalings.";
                break;
            case 0x80030109:
                result = "The docfile has been corrupted.";
                break;
            case 0x80030110:
                result = "OLE32.DLL has been loaded at the wrong address.";
                break;
            case 0x80030111:
                result = "The compound file is too large for the current implementation.";
                break;
            case 0x80030112:
                result = "The compound file was not created with the STGM_SIMPLE flag.";
                break;
            case 0x80030201:
                result = "The file download was aborted abnormally. The file is incomplete.";
                break;
            case 0x80030202:
                result = "The file download has been terminated.";
                break;
            case 0x80030305:
                result = "Generic Copy Protection Error.";
                break;
            case 0x80030306:
                result = "Copy Protection Error—DVD CSS Authentication failed.";
                break;
            case 0x80030307:
                result = "Copy Protection Error—The given sector does not have a valid CSS key.";
                break;
            case 0x80030308:
                result = "Copy Protection Error—DVD session key not established.";
                break;
            case 0x80030309:
                result = "Copy Protection Error—The read failed because the sector is encrypted.";
                break;
            case 0x8003030A:
                result = "Copy Protection Error—The current DVD's region does not correspond to the region setting of the drive.";
                break;
            case 0x8003030B:
                result = "Copy Protection Error—The drive's region setting might be permanent or the number of user resets has been exhausted.";
                break;
            case 0x80040000:
                result = "Invalid OLEVERB structure.";
                break;
            case 0x80040001:
                result = "Invalid advise flags.";
                break;
            case 0x80040002:
                result = "Cannot enumerate any more because the associated data is missing.";
                break;
            case 0x80040003:
                result = "This implementation does not take advises.";
                break;
            case 0x80040004:
                result = "There is no connection for this connection ID.";
                break;
            case 0x80040005:
                result = "Need to run the object to perform this operation.";
                break;
            case 0x80040006:
                result = "There is no cache to operate on.";
                break;
            case 0x80040007:
                result = "Uninitialized object.";
                break;
            case 0x80040008:
                result = "Linked object's source class has changed.";
                break;
            case 0x80040009:
                result = "Not able to get the moniker of the object.";
                break;
            case 0x8004000A:
                result = "Not able to bind to the source.";
                break;
            case 0x8004000B:
                result = "Object is static; operation not allowed.";
                break;
            case 0x8004000C:
                result = "User canceled out of the Save dialog box.";
                break;
            case 0x8004000D:
                result = "Invalid rectangle.";
                break;
            case 0x8004000E:
                result = "compobj.dll is too old for the ole2.dll initialized.";
                break;
            case 0x8004000F:
                result = "Invalid window handle.";
                break;
            case 0x80040010:
                result = "Object is not in any of the inplace active states.";
                break;
            case 0x80040011:
                result = "Not able to convert object.";
                break;
            case 0x80040012:
                result = "Not able to perform the operation because object is not given storage yet.";
                break;
            case 0x80040064:
                result = "Invalid FORMATETC structure.";
                break;
            case 0x80040065:
                result = "Invalid DVTARGETDEVICE structure.";
                break;
            case 0x80040066:
                result = "Invalid STDGMEDIUM structure.";
                break;
            case 0x80040067:
                result = "Invalid STATDATA structure.";
                break;
            case 0x80040068:
                result = "Invalid lindex.";
                break;
            case 0x80040069:
                result = "Invalid TYMED structure.";
                break;
            case 0x8004006A:
                result = "Invalid clipboard format.";
                break;
            case 0x8004006B:
                result = "Invalid aspects.";
                break;
            case 0x8004006C:
                result = "The tdSize parameter of the DVTARGETDEVICE structure is invalid.";
                break;
            case 0x8004006D:
                result = "Object does not support IViewObject interface.";
                break;
            case 0x80040100:
                result = "Trying to revoke a drop target that has not been registered.";
                break;
            case 0x80040101:
                result = "This window has already been registered as a drop target.";
                break;
            case 0x80040102:
                result = "Invalid window handle.";
                break;
            case 0x80040110:
                result = "Class does not support aggregation (or class object is remote).";
                break;
            case 0x80040111:
                result = "ClassFactory cannot supply requested class.";
                break;
            case 0x80040112:
                result = "Class is not licensed for use.";
                break;
            case 0x80040140:
                result = "Error drawing view.";
                break;
            case 0x80040150:
                result = "Could not read key from registry.";
                break;
            case 0x80040151:
                result = "Could not write key to registry.";
                break;
            case 0x80040152:
                result = "Could not find the key in the registry.";
                break;
            case 0x80040153:
                result = "Invalid value for registry.";
                break;
            case 0x80040154:
                result = "Class not registered.";
                break;
            case 0x80040155:
                result = "Interface not registered.";
                break;
            case 0x80040156:
                result = "Threading model entry is not valid.";
                break;
            case 0x80040160:
                result = "CATID does not exist.";
                break;
            case 0x80040161:
                result = "Description not found.";
                break;
            case 0x80040164:
                result = "No package in the software installation data in Active Directory meets this criteria.";
                break;
            case 0x80040165:
                result = "Deleting this will break the referential integrity of the software installation data in Active Directory.";
                break;
            case 0x80040166:
                result = "The CLSID was not found in the software installation data in Active Directory.";
                break;
            case 0x80040167:
                result = "The software installation data in Active Directory is corrupt.";
                break;
            case 0x80040168:
                result = "There is no software installation data in Active Directory.";
                break;
            case 0x80040169:
                result = "There is no software installation data object in Active Directory.";
                break;
            case 0x8004016A:
                result = "The software installation data object in Active Directory already exists.";
                break;
            case 0x8004016B:
                result = "The path to the software installation data in Active Directory is not correct.";
                break;
            case 0x8004016C:
                result = "A network error interrupted the operation.";
                break;
            case 0x8004016D:
                result = "The size of this object exceeds the maximum size set by the administrator.";
                break;
            case 0x8004016E:
                result = "The schema for the software installation data in Active Directory does not match the required schema.";
                break;
            case 0x8004016F:
                result = "An error occurred in the software installation data in Active Directory.";
                break;
            case 0x80040170:
                result = "Cache not updated.";
                break;
            case 0x80040180:
                result = "No verbs for OLE object.";
                break;
            case 0x80040181:
                result = "Invalid verb for OLE object.";
                break;
            case 0x800401A0:
                result = "Undo is not available.";
                break;
            case 0x800401A1:
                result = "Space for tools is not available.";
                break;
            case 0x800401C0:
                result = "OLESTREAM Get method failed.";
                break;
            case 0x800401C1:
                result = "OLESTREAM Put method failed.";
                break;
            case 0x800401C2:
                result = "Contents of the OLESTREAM not in correct format.";
                break;
            case 0x800401C3:
                result = "There was an error in a Windows GDI call while converting the bitmap to a device-independent bitmap (DIB).";
                break;
            case 0x800401C4:
                result = "Contents of the IStorage not in correct format.";
                break;
            case 0x800401C5:
                result = "Contents of IStorage is missing one of the standard streams.";
                break;
            case 0x800401C6:
                result = "There was an error in a Windows Graphics Device Interface (GDI) call while converting the DIB to a bitmap.";
                break;
            case 0x800401D0:
                result = "OpenClipboard failed.";
                break;
            case 0x800401D1:
                result = "EmptyClipboard failed.";
                break;
            case 0x800401D2:
                result = "SetClipboard failed.";
                break;
            case 0x800401D3:
                result = "Data on clipboard is invalid.";
                break;
            case 0x800401D4:
                result = "CloseClipboard failed.";
                break;
            case 0x800401E0:
                result = "Moniker needs to be connected manually.";
                break;
            case 0x800401E1:
                result = "Operation exceeded deadline.";
                break;
            case 0x800401E2:
                result = "Moniker needs to be generic.";
                break;
            case 0x800401E3:
                result = "Operation unavailable.";
                break;
            case 0x800401E4:
                result = "Invalid syntax.";
                break;
            case 0x800401E5:
                result = "No object for moniker.";
                break;
            case 0x800401E6:
                result = "Bad extension for file.";
                break;
            case 0x800401E7:
                result = "Intermediate operation failed.";
                break;
            case 0x800401E8:
                result = "Moniker is not bindable.";
                break;
            case 0x800401E9:
                result = "Moniker is not bound.";
                break;
            case 0x800401EA:
                result = "Moniker cannot open file.";
                break;
            case 0x800401EB:
                result = "User input required for operation to succeed.";
                break;
            case 0x800401EC:
                result = "Moniker class has no inverse.";
                break;
            case 0x800401ED:
                result = "Moniker does not refer to storage.";
                break;
            case 0x800401EE:
                result = "No common prefix.";
                break;
            case 0x800401EF:
                result = "Moniker could not be enumerated.";
                break;
            case 0x800401F0:
                result = "CoInitialize has not been called.";
                break;
            case 0x800401F1:
                result = "CoInitialize has already been called.";
                break;
            case 0x800401F2:
                result = "Class of object cannot be determined.";
                break;
            case 0x800401F3:
                result = "Invalid class string.";
                break;
            case 0x800401F4:
                result = "Invalid interface string.";
                break;
            case 0x800401F5:
                result = "Application not found.";
                break;
            case 0x800401F6:
                result = "Application cannot be run more than once.";
                break;
            case 0x800401F7:
                result = "Some error in application.";
                break;
            case 0x800401F8:
                result = "DLL for class not found.";
                break;
            case 0x800401F9:
                result = "Error in the DLL.";
                break;
            case 0x800401FA:
                result = "Wrong operating system or operating system version for application.";
                break;
            case 0x800401FB:
                result = "Object is not registered.";
                break;
            case 0x800401FC:
                result = "Object is already registered.";
                break;
            case 0x800401FD:
                result = "Object is not connected to server.";
                break;
            case 0x800401FE:
                result = "Application was launched, but it did not register a class factory.";
                break;
            case 0x800401FF:
                result = "Object has been released.";
                break;
            case 0x80040201:
                result = "An event was unable to invoke any of the subscribers.";
                break;
            case 0x80040203:
                result = "A syntax error occurred trying to evaluate a query string.";
                break;
            case 0x80040204:
                result = "An invalid field name was used in a query string.";
                break;
            case 0x80040205:
                result = "An unexpected exception was raised.";
                break;
            case 0x80040206:
                result = "An unexpected internal error was detected.";
                break;
            case 0x80040207:
                result = "The owner security identifier (SID) on a per-user subscription does not exist.";
                break;
            case 0x80040208:
                result = "A user-supplied component or subscriber raised an exception.";
                break;
            case 0x80040209:
                result = "An interface has too many methods to fire events from.";
                break;
            case 0x8004020A:
                result = "A subscription cannot be stored unless its event class already exists.";
                break;
            case 0x8004020B:
                result = "Not all the objects requested could be removed.";
                break;
            case 0x8004020C:
                result = "COM+ is required for this operation, but it is not installed.";
                break;
            case 0x8004020D:
                result = "Cannot modify or delete an object that was not added using the COM+ Administrative SDK.";
                break;
            case 0x8004020E:
                result = "Cannot modify or delete an object that was added using the COM+ Administrative SDK.";
                break;
            case 0x8004020F:
                result = "The event class for this subscription is in an invalid partition.";
                break;
            case 0x80040210:
                result = "The owner of the PerUser subscription is not logged on to the system specified.";
                break;
            case 0x80041309:
                result = "Trigger not found.";
                break;
            case 0x8004130A:
                result = "One or more of the properties that are needed to run this task have not been set.";
                break;
            case 0x8004130B:
                result = "There is no running instance of the task.";
                break;
            case 0x8004130C:
                result = "The Task Scheduler service is not installed on this computer.";
                break;
            case 0x8004130D:
                result = "The task object could not be opened.";
                break;
            case 0x8004130E:
                result = "The object is either an invalid task object or is not a task object.";
                break;
            case 0x8004130F:
                result = "No account information could be found in the Task Scheduler security database for the task indicated.";
                break;
            case 0x80041310:
                result = "Unable to establish existence of the account specified.";
                break;
            case 0x80041311:
                result = "Corruption was detected in the Task Scheduler security database; the database has been reset.";
                break;
            case 0x80041312:
                result = "Task Scheduler security services are available only on Windows NT operating system.";
                break;
            case 0x80041313:
                result = "The task object version is either unsupported or invalid.";
                break;
            case 0x80041314:
                result = "The task has been configured with an unsupported combination of account settings and run-time options.";
                break;
            case 0x80041315:
                result = "The Task Scheduler service is not running.";
                break;
            case 0x80041316:
                result = "The task XML contains an unexpected node.";
                break;
            case 0x80041317:
                result = "The task XML contains an element or attribute from an unexpected namespace.";
                break;
            case 0x80041318:
                result = "The task XML contains a value that is incorrectly formatted or out of range.";
                break;
            case 0x80041319:
                result = "The task XML is missing a required element or attribute.";
                break;
            case 0x8004131A:
                result = "The task XML is malformed.";
                break;
            case 0x8004131D:
                result = "The task XML contains too many nodes of the same type.";
                break;
            case 0x8004131E:
                result = "The task cannot be started after the trigger's end boundary.";
                break;
            case 0x8004131F:
                result = "An instance of this task is already running.";
                break;
            case 0x80041320:
                result = "The task will not run because the user is not logged on.";
                break;
            case 0x80041321:
                result = "The task image is corrupt or has been tampered with.";
                break;
            case 0x80041322:
                result = "The Task Scheduler service is not available.";
                break;
            case 0x80041323:
                result = "The Task Scheduler service is too busy to handle your request. Try again later.";
                break;
            case 0x80041324:
                result = "The Task Scheduler service attempted to run the task, but the task did not run due to one of the constraints in the task definition.";
                break;
            case 0x8004D000:
                result = "Another single phase resource manager has already been enlisted in this transaction.";
                break;
            case 0x8004D001:
                result = "A retaining commit or abort is not supported.";
                break;
            case 0x8004D002:
                result = "The transaction failed to commit for an unknown reason. The transaction was aborted.";
                break;
            case 0x8004D003:
                result = "Cannot call commit on this transaction object because the calling application did not initiate the transaction.";
                break;
            case 0x8004D004:
                result = "Instead of committing, the resource heuristically aborted.";
                break;
            case 0x8004D005:
                result = "Instead of aborting, the resource heuristically committed.";
                break;
            case 0x8004D006:
                result = "Some of the states of the resource were committed while others were aborted, likely because of heuristic decisions.";
                break;
            case 0x8004D007:
                result = "Some of the states of the resource might have been committed while others were aborted, likely because of heuristic decisions.";
                break;
            case 0x8004D008:
                result = "The requested isolation level is not valid or supported.";
                break;
            case 0x8004D009:
                result = "The transaction manager does not support an asynchronous operation for this method.";
                break;
            case 0x8004D00A:
                result = "Unable to enlist in the transaction.";
                break;
            case 0x8004D00B:
                result = "The requested semantics of retention of isolation across retaining commit and abort boundaries cannot be supported by this transaction implementation, or isoFlags was not equal to 0.";
                break;
            case 0x8004D00C:
                result = "There is no resource presently associated with this enlistment.";
                break;
            case 0x8004D00D:
                result = "The transaction failed to commit due to the failure of optimistic concurrency control in at least one of the resource managers.";
                break;
            case 0x8004D00E:
                result = "The transaction has already been implicitly or explicitly committed or aborted.";
                break;
            case 0x8004D00F:
                result = "An invalid combination of flags was specified.";
                break;
            case 0x8004D010:
                result = "The resource manager ID is not associated with this transaction or the transaction manager.";
                break;
            case 0x8004D011:
                result = "This method was called in the wrong state.";
                break;
            case 0x8004D012:
                result = "The indicated unit of work does not match the unit of work expected by the resource manager.";
                break;
            case 0x8004D013:
                result = "An enlistment in a transaction already exists.";
                break;
            case 0x8004D014:
                result = "An import object for the transaction could not be found.";
                break;
            case 0x8004D015:
                result = "The transaction cookie is invalid.";
                break;
            case 0x8004D016:
                result = "The transaction status is in doubt. A communication failure occurred, or a transaction manager or resource manager has failed.";
                break;
            case 0x8004D017:
                result = "A time-out was specified, but time-outs are not supported.";
                break;
            case 0x8004D018:
                result = "The requested operation is already in progress for the transaction.";
                break;
            case 0x8004D019:
                result = "The transaction has already been aborted.";
                break;
            case 0x8004D01A:
                result = "The Transaction Manager returned a log full error.";
                break;
            case 0x8004D01B:
                result = "The transaction manager is not available.";
                break;
            case 0x8004D01C:
                result = "A connection with the transaction manager was lost.";
                break;
            case 0x8004D01D:
                result = "A request to establish a connection with the transaction manager was denied.";
                break;
            case 0x8004D01E:
                result = "Resource manager reenlistment to determine transaction status timed out.";
                break;
            case 0x8004D01F:
                result = "The transaction manager failed to establish a connection with another Transaction Internet Protocol (TIP) transaction manager.";
                break;
            case 0x8004D020:
                result = "The transaction manager encountered a protocol error with another TIP transaction manager.";
                break;
            case 0x8004D021:
                result = "The transaction manager could not propagate a transaction from another TIP transaction manager.";
                break;
            case 0x8004D022:
                result = "The transaction manager on the destination machine is not available.";
                break;
            case 0x8004D023:
                result = "The transaction manager has disabled its support for TIP.";
                break;
            case 0x8004D024:
                result = "The transaction manager has disabled its support for remote or network transactions.";
                break;
            case 0x8004D025:
                result = "The partner transaction manager has disabled its support for remote or network transactions.";
                break;
            case 0x8004D026:
                result = "The transaction manager has disabled its support for XA transactions.";
                break;
            case 0x8004D027:
                result = "Microsoft Distributed Transaction Coordinator (MSDTC) was unable to read its configuration information.";
                break;
            case 0x8004D028:
                result = "MSDTC was unable to load the DTC proxy DLL.";
                break;
            case 0x8004D029:
                result = "The local transaction has aborted.";
                break;
            case 0x8004D080:
                result = "The specified CRM clerk was not found. It might have completed before it could be held.";
                break;
            case 0x8004D081:
                result = "The specified CRM clerk does not exist.";
                break;
            case 0x8004D082:
                result = "Recovery of the CRM log file is still in progress.";
                break;
            case 0x8004D083:
                result = "The transaction has completed, and the log records have been discarded from the log file. They are no longer available.";
                break;
            case 0x8004D084:
                result = "lsnToRead is outside of the current limits of the log";
                break;
            case 0x8004D085:
                result = "The COM+ Compensating Resource Manager has records it wishes to replay.";
                break;
            case 0x8004D100:
                result = "The request to connect to the specified transaction coordinator was denied.";
                break;
            case 0x8004D101:
                result = "The maximum number of enlistments for the specified transaction has been reached.";
                break;
            case 0x8004D102:
                result = "A resource manager with the same identifier is already registered with the specified transaction coordinator.";
                break;
            case 0x8004D103:
                result = "The prepare request given was not eligible for single-phase optimizations.";
                break;
            case 0x8004D104:
                result = "RecoveryComplete has already been called for the given resource manager.";
                break;
            case 0x8004D105:
                result = "The interface call made was incorrect for the current state of the protocol.";
                break;
            case 0x8004D106:
                result = "The xa_open call failed for the XA resource.";
                break;
            case 0x8004D107:
                result = "The xa_recover call failed for the XA resource.";
                break;
            case 0x8004D108:
                result = "The logical unit of work specified cannot be found.";
                break;
            case 0x8004D109:
                result = "The specified logical unit of work already exists.";
                break;
            case 0x8004D10A:
                result = "Subordinate creation failed. The specified logical unit of work was not connected.";
                break;
            case 0x8004D10B:
                result = "A transaction with the given identifier already exists.";
                break;
            case 0x8004D10C:
                result = "The resource is in use.";
                break;
            case 0x8004D10D:
                result = "The LU Recovery process is down.";
                break;
            case 0x8004D10E:
                result = "The remote session was lost.";
                break;
            case 0x8004D10F:
                result = "The resource is currently recovering.";
                break;
            case 0x8004D110:
                result = "There was a mismatch in driving recovery.";
                break;
            case 0x8004D111:
                result = "An error occurred with the XA resource.";
                break;
            case 0x8004E002:
                result = "The root transaction wanted to commit, but the transaction aborted.";
                break;
            case 0x8004E003:
                result = "The COM+ component on which the method call was made has a transaction that has already aborted or is in the process of aborting.";
                break;
            case 0x8004E004:
                result = "There is no Microsoft Transaction Server (MTS) object context.";
                break;
            case 0x8004E005:
                result = "The component is configured to use synchronization, and this method call would cause a deadlock to occur.";
                break;
            case 0x8004E006:
                result = "The component is configured to use synchronization, and a thread has timed out waiting to enter the context.";
                break;
            case 0x8004E007:
                result = "You made a method call on a COM+ component that has a transaction that has already committed or aborted.";
                break;
            case 0x8004E00C:
                result = "The specified role was not configured for the application.";
                break;
            case 0x8004E00F:
                result = "COM+ was unable to talk to the MSDTC.";
                break;
            case 0x8004E021:
                result = "An unexpected error occurred during COM+ activation.";
                break;
            case 0x8004E022:
                result = "COM+ activation failed. Check the event log for more information.";
                break;
            case 0x8004E023:
                result = "COM+ activation failed due to a catalog or configuration error.";
                break;
            case 0x8004E024:
                result = "COM+ activation failed because the activation could not be completed in the specified amount of time.";
                break;
            case 0x8004E025:
                result = "COM+ activation failed because an initialization function failed. Check the event log for more information.";
                break;
            case 0x8004E026:
                result = "The requested operation requires that just-in-time (JIT) be in the current context, and it is not.";
                break;
            case 0x8004E027:
                result = "The requested operation requires that the current context have a transaction, and it does not.";
                break;
            case 0x8004E028:
                result = "The components threading model has changed after install into a COM+ application. Re-install component.";
                break;
            case 0x8004E029:
                result = "Internet Information Services (IIS) intrinsics not available. Start your work with IIS.";
                break;
            case 0x8004E02A:
                result = "An attempt to write a cookie failed.";
                break;
            case 0x8004E02B:
                result = "An attempt to use a database generated a database-specific error.";
                break;
            case 0x8004E02C:
                result = "The COM+ component you created must use object pooling to work.";
                break;
            case 0x8004E02D:
                result = "The COM+ component you created must use object construction to work correctly.";
                break;
            case 0x8004E02E:
                result = "The COM+ component requires synchronization, and it is not configured for it.";
                break;
            case 0x8004E02F:
                result = "The TxIsolation Level property for the COM+ component being created is stronger than the TxIsolationLevel for the root.";
                break;
            case 0x8004E030:
                result = "The component attempted to make a cross-context call between invocations of EnterTransactionScope and ExitTransactionScope. This is not allowed. Cross-context calls cannot be made while inside a transaction scope.";
                break;
            case 0x8004E031:
                result = "The component made a call to EnterTransactionScope, but did not make a corresponding call to ExitTransactionScope before returning.";
                break;
            case 0x80070005:
                result = "General access denied error.";
                break;
            case 0x8007000E:
                result = "The server does not have enough memory for the new channel.";
                break;
            case 0x80070032:
                result = "The server cannot support a client request for a dynamic virtual channel.";
                break;
            case 0x80070057:
                result = "One or more arguments are invalid.";
                break;
            case 0x80070070:
                result = "There is not enough space on the disk.";
                break;
            case 0x80080001:
                result = "Attempt to create a class object failed.";
                break;
            case 0x80080002:
                result = "OLE service could not bind object.";
                break;
            case 0x80080003:
                result = "RPC communication failed with OLE service.";
                break;
            case 0x80080004:
                result = "Bad path to object.";
                break;
            case 0x80080005:
                result = "Server execution failed.";
                break;
            case 0x80080006:
                result = "OLE service could not communicate with the object server.";
                break;
            case 0x80080007:
                result = "Moniker path could not be normalized.";
                break;
            case 0x80080008:
                result = "Object server is stopping when OLE service contacts it.";
                break;
            case 0x80080009:
                result = "An invalid root block pointer was specified.";
                break;
            case 0x80080010:
                result = "An allocation chain contained an invalid link pointer.";
                break;
            case 0x80080011:
                result = "The requested allocation size was too large.";
                break;
            case 0x80080015:
                result = "The activation requires a display name to be present under the class identifier (CLSID) key.";
                break;
            case 0x80080016:
                result = "The activation requires that the RunAs value for the application is Activate As Activator.";
                break;
            case 0x80080017:
                result = "The class is not configured to support elevated activation.";
                break;
            case 0x80090001:
                result = "Bad UID.";
                break;
            case 0x80090002:
                result = "Bad hash.";
                break;
            case 0x80090003:
                result = "Bad key.";
                break;
            case 0x80090004:
                result = "Bad length.";
                break;
            case 0x80090005:
                result = "Bad data.";
                break;
            case 0x80090006:
                result = "Invalid signature.";
                break;
            case 0x80090007:
                result = "Bad version of provider.";
                break;
            case 0x80090008:
                result = "Invalid algorithm specified.";
                break;
            case 0x80090009:
                result = "Invalid flags specified.";
                break;
            case 0x8009000A:
                result = "Invalid type specified.";
                break;
            case 0x8009000B:
                result = "Key not valid for use in specified state.";
                break;
            case 0x8009000C:
                result = "Hash not valid for use in specified state.";
                break;
            case 0x8009000D:
                result = "Key does not exist.";
                break;
            case 0x8009000E:
                result = "Insufficient memory available for the operation.";
                break;
            case 0x8009000F:
                result = "Object already exists.";
                break;
            case 0x80090010:
                result = "Access denied.";
                break;
            case 0x80090011:
                result = "Object was not found.";
                break;
            case 0x80090012:
                result = "Data already encrypted.";
                break;
            case 0x80090013:
                result = "Invalid provider specified.";
                break;
            case 0x80090014:
                result = "Invalid provider type specified.";
                break;
            case 0x80090015:
                result = "Provider's public key is invalid.";
                break;
            case 0x80090016:
                result = "Key set does not exist.";
                break;
            case 0x80090017:
                result = "Provider type not defined.";
                break;
            case 0x80090018:
                result = "The provider type, as registered, is invalid.";
                break;
            case 0x80090019:
                result = "The key set is not defined.";
                break;
            case 0x8009001A:
                result = "The key set, as registered, is invalid.";
                break;
            case 0x8009001B:
                result = "Provider type does not match registered value.";
                break;
            case 0x8009001C:
                result = "The digital signature file is corrupt.";
                break;
            case 0x8009001D:
                result = "Provider DLL failed to initialize correctly.";
                break;
            case 0x8009001E:
                result = "Provider DLL could not be found.";
                break;
            case 0x8009001F:
                result = "The keyset parameter is invalid.";
                break;
            case 0x80090020:
                result = "An internal error occurred.";
                break;
            case 0x80090021:
                result = "A base error occurred.";
                break;
            case 0x80090022:
                result = "Provider could not perform the action because the context was acquired as silent.";
                break;
            case 0x80090023:
                result = "The security token does not have storage space available for an additional container.";
                break;
            case 0x80090024:
                result = "The profile for the user is a temporary profile.";
                break;
            case 0x80090025:
                result = "The key parameters could not be set because the configuration service provider (CSP) uses fixed parameters.";
                break;
            case 0x80090026:
                result = "The supplied handle is invalid.";
                break;
            case 0x80090027:
                result = "The parameter is incorrect.";
                break;
            case 0x80090028:
                result = "The buffer supplied to a function was too small.";
                break;
            case 0x80090029:
                result = "The requested operation is not supported.";
                break;
            case 0x8009002A:
                result = "No more data is available.";
                break;
            case 0x8009002B:
                result = "The supplied buffers overlap incorrectly.";
                break;
            case 0x8009002C:
                result = "The specified data could not be decrypted.";
                break;
            case 0x8009002D:
                result = "An internal consistency check failed.";
                break;
            case 0x8009002E:
                result = "This operation requires input from the user.";
                break;
            case 0x8009002F:
                result = "The cryptographic provider does not support Hash Message Authentication Code (HMAC).";
                break;
            case 0x80090300:
                result = "Not enough memory is available to complete this request.";
                break;
            case 0x80090301:
                result = "The handle specified is invalid.";
                break;
            case 0x80090302:
                result = "The function requested is not supported.";
                break;
            case 0x80090303:
                result = "The specified target is unknown or unreachable.";
                break;
            case 0x80090304:
                result = "The Local Security Authority (LSA) cannot be contacted.";
                break;
            case 0x80090305:
                result = "The requested security package does not exist.";
                break;
            case 0x80090306:
                result = "The caller is not the owner of the desired credentials.";
                break;
            case 0x80090307:
                result = "The security package failed to initialize and cannot be installed.";
                break;
            case 0x80090308:
                result = "The token supplied to the function is invalid.";
                break;
            case 0x80090309:
                result = "The security package is not able to marshal the logon buffer, so the logon attempt has failed.";
                break;
            case 0x8009030A:
                result = "The per-message quality of protection is not supported by the security package.";
                break;
            case 0x8009030B:
                result = "The security context does not allow impersonation of the client.";
                break;
            case 0x8009030C:
                result = "The logon attempt failed.";
                break;
            case 0x8009030D:
                result = "The credentials supplied to the package were not recognized.";
                break;
            case 0x8009030E:
                result = "No credentials are available in the security package.";
                break;
            case 0x8009030F:
                result = "The message or signature supplied for verification has been altered.";
                break;
            case 0x80090310:
                result = "The message supplied for verification is out of sequence.";
                break;
            case 0x80090311:
                result = "No authority could be contacted for authentication.";
                break;
            case 0x80090316:
                result = "The requested security package does not exist.";
                break;
            case 0x80090317:
                result = "The context has expired and can no longer be used.";
                break;
            case 0x80090318:
                result = "The supplied message is incomplete. The signature was not verified.";
                break;
            case 0x80090320:
                result = "The credentials supplied were not complete and could not be verified. The context could not be initialized.";
                break;
            case 0x80090321:
                result = "The buffers supplied to a function was too small.";
                break;
            case 0x80090322:
                result = "The target principal name is incorrect.";
                break;
            case 0x80090324:
                result = "The clocks on the client and server machines are skewed.";
                break;
            case 0x80090325:
                result = "The certificate chain was issued by an authority that is not trusted.";
                break;
            case 0x80090326:
                result = "The message received was unexpected or badly formatted.";
                break;
            case 0x80090327:
                result = "An unknown error occurred while processing the certificate.";
                break;
            case 0x80090328:
                result = "The received certificate has expired.";
                break;
            case 0x80090329:
                result = "The specified data could not be encrypted.";
                break;
            case 0x80090330:
                result = "The specified data could not be decrypted.";
                break;
            case 0x80090331:
                result = "The client and server cannot communicate because they do not possess a common algorithm.";
                break;
            case 0x80090332:
                result = "The security context could not be established due to a failure in the requested quality of service (for example, mutual authentication or delegation).";
                break;
            case 0x80090333:
                result = "A security context was deleted before the context was completed. This is considered a logon failure.";
                break;
            case 0x80090334:
                result = "The client is trying to negotiate a context and the server requires user-to-user but did not send a ticket granting ticket (TGT) reply.";
                break;
            case 0x80090335:
                result = "Unable to accomplish the requested task because the local machine does not have an IP addresses.";
                break;
            case 0x80090336:
                result = "The supplied credential handle does not match the credential associated with the security context.";
                break;
            case 0x80090337:
                result = "The cryptographic system or checksum function is invalid because a required function is unavailable.";
                break;
            case 0x80090338:
                result = "The number of maximum ticket referrals has been exceeded.";
                break;
            case 0x80090339:
                result = "The local machine must be a Kerberos domain controller (KDC), and it is not.";
                break;
            case 0x8009033A:
                result = "The other end of the security negotiation requires strong cryptographics, but it is not supported on the local machine.";
                break;
            case 0x8009033B:
                result = "The KDC reply contained more than one principal name.";
                break;
            case 0x8009033C:
                result = "Expected to find PA data for a hint of what etype to use, but it was not found.";
                break;
            case 0x8009033D:
                result = "The client certificate does not contain a valid user principal name (UPN), or does not match the client name in the logon request. Contact your administrator.";
                break;
            case 0x8009033E:
                result = "Smart card logon is required and was not used.";
                break;
            case 0x8009033F:
                result = "A system shutdown is in progress.";
                break;
            case 0x80090340:
                result = "An invalid request was sent to the KDC.";
                break;
            case 0x80090341:
                result = "The KDC was unable to generate a referral for the service requested.";
                break;
            case 0x80090342:
                result = "The encryption type requested is not supported by the KDC.";
                break;
            case 0x80090343:
                result = "An unsupported pre-authentication mechanism was presented to the Kerberos package.";
                break;
            case 0x80090345:
                result = "The requested operation cannot be completed. The computer must be trusted for delegation, and the current user account must be configured to allow delegation.";
                break;
            case 0x80090346:
                result = "Client's supplied Security Support Provider Interface (SSPI) channel bindings were incorrect.";
                break;
            case 0x80090347:
                result = "The received certificate was mapped to multiple accounts.";
                break;
            case 0x80090348:
                result = "No Kerberos key was found.";
                break;
            case 0x80090349:
                result = "The certificate is not valid for the requested usage.";
                break;
            case 0x80090350:
                result = "The system detected a possible attempt to compromise security. Ensure that you can contact the server that authenticated you.";
                break;
            case 0x80090351:
                result = "The smart card certificate used for authentication has been revoked. Contact your system administrator. The event log might contain additional information.";
                break;
            case 0x80090352:
                result = "An untrusted certification authority (CA) was detected while processing the smart card certificate used for authentication. Contact your system administrator.";
                break;
            case 0x80090353:
                result = "The revocation status of the smart card certificate used for authentication could not be determined. Contact your system administrator.";
                break;
            case 0x80090354:
                result = "The smart card certificate used for authentication was not trusted. Contact your system administrator.";
                break;
            case 0x80090355:
                result = "The smart card certificate used for authentication has expired. Contact your system administrator.";
                break;
            case 0x80090356:
                result = "The Kerberos subsystem encountered an error. A service for user protocol requests was made against a domain controller that does not support services for users.";
                break;
            case 0x80090357:
                result = "An attempt was made by this server to make a Kerberos-constrained delegation request for a target outside the server's realm. This is not supported and indicates a misconfiguration on this server's allowed-to-delegate-to list. Contact your administrator.";
                break;
            case 0x80090358:
                result = "The revocation status of the domain controller certificate used for smart card authentication could not be determined. The system event log contains additional information. Contact your system administrator.";
                break;
            case 0x80090359:
                result = "An untrusted CA was detected while processing the domain controller certificate used for authentication. The system event log contains additional information. Contact your system administrator.";
                break;
            case 0x8009035A:
                result = "The domain controller certificate used for smart card logon has expired. Contact your system administrator with the contents of your system event log.";
                break;
            case 0x8009035B:
                result = "The domain controller certificate used for smart card logon has been revoked. Contact your system administrator with the contents of your system event log.";
                break;
            case 0x8009035D:
                result = "One or more of the parameters passed to the function were invalid.";
                break;
            case 0x8009035E:
                result = "The client policy does not allow credential delegation to the target server.";
                break;
            case 0x8009035F:
                result = "The client policy does not allow credential delegation to the target server with NLTM only authentication.";
                break;
            case 0x80091001:
                result = "An error occurred while performing an operation on a cryptographic message.";
                break;
            case 0x80091002:
                result = "Unknown cryptographic algorithm.";
                break;
            case 0x80091003:
                result = "The object identifier is poorly formatted.";
                break;
            case 0x80091004:
                result = "Invalid cryptographic message type.";
                break;
            case 0x80091005:
                result = "Unexpected cryptographic message encoding.";
                break;
            case 0x80091006:
                result = "The cryptographic message does not contain an expected authenticated attribute.";
                break;
            case 0x80091007:
                result = "The hash value is not correct.";
                break;
            case 0x80091008:
                result = "The index value is not valid.";
                break;
            case 0x80091009:
                result = "The content of the cryptographic message has already been decrypted.";
                break;
            case 0x8009100A:
                result = "The content of the cryptographic message has not been decrypted yet.";
                break;
            case 0x8009100B:
                result = "The enveloped-data message does not contain the specified recipient.";
                break;
            case 0x8009100C:
                result = "Invalid control type.";
                break;
            case 0x8009100D:
                result = "Invalid issuer or serial number.";
                break;
            case 0x8009100E:
                result = "Cannot find the original signer.";
                break;
            case 0x8009100F:
                result = "The cryptographic message does not contain all of the requested attributes.";
                break;
            case 0x80091010:
                result = "The streamed cryptographic message is not ready to return data.";
                break;
            case 0x80091011:
                result = "The streamed cryptographic message requires more data to complete the decode operation.";
                break;
            case 0x80092001:
                result = "The length specified for the output data was insufficient.";
                break;
            case 0x80092002:
                result = "An error occurred during the encode or decode operation.";
                break;
            case 0x80092003:
                result = "An error occurred while reading or writing to a file.";
                break;
            case 0x80092004:
                result = "Cannot find object or property.";
                break;
            case 0x80092005:
                result = "The object or property already exists.";
                break;
            case 0x80092006:
                result = "No provider was specified for the store or object.";
                break;
            case 0x80092007:
                result = "The specified certificate is self-signed.";
                break;
            case 0x80092008:
                result = "The previous certificate or certificate revocation list (CRL) context was deleted.";
                break;
            case 0x80092009:
                result = "Cannot find the requested object.";
                break;
            case 0x8009200A:
                result = "The certificate does not have a property that references a private key.";
                break;
            case 0x8009200B:
                result = "Cannot find the certificate and private key for decryption.";
                break;
            case 0x8009200C:
                result = "Cannot find the certificate and private key to use for decryption.";
                break;
            case 0x8009200D:
                result = "Not a cryptographic message or the cryptographic message is not formatted correctly.";
                break;
            case 0x8009200E:
                result = "The signed cryptographic message does not have a signer for the specified signer index.";
                break;
            case 0x8009200F:
                result = "Final closure is pending until additional frees or closes.";
                break;
            case 0x80092010:
                result = "The certificate is revoked.";
                break;
            case 0x80092011:
                result = "No DLL or exported function was found to verify revocation.";
                break;
            case 0x80092012:
                result = "The revocation function was unable to check revocation for the certificate.";
                break;
            case 0x80092013:
                result = "The revocation function was unable to check revocation because the revocation server was offline.";
                break;
            case 0x80092014:
                result = "The certificate is not in the revocation server's database.";
                break;
            case 0x80092020:
                result = "The string contains a non-numeric character.";
                break;
            case 0x80092021:
                result = "The string contains a nonprintable character.";
                break;
            case 0x80092022:
                result = "The string contains a character not in the 7-bit ASCII character set.";
                break;
            case 0x80092023:
                result = "The string contains an invalid X500 name attribute key, object identifier (OID), value, or delimiter.";
                break;
            case 0x80092024:
                result = "The dwValueType for the CERT_NAME_VALUE is not one of the character strings. Most likely it is either a CERT_RDN_ENCODED_BLOB or CERT_TDN_OCTED_STRING.";
                break;
            case 0x80092025:
                result = "The Put operation cannot continue. The file needs to be resized. However, there is already a signature present. A complete signing operation must be done.";
                break;
            case 0x80092026:
                result = "The cryptographic operation failed due to a local security option setting.";
                break;
            case 0x80092027:
                result = "No DLL or exported function was found to verify subject usage.";
                break;
            case 0x80092028:
                result = "The called function was unable to perform a usage check on the subject.";
                break;
            case 0x80092029:
                result = "The called function was unable to complete the usage check because the server was offline.";
                break;
            case 0x8009202A:
                result = "The subject was not found in a certificate trust list (CTL).";
                break;
            case 0x8009202B:
                result = "None of the signers of the cryptographic message or certificate trust list is trusted.";
                break;
            case 0x8009202C:
                result = "The public key's algorithm parameters are missing.";
                break;
            case 0x80093000:
                result = "OSS Certificate encode/decode error code base.";
                break;
            case 0x80093001:
                result = "OSS ASN.1 Error: Output Buffer is too small.";
                break;
            case 0x80093002:
                result = "OSS ASN.1 Error: Signed integer is encoded as a unsigned integer.";
                break;
            case 0x80093003:
                result = "OSS ASN.1 Error: Unknown ASN.1 data type.";
                break;
            case 0x80093004:
                result = "OSS ASN.1 Error: Output buffer is too small; the decoded data has been truncated.";
                break;
            case 0x80093005:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x80093006:
                result = "OSS ASN.1 Error: Invalid argument.";
                break;
            case 0x80093007:
                result = "OSS ASN.1 Error: Encode/Decode version mismatch.";
                break;
            case 0x80093008:
                result = "OSS ASN.1 Error: Out of memory.";
                break;
            case 0x80093009:
                result = "OSS ASN.1 Error: Encode/Decode error.";
                break;
            case 0x8009300A:
                result = "OSS ASN.1 Error: Internal error.";
                break;
            case 0x8009300B:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x8009300C:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x8009300D:
                result = "OSS ASN.1 Error: Unsupported BER indefinite-length encoding.";
                break;
            case 0x8009300E:
                result = "OSS ASN.1 Error: Access violation.";
                break;
            case 0x8009300F:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x80093010:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x80093011:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x80093012:
                result = "OSS ASN.1 Error: Internal error.";
                break;
            case 0x80093013:
                result = "OSS ASN.1 Error: Multithreading conflict.";
                break;
            case 0x80093014:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x80093015:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x80093016:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x80093017:
                result = "OSS ASN.1 Error: Encode/Decode function not implemented.";
                break;
            case 0x80093018:
                result = "OSS ASN.1 Error: Trace file error.";
                break;
            case 0x80093019:
                result = "OSS ASN.1 Error: Function not implemented.";
                break;
            case 0x8009301A:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x8009301B:
                result = "OSS ASN.1 Error: Trace file error.";
                break;
            case 0x8009301C:
                result = "OSS ASN.1 Error: Trace file error.";
                break;
            case 0x8009301D:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x8009301E:
                result = "OSS ASN.1 Error: Invalid data.";
                break;
            case 0x8009301F:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093020:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093021:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093022:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093023:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093024:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093025:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093026:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093027:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093028:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x80093029:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x8009302A:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x8009302B:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x8009302C:
                result = "OSS ASN.1 Error: Program link error.";
                break;
            case 0x8009302D:
                result = "OSS ASN.1 Error: System resource error.";
                break;
            case 0x8009302E:
                result = "OSS ASN.1 Error: Trace file error.";
                break;
            case 0x80093100:
                result = "ASN1 Certificate encode/decode error code base.";
                break;
            case 0x80093101:
                result = "ASN1 internal encode or decode error.";
                break;
            case 0x80093102:
                result = "ASN1 unexpected end of data.";
                break;
            case 0x80093103:
                result = "ASN1 corrupted data.";
                break;
            case 0x80093104:
                result = "ASN1 value too large.";
                break;
            case 0x80093105:
                result = "ASN1 constraint violated.";
                break;
            case 0x80093106:
                result = "ASN1 out of memory.";
                break;
            case 0x80093107:
                result = "ASN1 buffer overflow.";
                break;
            case 0x80093108:
                result = "ASN1 function not supported for this protocol data unit (PDU).";
                break;
            case 0x80093109:
                result = "ASN1 bad arguments to function call.";
                break;
            case 0x8009310A:
                result = "ASN1 bad real value.";
                break;
            case 0x8009310B:
                result = "ASN1 bad tag value met.";
                break;
            case 0x8009310C:
                result = "ASN1 bad choice value.";
                break;
            case 0x8009310D:
                result = "ASN1 bad encoding rule.";
                break;
            case 0x8009310E:
                result = "ASN1 bad Unicode (UTF8).";
                break;
            case 0x80093133:
                result = "ASN1 bad PDU type.";
                break;
            case 0x80093134:
                result = "ASN1 not yet implemented.";
                break;
            case 0x80093201:
                result = "ASN1 skipped unknown extensions.";
                break;
            case 0x80093202:
                result = "ASN1 end of data expected.";
                break;
            case 0x80094001:
                result = "The request subject name is invalid or too long.";
                break;
            case 0x80094002:
                result = "The request does not exist.";
                break;
            case 0x80094003:
                result = "The request's current status does not allow this operation.";
                break;
            case 0x80094004:
                result = "The requested property value is empty.";
                break;
            case 0x80094005:
                result = "The CA's certificate contains invalid data.";
                break;
            case 0x80094006:
                result = "Certificate service has been suspended for a database restore operation.";
                break;
            case 0x80094007:
                result = "The certificate contains an encoded length that is potentially incompatible with older enrollment software.";
                break;
            case 0x80094008:
                result = "The operation is denied. The user has multiple roles assigned, and the CA is configured to enforce role separation.";
                break;
            case 0x80094009:
                result = "The operation is denied. It can only be performed by a certificate manager that is allowed to manage certificates for the current requester.";
                break;
            case 0x8009400A:
                result = "Cannot archive private key. The CA is not configured for key archival.";
                break;
            case 0x8009400B:
                result = "Cannot archive private key. The CA could not verify one or more key recovery certificates.";
                break;
            case 0x8009400C:
                result = "The request is incorrectly formatted. The encrypted private key must be in an unauthenticated attribute in an outermost signature.";
                break;
            case 0x8009400D:
                result = "At least one security principal must have the permission to manage this CA.";
                break;
            case 0x8009400E:
                result = "The request contains an invalid renewal certificate attribute.";
                break;
            case 0x8009400F:
                result = "An attempt was made to open a CA database session, but there are already too many active sessions. The server needs to be configured to allow additional sessions.";
                break;
            case 0x80094010:
                result = "A memory reference caused a data alignment fault.";
                break;
            case 0x80094011:
                result = "The permissions on this CA do not allow the current user to enroll for certificates.";
                break;
            case 0x80094012:
                result = "The permissions on the certificate template do not allow the current user to enroll for this type of certificate.";
                break;
            case 0x80094013:
                result = "The contacted domain controller cannot support signed Lightweight Directory Access Protocol (LDAP) traffic. Update the domain controller or configure Certificate Services to use SSL for Active Directory access.";
                break;
            case 0x80094800:
                result = "The requested certificate template is not supported by this CA.";
                break;
            case 0x80094801:
                result = "The request contains no certificate template information.";
                break;
            case 0x80094802:
                result = "The request contains conflicting template information.";
                break;
            case 0x80094803:
                result = "The request is missing a required Subject Alternate name extension.";
                break;
            case 0x80094804:
                result = "The request is missing a required private key for archival by the server.";
                break;
            case 0x80094805:
                result = "The request is missing a required SMIME capabilities extension.";
                break;
            case 0x80094806:
                result = "The request was made on behalf of a subject other than the caller. The certificate template must be configured to require at least one signature to authorize the request.";
                break;
            case 0x80094807:
                result = "The request template version is newer than the supported template version.";
                break;
            case 0x80094808:
                result = "The template is missing a required signature policy attribute.";
                break;
            case 0x80094809:
                result = "The request is missing required signature policy information.";
                break;
            case 0x8009480A:
                result = "The request is missing one or more required signatures.";
                break;
            case 0x8009480B:
                result = "One or more signatures did not include the required application or issuance policies. The request is missing one or more required valid signatures.";
                break;
            case 0x8009480C:
                result = "The request is missing one or more required signature issuance policies.";
                break;
            case 0x8009480D:
                result = "The UPN is unavailable and cannot be added to the Subject Alternate name.";
                break;
            case 0x8009480E:
                result = "The Active Directory GUID is unavailable and cannot be added to the Subject Alternate name.";
                break;
            case 0x8009480F:
                result = "The Domain Name System (DNS) name is unavailable and cannot be added to the Subject Alternate name.";
                break;
            case 0x80094810:
                result = "The request includes a private key for archival by the server, but key archival is not enabled for the specified certificate template.";
                break;
            case 0x80094811:
                result = "The public key does not meet the minimum size required by the specified certificate template.";
                break;
            case 0x80094812:
                result = "The email name is unavailable and cannot be added to the Subject or Subject Alternate name.";
                break;
            case 0x80094813:
                result = "One or more certificate templates to be enabled on this CA could not be found.";
                break;
            case 0x80094814:
                result = "The certificate template renewal period is longer than the certificate validity period. The template should be reconfigured or the CA certificate renewed.";
                break;
            case 0x80094815:
                result = "The certificate template requires too many return authorization (RA) signatures. Only one RA signature is allowed.";
                break;
            case 0x80094816:
                result = "The key used in a renewal request does not match one of the certificates being renewed.";
                break;
            case 0x80094817:
                result = "The endorsement key certificate is not valid.";
                break;
            case 0x8009481A:
                result = "Key attestation did not succeed.";
                break;
            case 0x80095000:
                result = "The key is not exportable.";
                break;
            case 0x80095001:
                result = "You cannot add the root CA certificate into your local store.";
                break;
            case 0x80095002:
                result = "The key archival hash attribute was not found in the response.";
                break;
            case 0x80095003:
                result = "An unexpected key archival hash attribute was found in the response.";
                break;
            case 0x80095004:
                result = "There is a key archival hash mismatch between the request and the response.";
                break;
            case 0x80095005:
                result = "Signing certificate cannot include SMIME extension.";
                break;
            case 0x80096001:
                result = "A system-level error occurred while verifying trust.";
                break;
            case 0x80096002:
                result = "The certificate for the signer of the message is invalid or not found.";
                break;
            case 0x80096003:
                result = "One of the counter signatures was invalid.";
                break;
            case 0x80096004:
                result = "The signature of the certificate cannot be verified.";
                break;
            case 0x80096005:
                result = "The time-stamp signature or certificate could not be verified or is malformed.";
                break;
            case 0x80096010:
                result = "The digital signature of the object did not verify.";
                break;
            case 0x80096019:
                result = "A certificate's basic constraint extension has not been observed.";
                break;
            case 0x8009601E:
                result = "The certificate does not meet or contain the Authenticode financial extensions.";
                break;
            case 0x80097001:
                result = "Tried to reference a part of the file outside the proper range.";
                break;
            case 0x80097002:
                result = "Could not retrieve an object from the file.";
                break;
            case 0x80097003:
                result = "Could not find the head table in the file.";
                break;
            case 0x80097004:
                result = "The magic number in the head table is incorrect.";
                break;
            case 0x80097005:
                result = "The offset table has incorrect values.";
                break;
            case 0x80097006:
                result = "Duplicate table tags or the tags are out of alphabetical order.";
                break;
            case 0x80097007:
                result = "A table does not start on a long word boundary.";
                break;
            case 0x80097008:
                result = "First table does not appear after header information.";
                break;
            case 0x80097009:
                result = "Two or more tables overlap.";
                break;
            case 0x8009700A:
                result = "Too many pad bytes between tables, or pad bytes are not 0.";
                break;
            case 0x8009700B:
                result = "File is too small to contain the last table.";
                break;
            case 0x8009700C:
                result = "A table checksum is incorrect.";
                break;
            case 0x8009700D:
                result = "The file checksum is incorrect.";
                break;
            case 0x80097010:
                result = "The signature does not have the correct attributes for the policy.";
                break;
            case 0x80097011:
                result = "The file did not pass the hints check.";
                break;
            case 0x80097012:
                result = "The file is not an OpenType file.";
                break;
            case 0x80097013:
                result = "Failed on a file operation (such as open, map, read, or write).";
                break;
            case 0x80097014:
                result = "A call to a CryptoAPI function failed.";
                break;
            case 0x80097015:
                result = "There is a bad version number in the file.";
                break;
            case 0x80097016:
                result = "The structure of the DSIG table is incorrect.";
                break;
            case 0x80097017:
                result = "A check failed in a partially constant table.";
                break;
            case 0x80097018:
                result = "Some kind of structural error.";
                break;
            case 0x80097019:
                result = "The requested credential requires confirmation.";
                break;
            case 0x800B0001:
                result = "Unknown trust provider.";
                break;
            case 0x800B0002:
                result = "The trust verification action specified is not supported by the specified trust provider.";
                break;
            case 0x800B0003:
                result = "The form specified for the subject is not one supported or known by the specified trust provider.";
                break;
            case 0x800B0004:
                result = "The subject is not trusted for the specified action.";
                break;
            case 0x800B0005:
                result = "Error due to problem in ASN.1 encoding process.";
                break;
            case 0x800B0006:
                result = "Error due to problem in ASN.1 decoding process.";
                break;
            case 0x800B0007:
                result = "Reading/writing extensions where attributes are appropriate, and vice versa.";
                break;
            case 0x800B0008:
                result = "Unspecified cryptographic failure.";
                break;
            case 0x800B0009:
                result = "The size of the data could not be determined.";
                break;
            case 0x800B000A:
                result = "The size of the indefinite-sized data could not be determined.";
                break;
            case 0x800B000B:
                result = "This object does not read and write self-sizing data.";
                break;
            case 0x800B0100:
                result = "No signature was present in the subject.";
                break;
            case 0x800B0101:
                result = "A required certificate is not within its validity period when verifying against the current system clock or the time stamp in the signed file.";
                break;
            case 0x800B0102:
                result = "The validity periods of the certification chain do not nest correctly.";
                break;
            case 0x800B0103:
                result = "A certificate that can only be used as an end entity is being used as a CA or vice versa.";
                break;
            case 0x800B0104:
                result = "A path length constraint in the certification chain has been violated.";
                break;
            case 0x800B0105:
                result = "A certificate contains an unknown extension that is marked \"critical\".";
                break;
            case 0x800B0106:
                result = "A certificate is being used for a purpose other than the ones specified by its CA.";
                break;
            case 0x800B0107:
                result = "A parent of a given certificate did not issue that child certificate.";
                break;
            case 0x800B0108:
                result = "A certificate is missing or has an empty value for an important field, such as a subject or issuer name.";
                break;
            case 0x800B0109:
                result = "A certificate chain processed, but terminated in a root certificate that is not trusted by the trust provider.";
                break;
            case 0x800B010A:
                result = "A certificate chain could not be built to a trusted root authority.";
                break;
            case 0x800B010B:
                result = "Generic trust failure.";
                break;
            case 0x800B010C:
                result = "A certificate was explicitly revoked by its issuer. If the certificate is Microsoft Windows PCA 2010, then the driver was signed by a certificate no longer recognized by Windows.";
                break;
            case 0x800B010D:
                result = "The certification path terminates with the test root that is not trusted with the current policy settings.";
                break;
            case 0x800B010E:
                result = "The revocation process could not continue—the certificates could not be checked.";
                break;
            case 0x800B010F:
                result = "The certificate's CN name does not match the passed value.";
                break;
            case 0x800B0110:
                result = "The certificate is not valid for the requested usage.";
                break;
            case 0x800B0111:
                result = "The certificate was explicitly marked as untrusted by the user.";
                break;
            case 0x800B0112:
                result = "A certification chain processed correctly, but one of the CA certificates is not trusted by the policy provider.";
                break;
            case 0x800B0113:
                result = "The certificate has invalid policy.";
                break;
            case 0x800B0114:
                result = "The certificate has an invalid name. The name is not included in the permitted list or is explicitly excluded.";
                break;
            case 0x800D0003:
                result = "The maximum filebitrate value specified is greater than the server's configured maximum bandwidth.";
                break;
            case 0x800D0004:
                result = "The maximum bandwidth value specified is less than the maximum filebitrate.";
                break;
            case 0x800D0060:
                result = "Unknown %1 event encountered.";
                break;
            case 0x800D0199:
                result = "Disk %1 ( %2 ) on Content Server %3, will be failed because it is catatonic.";
                break;
            case 0x800D019A:
                result = "Disk %1 ( %2 ) on Content Server %3, auto online from catatonic state.";
                break;
            case 0x800F0000:
                result = "A non-empty line was encountered in the INF before the start of a section.";
                break;
            case 0x800F0001:
                result = "A section name marker in the information file (INF) is not complete or does not exist on a line by itself.";
                break;
            case 0x800F0002:
                result = "An INF section was encountered whose name exceeds the maximum section name length.";
                break;
            case 0x800F0003:
                result = "The syntax of the INF is invalid.";
                break;
            case 0x800F0100:
                result = "The style of the INF is different than what was requested.";
                break;
            case 0x800F0101:
                result = "The required section was not found in the INF.";
                break;
            case 0x800F0102:
                result = "The required line was not found in the INF.";
                break;
            case 0x800F0103:
                result = "The files affected by the installation of this file queue have not been backed up for uninstall.";
                break;
            case 0x800F0200:
                result = "The INF or the device information set or element does not have an associated install class.";
                break;
            case 0x800F0201:
                result = "The INF or the device information set or element does not match the specified install class.";
                break;
            case 0x800F0202:
                result = "An existing device was found that is a duplicate of the device being manually installed.";
                break;
            case 0x800F0203:
                result = "There is no driver selected for the device information set or element.";
                break;
            case 0x800F0204:
                result = "The requested device registry key does not exist.";
                break;
            case 0x800F0205:
                result = "The device instance name is invalid.";
                break;
            case 0x800F0206:
                result = "The install class is not present or is invalid.";
                break;
            case 0x800F0207:
                result = "The device instance cannot be created because it already exists.";
                break;
            case 0x800F0208:
                result = "The operation cannot be performed on a device information element that has not been registered.";
                break;
            case 0x800F0209:
                result = "The device property code is invalid.";
                break;
            case 0x800F020A:
                result = "The INF from which a driver list is to be built does not exist.";
                break;
            case 0x800F020B:
                result = "The device instance does not exist in the hardware tree.";
                break;
            case 0x800F020C:
                result = "The icon representing this install class cannot be loaded.";
                break;
            case 0x800F020D:
                result = "The class installer registry entry is invalid.";
                break;
            case 0x800F020E:
                result = "The class installer has indicated that the default action should be performed for this installation request.";
                break;
            case 0x800F020F:
                result = "The operation does not require any files to be copied.";
                break;
            case 0x800F0210:
                result = "The specified hardware profile does not exist.";
                break;
            case 0x800F0211:
                result = "There is no device information element currently selected for this device information set.";
                break;
            case 0x800F0212:
                result = "The operation cannot be performed because the device information set is locked.";
                break;
            case 0x800F0213:
                result = "The operation cannot be performed because the device information element is locked.";
                break;
            case 0x800F0214:
                result = "The specified path does not contain any applicable device INFs.";
                break;
            case 0x800F0215:
                result = "No class installer parameters have been set for the device information set or element.";
                break;
            case 0x800F0216:
                result = "The operation cannot be performed because the file queue is locked.";
                break;
            case 0x800F0217:
                result = "A service installation section in this INF is invalid.";
                break;
            case 0x800F0218:
                result = "There is no class driver list for the device information element.";
                break;
            case 0x800F0219:
                result = "The installation failed because a function driver was not specified for this device instance.";
                break;
            case 0x800F021A:
                result = "There is presently no default device interface designated for this interface class.";
                break;
            case 0x800F021B:
                result = "The operation cannot be performed because the device interface is currently active.";
                break;
            case 0x800F021C:
                result = "The operation cannot be performed because the device interface has been removed from the system.";
                break;
            case 0x800F021D:
                result = "An interface installation section in this INF is invalid.";
                break;
            case 0x800F021E:
                result = "This interface class does not exist in the system.";
                break;
            case 0x800F021F:
                result = "The reference string supplied for this interface device is invalid.";
                break;
            case 0x800F0220:
                result = "The specified machine name does not conform to Universal Naming Convention (UNCs).";
                break;
            case 0x800F0221:
                result = "A general remote communication error occurred.";
                break;
            case 0x800F0222:
                result = "The machine selected for remote communication is not available at this time.";
                break;
            case 0x800F0223:
                result = "The Plug and Play service is not available on the remote machine.";
                break;
            case 0x800F0224:
                result = "The property page provider registry entry is invalid.";
                break;
            case 0x800F0225:
                result = "The requested device interface is not present in the system.";
                break;
            case 0x800F0226:
                result = "The device's co-installer has additional work to perform after installation is complete.";
                break;
            case 0x800F0227:
                result = "The device's co-installer is invalid.";
                break;
            case 0x800F0228:
                result = "There are no compatible drivers for this device.";
                break;
            case 0x800F0229:
                result = "There is no icon that represents this device or device type.";
                break;
            case 0x800F022A:
                result = "A logical configuration specified in this INF is invalid.";
                break;
            case 0x800F022B:
                result = "The class installer has denied the request to install or upgrade this device.";
                break;
            case 0x800F022C:
                result = "One of the filter drivers installed for this device is invalid.";
                break;
            case 0x800F022D:
                result = "The driver selected for this device does not support Windows XP operating system.";
                break;
            case 0x800F022E:
                result = "The driver selected for this device does not support Windows.";
                break;
            case 0x800F022F:
                result = "The third-party INF does not contain digital signature information.";
                break;
            case 0x800F0230:
                result = "An invalid attempt was made to use a device installation file queue for verification of digital signatures relative to other platforms.";
                break;
            case 0x800F0231:
                result = "The device cannot be disabled.";
                break;
            case 0x800F0232:
                result = "The device could not be dynamically removed.";
                break;
            case 0x800F0233:
                result = "Cannot copy to specified target.";
                break;
            case 0x800F0234:
                result = "Driver is not intended for this platform.";
                break;
            case 0x800F0235:
                result = "Operation not allowed in WOW64.";
                break;
            case 0x800F0236:
                result = "The operation involving unsigned file copying was rolled back, so that a system restore point could be set.";
                break;
            case 0x800F0237:
                result = "An INF was copied into the Windows INF directory in an improper manner.";
                break;
            case 0x800F0238:
                result = "The Security Configuration Editor (SCE) APIs have been disabled on this embedded product.";
                break;
            case 0x800F0239:
                result = "An unknown exception was encountered.";
                break;
            case 0x800F023A:
                result = "A problem was encountered when accessing the Plug and Play registry database.";
                break;
            case 0x800F023B:
                result = "The requested operation is not supported for a remote machine.";
                break;
            case 0x800F023C:
                result = "The specified file is not an installed original equipment manufacturer (OEM) INF.";
                break;
            case 0x800F023D:
                result = "One or more devices are presently installed using the specified INF.";
                break;
            case 0x800F023E:
                result = "The requested device install operation is obsolete.";
                break;
            case 0x800F023F:
                result = "A file could not be verified because it does not have an associated catalog signed via Authenticode.";
                break;
            case 0x800F0240:
                result = "Authenticode signature verification is not supported for the specified INF.";
                break;
            case 0x800F0241:
                result = "The INF was signed with an Authenticode catalog from a trusted publisher.";
                break;
            case 0x800F0242:
                result = "The publisher of an Authenticode-signed catalog has not yet been established as trusted.";
                break;
            case 0x800F0243:
                result = "The publisher of an Authenticode-signed catalog was not established as trusted.";
                break;
            case 0x800F0244:
                result = "The software was tested for compliance with Windows logo requirements on a different version of Windows and might not be compatible with this version.";
                break;
            case 0x800F0245:
                result = "The file can be validated only by a catalog signed via Authenticode.";
                break;
            case 0x800F0246:
                result = "One of the installers for this device cannot perform the installation at this time.";
                break;
            case 0x800F0247:
                result = "A problem was encountered while attempting to add the driver to the store.";
                break;
            case 0x800F0248:
                result = "The installation of this device is forbidden by system policy. Contact your system administrator.";
                break;
            case 0x800F0249:
                result = "The installation of this driver is forbidden by system policy. Contact your system administrator.";
                break;
            case 0x800F024A:
                result = "The specified INF is the wrong type for this operation.";
                break;
            case 0x800F024B:
                result = "The hash for the file is not present in the specified catalog file. The file is likely corrupt or the victim of tampering.";
                break;
            case 0x800F024C:
                result = "A problem was encountered while attempting to delete the driver from the store.";
                break;
            case 0x800F0300:
                result = "An unrecoverable stack overflow was encountered.";
                break;
            case 0x800F1000:
                result = "No installed components were detected.";
                break;
            case 0x80100001:
                result = "An internal consistency check failed.";
                break;
            case 0x80100002:
                result = "The action was canceled by an SCardCancel request.";
                break;
            case 0x80100003:
                result = "The supplied handle was invalid.";
                break;
            case 0x80100004:
                result = "One or more of the supplied parameters could not be properly interpreted.";
                break;
            case 0x80100005:
                result = "Registry startup information is missing or invalid.";
                break;
            case 0x80100006:
                result = "Not enough memory available to complete this command.";
                break;
            case 0x80100007:
                result = "An internal consistency timer has expired.";
                break;
            case 0x80100008:
                result = "The data buffer to receive returned data is too small for the returned data.";
                break;
            case 0x80100009:
                result = "The specified reader name is not recognized.";
                break;
            case 0x8010000A:
                result = "The user-specified time-out value has expired.";
                break;
            case 0x8010000B:
                result = "The smart card cannot be accessed because of other connections outstanding.";
                break;
            case 0x8010000C:
                result = "The operation requires a smart card, but no smart card is currently in the device.";
                break;
            case 0x8010000D:
                result = "The specified smart card name is not recognized.";
                break;
            case 0x8010000E:
                result = "The system could not dispose of the media in the requested manner.";
                break;
            case 0x8010000F:
                result = "The requested protocols are incompatible with the protocol currently in use with the smart card.";
                break;
            case 0x80100010:
                result = "The reader or smart card is not ready to accept commands.";
                break;
            case 0x80100011:
                result = "One or more of the supplied parameters values could not be properly interpreted.";
                break;
            case 0x80100012:
                result = "The action was canceled by the system, presumably to log off or shut down.";
                break;
            case 0x80100013:
                result = "An internal communications error has been detected.";
                break;
            case 0x80100014:
                result = "An internal error has been detected, but the source is unknown.";
                break;
            case 0x80100015:
                result = "An automatic terminal recognition (ATR) obtained from the registry is not a valid ATR string.";
                break;
            case 0x80100016:
                result = "An attempt was made to end a nonexistent transaction.";
                break;
            case 0x80100017:
                result = "The specified reader is not currently available for use.";
                break;
            case 0x80100018:
                result = "The operation has been aborted to allow the server application to exit.";
                break;
            case 0x80100019:
                result = "The peripheral component interconnect (PCI) Receive buffer was too small.";
                break;
            case 0x8010001A:
                result = "The reader driver does not meet minimal requirements for support.";
                break;
            case 0x8010001B:
                result = "The reader driver did not produce a unique reader name.";
                break;
            case 0x8010001C:
                result = "The smart card does not meet minimal requirements for support.";
                break;
            case 0x8010001D:
                result = "The smart card resource manager is not running.";
                break;
            case 0x8010001E:
                result = "The smart card resource manager has shut down.";
                break;
            case 0x8010001F:
                result = "An unexpected card error has occurred.";
                break;
            case 0x80100020:
                result = "No primary provider can be found for the smart card.";
                break;
            case 0x80100021:
                result = "The requested order of object creation is not supported.";
                break;
            case 0x80100022:
                result = "This smart card does not support the requested feature.";
                break;
            case 0x80100023:
                result = "The identified directory does not exist in the smart card.";
                break;
            case 0x80100024:
                result = "The identified file does not exist in the smart card.";
                break;
            case 0x80100025:
                result = "The supplied path does not represent a smart card directory.";
                break;
            case 0x80100026:
                result = "The supplied path does not represent a smart card file.";
                break;
            case 0x80100027:
                result = "Access is denied to this file.";
                break;
            case 0x80100028:
                result = "The smart card does not have enough memory to store the information.";
                break;
            case 0x80100029:
                result = "There was an error trying to set the smart card file object pointer.";
                break;
            case 0x8010002A:
                result = "The supplied PIN is incorrect.";
                break;
            case 0x8010002B:
                result = "An unrecognized error code was returned from a layered component.";
                break;
            case 0x8010002C:
                result = "The requested certificate does not exist.";
                break;
            case 0x8010002D:
                result = "The requested certificate could not be obtained.";
                break;
            case 0x8010002E:
                result = "Cannot find a smart card reader.";
                break;
            case 0x8010002F:
                result = "A communications error with the smart card has been detected. Retry the operation.";
                break;
            case 0x80100030:
                result = "The requested key container does not exist on the smart card.";
                break;
            case 0x80100031:
                result = "The smart card resource manager is too busy to complete this operation.";
                break;
            case 0x80100065:
                result = "The reader cannot communicate with the smart card, due to ATR configuration conflicts.";
                break;
            case 0x80100066:
                result = "The smart card is not responding to a reset.";
                break;
            case 0x80100067:
                result = "Power has been removed from the smart card, so that further communication is not possible.";
                break;
            case 0x80100068:
                result = "The smart card has been reset, so any shared state information is invalid.";
                break;
            case 0x80100069:
                result = "The smart card has been removed, so that further communication is not possible.";
                break;
            case 0x8010006A:
                result = "Access was denied because of a security violation.";
                break;
            case 0x8010006B:
                result = "The card cannot be accessed because the wrong PIN was presented.";
                break;
            case 0x8010006C:
                result = "The card cannot be accessed because the maximum number of PIN entry attempts has been reached.";
                break;
            case 0x8010006D:
                result = "The end of the smart card file has been reached.";
                break;
            case 0x8010006E:
                result = "The action was canceled by the user.";
                break;
            case 0x8010006F:
                result = "No PIN was presented to the smart card.";
                break;
            case 0x80110401:
                result = "Errors occurred accessing one or more objects—the ErrorInfo collection contains more detail.";
                break;
            case 0x80110402:
                result = "One or more of the object's properties are missing or invalid.";
                break;
            case 0x80110403:
                result = "The object was not found in the catalog.";
                break;
            case 0x80110404:
                result = "The object is already registered.";
                break;
            case 0x80110407:
                result = "An error occurred writing to the application file.";
                break;
            case 0x80110408:
                result = "An error occurred reading the application file.";
                break;
            case 0x80110409:
                result = "Invalid version number in application file.";
                break;
            case 0x8011040A:
                result = "The file path is invalid.";
                break;
            case 0x8011040B:
                result = "The application is already installed.";
                break;
            case 0x8011040C:
                result = "The role already exists.";
                break;
            case 0x8011040D:
                result = "An error occurred copying the file.";
                break;
            case 0x8011040F:
                result = "One or more users are not valid.";
                break;
            case 0x80110410:
                result = "One or more users in the application file are not valid.";
                break;
            case 0x80110411:
                result = "The component's CLSID is missing or corrupt.";
                break;
            case 0x80110412:
                result = "The component's programmatic ID is missing or corrupt.";
                break;
            case 0x80110413:
                result = "Unable to set required authentication level for update request.";
                break;
            case 0x80110414:
                result = "The identity or password set on the application is not valid.";
                break;
            case 0x80110418:
                result = "Application file CLSIDs or instance identifiers (IIDs) do not match corresponding DLLs.";
                break;
            case 0x80110419:
                result = "Interface information is either missing or changed.";
                break;
            case 0x8011041A:
                result = "DllRegisterServer failed on component install.";
                break;
            case 0x8011041B:
                result = "No server file share available.";
                break;
            case 0x8011041D:
                result = "DLL could not be loaded.";
                break;
            case 0x8011041E:
                result = "The registered TypeLib ID is not valid.";
                break;
            case 0x8011041F:
                result = "Application install directory not found.";
                break;
            case 0x80110423:
                result = "Errors occurred while in the component registrar.";
                break;
            case 0x80110424:
                result = "The file does not exist.";
                break;
            case 0x80110425:
                result = "The DLL could not be loaded.";
                break;
            case 0x80110426:
                result = "GetClassObject failed in the DLL.";
                break;
            case 0x80110427:
                result = "The DLL does not support the components listed in the TypeLib.";
                break;
            case 0x80110428:
                result = "The TypeLib could not be loaded.";
                break;
            case 0x80110429:
                result = "The file does not contain components or component information.";
                break;
            case 0x8011042A:
                result = "Changes to this object and its subobjects have been disabled.";
                break;
            case 0x8011042B:
                result = "The delete function has been disabled for this object.";
                break;
            case 0x8011042C:
                result = "The server catalog version is not supported.";
                break;
            case 0x8011042D:
                result = "The component move was disallowed because the source or destination application is either a system application or currently locked against changes.";
                break;
            case 0x8011042E:
                result = "The component move failed because the destination application no longer exists.";
                break;
            case 0x80110430:
                result = "The system was unable to register the TypeLib.";
                break;
            case 0x80110433:
                result = "This operation cannot be performed on the system application.";
                break;
            case 0x80110434:
                result = "The component registrar referenced in this file is not available.";
                break;
            case 0x80110435:
                result = "A component in the same DLL is already installed.";
                break;
            case 0x80110436:
                result = "The service is not installed.";
                break;
            case 0x80110437:
                result = "One or more property settings are either invalid or in conflict with each other.";
                break;
            case 0x80110438:
                result = "The object you are attempting to add or rename already exists.";
                break;
            case 0x80110439:
                result = "The component already exists.";
                break;
            case 0x8011043B:
                result = "The registration file is corrupt.";
                break;
            case 0x8011043C:
                result = "The property value is too large.";
                break;
            case 0x8011043E:
                result = "Object was not found in registry.";
                break;
            case 0x8011043F:
                result = "This object cannot be pooled.";
                break;
            case 0x80110446:
                result = "A CLSID with the same GUID as the new application ID is already installed on this machine.";
                break;
            case 0x80110447:
                result = "A role assigned to a component, interface, or method did not exist in the application.";
                break;
            case 0x80110448:
                result = "You must have components in an application to start the application.";
                break;
            case 0x80110449:
                result = "This operation is not enabled on this platform.";
                break;
            case 0x8011044A:
                result = "Application proxy is not exportable.";
                break;
            case 0x8011044B:
                result = "Failed to start application because it is either a library application or an application proxy.";
                break;
            case 0x8011044C:
                result = "System application is not exportable.";
                break;
            case 0x8011044D:
                result = "Cannot subscribe to this component (the component might have been imported).";
                break;
            case 0x8011044E:
                result = "An event class cannot also be a subscriber component.";
                break;
            case 0x8011044F:
                result = "Library applications and application proxies are incompatible.";
                break;
            case 0x80110450:
                result = "This function is valid for the base partition only.";
                break;
            case 0x80110451:
                result = "You cannot start an application that has been disabled.";
                break;
            case 0x80110457:
                result = "The specified partition name is already in use on this computer.";
                break;
            case 0x80110458:
                result = "The specified partition name is invalid. Check that the name contains at least one visible character.";
                break;
            case 0x80110459:
                result = "The partition cannot be deleted because it is the default partition for one or more users.";
                break;
            case 0x8011045A:
                result = "The partition cannot be exported because one or more components in the partition have the same file name.";
                break;
            case 0x8011045B:
                result = "Applications that contain one or more imported components cannot be installed into a nonbase partition.";
                break;
            case 0x8011045C:
                result = "The application name is not unique and cannot be resolved to an application ID.";
                break;
            case 0x8011045D:
                result = "The partition name is not unique and cannot be resolved to a partition ID.";
                break;
            case 0x80110472:
                result = "The COM+ registry database has not been initialized.";
                break;
            case 0x80110473:
                result = "The COM+ registry database is not open.";
                break;
            case 0x80110474:
                result = "The COM+ registry database detected a system error.";
                break;
            case 0x80110475:
                result = "The COM+ registry database is already running.";
                break;
            case 0x80110480:
                result = "This version of the COM+ registry database cannot be migrated.";
                break;
            case 0x80110481:
                result = "The schema version to be migrated could not be found in the COM+ registry database.";
                break;
            case 0x80110482:
                result = "There was a type mismatch between binaries.";
                break;
            case 0x80110483:
                result = "A binary of unknown or invalid type was provided.";
                break;
            case 0x80110484:
                result = "There was a type mismatch between a binary and an application.";
                break;
            case 0x80110485:
                result = "The application cannot be paused or resumed.";
                break;
            case 0x80110486:
                result = "The COM+ catalog server threw an exception during execution.";
                break;
            case 0x80110600:
                result = "Only COM+ applications marked \"queued\" can be invoked using the \"queue\" moniker.";
                break;
            case 0x80110601:
                result = "At least one interface must be marked \"queued\" to create a queued component instance with the \"queue\" moniker.";
                break;
            case 0x80110602:
                result = "Message Queuing is required for the requested operation and is not installed.";
                break;
            case 0x80110603:
                result = "Unable to marshal an interface that does not support IPersistStream.";
                break;
            case 0x80110604:
                result = "The message is improperly formatted or was damaged in transit.";
                break;
            case 0x80110605:
                result = "An unauthenticated message was received by an application that accepts only authenticated messages.";
                break;
            case 0x80110606:
                result = "The message was requeued or moved by a user not in the QC Trusted User \"role\".";
                break;
            case 0x80110701:
                result = "Cannot create a duplicate resource of type Distributed Transaction Coordinator.";
                break;
            case 0x80110808:
                result = "One of the objects being inserted or updated does not belong to a valid parent collection.";
                break;
            case 0x80110809:
                result = "One of the specified objects cannot be found.";
                break;
            case 0x8011080A:
                result = "The specified application is not currently running.";
                break;
            case 0x8011080B:
                result = "The partitions specified are not valid.";
                break;
            case 0x8011080D:
                result = "COM+ applications that run as Windows NT service cannot be pooled or recycled.";
                break;
            case 0x8011080E:
                result = "One or more users are already assigned to a local partition set.";
                break;
            case 0x8011080F:
                result = "Library applications cannot be recycled.";
                break;
            case 0x80110811:
                result = "Applications running as Windows NT services cannot be recycled.";
                break;
            case 0x80110812:
                result = "The process has already been recycled.";
                break;
            case 0x80110813:
                result = "A paused process cannot be recycled.";
                break;
            case 0x80110814:
                result = "Library applications cannot be Windows NT services.";
                break;
            case 0x80110815:
                result = "The ProgID provided to the copy operation is invalid. The ProgID is in use by another registered CLSID.";
                break;
            case 0x80110816:
                result = "The partition specified as the default is not a member of the partition set.";
                break;
            case 0x80110817:
                result = "A recycled process cannot be paused.";
                break;
            case 0x80110818:
                result = "Access to the specified partition is denied.";
                break;
            case 0x80110819:
                result = "Only application files (*.msi files) can be installed into partitions.";
                break;
            case 0x8011081A:
                result = "Applications containing one or more legacy components cannot be exported to 1.0 format.";
                break;
            case 0x8011081B:
                result = "Legacy components cannot exist in nonbase partitions.";
                break;
            case 0x8011081C:
                result = "A component cannot be moved (or copied) from the System Application, an application proxy, or a nonchangeable application.";
                break;
            case 0x8011081D:
                result = "A component cannot be moved (or copied) to the System Application, an application proxy or a nonchangeable application.";
                break;
            case 0x8011081E:
                result = "A private component cannot be moved (or copied) to a library application or to the base partition.";
                break;
            case 0x8011081F:
                result = "The Base Application Partition exists in all partition sets and cannot be removed.";
                break;
            case 0x80110820:
                result = "Alas, Event Class components cannot be aliased.";
                break;
            case 0x80110821:
                result = "Access is denied because the component is private.";
                break;
            case 0x80110822:
                result = "The specified SAFER level is invalid.";
                break;
            case 0x80110823:
                result = "The specified user cannot write to the system registry.";
                break;
            case 0x80110824:
                result = "COM+ partitions are currently disabled.";
                break;
            case 0x801F0001:
                result = "A handler was not defined by the filter for this operation.";
                break;
            case 0x801F0002:
                result = "A context is already defined for this object.";
                break;
            case 0x801F0003:
                result = "Asynchronous requests are not valid for this operation.";
                break;
            case 0x801F0004:
                result = "Disallow the Fast IO path for this operation.";
                break;
            case 0x801F0005:
                result = "An invalid name request was made. The name requested cannot be retrieved at this time.";
                break;
            case 0x801F0006:
                result = "Posting this operation to a worker thread for further processing is not safe at this time because it could lead to a system deadlock.";
                break;
            case 0x801F0007:
                result = "The Filter Manager was not initialized when a filter tried to register. Be sure that the Filter Manager is being loaded as a driver.";
                break;
            case 0x801F0008:
                result = "The filter is not ready for attachment to volumes because it has not finished initializing (FltStartFiltering has not been called).";
                break;
            case 0x801F0009:
                result = "The filter must clean up any operation-specific context at this time because it is being removed from the system before the operation is completed by the lower drivers.";
                break;
            case 0x801F000A:
                result = "The Filter Manager had an internal error from which it cannot recover; therefore, the operation has been failed. This is usually the result of a filter returning an invalid value from a preoperation callback.";
                break;
            case 0x801F000B:
                result = "The object specified for this action is in the process of being deleted; therefore, the action requested cannot be completed at this time.";
                break;
            case 0x801F000C:
                result = "Nonpaged pool must be used for this type of context.";
                break;
            case 0x801F000D:
                result = "A duplicate handler definition has been provided for an operation.";
                break;
            case 0x801F000E:
                result = "The callback data queue has been disabled.";
                break;
            case 0x801F000F:
                result = "Do not attach the filter to the volume at this time.";
                break;
            case 0x801F0010:
                result = "Do not detach the filter from the volume at this time.";
                break;
            case 0x801F0011:
                result = "An instance already exists at this altitude on the volume specified.";
                break;
            case 0x801F0012:
                result = "An instance already exists with this name on the volume specified.";
                break;
            case 0x801F0013:
                result = "The system could not find the filter specified.";
                break;
            case 0x801F0014:
                result = "The system could not find the volume specified.";
                break;
            case 0x801F0015:
                result = "The system could not find the instance specified.";
                break;
            case 0x801F0016:
                result = "No registered context allocation definition was found for the given request.";
                break;
            case 0x801F0017:
                result = "An invalid parameter was specified during context registration.";
                break;
            case 0x801F0018:
                result = "The name requested was not found in the Filter Manager name cache and could not be retrieved from the file system.";
                break;
            case 0x801F0019:
                result = "The requested device object does not exist for the given volume.";
                break;
            case 0x801F001A:
                result = "The specified volume is already mounted.";
                break;
            case 0x801F001B:
                result = "The specified Transaction Context is already enlisted in a transaction.";
                break;
            case 0x801F001C:
                result = "The specified context is already attached to another object.";
                break;
            case 0x801F0020:
                result = "No waiter is present for the filter's reply to this message.";
                break;
            case 0x80260001:
                result = "{Display Driver Stopped Responding} The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft.";
                break;
            case 0x80261001:
                result = "Monitor descriptor could not be obtained.";
                break;
            case 0x80261002:
                result = "Format of the obtained monitor descriptor is not supported by this release.";
                break;
            case 0x80263001:
                result = "{Desktop Composition is Disabled} The operation could not be completed because desktop composition is disabled.";
                break;
            case 0x80263002:
                result = "{Some Desktop Composition APIs Are Not Supported While Remoting} Some desktop composition APIs are not supported while remoting. The operation is not supported while running in a remote session.";
                break;
            case 0x80263003:
                result = "{No DWM Redirection Surface is Available} The Desktop Window Manager (DWM) was unable to provide a redirection surface to complete the DirectX present.";
                break;
            case 0x80263004:
                result = "{DWM Is Not Queuing Presents for the Specified Window} The window specified is not currently using queued presents.";
                break;
            case 0x80280000:
                result = "This is an error mask to convert Trusted Platform Module (TPM) hardware errors to Win32 errors.";
                break;
            case 0x80280001:
                result = "Authentication failed.";
                break;
            case 0x80280002:
                result = "The index to a Platform Configuration Register (PCR), DIR, or other register is incorrect.";
                break;
            case 0x80280003:
                result = "One or more parameters are bad.";
                break;
            case 0x80280004:
                result = "An operation completed successfully but the auditing of that operation failed.";
                break;
            case 0x80280005:
                result = "The clear disable flag is set and all clear operations now require physical access.";
                break;
            case 0x80280006:
                result = "The TPM is deactivated.";
                break;
            case 0x80280007:
                result = "The TPM is disabled.";
                break;
            case 0x80280008:
                result = "The target command has been disabled.";
                break;
            case 0x80280009:
                result = "The operation failed.";
                break;
            case 0x8028000A:
                result = "The ordinal was unknown or inconsistent.";
                break;
            case 0x8028000B:
                result = "The ability to install an owner is disabled.";
                break;
            case 0x8028000C:
                result = "The key handle cannot be interpreted.";
                break;
            case 0x8028000D:
                result = "The key handle points to an invalid key.";
                break;
            case 0x8028000E:
                result = "Unacceptable encryption scheme.";
                break;
            case 0x8028000F:
                result = "Migration authorization failed.";
                break;
            case 0x80280010:
                result = "PCR information could not be interpreted.";
                break;
            case 0x80280011:
                result = "No room to load key.";
                break;
            case 0x80280012:
                result = "There is no storage root key (SRK) set.";
                break;
            case 0x80280013:
                result = "An encrypted blob is invalid or was not created by this TPM.";
                break;
            case 0x80280014:
                result = "There is already an owner.";
                break;
            case 0x80280015:
                result = "The TPM has insufficient internal resources to perform the requested action.";
                break;
            case 0x80280016:
                result = "A random string was too short.";
                break;
            case 0x80280017:
                result = "The TPM does not have the space to perform the operation.";
                break;
            case 0x80280018:
                result = "The named PCR value does not match the current PCR value.";
                break;
            case 0x80280019:
                result = "The paramSize argument to the command has the incorrect value.";
                break;
            case 0x8028001A:
                result = "There is no existing SHA-1 thread.";
                break;
            case 0x8028001B:
                result = "The calculation is unable to proceed because the existing SHA-1 thread has already encountered an error.";
                break;
            case 0x8028001C:
                result = "Self-test has failed and the TPM has shut down.";
                break;
            case 0x8028001D:
                result = "The authorization for the second key in a two-key function failed authorization.";
                break;
            case 0x8028001E:
                result = "The tag value sent to for a command is invalid.";
                break;
            case 0x8028001F:
                result = "An I/O error occurred transmitting information to the TPM.";
                break;
            case 0x80280020:
                result = "The encryption process had a problem.";
                break;
            case 0x80280021:
                result = "The decryption process did not complete.";
                break;
            case 0x80280022:
                result = "An invalid handle was used.";
                break;
            case 0x80280023:
                result = "The TPM does not have an endorsement key (EK) installed.";
                break;
            case 0x80280024:
                result = "The usage of a key is not allowed.";
                break;
            case 0x80280025:
                result = "The submitted entity type is not allowed.";
                break;
            case 0x80280026:
                result = "The command was received in the wrong sequence relative to TPM_Init and a subsequent TPM_Startup.";
                break;
            case 0x80280027:
                result = "Signed data cannot include additional DER information.";
                break;
            case 0x80280028:
                result = "The key properties in TPM_KEY_PARMs are not supported by this TPM.";
                break;
            case 0x80280029:
                result = "The migration properties of this key are incorrect.";
                break;
            case 0x8028002A:
                result = "The signature or encryption scheme for this key is incorrect or not permitted in this situation.";
                break;
            case 0x8028002B:
                result = "The size of the data (or blob) parameter is bad or inconsistent with the referenced key.";
                break;
            case 0x8028002C:
                result = "A mode parameter is bad, such as capArea or subCapArea for TPM_GetCapability, physicalPresence parameter for TPM_PhysicalPresence, or migrationType for TPM_CreateMigrationBlob.";
                break;
            case 0x8028002D:
                result = "Either the physicalPresence or physicalPresenceLock bits have the wrong value.";
                break;
            case 0x8028002E:
                result = "The TPM cannot perform this version of the capability.";
                break;
            case 0x8028002F:
                result = "The TPM does not allow for wrapped transport sessions.";
                break;
            case 0x80280030:
                result = "TPM audit construction failed and the underlying command was returning a failure code also.";
                break;
            case 0x80280031:
                result = "TPM audit construction failed and the underlying command was returning success.";
                break;
            case 0x80280032:
                result = "Attempt to reset a PCR that does not have the resettable attribute.";
                break;
            case 0x80280033:
                result = "Attempt to reset a PCR register that requires locality and the locality modifier not part of command transport.";
                break;
            case 0x80280034:
                result = "Make identity blob not properly typed.";
                break;
            case 0x80280035:
                result = "When saving context identified resource type does not match actual resource.";
                break;
            case 0x80280036:
                result = "The TPM is attempting to execute a command only available when in Federal Information Processing Standards (FIPS) mode.";
                break;
            case 0x80280037:
                result = "The command is attempting to use an invalid family ID.";
                break;
            case 0x80280038:
                result = "The permission to manipulate the NV storage is not available.";
                break;
            case 0x80280039:
                result = "The operation requires a signed command.";
                break;
            case 0x8028003A:
                result = "Wrong operation to load an NV key.";
                break;
            case 0x8028003B:
                result = "NV_LoadKey blob requires both owner and blob authorization.";
                break;
            case 0x8028003C:
                result = "The NV area is locked and not writable.";
                break;
            case 0x8028003D:
                result = "The locality is incorrect for the attempted operation.";
                break;
            case 0x8028003E:
                result = "The NV area is read-only and cannot be written to.";
                break;
            case 0x8028003F:
                result = "There is no protection on the write to the NV area.";
                break;
            case 0x80280040:
                result = "The family count value does not match.";
                break;
            case 0x80280041:
                result = "The NV area has already been written to.";
                break;
            case 0x80280042:
                result = "The NV area attributes conflict.";
                break;
            case 0x80280043:
                result = "The structure tag and version are invalid or inconsistent.";
                break;
            case 0x80280044:
                result = "The key is under control of the TPM owner and can only be evicted by the TPM owner.";
                break;
            case 0x80280045:
                result = "The counter handle is incorrect.";
                break;
            case 0x80280046:
                result = "The write is not a complete write of the area.";
                break;
            case 0x80280047:
                result = "The gap between saved context counts is too large.";
                break;
            case 0x80280048:
                result = "The maximum number of NV writes without an owner has been exceeded.";
                break;
            case 0x80280049:
                result = "No operator AuthData value is set.";
                break;
            case 0x8028004A:
                result = "The resource pointed to by context is not loaded.";
                break;
            case 0x8028004B:
                result = "The delegate administration is locked.";
                break;
            case 0x8028004C:
                result = "Attempt to manage a family other then the delegated family.";
                break;
            case 0x8028004D:
                result = "Delegation table management not enabled.";
                break;
            case 0x8028004E:
                result = "There was a command executed outside an exclusive transport session.";
                break;
            case 0x8028004F:
                result = "Attempt to context save an owner evict controlled key.";
                break;
            case 0x80280050:
                result = "The DAA command has no resources available to execute the command.";
                break;
            case 0x80280051:
                result = "The consistency check on DAA parameter inputData0 has failed.";
                break;
            case 0x80280052:
                result = "The consistency check on DAA parameter inputData1 has failed.";
                break;
            case 0x80280053:
                result = "The consistency check on DAA_issuerSettings has failed.";
                break;
            case 0x80280054:
                result = "The consistency check on DAA_tpmSpecific has failed.";
                break;
            case 0x80280055:
                result = "The atomic process indicated by the submitted DAA command is not the expected process.";
                break;
            case 0x80280056:
                result = "The issuer's validity check has detected an inconsistency.";
                break;
            case 0x80280057:
                result = "The consistency check on w has failed.";
                break;
            case 0x80280058:
                result = "The handle is incorrect.";
                break;
            case 0x80280059:
                result = "Delegation is not correct.";
                break;
            case 0x8028005A:
                result = "The context blob is invalid.";
                break;
            case 0x8028005B:
                result = "Too many contexts held by the TPM.";
                break;
            case 0x8028005C:
                result = "Migration authority signature validation failure.";
                break;
            case 0x8028005D:
                result = "Migration destination not authenticated.";
                break;
            case 0x8028005E:
                result = "Migration source incorrect.";
                break;
            case 0x8028005F:
                result = "Incorrect migration authority.";
                break;
            case 0x80280061:
                result = "Attempt to revoke the EK and the EK is not revocable.";
                break;
            case 0x80280062:
                result = "Bad signature of CMK ticket.";
                break;
            case 0x80280063:
                result = "There is no room in the context list for additional contexts.";
                break;
            case 0x80280400:
                result = "The command was blocked.";
                break;
            case 0x80280401:
                result = "The specified handle was not found.";
                break;
            case 0x80280402:
                result = "The TPM returned a duplicate handle and the command needs to be resubmitted.";
                break;
            case 0x80280403:
                result = "The command within the transport was blocked.";
                break;
            case 0x80280404:
                result = "The command within the transport is not supported.";
                break;
            case 0x80280800:
                result = "The TPM is too busy to respond to the command immediately, but the command could be resubmitted at a later time.";
                break;
            case 0x80280801:
                result = "SelfTestFull has not been run.";
                break;
            case 0x80280802:
                result = "The TPM is currently executing a full self-test.";
                break;
            case 0x80280803:
                result = "The TPM is defending against dictionary attacks and is in a time-out period.";
                break;
            case 0x80284001:
                result = "An internal software error has been detected.";
                break;
            case 0x80284002:
                result = "One or more input parameters are bad.";
                break;
            case 0x80284003:
                result = "A specified output pointer is bad.";
                break;
            case 0x80284004:
                result = "The specified context handle does not refer to a valid context.";
                break;
            case 0x80284005:
                result = "A specified output buffer is too small.";
                break;
            case 0x80284006:
                result = "An error occurred while communicating with the TPM.";
                break;
            case 0x80284007:
                result = "One or more context parameters are invalid.";
                break;
            case 0x80284008:
                result = "The TPM Base Services (TBS) is not running and could not be started.";
                break;
            case 0x80284009:
                result = "A new context could not be created because there are too many open contexts.";
                break;
            case 0x8028400A:
                result = "A new virtual resource could not be created because there are too many open virtual resources.";
                break;
            case 0x8028400B:
                result = "The TBS service has been started but is not yet running.";
                break;
            case 0x8028400C:
                result = "The physical presence interface is not supported.";
                break;
            case 0x8028400D:
                result = "The command was canceled.";
                break;
            case 0x8028400E:
                result = "The input or output buffer is too large.";
                break;
            case 0x80290100:
                result = "The command buffer is not in the correct state.";
                break;
            case 0x80290101:
                result = "The command buffer does not contain enough data to satisfy the request.";
                break;
            case 0x80290102:
                result = "The command buffer cannot contain any more data.";
                break;
            case 0x80290103:
                result = "One or more output parameters was null or invalid.";
                break;
            case 0x80290104:
                result = "One or more input parameters are invalid.";
                break;
            case 0x80290105:
                result = "Not enough memory was available to satisfy the request.";
                break;
            case 0x80290106:
                result = "The specified buffer was too small.";
                break;
            case 0x80290107:
                result = "An internal error was detected.";
                break;
            case 0x80290108:
                result = "The caller does not have the appropriate rights to perform the requested operation.";
                break;
            case 0x80290109:
                result = "The specified authorization information was invalid.";
                break;
            case 0x8029010A:
                result = "The specified context handle was not valid.";
                break;
            case 0x8029010B:
                result = "An error occurred while communicating with the TBS.";
                break;
            case 0x8029010C:
                result = "The TPM returned an unexpected result.";
                break;
            case 0x8029010D:
                result = "The message was too large for the encoding scheme.";
                break;
            case 0x8029010E:
                result = "The encoding in the binary large object (BLOB) was not recognized.";
                break;
            case 0x8029010F:
                result = "The key size is not valid.";
                break;
            case 0x80290110:
                result = "The encryption operation failed.";
                break;
            case 0x80290111:
                result = "The key parameters structure was not valid.";
                break;
            case 0x80290112:
                result = "The requested supplied data does not appear to be a valid migration authorization BLOB.";
                break;
            case 0x80290113:
                result = "The specified PCR index was invalid.";
                break;
            case 0x80290114:
                result = "The data given does not appear to be a valid delegate BLOB.";
                break;
            case 0x80290115:
                result = "One or more of the specified context parameters was not valid.";
                break;
            case 0x80290116:
                result = "The data given does not appear to be a valid key BLOB.";
                break;
            case 0x80290117:
                result = "The specified PCR data was invalid.";
                break;
            case 0x80290118:
                result = "The format of the owner authorization data was invalid.";
                break;
            case 0x80290200:
                result = "The specified buffer was too small.";
                break;
            case 0x80290201:
                result = "The context could not be cleaned up.";
                break;
            case 0x80290202:
                result = "The specified context handle is invalid.";
                break;
            case 0x80290203:
                result = "An invalid context parameter was specified.";
                break;
            case 0x80290204:
                result = "An error occurred while communicating with the TPM.";
                break;
            case 0x80290205:
                result = "No entry with the specified key was found.";
                break;
            case 0x80290206:
                result = "The specified virtual handle matches a virtual handle already in use.";
                break;
            case 0x80290207:
                result = "The pointer to the returned handle location was null or invalid.";
                break;
            case 0x80290208:
                result = "One or more parameters are invalid.";
                break;
            case 0x80290209:
                result = "The RPC subsystem could not be initialized.";
                break;
            case 0x8029020A:
                result = "The TBS scheduler is not running.";
                break;
            case 0x8029020B:
                result = "The command was canceled.";
                break;
            case 0x8029020C:
                result = "There was not enough memory to fulfill the request.";
                break;
            case 0x8029020D:
                result = "The specified list is empty, or the iteration has reached the end of the list.";
                break;
            case 0x8029020E:
                result = "The specified item was not found in the list.";
                break;
            case 0x8029020F:
                result = "The TPM does not have enough space to load the requested resource.";
                break;
            case 0x80290210:
                result = "There are too many TPM contexts in use.";
                break;
            case 0x80290211:
                result = "The TPM command failed.";
                break;
            case 0x80290212:
                result = "The TBS does not recognize the specified ordinal.";
                break;
            case 0x80290213:
                result = "The requested resource is no longer available.";
                break;
            case 0x80290214:
                result = "The resource type did not match.";
                break;
            case 0x80290215:
                result = "No resources can be unloaded.";
                break;
            case 0x80290216:
                result = "No new entries can be added to the hash table.";
                break;
            case 0x80290217:
                result = "A new TBS context could not be created because there are too many open contexts.";
                break;
            case 0x80290218:
                result = "A new virtual resource could not be created because there are too many open virtual resources.";
                break;
            case 0x80290219:
                result = "The physical presence interface is not supported.";
                break;
            case 0x8029021A:
                result = "TBS is not compatible with the version of TPM found on the system.";
                break;
            case 0x80290300:
                result = "A general error was detected when attempting to acquire the BIOS response to a physical presence command.";
                break;
            case 0x80290301:
                result = "The user failed to confirm the TPM operation request.";
                break;
            case 0x80290302:
                result = "The BIOS failure prevented the successful execution of the requested TPM operation (for example, invalid TPM operation request, BIOS communication error with the TPM).";
                break;
            case 0x80290303:
                result = "The BIOS does not support the physical presence interface.";
                break;
            case 0x80300002:
                result = "A Data Collector Set was not found.";
                break;
            case 0x80300045:
                result = "Unable to start Data Collector Set because there are too many folders.";
                break;
            case 0x80300070:
                result = "Not enough free disk space to start Data Collector Set.";
                break;
            case 0x803000AA:
                result = "Data Collector Set is in use.";
                break;
            case 0x803000B7:
                result = "Data Collector Set already exists.";
                break;
            case 0x80300101:
                result = "Property value conflict.";
                break;
            case 0x80300102:
                result = "The current configuration for this Data Collector Set requires that it contain exactly one Data Collector.";
                break;
            case 0x80300103:
                result = "A user account is required to commit the current Data Collector Set properties.";
                break;
            case 0x80300104:
                result = "Data Collector Set is not running.";
                break;
            case 0x80300105:
                result = "A conflict was detected in the list of include and exclude APIs. Do not specify the same API in both the include list and the exclude list.";
                break;
            case 0x80300106:
                result = "The executable path specified refers to a network share or UNC path.";
                break;
            case 0x80300107:
                result = "The executable path specified is already configured for API tracing.";
                break;
            case 0x80300108:
                result = "The executable path specified does not exist. Verify that the specified path is correct.";
                break;
            case 0x80300109:
                result = "Data Collector already exists.";
                break;
            case 0x8030010A:
                result = "The wait for the Data Collector Set start notification has timed out.";
                break;
            case 0x8030010B:
                result = "The wait for the Data Collector to start has timed out.";
                break;
            case 0x8030010C:
                result = "The wait for the report generation tool to finish has timed out.";
                break;
            case 0x8030010D:
                result = "Duplicate items are not allowed.";
                break;
            case 0x8030010E:
                result = "When specifying the executable to trace, you must specify a full path to the executable and not just a file name.";
                break;
            case 0x8030010F:
                result = "The session name provided is invalid.";
                break;
            case 0x80300110:
                result = "The Event Log channel Microsoft-Windows-Diagnosis-PLA/Operational must be enabled to perform this operation.";
                break;
            case 0x80300111:
                result = "The Event Log channel Microsoft-Windows-TaskScheduler must be enabled to perform this operation.";
                break;
            case 0x80310000:
                result = "The volume must be unlocked before it can be used.";
                break;
            case 0x80310001:
                result = "The volume is fully decrypted and no key is available.";
                break;
            case 0x80310002:
                result = "The firmware does not support using a TPM during boot.";
                break;
            case 0x80310003:
                result = "The firmware does not use a TPM to perform initial program load (IPL) measurement.";
                break;
            case 0x80310004:
                result = "The master boot record (MBR) is not TPM-aware.";
                break;
            case 0x80310005:
                result = "The BOOTMGR is not being measured by the TPM.";
                break;
            case 0x80310006:
                result = "The BOOTMGR component does not perform expected TPM measurements.";
                break;
            case 0x80310007:
                result = "No secure key protection mechanism has been defined.";
                break;
            case 0x80310008:
                result = "This volume has not been provisioned for encryption.";
                break;
            case 0x80310009:
                result = "Requested action was denied by the full-volume encryption (FVE) control engine.";
                break;
            case 0x8031000A:
                result = "The Active Directory forest does not contain the required attributes and classes to host FVE or TPM information.";
                break;
            case 0x8031000B:
                result = "The type of data obtained from Active Directory was not expected.";
                break;
            case 0x8031000C:
                result = "The size of the data obtained from Active Directory was not expected.";
                break;
            case 0x8031000D:
                result = "The attribute read from Active Directory has no (zero) values.";
                break;
            case 0x8031000E:
                result = "The attribute was not set.";
                break;
            case 0x8031000F:
                result = "The specified GUID could not be found.";
                break;
            case 0x80310010:
                result = "The control block for the encrypted volume is not valid.";
                break;
            case 0x80310011:
                result = "Not enough free space remaining on volume to allow encryption.";
                break;
            case 0x80310012:
                result = "The volume cannot be encrypted because it is required to boot the operating system.";
                break;
            case 0x80310013:
                result = "The volume cannot be encrypted because the file system is not supported.";
                break;
            case 0x80310014:
                result = "The file system is inconsistent. Run CHKDSK.";
                break;
            case 0x80310015:
                result = "This volume cannot be encrypted.";
                break;
            case 0x80310016:
                result = "Data supplied is malformed.";
                break;
            case 0x80310017:
                result = "Volume is not bound to the system.";
                break;
            case 0x80310018:
                result = "TPM must be owned before a volume can be bound to it.";
                break;
            case 0x80310019:
                result = "The volume specified is not a data volume.";
                break;
            case 0x8031001A:
                result = "The buffer supplied to a function was insufficient to contain the returned data.";
                break;
            case 0x8031001B:
                result = "A read operation failed while converting the volume.";
                break;
            case 0x8031001C:
                result = "A write operation failed while converting the volume.";
                break;
            case 0x8031001D:
                result = "One or more key protection mechanisms are required for this volume.";
                break;
            case 0x8031001E:
                result = "Cluster configurations are not supported.";
                break;
            case 0x8031001F:
                result = "The volume is already bound to the system.";
                break;
            case 0x80310020:
                result = "The boot OS volume is not being protected via FVE.";
                break;
            case 0x80310021:
                result = "All protection mechanisms are effectively disabled (clear key exists).";
                break;
            case 0x80310022:
                result = "A recovery key protection mechanism is required.";
                break;
            case 0x80310023:
                result = "This volume cannot be bound to a TPM.";
                break;
            case 0x80310024:
                result = "The control block for the encrypted volume was updated by another thread. Try again.";
                break;
            case 0x80310025:
                result = "The SRK authentication of the TPM is not zero and, therefore, is not compatible.";
                break;
            case 0x80310026:
                result = "The volume encryption algorithm cannot be used on this sector size.";
                break;
            case 0x80310027:
                result = "BitLocker recovery authentication failed.";
                break;
            case 0x80310028:
                result = "The volume specified is not the boot OS volume.";
                break;
            case 0x80310029:
                result = "Auto-unlock information for data volumes is present on the boot OS volume.";
                break;
            case 0x8031002A:
                result = "The system partition boot sector does not perform TPM measurements.";
                break;
            case 0x8031002B:
                result = "The system partition file system must be NTFS.";
                break;
            case 0x8031002C:
                result = "Group policy requires a recovery password before encryption can begin.";
                break;
            case 0x8031002D:
                result = "The volume encryption algorithm and key cannot be set on an encrypted volume.";
                break;
            case 0x8031002E:
                result = "A key must be specified before encryption can begin.";
                break;
            case 0x80310030:
                result = "A bootable CD/DVD is in the system. Remove the CD/DVD and reboot the system.";
                break;
            case 0x80310031:
                result = "An instance of this key protector already exists on the volume.";
                break;
            case 0x80310032:
                result = "The file cannot be saved to a relative path.";
                break;
            case 0x80320001:
                result = "The callout does not exist.";
                break;
            case 0x80320002:
                result = "The filter condition does not exist.";
                break;
            case 0x80320003:
                result = "The filter does not exist.";
                break;
            case 0x80320004:
                result = "The layer does not exist.";
                break;
            case 0x80320005:
                result = "The provider does not exist.";
                break;
            case 0x80320006:
                result = "The provider context does not exist.";
                break;
            case 0x80320007:
                result = "The sublayer does not exist.";
                break;
            case 0x80320008:
                result = "The object does not exist.";
                break;
            case 0x80320009:
                result = "An object with that GUID or LUID already exists.";
                break;
            case 0x8032000A:
                result = "The object is referenced by other objects and, therefore, cannot be deleted.";
                break;
            case 0x8032000B:
                result = "The call is not allowed from within a dynamic session.";
                break;
            case 0x8032000C:
                result = "The call was made from the wrong session and, therefore, cannot be completed.";
                break;
            case 0x8032000D:
                result = "The call must be made from within an explicit transaction.";
                break;
            case 0x8032000E:
                result = "The call is not allowed from within an explicit transaction.";
                break;
            case 0x8032000F:
                result = "The explicit transaction has been forcibly canceled.";
                break;
            case 0x80320010:
                result = "The session has been canceled.";
                break;
            case 0x80320011:
                result = "The call is not allowed from within a read-only transaction.";
                break;
            case 0x80320012:
                result = "The call timed out while waiting to acquire the transaction lock.";
                break;
            case 0x80320013:
                result = "Collection of network diagnostic events is disabled.";
                break;
            case 0x80320014:
                result = "The operation is not supported by the specified layer.";
                break;
            case 0x80320015:
                result = "The call is allowed for kernel-mode callers only.";
                break;
            case 0x80320016:
                result = "The call tried to associate two objects with incompatible lifetimes.";
                break;
            case 0x80320017:
                result = "The object is built in and, therefore, cannot be deleted.";
                break;
            case 0x80320018:
                result = "The maximum number of boot-time filters has been reached.";
                break;
            case 0x80320019:
                result = "A notification could not be delivered because a message queue is at its maximum capacity.";
                break;
            case 0x8032001A:
                result = "The traffic parameters do not match those for the security association context.";
                break;
            case 0x8032001B:
                result = "The call is not allowed for the current security association state.";
                break;
            case 0x8032001C:
                result = "A required pointer is null.";
                break;
            case 0x8032001D:
                result = "An enumerator is not valid.";
                break;
            case 0x8032001E:
                result = "The flags field contains an invalid value.";
                break;
            case 0x8032001F:
                result = "A network mask is not valid.";
                break;
            case 0x80320020:
                result = "An FWP_RANGE is not valid.";
                break;
            case 0x80320021:
                result = "The time interval is not valid.";
                break;
            case 0x80320022:
                result = "An array that must contain at least one element that is zero-length.";
                break;
            case 0x80320023:
                result = "The displayData.name field cannot be null.";
                break;
            case 0x80320024:
                result = "The action type is not one of the allowed action types for a filter.";
                break;
            case 0x80320025:
                result = "The filter weight is not valid.";
                break;
            case 0x80320026:
                result = "A filter condition contains a match type that is not compatible with the operands.";
                break;
            case 0x80320027:
                result = "An FWP_VALUE or FWPM_CONDITION_VALUE is of the wrong type.";
                break;
            case 0x80320028:
                result = "An integer value is outside the allowed range.";
                break;
            case 0x80320029:
                result = "A reserved field is nonzero.";
                break;
            case 0x8032002A:
                result = "A filter cannot contain multiple conditions operating on a single field.";
                break;
            case 0x8032002B:
                result = "A policy cannot contain the same keying module more than once.";
                break;
            case 0x8032002C:
                result = "The action type is not compatible with the layer.";
                break;
            case 0x8032002D:
                result = "The action type is not compatible with the sublayer.";
                break;
            case 0x8032002E:
                result = "The raw context or the provider context is not compatible with the layer.";
                break;
            case 0x8032002F:
                result = "The raw context or the provider context is not compatible with the callout.";
                break;
            case 0x80320030:
                result = "The authentication method is not compatible with the policy type.";
                break;
            case 0x80320031:
                result = "The Diffie-Hellman group is not compatible with the policy type.";
                break;
            case 0x80320032:
                result = "An Internet Key Exchange (IKE) policy cannot contain an Extended Mode policy.";
                break;
            case 0x80320033:
                result = "The enumeration template or subscription will never match any objects.";
                break;
            case 0x80320034:
                result = "The provider context is of the wrong type.";
                break;
            case 0x80320035:
                result = "The parameter is incorrect.";
                break;
            case 0x80320036:
                result = "The maximum number of sublayers has been reached.";
                break;
            case 0x80320037:
                result = "The notification function for a callout returned an error.";
                break;
            case 0x80320038:
                result = "The IPsec authentication configuration is not compatible with the authentication type.";
                break;
            case 0x80320039:
                result = "The IPsec cipher configuration is not compatible with the cipher type.";
                break;
            case 0x80340002:
                result = "The binding to the network interface is being closed.";
                break;
            case 0x80340004:
                result = "An invalid version was specified.";
                break;
            case 0x80340005:
                result = "An invalid characteristics table was used.";
                break;
            case 0x80340006:
                result = "Failed to find the network interface, or the network interface is not ready.";
                break;
            case 0x80340007:
                result = "Failed to open the network interface.";
                break;
            case 0x80340008:
                result = "The network interface has encountered an internal unrecoverable failure.";
                break;
            case 0x80340009:
                result = "The multicast list on the network interface is full.";
                break;
            case 0x8034000A:
                result = "An attempt was made to add a duplicate multicast address to the list.";
                break;
            case 0x8034000B:
                result = "At attempt was made to remove a multicast address that was never added.";
                break;
            case 0x8034000C:
                result = "The network interface aborted the request.";
                break;
            case 0x8034000D:
                result = "The network interface cannot process the request because it is being reset.";
                break;
            case 0x8034000F:
                result = "An attempt was made to send an invalid packet on a network interface.";
                break;
            case 0x80340010:
                result = "The specified request is not a valid operation for the target device.";
                break;
            case 0x80340011:
                result = "The network interface is not ready to complete this operation.";
                break;
            case 0x80340014:
                result = "The length of the buffer submitted for this operation is not valid.";
                break;
            case 0x80340015:
                result = "The data used for this operation is not valid.";
                break;
            case 0x80340016:
                result = "The length of the buffer submitted for this operation is too small.";
                break;
            case 0x80340017:
                result = "The network interface does not support this OID.";
                break;
            case 0x80340018:
                result = "The network interface has been removed.";
                break;
            case 0x80340019:
                result = "The network interface does not support this media type.";
                break;
            case 0x8034001A:
                result = "An attempt was made to remove a token ring group address that is in use by other components.";
                break;
            case 0x8034001B:
                result = "An attempt was made to map a file that cannot be found.";
                break;
            case 0x8034001C:
                result = "An error occurred while the NDIS tried to map the file.";
                break;
            case 0x8034001D:
                result = "An attempt was made to map a file that is already mapped.";
                break;
            case 0x8034001E:
                result = "An attempt to allocate a hardware resource failed because the resource is used by another component.";
                break;
            case 0x8034001F:
                result = "The I/O operation failed because network media is disconnected or the wireless access point is out of range.";
                break;
            case 0x80340022:
                result = "The network address used in the request is invalid.";
                break;
            case 0x8034002A:
                result = "The offload operation on the network interface has been paused.";
                break;
            case 0x8034002B:
                result = "The network interface was not found.";
                break;
            case 0x8034002C:
                result = "The revision number specified in the structure is not supported.";
                break;
            case 0x8034002D:
                result = "The specified port does not exist on this network interface.";
                break;
            case 0x8034002E:
                result = "The current state of the specified port on this network interface does not support the requested operation.";
                break;
            case 0x803400BB:
                result = "The network interface does not support this request.";
                break;
            case 0x80342000:
                result = "The wireless local area network (LAN) interface is in auto-configuration mode and does not support the requested parameter change operation.";
                break;
            case 0x80342001:
                result = "The wireless LAN interface is busy and cannot perform the requested operation.";
                break;
            case 0x80342002:
                result = "The wireless LAN interface is shutting down and does not support the requested operation.";
                break;
            case 0x8DEAD01B:
                result = "A requested object was not found.";
                break;
            case 0x8DEAD01C:
                result = "The server received a CREATE_VOLUME subrequest of a SYNC_VOLUMES request, but the ServerVolumeTable size limit for the RequestMachine has already been reached.";
                break;
            case 0x8DEAD01E:
                result = "The server is busy, and the client should retry the request at a later time.";
                break;
            case 0xC0090001:
                result = "The specified event is currently not being audited.";
                break;
            case 0xC0090002:
                result = "The SID filtering operation removed all SIDs.";
                break;
            case 0xC0090003:
                result = "Business rule scripts are disabled for the calling application.";
                break;
            case 0xC00D0005:
                result = "There is no connection established with the Windows Media server. The operation failed.";
                break;
            case 0xC00D0006:
                result = "Unable to establish a connection to the server.";
                break;
            case 0xC00D0007:
                result = "Unable to destroy the title.";
                break;
            case 0xC00D0008:
                result = "Unable to rename the title.";
                break;
            case 0xC00D0009:
                result = "Unable to offline disk.";
                break;
            case 0xC00D000A:
                result = "Unable to online disk.";
                break;
            case 0xC00D000B:
                result = "There is no file parser registered for this type of file.";
                break;
            case 0xC00D000C:
                result = "There is no data connection established.";
                break;
            case 0xC00D000D:
                result = "Failed to load the local play DLL.";
                break;
            case 0xC00D000E:
                result = "The network is busy.";
                break;
            case 0xC00D000F:
                result = "The server session limit was exceeded.";
                break;
            case 0xC00D0010:
                result = "The network connection already exists.";
                break;
            case 0xC00D0011:
                result = "Index %1 is invalid.";
                break;
            case 0xC00D0012:
                result = "There is no protocol or protocol version supported by both the client and the server.";
                break;
            case 0xC00D0013:
                result = "The server, a computer set up to offer multimedia content to other computers, could not handle your request for multimedia content in a timely manner. Please try again later.";
                break;
            case 0xC00D0014:
                result = "Error writing to the network.";
                break;
            case 0xC00D0015:
                result = "Error reading from the network.";
                break;
            case 0xC00D0016:
                result = "Error writing to a disk.";
                break;
            case 0xC00D0017:
                result = "Error reading from a disk.";
                break;
            case 0xC00D0018:
                result = "Error writing to a file.";
                break;
            case 0xC00D0019:
                result = "Error reading from a file.";
                break;
            case 0xC00D001A:
                result = "The system cannot find the file specified.";
                break;
            case 0xC00D001B:
                result = "The file already exists.";
                break;
            case 0xC00D001C:
                result = "The file name, directory name, or volume label syntax is incorrect.";
                break;
            case 0xC00D001D:
                result = "Failed to open a file.";
                break;
            case 0xC00D001E:
                result = "Unable to allocate a file.";
                break;
            case 0xC00D001F:
                result = "Unable to initialize a file.";
                break;
            case 0xC00D0020:
                result = "Unable to play a file.";
                break;
            case 0xC00D0021:
                result = "Could not set the disk UID.";
                break;
            case 0xC00D0022:
                result = "An error was induced for testing purposes.";
                break;
            case 0xC00D0023:
                result = "Two Content Servers failed to communicate.";
                break;
            case 0xC00D0024:
                result = "An unknown error occurred.";
                break;
            case 0xC00D0025:
                result = "The requested resource is in use.";
                break;
            case 0xC00D0026:
                result = "The specified protocol is not recognized. Be sure that the file name and syntax, such as slashes, are correct for the protocol.";
                break;
            case 0xC00D0027:
                result = "The network service provider failed.";
                break;
            case 0xC00D0028:
                result = "An attempt to acquire a network resource failed.";
                break;
            case 0xC00D0029:
                result = "The network connection has failed.";
                break;
            case 0xC00D002A:
                result = "The session is being terminated locally.";
                break;
            case 0xC00D002B:
                result = "The request is invalid in the current state.";
                break;
            case 0xC00D002C:
                result = "There is insufficient bandwidth available to fulfill the request.";
                break;
            case 0xC00D002D:
                result = "The disk is not rebuilding.";
                break;
            case 0xC00D002E:
                result = "An operation requested for a particular time could not be carried out on schedule.";
                break;
            case 0xC00D002F:
                result = "Invalid or corrupt data was encountered.";
                break;
            case 0xC00D0030:
                result = "The bandwidth required to stream a file is higher than the maximum file bandwidth allowed on the server.";
                break;
            case 0xC00D0031:
                result = "The client cannot have any more files open simultaneously.";
                break;
            case 0xC00D0032:
                result = "The server received invalid data from the client on the control connection.";
                break;
            case 0xC00D0033:
                result = "There is no stream available.";
                break;
            case 0xC00D0034:
                result = "There is no more data in the stream.";
                break;
            case 0xC00D0035:
                result = "The specified server could not be found.";
                break;
            case 0xC00D0036:
                result = "The specified name is already in use.";
                break;
            case 0xC00D0037:
                result = "The specified address is already in use.";
                break;
            case 0xC00D0038:
                result = "The specified address is not a valid multicast address.";
                break;
            case 0xC00D0039:
                result = "The specified adapter address is invalid.";
                break;
            case 0xC00D003A:
                result = "The specified delivery mode is invalid.";
                break;
            case 0xC00D003B:
                result = "The specified station does not exist.";
                break;
            case 0xC00D003C:
                result = "The specified stream does not exist.";
                break;
            case 0xC00D003D:
                result = "The specified archive could not be opened.";
                break;
            case 0xC00D003E:
                result = "The system cannot find any titles on the server.";
                break;
            case 0xC00D003F:
                result = "The system cannot find the client specified.";
                break;
            case 0xC00D0040:
                result = "The Blackhole Address is not initialized.";
                break;
            case 0xC00D0041:
                result = "The station does not support the stream format.";
                break;
            case 0xC00D0042:
                result = "The specified key is not valid.";
                break;
            case 0xC00D0043:
                result = "The specified port is not valid.";
                break;
            case 0xC00D0044:
                result = "The specified TTL is not valid.";
                break;
            case 0xC00D0045:
                result = "The request to fast forward or rewind could not be fulfilled.";
                break;
            case 0xC00D0046:
                result = "Unable to load the appropriate file parser.";
                break;
            case 0xC00D0047:
                result = "Cannot exceed the maximum bandwidth limit.";
                break;
            case 0xC00D0048:
                result = "Invalid value for LogFilePeriod.";
                break;
            case 0xC00D0049:
                result = "Cannot exceed the maximum client limit.";
                break;
            case 0xC00D004A:
                result = "The maximum log file size has been reached.";
                break;
            case 0xC00D004B:
                result = "Cannot exceed the maximum file rate.";
                break;
            case 0xC00D004C:
                result = "Unknown file type.";
                break;
            case 0xC00D004D:
                result = "The specified file, %1, cannot be loaded onto the specified server, %2.";
                break;
            case 0xC00D004E:
                result = "There was a usage error with file parser.";
                break;
            case 0xC00D0050:
                result = "The Title Server %1 has failed.";
                break;
            case 0xC00D0053:
                result = "Content Server %1 (%2) has failed.";
                break;
            case 0xC00D0055:
                result = "Disk %1 ( %2 ) on Content Server %3, has failed.";
                break;
            case 0xC00D0060:
                result = "The NetShow data stream limit of %1 streams was reached.";
                break;
            case 0xC00D0061:
                result = "The NetShow Video Server was unable to allocate a %1 block file named %2.";
                break;
            case 0xC00D0062:
                result = "A Content Server was unable to page a block.";
                break;
            case 0xC00D0063:
                result = "Disk %1 has unrecognized control block version %2.";
                break;
            case 0xC00D0064:
                result = "Disk %1 has incorrect uid %2.";
                break;
            case 0xC00D0065:
                result = "Disk %1 has unsupported file system major version %2.";
                break;
            case 0xC00D0066:
                result = "Disk %1 has bad stamp number in control block.";
                break;
            case 0xC00D0067:
                result = "Disk %1 is partially reconstructed.";
                break;
            case 0xC00D0068:
                result = "EnactPlan gives up.";
                break;
            case 0xC00D006A:
                result = "The key was not found in the registry.";
                break;
            case 0xC00D006B:
                result = "The publishing point cannot be started because the server does not have the appropriate stream formats. Use the Multicast Announcement Wizard to create a new announcement for this publishing point.";
                break;
            case 0xC00D006C:
                result = "No reference URLs were found in an ASX file.";
                break;
            case 0xC00D006D:
                result = "Error opening wave device, the device might be in use.";
                break;
            case 0xC00D006F:
                result = "Unable to establish a connection to the NetShow event monitor service.";
                break;
            case 0xC00D0071:
                result = "No device driver is present on the system.";
                break;
            case 0xC00D0072:
                result = "No specified device driver is present.";
                break;
            case 0xC00D00C8:
                result = "Netshow Events Monitor is not operational and has been disconnected.";
                break;
            case 0xC00D00C9:
                result = "Disk %1 is remirrored.";
                break;
            case 0xC00D00CA:
                result = "Insufficient data found.";
                break;
            case 0xC00D00CB:
                result = "1 failed in file %2 line %3.";
                break;
            case 0xC00D00CC:
                result = "The specified adapter name is invalid.";
                break;
            case 0xC00D00CD:
                result = "The application is not licensed for this feature.";
                break;
            case 0xC00D00CE:
                result = "Unable to contact the server.";
                break;
            case 0xC00D00CF:
                result = "Maximum number of titles exceeded.";
                break;
            case 0xC00D00D0:
                result = "Maximum size of a title exceeded.";
                break;
            case 0xC00D00D1:
                result = "UDP protocol not enabled. Not trying %1!ls!.";
                break;
            case 0xC00D00D2:
                result = "TCP protocol not enabled. Not trying %1!ls!.";
                break;
            case 0xC00D00D3:
                result = "HTTP protocol not enabled. Not trying %1!ls!.";
                break;
            case 0xC00D00D4:
                result = "The product license has expired.";
                break;
            case 0xC00D00D5:
                result = "Source file exceeds the per title maximum bitrate. See NetShow Theater documentation for more information.";
                break;
            case 0xC00D00D6:
                result = "The program name cannot be empty.";
                break;
            case 0xC00D00D7:
                result = "Station %1 does not exist.";
                break;
            case 0xC00D00D8:
                result = "You need to define at least one station before this operation can complete.";
                break;
            case 0xC00D00D9:
                result = "The index specified is invalid.";
                break;
            case 0xC00D0190:
                result = "Content Server %1 (%2) has failed its link to Content Server %3.";
                break;
            case 0xC00D0192:
                result = "Content Server %1 (%2) has incorrect uid %3.";
                break;
            case 0xC00D0195:
                result = "Server unreliable because multiple components failed.";
                break;
            case 0xC00D019B:
                result = "Content Server %1 (%2) is unable to communicate with the Media System Network Protocol.";
                break;
            case 0xC00D07F1:
                result = "Nothing to do.";
                break;
            case 0xC00D07F2:
                result = "Not receiving data from the server.";
                break;
            case 0xC00D0BB8:
                result = "The input media format is invalid.";
                break;
            case 0xC00D0BB9:
                result = "The MSAudio codec is not installed on this system.";
                break;
            case 0xC00D0BBA:
                result = "An unexpected error occurred with the MSAudio codec.";
                break;
            case 0xC00D0BBB:
                result = "The output media format is invalid.";
                break;
            case 0xC00D0BBC:
                result = "The object must be fully configured before audio samples can be processed.";
                break;
            case 0xC00D0BBD:
                result = "You need a license to perform the requested operation on this media file.";
                break;
            case 0xC00D0BBE:
                result = "You need a license to perform the requested operation on this media file.";
                break;
            case 0xC00D0BBF:
                result = "This media file is corrupted or invalid. Contact the content provider for a new file.";
                break;
            case 0xC00D0BC0:
                result = "The license for this media file has expired. Get a new license or contact the content provider for further assistance.";
                break;
            case 0xC00D0BC1:
                result = "You are not allowed to open this file. Contact the content provider for further assistance.";
                break;
            case 0xC00D0BC2:
                result = "The requested audio codec is not installed on this system.";
                break;
            case 0xC00D0BC3:
                result = "An unexpected error occurred with the audio codec.";
                break;
            case 0xC00D0BC4:
                result = "The requested video codec is not installed on this system.";
                break;
            case 0xC00D0BC5:
                result = "An unexpected error occurred with the video codec.";
                break;
            case 0xC00D0BC6:
                result = "The Profile is invalid.";
                break;
            case 0xC00D0BC7:
                result = "A new version of the SDK is needed to play the requested content.";
                break;
            case 0xC00D0BCA:
                result = "The requested URL is not available in offline mode.";
                break;
            case 0xC00D0BCB:
                result = "The requested URL cannot be accessed because there is no network connection.";
                break;
            case 0xC00D0BCC:
                result = "The encoding process was unable to keep up with the amount of supplied data.";
                break;
            case 0xC00D0BCD:
                result = "The given property is not supported.";
                break;
            case 0xC00D0BCE:
                result = "Windows Media Player cannot copy the files to the CD because they are 8-bit. Convert the files to 16-bit, 44-kHz stereo files by using Sound Recorder or another audio-processing program, and then try again.";
                break;
            case 0xC00D0BCF:
                result = "There are no more samples in the current range.";
                break;
            case 0xC00D0BD0:
                result = "The given sampling rate is invalid.";
                break;
            case 0xC00D0BD1:
                result = "The given maximum packet size is too small to accommodate this profile.)";
                break;
            case 0xC00D0BD2:
                result = "The packet arrived too late to be of use.";
                break;
            case 0xC00D0BD3:
                result = "The packet is a duplicate of one received before.";
                break;
            case 0xC00D0BD4:
                result = "Supplied buffer is too small.";
                break;
            case 0xC00D0BD5:
                result = "The wrong number of preprocessing passes was used for the stream's output type.";
                break;
            case 0xC00D0BD6:
                result = "An attempt was made to add, modify, or delete a read only attribute.";
                break;
            case 0xC00D0BD7:
                result = "An attempt was made to add attribute that is not allowed for the given media type.";
                break;
            case 0xC00D0BD8:
                result = "The EDL provided is invalid.";
                break;
            case 0xC00D0BD9:
                result = "The Data Unit Extension data was too large to be used.";
                break;
            case 0xC00D0BDA:
                result = "An unexpected error occurred with a DMO codec.";
                break;
            case 0xC00D0BDC:
                result = "This feature has been disabled by group policy.";
                break;
            case 0xC00D0BDD:
                result = "This feature is disabled in this SKU.";
                break;
            case 0xC00D0FA0:
                result = "There is no CD in the CD drive. Insert a CD, and then try again.";
                break;
            case 0xC00D0FA1:
                result = "Windows Media Player could not use digital playback to play the CD. To switch to analog playback, on the Tools menu, click Options, and then click the Devices tab. Double-click the CD drive, and then in the Playback area, click Analog. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FA2:
                result = "Windows Media Player no longer detects a connected portable device. Reconnect your portable device, and then try synchronizing the file again.";
                break;
            case 0xC00D0FA3:
                result = "Windows Media Player cannot play the file. The portable device does not support the specified file type.";
                break;
            case 0xC00D0FA4:
                result = "Windows Media Player could not use digital playback to play the CD. The Player has automatically switched the CD drive to analog playback. To switch back to digital CD playback, use the Devices tab. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FA5:
                result = "An invalid line error occurred in the mixer.";
                break;
            case 0xC00D0FA6:
                result = "An invalid control error occurred in the mixer.";
                break;
            case 0xC00D0FA7:
                result = "An invalid value error occurred in the mixer.";
                break;
            case 0xC00D0FA8:
                result = "An unrecognized MMRESULT occurred in the mixer.";
                break;
            case 0xC00D0FA9:
                result = "User has stopped the operation.";
                break;
            case 0xC00D0FAA:
                result = "Windows Media Player cannot rip the track because a compatible MP3 encoder is not installed on your computer. Install a compatible MP3 encoder or choose a different format to rip to (such as Windows Media Audio).";
                break;
            case 0xC00D0FAB:
                result = "Windows Media Player cannot read the CD. The disc might be dirty or damaged. Turn on error correction, and then try again.";
                break;
            case 0xC00D0FAC:
                result = "Windows Media Player cannot read the CD. The disc might be dirty or damaged or the CD drive might be malfunctioning.";
                break;
            case 0xC00D0FAD:
                result = "For best performance, do not play CD tracks while ripping them.";
                break;
            case 0xC00D0FAE:
                result = "It is not possible to directly burn tracks from one CD to another CD. You must first rip the tracks from the CD to your computer, and then burn the files to a blank CD.";
                break;
            case 0xC00D0FAF:
                result = "Could not open a sound mixer driver.";
                break;
            case 0xC00D0FB0:
                result = "Windows Media Player cannot rip tracks from the CD correctly because the CD drive settings in Device Manager do not match the CD drive settings in the Player.";
                break;
            case 0xC00D0FB1:
                result = "Windows Media Player is busy reading the CD.";
                break;
            case 0xC00D0FB2:
                result = "Windows Media Player could not use digital playback to play the CD. The Player has automatically switched the CD drive to analog playback. To switch back to digital CD playback, use the Devices tab. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FB3:
                result = "Windows Media Player could not use digital playback to play the CD. The Player has automatically switched the CD drive to analog playback. To switch back to digital CD playback, use the Devices tab. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FB4:
                result = "A call was made to GetParseError on the XML parser but there was no error to retrieve.";
                break;
            case 0xC00D0FB5:
                result = "The XML Parser ran out of data while parsing.";
                break;
            case 0xC00D0FB6:
                result = "A generic parse error occurred in the XML parser but no information is available.";
                break;
            case 0xC00D0FB7:
                result = "A call get GetNamedAttribute or GetNamedAttributeIndex on the XML parser resulted in the index not being found.";
                break;
            case 0xC00D0FB8:
                result = "A call was made go GetNamedPI on the XML parser, but the requested Processing Instruction was not found.";
                break;
            case 0xC00D0FB9:
                result = "Persist was called on the XML parser, but the parser has no data to persist.";
                break;
            case 0xC00D0FBA:
                result = "This file path is already in the library.";
                break;
            case 0xC00D0FBE:
                result = "Windows Media Player is already searching for files to add to your library. Wait for the current process to finish before attempting to search again.";
                break;
            case 0xC00D0FBF:
                result = "Windows Media Player is unable to find the media you are looking for.";
                break;
            case 0xC00D0FC0:
                result = "A component of Windows Media Player is out-of-date. If you are running a pre-release version of Windows, try upgrading to a more recent version.";
                break;
            case 0xC00D0FC1:
                result = "This container does not support search on items.";
                break;
            case 0xC00D0FC7:
                result = "Windows Media Player encountered a problem while adding one or more files to the library. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FC8:
                result = "A Windows API call failed but no error information was available.";
                break;
            case 0xC00D0FC9:
                result = "This file does not have burn rights. If you obtained this file from an online store, go to the online store to get burn rights.";
                break;
            case 0xC00D0FCA:
                result = "Windows Media Player no longer detects a connected portable device. Reconnect your portable device, and then try to sync the file again.";
                break;
            case 0xC00D0FCB:
                result = "Windows Media Player cannot play the file because it is corrupted.";
                break;
            case 0xC00D0FCC:
                result = "Windows Media Player encountered an error while attempting to access information in the library. Try restarting the Player.";
                break;
            case 0xC00D0FCD:
                result = "The file cannot be added to the library because it is smaller than the \"Skip files smaller than\" setting. To add the file, change the setting on the Library tab. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FCE:
                result = "Windows Media Player cannot create the library. You must be logged on as an administrator or a member of the Administrators group to install the Player. For more information, contact your system administrator.";
                break;
            case 0xC00D0FCF:
                result = "The file is already in use. Close other programs that might be using the file, or stop playing the file, and then try again.";
                break;
            case 0xC00D0FD0:
                result = "Windows Media Player has encountered an unknown error.";
                break;
            case 0xC00D0FD1:
                result = "The Windows Media Player ActiveX control cannot connect to remote media services, but will continue with local media services.";
                break;
            case 0xC00D0FD2:
                result = "The requested method or property is not available because the Windows Media Player ActiveX control has not been properly activated.";
                break;
            case 0xC00D0FD3:
                result = "The Windows Media Player ActiveX control is not running in remote mode.";
                break;
            case 0xC00D0FD4:
                result = "An error occurred while trying to get the remote Windows Media Player window.";
                break;
            case 0xC00D0FD5:
                result = "Windows Media Player has encountered an unknown error.";
                break;
            case 0xC00D0FD6:
                result = "Windows Media Player was not closed properly. A damaged or incompatible plug-in might have caused the problem to occur. As a precaution, all optional plug-ins have been disabled.";
                break;
            case 0xC00D0FD7:
                result = "Windows Media Player cannot find the specified path. Verify that the path is typed correctly. If it is, the path does not exist in the specified location, or the computer where the path is located is not available.";
                break;
            case 0xC00D0FD8:
                result = "Windows Media Player cannot save a file that is being streamed.";
                break;
            case 0xC00D0FD9:
                result = "Windows Media Player cannot find the selected plug-in. The Player will try to remove it from the menu. To use this plug-in, install it again.";
                break;
            case 0xC00D0FDA:
                result = "Action requires input from the user.";
                break;
            case 0xC00D0FDB:
                result = "The Windows Media Player ActiveX control must be in a docked state for this action to be performed.";
                break;
            case 0xC00D0FDC:
                result = "The Windows Media Player external object is not ready.";
                break;
            case 0xC00D0FDD:
                result = "Windows Media Player cannot perform the requested action. Your computer's time and date might not be set correctly.";
                break;
            case 0xC00D0FDE:
                result = "The control (%s) does not support creation of sub-controls, yet (%d) sub-controls have been specified.";
                break;
            case 0xC00D0FDF:
                result = "Version mismatch: (%.1f required, %.1f found).";
                break;
            case 0xC00D0FE0:
                result = "The layout manager was given valid XML that wasn't a theme file.";
                break;
            case 0xC00D0FE1:
                result = "The %s subelement could not be found on the %s object.";
                break;
            case 0xC00D0FE2:
                result = "An error occurred parsing the version tag. Valid version tags are of the form: <?wmp version='1.0'?>.";
                break;
            case 0xC00D0FE3:
                result = "The view specified in for the 'currentViewID' property (%s) was not found in this theme file.";
                break;
            case 0xC00D0FE4:
                result = "This error used internally for hit testing.";
                break;
            case 0xC00D0FE5:
                result = "Attributes were specified for the %s object, but the object was not available to send them to.";
                break;
            case 0xC00D0FE6:
                result = "The %s event already has a handler, the second handler was ignored.";
                break;
            case 0xC00D0FE7:
                result = "No .wms file found in skin archive.";
                break;
            case 0xC00D0FEA:
                result = "Windows Media Player encountered a problem while downloading the file. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FEB:
                result = "The Windows Media Player ActiveX control cannot load the requested uiMode and cannot roll back to the existing uiMode.";
                break;
            case 0xC00D0FEC:
                result = "Windows Media Player encountered a problem with the skin file. The skin file might not be valid.";
                break;
            case 0xC00D0FED:
                result = "Windows Media Player cannot send the link because your email program is not responding. Verify that your email program is configured properly, and then try again. For more information about email, see Windows Help.";
                break;
            case 0xC00D0FEE:
                result = "Windows Media Player cannot switch to full mode because your computer administrator has locked this skin.";
                break;
            case 0xC00D0FEF:
                result = "Windows Media Player encountered a problem while saving the file. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FF0:
                result = "Windows Media Player cannot overwrite a read-only file. Try using a different file name.";
                break;
            case 0xC00D0FF1:
                result = "Windows Media Player encountered a problem while creating or saving the playlist. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FF2:
                result = "Windows Media Player cannot open the Windows Media Download file. The file might be damaged.";
                break;
            case 0xC00D0FF3:
                result = "The file cannot be added to the library because it is a protected DVR-MS file. This content cannot be played back by Windows Media Player.";
                break;
            case 0xC00D0FF4:
                result = "Media sharing has been turned off because a required Windows setting or component has changed. For additional assistance, click Web Help.";
                break;
            case 0xC00D0FFA:
                result = "Exclusive Services launch failed because the Windows Media Player is already running.";
                break;
            case 0xC00D1004:
                result = "JPG Images are not recommended for use as a mappingImage.";
                break;
            case 0xC00D1005:
                result = "JPG Images are not recommended when using a transparencyColor.";
                break;
            case 0xC00D1009:
                result = "The Max property cannot be less than Min property.";
                break;
            case 0xC00D100A:
                result = "The Min property cannot be greater than Max property.";
                break;
            case 0xC00D100E:
                result = "JPG Images are not recommended for use as a positionImage.";
                break;
            case 0xC00D100F:
                result = "The (%s) image's size is not evenly divisible by the positionImage's size.";
                break;
            case 0xC00D1018:
                result = "The ZIP reader opened a file and its signature did not match that of the ZIP files.";
                break;
            case 0xC00D1019:
                result = "The ZIP reader has detected that the file is corrupted.";
                break;
            case 0xC00D101A:
                result = "GetFileStream, SaveToFile, or SaveTemp file was called on the ZIP reader with a file name that was not found in the ZIP file.";
                break;
            case 0xC00D1022:
                result = "Image type not supported.";
                break;
            case 0xC00D1023:
                result = "Image file might be corrupt.";
                break;
            case 0xC00D1024:
                result = "Unexpected end of file. GIF file might be corrupt.";
                break;
            case 0xC00D1025:
                result = "Invalid GIF file.";
                break;
            case 0xC00D1026:
                result = "Invalid GIF version. Only 87a or 89a supported.";
                break;
            case 0xC00D1027:
                result = "No images found in GIF file.";
                break;
            case 0xC00D1028:
                result = "Invalid PNG image file format.";
                break;
            case 0xC00D1029:
                result = "PNG bitdepth not supported.";
                break;
            case 0xC00D102A:
                result = "Compression format defined in PNG file not supported,";
                break;
            case 0xC00D102B:
                result = "Filter method defined in PNG file not supported.";
                break;
            case 0xC00D102C:
                result = "Interlace method defined in PNG file not supported.";
                break;
            case 0xC00D102D:
                result = "Bad CRC in PNG file.";
                break;
            case 0xC00D102E:
                result = "Invalid bitmask in BMP file.";
                break;
            case 0xC00D102F:
                result = "Topdown DIB not supported.";
                break;
            case 0xC00D1030:
                result = "Bitmap could not be created.";
                break;
            case 0xC00D1031:
                result = "Compression format defined in BMP not supported.";
                break;
            case 0xC00D1032:
                result = "Invalid Bitmap format.";
                break;
            case 0xC00D1033:
                result = "JPEG Arithmetic coding not supported.";
                break;
            case 0xC00D1034:
                result = "Invalid JPEG format.";
                break;
            case 0xC00D1035:
                result = "Invalid JPEG format.";
                break;
            case 0xC00D1036:
                result = "Internal version error. Unexpected JPEG library version.";
                break;
            case 0xC00D1037:
                result = "Internal JPEG Library error. Unsupported JPEG data precision.";
                break;
            case 0xC00D1038:
                result = "JPEG CCIR601 not supported.";
                break;
            case 0xC00D1039:
                result = "No image found in JPEG file.";
                break;
            case 0xC00D103A:
                result = "Could not read JPEG file.";
                break;
            case 0xC00D103B:
                result = "JPEG Fractional sampling not supported.";
                break;
            case 0xC00D103C:
                result = "JPEG image too large. Maximum image size supported is 65500 X 65500.";
                break;
            case 0xC00D103D:
                result = "Unexpected end of file reached in JPEG file.";
                break;
            case 0xC00D103E:
                result = "Unsupported JPEG SOF marker found.";
                break;
            case 0xC00D103F:
                result = "Unknown JPEG marker found.";
                break;
            case 0xC00D1044:
                result = "Windows Media Player cannot display the picture file. The player either does not support the picture type or the picture is corrupted.";
                break;
            case 0xC00D1049:
                result = "Windows Media Player cannot compute a Digital Audio Id for the song. It is too short.";
                break;
            case 0xC00D104A:
                result = "Windows Media Player cannot play the file at the requested speed.";
                break;
            case 0xC00D104B:
                result = "The rendering or digital signal processing plug-in cannot be instantiated.";
                break;
            case 0xC00D104C:
                result = "The file cannot be queued for seamless playback.";
                break;
            case 0xC00D104D:
                result = "Windows Media Player cannot download media usage rights for a file in the playlist.";
                break;
            case 0xC00D104E:
                result = "Windows Media Player encountered an error while trying to queue a file.";
                break;
            case 0xC00D1051:
                result = "Windows Media Player cannot play the protected file. The Player cannot verify that the connection to your video card is secure. Try installing an updated device driver for your video card.";
                break;
            case 0xC00D1052:
                result = "Windows Media Player cannot play the protected file. The Player detected that the connection to your hardware might not be secure.";
                break;
            case 0xC00D1053:
                result = "Windows Media Player output link protection is unsupported on this system.";
                break;
            case 0xC00D1054:
                result = "Operation attempted in an invalid graph state.";
                break;
            case 0xC00D1055:
                result = "A renderer cannot be inserted in a stream while one already exists.";
                break;
            case 0xC00D1056:
                result = "The Windows Media SDK interface needed to complete the operation does not exist at this time.";
                break;
            case 0xC00D1057:
                result = "Windows Media Player cannot play a portion of the file because it requires a codec that either could not be downloaded or that is not supported by the Player.";
                break;
            case 0xC00D1058:
                result = "File transfer streams are not allowed in the standalone Player.";
                break;
            case 0xC00D1059:
                result = "Windows Media Player cannot play the file. The Player does not support the format you are trying to play.";
                break;
            case 0xC00D105A:
                result = "An operation was attempted on a pin that does not exist in the DirectShow filter graph.";
                break;
            case 0xC00D105B:
                result = "Specified operation cannot be completed while waiting for a media format change from the SDK.";
                break;
            case 0xC00D105C:
                result = "Specified operation cannot be completed because the source filter does not exist.";
                break;
            case 0xC00D105D:
                result = "The specified type does not match this pin.";
                break;
            case 0xC00D105E:
                result = "The WMR Source Filter does not have a callback available.";
                break;
            case 0xC00D1062:
                result = "The specified property has not been set on this sample.";
                break;
            case 0xC00D1063:
                result = "A plug-in is required to correctly play the file. To determine if the plug-in is available to download, click Web Help.";
                break;
            case 0xC00D1064:
                result = "Windows Media Player cannot play the file because your media usage rights are corrupted. If you previously backed up your media usage rights, try restoring them.";
                break;
            case 0xC00D1065:
                result = "Windows Media Player cannot play protected files that contain binary streams.";
                break;
            case 0xC00D1068:
                result = "Windows Media Player cannot play the playlist because it is not valid.";
                break;
            case 0xC00D1069:
                result = "Windows Media Player cannot play the playlist because it is not valid.";
                break;
            case 0xC00D106A:
                result = "A later version of Windows Media Player might be required to play this playlist.";
                break;
            case 0xC00D106B:
                result = "The format of a REPEAT loop within the current playlist file is not valid.";
                break;
            case 0xC00D106C:
                result = "Windows Media Player cannot save the playlist because it does not contain any items.";
                break;
            case 0xC00D106D:
                result = "Windows Media Player cannot play the playlist because it is not valid.";
                break;
            case 0xC00D106E:
                result = "The specified attribute does not exist.";
                break;
            case 0xC00D106F:
                result = "The specified attribute already exists.";
                break;
            case 0xC00D1070:
                result = "Cannot retrieve the specified attribute.";
                break;
            case 0xC00D1071:
                result = "The specified item does not exist in the current playlist.";
                break;
            case 0xC00D1072:
                result = "Items of the specified type cannot be created within the current playlist.";
                break;
            case 0xC00D1073:
                result = "The specified item cannot be set in the current playlist.";
                break;
            case 0xC00D1074:
                result = "Windows Media Player cannot perform the requested action because the playlist does not contain any items.";
                break;
            case 0xC00D1075:
                result = "The specified auto playlist contains a filter type that is either not valid or is not installed on this computer.";
                break;
            case 0xC00D1076:
                result = "Windows Media Player cannot play the file because the associated playlist contains too many nested playlists.";
                break;
            case 0xC00D107C:
                result = "Windows Media Player cannot find the file. Verify that the path is typed correctly. If it is, the file might not exist in the specified location, or the computer where the file is stored might not be available.";
                break;
            case 0xC00D107D:
                result = "Failed to create the Global Interface Table.";
                break;
            case 0xC00D107E:
                result = "Failed to get the marshaled graph event handler interface.";
                break;
            case 0xC00D107F:
                result = "Buffer is too small for copying media type.";
                break;
            case 0xC00D1080:
                result = "The current state of the Player does not allow this operation.";
                break;
            case 0xC00D1081:
                result = "The playlist manager does not understand the current play mode (for example, shuffle or normal).";
                break;
            case 0xC00D1086:
                result = "Windows Media Player cannot play the file because it is not in the current playlist.";
                break;
            case 0xC00D1087:
                result = "There are no items in the playlist. Add items to the playlist, and then try again.";
                break;
            case 0xC00D1088:
                result = "The web page cannot be displayed because no web browser is installed on your computer.";
                break;
            case 0xC00D1089:
                result = "Windows Media Player cannot find the specified file. Verify the path is typed correctly. If it is, the file does not exist in the specified location, or the computer where the file is stored is not available.";
                break;
            case 0xC00D108A:
                result = "Graph with the specified URL was not found in the prerolled graph list.";
                break;
            case 0xC00D108B:
                result = "Windows Media Player cannot perform the requested operation because there is only one item in the playlist.";
                break;
            case 0xC00D108C:
                result = "An error sink was never registered for the calling object.";
                break;
            case 0xC00D108D:
                result = "The error manager is not available to respond to errors.";
                break;
            case 0xC00D108E:
                result = "The Web Help URL cannot be opened.";
                break;
            case 0xC00D108F:
                result = "Could not resume playing next item in playlist.";
                break;
            case 0xC00D1090:
                result = "Windows Media Player cannot play the file because the associated playlist does not contain any items or the playlist is not valid.";
                break;
            case 0xC00D1091:
                result = "An empty string for playlist attribute name was found.";
                break;
            case 0xC00D1092:
                result = "A playlist attribute name that is not valid was found.";
                break;
            case 0xC00D1093:
                result = "An empty string for a playlist attribute value was found.";
                break;
            case 0xC00D1094:
                result = "An illegal value for a playlist attribute was found.";
                break;
            case 0xC00D1095:
                result = "An empty string for a playlist item attribute name was found.";
                break;
            case 0xC00D1096:
                result = "An illegal value for a playlist item attribute name was found.";
                break;
            case 0xC00D1097:
                result = "An illegal value for a playlist item attribute was found.";
                break;
            case 0xC00D1098:
                result = "The playlist does not contain any items.";
                break;
            case 0xC00D1099:
                result = "Windows Media Player cannot play the file. The file is either corrupted or the Player does not support the format you are trying to play.";
                break;
            case 0xC00D109A:
                result = "The codec downloaded for this file does not appear to be properly signed, so it cannot be installed.";
                break;
            case 0xC00D109B:
                result = "Windows Media Player cannot play the file. One or more codecs required to play the file could not be found.";
                break;
            case 0xC00D109C:
                result = "Windows Media Player cannot play the file because a required codec is not installed on your computer. To try downloading the codec, turn on the \"Download codecs automatically\" option.";
                break;
            case 0xC00D109D:
                result = "Windows Media Player encountered a problem while downloading the playlist. For additional assistance, click Web Help.";
                break;
            case 0xC00D109E:
                result = "Failed to build the playlist.";
                break;
            case 0xC00D109F:
                result = "Playlist has no alternates to switch into.";
                break;
            case 0xC00D10A0:
                result = "No more playlist alternates available to switch to.";
                break;
            case 0xC00D10A1:
                result = "Could not find the name of the alternate playlist to switch into.";
                break;
            case 0xC00D10A2:
                result = "Failed to switch to an alternate for this media.";
                break;
            case 0xC00D10A3:
                result = "Failed to initialize an alternate for the media.";
                break;
            case 0xC00D10A4:
                result = "No URL specified for the roll over Refs in the playlist file.";
                break;
            case 0xC00D10A5:
                result = "Encountered a playlist with no name.";
                break;
            case 0xC00D10A6:
                result = "A required attribute in the event block of the playlist was not found.";
                break;
            case 0xC00D10A7:
                result = "No items were found in the event block of the playlist.";
                break;
            case 0xC00D10A8:
                result = "No playlist was found while returning from a nested playlist.";
                break;
            case 0xC00D10A9:
                result = "The media item is not active currently.";
                break;
            case 0xC00D10AB:
                result = "Windows Media Player cannot perform the requested action because you chose to cancel it.";
                break;
            case 0xC00D10AC:
                result = "Windows Media Player encountered a problem with the playlist. The format of the playlist is not valid.";
                break;
            case 0xC00D10AD:
                result = "Media object corresponding to start of a playlist repeat block was not found.";
                break;
            case 0xC00D10AE:
                result = "Media object corresponding to the end of a playlist repeat block was not found.";
                break;
            case 0xC00D10AF:
                result = "The playlist URL supplied to the playlist manager is not valid.";
                break;
            case 0xC00D10B0:
                result = "Windows Media Player cannot play the file because it is corrupted.";
                break;
            case 0xC00D10B1:
                result = "Windows Media Player cannot add the playlist to the library because the playlist does not contain any items.";
                break;
            case 0xC00D10B2:
                result = "An error has occurred that could prevent the changing of the video contrast on this media.";
                break;
            case 0xC00D10B3:
                result = "Windows Media Player cannot play the file. If the file is located on the Internet, connect to the Internet. If the file is located on a removable storage card, insert the storage card.";
                break;
            case 0xC00D10B4:
                result = "The playlist contains an ENTRYREF for which no href was parsed. Check the syntax of playlist file.";
                break;
            case 0xC00D10B5:
                result = "Windows Media Player cannot play any items in the playlist. To find information about the problem, click the Now Playing tab, and then click the icon next to each file in the List pane.";
                break;
            case 0xC00D10B6:
                result = "Windows Media Player cannot play some or all of the items in the playlist because the playlist is nested.";
                break;
            case 0xC00D10B7:
                result = "Windows Media Player cannot play the file at this time. Try again later.";
                break;
            case 0xC00D10B8:
                result = "There is no child playlist available for this media item at this time.";
                break;
            case 0xC00D10B9:
                result = "There is no child playlist for this media item.";
                break;
            case 0xC00D10BA:
                result = "Windows Media Player cannot find the file. The link from the item in the library to its associated digital media file might be broken. To fix the problem, try repairing the link or removing the item from the library.";
                break;
            case 0xC00D10BB:
                result = "The temporary file was not found.";
                break;
            case 0xC00D10BC:
                result = "Windows Media Player cannot sync the file because the device needs to be updated.";
                break;
            case 0xC00D10BD:
                result = "Windows Media Player cannot play the video because there is a problem with your video card.";
                break;
            case 0xC00D10BE:
                result = "Windows Media Player failed to change the screen mode for full-screen video playback.";
                break;
            case 0xC00D10BF:
                result = "Windows Media Player cannot play one or more files. For additional information, right-click an item that cannot be played, and then click Error Details.";
                break;
            case 0xC00D10C0:
                result = "Cannot change the proxy name if the proxy setting is not set to custom.";
                break;
            case 0xC00D10C1:
                result = "Cannot change the proxy port if the proxy setting is not set to custom.";
                break;
            case 0xC00D10C2:
                result = "Cannot change the proxy exception list if the proxy setting is not set to custom.";
                break;
            case 0xC00D10C3:
                result = "Cannot change the proxy bypass flag if the proxy setting is not set to custom.";
                break;
            case 0xC00D10C4:
                result = "Cannot find the specified protocol.";
                break;
            case 0xC00D10C5:
                result = "Cannot change the language settings. Either the graph has no audio or the audio only supports one language.";
                break;
            case 0xC00D10C6:
                result = "The graph has no audio language selected.";
                break;
            case 0xC00D10C7:
                result = "This is not a media CD.";
                break;
            case 0xC00D10C8:
                result = "Windows Media Player cannot play the file because the URL is too long.";
                break;
            case 0xC00D10C9:
                result = "To play the selected item, you must install the Macromedia Flash Player. To download the Macromedia Flash Player, go to the Adobe website.";
                break;
            case 0xC00D10CA:
                result = "To play the selected item, you must install a later version of the Macromedia Flash Player. To download the Macromedia Flash Player, go to the Adobe website.";
                break;
            case 0xC00D10CB:
                result = "Windows Media Player cannot play the file because your Internet security settings prohibit the use of ActiveX controls.";
                break;
            case 0xC00D10CC:
                result = "The use of this method requires an existing reference to the Player object.";
                break;
            case 0xC00D10CD:
                result = "Windows Media Player cannot play the CD. The disc might be dirty or damaged.";
                break;
            case 0xC00D10CE:
                result = "Windows Media Player cannot play the file because your Internet security settings prohibit the use of ActiveX controls.";
                break;
            case 0xC00D10CF:
                result = "Flash playback has been turned off in Windows Media Player.";
                break;
            case 0xC00D10D0:
                result = "Windows Media Player cannot rip the CD because a valid rip location cannot be created.";
                break;
            case 0xC00D10D1:
                result = "Windows Media Player cannot play the file because a required codec is not installed on your computer.";
                break;
            case 0xC00D10D2:
                result = "Windows Media Player cannot rip one or more tracks from the CD.";
                break;
            case 0xC00D10D3:
                result = "Windows Media Player encountered a problem while ripping the track from the CD. For additional assistance, click Web Help.";
                break;
            case 0xC00D10D4:
                result = "Windows Media Player encountered a problem while erasing the disc. For additional assistance, click Web Help.";
                break;
            case 0xC00D10D5:
                result = "Windows Media Player encountered a problem while formatting the device. For additional assistance, click Web Help.";
                break;
            case 0xC00D10D6:
                result = "This file cannot be burned to a CD because it is not located on your computer.";
                break;
            case 0xC00D10D7:
                result = "It is not possible to burn this file type to an audio CD. Windows Media Player can burn the following file types to an audio CD: WMA, MP3, or WAV.";
                break;
            case 0xC00D10D8:
                result = "This file is too large to fit on a disc.";
                break;
            case 0xC00D10D9:
                result = "It is not possible to determine if this file can fit on a disc because Windows Media Player cannot detect the length of the file. Playing the file before burning might enable the Player to detect the file length.";
                break;
            case 0xC00D10DA:
                result = "Windows Media Player encountered a problem while burning the file to the disc. For additional assistance, click Web Help.";
                break;
            case 0xC00D10DC:
                result = "Windows Media Player cannot burn the audio CD because some items in the list that you chose to buy could not be downloaded from the online store.";
                break;
            case 0xC00D10DD:
                result = "Windows Media Player cannot play the file. Try using Windows Update or Device Manager to update the device drivers for your audio and video cards. For information about using Windows Update or Device Manager, see Windows Help.";
                break;
            case 0xC00D1126:
                result = "Windows Media Player has detected that you are not connected to the Internet. Connect to the Internet, and then try again.";
                break;
            case 0xC00D1127:
                result = "The attempt to connect to the Internet was canceled.";
                break;
            case 0xC00D1128:
                result = "The attempt to connect to the Internet failed.";
                break;
            case 0xC00D1129:
                result = "Windows Media Player has encountered an unknown network error.";
                break;
            case 0xC00D1130:
                result = "No window is currently listening to Backup and Restore events.";
                break;
            case 0xC00D1131:
                result = "Your media usage rights were not backed up because the backup was canceled.";
                break;
            case 0xC00D1132:
                result = "Your media usage rights were not restored because the restoration was canceled.";
                break;
            case 0xC00D1133:
                result = "An error occurred while backing up or restoring your media usage rights. A required web page cannot be displayed.";
                break;
            case 0xC00D1134:
                result = "Your media usage rights were not backed up because the backup was canceled.";
                break;
            case 0xC00D1137:
                result = "Windows Media Player cannot restore your media usage rights from the specified location. Choose another location, and then try again.";
                break;
            case 0xC00D1138:
                result = "Windows Media Player cannot backup or restore your media usage rights.";
                break;
            case 0xC00D1158:
                result = "Windows Media Player cannot add the file to the library.";
                break;
            case 0xC00D1159:
                result = "Windows Media Player cannot add the file to the library because the content provider prohibits it. For assistance, contact the company that provided the file.";
                break;
            case 0xC00D115A:
                result = "Windows Media Player cannot add the file to the library because the content provider prohibits it. For assistance, contact the company that provided the file.";
                break;
            case 0xC00D115B:
                result = "Windows Media Player cannot add the file to the library. The file might not be valid.";
                break;
            case 0xC00D115C:
                result = "Windows Media Player cannot add the file to the library. The plug-in required to add the file is not installed properly. For assistance, click Web Help to display the website of the company that provided the file.";
                break;
            case 0xC00D115D:
                result = "Windows Media Player cannot add the file to the library. The plug-in required to add the file is not installed properly. For assistance, contact the company that provided the file.";
                break;
            case 0xC00D115E:
                result = "Windows Media Player cannot add the file to the library. The plug-in required to add the file is not installed properly. For assistance, contact the company that provided the file.";
                break;
            case 0xC00D1160:
                result = "Windows Media Player cannot play this DVD. Try installing an updated driver for your video card or obtaining a newer video card.";
                break;
            case 0xC00D1161:
                result = "This DVD's resolution exceeds the maximum allowed by your component video outputs. Try reducing your screen resolution to 640 x 480, or turn off analog component outputs and use a VGA connection to your monitor.";
                break;
            case 0xC00D1162:
                result = "Windows Media Player cannot display subtitles or highlights in DVD menus. Reinstall the DVD decoder or contact the DVD drive manufacturer to obtain an updated decoder.";
                break;
            case 0xC00D1163:
                result = "Windows Media Player cannot play this DVD because there is a problem with digital copy protection between your DVD drive, decoder, and video card. Try installing an updated driver for your video card.";
                break;
            case 0xC00D1164:
                result = "Windows Media Player cannot play the DVD. The disc was created in a manner that the Player does not support.";
                break;
            case 0xC00D1165:
                result = "Windows Media Player cannot play the DVD because the disc prohibits playback in your region of the world. You must obtain a disc that is intended for your geographic region.";
                break;
            case 0xC00D1166:
                result = "Windows Media Player cannot play the DVD because your video card does not support DVD playback.";
                break;
            case 0xC00D1167:
                result = "Windows Media Player cannot play this DVD because it is not possible to turn on analog copy protection on the output display. Try installing an updated driver for your video card.";
                break;
            case 0xC00D1168:
                result = "Windows Media Player cannot play the DVD because the region assigned to your DVD drive does not match the region assigned to your DVD decoder.";
                break;
            case 0xC00D1169:
                result = "Windows Media Player cannot play the DVD because the disc prohibits playback in your region of the world. You must obtain a disc that is intended for your geographic region.";
                break;
            case 0xC00D116A:
                result = "Windows Media Player cannot play DVD video. You might need to adjust your Windows display settings. Open display settings in Control Panel, and then try lowering your screen resolution and color quality settings.";
                break;
            case 0xC00D116B:
                result = "Windows Media Player cannot play DVD audio. Verify that your sound card is set up correctly, and then try again.";
                break;
            case 0xC00D116C:
                result = "Windows Media Player cannot play DVD video. Close any open files and quit any other programs, and then try again. If the problem persists, restart your computer.";
                break;
            case 0xC00D116D:
                result = "Windows Media Player cannot play the DVD because a compatible DVD decoder is not installed on your computer.";
                break;
            case 0xC00D116E:
                result = "Windows Media Player cannot play the scene because it has a parental rating higher than the rating that you are authorized to view.";
                break;
            case 0xC00D116F:
                result = "Windows Media Player cannot skip to the requested location on the DVD.";
                break;
            case 0xC00D1170:
                result = "Windows Media Player cannot play the DVD because it is currently in use by another program. Quit the other program that is using the DVD, and then try again.";
                break;
            case 0xC00D1171:
                result = "Windows Media Player cannot play DVD video. You might need to adjust your Windows display settings. Open display settings in Control Panel, and then try lowering your screen resolution and color quality settings.";
                break;
            case 0xC00D1172:
                result = "Windows Media Player cannot rip the DVD because it is copy protected.";
                break;
            case 0xC00D1173:
                result = "One of more of the required properties has not been set.";
                break;
            case 0xC00D1174:
                result = "The specified title and/or chapter number does not exist on this DVD.";
                break;
            case 0xC00D1176:
                result = "Windows Media Player cannot burn the files because the Player cannot find a burner. If the burner is connected properly, try using Windows Update to install the latest device driver.";
                break;
            case 0xC00D1177:
                result = "Windows Media Player does not detect storage media in the selected device. Insert storage media into the device, and then try again.";
                break;
            case 0xC00D1178:
                result = "Windows Media Player cannot sync this file. The Player might not support the file type.";
                break;
            case 0xC00D1179:
                result = "Windows Media Player does not detect a portable device. Connect your portable device, and then try again.";
                break;
            case 0xC00D117A:
                result = "Windows Media Player encountered an error while communicating with the device. The storage card on the device might be full, the device might be turned off, or the device might not allow playlists or folders to be created on it.";
                break;
            case 0xC00D117B:
                result = "Windows Media Player encountered an error while burning a CD.";
                break;
            case 0xC00D117C:
                result = "Windows Media Player encountered an error while communicating with a portable device or CD drive.";
                break;
            case 0xC00D117D:
                result = "Windows Media Player cannot open the WAV file.";
                break;
            case 0xC00D117E:
                result = "Windows Media Player failed to burn all the files to the CD. Select a slower recording speed, and then try again.";
                break;
            case 0xC00D117F:
                result = "There is not enough storage space on the portable device to complete this operation. Delete some unneeded files on the portable device, and then try again.";
                break;
            case 0xC00D1180:
                result = "Windows Media Player cannot burn the files. Verify that your burner is connected properly, and then try again. If the problem persists, reinstall the Player.";
                break;
            case 0xC00D1181:
                result = "Windows Media Player did not sync some files to the device because there is not enough storage space on the device.";
                break;
            case 0xC00D1182:
                result = "The disc in the burner is not valid. Insert a blank disc into the burner, and then try again.";
                break;
            case 0xC00D1183:
                result = "Windows Media Player cannot perform the requested action because the device does not support sync.";
                break;
            case 0xC00D1184:
                result = "To perform the requested action, you must first set up sync with the device.";
                break;
            case 0xC00D1185:
                result = "You have already created sync partnerships with 16 devices. To create a new sync partnership, you must first end an existing partnership.";
                break;
            case 0xC00D1186:
                result = "Windows Media Player cannot sync the file because protected files cannot be converted to the required quality level or file format.";
                break;
            case 0xC00D1187:
                result = "The folder that stores converted files is full. Either empty the folder or increase its size, and then try again.";
                break;
            case 0xC00D1188:
                result = "There are too many files with the same name in the folder on the device. Change the file name or sync to a different folder.";
                break;
            case 0xC00D1189:
                result = "Windows Media Player cannot convert the file to the format required by the device.";
                break;
            case 0xC00D118A:
                result = "You have reached the maximum number of files your device allows in a folder. If your device supports playback from subfolders, try creating subfolders on the device and storing some files in them.";
                break;
            case 0xC00D118B:
                result = "Windows Media Player is already trying to start the Device Setup Wizard.";
                break;
            case 0xC00D118C:
                result = "Windows Media Player cannot convert this file format. If an updated version of the codec used to compress this file is available, install it and then try to sync the file again.";
                break;
            case 0xC00D118D:
                result = "Windows Media Player is busy setting up devices. Try again later.";
                break;
            case 0xC00D118E:
                result = "Your device is using an outdated driver that is no longer supported by Windows Media Player. For additional assistance, click Web Help.";
                break;
            case 0xC00D118F:
                result = "Windows Media Player cannot sync the file because a file with the same name already exists on the device. Change the file name or try to sync the file to a different folder.";
                break;
            case 0xC00D1190:
                result = "Automatic and manual sync have been turned off temporarily. To sync to a device, restart Windows Media Player.";
                break;
            case 0xC00D1191:
                result = "This device is not available. Connect the device to the computer, and then try again.";
                break;
            case 0xC00D1192:
                result = "Windows Media Player cannot sync the file because an error occurred while converting the file to another quality level or format. If the problem persists, remove the file from the list of files to sync.";
                break;
            case 0xC00D1193:
                result = "Windows Media Player cannot sync the file to your device. The file might be stored in a location that is not supported. Copy the file from its current location to your hard disk, add it to your library, and then try to sync the file again.";
                break;
            case 0xC00D1194:
                result = "Windows Media Player cannot open the specified URL. Verify that the Player is configured to use all available protocols, and then try again.";
                break;
            case 0xC00D1195:
                result = "Windows Media Player cannot perform the requested action because there is not enough storage space on your computer. Delete some unneeded files on your hard disk, and then try again.";
                break;
            case 0xC00D1196:
                result = "The server denied access to the file. Verify that you are using the correct user name and password.";
                break;
            case 0xC00D1197:
                result = "Windows Media Player cannot find the file. If you are trying to play, burn, or sync an item that is in your library, the item might point to a file that has been moved, renamed, or deleted.";
                break;
            case 0xC00D1198:
                result = "Windows Media Player cannot connect to the server. The server name might not be correct, the server might not be available, or your proxy settings might not be correct.";
                break;
            case 0xC00D1199:
                result = "Windows Media Player cannot play the file. The Player might not support the file type or might not support the codec that was used to compress the file.";
                break;
            case 0xC00D119A:
                result = "Windows Media Player cannot play the file. The Player might not support the file type or a required codec might not be installed on your computer.";
                break;
            case 0xC00D119B:
                result = "Windows Media Player cannot create the playlist because the name already exists. Type a different playlist name.";
                break;
            case 0xC00D119C:
                result = "Windows Media Player cannot delete the playlist because it contains items that are not digital media files. Any digital media files in the playlist were deleted.";
                break;
            case 0xC00D119D:
                result = "The playlist cannot be opened because it is stored in a shared folder on another computer. If possible, move the playlist to the playlists folder on your computer.";
                break;
            case 0xC00D119E:
                result = "Windows Media Player is already in use. Stop playing any items, close all Player dialog boxes, and then try again.";
                break;
            case 0xC00D119F:
                result = "Windows Media Player encountered an error while burning. Verify that the burner is connected properly and that the disc is clean and not damaged.";
                break;
            case 0xC00D11A0:
                result = "Windows Media Player has encountered an unknown error with your portable device. Reconnect your portable device, and then try again.";
                break;
            case 0xC00D11A1:
                result = "A codec is required to play this file. To determine if this codec is available to download from the web, click Web Help.";
                break;
            case 0xC00D11A2:
                result = "An audio codec is needed to play this file. To determine if this codec is available to download from the web, click Web Help.";
                break;
            case 0xC00D11A3:
                result = "To play the file, you must install the latest Windows service pack. To install the service pack from the Windows Update website, click Web Help.";
                break;
            case 0xC00D11A4:
                result = "Windows Media Player no longer detects a portable device. Reconnect your portable device, and then try again.";
                break;
            case 0xC00D11A5:
                result = "Windows Media Player cannot sync the file because the portable device does not support protected files.";
                break;
            case 0xC00D11A6:
                result = "This file does not have sync rights. If you obtained this file from an online store, go to the online store to get sync rights.";
                break;
            case 0xC00D11A7:
                result = "Windows Media Player cannot sync the file because the sync rights have expired. Go to the content provider's online store to get new sync rights.";
                break;
            case 0xC00D11A8:
                result = "The portable device is already in use. Wait until the current task finishes or quit other programs that might be using the portable device, and then try again.";
                break;
            case 0xC00D11A9:
                result = "Windows Media Player cannot sync the file because the content provider or device prohibits it. You might be able to resolve this problem by going to the content provider's online store to get sync rights.";
                break;
            case 0xC00D11AA:
                result = "The content provider has not granted you the right to sync this file. Go to the content provider's online store to get sync rights.";
                break;
            case 0xC00D11AB:
                result = "Windows Media Player cannot burn the files to the CD. Verify that the disc is clean and not damaged. If necessary, select a slower recording speed or try a different brand of blank discs.";
                break;
            case 0xC00D11AD:
                result = "Windows Media Player cannot burn the files. Verify that the burner is connected properly, and then try again.";
                break;
            case 0xC00D11AE:
                result = "Windows Media Player cannot burn the files. Verify that the burner is connected properly and that the disc is clean and not damaged. If the burner is already in use, wait until the current task finishes or quit other programs that might be using the burner.";
                break;
            case 0xC00D11AF:
                result = "Windows Media Player cannot burn the files to the CD.";
                break;
            case 0xC00D11B0:
                result = "Windows Media Player cannot play the file. The server might not be available or there might be a problem with your network or firewall settings.";
                break;
            case 0xC00D11B1:
                result = "Windows Media Player encountered a problem while playing the file. For additional assistance, click Web Help.";
                break;
            case 0xC00D11B2:
                result = "Windows Media Player must connect to the Internet to verify the file's media usage rights. Connect to the Internet, and then try again.";
                break;
            case 0xC00D11B3:
                result = "Windows Media Player cannot play the file because a network error occurred. The server might not be available. Verify that you are connected to the network and that your proxy settings are correct.";
                break;
            case 0xC00D11B4:
                result = "Windows Media Player cannot restore your media usage rights because it could not find any backed up rights on your computer.";
                break;
            case 0xC00D11B5:
                result = "Windows Media Player cannot download media usage rights because the server is not available (for example, the server might be busy or not online).";
                break;
            case 0xC00D11B6:
                result = "Windows Media Player cannot play the file. A network firewall might be preventing the Player from opening the file by using the UDP transport protocol. If you typed a URL in the Open URL dialog box, try using a different transport protocol (for example, \"http:\").";
                break;
            case 0xC00D11B7:
                result = "Insert the removable media, and then try again.";
                break;
            case 0xC00D11B8:
                result = "Windows Media Player cannot play the file because the proxy server is not responding. The proxy server might be temporarily unavailable or your Player proxy settings might not be valid.";
                break;
            case 0xC00D11B9:
                result = "To play the file, you might need to install a later version of Windows Media Player. On the Help menu, click Check for Updates, and then follow the instructions. For additional assistance, click Web Help.";
                break;
            case 0xC00D11BA:
                result = "Windows Media Player cannot play the file because there is a problem with your sound device. There might not be a sound device installed on your computer, it might be in use by another program, or it might not be functioning properly.";
                break;
            case 0xC00D11BB:
                result = "Windows Media Player cannot play the file because the specified protocol is not supported. If you typed a URL in the Open URL dialog box, try using a different transport protocol (for example, \"http:\" or \"rtsp:\").";
                break;
            case 0xC00D11BC:
                result = "Windows Media Player cannot add the file to the library because the file format is not supported.";
                break;
            case 0xC00D11BD:
                result = "Windows Media Player cannot play the file because the specified protocol is not supported. If you typed a URL in the Open URL dialog box, try using a different transport protocol (for example, \"mms:\").";
                break;
            case 0xC00D11BE:
                result = "Windows Media Player cannot play the file because there are no streaming protocols selected. Select one or more protocols, and then try again.";
                break;
            case 0xC00D11BF:
                result = "Windows Media Player cannot switch to Full Screen. You might need to adjust your Windows display settings. Open display settings in Control Panel, and then try setting Hardware acceleration to Full.";
                break;
            case 0xC00D11C0:
                result = "Windows Media Player cannot play the file because a network error occurred. The server might not be available (for example, the server is busy or not online) or you might not be connected to the network.";
                break;
            case 0xC00D11C1:
                result = "Windows Media Player cannot play the file because the server is not responding. Verify that you are connected to the network, and then try again later.";
                break;
            case 0xC00D11C2:
                result = "Windows Media Player cannot play the file because the multicast protocol is not enabled. On the Tools menu, click Options, click the Network tab, and then select the Multicast check box. For additional assistance, click Web Help.";
                break;
            case 0xC00D11C3:
                result = "Windows Media Player cannot play the file because a network problem occurred. Verify that you are connected to the network, and then try again later.";
                break;
            case 0xC00D11C4:
                result = "Windows Media Player cannot play the file because the network proxy server cannot be found. Verify that your proxy settings are correct, and then try again.";
                break;
            case 0xC00D11C5:
                result = "Windows Media Player cannot play the file because it is corrupted.";
                break;
            case 0xC00D11C6:
                result = "Your computer is running low on memory. Quit other programs, and then try again.";
                break;
            case 0xC00D11C7:
                result = "Windows Media Player cannot play, burn, rip, or sync the file because a required audio codec is not installed on your computer.";
                break;
            case 0xC00D11C8:
                result = "Windows Media Player cannot play the file because the required video codec is not installed on your computer.";
                break;
            case 0xC00D11C9:
                result = "Windows Media Player cannot burn the files. If the burner is busy, wait for the current task to finish. If necessary, verify that the burner is connected properly and that you have installed the latest device driver.";
                break;
            case 0xC00D11CA:
                result = "Windows Media Player cannot play the protected file because there is a problem with your sound device. Try installing a new device driver or use a different sound device.";
                break;
            case 0xC00D11CB:
                result = "Windows Media Player encountered a network error. Restart the Player.";
                break;
            case 0xC00D11CC:
                result = "Windows Media Player is not installed properly. Reinstall the Player.";
                break;
            case 0xC00D11CD:
                result = "Windows Media Player encountered an unknown error. For additional assistance, click Web Help.";
                break;
            case 0xC00D11CE:
                result = "Windows Media Player cannot play the file because the required codec is not valid.";
                break;
            case 0xC00D11CF:
                result = "The CD drive is in use by another user. Wait for the task to complete, and then try again.";
                break;
            case 0xC00D11D0:
                result = "Windows Media Player cannot play, sync, or burn the protected file because a problem occurred with the Windows Media Digital Rights Management (DRM) system. You might need to connect to the Internet to update your DRM components. For additional assistance, click Web Help.";
                break;
            case 0xC00D11D1:
                result = "Windows Media Player cannot play the file because there might be a problem with your sound or video device. Try installing an updated device driver.";
                break;
            case 0xC00D11D2:
                result = "Windows Media Player cannot access the file. The file might be in use, you might not have access to the computer where the file is stored, or your proxy settings might not be correct.";
                break;
            case 0xC00D11D3:
                result = "The content provider prohibits this action. Go to the content provider's online store to get new media usage rights.";
                break;
            case 0xC00D11D4:
                result = "Windows Media Player cannot perform the requested action at this time.";
                break;
            case 0xC00D11D5:
                result = "Windows Media Player cannot burn the files because there is not enough free disk space to store the temporary files. Delete some unneeded files on your hard disk, and then try again.";
                break;
            case 0xC00D11D6:
                result = "Your media usage rights have become corrupted or are no longer valid. This might happen if you have replaced hardware components in your computer.";
                break;
            case 0xC00D11D7:
                result = "The required Windows Media Digital Rights Management (DRM) component cannot be validated. You might be able resolve the problem by reinstalling the Player.";
                break;
            case 0xC00D11D8:
                result = "You have exceeded your restore limit for the day. Try restoring your media usage rights tomorrow.";
                break;
            case 0xC00D11D9:
                result = "Some files might not fit on the CD. The required space cannot be calculated accurately because some files might be missing duration information. To ensure the calculation is accurate, play the files that are missing duration information.";
                break;
            case 0xC00D11DA:
                result = "Windows Media Player cannot verify the file's media usage rights. If you obtained this file from an online store, go to the online store to get the necessary rights.";
                break;
            case 0xC00D11DB:
                result = "It is not possible to sync because this device's internal clock is not set correctly. To set the clock, select the option to set the device clock on the Privacy tab of the Options dialog box, connect to the Internet, and then sync the device again. For additional assistance, click Web Help.";
                break;
            case 0xC00D11DC:
                result = "Windows Media Player cannot play, burn, rip, or sync the protected file because you do not have the appropriate rights.";
                break;
            case 0xC00D11DD:
                result = "Windows Media Player encountered an error during upgrade.";
                break;
            case 0xC00D11DE:
                result = "Windows Media Player cannot connect to the server because it is not accepting any new connections. This could be because it has reached its maximum connection limit. Please try again later.";
                break;
            case 0xC00D11DF:
                result = "A number of queued files cannot be played. To find information about the problem, click the Now Playing tab, and then click the icon next to each file in the List pane.";
                break;
            case 0xC00D11E0:
                result = "Windows Media Player encountered an error while erasing the rewritable CD or DVD. Verify that the CD or DVD burner is connected properly and that the disc is clean and not damaged.";
                break;
            case 0xC00D11E1:
                result = "Windows Media Player cannot erase the rewritable CD or DVD. Verify that the CD or DVD burner is connected properly and that the disc is clean and not damaged. If the burner is already in use, wait until the current task finishes or quit other programs that might be using the burner.";
                break;
            case 0xC00D11E2:
                result = "A Windows Media Digital Rights Management (DRM) component encountered a problem. If you are trying to use a file that you obtained from an online store, try going to the online store and getting the appropriate usage rights.";
                break;
            case 0xC00D11E3:
                result = "It is not possible to obtain device's certificate. Please contact the device manufacturer for a firmware update or for other steps to resolve this problem.";
                break;
            case 0xC00D11E4:
                result = "Windows Media Player encountered an error when connecting to the server. The security information from the server could not be validated.";
                break;
            case 0xC00D11E5:
                result = "An audio device was disconnected or reconfigured. Verify that the audio device is connected, and then try to play the item again.";
                break;
            case 0xC00D11E6:
                result = "Windows Media Player could not complete burning because the disc is not compatible with your drive. Try inserting a different kind of recordable media or use a disc that supports a write speed that is compatible with your drive.";
                break;
            case 0xC00D11EE:
                result = "Windows Media Player cannot save the sync settings because your device is full. Delete some unneeded files on your device and then try again.";
                break;
            case 0xC00D11EF:
                result = "It is not possible to change sync settings at this time. Try again later.";
                break;
            case 0xC00D11F0:
                result = "Windows Media Player cannot delete these files currently. If the Player is synchronizing, wait until it is complete and then try again.";
                break;
            case 0xC00D11F8:
                result = "Windows Media Player could not use digital mode to read the CD. The Player has automatically switched the CD drive to analog mode. To switch back to digital mode, use the Devices tab. For additional assistance, click Web Help.";
                break;
            case 0xC00D11F9:
                result = "No CD track was specified for playback.";
                break;
            case 0xC00D11FA:
                result = "The CD filter was not able to create the CD reader.";
                break;
            case 0xC00D11FB:
                result = "Invalid ISRC code.";
                break;
            case 0xC00D11FC:
                result = "Invalid Media Catalog Number.";
                break;
            case 0xC00D11FD:
                result = "Windows Media Player cannot play audio CDs correctly because the CD drive is slow and error correction is turned on. To increase performance, turn off playback error correction for this drive.";
                break;
            case 0xC00D11FE:
                result = "Windows Media Player cannot estimate the CD drive's playback speed because the CD track is too short.";
                break;
            case 0xC00D11FF:
                result = "Cannot queue the CD track because queuing is not enabled.";
                break;
            case 0xC00D1202:
                result = "Windows Media Player cannot download additional media usage rights until the current download is complete.";
                break;
            case 0xC00D1203:
                result = "The media usage rights for this file have expired or are no longer valid. If you obtained the file from an online store, sign in to the store, and then try again.";
                break;
            case 0xC00D1204:
                result = "Windows Media Player cannot download the media usage rights for the file. If you obtained the file from an online store, sign in to the store, and then try again.";
                break;
            case 0xC00D1205:
                result = "The media usage rights for this file are not yet valid. To see when they will become valid, right-click the file in the library, click Properties, and then click the Media Usage Rights tab.";
                break;
            case 0xC00D1206:
                result = "The media usage rights for this file are not valid. If you obtained this file from an online store, contact the store for assistance.";
                break;
            case 0xC00D1207:
                result = "The content provider has revoked the media usage rights for this file. If you obtained this file from an online store, ask the store if a new version of the file is available.";
                break;
            case 0xC00D1208:
                result = "The media usage rights for this file require a feature that is not supported in your current version of Windows Media Player or your current version of Windows. Try installing the latest version of the Player. If you obtained this file from an online store, contact the store for further assistance.";
                break;
            case 0xC00D1209:
                result = "Windows Media Player cannot download media usage rights at this time. Try again later.";
                break;
            case 0xC00D120A:
                result = "Windows Media Player cannot play, burn, or sync the file because the media usage rights are missing. If you obtained the file from an online store, sign in to the store, and then try again.";
                break;
            case 0xC00D120B:
                result = "Windows Media Player cannot play, burn, or sync the file because the media usage rights are missing. If you obtained the file from an online store, sign in to the store, and then try again.";
                break;
            case 0xC00D122A:
                result = "Windows Media Player cannot read a policy. This can occur when the policy does not exist in the registry or when the registry cannot be read.";
                break;
            case 0xC00D1234:
                result = "Windows Media Player cannot sync content streamed directly from the Internet. If possible, download the file to your computer, and then try to sync the file.";
                break;
            case 0xC00D1235:
                result = "This playlist is not valid or is corrupted. Create a new playlist using Windows Media Player, then sync the new playlist instead.";
                break;
            case 0xC00D1236:
                result = "Windows Media Player encountered a problem while synchronizing the file to the device. For additional assistance, click Web Help.";
                break;
            case 0xC00D1237:
                result = "Windows Media Player encountered an error while synchronizing to the device.";
                break;
            case 0xC00D1238:
                result = "Windows Media Player cannot delete a file from the device.";
                break;
            case 0xC00D1239:
                result = "Windows Media Player cannot copy a file from the device to your library.";
                break;
            case 0xC00D123A:
                result = "Windows Media Player cannot communicate with the device because the device is not responding. Try reconnecting the device, resetting the device, or contacting the device manufacturer for updated firmware.";
                break;
            case 0xC00D123B:
                result = "Windows Media Player cannot sync the picture to the device because a problem occurred while converting the file to another quality level or format. The original file might be damaged or corrupted.";
                break;
            case 0xC00D123C:
                result = "Windows Media Player cannot convert the file. The file might have been encrypted by the Encrypted File System (EFS). Try decrypting the file first and then synchronizing it. For information about how to decrypt a file, see Windows Help and Support.";
                break;
            case 0xC00D123D:
                result = "Your device requires that this file be converted in order to play on the device. However, the device either does not support playing audio, or Windows Media Player cannot convert the file to an audio format that is supported by the device.";
                break;
            case 0xC00D123E:
                result = "Your device requires that this file be converted in order to play on the device. However, the device either does not support playing video, or Windows Media Player cannot convert the file to a video format that is supported by the device.";
                break;
            case 0xC00D123F:
                result = "Your device requires that this file be converted in order to play on the device. However, the device either does not support displaying pictures, or Windows Media Player cannot convert the file to a picture format that is supported by the device.";
                break;
            case 0xC00D1240:
                result = "Windows Media Player cannot sync the file to your computer because the file name is too long. Try renaming the file on the device.";
                break;
            case 0xC00D1241:
                result = "Windows Media Player cannot sync the file because the device is not responding. This typically occurs when there is a problem with the device firmware. For additional assistance, click Web Help.";
                break;
            case 0xC00D1242:
                result = "Incomplete playlist.";
                break;
            case 0xC00D1243:
                result = "It is not possible to perform the requested action because sync is in progress. You can either stop sync or wait for it to complete, and then try again.";
                break;
            case 0xC00D1244:
                result = "Windows Media Player cannot sync the subscription content because you are not signed in to the online store that provided it. Sign in to the online store, and then try again.";
                break;
            case 0xC00D1245:
                result = "Windows Media Player cannot convert the file to the format required by the device. One or more codecs required to convert the file could not be found.";
                break;
            case 0xC00D1246:
                result = "It is not possible to sync subscription files to this device.";
                break;
            case 0xC00D1247:
                result = "Your device is operating slowly or is not responding. Until the device responds, it is not possible to sync again. To return the device to normal operation, try disconnecting it from the computer or resetting it.";
                break;
            case 0xC00D125C:
                result = "The Windows Media Player download manager cannot function properly because the Player main window cannot be found. Try restarting the Player.";
                break;
            case 0xC00D125D:
                result = "Windows Media Player encountered a download that has the wrong number of files. This might occur if another program is trying to create jobs with the same signature as the Player.";
                break;
            case 0xC00D125E:
                result = "Windows Media Player tried to complete a download that was already canceled. The file will not be available.";
                break;
            case 0xC00D125F:
                result = "Windows Media Player tried to cancel a download that was already completed. The file will not be removed.";
                break;
            case 0xC00D1260:
                result = "Windows Media Player is trying to access a download that is not valid.";
                break;
            case 0xC00D1261:
                result = "This download was not created by Windows Media Player.";
                break;
            case 0xC00D1262:
                result = "The Windows Media Player download manager cannot create a temporary file name. This might occur if the path is not valid or if the disk is full.";
                break;
            case 0xC00D1263:
                result = "The Windows Media Player download manager plug-in cannot start. This might occur if the system is out of resources.";
                break;
            case 0xC00D1264:
                result = "The Windows Media Player download manager cannot move the file.";
                break;
            case 0xC00D1265:
                result = "The Windows Media Player download manager cannot perform a task because the system has no resources to allocate.";
                break;
            case 0xC00D1266:
                result = "The Windows Media Player download manager cannot perform a task because the task took too long to run.";
                break;
            case 0xC00D1267:
                result = "The Windows Media Player download manager cannot perform a task because the Player is terminating the service. The task will be recovered when the Player restarts.";
                break;
            case 0xC00D1268:
                result = "The Windows Media Player download manager cannot expand a WMD file. The file will be deleted and the operation will not be completed successfully.";
                break;
            case 0xC00D1269:
                result = "The Windows Media Player download manager cannot start. This might occur if the system is out of resources.";
                break;
            case 0xC00D126A:
                result = "Windows Media Player cannot access a required functionality. This might occur if the wrong system files or Player DLLs are loaded.";
                break;
            case 0xC00D126B:
                result = "Windows Media Player cannot get the file name of the requested download. The requested download will be canceled.";
                break;
            case 0xC00D128E:
                result = "Windows Media Player encountered an error while downloading an image.";
                break;
            case 0xC00D12C0:
                result = "Windows Media Player cannot update your media usage rights because the Player cannot verify the list of activated users of this computer.";
                break;
            case 0xC00D12C1:
                result = "Windows Media Player is trying to acquire media usage rights for a file that is no longer being used. Rights acquisition will stop.";
                break;
            case 0xC00D12F2:
                result = "The parameter is not valid.";
                break;
            case 0xC00D12FC:
                result = "The state is not valid for this request.";
                break;
            case 0xC00D1306:
                result = "Windows Media Player cannot play this file until you complete the software component upgrade. After the component has been upgraded, try to play the file again.";
                break;
            case 0xC00D1324:
                result = "The URL is not safe for the operation specified.";
                break;
            case 0xC00D1325:
                result = "The URL contains one or more characters that are not valid.";
                break;
            case 0xC00D1326:
                result = "The URL contains a host name that is not valid.";
                break;
            case 0xC00D1327:
                result = "The URL contains a path that is not valid.";
                break;
            case 0xC00D1328:
                result = "The URL contains a scheme that is not valid.";
                break;
            case 0xC00D1329:
                result = "The URL is not valid.";
                break;
            case 0xC00D132B:
                result = "Windows Media Player cannot play the file. If you clicked a link on a web page, the link might not be valid.";
                break;
            case 0xC00D132C:
                result = "The URL port is not valid.";
                break;
            case 0xC00D132D:
                result = "The URL is not a directory.";
                break;
            case 0xC00D132E:
                result = "The URL is not a file.";
                break;
            case 0xC00D132F:
                result = "The URL contains characters that cannot be decoded. The URL might be truncated or incomplete.";
                break;
            case 0xC00D1330:
                result = "The specified URL is not a relative URL.";
                break;
            case 0xC00D1331:
                result = "The buffer is smaller than the size specified.";
                break;
            case 0xC00D1356:
                result = "The content provider has not granted you the right to play this file. Go to the content provider's online store to get play rights.";
                break;
            case 0xC00D1357:
                result = "Windows Media Player cannot purchase or download content from multiple online stores.";
                break;
            case 0xC00D1358:
                result = "The file cannot be purchased or downloaded. The file might not be available from the online store.";
                break;
            case 0xC00D135A:
                result = "The provider of this file cannot be identified.";
                break;
            case 0xC00D135B:
                result = "The file is only available for download when you buy the entire album.";
                break;
            case 0xC00D135C:
                result = "You must buy the file before you can download it.";
                break;
            case 0xC00D135D:
                result = "You have exceeded the maximum number of files that can be purchased in a single transaction.";
                break;
            case 0xC00D135F:
                result = "Windows Media Player cannot sign in to the online store. Verify that you are using the correct user name and password. If the problem persists, the store might be temporarily unavailable.";
                break;
            case 0xC00D1360:
                result = "Windows Media Player cannot download this item because the server is not responding. The server might be temporarily unavailable or the Internet connection might be lost.";
                break;
            case 0xC00D1362:
                result = "Content Partner still initializing.";
                break;
            case 0xC00D1363:
                result = "The folder could not be opened. The folder might have been moved or deleted.";
                break;
            case 0xC00D136A:
                result = "Windows Media Player could not add all of the images to the file because the images exceeded the 7 megabyte (MB) limit.";
                break;
            case 0xC00D1388:
                result = "The client redirected to another server.";
                break;
            case 0xC00D1389:
                result = "The streaming media description is no longer current.";
                break;
            case 0xC00D138A:
                result = "It is not possible to create a persistent namespace node under a transient parent node.";
                break;
            case 0xC00D138B:
                result = "It is not possible to store a value in a namespace node that has a different value type.";
                break;
            case 0xC00D138C:
                result = "It is not possible to remove the root namespace node.";
                break;
            case 0xC00D138D:
                result = "The specified namespace node could not be found.";
                break;
            case 0xC00D138E:
                result = "The buffer supplied to hold namespace node string is too small.";
                break;
            case 0xC00D138F:
                result = "The callback list on a namespace node is at the maximum size.";
                break;
            case 0xC00D1390:
                result = "It is not possible to register an already-registered callback on a namespace node.";
                break;
            case 0xC00D1391:
                result = "Cannot find the callback in the namespace when attempting to remove the callback.";
                break;
            case 0xC00D1392:
                result = "The namespace node name exceeds the allowed maximum length.";
                break;
            case 0xC00D1393:
                result = "Cannot create a namespace node that already exists.";
                break;
            case 0xC00D1394:
                result = "The namespace node name cannot be a null string.";
                break;
            case 0xC00D1395:
                result = "Finding a child namespace node by index failed because the index exceeded the number of children.";
                break;
            case 0xC00D1396:
                result = "The namespace node name is invalid.";
                break;
            case 0xC00D1397:
                result = "It is not possible to store a value in a namespace node that has a different security type.";
                break;
            case 0xC00D13EC:
                result = "The archive request conflicts with other requests in progress.";
                break;
            case 0xC00D13ED:
                result = "The specified origin server cannot be found.";
                break;
            case 0xC00D13EE:
                result = "The specified origin server is not responding.";
                break;
            case 0xC00D13EF:
                result = "The internal code for HTTP status code 412 Precondition Failed due to not broadcast type.";
                break;
            case 0xC00D13F0:
                result = "The internal code for HTTP status code 403 Forbidden due to not cacheable.";
                break;
            case 0xC00D13F1:
                result = "The internal code for HTTP status code 304 Not Modified.";
                break;
            case 0xC00D1450:
                result = "It is not possible to remove a cache or proxy publishing point.";
                break;
            case 0xC00D1451:
                result = "It is not possible to remove the last instance of a type of plug-in.";
                break;
            case 0xC00D1452:
                result = "Cache and proxy publishing points do not support this property or method.";
                break;
            case 0xC00D1453:
                result = "The plug-in does not support the specified load type.";
                break;
            case 0xC00D1454:
                result = "The plug-in does not support any load types. The plug-in must support at least one load type.";
                break;
            case 0xC00D1455:
                result = "The publishing point name is invalid.";
                break;
            case 0xC00D1456:
                result = "Only one multicast data writer plug-in can be enabled for a publishing point.";
                break;
            case 0xC00D1457:
                result = "The requested operation cannot be completed while the publishing point is started.";
                break;
            case 0xC00D1458:
                result = "A multicast data writer plug-in must be enabled in order for this operation to be completed.";
                break;
            case 0xC00D1459:
                result = "This feature requires Windows Server 2003, Enterprise Edition.";
                break;
            case 0xC00D145A:
                result = "The requested operation cannot be completed because the specified publishing point has been removed.";
                break;
            case 0xC00D145B:
                result = "Push publishing points are started when the encoder starts pushing the stream. This publishing point cannot be started by the server administrator.";
                break;
            case 0xC00D145C:
                result = "The specified language is not supported.";
                break;
            case 0xC00D145D:
                result = "Windows Media Services will only run on Windows Server 2003, Standard Edition and Windows Server 2003, Enterprise Edition.";
                break;
            case 0xC00D145E:
                result = "The operation cannot be completed because the publishing point has been stopped.";
                break;
            case 0xC00D14B4:
                result = "The playlist entry is already playing.";
                break;
            case 0xC00D14B5:
                result = "The playlist or directory you are requesting does not contain content.";
                break;
            case 0xC00D14B6:
                result = "The server was unable to parse the requested playlist file.";
                break;
            case 0xC00D14B7:
                result = "The requested operation is not supported for this type of playlist entry.";
                break;
            case 0xC00D14B8:
                result = "Cannot jump to a playlist entry that is not inserted in the playlist.";
                break;
            case 0xC00D14B9:
                result = "Cannot seek to the desired playlist entry.";
                break;
            case 0xC00D14BA:
                result = "Cannot play recursive playlist.";
                break;
            case 0xC00D14BB:
                result = "The number of nested playlists exceeded the limit the server can handle.";
                break;
            case 0xC00D14BC:
                result = "Cannot execute the requested operation because the playlist has been shut down by the Media Server.";
                break;
            case 0xC00D14BD:
                result = "The playlist has ended while receding.";
                break;
            case 0xC00D1518:
                result = "The data path does not have an associated data writer plug-in.";
                break;
            case 0xC00D151A:
                result = "The specified push template is invalid.";
                break;
            case 0xC00D151B:
                result = "The specified push publishing point is invalid.";
                break;
            case 0xC00D151C:
                result = "The requested operation cannot be performed because the server or publishing point is in a critical error state.";
                break;
            case 0xC00D151D:
                result = "The content cannot be played because the server is not currently accepting connections. Try connecting at a later time.";
                break;
            case 0xC00D151E:
                result = "The version of this playlist is not supported by the server.";
                break;
            case 0xC00D151F:
                result = "The command does not apply to the current media header user by a server component.";
                break;
            case 0xC00D1520:
                result = "The specified publishing point name is already in use.";
                break;
            case 0xC00D157C:
                result = "There is no script engine available for this file.";
                break;
            case 0xC00D157D:
                result = "The plug-in has reported an error. See the Troubleshooting tab or the NT Application Event Log for details.";
                break;
            case 0xC00D157E:
                result = "No enabled data source plug-in is available to access the requested content.";
                break;
            case 0xC00D157F:
                result = "No enabled playlist parser plug-in is available to access the requested content.";
                break;
            case 0xC00D1580:
                result = "The data source plug-in does not support enumeration.";
                break;
            case 0xC00D1581:
                result = "The server cannot stream the selected file because it is either damaged or corrupt. Select a different file.";
                break;
            case 0xC00D1582:
                result = "The plug-in cannot be enabled because a compatible script debugger is not installed on this system. Install a script debugger, or disable the script debugger option on the general tab of the plug-in's properties page and try again.";
                break;
            case 0xC00D1583:
                result = "The plug-in cannot be loaded because it requires Windows Server 2003, Enterprise Edition.";
                break;
            case 0xC00D1584:
                result = "Another wizard is currently running. Please close the other wizard or wait until it finishes before attempting to run this wizard again.";
                break;
            case 0xC00D1585:
                result = "Invalid log URL. Multicast logging URL must look like \"http://servername/isapibackend.dll\".";
                break;
            case 0xC00D1586:
                result = "Invalid MTU specified. The valid range for maximum packet size is between 36 and 65507 bytes.";
                break;
            case 0xC00D1587:
                result = "Invalid play statistics for logging.";
                break;
            case 0xC00D1588:
                result = "The log needs to be skipped.";
                break;
            case 0xC00D1589:
                result = "The size of the data exceeded the limit the WMS HTTP Download Data Source plugin can handle.";
                break;
            case 0xC00D158A:
                result = "One usage of each socket address (protocol/network address/port) is permitted. Verify that other services or applications are not attempting to use the same port and then try to enable the plug-in again.";
                break;
            case 0xC00D158B:
                result = "One usage of each socket address (protocol/network address/port) is permitted. Verify that other services (such as IIS) or applications are not attempting to use the same port and then try to enable the plug-in again.";
                break;
            case 0xC00D158C:
                result = "The WMS HTTP Download Data Source plugin was unable to receive the remote server's response.";
                break;
            case 0xC00D158D:
                result = "The archive plug-in has reached its quota.";
                break;
            case 0xC00D158E:
                result = "The archive plug-in aborted because the source was from broadcast.";
                break;
            case 0xC00D158F:
                result = "The archive plug-in detected an interrupt in the source.";
                break;
            case 0xC00D1590:
                result = "The system cannot find the file specified.";
                break;
            case 0xC00D1B58:
                result = "The mark-in time should be greater than 0 and less than the mark-out time.";
                break;
            case 0xC00D1B59:
                result = "The mark-out time should be greater than the mark-in time and less than the file duration.";
                break;
            case 0xC00D1B5A:
                result = "No matching media type is found in the source %1.";
                break;
            case 0xC00D1B5B:
                result = "The specified source type is not supported.";
                break;
            case 0xC00D1B5C:
                result = "It is not possible to specify more than one audio input.";
                break;
            case 0xC00D1B5D:
                result = "It is not possible to specify more than two video inputs.";
                break;
            case 0xC00D1B5E:
                result = "No matching element is found in the list.";
                break;
            case 0xC00D1B5F:
                result = "The profile's media types must match the media types defined for the session.";
                break;
            case 0xC00D1B60:
                result = "It is not possible to remove an active source while encoding.";
                break;
            case 0xC00D1B61:
                result = "It is not possible to open the specified audio capture device because it is currently in use.";
                break;
            case 0xC00D1B62:
                result = "It is not possible to open the specified audio capture device because an unexpected error has occurred.";
                break;
            case 0xC00D1B63:
                result = "The audio capture device does not support the specified audio format.";
                break;
            case 0xC00D1B64:
                result = "It is not possible to open the specified video capture device because it is currently in use.";
                break;
            case 0xC00D1B65:
                result = "It is not possible to open the specified video capture device because an unexpected error has occurred.";
                break;
            case 0xC00D1B66:
                result = "This operation is not allowed while encoding.";
                break;
            case 0xC00D1B67:
                result = "No profile is set for the source.";
                break;
            case 0xC00D1B68:
                result = "The video capture driver returned an unrecoverable error. It is now in an unstable state.";
                break;
            case 0xC00D1B69:
                result = "It was not possible to start the video device.";
                break;
            case 0xC00D1B6A:
                result = "The video source does not support the requested output format or color depth.";
                break;
            case 0xC00D1B6B:
                result = "The video source does not support the requested capture size.";
                break;
            case 0xC00D1B6C:
                result = "It was not possible to obtain output information from the video compressor.";
                break;
            case 0xC00D1B6D:
                result = "It was not possible to create a video capture window.";
                break;
            case 0xC00D1B6E:
                result = "There is already a stream active on this video device.";
                break;
            case 0xC00D1B6F:
                result = "No media format is set in source.";
                break;
            case 0xC00D1B70:
                result = "Cannot find a valid output stream from the source.";
                break;
            case 0xC00D1B71:
                result = "It was not possible to find a valid source plug-in for the specified source.";
                break;
            case 0xC00D1B72:
                result = "No source is currently active.";
                break;
            case 0xC00D1B73:
                result = "No script stream is set in the current source.";
                break;
            case 0xC00D1B74:
                result = "This operation is not allowed while archiving.";
                break;
            case 0xC00D1B75:
                result = "The setting for the maximum packet size is not valid.";
                break;
            case 0xC00D1B76:
                result = "The plug-in CLSID specified is not valid.";
                break;
            case 0xC00D1B77:
                result = "This archive type is not supported.";
                break;
            case 0xC00D1B78:
                result = "This archive operation is not supported.";
                break;
            case 0xC00D1B79:
                result = "The local archive file name was not set.";
                break;
            case 0xC00D1B7A:
                result = "The source is not yet prepared.";
                break;
            case 0xC00D1B7B:
                result = "Profiles on the sources do not match.";
                break;
            case 0xC00D1B7C:
                result = "The specified crop values are not valid.";
                break;
            case 0xC00D1B7D:
                result = "No statistics are available at this time.";
                break;
            case 0xC00D1B7E:
                result = "The encoder is not archiving.";
                break;
            case 0xC00D1B7F:
                result = "This operation is only allowed during encoding.";
                break;
            case 0xC00D1B80:
                result = "This SourceGroupCollection doesn't contain any SourceGroups.";
                break;
            case 0xC00D1B81:
                result = "This source does not have a frame rate of 30 fps. Therefore, it is not possible to apply the inverse telecine filter to the source.";
                break;
            case 0xC00D1B82:
                result = "It is not possible to display your source or output video in the Video panel.";
                break;
            case 0xC00D1B83:
                result = "One or more codecs required to open this content could not be found.";
                break;
            case 0xC00D1B84:
                result = "The archive file has the same name as an input file. Change one of the names before continuing.";
                break;
            case 0xC00D1B85:
                result = "The source has not been set up completely.";
                break;
            case 0xC00D1B86:
                result = "It is not possible to apply time compression to a broadcast session.";
                break;
            case 0xC00D1B87:
                result = "It is not possible to open this device.";
                break;
            case 0xC00D1B88:
                result = "It is not possible to start encoding because the display size or color has changed since the current session was defined. Restore the previous settings or create a new session.";
                break;
            case 0xC00D1B89:
                result = "No audio data has been received for several seconds. Check the audio source and restart the encoder.";
                break;
            case 0xC00D1B8A:
                result = "One or all of the specified sources are not working properly. Check that the sources are configured correctly.";
                break;
            case 0xC00D1B8B:
                result = "The supplied configuration file is not supported by this version of the encoder.";
                break;
            case 0xC00D1B8C:
                result = "It is not possible to use image preprocessing with live encoding.";
                break;
            case 0xC00D1B8D:
                result = "It is not possible to use two-pass encoding when the source is set to loop.";
                break;
            case 0xC00D1B8E:
                result = "It is not possible to pause encoding during a broadcast.";
                break;
            case 0xC00D1B8F:
                result = "A DRM profile has not been set for the current session.";
                break;
            case 0xC00D1B90:
                result = "The profile ID is already used by a DRM profile. Specify a different profile ID.";
                break;
            case 0xC00D1B91:
                result = "The setting of the selected device does not support control for playing back tapes.";
                break;
            case 0xC00D1B92:
                result = "You must specify a mixed voice and audio mode in order to use an optimization definition file.";
                break;
            case 0xC00D1B93:
                result = "The specified password is too long. Type a password with fewer than 8 characters.";
                break;
            case 0xC00D1B94:
                result = "It is not possible to seek to the specified mark-in point.";
                break;
            case 0xC00D1B95:
                result = "When you choose to maintain the interlacing in your video, the output video size must match the input video size.";
                break;
            case 0xC00D1B96:
                result = "Only one device control plug-in can control a device.";
                break;
            case 0xC00D1B97:
                result = "You must also enable storing content to hard disk temporarily in order to use two-pass encoding with the input device.";
                break;
            case 0xC00D1B98:
                result = "An audience is missing from the output stream configuration.";
                break;
            case 0xC00D1B99:
                result = "All audiences in the output tree must have the same content type.";
                break;
            case 0xC00D1B9A:
                result = "A source index is missing from the output stream configuration.";
                break;
            case 0xC00D1B9B:
                result = "The same source index in different audiences should have the same number of languages.";
                break;
            case 0xC00D1B9C:
                result = "The same source index in different audiences should have the same languages.";
                break;
            case 0xC00D1B9D:
                result = "The same source index in different audiences should use the same VBR encoding mode.";
                break;
            case 0xC00D1B9E:
                result = "The bit rate index specified is not valid.";
                break;
            case 0xC00D1B9F:
                result = "The specified language is not valid.";
                break;
            case 0xC00D1BA0:
                result = "The specified source type is not valid.";
                break;
            case 0xC00D1BA1:
                result = "The source must be a mono channel .wav file.";
                break;
            case 0xC00D1BA2:
                result = "All the source .wav files must have the same format.";
                break;
            case 0xC00D1BA3:
                result = "The hard disk being used for temporary storage of content has reached the minimum allowed disk space. Create more space on the hard disk and restart encoding.";
                break;
            case 0xC00D1BA4:
                result = "It is not possible to apply the inverse telecine feature to PAL content.";
                break;
            case 0xC00D1BA5:
                result = "A capture device in the current active source is no longer available.";
                break;
            case 0xC00D1BA6:
                result = "A device used in the current active source for device control is no longer available.";
                break;
            case 0xC00D1BA7:
                result = "No frames have been submitted to the analyzer for analysis.";
                break;
            case 0xC00D1BA8:
                result = "The source video does not support time codes.";
                break;
            case 0xC00D1BA9:
                result = "It is not possible to generate a time code when there are multiple sources in a session.";
                break;
            case 0xC00D1BAA:
                result = "The voice codec optimization definition file cannot be found or is corrupted.";
                break;
            case 0xC00D1BAB:
                result = "The same source index in different audiences should have the same interlace mode.";
                break;
            case 0xC00D1BAC:
                result = "The same source index in different audiences should have the same nonsquare pixel mode.";
                break;
            case 0xC00D1BAD:
                result = "The same source index in different audiences should have the same time code mode.";
                break;
            case 0xC00D1BAE:
                result = "Either the end of the tape has been reached or there is no tape. Check the device and tape.";
                break;
            case 0xC00D1BAF:
                result = "No audio or video input has been specified.";
                break;
            case 0xC00D1BB0:
                result = "The profile must contain a bit rate.";
                break;
            case 0xC00D1BB1:
                result = "You must specify at least one audio stream to be compatible with Windows Media Player 7.1.";
                break;
            case 0xC00D1BB2:
                result = "Using a VBR encoding mode is not compatible with Windows Media Player 7.1.";
                break;
            case 0xC00D1BB3:
                result = "You must specify a profile name.";
                break;
            case 0xC00D1BB4:
                result = "It is not possible to use a VBR encoding mode with uncompressed audio or video.";
                break;
            case 0xC00D1BB5:
                result = "It is not possible to use MBR encoding with VBR encoding.";
                break;
            case 0xC00D1BB6:
                result = "It is not possible to mix uncompressed and compressed content in a session.";
                break;
            case 0xC00D1BB7:
                result = "All audiences must use the same audio codec.";
                break;
            case 0xC00D1BB8:
                result = "All audiences should use the same audio format to be compatible with Windows Media Player 7.1.";
                break;
            case 0xC00D1BB9:
                result = "The audio bit rate for an audience with a higher total bit rate must be greater than one with a lower total bit rate.";
                break;
            case 0xC00D1BBA:
                result = "The audio peak bit rate setting is not valid.";
                break;
            case 0xC00D1BBB:
                result = "The audio peak bit rate setting must be greater than the audio bit rate setting.";
                break;
            case 0xC00D1BBC:
                result = "The setting for the maximum buffer size for audio is not valid.";
                break;
            case 0xC00D1BBD:
                result = "All audiences must use the same video codec.";
                break;
            case 0xC00D1BBE:
                result = "All audiences should use the same video size to be compatible with Windows Media Player 7.1.";
                break;
            case 0xC00D1BBF:
                result = "The video bit rate setting is not valid.";
                break;
            case 0xC00D1BC0:
                result = "The video bit rate for an audience with a higher total bit rate must be greater than one with a lower total bit rate.";
                break;
            case 0xC00D1BC1:
                result = "The video peak bit rate setting is not valid.";
                break;
            case 0xC00D1BC2:
                result = "The video peak bit rate setting must be greater than the video bit rate setting.";
                break;
            case 0xC00D1BC3:
                result = "The video width setting is not valid.";
                break;
            case 0xC00D1BC4:
                result = "The video height setting is not valid.";
                break;
            case 0xC00D1BC5:
                result = "The video frame rate setting is not valid.";
                break;
            case 0xC00D1BC6:
                result = "The video key frame setting is not valid.";
                break;
            case 0xC00D1BC7:
                result = "The video image quality setting is not valid.";
                break;
            case 0xC00D1BC8:
                result = "The video codec quality setting is not valid.";
                break;
            case 0xC00D1BC9:
                result = "The video buffer setting is not valid.";
                break;
            case 0xC00D1BCA:
                result = "The setting for the maximum buffer size for video is not valid.";
                break;
            case 0xC00D1BCB:
                result = "The value of the video maximum buffer size setting must be greater than the video buffer size setting.";
                break;
            case 0xC00D1BCC:
                result = "The alignment of the video width is not valid.";
                break;
            case 0xC00D1BCD:
                result = "The alignment of the video height is not valid.";
                break;
            case 0xC00D1BCE:
                result = "All bit rates must have the same script bit rate.";
                break;
            case 0xC00D1BCF:
                result = "The script bit rate specified is not valid.";
                break;
            case 0xC00D1BD0:
                result = "All bit rates must have the same file transfer bit rate.";
                break;
            case 0xC00D1BD1:
                result = "The file transfer bit rate is not valid.";
                break;
            case 0xC00D1BD2:
                result = "All audiences in a profile should either be same as input or have video width and height specified.";
                break;
            case 0xC00D1BD3:
                result = "This source type does not support looping.";
                break;
            case 0xC00D1BD4:
                result = "The fold-down value needs to be between -144 and 0.";
                break;
            case 0xC00D1BD5:
                result = "The specified DRM profile does not exist in the system.";
                break;
            case 0xC00D1BD6:
                result = "The specified time code is not valid.";
                break;
            case 0xC00D1BD7:
                result = "It is not possible to apply time compression to a video-only session.";
                break;
            case 0xC00D1BD8:
                result = "It is not possible to apply time compression to a session that is using two-pass encoding.";
                break;
            case 0xC00D1BD9:
                result = "It is not possible to generate a time code for an audio-only session.";
                break;
            case 0xC00D1BDA:
                result = "It is not possible to generate a time code when you are encoding content at multiple bit rates.";
                break;
            case 0xC00D1BDB:
                result = "The video codec selected does not support maintaining interlacing in video.";
                break;
            case 0xC00D1BDC:
                result = "Maintaining interlacing in video is not compatible with Windows Media Player 7.1.";
                break;
            case 0xC00D1BDD:
                result = "Allowing nonsquare pixel output is not compatible with Windows Media Player 7.1.";
                break;
            case 0xC00D1BDE:
                result = "Only capture devices can be used with device control.";
                break;
            case 0xC00D1BDF:
                result = "It is not possible to generate the stream format file if you are using quality-based VBR encoding for the audio or video stream. Instead use the Windows Media file generated after encoding to create the announcement file.";
                break;
            case 0xC00D1BE0:
                result = "It is not possible to create a DRM profile because the maximum number of profiles has been reached. You must delete some DRM profiles before creating new ones.";
                break;
            case 0xC00D1BE1:
                result = "The device is in an unstable state. Check that the device is functioning properly and a tape is in place.";
                break;
            case 0xC00D1BE2:
                result = "The pixel aspect ratio value must be between 1 and 255.";
                break;
            case 0xC00D1BE3:
                result = "All streams with different languages in the same audience must have same properties.";
                break;
            case 0xC00D1BE4:
                result = "The profile must contain at least one audio or video stream.";
                break;
            case 0xC00D1BE5:
                result = "The transform plug-in could not be found.";
                break;
            case 0xC00D1BE6:
                result = "The transform plug-in is not valid. It might be damaged or you might not have the required permissions to access the plug-in.";
                break;
            case 0xC00D1BE7:
                result = "To use two-pass encoding, you must enable device control and setup an edit decision list (EDL) that has at least one entry.";
                break;
            case 0xC00D1BE8:
                result = "When you choose to maintain the interlacing in your video, the output video size must be a multiple of 4.";
                break;
            case 0xC00D1BE9:
                result = "Markin/Markout is unsupported with this source type.";
                break;
            case 0xC00D2711:
                result = "A problem has occurred in the Digital Rights Management component. Contact product support for this application.";
                break;
            case 0xC00D2712:
                result = "License storage is not working. Contact Microsoft product support.";
                break;
            case 0xC00D2713:
                result = "Secure storage is not working. Contact Microsoft product support.";
                break;
            case 0xC00D2714:
                result = "License acquisition did not work. Acquire a new license or contact the content provider for further assistance.";
                break;
            case 0xC00D2715:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2716:
                result = "The media file is corrupted. Contact the content provider to get a new file.";
                break;
            case 0xC00D2717:
                result = "The license is corrupted. Acquire a new license.";
                break;
            case 0xC00D2718:
                result = "The license is corrupted or invalid. Acquire a new license";
                break;
            case 0xC00D2719:
                result = "Licenses cannot be copied from one computer to another. Use License Management to transfer licenses, or get a new license for the media file.";
                break;
            case 0xC00D271B:
                result = "License storage is not working. Contact Microsoft product support.";
                break;
            case 0xC00D271C:
                result = "The media file is corrupted. Contact the content provider to get a new file.";
                break;
            case 0xC00D271D:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D271E:
                result = "The license could not be acquired. Try again later.";
                break;
            case 0xC00D271F:
                result = "License acquisition did not work. Acquire a new license or contact the content provider for further assistance.";
                break;
            case 0xC00D2720:
                result = "The requested operation cannot be performed on this file.";
                break;
            case 0xC00D2721:
                result = "The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer.";
                break;
            case 0xC00D2722:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2723:
                result = "The media file is corrupted. Contact the content provider to get a new file.";
                break;
            case 0xC00D2725:
                result = "The license is corrupted. Acquire a new license.";
                break;
            case 0xC00D2728:
                result = "A security upgrade is required to perform the operation on this media file.";
                break;
            case 0xC00D2729:
                result = "You already have the latest security components. No upgrade is necessary at this time.";
                break;
            case 0xC00D272A:
                result = "The application cannot perform this action. Contact product support for this application.";
                break;
            case 0xC00D272B:
                result = "You cannot begin a new license acquisition process until the current one has been completed.";
                break;
            case 0xC00D272C:
                result = "You cannot begin a new security upgrade until the current one has been completed.";
                break;
            case 0xC00D272D:
                result = "Failure in Backup-Restore.";
                break;
            case 0xC00D272E:
                result = "Bad Request ID in Backup-Restore.";
                break;
            case 0xC00D272F:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2730:
                result = "A license cannot be created for this media file. Reinstall the application.";
                break;
            case 0xC00D2731:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2732:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2733:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2734:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2735:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2736:
                result = "The security upgrade failed. Try again later.";
                break;
            case 0xC00D2737:
                result = "License storage is not working. Contact Microsoft product support.";
                break;
            case 0xC00D2738:
                result = "License storage is not working. Contact Microsoft product support.";
                break;
            case 0xC00D2739:
                result = "License storage is not working. Contact Microsoft product support.";
                break;
            case 0xC00D273A:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D273B:
                result = "A problem has occurred in the Digital Rights Management component. Contact product support for this application.";
                break;
            case 0xC00D273C:
                result = "License storage is not working. Contact Microsoft product support.";
                break;
            case 0xC00D273D:
                result = "The media file is corrupted. Contact the content provider to get a new file.";
                break;
            case 0xC00D273E:
                result = "A problem has occurred in the Digital Rights Management component. Try again later.";
                break;
            case 0xC00D273F:
                result = "The application has made an invalid call to the Digital Rights Management component. Contact product support for this application.";
                break;
            case 0xC00D2740:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2741:
                result = "A problem has occurred in the Digital Rights Management component. Contact product support for this application.";
                break;
            case 0xC00D2742:
                result = "Licenses are already backed up in this location.";
                break;
            case 0xC00D2743:
                result = "One or more backed-up licenses are missing or corrupt.";
                break;
            case 0xC00D2744:
                result = "You cannot begin a new backup process until the current process has been completed.";
                break;
            case 0xC00D2745:
                result = "Bad Data sent to Backup-Restore.";
                break;
            case 0xC00D2748:
                result = "The license is invalid. Contact the content provider for further assistance.";
                break;
            case 0xC00D2749:
                result = "A required property was not set by the application. Contact product support for this application.";
                break;
            case 0xC00D274A:
                result = "A problem has occurred in the Digital Rights Management component of this application. Try to acquire a license again.";
                break;
            case 0xC00D274B:
                result = "A license cannot be found for this media file. Use License Management to transfer a license for this file from the original computer, or acquire a new license.";
                break;
            case 0xC00D274C:
                result = "A problem occurred during the security upgrade. Try again later.";
                break;
            case 0xC00D274D:
                result = "Certified driver components are required to play this media file. Contact Windows Update to see whether updated drivers are available for your hardware.";
                break;
            case 0xC00D274E:
                result = "One or more of the Secure Audio Path components were not found or an entry point in those components was not found.";
                break;
            case 0xC00D274F:
                result = "Status message: Reopen the file.";
                break;
            case 0xC00D2750:
                result = "Certain driver functionality is required to play this media file. Contact Windows Update to see whether updated drivers are available for your hardware.";
                break;
            case 0xC00D2751:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2752:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2753:
                result = "You cannot restore your license(s).";
                break;
            case 0xC00D2754:
                result = "The licenses for your media files are corrupted. Contact Microsoft product support.";
                break;
            case 0xC00D2755:
                result = "To transfer this media file, you must upgrade the application.";
                break;
            case 0xC00D2756:
                result = "You cannot make any more copies of this media file.";
                break;
            case 0xC00D2757:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2758:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2759:
                result = "Unable to obtain license.";
                break;
            case 0xC00D275A:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D275B:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D275C:
                result = "The buffer supplied is not sufficient.";
                break;
            case 0xC00D275D:
                result = "The property requested is not supported.";
                break;
            case 0xC00D275E:
                result = "The specified server cannot perform the requested operation.";
                break;
            case 0xC00D275F:
                result = "Some of the licenses could not be stored.";
                break;
            case 0xC00D2760:
                result = "The Digital Rights Management security upgrade component could not be validated. Contact Microsoft product support.";
                break;
            case 0xC00D2761:
                result = "Invalid or corrupt data was encountered.";
                break;
            case 0xC00D2762:
                result = "The Windows Media Digital Rights Management system cannot perform the requested action because your computer or network administrator has enabled the group policy Prevent Windows Media DRM Internet Access. For assistance, contact your administrator.";
                break;
            case 0xC00D2763:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2764:
                result = "Not all of the necessary properties for DRM have been set.";
                break;
            case 0xC00D2765:
                result = "The portable device does not have the security required to copy protected files to it. To obtain the additional security, try to copy the file to your portable device again. When a message appears, click OK.";
                break;
            case 0xC00D2766:
                result = "Too many resets in Backup-Restore.";
                break;
            case 0xC00D2767:
                result = "Running this process under a debugger while using DRM content is not allowed.";
                break;
            case 0xC00D2768:
                result = "The user canceled the DRM operation.";
                break;
            case 0xC00D2769:
                result = "The license you are using has assocaited output restrictions. This license is unusable until these restrictions are queried.";
                break;
            case 0xC00D276A:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D276B:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D276C:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D276D:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2770:
                result = "The specified track has exceeded it's specified playlist burn limit in this playlist.";
                break;
            case 0xC00D2771:
                result = "The specified track has exceeded it's track burn limit.";
                break;
            case 0xC00D2772:
                result = "A problem has occurred in obtaining the device's certificate. Contact Microsoft product support.";
                break;
            case 0xC00D2773:
                result = "A problem has occurred in obtaining the device's secure clock. Contact Microsoft product support.";
                break;
            case 0xC00D2774:
                result = "A problem has occurred in setting the device's secure clock. Contact Microsoft product support.";
                break;
            case 0xC00D2775:
                result = "A problem has occurred in obtaining the secure clock from server. Contact Microsoft product support.";
                break;
            case 0xC00D2776:
                result = "This content requires the metering policy to be enabled.";
                break;
            case 0xC00D2777:
                result = "Transfer of chained licenses unsupported.";
                break;
            case 0xC00D2778:
                result = "The Digital Rights Management component is not installed properly. Reinstall the Player.";
                break;
            case 0xC00D2779:
                result = "The file could not be transferred because the device clock is not set.";
                break;
            case 0xC00D277A:
                result = "The content header is missing an acquisition URL.";
                break;
            case 0xC00D277B:
                result = "The current attached device does not support WMDRM.";
                break;
            case 0xC00D277C:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D277D:
                result = "The client application has been forcefully terminated during a DRM petition.";
                break;
            case 0xC00D277E:
                result = "The client application has been forcefully terminated during a DRM challenge.";
                break;
            case 0xC00D277F:
                result = "Secure storage protection error. Restore your licenses from a previous backup and try again.";
                break;
            case 0xC00D2780:
                result = "A problem has occurred in the Digital Rights Management root of trust. Contact Microsoft product support.";
                break;
            case 0xC00D2781:
                result = "A problem has occurred in retrieving the Digital Rights Management machine identification. Contact Microsoft product support.";
                break;
            case 0xC00D2782:
                result = "A problem has occurred in opening the Digital Rights Management data storage file. Contact Microsoft product.";
                break;
            case 0xC00D2783:
                result = "The Digital Rights Management data storage is not functioning properly. Contact Microsoft product support.";
                break;
            case 0xC00D2784:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2785:
                result = "A secured library is required to access the requested functionality.";
                break;
            case 0xC00D2786:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2787:
                result = "A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support.";
                break;
            case 0xC00D2788:
                result = "A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support.";
                break;
            case 0xC00D2789:
                result = "A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support.";
                break;
            case 0xC00D278A:
                result = "A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support.";
                break;
            case 0xC00D278B:
                result = "A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support.";
                break;
            case 0xC00D278C:
                result = "The Digital Rights Management component is in use during license migration. Contact Microsoft product support.";
                break;
            case 0xC00D278D:
                result = "Licenses are being migrated to a machine running XP or downlevel OS. This operation can only be performed on Windows Vista or a later OS. Contact Microsoft product support.";
                break;
            case 0xC00D278E:
                result = "Migration Image already exists. Contact Microsoft product support.";
                break;
            case 0xC00D278F:
                result = "The requested action cannot be performed because a hardware configuration change has been detected by the Windows Media Digital Rights Management (DRM) components on your computer.";
                break;
            case 0xC00D2790:
                result = "The wrong stublib has been linked to an application or DLL using drmv2clt.dll.";
                break;
            case 0xC00D2791:
                result = "The legacy V2 data being imported is invalid.";
                break;
            case 0xC00D2792:
                result = "The license being imported already exists.";
                break;
            case 0xC00D2793:
                result = "The password of the Legacy V2 SST entry being imported is incorrect.";
                break;
            case 0xC00D2794:
                result = "Migration is not supported by the plugin.";
                break;
            case 0xC00D2795:
                result = "A migration importer cannot be created for this media file. Reinstall the application.";
                break;
            case 0xC00D2796:
                result = "The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer.";
                break;
            case 0xC00D2797:
                result = "The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer.";
                break;
            case 0xC00D2798:
                result = "The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer.";
                break;
            case 0xC00D2799:
                result = "The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer.";
                break;
            case 0xC00D279A:
                result = "Migration was canceled by the user.";
                break;
            case 0xC00D279B:
                result = "Migration object is already in use and cannot be called until the current operation completes.";
                break;
            case 0xC00D279C:
                result = "The content header does not comply with DRM requirements and cannot be used.";
                break;
            case 0xC00D27D8:
                result = "The license for this file has expired and is no longer valid. Contact your content provider for further assistance.";
                break;
            case 0xC00D27D9:
                result = "The license for this file is not valid yet, but will be at a future date.";
                break;
            case 0xC00D27DA:
                result = "The license for this file requires a higher level of security than the player you are currently using has. Try using a different player or download a newer version of your current player.";
                break;
            case 0xC00D27DB:
                result = "The license cannot be stored as it requires security upgrade of Digital Rights Management component.";
                break;
            case 0xC00D27DC:
                result = "Your machine does not meet the requirements for storing the license.";
                break;
            case 0xC00D27DD:
                result = "The license for this file requires an upgraded version of your player or a different player.";
                break;
            case 0xC00D27DF:
                result = "The license server's certificate expired. Make sure your system clock is set correctly. Contact your content provider for further assistance.";
                break;
            case 0xC00D27E0:
                result = "The license for this file requires a higher level of security than the player you are currently using has. Try using a different player or download a newer version of your current player.";
                break;
            case 0xC00D27E1:
                result = "The content owner for the license you just acquired is no longer supporting their content. Contact the content owner for a newer version of the content.";
                break;
            case 0xC00D27E2:
                result = "The content owner for the license you just acquired requires your device to register to the current machine.";
                break;
            case 0xC00D280A:
                result = "The license for this file requires a feature that is not supported in your current player or operating system. You can try with newer version of your current player or contact your content provider for further assistance.";
                break;
            case 0xC00D280B:
                result = "The license for this file requires a feature that is not supported in your current player or operating system. You can try with newer version of your current player or contact your content provider for further assistance.";
                break;
            case 0xC00D280C:
                result = "The license for this file requires Windows Driver Model (WDM) audio drivers. Contact your sound card manufacturer for further assistance.";
                break;
            case 0xC00D280D:
                result = "The license for this file requires a higher level of security than the player you are currently using has. Try using a different player or download a newer version of your current player.";
                break;
            case 0xC00D280E:
                result = "The license for this file is not supported by your current player. You can try with newer version of your current player or contact your content provider for further assistance.";
                break;
            case 0xC00D283D:
                result = "An updated version of your media player is required to play the selected content.";
                break;
            case 0xC00D283E:
                result = "A new version of the Digital Rights Management component is required. Contact product support for this application to get the latest version.";
                break;
            case 0xC00D283F:
                result = "Failed to either create or verify the content header.";
                break;
            case 0xC00D2840:
                result = "Could not read the necessary information from the system registry.";
                break;
            case 0xC00D2841:
                result = "The DRM subsystem is currently locked by another application or user. Try again later.";
                break;
            case 0xC00D2842:
                result = "There are too many target devices registered on the portable media.";
                break;
            case 0xC00D2843:
                result = "The security upgrade cannot be completed because the allowed number of daily upgrades has been exceeded. Try again tomorrow.";
                break;
            case 0xC00D2844:
                result = "The security upgrade cannot be completed because the server is unable to perform the operation. Try again later.";
                break;
            case 0xC00D2845:
                result = "The security upgrade cannot be performed because the server is not available. Try again later.";
                break;
            case 0xC00D2846:
                result = "Windows Media Player cannot restore your licenses because the server is not available. Try again later.";
                break;
            case 0xC00D2847:
                result = "Windows Media Player cannot play the protected file. Verify that your computer's date is set correctly. If it is correct, on the Help menu, click Check for Player Updates to install the latest version of the Player.";
                break;
            case 0xC00D2848:
                result = "The chained license cannot be created because the referenced uplink license does not exist.";
                break;
            case 0xC00D2849:
                result = "The specified KID is invalid.";
                break;
            case 0xC00D284A:
                result = "License initialization did not work. Contact Microsoft product support.";
                break;
            case 0xC00D284C:
                result = "The uplink license of a chained license cannot itself be a chained license.";
                break;
            case 0xC00D284D:
                result = "The specified encryption algorithm is unsupported.";
                break;
            case 0xC00D284E:
                result = "License deletion did not work. Contact Microsoft product support.";
                break;
            case 0xC00D28A0:
                result = "The client's certificate is corrupted or the signature cannot be verified.";
                break;
            case 0xC00D28A1:
                result = "The client's certificate has been revoked.";
                break;
            case 0xC00D28A2:
                result = "There is no license available for the requested action.";
                break;
            case 0xC00D28A3:
                result = "The maximum number of devices in use has been reached. Unable to open additional devices.";
                break;
            case 0xC00D28A4:
                result = "The proximity detection procedure could not confirm that the receiver is near the transmitter in the network.";
                break;
            case 0xC00D28A5:
                result = "The client must be registered before executing the intended operation.";
                break;
            case 0xC00D28A6:
                result = "The client must be approved before executing the intended operation.";
                break;
            case 0xC00D28A7:
                result = "The client must be revalidated before executing the intended operation.";
                break;
            case 0xC00D28A8:
                result = "The response to the proximity detection challenge is invalid.";
                break;
            case 0xC00D28A9:
                result = "The requested session is invalid.";
                break;
            case 0xC00D28AA:
                result = "The device must be opened before it can be used to receive content.";
                break;
            case 0xC00D28AB:
                result = "Device registration failed because the device is already registered.";
                break;
            case 0xC00D28AC:
                result = "Unsupported WMDRM-ND protocol version.";
                break;
            case 0xC00D28AD:
                result = "The requested action is not supported.";
                break;
            case 0xC00D28AE:
                result = "The certificate does not have an adequate security level for the requested action.";
                break;
            case 0xC00D28AF:
                result = "Unable to open the specified port for receiving Proximity messages.";
                break;
            case 0xC00D28B0:
                result = "The message format is invalid.";
                break;
            case 0xC00D28B1:
                result = "The Certificate Revocation List is invalid or corrupted.";
                break;
            case 0xC00D28B2:
                result = "The length of the attribute name or value is too long.";
                break;
            case 0xC00D28B3:
                result = "The license blob passed in the cardea request is expired.";
                break;
            case 0xC00D28B4:
                result = "The license blob passed in the cardea request is invalid. Contact Microsoft product support.";
                break;
            case 0xC00D28B5:
                result = "The requested operation cannot be performed because the license does not contain an inclusion list.";
                break;
            case 0xC00D28B6:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D28B7:
                result = "A problem has occurred in the Digital Rights Management component. Contact Microsoft product support.";
                break;
            case 0xC00D2904:
                result = "Windows Media Player does not support the level of output protection required by the content.";
                break;
            case 0xC00D2905:
                result = "Windows Media Player does not support the level of protection required for compressed digital video.";
                break;
            case 0xC00D2906:
                result = "Windows Media Player does not support the level of protection required for uncompressed digital video.";
                break;
            case 0xC00D2907:
                result = "Windows Media Player does not support the level of protection required for analog video.";
                break;
            case 0xC00D2908:
                result = "Windows Media Player does not support the level of protection required for compressed digital audio.";
                break;
            case 0xC00D2909:
                result = "Windows Media Player does not support the level of protection required for uncompressed digital audio.";
                break;
            case 0xC00D290A:
                result = "Windows Media Player does not support the scheme of output protection required by the content.";
                break;
            case 0xC00D2AFA:
                result = "Installation was not successful and some file cleanup is not complete. For best results, restart your computer.";
                break;
            case 0xC00D2AFB:
                result = "Installation was not successful. To continue, you must restart your computer.";
                break;
            case 0xC00D2AFC:
                result = "Installation was not successful.";
                break;
            case 0xC00D2AFD:
                result = "Setup cannot migrate the Windows Media Digital Rights Management (DRM) components.";
                break;
            case 0xC00D2AFE:
                result = "Some skin or playlist components cannot be installed.";
                break;
            case 0xC00D2AFF:
                result = "Setup cannot migrate the Windows Media Digital Rights Management (DRM) components. In addition, some skin or playlist components cannot be installed.";
                break;
            case 0xC00D2B00:
                result = "Installation is blocked because your computer does not meet one or more of the setup requirements.";
                break;
            case 0xC00D2EE0:
                result = "The specified protocol is not supported.";
                break;
            case 0xC00D2EE1:
                result = "The client is redirected to a proxy server.";
                break;
            case 0xC00D2EE2:
                result = "The server encountered an unexpected condition which prevented it from fulfilling the request.";
                break;
            case 0xC00D2EE3:
                result = "The request could not be understood by the server.";
                break;
            case 0xC00D2EE4:
                result = "The proxy experienced an error while attempting to contact the media server.";
                break;
            case 0xC00D2EE5:
                result = "The proxy did not receive a timely response while attempting to contact the media server.";
                break;
            case 0xC00D2EE6:
                result = "The server is currently unable to handle the request due to a temporary overloading or maintenance of the server.";
                break;
            case 0xC00D2EE7:
                result = "The server is refusing to fulfill the requested operation.";
                break;
            case 0xC00D2EE8:
                result = "The server is not a compatible streaming media server.";
                break;
            case 0xC00D2EE9:
                result = "The content cannot be streamed because the Multicast protocol has been disabled.";
                break;
            case 0xC00D2EEA:
                result = "The server redirected the player to an invalid location.";
                break;
            case 0xC00D2EEB:
                result = "The content cannot be streamed because all protocols have been disabled.";
                break;
            case 0xC00D2EEC:
                result = "The MSBD protocol is no longer supported. Please use HTTP to connect to the Windows Media stream.";
                break;
            case 0xC00D2EED:
                result = "The proxy server could not be located. Please check your proxy server configuration.";
                break;
            case 0xC00D2EEE:
                result = "Unable to establish a connection to the proxy server. Please check your proxy server configuration.";
                break;
            case 0xC00D2EEF:
                result = "Unable to locate the media server. The operation timed out.";
                break;
            case 0xC00D2EF0:
                result = "Unable to locate the proxy server. The operation timed out.";
                break;
            case 0xC00D2EF1:
                result = "Media closed because Windows was shut down.";
                break;
            case 0xC00D2EF2:
                result = "Unable to read the contents of a playlist file from a media server.";
                break;
            case 0xC00D2EF3:
                result = "Session not found.";
                break;
            case 0xC00D2EF4:
                result = "Content requires a streaming media client.";
                break;
            case 0xC00D2EF5:
                result = "A command applies to a previous playlist entry.";
                break;
            case 0xC00D2EF6:
                result = "The proxy server is denying access. The username and/or password might be incorrect.";
                break;
            case 0xC00D2EF7:
                result = "The proxy could not provide valid authentication credentials to the media server.";
                break;
            case 0xC00D2EF8:
                result = "The network sink failed to write data to the network.";
                break;
            case 0xC00D2EF9:
                result = "Packets are not being received from the server. The packets might be blocked by a filtering device, such as a network firewall.";
                break;
            case 0xC00D2EFA:
                result = "The MMS protocol is not supported. Please use HTTP or RTSP to connect to the Windows Media stream.";
                break;
            case 0xC00D2EFB:
                result = "The Windows Media server is denying access. The username and/or password might be incorrect.";
                break;
            case 0xC00D2EFC:
                result = "The Publishing Point or file on the Windows Media Server is no longer available.";
                break;
            case 0xC00D2EFD:
                result = "There is no existing packetizer plugin for a stream.";
                break;
            case 0xC00D2EFE:
                result = "The response from the media server could not be understood. This might be caused by an incompatible proxy server or media server.";
                break;
            case 0xC00D2F00:
                result = "The Windows Media Server reset the network connection.";
                break;
            case 0xC00D2F02:
                result = "The request could not reach the media server (too many hops).";
                break;
            case 0xC00D2F05:
                result = "The server is sending too much data. The connection has been terminated.";
                break;
            case 0xC00D2F06:
                result = "It was not possible to establish a connection to the media server in a timely manner. The media server might be down for maintenance, or it might be necessary to use a proxy server to access this media server.";
                break;
            case 0xC00D2F07:
                result = "It was not possible to establish a connection to the proxy server in a timely manner. Please check your proxy server configuration.";
                break;
            case 0xC00D2F08:
                result = "Session not found.";
                break;
            case 0xC00D2F0A:
                result = "Unknown packet sink stream.";
                break;
            case 0xC00D2F0B:
                result = "Unable to establish a connection to the server. Ensure Windows Media Services is started and the HTTP Server control protocol is properly enabled.";
                break;
            case 0xC00D2F0C:
                result = "The Server service that received the HTTP push request is not a compatible version of Windows Media Services (WMS). This error might indicate the push request was received by IIS instead of WMS. Ensure WMS is started and has the HTTP Server control protocol properly enabled and try again.";
                break;
            case 0xC00D32C8:
                result = "The playlist has reached its end.";
                break;
            case 0xC00D32C9:
                result = "Use file source.";
                break;
            case 0xC00D32CA:
                result = "The property was not found.";
                break;
            case 0xC00D32CC:
                result = "The property is read only.";
                break;
            case 0xC00D32CD:
                result = "The table key was not found.";
                break;
            case 0xC00D32CF:
                result = "Invalid query operator.";
                break;
            case 0xC00D32D0:
                result = "Invalid query property.";
                break;
            case 0xC00D32D2:
                result = "The property is not supported.";
                break;
            case 0xC00D32D4:
                result = "Schema classification failure.";
                break;
            case 0xC00D32D5:
                result = "The metadata format is not supported.";
                break;
            case 0xC00D32D6:
                result = "Cannot edit the metadata.";
                break;
            case 0xC00D32D7:
                result = "Cannot set the locale id.";
                break;
            case 0xC00D32D8:
                result = "The language is not supported in the format.";
                break;
            case 0xC00D32D9:
                result = "There is no RFC1766 name translation for the supplied locale id.";
                break;
            case 0xC00D32DA:
                result = "The metadata (or metadata item) is not available.";
                break;
            case 0xC00D32DB:
                result = "The cached metadata (or metadata item) is not available.";
                break;
            case 0xC00D32DC:
                result = "The metadata document is invalid.";
                break;
            case 0xC00D32DD:
                result = "The metadata content identifier is not available.";
                break;
            case 0xC00D32DE:
                result = "Cannot retrieve metadata from the offline metadata cache.";
                break;
            case 0xC0261003:
                result = "Checksum of the obtained monitor descriptor is invalid.";
                break;
            case 0xC0261004:
                result = "Monitor descriptor contains an invalid standard timing block.";
                break;
            case 0xC0261005:
                result = "Windows Management Instrumentation (WMI) data block registration failed for one of the MSMonitorClass WMI subclasses.";
                break;
            case 0xC0261006:
                result = "Provided monitor descriptor block is either corrupted or does not contain the monitor's detailed serial number.";
                break;
            case 0xC0261007:
                result = "Provided monitor descriptor block is either corrupted or does not contain the monitor's user-friendly name.";
                break;
            case 0xC0261008:
                result = "There is no monitor descriptor data at the specified (offset, size) region.";
                break;
            case 0xC0261009:
                result = "Monitor descriptor contains an invalid detailed timing block.";
                break;
            case 0xC0262000:
                result = "Exclusive mode ownership is needed to create unmanaged primary allocation.";
                break;
            case 0xC0262001:
                result = "The driver needs more direct memory access (DMA) buffer space to complete the requested operation.";
                break;
            case 0xC0262002:
                result = "Specified display adapter handle is invalid.";
                break;
            case 0xC0262003:
                result = "Specified display adapter and all of its state has been reset.";
                break;
            case 0xC0262004:
                result = "The driver stack does not match the expected driver model.";
                break;
            case 0xC0262005:
                result = "Present happened but ended up into the changed desktop mode.";
                break;
            case 0xC0262006:
                result = "Nothing to present due to desktop occlusion.";
                break;
            case 0xC0262007:
                result = "Not able to present due to denial of desktop access.";
                break;
            case 0xC0262008:
                result = "Not able to present with color conversion.";
                break;
            case 0xC0262100:
                result = "Not enough video memory available to complete the operation.";
                break;
            case 0xC0262101:
                result = "Could not probe and lock the underlying memory of an allocation.";
                break;
            case 0xC0262102:
                result = "The allocation is currently busy.";
                break;
            case 0xC0262103:
                result = "An object being referenced has reach the maximum reference count already and cannot be referenced further.";
                break;
            case 0xC0262104:
                result = "A problem could not be solved due to some currently existing condition. The problem should be tried again later.";
                break;
            case 0xC0262105:
                result = "A problem could not be solved due to some currently existing condition. The problem should be tried again immediately.";
                break;
            case 0xC0262106:
                result = "The allocation is invalid.";
                break;
            case 0xC0262107:
                result = "No more unswizzling apertures are currently available.";
                break;
            case 0xC0262108:
                result = "The current allocation cannot be unswizzled by an aperture.";
                break;
            case 0xC0262109:
                result = "The request failed because a pinned allocation cannot be evicted.";
                break;
            case 0xC0262110:
                result = "The allocation cannot be used from its current segment location for the specified operation.";
                break;
            case 0xC0262111:
                result = "A locked allocation cannot be used in the current command buffer.";
                break;
            case 0xC0262112:
                result = "The allocation being referenced has been closed permanently.";
                break;
            case 0xC0262113:
                result = "An invalid allocation instance is being referenced.";
                break;
            case 0xC0262114:
                result = "An invalid allocation handle is being referenced.";
                break;
            case 0xC0262115:
                result = "The allocation being referenced does not belong to the current device.";
                break;
            case 0xC0262116:
                result = "The specified allocation lost its content.";
                break;
            case 0xC0262200:
                result = "Graphics processing unit (GPU) exception is detected on the given device. The device is not able to be scheduled.";
                break;
            case 0xC0262300:
                result = "Specified video present network (VidPN) topology is invalid.";
                break;
            case 0xC0262301:
                result = "Specified VidPN topology is valid but is not supported by this model of the display adapter.";
                break;
            case 0xC0262302:
                result = "Specified VidPN topology is valid but is not supported by the display adapter at this time, due to current allocation of its resources.";
                break;
            case 0xC0262303:
                result = "Specified VidPN handle is invalid.";
                break;
            case 0xC0262304:
                result = "Specified video present source is invalid.";
                break;
            case 0xC0262305:
                result = "Specified video present target is invalid.";
                break;
            case 0xC0262306:
                result = "Specified VidPN modality is not supported (for example, at least two of the pinned modes are not cofunctional).";
                break;
            case 0xC0262308:
                result = "Specified VidPN source mode set is invalid.";
                break;
            case 0xC0262309:
                result = "Specified VidPN target mode set is invalid.";
                break;
            case 0xC026230A:
                result = "Specified video signal frequency is invalid.";
                break;
            case 0xC026230B:
                result = "Specified video signal active region is invalid.";
                break;
            case 0xC026230C:
                result = "Specified video signal total region is invalid.";
                break;
            case 0xC0262310:
                result = "Specified video present source mode is invalid.";
                break;
            case 0xC0262311:
                result = "Specified video present target mode is invalid.";
                break;
            case 0xC0262312:
                result = "Pinned mode must remain in the set on VidPN's cofunctional modality enumeration.";
                break;
            case 0xC0262313:
                result = "Specified video present path is already in the VidPN topology.";
                break;
            case 0xC0262314:
                result = "Specified mode is already in the mode set.";
                break;
            case 0xC0262315:
                result = "Specified video present source set is invalid.";
                break;
            case 0xC0262316:
                result = "Specified video present target set is invalid.";
                break;
            case 0xC0262317:
                result = "Specified video present source is already in the video present source set.";
                break;
            case 0xC0262318:
                result = "Specified video present target is already in the video present target set.";
                break;
            case 0xC0262319:
                result = "Specified VidPN present path is invalid.";
                break;
            case 0xC026231A:
                result = "Miniport has no recommendation for augmentation of the specified VidPN topology.";
                break;
            case 0xC026231B:
                result = "Specified monitor frequency range set is invalid.";
                break;
            case 0xC026231C:
                result = "Specified monitor frequency range is invalid.";
                break;
            case 0xC026231D:
                result = "Specified frequency range is not in the specified monitor frequency range set.";
                break;
            case 0xC026231F:
                result = "Specified frequency range is already in the specified monitor frequency range set.";
                break;
            case 0xC0262320:
                result = "Specified mode set is stale. Reacquire the new mode set.";
                break;
            case 0xC0262321:
                result = "Specified monitor source mode set is invalid.";
                break;
            case 0xC0262322:
                result = "Specified monitor source mode is invalid.";
                break;
            case 0xC0262323:
                result = "Miniport does not have any recommendation regarding the request to provide a functional VidPN given the current display adapter configuration.";
                break;
            case 0xC0262324:
                result = "ID of the specified mode is already used by another mode in the set.";
                break;
            case 0xC0262325:
                result = "System failed to determine a mode that is supported by both the display adapter and the monitor connected to it.";
                break;
            case 0xC0262326:
                result = "Number of video present targets must be greater than or equal to the number of video present sources.";
                break;
            case 0xC0262327:
                result = "Specified present path is not in the VidPN topology.";
                break;
            case 0xC0262328:
                result = "Display adapter must have at least one video present source.";
                break;
            case 0xC0262329:
                result = "Display adapter must have at least one video present target.";
                break;
            case 0xC026232A:
                result = "Specified monitor descriptor set is invalid.";
                break;
            case 0xC026232B:
                result = "Specified monitor descriptor is invalid.";
                break;
            case 0xC026232C:
                result = "Specified descriptor is not in the specified monitor descriptor set.";
                break;
            case 0xC026232D:
                result = "Specified descriptor is already in the specified monitor descriptor set.";
                break;
            case 0xC026232E:
                result = "ID of the specified monitor descriptor is already used by another descriptor in the set.";
                break;
            case 0xC026232F:
                result = "Specified video present target subset type is invalid.";
                break;
            case 0xC0262330:
                result = "Two or more of the specified resources are not related to each other, as defined by the interface semantics.";
                break;
            case 0xC0262331:
                result = "ID of the specified video present source is already used by another source in the set.";
                break;
            case 0xC0262332:
                result = "ID of the specified video present target is already used by another target in the set.";
                break;
            case 0xC0262333:
                result = "Specified VidPN source cannot be used because there is no available VidPN target to connect it to.";
                break;
            case 0xC0262334:
                result = "Newly arrived monitor could not be associated with a display adapter.";
                break;
            case 0xC0262335:
                result = "Display adapter in question does not have an associated VidPN manager.";
                break;
            case 0xC0262336:
                result = "VidPN manager of the display adapter in question does not have an active VidPN.";
                break;
            case 0xC0262337:
                result = "Specified VidPN topology is stale. Re-acquire the new topology.";
                break;
            case 0xC0262338:
                result = "There is no monitor connected on the specified video present target.";
                break;
            case 0xC0262339:
                result = "Specified source is not part of the specified VidPN topology.";
                break;
            case 0xC026233A:
                result = "Specified primary surface size is invalid.";
                break;
            case 0xC026233B:
                result = "Specified visible region size is invalid.";
                break;
            case 0xC026233C:
                result = "Specified stride is invalid.";
                break;
            case 0xC026233D:
                result = "Specified pixel format is invalid.";
                break;
            case 0xC026233E:
                result = "Specified color basis is invalid.";
                break;
            case 0xC026233F:
                result = "Specified pixel value access mode is invalid.";
                break;
            case 0xC0262340:
                result = "Specified target is not part of the specified VidPN topology.";
                break;
            case 0xC0262341:
                result = "Failed to acquire display mode management interface.";
                break;
            case 0xC0262342:
                result = "Specified VidPN source is already owned by a display mode manager (DMM) client and cannot be used until that client releases it.";
                break;
            case 0xC0262343:
                result = "Specified VidPN is active and cannot be accessed.";
                break;
            case 0xC0262344:
                result = "Specified VidPN present path importance ordinal is invalid.";
                break;
            case 0xC0262345:
                result = "Specified VidPN present path content geometry transformation is invalid.";
                break;
            case 0xC0262346:
                result = "Specified content geometry transformation is not supported on the respective VidPN present path.";
                break;
            case 0xC0262347:
                result = "Specified gamma ramp is invalid.";
                break;
            case 0xC0262348:
                result = "Specified gamma ramp is not supported on the respective VidPN present path.";
                break;
            case 0xC0262349:
                result = "Multisampling is not supported on the respective VidPN present path.";
                break;
            case 0xC026234A:
                result = "Specified mode is not in the specified mode set.";
                break;
            case 0xC026234D:
                result = "Specified VidPN topology recommendation reason is invalid.";
                break;
            case 0xC026234E:
                result = "Specified VidPN present path content type is invalid.";
                break;
            case 0xC026234F:
                result = "Specified VidPN present path copy protection type is invalid.";
                break;
            case 0xC0262350:
                result = "No more than one unassigned mode set can exist at any given time for a given VidPN source or target.";
                break;
            case 0xC0262352:
                result = "The specified scan line ordering type is invalid.";
                break;
            case 0xC0262353:
                result = "Topology changes are not allowed for the specified VidPN.";
                break;
            case 0xC0262354:
                result = "All available importance ordinals are already used in the specified topology.";
                break;
            case 0xC0262355:
                result = "Specified primary surface has a different private format attribute than the current primary surface.";
                break;
            case 0xC0262356:
                result = "Specified mode pruning algorithm is invalid.";
                break;
            case 0xC0262400:
                result = "Specified display adapter child device already has an external device connected to it.";
                break;
            case 0xC0262401:
                result = "The display adapter child device does not support reporting a descriptor.";
                break;
            case 0xC0262430:
                result = "The display adapter is not linked to any other adapters.";
                break;
            case 0xC0262431:
                result = "Lead adapter in a linked configuration was not enumerated yet.";
                break;
            case 0xC0262432:
                result = "Some chain adapters in a linked configuration were not enumerated yet.";
                break;
            case 0xC0262433:
                result = "The chain of linked adapters is not ready to start because of an unknown failure.";
                break;
            case 0xC0262434:
                result = "An attempt was made to start a lead link display adapter when the chain links were not started yet.";
                break;
            case 0xC0262435:
                result = "An attempt was made to turn on a lead link display adapter when the chain links were turned off.";
                break;
            case 0xC0262436:
                result = "The adapter link was found to be in an inconsistent state. Not all adapters are in an expected PNP or power state.";
                break;
            case 0xC0262438:
                result = "The driver trying to start is not the same as the driver for the posted display adapter.";
                break;
            case 0xC0262500:
                result = "The driver does not support Output Protection Manager (OPM).";
                break;
            case 0xC0262501:
                result = "The driver does not support Certified Output Protection Protocol (COPP).";
                break;
            case 0xC0262502:
                result = "The driver does not support a user-accessible bus (UAB).";
                break;
            case 0xC0262503:
                result = "The specified encrypted parameters are invalid.";
                break;
            case 0xC0262504:
                result = "An array passed to a function cannot hold all of the data that the function wants to put in it.";
                break;
            case 0xC0262505:
                result = "The GDI display device passed to this function does not have any active video outputs.";
                break;
            case 0xC0262506:
                result = "The protected video path (PVP) cannot find an actual GDI display device that corresponds to the passed-in GDI display device name.";
                break;
            case 0xC0262507:
                result = "This function failed because the GDI display device passed to it was not attached to the Windows desktop.";
                break;
            case 0xC0262508:
                result = "The PVP does not support mirroring display devices because they do not have video outputs.";
                break;
            case 0xC026250A:
                result = "The function failed because an invalid pointer parameter was passed to it. A pointer parameter is invalid if it is null, it points to an invalid address, it points to a kernel mode address, or it is not correctly aligned.";
                break;
            case 0xC026250B:
                result = "An internal error caused this operation to fail.";
                break;
            case 0xC026250C:
                result = "The function failed because the caller passed in an invalid OPM user mode handle.";
                break;
            case 0xC026250D:
                result = "This function failed because the GDI device passed to it did not have any monitors associated with it.";
                break;
            case 0xC026250E:
                result = "A certificate could not be returned because the certificate buffer passed to the function was too small.";
                break;
            case 0xC026250F:
                result = "A video output could not be created because the frame buffer is in spanning mode.";
                break;
            case 0xC0262510:
                result = "A video output could not be created because the frame buffer is in theater mode.";
                break;
            case 0xC0262511:
                result = "The function call failed because the display adapter's hardware functionality scan failed to validate the graphics hardware.";
                break;
            case 0xC0262512:
                result = "The High-Bandwidth Digital Content Protection (HDCP) System Renewability Message (SRM) passed to this function did not comply with section 5 of the HDCP 1.1 specification.";
                break;
            case 0xC0262513:
                result = "The video output cannot enable the HDCP system because it does not support it.";
                break;
            case 0xC0262514:
                result = "The video output cannot enable analog copy protection because it does not support it.";
                break;
            case 0xC0262515:
                result = "The video output cannot enable the Content Generation Management System Analog (CGMS-A) protection technology because it does not support it.";
                break;
            case 0xC0262516:
                result = "IOPMVideoOutput's GetInformation() method cannot return the version of the SRM being used because the application never successfully passed an SRM to the video output.";
                break;
            case 0xC0262517:
                result = "IOPMVideoOutput's Configure() method cannot enable the specified output protection technology because the output's screen resolution is too high.";
                break;
            case 0xC0262518:
                result = "IOPMVideoOutput's Configure() method cannot enable HDCP because the display adapter's HDCP hardware is already being used by other physical outputs.";
                break;
            case 0xC0262519:
                result = "The operating system asynchronously destroyed this OPM video output because the operating system's state changed. This error typically occurs because the monitor physical device object (PDO) associated with this video output was removed, the monitor PDO associated with this video output was stopped, the video output's session became a nonconsole session or the video output's desktop became an inactive desktop.";
                break;
            case 0xC026251A:
                result = "IOPMVideoOutput's methods cannot be called when a session is changing its type. There are currently three types of sessions: console, disconnected and remote (remote desktop protocol [RDP] or Independent Computing Architecture [ICA]).";
                break;
            case 0xC0262580:
                result = "The monitor connected to the specified video output does not have an I2C bus.";
                break;
            case 0xC0262581:
                result = "No device on the I2C bus has the specified address.";
                break;
            case 0xC0262582:
                result = "An error occurred while transmitting data to the device on the I2C bus.";
                break;
            case 0xC0262583:
                result = "An error occurred while receiving data from the device on the I2C bus.";
                break;
            case 0xC0262584:
                result = "The monitor does not support the specified Virtual Control Panel (VCP) code.";
                break;
            case 0xC0262585:
                result = "The data received from the monitor is invalid.";
                break;
            case 0xC0262586:
                result = "A function call failed because a monitor returned an invalid Timing Status byte when the operating system used the Display Data Channel Command Interface (DDC/CI) Get Timing Report and Timing Message command to get a timing report from a monitor.";
                break;
            case 0xC0262587:
                result = "The monitor returned a DDC/CI capabilities string that did not comply with the ACCESS.bus 3.0, DDC/CI 1.1 or MCCS 2 Revision 1 specification.";
                break;
            case 0xC0262588:
                result = "An internal Monitor Configuration API error occurred.";
                break;
            case 0xC0262589:
                result = "An operation failed because a DDC/CI message had an invalid value in its command field.";
                break;
            case 0xC026258A:
                result = "This error occurred because a DDC/CI message length field contained an invalid value.";
                break;
            case 0xC026258B:
                result = "This error occurred because the value in a DDC/CI message checksum field did not match the message's computed checksum value. This error implies that the data was corrupted while it was being transmitted from a monitor to a computer.";
                break;
            case 0xC02625D6:
                result = "The HMONITOR no longer exists, is not attached to the desktop, or corresponds to a mirroring device.";
                break;
            case 0xC02625D7:
                result = "The Direct3D (D3D) device's GDI display device no longer exists, is not attached to the desktop, or is a mirroring display device.";
                break;
            case 0xC02625D8:
                result = "A continuous VCP code's current value is greater than its maximum value. This error code indicates that a monitor returned an invalid value.";
                break;
            case 0xC02625D9:
                result = "The monitor's VCP Version (0xDF) VCP code returned an invalid version value.";
                break;
            case 0xC02625DA:
                result = "The monitor does not comply with the Monitor Control Command Set (MCCS) specification it claims to support.";
                break;
            case 0xC02625DB:
                result = "The MCCS version in a monitor's mccs_ver capability does not match the MCCS version the monitor reports when the VCP Version (0xDF) VCP code is used.";
                break;
            case 0xC02625DC:
                result = "The Monitor Configuration API only works with monitors that support the MCCS 1.0 specification, the MCCS 2.0 specification, or the MCCS 2.0 Revision 1 specification.";
                break;
            case 0xC02625DE:
                result = "The monitor returned an invalid monitor technology type. CRT, plasma, and LCD (TFT) are examples of monitor technology types. This error implies that the monitor violated the MCCS 2.0 or MCCS 2.0 Revision 1 specification.";
                break;
            case 0xC02625DF:
                result = "The SetMonitorColorTemperature() caller passed a color temperature to it that the current monitor did not support. CRT, plasma, and LCD (TFT) are examples of monitor technology types. This error implies that the monitor violated the MCCS 2.0 or MCCS 2.0 Revision 1 specification.";
                break;
            case 0xC02625E0:
                result = "This function can be used only if a program is running in the local console session. It cannot be used if the program is running on a remote desktop session or on a terminal server session.";
                break;
	}

	/* convert & check win32 error space? */
	if (result == NULL && HRESULT_IS_LIKELY_WERR(err_code)) {
		WERROR wErr = W_ERROR(WIN32_FROM_HRESULT(err_code));
		result = get_friendly_werror_msg(wErr);
	}
	return result;
}

const char *hresult_errstr(HRESULT err_code)
{
	static char msg[22];

	switch (HRES_ERROR_V(err_code)) {
            case 0x30200:
                return "HRES_STG_S_CONVERTED";
                break;
            case 0x30201:
                return "HRES_STG_S_BLOCK";
                break;
            case 0x30202:
                return "HRES_STG_S_RETRYNOW";
                break;
            case 0x30203:
                return "HRES_STG_S_MONITORING";
                break;
            case 0x30204:
                return "HRES_STG_S_MULTIPLEOPENS";
                break;
            case 0x30205:
                return "HRES_STG_S_CONSOLIDATIONFAILED";
                break;
            case 0x30206:
                return "HRES_STG_S_CANNOTCONSOLIDATE";
                break;
            case 0x40000:
                return "HRES_OLE_S_USEREG";
                break;
            case 0x40001:
                return "HRES_OLE_S_STATIC";
                break;
            case 0x40002:
                return "HRES_OLE_S_MAC_CLIPFORMAT";
                break;
            case 0x40100:
                return "HRES_DRAGDROP_S_DROP";
                break;
            case 0x40101:
                return "HRES_DRAGDROP_S_CANCEL";
                break;
            case 0x40102:
                return "HRES_DRAGDROP_S_USEDEFAULTCURSORS";
                break;
            case 0x40130:
                return "HRES_DATA_S_SAMEFORMATETC";
                break;
            case 0x40140:
                return "HRES_VIEW_S_ALREADY_FROZEN";
                break;
            case 0x40170:
                return "HRES_CACHE_S_FORMATETC_NOTSUPPORTED";
                break;
            case 0x40171:
                return "HRES_CACHE_S_SAMECACHE";
                break;
            case 0x40172:
                return "HRES_CACHE_S_SOMECACHES_NOTUPDATED";
                break;
            case 0x40180:
                return "HRES_OLEOBJ_S_INVALIDVERB";
                break;
            case 0x40181:
                return "HRES_OLEOBJ_S_CANNOT_DOVERB_NOW";
                break;
            case 0x40182:
                return "HRES_OLEOBJ_S_INVALIDHWND";
                break;
            case 0x401A0:
                return "HRES_INPLACE_S_TRUNCATED";
                break;
            case 0x401C0:
                return "HRES_CONVERT10_S_NO_PRESENTATION";
                break;
            case 0x401E2:
                return "HRES_MK_S_REDUCED_TO_SELF";
                break;
            case 0x401E4:
                return "HRES_MK_S_ME";
                break;
            case 0x401E5:
                return "HRES_MK_S_HIM";
                break;
            case 0x401E6:
                return "HRES_MK_S_US";
                break;
            case 0x401E7:
                return "HRES_MK_S_MONIKERALREADYREGISTERED";
                break;
            case 0x40200:
                return "HRES_EVENT_S_SOME_SUBSCRIBERS_FAILED";
                break;
            case 0x40202:
                return "HRES_EVENT_S_NOSUBSCRIBERS";
                break;
            case 0x41300:
                return "HRES_SCHED_S_TASK_READY";
                break;
            case 0x41301:
                return "HRES_SCHED_S_TASK_RUNNING";
                break;
            case 0x41302:
                return "HRES_SCHED_S_TASK_DISABLED";
                break;
            case 0x41303:
                return "HRES_SCHED_S_TASK_HAS_NOT_RUN";
                break;
            case 0x41304:
                return "HRES_SCHED_S_TASK_NO_MORE_RUNS";
                break;
            case 0x41305:
                return "HRES_SCHED_S_TASK_NOT_SCHEDULED";
                break;
            case 0x41306:
                return "HRES_SCHED_S_TASK_TERMINATED";
                break;
            case 0x41307:
                return "HRES_SCHED_S_TASK_NO_VALID_TRIGGERS";
                break;
            case 0x41308:
                return "HRES_SCHED_S_EVENT_TRIGGER";
                break;
            case 0x4131B:
                return "HRES_SCHED_S_SOME_TRIGGERS_FAILED";
                break;
            case 0x4131C:
                return "HRES_SCHED_S_BATCH_LOGON_PROBLEM";
                break;
            case 0x4D000:
                return "HRES_XACT_S_ASYNC";
                break;
            case 0x4D002:
                return "HRES_XACT_S_READONLY";
                break;
            case 0x4D003:
                return "HRES_XACT_S_SOMENORETAIN";
                break;
            case 0x4D004:
                return "HRES_XACT_S_OKINFORM";
                break;
            case 0x4D005:
                return "HRES_XACT_S_MADECHANGESCONTENT";
                break;
            case 0x4D006:
                return "HRES_XACT_S_MADECHANGESINFORM";
                break;
            case 0x4D007:
                return "HRES_XACT_S_ALLNORETAIN";
                break;
            case 0x4D008:
                return "HRES_XACT_S_ABORTING";
                break;
            case 0x4D009:
                return "HRES_XACT_S_SINGLEPHASE";
                break;
            case 0x4D00A:
                return "HRES_XACT_S_LOCALLY_OK";
                break;
            case 0x4D010:
                return "HRES_XACT_S_LASTRESOURCEMANAGER";
                break;
            case 0x80012:
                return "HRES_CO_S_NOTALLINTERFACES";
                break;
            case 0x80013:
                return "HRES_CO_S_MACHINENAMENOTFOUND";
                break;
            case 0x90312:
                return "HRES_SEC_I_CONTINUE_NEEDED";
                break;
            case 0x90313:
                return "HRES_SEC_I_COMPLETE_NEEDED";
                break;
            case 0x90314:
                return "HRES_SEC_I_COMPLETE_AND_CONTINUE";
                break;
            case 0x90315:
                return "HRES_SEC_I_LOCAL_LOGON";
                break;
            case 0x90317:
                return "HRES_SEC_I_CONTEXT_EXPIRED";
                break;
            case 0x90320:
                return "HRES_SEC_I_INCOMPLETE_CREDENTIALS";
                break;
            case 0x90321:
                return "HRES_SEC_I_RENEGOTIATE";
                break;
            case 0x90323:
                return "HRES_SEC_I_NO_LSA_CONTEXT";
                break;
            case 0x9035C:
                return "HRES_SEC_I_SIGNATURE_NEEDED";
                break;
            case 0x91012:
                return "HRES_CRYPT_I_NEW_PROTECTION_REQUIRED";
                break;
            case 0xD0000:
                return "HRES_NS_S_CALLPENDING";
                break;
            case 0xD0001:
                return "HRES_NS_S_CALLABORTED";
                break;
            case 0xD0002:
                return "HRES_NS_S_STREAM_TRUNCATED";
                break;
            case 0xD0BC8:
                return "HRES_NS_S_REBUFFERING";
                break;
            case 0xD0BC9:
                return "HRES_NS_S_DEGRADING_QUALITY";
                break;
            case 0xD0BDB:
                return "HRES_NS_S_TRANSCRYPTOR_EOF";
                break;
            case 0xD0FE8:
                return "HRES_NS_S_WMP_UI_VERSIONMISMATCH";
                break;
            case 0xD0FE9:
                return "HRES_NS_S_WMP_EXCEPTION";
                break;
            case 0xD1040:
                return "HRES_NS_S_WMP_LOADED_GIF_IMAGE";
                break;
            case 0xD1041:
                return "HRES_NS_S_WMP_LOADED_PNG_IMAGE";
                break;
            case 0xD1042:
                return "HRES_NS_S_WMP_LOADED_BMP_IMAGE";
                break;
            case 0xD1043:
                return "HRES_NS_S_WMP_LOADED_JPG_IMAGE";
                break;
            case 0xD104F:
                return "HRES_NS_S_WMG_FORCE_DROP_FRAME";
                break;
            case 0xD105F:
                return "HRES_NS_S_WMR_ALREADYRENDERED";
                break;
            case 0xD1060:
                return "HRES_NS_S_WMR_PINTYPEPARTIALMATCH";
                break;
            case 0xD1061:
                return "HRES_NS_S_WMR_PINTYPEFULLMATCH";
                break;
            case 0xD1066:
                return "HRES_NS_S_WMG_ADVISE_DROP_FRAME";
                break;
            case 0xD1067:
                return "HRES_NS_S_WMG_ADVISE_DROP_TO_KEYFRAME";
                break;
            case 0xD10DB:
                return "HRES_NS_S_NEED_TO_BUY_BURN_RIGHTS";
                break;
            case 0xD10FE:
                return "HRES_NS_S_WMPCORE_PLAYLISTCLEARABORT";
                break;
            case 0xD10FF:
                return "HRES_NS_S_WMPCORE_PLAYLISTREMOVEITEMABORT";
                break;
            case 0xD1102:
                return "HRES_NS_S_WMPCORE_PLAYLIST_CREATION_PENDING";
                break;
            case 0xD1103:
                return "HRES_NS_S_WMPCORE_MEDIA_VALIDATION_PENDING";
                break;
            case 0xD1104:
                return "HRES_NS_S_WMPCORE_PLAYLIST_REPEAT_SECONDARY_SEGMENTS_IGNORED";
                break;
            case 0xD1105:
                return "HRES_NS_S_WMPCORE_COMMAND_NOT_AVAILABLE";
                break;
            case 0xD1106:
                return "HRES_NS_S_WMPCORE_PLAYLIST_NAME_AUTO_GENERATED";
                break;
            case 0xD1107:
                return "HRES_NS_S_WMPCORE_PLAYLIST_IMPORT_MISSING_ITEMS";
                break;
            case 0xD1108:
                return "HRES_NS_S_WMPCORE_PLAYLIST_COLLAPSED_TO_SINGLE_MEDIA";
                break;
            case 0xD1109:
                return "HRES_NS_S_WMPCORE_MEDIA_CHILD_PLAYLIST_OPEN_PENDING";
                break;
            case 0xD110A:
                return "HRES_NS_S_WMPCORE_MORE_NODES_AVAIABLE";
                break;
            case 0xD1135:
                return "HRES_NS_S_WMPBR_SUCCESS";
                break;
            case 0xD1136:
                return "HRES_NS_S_WMPBR_PARTIALSUCCESS";
                break;
            case 0xD1144:
                return "HRES_NS_S_WMPEFFECT_TRANSPARENT";
                break;
            case 0xD1145:
                return "HRES_NS_S_WMPEFFECT_OPAQUE";
                break;
            case 0xD114E:
                return "HRES_NS_S_OPERATION_PENDING";
                break;
            case 0xD1359:
                return "HRES_NS_S_TRACK_BUY_REQUIRES_ALBUM_PURCHASE";
                break;
            case 0xD135E:
                return "HRES_NS_S_NAVIGATION_COMPLETE_WITH_ERRORS";
                break;
            case 0xD1361:
                return "HRES_NS_S_TRACK_ALREADY_DOWNLOADED";
                break;
            case 0xD1519:
                return "HRES_NS_S_PUBLISHING_POINT_STARTED_WITH_FAILED_SINKS";
                break;
            case 0xD2726:
                return "HRES_NS_S_DRM_LICENSE_ACQUIRED";
                break;
            case 0xD2727:
                return "HRES_NS_S_DRM_INDIVIDUALIZED";
                break;
            case 0xD2746:
                return "HRES_NS_S_DRM_MONITOR_CANCELLED";
                break;
            case 0xD2747:
                return "HRES_NS_S_DRM_ACQUIRE_CANCELLED";
                break;
            case 0xD276E:
                return "HRES_NS_S_DRM_BURNABLE_TRACK";
                break;
            case 0xD276F:
                return "HRES_NS_S_DRM_BURNABLE_TRACK_WITH_PLAYLIST_RESTRICTION";
                break;
            case 0xD27DE:
                return "HRES_NS_S_DRM_NEEDS_INDIVIDUALIZATION";
                break;
            case 0xD2AF8:
                return "HRES_NS_S_REBOOT_RECOMMENDED";
                break;
            case 0xD2AF9:
                return "HRES_NS_S_REBOOT_REQUIRED";
                break;
            case 0xD2F09:
                return "HRES_NS_S_EOSRECEDING";
                break;
            case 0xD2F0D:
                return "HRES_NS_S_CHANGENOTICE";
                break;
            case 0x1F0001:
                return "HRES_ERROR_FLT_IO_COMPLETE";
                break;
            case 0x262307:
                return "HRES_ERROR_GRAPHICS_MODE_NOT_PINNED";
                break;
            case 0x26231E:
                return "HRES_ERROR_GRAPHICS_NO_PREFERRED_MODE";
                break;
            case 0x26234B:
                return "HRES_ERROR_GRAPHICS_DATASET_IS_EMPTY";
                break;
            case 0x26234C:
                return "HRES_ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET";
                break;
            case 0x262351:
                return "HRES_ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED";
                break;
            case 0x300100:
                return "HRES_PLA_S_PROPERTY_IGNORED";
                break;
            case 0x340001:
                return "HRES_ERROR_NDIS_INDICATION_REQUIRED";
                break;
            case 0xDEAD100:
                return "HRES_TRK_S_OUT_OF_SYNC";
                break;
            case 0xDEAD102:
                return "HRES_TRK_VOLUME_NOT_FOUND";
                break;
            case 0xDEAD103:
                return "HRES_TRK_VOLUME_NOT_OWNED";
                break;
            case 0xDEAD107:
                return "HRES_TRK_S_NOTIFICATION_QUOTA_EXCEEDED";
                break;
            case 0x400D004F:
                return "HRES_NS_I_TIGER_START";
                break;
            case 0x400D0051:
                return "HRES_NS_I_CUB_START";
                break;
            case 0x400D0052:
                return "HRES_NS_I_CUB_RUNNING";
                break;
            case 0x400D0054:
                return "HRES_NS_I_DISK_START";
                break;
            case 0x400D0056:
                return "HRES_NS_I_DISK_REBUILD_STARTED";
                break;
            case 0x400D0057:
                return "HRES_NS_I_DISK_REBUILD_FINISHED";
                break;
            case 0x400D0058:
                return "HRES_NS_I_DISK_REBUILD_ABORTED";
                break;
            case 0x400D0059:
                return "HRES_NS_I_LIMIT_FUNNELS";
                break;
            case 0x400D005A:
                return "HRES_NS_I_START_DISK";
                break;
            case 0x400D005B:
                return "HRES_NS_I_STOP_DISK";
                break;
            case 0x400D005C:
                return "HRES_NS_I_STOP_CUB";
                break;
            case 0x400D005D:
                return "HRES_NS_I_KILL_USERSESSION";
                break;
            case 0x400D005E:
                return "HRES_NS_I_KILL_CONNECTION";
                break;
            case 0x400D005F:
                return "HRES_NS_I_REBUILD_DISK";
                break;
            case 0x400D0069:
                return "HRES_MCMADM_I_NO_EVENTS";
                break;
            case 0x400D006E:
                return "HRES_NS_I_LOGGING_FAILED";
                break;
            case 0x400D0070:
                return "HRES_NS_I_LIMIT_BANDWIDTH";
                break;
            case 0x400D0191:
                return "HRES_NS_I_CUB_UNFAIL_LINK";
                break;
            case 0x400D0193:
                return "HRES_NS_I_RESTRIPE_START";
                break;
            case 0x400D0194:
                return "HRES_NS_I_RESTRIPE_DONE";
                break;
            case 0x400D0196:
                return "HRES_NS_I_RESTRIPE_DISK_OUT";
                break;
            case 0x400D0197:
                return "HRES_NS_I_RESTRIPE_CUB_OUT";
                break;
            case 0x400D0198:
                return "HRES_NS_I_DISK_STOP";
                break;
            case 0x400D14BE:
                return "HRES_NS_I_PLAYLIST_CHANGE_RECEDING";
                break;
            case 0x400D2EFF:
                return "HRES_NS_I_RECONNECTED";
                break;
            case 0x400D2F01:
                return "HRES_NS_I_NOLOG_STOP";
                break;
            case 0x400D2F03:
                return "HRES_NS_I_EXISTING_PACKETIZER";
                break;
            case 0x400D2F04:
                return "HRES_NS_I_MANUAL_PROXY";
                break;
            case 0x40262009:
                return "HRES_ERROR_GRAPHICS_DRIVER_MISMATCH";
                break;
            case 0x4026242F:
                return "HRES_ERROR_GRAPHICS_UNKNOWN_CHILD_STATUS";
                break;
            case 0x40262437:
                return "HRES_ERROR_GRAPHICS_LEADLINK_START_DEFERRED";
                break;
            case 0x40262439:
                return "HRES_ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY";
                break;
            case 0x4026243A:
                return "HRES_ERROR_GRAPHICS_START_DEFERRED";
                break;
            case 0x8000000A:
                return "HRES_E_PENDING";
                break;
            case 0x80004001:
                return "HRES_E_NOTIMPL";
                break;
            case 0x80004002:
                return "HRES_E_NOINTERFACE";
                break;
            case 0x80004003:
                return "HRES_E_POINTER";
                break;
            case 0x80004004:
                return "HRES_E_ABORT";
                break;
            case 0x80004005:
                return "HRES_E_FAIL";
                break;
            case 0x80004006:
                return "HRES_CO_E_INIT_TLS";
                break;
            case 0x80004007:
                return "HRES_CO_E_INIT_SHARED_ALLOCATOR";
                break;
            case 0x80004008:
                return "HRES_CO_E_INIT_MEMORY_ALLOCATOR";
                break;
            case 0x80004009:
                return "HRES_CO_E_INIT_CLASS_CACHE";
                break;
            case 0x8000400A:
                return "HRES_CO_E_INIT_RPC_CHANNEL";
                break;
            case 0x8000400B:
                return "HRES_CO_E_INIT_TLS_SET_CHANNEL_CONTROL";
                break;
            case 0x8000400C:
                return "HRES_CO_E_INIT_TLS_CHANNEL_CONTROL";
                break;
            case 0x8000400D:
                return "HRES_CO_E_INIT_UNACCEPTED_USER_ALLOCATOR";
                break;
            case 0x8000400E:
                return "HRES_CO_E_INIT_SCM_MUTEX_EXISTS";
                break;
            case 0x8000400F:
                return "HRES_CO_E_INIT_SCM_FILE_MAPPING_EXISTS";
                break;
            case 0x80004010:
                return "HRES_CO_E_INIT_SCM_MAP_VIEW_OF_FILE";
                break;
            case 0x80004011:
                return "HRES_CO_E_INIT_SCM_EXEC_FAILURE";
                break;
            case 0x80004012:
                return "HRES_CO_E_INIT_ONLY_SINGLE_THREADED";
                break;
            case 0x80004013:
                return "HRES_CO_E_CANT_REMOTE";
                break;
            case 0x80004014:
                return "HRES_CO_E_BAD_SERVER_NAME";
                break;
            case 0x80004015:
                return "HRES_CO_E_WRONG_SERVER_IDENTITY";
                break;
            case 0x80004016:
                return "HRES_CO_E_OLE1DDE_DISABLED";
                break;
            case 0x80004017:
                return "HRES_CO_E_RUNAS_SYNTAX";
                break;
            case 0x80004018:
                return "HRES_CO_E_CREATEPROCESS_FAILURE";
                break;
            case 0x80004019:
                return "HRES_CO_E_RUNAS_CREATEPROCESS_FAILURE";
                break;
            case 0x8000401A:
                return "HRES_CO_E_RUNAS_LOGON_FAILURE";
                break;
            case 0x8000401B:
                return "HRES_CO_E_LAUNCH_PERMSSION_DENIED";
                break;
            case 0x8000401C:
                return "HRES_CO_E_START_SERVICE_FAILURE";
                break;
            case 0x8000401D:
                return "HRES_CO_E_REMOTE_COMMUNICATION_FAILURE";
                break;
            case 0x8000401E:
                return "HRES_CO_E_SERVER_START_TIMEOUT";
                break;
            case 0x8000401F:
                return "HRES_CO_E_CLSREG_INCONSISTENT";
                break;
            case 0x80004020:
                return "HRES_CO_E_IIDREG_INCONSISTENT";
                break;
            case 0x80004021:
                return "HRES_CO_E_NOT_SUPPORTED";
                break;
            case 0x80004022:
                return "HRES_CO_E_RELOAD_DLL";
                break;
            case 0x80004023:
                return "HRES_CO_E_MSI_ERROR";
                break;
            case 0x80004024:
                return "HRES_CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT";
                break;
            case 0x80004025:
                return "HRES_CO_E_SERVER_PAUSED";
                break;
            case 0x80004026:
                return "HRES_CO_E_SERVER_NOT_PAUSED";
                break;
            case 0x80004027:
                return "HRES_CO_E_CLASS_DISABLED";
                break;
            case 0x80004028:
                return "HRES_CO_E_CLRNOTAVAILABLE";
                break;
            case 0x80004029:
                return "HRES_CO_E_ASYNC_WORK_REJECTED";
                break;
            case 0x8000402A:
                return "HRES_CO_E_SERVER_INIT_TIMEOUT";
                break;
            case 0x8000402B:
                return "HRES_CO_E_NO_SECCTX_IN_ACTIVATE";
                break;
            case 0x80004030:
                return "HRES_CO_E_TRACKER_CONFIG";
                break;
            case 0x80004031:
                return "HRES_CO_E_THREADPOOL_CONFIG";
                break;
            case 0x80004032:
                return "HRES_CO_E_SXS_CONFIG";
                break;
            case 0x80004033:
                return "HRES_CO_E_MALFORMED_SPN";
                break;
            case 0x8000FFFF:
                return "HRES_E_UNEXPECTED";
                break;
            case 0x80010001:
                return "HRES_RPC_E_CALL_REJECTED";
                break;
            case 0x80010002:
                return "HRES_RPC_E_CALL_CANCELED";
                break;
            case 0x80010003:
                return "HRES_RPC_E_CANTPOST_INSENDCALL";
                break;
            case 0x80010004:
                return "HRES_RPC_E_CANTCALLOUT_INASYNCCALL";
                break;
            case 0x80010005:
                return "HRES_RPC_E_CANTCALLOUT_INEXTERNALCALL";
                break;
            case 0x80010006:
                return "HRES_RPC_E_CONNECTION_TERMINATED";
                break;
            case 0x80010007:
                return "HRES_RPC_E_SERVER_DIED";
                break;
            case 0x80010008:
                return "HRES_RPC_E_CLIENT_DIED";
                break;
            case 0x80010009:
                return "HRES_RPC_E_INVALID_DATAPACKET";
                break;
            case 0x8001000A:
                return "HRES_RPC_E_CANTTRANSMIT_CALL";
                break;
            case 0x8001000B:
                return "HRES_RPC_E_CLIENT_CANTMARSHAL_DATA";
                break;
            case 0x8001000C:
                return "HRES_RPC_E_CLIENT_CANTUNMARSHAL_DATA";
                break;
            case 0x8001000D:
                return "HRES_RPC_E_SERVER_CANTMARSHAL_DATA";
                break;
            case 0x8001000E:
                return "HRES_RPC_E_SERVER_CANTUNMARSHAL_DATA";
                break;
            case 0x8001000F:
                return "HRES_RPC_E_INVALID_DATA";
                break;
            case 0x80010010:
                return "HRES_RPC_E_INVALID_PARAMETER";
                break;
            case 0x80010011:
                return "HRES_RPC_E_CANTCALLOUT_AGAIN";
                break;
            case 0x80010012:
                return "HRES_RPC_E_SERVER_DIED_DNE";
                break;
            case 0x80010100:
                return "HRES_RPC_E_SYS_CALL_FAILED";
                break;
            case 0x80010101:
                return "HRES_RPC_E_OUT_OF_RESOURCES";
                break;
            case 0x80010102:
                return "HRES_RPC_E_ATTEMPTED_MULTITHREAD";
                break;
            case 0x80010103:
                return "HRES_RPC_E_NOT_REGISTERED";
                break;
            case 0x80010104:
                return "HRES_RPC_E_FAULT";
                break;
            case 0x80010105:
                return "HRES_RPC_E_SERVERFAULT";
                break;
            case 0x80010106:
                return "HRES_RPC_E_CHANGED_MODE";
                break;
            case 0x80010107:
                return "HRES_RPC_E_INVALIDMETHOD";
                break;
            case 0x80010108:
                return "HRES_RPC_E_DISCONNECTED";
                break;
            case 0x80010109:
                return "HRES_RPC_E_RETRY";
                break;
            case 0x8001010A:
                return "HRES_RPC_E_SERVERCALL_RETRYLATER";
                break;
            case 0x8001010B:
                return "HRES_RPC_E_SERVERCALL_REJECTED";
                break;
            case 0x8001010C:
                return "HRES_RPC_E_INVALID_CALLDATA";
                break;
            case 0x8001010D:
                return "HRES_RPC_E_CANTCALLOUT_ININPUTSYNCCALL";
                break;
            case 0x8001010E:
                return "HRES_RPC_E_WRONG_THREAD";
                break;
            case 0x8001010F:
                return "HRES_RPC_E_THREAD_NOT_INIT";
                break;
            case 0x80010110:
                return "HRES_RPC_E_VERSION_MISMATCH";
                break;
            case 0x80010111:
                return "HRES_RPC_E_INVALID_HEADER";
                break;
            case 0x80010112:
                return "HRES_RPC_E_INVALID_EXTENSION";
                break;
            case 0x80010113:
                return "HRES_RPC_E_INVALID_IPID";
                break;
            case 0x80010114:
                return "HRES_RPC_E_INVALID_OBJECT";
                break;
            case 0x80010115:
                return "HRES_RPC_S_CALLPENDING";
                break;
            case 0x80010116:
                return "HRES_RPC_S_WAITONTIMER";
                break;
            case 0x80010117:
                return "HRES_RPC_E_CALL_COMPLETE";
                break;
            case 0x80010118:
                return "HRES_RPC_E_UNSECURE_CALL";
                break;
            case 0x80010119:
                return "HRES_RPC_E_TOO_LATE";
                break;
            case 0x8001011A:
                return "HRES_RPC_E_NO_GOOD_SECURITY_PACKAGES";
                break;
            case 0x8001011B:
                return "HRES_RPC_E_ACCESS_DENIED";
                break;
            case 0x8001011C:
                return "HRES_RPC_E_REMOTE_DISABLED";
                break;
            case 0x8001011D:
                return "HRES_RPC_E_INVALID_OBJREF";
                break;
            case 0x8001011E:
                return "HRES_RPC_E_NO_CONTEXT";
                break;
            case 0x8001011F:
                return "HRES_RPC_E_TIMEOUT";
                break;
            case 0x80010120:
                return "HRES_RPC_E_NO_SYNC";
                break;
            case 0x80010121:
                return "HRES_RPC_E_FULLSIC_REQUIRED";
                break;
            case 0x80010122:
                return "HRES_RPC_E_INVALID_STD_NAME";
                break;
            case 0x80010123:
                return "HRES_CO_E_FAILEDTOIMPERSONATE";
                break;
            case 0x80010124:
                return "HRES_CO_E_FAILEDTOGETSECCTX";
                break;
            case 0x80010125:
                return "HRES_CO_E_FAILEDTOOPENTHREADTOKEN";
                break;
            case 0x80010126:
                return "HRES_CO_E_FAILEDTOGETTOKENINFO";
                break;
            case 0x80010127:
                return "HRES_CO_E_TRUSTEEDOESNTMATCHCLIENT";
                break;
            case 0x80010128:
                return "HRES_CO_E_FAILEDTOQUERYCLIENTBLANKET";
                break;
            case 0x80010129:
                return "HRES_CO_E_FAILEDTOSETDACL";
                break;
            case 0x8001012A:
                return "HRES_CO_E_ACCESSCHECKFAILED";
                break;
            case 0x8001012B:
                return "HRES_CO_E_NETACCESSAPIFAILED";
                break;
            case 0x8001012C:
                return "HRES_CO_E_WRONGTRUSTEENAMESYNTAX";
                break;
            case 0x8001012D:
                return "HRES_CO_E_INVALIDSID";
                break;
            case 0x8001012E:
                return "HRES_CO_E_CONVERSIONFAILED";
                break;
            case 0x8001012F:
                return "HRES_CO_E_NOMATCHINGSIDFOUND";
                break;
            case 0x80010130:
                return "HRES_CO_E_LOOKUPACCSIDFAILED";
                break;
            case 0x80010131:
                return "HRES_CO_E_NOMATCHINGNAMEFOUND";
                break;
            case 0x80010132:
                return "HRES_CO_E_LOOKUPACCNAMEFAILED";
                break;
            case 0x80010133:
                return "HRES_CO_E_SETSERLHNDLFAILED";
                break;
            case 0x80010134:
                return "HRES_CO_E_FAILEDTOGETWINDIR";
                break;
            case 0x80010135:
                return "HRES_CO_E_PATHTOOLONG";
                break;
            case 0x80010136:
                return "HRES_CO_E_FAILEDTOGENUUID";
                break;
            case 0x80010137:
                return "HRES_CO_E_FAILEDTOCREATEFILE";
                break;
            case 0x80010138:
                return "HRES_CO_E_FAILEDTOCLOSEHANDLE";
                break;
            case 0x80010139:
                return "HRES_CO_E_EXCEEDSYSACLLIMIT";
                break;
            case 0x8001013A:
                return "HRES_CO_E_ACESINWRONGORDER";
                break;
            case 0x8001013B:
                return "HRES_CO_E_INCOMPATIBLESTREAMVERSION";
                break;
            case 0x8001013C:
                return "HRES_CO_E_FAILEDTOOPENPROCESSTOKEN";
                break;
            case 0x8001013D:
                return "HRES_CO_E_DECODEFAILED";
                break;
            case 0x8001013F:
                return "HRES_CO_E_ACNOTINITIALIZED";
                break;
            case 0x80010140:
                return "HRES_CO_E_CANCEL_DISABLED";
                break;
            case 0x8001FFFF:
                return "HRES_RPC_E_UNEXPECTED";
                break;
            case 0x80020001:
                return "HRES_DISP_E_UNKNOWNINTERFACE";
                break;
            case 0x80020003:
                return "HRES_DISP_E_MEMBERNOTFOUND";
                break;
            case 0x80020004:
                return "HRES_DISP_E_PARAMNOTFOUND";
                break;
            case 0x80020005:
                return "HRES_DISP_E_TYPEMISMATCH";
                break;
            case 0x80020006:
                return "HRES_DISP_E_UNKNOWNNAME";
                break;
            case 0x80020007:
                return "HRES_DISP_E_NONAMEDARGS";
                break;
            case 0x80020008:
                return "HRES_DISP_E_BADVARTYPE";
                break;
            case 0x80020009:
                return "HRES_DISP_E_EXCEPTION";
                break;
            case 0x8002000A:
                return "HRES_DISP_E_OVERFLOW";
                break;
            case 0x8002000B:
                return "HRES_DISP_E_BADINDEX";
                break;
            case 0x8002000C:
                return "HRES_DISP_E_UNKNOWNLCID";
                break;
            case 0x8002000D:
                return "HRES_DISP_E_ARRAYISLOCKED";
                break;
            case 0x8002000E:
                return "HRES_DISP_E_BADPARAMCOUNT";
                break;
            case 0x8002000F:
                return "HRES_DISP_E_PARAMNOTOPTIONAL";
                break;
            case 0x80020010:
                return "HRES_DISP_E_BADCALLEE";
                break;
            case 0x80020011:
                return "HRES_DISP_E_NOTACOLLECTION";
                break;
            case 0x80020012:
                return "HRES_DISP_E_DIVBYZERO";
                break;
            case 0x80020013:
                return "HRES_DISP_E_BUFFERTOOSMALL";
                break;
            case 0x80028016:
                return "HRES_TYPE_E_BUFFERTOOSMALL";
                break;
            case 0x80028017:
                return "HRES_TYPE_E_FIELDNOTFOUND";
                break;
            case 0x80028018:
                return "HRES_TYPE_E_INVDATAREAD";
                break;
            case 0x80028019:
                return "HRES_TYPE_E_UNSUPFORMAT";
                break;
            case 0x8002801C:
                return "HRES_TYPE_E_REGISTRYACCESS";
                break;
            case 0x8002801D:
                return "HRES_TYPE_E_LIBNOTREGISTERED";
                break;
            case 0x80028027:
                return "HRES_TYPE_E_UNDEFINEDTYPE";
                break;
            case 0x80028028:
                return "HRES_TYPE_E_QUALIFIEDNAMEDISALLOWED";
                break;
            case 0x80028029:
                return "HRES_TYPE_E_INVALIDSTATE";
                break;
            case 0x8002802A:
                return "HRES_TYPE_E_WRONGTYPEKIND";
                break;
            case 0x8002802B:
                return "HRES_TYPE_E_ELEMENTNOTFOUND";
                break;
            case 0x8002802C:
                return "HRES_TYPE_E_AMBIGUOUSNAME";
                break;
            case 0x8002802D:
                return "HRES_TYPE_E_NAMECONFLICT";
                break;
            case 0x8002802E:
                return "HRES_TYPE_E_UNKNOWNLCID";
                break;
            case 0x8002802F:
                return "HRES_TYPE_E_DLLFUNCTIONNOTFOUND";
                break;
            case 0x800288BD:
                return "HRES_TYPE_E_BADMODULEKIND";
                break;
            case 0x800288C5:
                return "HRES_TYPE_E_SIZETOOBIG";
                break;
            case 0x800288C6:
                return "HRES_TYPE_E_DUPLICATEID";
                break;
            case 0x800288CF:
                return "HRES_TYPE_E_INVALIDID";
                break;
            case 0x80028CA0:
                return "HRES_TYPE_E_TYPEMISMATCH";
                break;
            case 0x80028CA1:
                return "HRES_TYPE_E_OUTOFBOUNDS";
                break;
            case 0x80028CA2:
                return "HRES_TYPE_E_IOERROR";
                break;
            case 0x80028CA3:
                return "HRES_TYPE_E_CANTCREATETMPFILE";
                break;
            case 0x80029C4A:
                return "HRES_TYPE_E_CANTLOADLIBRARY";
                break;
            case 0x80029C83:
                return "HRES_TYPE_E_INCONSISTENTPROPFUNCS";
                break;
            case 0x80029C84:
                return "HRES_TYPE_E_CIRCULARTYPE";
                break;
            case 0x80030001:
                return "HRES_STG_E_INVALIDFUNCTION";
                break;
            case 0x80030002:
                return "HRES_STG_E_FILENOTFOUND";
                break;
            case 0x80030003:
                return "HRES_STG_E_PATHNOTFOUND";
                break;
            case 0x80030004:
                return "HRES_STG_E_TOOMANYOPENFILES";
                break;
            case 0x80030005:
                return "HRES_STG_E_ACCESSDENIED";
                break;
            case 0x80030006:
                return "HRES_STG_E_INVALIDHANDLE";
                break;
            case 0x80030008:
                return "HRES_STG_E_INSUFFICIENTMEMORY";
                break;
            case 0x80030009:
                return "HRES_STG_E_INVALIDPOINTER";
                break;
            case 0x80030012:
                return "HRES_STG_E_NOMOREFILES";
                break;
            case 0x80030013:
                return "HRES_STG_E_DISKISWRITEPROTECTED";
                break;
            case 0x80030019:
                return "HRES_STG_E_SEEKERROR";
                break;
            case 0x8003001D:
                return "HRES_STG_E_WRITEFAULT";
                break;
            case 0x8003001E:
                return "HRES_STG_E_READFAULT";
                break;
            case 0x80030020:
                return "HRES_STG_E_SHAREVIOLATION";
                break;
            case 0x80030021:
                return "HRES_STG_E_LOCKVIOLATION";
                break;
            case 0x80030050:
                return "HRES_STG_E_FILEALREADYEXISTS";
                break;
            case 0x80030057:
                return "HRES_STG_E_INVALIDPARAMETER";
                break;
            case 0x80030070:
                return "HRES_STG_E_MEDIUMFULL";
                break;
            case 0x800300F0:
                return "HRES_STG_E_PROPSETMISMATCHED";
                break;
            case 0x800300FA:
                return "HRES_STG_E_ABNORMALAPIEXIT";
                break;
            case 0x800300FB:
                return "HRES_STG_E_INVALIDHEADER";
                break;
            case 0x800300FC:
                return "HRES_STG_E_INVALIDNAME";
                break;
            case 0x800300FD:
                return "HRES_STG_E_UNKNOWN";
                break;
            case 0x800300FE:
                return "HRES_STG_E_UNIMPLEMENTEDFUNCTION";
                break;
            case 0x800300FF:
                return "HRES_STG_E_INVALIDFLAG";
                break;
            case 0x80030100:
                return "HRES_STG_E_INUSE";
                break;
            case 0x80030101:
                return "HRES_STG_E_NOTCURRENT";
                break;
            case 0x80030102:
                return "HRES_STG_E_REVERTED";
                break;
            case 0x80030103:
                return "HRES_STG_E_CANTSAVE";
                break;
            case 0x80030104:
                return "HRES_STG_E_OLDFORMAT";
                break;
            case 0x80030105:
                return "HRES_STG_E_OLDDLL";
                break;
            case 0x80030106:
                return "HRES_STG_E_SHAREREQUIRED";
                break;
            case 0x80030107:
                return "HRES_STG_E_NOTFILEBASEDSTORAGE";
                break;
            case 0x80030108:
                return "HRES_STG_E_EXTANTMARSHALLINGS";
                break;
            case 0x80030109:
                return "HRES_STG_E_DOCFILECORRUPT";
                break;
            case 0x80030110:
                return "HRES_STG_E_BADBASEADDRESS";
                break;
            case 0x80030111:
                return "HRES_STG_E_DOCFILETOOLARGE";
                break;
            case 0x80030112:
                return "HRES_STG_E_NOTSIMPLEFORMAT";
                break;
            case 0x80030201:
                return "HRES_STG_E_INCOMPLETE";
                break;
            case 0x80030202:
                return "HRES_STG_E_TERMINATED";
                break;
            case 0x80030305:
                return "HRES_STG_E_STATUS_COPY_PROTECTION_FAILURE";
                break;
            case 0x80030306:
                return "HRES_STG_E_CSS_AUTHENTICATION_FAILURE";
                break;
            case 0x80030307:
                return "HRES_STG_E_CSS_KEY_NOT_PRESENT";
                break;
            case 0x80030308:
                return "HRES_STG_E_CSS_KEY_NOT_ESTABLISHED";
                break;
            case 0x80030309:
                return "HRES_STG_E_CSS_SCRAMBLED_SECTOR";
                break;
            case 0x8003030A:
                return "HRES_STG_E_CSS_REGION_MISMATCH";
                break;
            case 0x8003030B:
                return "HRES_STG_E_RESETS_EXHAUSTED";
                break;
            case 0x80040000:
                return "HRES_OLE_E_OLEVERB";
                break;
            case 0x80040001:
                return "HRES_OLE_E_ADVF";
                break;
            case 0x80040002:
                return "HRES_OLE_E_ENUM_NOMORE";
                break;
            case 0x80040003:
                return "HRES_OLE_E_ADVISENOTSUPPORTED";
                break;
            case 0x80040004:
                return "HRES_OLE_E_NOCONNECTION";
                break;
            case 0x80040005:
                return "HRES_OLE_E_NOTRUNNING";
                break;
            case 0x80040006:
                return "HRES_OLE_E_NOCACHE";
                break;
            case 0x80040007:
                return "HRES_OLE_E_BLANK";
                break;
            case 0x80040008:
                return "HRES_OLE_E_CLASSDIFF";
                break;
            case 0x80040009:
                return "HRES_OLE_E_CANT_GETMONIKER";
                break;
            case 0x8004000A:
                return "HRES_OLE_E_CANT_BINDTOSOURCE";
                break;
            case 0x8004000B:
                return "HRES_OLE_E_STATIC";
                break;
            case 0x8004000C:
                return "HRES_OLE_E_PROMPTSAVECANCELLED";
                break;
            case 0x8004000D:
                return "HRES_OLE_E_INVALIDRECT";
                break;
            case 0x8004000E:
                return "HRES_OLE_E_WRONGCOMPOBJ";
                break;
            case 0x8004000F:
                return "HRES_OLE_E_INVALIDHWND";
                break;
            case 0x80040010:
                return "HRES_OLE_E_NOT_INPLACEACTIVE";
                break;
            case 0x80040011:
                return "HRES_OLE_E_CANTCONVERT";
                break;
            case 0x80040012:
                return "HRES_OLE_E_NOSTORAGE";
                break;
            case 0x80040064:
                return "HRES_DV_E_FORMATETC";
                break;
            case 0x80040065:
                return "HRES_DV_E_DVTARGETDEVICE";
                break;
            case 0x80040066:
                return "HRES_DV_E_STGMEDIUM";
                break;
            case 0x80040067:
                return "HRES_DV_E_STATDATA";
                break;
            case 0x80040068:
                return "HRES_DV_E_LINDEX";
                break;
            case 0x80040069:
                return "HRES_DV_E_TYMED";
                break;
            case 0x8004006A:
                return "HRES_DV_E_CLIPFORMAT";
                break;
            case 0x8004006B:
                return "HRES_DV_E_DVASPECT";
                break;
            case 0x8004006C:
                return "HRES_DV_E_DVTARGETDEVICE_SIZE";
                break;
            case 0x8004006D:
                return "HRES_DV_E_NOIVIEWOBJECT";
                break;
            case 0x80040100:
                return "HRES_DRAGDROP_E_NOTREGISTERED";
                break;
            case 0x80040101:
                return "HRES_DRAGDROP_E_ALREADYREGISTERED";
                break;
            case 0x80040102:
                return "HRES_DRAGDROP_E_INVALIDHWND";
                break;
            case 0x80040110:
                return "HRES_CLASS_E_NOAGGREGATION";
                break;
            case 0x80040111:
                return "HRES_CLASS_E_CLASSNOTAVAILABLE";
                break;
            case 0x80040112:
                return "HRES_CLASS_E_NOTLICENSED";
                break;
            case 0x80040140:
                return "HRES_VIEW_E_DRAW";
                break;
            case 0x80040150:
                return "HRES_REGDB_E_READREGDB";
                break;
            case 0x80040151:
                return "HRES_REGDB_E_WRITEREGDB";
                break;
            case 0x80040152:
                return "HRES_REGDB_E_KEYMISSING";
                break;
            case 0x80040153:
                return "HRES_REGDB_E_INVALIDVALUE";
                break;
            case 0x80040154:
                return "HRES_REGDB_E_CLASSNOTREG";
                break;
            case 0x80040155:
                return "HRES_REGDB_E_IIDNOTREG";
                break;
            case 0x80040156:
                return "HRES_REGDB_E_BADTHREADINGMODEL";
                break;
            case 0x80040160:
                return "HRES_CAT_E_CATIDNOEXIST";
                break;
            case 0x80040161:
                return "HRES_CAT_E_NODESCRIPTION";
                break;
            case 0x80040164:
                return "HRES_CS_E_PACKAGE_NOTFOUND";
                break;
            case 0x80040165:
                return "HRES_CS_E_NOT_DELETABLE";
                break;
            case 0x80040166:
                return "HRES_CS_E_CLASS_NOTFOUND";
                break;
            case 0x80040167:
                return "HRES_CS_E_INVALID_VERSION";
                break;
            case 0x80040168:
                return "HRES_CS_E_NO_CLASSSTORE";
                break;
            case 0x80040169:
                return "HRES_CS_E_OBJECT_NOTFOUND";
                break;
            case 0x8004016A:
                return "HRES_CS_E_OBJECT_ALREADY_EXISTS";
                break;
            case 0x8004016B:
                return "HRES_CS_E_INVALID_PATH";
                break;
            case 0x8004016C:
                return "HRES_CS_E_NETWORK_ERROR";
                break;
            case 0x8004016D:
                return "HRES_CS_E_ADMIN_LIMIT_EXCEEDED";
                break;
            case 0x8004016E:
                return "HRES_CS_E_SCHEMA_MISMATCH";
                break;
            case 0x8004016F:
                return "HRES_CS_E_INTERNAL_ERROR";
                break;
            case 0x80040170:
                return "HRES_CACHE_E_NOCACHE_UPDATED";
                break;
            case 0x80040180:
                return "HRES_OLEOBJ_E_NOVERBS";
                break;
            case 0x80040181:
                return "HRES_OLEOBJ_E_INVALIDVERB";
                break;
            case 0x800401A0:
                return "HRES_INPLACE_E_NOTUNDOABLE";
                break;
            case 0x800401A1:
                return "HRES_INPLACE_E_NOTOOLSPACE";
                break;
            case 0x800401C0:
                return "HRES_CONVERT10_E_OLESTREAM_GET";
                break;
            case 0x800401C1:
                return "HRES_CONVERT10_E_OLESTREAM_PUT";
                break;
            case 0x800401C2:
                return "HRES_CONVERT10_E_OLESTREAM_FMT";
                break;
            case 0x800401C3:
                return "HRES_CONVERT10_E_OLESTREAM_BITMAP_TO_DIB";
                break;
            case 0x800401C4:
                return "HRES_CONVERT10_E_STG_FMT";
                break;
            case 0x800401C5:
                return "HRES_CONVERT10_E_STG_NO_STD_STREAM";
                break;
            case 0x800401C6:
                return "HRES_CONVERT10_E_STG_DIB_TO_BITMAP";
                break;
            case 0x800401D0:
                return "HRES_CLIPBRD_E_CANT_OPEN";
                break;
            case 0x800401D1:
                return "HRES_CLIPBRD_E_CANT_EMPTY";
                break;
            case 0x800401D2:
                return "HRES_CLIPBRD_E_CANT_SET";
                break;
            case 0x800401D3:
                return "HRES_CLIPBRD_E_BAD_DATA";
                break;
            case 0x800401D4:
                return "HRES_CLIPBRD_E_CANT_CLOSE";
                break;
            case 0x800401E0:
                return "HRES_MK_E_CONNECTMANUALLY";
                break;
            case 0x800401E1:
                return "HRES_MK_E_EXCEEDEDDEADLINE";
                break;
            case 0x800401E2:
                return "HRES_MK_E_NEEDGENERIC";
                break;
            case 0x800401E3:
                return "HRES_MK_E_UNAVAILABLE";
                break;
            case 0x800401E4:
                return "HRES_MK_E_SYNTAX";
                break;
            case 0x800401E5:
                return "HRES_MK_E_NOOBJECT";
                break;
            case 0x800401E6:
                return "HRES_MK_E_INVALIDEXTENSION";
                break;
            case 0x800401E7:
                return "HRES_MK_E_INTERMEDIATEINTERFACENOTSUPPORTED";
                break;
            case 0x800401E8:
                return "HRES_MK_E_NOTBINDABLE";
                break;
            case 0x800401E9:
                return "HRES_MK_E_NOTBOUND";
                break;
            case 0x800401EA:
                return "HRES_MK_E_CANTOPENFILE";
                break;
            case 0x800401EB:
                return "HRES_MK_E_MUSTBOTHERUSER";
                break;
            case 0x800401EC:
                return "HRES_MK_E_NOINVERSE";
                break;
            case 0x800401ED:
                return "HRES_MK_E_NOSTORAGE";
                break;
            case 0x800401EE:
                return "HRES_MK_E_NOPREFIX";
                break;
            case 0x800401EF:
                return "HRES_MK_E_ENUMERATION_FAILED";
                break;
            case 0x800401F0:
                return "HRES_CO_E_NOTINITIALIZED";
                break;
            case 0x800401F1:
                return "HRES_CO_E_ALREADYINITIALIZED";
                break;
            case 0x800401F2:
                return "HRES_CO_E_CANTDETERMINECLASS";
                break;
            case 0x800401F3:
                return "HRES_CO_E_CLASSSTRING";
                break;
            case 0x800401F4:
                return "HRES_CO_E_IIDSTRING";
                break;
            case 0x800401F5:
                return "HRES_CO_E_APPNOTFOUND";
                break;
            case 0x800401F6:
                return "HRES_CO_E_APPSINGLEUSE";
                break;
            case 0x800401F7:
                return "HRES_CO_E_ERRORINAPP";
                break;
            case 0x800401F8:
                return "HRES_CO_E_DLLNOTFOUND";
                break;
            case 0x800401F9:
                return "HRES_CO_E_ERRORINDLL";
                break;
            case 0x800401FA:
                return "HRES_CO_E_WRONGOSFORAPP";
                break;
            case 0x800401FB:
                return "HRES_CO_E_OBJNOTREG";
                break;
            case 0x800401FC:
                return "HRES_CO_E_OBJISREG";
                break;
            case 0x800401FD:
                return "HRES_CO_E_OBJNOTCONNECTED";
                break;
            case 0x800401FE:
                return "HRES_CO_E_APPDIDNTREG";
                break;
            case 0x800401FF:
                return "HRES_CO_E_RELEASED";
                break;
            case 0x80040201:
                return "HRES_EVENT_E_ALL_SUBSCRIBERS_FAILED";
                break;
            case 0x80040203:
                return "HRES_EVENT_E_QUERYSYNTAX";
                break;
            case 0x80040204:
                return "HRES_EVENT_E_QUERYFIELD";
                break;
            case 0x80040205:
                return "HRES_EVENT_E_INTERNALEXCEPTION";
                break;
            case 0x80040206:
                return "HRES_EVENT_E_INTERNALERROR";
                break;
            case 0x80040207:
                return "HRES_EVENT_E_INVALID_PER_USER_SID";
                break;
            case 0x80040208:
                return "HRES_EVENT_E_USER_EXCEPTION";
                break;
            case 0x80040209:
                return "HRES_EVENT_E_TOO_MANY_METHODS";
                break;
            case 0x8004020A:
                return "HRES_EVENT_E_MISSING_EVENTCLASS";
                break;
            case 0x8004020B:
                return "HRES_EVENT_E_NOT_ALL_REMOVED";
                break;
            case 0x8004020C:
                return "HRES_EVENT_E_COMPLUS_NOT_INSTALLED";
                break;
            case 0x8004020D:
                return "HRES_EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT";
                break;
            case 0x8004020E:
                return "HRES_EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT";
                break;
            case 0x8004020F:
                return "HRES_EVENT_E_INVALID_EVENT_CLASS_PARTITION";
                break;
            case 0x80040210:
                return "HRES_EVENT_E_PER_USER_SID_NOT_LOGGED_ON";
                break;
            case 0x80041309:
                return "HRES_SCHED_E_TRIGGER_NOT_FOUND";
                break;
            case 0x8004130A:
                return "HRES_SCHED_E_TASK_NOT_READY";
                break;
            case 0x8004130B:
                return "HRES_SCHED_E_TASK_NOT_RUNNING";
                break;
            case 0x8004130C:
                return "HRES_SCHED_E_SERVICE_NOT_INSTALLED";
                break;
            case 0x8004130D:
                return "HRES_SCHED_E_CANNOT_OPEN_TASK";
                break;
            case 0x8004130E:
                return "HRES_SCHED_E_INVALID_TASK";
                break;
            case 0x8004130F:
                return "HRES_SCHED_E_ACCOUNT_INFORMATION_NOT_SET";
                break;
            case 0x80041310:
                return "HRES_SCHED_E_ACCOUNT_NAME_NOT_FOUND";
                break;
            case 0x80041311:
                return "HRES_SCHED_E_ACCOUNT_DBASE_CORRUPT";
                break;
            case 0x80041312:
                return "HRES_SCHED_E_NO_SECURITY_SERVICES";
                break;
            case 0x80041313:
                return "HRES_SCHED_E_UNKNOWN_OBJECT_VERSION";
                break;
            case 0x80041314:
                return "HRES_SCHED_E_UNSUPPORTED_ACCOUNT_OPTION";
                break;
            case 0x80041315:
                return "HRES_SCHED_E_SERVICE_NOT_RUNNING";
                break;
            case 0x80041316:
                return "HRES_SCHED_E_UNEXPECTEDNODE";
                break;
            case 0x80041317:
                return "HRES_SCHED_E_NAMESPACE";
                break;
            case 0x80041318:
                return "HRES_SCHED_E_INVALIDVALUE";
                break;
            case 0x80041319:
                return "HRES_SCHED_E_MISSINGNODE";
                break;
            case 0x8004131A:
                return "HRES_SCHED_E_MALFORMEDXML";
                break;
            case 0x8004131D:
                return "HRES_SCHED_E_TOO_MANY_NODES";
                break;
            case 0x8004131E:
                return "HRES_SCHED_E_PAST_END_BOUNDARY";
                break;
            case 0x8004131F:
                return "HRES_SCHED_E_ALREADY_RUNNING";
                break;
            case 0x80041320:
                return "HRES_SCHED_E_USER_NOT_LOGGED_ON";
                break;
            case 0x80041321:
                return "HRES_SCHED_E_INVALID_TASK_HASH";
                break;
            case 0x80041322:
                return "HRES_SCHED_E_SERVICE_NOT_AVAILABLE";
                break;
            case 0x80041323:
                return "HRES_SCHED_E_SERVICE_TOO_BUSY";
                break;
            case 0x80041324:
                return "HRES_SCHED_E_TASK_ATTEMPTED";
                break;
            case 0x8004D000:
                return "HRES_XACT_E_ALREADYOTHERSINGLEPHASE";
                break;
            case 0x8004D001:
                return "HRES_XACT_E_CANTRETAIN";
                break;
            case 0x8004D002:
                return "HRES_XACT_E_COMMITFAILED";
                break;
            case 0x8004D003:
                return "HRES_XACT_E_COMMITPREVENTED";
                break;
            case 0x8004D004:
                return "HRES_XACT_E_HEURISTICABORT";
                break;
            case 0x8004D005:
                return "HRES_XACT_E_HEURISTICCOMMIT";
                break;
            case 0x8004D006:
                return "HRES_XACT_E_HEURISTICDAMAGE";
                break;
            case 0x8004D007:
                return "HRES_XACT_E_HEURISTICDANGER";
                break;
            case 0x8004D008:
                return "HRES_XACT_E_ISOLATIONLEVEL";
                break;
            case 0x8004D009:
                return "HRES_XACT_E_NOASYNC";
                break;
            case 0x8004D00A:
                return "HRES_XACT_E_NOENLIST";
                break;
            case 0x8004D00B:
                return "HRES_XACT_E_NOISORETAIN";
                break;
            case 0x8004D00C:
                return "HRES_XACT_E_NORESOURCE";
                break;
            case 0x8004D00D:
                return "HRES_XACT_E_NOTCURRENT";
                break;
            case 0x8004D00E:
                return "HRES_XACT_E_NOTRANSACTION";
                break;
            case 0x8004D00F:
                return "HRES_XACT_E_NOTSUPPORTED";
                break;
            case 0x8004D010:
                return "HRES_XACT_E_UNKNOWNRMGRID";
                break;
            case 0x8004D011:
                return "HRES_XACT_E_WRONGSTATE";
                break;
            case 0x8004D012:
                return "HRES_XACT_E_WRONGUOW";
                break;
            case 0x8004D013:
                return "HRES_XACT_E_XTIONEXISTS";
                break;
            case 0x8004D014:
                return "HRES_XACT_E_NOIMPORTOBJECT";
                break;
            case 0x8004D015:
                return "HRES_XACT_E_INVALIDCOOKIE";
                break;
            case 0x8004D016:
                return "HRES_XACT_E_INDOUBT";
                break;
            case 0x8004D017:
                return "HRES_XACT_E_NOTIMEOUT";
                break;
            case 0x8004D018:
                return "HRES_XACT_E_ALREADYINPROGRESS";
                break;
            case 0x8004D019:
                return "HRES_XACT_E_ABORTED";
                break;
            case 0x8004D01A:
                return "HRES_XACT_E_LOGFULL";
                break;
            case 0x8004D01B:
                return "HRES_XACT_E_TMNOTAVAILABLE";
                break;
            case 0x8004D01C:
                return "HRES_XACT_E_CONNECTION_DOWN";
                break;
            case 0x8004D01D:
                return "HRES_XACT_E_CONNECTION_DENIED";
                break;
            case 0x8004D01E:
                return "HRES_XACT_E_REENLISTTIMEOUT";
                break;
            case 0x8004D01F:
                return "HRES_XACT_E_TIP_CONNECT_FAILED";
                break;
            case 0x8004D020:
                return "HRES_XACT_E_TIP_PROTOCOL_ERROR";
                break;
            case 0x8004D021:
                return "HRES_XACT_E_TIP_PULL_FAILED";
                break;
            case 0x8004D022:
                return "HRES_XACT_E_DEST_TMNOTAVAILABLE";
                break;
            case 0x8004D023:
                return "HRES_XACT_E_TIP_DISABLED";
                break;
            case 0x8004D024:
                return "HRES_XACT_E_NETWORK_TX_DISABLED";
                break;
            case 0x8004D025:
                return "HRES_XACT_E_PARTNER_NETWORK_TX_DISABLED";
                break;
            case 0x8004D026:
                return "HRES_XACT_E_XA_TX_DISABLED";
                break;
            case 0x8004D027:
                return "HRES_XACT_E_UNABLE_TO_READ_DTC_CONFIG";
                break;
            case 0x8004D028:
                return "HRES_XACT_E_UNABLE_TO_LOAD_DTC_PROXY";
                break;
            case 0x8004D029:
                return "HRES_XACT_E_ABORTING";
                break;
            case 0x8004D080:
                return "HRES_XACT_E_CLERKNOTFOUND";
                break;
            case 0x8004D081:
                return "HRES_XACT_E_CLERKEXISTS";
                break;
            case 0x8004D082:
                return "HRES_XACT_E_RECOVERYINPROGRESS";
                break;
            case 0x8004D083:
                return "HRES_XACT_E_TRANSACTIONCLOSED";
                break;
            case 0x8004D084:
                return "HRES_XACT_E_INVALIDLSN";
                break;
            case 0x8004D085:
                return "HRES_XACT_E_REPLAYREQUEST";
                break;
            case 0x8004D100:
                return "HRES_XACT_E_CONNECTION_REQUEST_DENIED";
                break;
            case 0x8004D101:
                return "HRES_XACT_E_TOOMANY_ENLISTMENTS";
                break;
            case 0x8004D102:
                return "HRES_XACT_E_DUPLICATE_GUID";
                break;
            case 0x8004D103:
                return "HRES_XACT_E_NOTSINGLEPHASE";
                break;
            case 0x8004D104:
                return "HRES_XACT_E_RECOVERYALREADYDONE";
                break;
            case 0x8004D105:
                return "HRES_XACT_E_PROTOCOL";
                break;
            case 0x8004D106:
                return "HRES_XACT_E_RM_FAILURE";
                break;
            case 0x8004D107:
                return "HRES_XACT_E_RECOVERY_FAILED";
                break;
            case 0x8004D108:
                return "HRES_XACT_E_LU_NOT_FOUND";
                break;
            case 0x8004D109:
                return "HRES_XACT_E_DUPLICATE_LU";
                break;
            case 0x8004D10A:
                return "HRES_XACT_E_LU_NOT_CONNECTED";
                break;
            case 0x8004D10B:
                return "HRES_XACT_E_DUPLICATE_TRANSID";
                break;
            case 0x8004D10C:
                return "HRES_XACT_E_LU_BUSY";
                break;
            case 0x8004D10D:
                return "HRES_XACT_E_LU_NO_RECOVERY_PROCESS";
                break;
            case 0x8004D10E:
                return "HRES_XACT_E_LU_DOWN";
                break;
            case 0x8004D10F:
                return "HRES_XACT_E_LU_RECOVERING";
                break;
            case 0x8004D110:
                return "HRES_XACT_E_LU_RECOVERY_MISMATCH";
                break;
            case 0x8004D111:
                return "HRES_XACT_E_RM_UNAVAILABLE";
                break;
            case 0x8004E002:
                return "HRES_CONTEXT_E_ABORTED";
                break;
            case 0x8004E003:
                return "HRES_CONTEXT_E_ABORTING";
                break;
            case 0x8004E004:
                return "HRES_CONTEXT_E_NOCONTEXT";
                break;
            case 0x8004E005:
                return "HRES_CONTEXT_E_WOULD_DEADLOCK";
                break;
            case 0x8004E006:
                return "HRES_CONTEXT_E_SYNCH_TIMEOUT";
                break;
            case 0x8004E007:
                return "HRES_CONTEXT_E_OLDREF";
                break;
            case 0x8004E00C:
                return "HRES_CONTEXT_E_ROLENOTFOUND";
                break;
            case 0x8004E00F:
                return "HRES_CONTEXT_E_TMNOTAVAILABLE";
                break;
            case 0x8004E021:
                return "HRES_CO_E_ACTIVATIONFAILED";
                break;
            case 0x8004E022:
                return "HRES_CO_E_ACTIVATIONFAILED_EVENTLOGGED";
                break;
            case 0x8004E023:
                return "HRES_CO_E_ACTIVATIONFAILED_CATALOGERROR";
                break;
            case 0x8004E024:
                return "HRES_CO_E_ACTIVATIONFAILED_TIMEOUT";
                break;
            case 0x8004E025:
                return "HRES_CO_E_INITIALIZATIONFAILED";
                break;
            case 0x8004E026:
                return "HRES_CONTEXT_E_NOJIT";
                break;
            case 0x8004E027:
                return "HRES_CONTEXT_E_NOTRANSACTION";
                break;
            case 0x8004E028:
                return "HRES_CO_E_THREADINGMODEL_CHANGED";
                break;
            case 0x8004E029:
                return "HRES_CO_E_NOIISINTRINSICS";
                break;
            case 0x8004E02A:
                return "HRES_CO_E_NOCOOKIES";
                break;
            case 0x8004E02B:
                return "HRES_CO_E_DBERROR";
                break;
            case 0x8004E02C:
                return "HRES_CO_E_NOTPOOLED";
                break;
            case 0x8004E02D:
                return "HRES_CO_E_NOTCONSTRUCTED";
                break;
            case 0x8004E02E:
                return "HRES_CO_E_NOSYNCHRONIZATION";
                break;
            case 0x8004E02F:
                return "HRES_CO_E_ISOLEVELMISMATCH";
                break;
            case 0x8004E030:
                return "HRES_CO_E_CALL_OUT_OF_TX_SCOPE_NOT_ALLOWED";
                break;
            case 0x8004E031:
                return "HRES_CO_E_EXIT_TRANSACTION_SCOPE_NOT_CALLED";
                break;
            case 0x80070005:
                return "HRES_E_ACCESSDENIED";
                break;
            case 0x8007000E:
                return "HRES_E_OUTOFMEMORY";
                break;
            case 0x80070032:
                return "HRES_ERROR_NOT_SUPPORTED";
                break;
            case 0x80070057:
                return "HRES_E_INVALIDARG";
                break;
            case 0x80070070:
                return "HRES_ERROR_DISK_FULL";
                break;
            case 0x80080001:
                return "HRES_CO_E_CLASS_CREATE_FAILED";
                break;
            case 0x80080002:
                return "HRES_CO_E_SCM_ERROR";
                break;
            case 0x80080003:
                return "HRES_CO_E_SCM_RPC_FAILURE";
                break;
            case 0x80080004:
                return "HRES_CO_E_BAD_PATH";
                break;
            case 0x80080005:
                return "HRES_CO_E_SERVER_EXEC_FAILURE";
                break;
            case 0x80080006:
                return "HRES_CO_E_OBJSRV_RPC_FAILURE";
                break;
            case 0x80080007:
                return "HRES_MK_E_NO_NORMALIZED";
                break;
            case 0x80080008:
                return "HRES_CO_E_SERVER_STOPPING";
                break;
            case 0x80080009:
                return "HRES_MEM_E_INVALID_ROOT";
                break;
            case 0x80080010:
                return "HRES_MEM_E_INVALID_LINK";
                break;
            case 0x80080011:
                return "HRES_MEM_E_INVALID_SIZE";
                break;
            case 0x80080015:
                return "HRES_CO_E_MISSING_DISPLAYNAME";
                break;
            case 0x80080016:
                return "HRES_CO_E_RUNAS_VALUE_MUST_BE_AAA";
                break;
            case 0x80080017:
                return "HRES_CO_E_ELEVATION_DISABLED";
                break;
            case 0x80090001:
                return "HRES_NTE_BAD_UID";
                break;
            case 0x80090002:
                return "HRES_NTE_BAD_HASH";
                break;
            case 0x80090003:
                return "HRES_NTE_BAD_KEY";
                break;
            case 0x80090004:
                return "HRES_NTE_BAD_LEN";
                break;
            case 0x80090005:
                return "HRES_NTE_BAD_DATA";
                break;
            case 0x80090006:
                return "HRES_NTE_BAD_SIGNATURE";
                break;
            case 0x80090007:
                return "HRES_NTE_BAD_VER";
                break;
            case 0x80090008:
                return "HRES_NTE_BAD_ALGID";
                break;
            case 0x80090009:
                return "HRES_NTE_BAD_FLAGS";
                break;
            case 0x8009000A:
                return "HRES_NTE_BAD_TYPE";
                break;
            case 0x8009000B:
                return "HRES_NTE_BAD_KEY_STATE";
                break;
            case 0x8009000C:
                return "HRES_NTE_BAD_HASH_STATE";
                break;
            case 0x8009000D:
                return "HRES_NTE_NO_KEY";
                break;
            case 0x8009000E:
                return "HRES_NTE_NO_MEMORY";
                break;
            case 0x8009000F:
                return "HRES_NTE_EXISTS";
                break;
            case 0x80090010:
                return "HRES_NTE_PERM";
                break;
            case 0x80090011:
                return "HRES_NTE_NOT_FOUND";
                break;
            case 0x80090012:
                return "HRES_NTE_DOUBLE_ENCRYPT";
                break;
            case 0x80090013:
                return "HRES_NTE_BAD_PROVIDER";
                break;
            case 0x80090014:
                return "HRES_NTE_BAD_PROV_TYPE";
                break;
            case 0x80090015:
                return "HRES_NTE_BAD_PUBLIC_KEY";
                break;
            case 0x80090016:
                return "HRES_NTE_BAD_KEYSET";
                break;
            case 0x80090017:
                return "HRES_NTE_PROV_TYPE_NOT_DEF";
                break;
            case 0x80090018:
                return "HRES_NTE_PROV_TYPE_ENTRY_BAD";
                break;
            case 0x80090019:
                return "HRES_NTE_KEYSET_NOT_DEF";
                break;
            case 0x8009001A:
                return "HRES_NTE_KEYSET_ENTRY_BAD";
                break;
            case 0x8009001B:
                return "HRES_NTE_PROV_TYPE_NO_MATCH";
                break;
            case 0x8009001C:
                return "HRES_NTE_SIGNATURE_FILE_BAD";
                break;
            case 0x8009001D:
                return "HRES_NTE_PROVIDER_DLL_FAIL";
                break;
            case 0x8009001E:
                return "HRES_NTE_PROV_DLL_NOT_FOUND";
                break;
            case 0x8009001F:
                return "HRES_NTE_BAD_KEYSET_PARAM";
                break;
            case 0x80090020:
                return "HRES_NTE_FAIL";
                break;
            case 0x80090021:
                return "HRES_NTE_SYS_ERR";
                break;
            case 0x80090022:
                return "HRES_NTE_SILENT_CONTEXT";
                break;
            case 0x80090023:
                return "HRES_NTE_TOKEN_KEYSET_STORAGE_FULL";
                break;
            case 0x80090024:
                return "HRES_NTE_TEMPORARY_PROFILE";
                break;
            case 0x80090025:
                return "HRES_NTE_FIXEDPARAMETER";
                break;
            case 0x80090026:
                return "HRES_NTE_INVALID_HANDLE";
                break;
            case 0x80090027:
                return "HRES_NTE_INVALID_PARAMETER";
                break;
            case 0x80090028:
                return "HRES_NTE_BUFFER_TOO_SMALL";
                break;
            case 0x80090029:
                return "HRES_NTE_NOT_SUPPORTED";
                break;
            case 0x8009002A:
                return "HRES_NTE_NO_MORE_ITEMS";
                break;
            case 0x8009002B:
                return "HRES_NTE_BUFFERS_OVERLAP";
                break;
            case 0x8009002C:
                return "HRES_NTE_DECRYPTION_FAILURE";
                break;
            case 0x8009002D:
                return "HRES_NTE_INTERNAL_ERROR";
                break;
            case 0x8009002E:
                return "HRES_NTE_UI_REQUIRED";
                break;
            case 0x8009002F:
                return "HRES_NTE_HMAC_NOT_SUPPORTED";
                break;
            case 0x80090300:
                return "HRES_SEC_E_INSUFFICIENT_MEMORY";
                break;
            case 0x80090301:
                return "HRES_SEC_E_INVALID_HANDLE";
                break;
            case 0x80090302:
                return "HRES_SEC_E_UNSUPPORTED_FUNCTION";
                break;
            case 0x80090303:
                return "HRES_SEC_E_TARGET_UNKNOWN";
                break;
            case 0x80090304:
                return "HRES_SEC_E_INTERNAL_ERROR";
                break;
            case 0x80090305:
                return "HRES_SEC_E_SECPKG_NOT_FOUND";
                break;
            case 0x80090306:
                return "HRES_SEC_E_NOT_OWNER";
                break;
            case 0x80090307:
                return "HRES_SEC_E_CANNOT_INSTALL";
                break;
            case 0x80090308:
                return "HRES_SEC_E_INVALID_TOKEN";
                break;
            case 0x80090309:
                return "HRES_SEC_E_CANNOT_PACK";
                break;
            case 0x8009030A:
                return "HRES_SEC_E_QOP_NOT_SUPPORTED";
                break;
            case 0x8009030B:
                return "HRES_SEC_E_NO_IMPERSONATION";
                break;
            case 0x8009030C:
                return "HRES_SEC_E_LOGON_DENIED";
                break;
            case 0x8009030D:
                return "HRES_SEC_E_UNKNOWN_CREDENTIALS";
                break;
            case 0x8009030E:
                return "HRES_SEC_E_NO_CREDENTIALS";
                break;
            case 0x8009030F:
                return "HRES_SEC_E_MESSAGE_ALTERED";
                break;
            case 0x80090310:
                return "HRES_SEC_E_OUT_OF_SEQUENCE";
                break;
            case 0x80090311:
                return "HRES_SEC_E_NO_AUTHENTICATING_AUTHORITY";
                break;
            case 0x80090316:
                return "HRES_SEC_E_BAD_PKGID";
                break;
            case 0x80090317:
                return "HRES_SEC_E_CONTEXT_EXPIRED";
                break;
            case 0x80090318:
                return "HRES_SEC_E_INCOMPLETE_MESSAGE";
                break;
            case 0x80090320:
                return "HRES_SEC_E_INCOMPLETE_CREDENTIALS";
                break;
            case 0x80090321:
                return "HRES_SEC_E_BUFFER_TOO_SMALL";
                break;
            case 0x80090322:
                return "HRES_SEC_E_WRONG_PRINCIPAL";
                break;
            case 0x80090324:
                return "HRES_SEC_E_TIME_SKEW";
                break;
            case 0x80090325:
                return "HRES_SEC_E_UNTRUSTED_ROOT";
                break;
            case 0x80090326:
                return "HRES_SEC_E_ILLEGAL_MESSAGE";
                break;
            case 0x80090327:
                return "HRES_SEC_E_CERT_UNKNOWN";
                break;
            case 0x80090328:
                return "HRES_SEC_E_CERT_EXPIRED";
                break;
            case 0x80090329:
                return "HRES_SEC_E_ENCRYPT_FAILURE";
                break;
            case 0x80090330:
                return "HRES_SEC_E_DECRYPT_FAILURE";
                break;
            case 0x80090331:
                return "HRES_SEC_E_ALGORITHM_MISMATCH";
                break;
            case 0x80090332:
                return "HRES_SEC_E_SECURITY_QOS_FAILED";
                break;
            case 0x80090333:
                return "HRES_SEC_E_UNFINISHED_CONTEXT_DELETED";
                break;
            case 0x80090334:
                return "HRES_SEC_E_NO_TGT_REPLY";
                break;
            case 0x80090335:
                return "HRES_SEC_E_NO_IP_ADDRESSES";
                break;
            case 0x80090336:
                return "HRES_SEC_E_WRONG_CREDENTIAL_HANDLE";
                break;
            case 0x80090337:
                return "HRES_SEC_E_CRYPTO_SYSTEM_INVALID";
                break;
            case 0x80090338:
                return "HRES_SEC_E_MAX_REFERRALS_EXCEEDED";
                break;
            case 0x80090339:
                return "HRES_SEC_E_MUST_BE_KDC";
                break;
            case 0x8009033A:
                return "HRES_SEC_E_STRONG_CRYPTO_NOT_SUPPORTED";
                break;
            case 0x8009033B:
                return "HRES_SEC_E_TOO_MANY_PRINCIPALS";
                break;
            case 0x8009033C:
                return "HRES_SEC_E_NO_PA_DATA";
                break;
            case 0x8009033D:
                return "HRES_SEC_E_PKINIT_NAME_MISMATCH";
                break;
            case 0x8009033E:
                return "HRES_SEC_E_SMARTCARD_LOGON_REQUIRED";
                break;
            case 0x8009033F:
                return "HRES_SEC_E_SHUTDOWN_IN_PROGRESS";
                break;
            case 0x80090340:
                return "HRES_SEC_E_KDC_INVALID_REQUEST";
                break;
            case 0x80090341:
                return "HRES_SEC_E_KDC_UNABLE_TO_REFER";
                break;
            case 0x80090342:
                return "HRES_SEC_E_KDC_UNKNOWN_ETYPE";
                break;
            case 0x80090343:
                return "HRES_SEC_E_UNSUPPORTED_PREAUTH";
                break;
            case 0x80090345:
                return "HRES_SEC_E_DELEGATION_REQUIRED";
                break;
            case 0x80090346:
                return "HRES_SEC_E_BAD_BINDINGS";
                break;
            case 0x80090347:
                return "HRES_SEC_E_MULTIPLE_ACCOUNTS";
                break;
            case 0x80090348:
                return "HRES_SEC_E_NO_KERB_KEY";
                break;
            case 0x80090349:
                return "HRES_SEC_E_CERT_WRONG_USAGE";
                break;
            case 0x80090350:
                return "HRES_SEC_E_DOWNGRADE_DETECTED";
                break;
            case 0x80090351:
                return "HRES_SEC_E_SMARTCARD_CERT_REVOKED";
                break;
            case 0x80090352:
                return "HRES_SEC_E_ISSUING_CA_UNTRUSTED";
                break;
            case 0x80090353:
                return "HRES_SEC_E_REVOCATION_OFFLINE_C";
                break;
            case 0x80090354:
                return "HRES_SEC_E_PKINIT_CLIENT_FAILURE";
                break;
            case 0x80090355:
                return "HRES_SEC_E_SMARTCARD_CERT_EXPIRED";
                break;
            case 0x80090356:
                return "HRES_SEC_E_NO_S4U_PROT_SUPPORT";
                break;
            case 0x80090357:
                return "HRES_SEC_E_CROSSREALM_DELEGATION_FAILURE";
                break;
            case 0x80090358:
                return "HRES_SEC_E_REVOCATION_OFFLINE_KDC";
                break;
            case 0x80090359:
                return "HRES_SEC_E_ISSUING_CA_UNTRUSTED_KDC";
                break;
            case 0x8009035A:
                return "HRES_SEC_E_KDC_CERT_EXPIRED";
                break;
            case 0x8009035B:
                return "HRES_SEC_E_KDC_CERT_REVOKED";
                break;
            case 0x8009035D:
                return "HRES_SEC_E_INVALID_PARAMETER";
                break;
            case 0x8009035E:
                return "HRES_SEC_E_DELEGATION_POLICY";
                break;
            case 0x8009035F:
                return "HRES_SEC_E_POLICY_NLTM_ONLY";
                break;
            case 0x80091001:
                return "HRES_CRYPT_E_MSG_ERROR";
                break;
            case 0x80091002:
                return "HRES_CRYPT_E_UNKNOWN_ALGO";
                break;
            case 0x80091003:
                return "HRES_CRYPT_E_OID_FORMAT";
                break;
            case 0x80091004:
                return "HRES_CRYPT_E_INVALID_MSG_TYPE";
                break;
            case 0x80091005:
                return "HRES_CRYPT_E_UNEXPECTED_ENCODING";
                break;
            case 0x80091006:
                return "HRES_CRYPT_E_AUTH_ATTR_MISSING";
                break;
            case 0x80091007:
                return "HRES_CRYPT_E_HASH_VALUE";
                break;
            case 0x80091008:
                return "HRES_CRYPT_E_INVALID_INDEX";
                break;
            case 0x80091009:
                return "HRES_CRYPT_E_ALREADY_DECRYPTED";
                break;
            case 0x8009100A:
                return "HRES_CRYPT_E_NOT_DECRYPTED";
                break;
            case 0x8009100B:
                return "HRES_CRYPT_E_RECIPIENT_NOT_FOUND";
                break;
            case 0x8009100C:
                return "HRES_CRYPT_E_CONTROL_TYPE";
                break;
            case 0x8009100D:
                return "HRES_CRYPT_E_ISSUER_SERIALNUMBER";
                break;
            case 0x8009100E:
                return "HRES_CRYPT_E_SIGNER_NOT_FOUND";
                break;
            case 0x8009100F:
                return "HRES_CRYPT_E_ATTRIBUTES_MISSING";
                break;
            case 0x80091010:
                return "HRES_CRYPT_E_STREAM_MSG_NOT_READY";
                break;
            case 0x80091011:
                return "HRES_CRYPT_E_STREAM_INSUFFICIENT_DATA";
                break;
            case 0x80092001:
                return "HRES_CRYPT_E_BAD_LEN";
                break;
            case 0x80092002:
                return "HRES_CRYPT_E_BAD_ENCODE";
                break;
            case 0x80092003:
                return "HRES_CRYPT_E_FILE_ERROR";
                break;
            case 0x80092004:
                return "HRES_CRYPT_E_NOT_FOUND";
                break;
            case 0x80092005:
                return "HRES_CRYPT_E_EXISTS";
                break;
            case 0x80092006:
                return "HRES_CRYPT_E_NO_PROVIDER";
                break;
            case 0x80092007:
                return "HRES_CRYPT_E_SELF_SIGNED";
                break;
            case 0x80092008:
                return "HRES_CRYPT_E_DELETED_PREV";
                break;
            case 0x80092009:
                return "HRES_CRYPT_E_NO_MATCH";
                break;
            case 0x8009200A:
                return "HRES_CRYPT_E_UNEXPECTED_MSG_TYPE";
                break;
            case 0x8009200B:
                return "HRES_CRYPT_E_NO_KEY_PROPERTY";
                break;
            case 0x8009200C:
                return "HRES_CRYPT_E_NO_DECRYPT_CERT";
                break;
            case 0x8009200D:
                return "HRES_CRYPT_E_BAD_MSG";
                break;
            case 0x8009200E:
                return "HRES_CRYPT_E_NO_SIGNER";
                break;
            case 0x8009200F:
                return "HRES_CRYPT_E_PENDING_CLOSE";
                break;
            case 0x80092010:
                return "HRES_CRYPT_E_REVOKED";
                break;
            case 0x80092011:
                return "HRES_CRYPT_E_NO_REVOCATION_DLL";
                break;
            case 0x80092012:
                return "HRES_CRYPT_E_NO_REVOCATION_CHECK";
                break;
            case 0x80092013:
                return "HRES_CRYPT_E_REVOCATION_OFFLINE";
                break;
            case 0x80092014:
                return "HRES_CRYPT_E_NOT_IN_REVOCATION_DATABASE";
                break;
            case 0x80092020:
                return "HRES_CRYPT_E_INVALID_NUMERIC_STRING";
                break;
            case 0x80092021:
                return "HRES_CRYPT_E_INVALID_PRINTABLE_STRING";
                break;
            case 0x80092022:
                return "HRES_CRYPT_E_INVALID_IA5_STRING";
                break;
            case 0x80092023:
                return "HRES_CRYPT_E_INVALID_X500_STRING";
                break;
            case 0x80092024:
                return "HRES_CRYPT_E_NOT_CHAR_STRING";
                break;
            case 0x80092025:
                return "HRES_CRYPT_E_FILERESIZED";
                break;
            case 0x80092026:
                return "HRES_CRYPT_E_SECURITY_SETTINGS";
                break;
            case 0x80092027:
                return "HRES_CRYPT_E_NO_VERIFY_USAGE_DLL";
                break;
            case 0x80092028:
                return "HRES_CRYPT_E_NO_VERIFY_USAGE_CHECK";
                break;
            case 0x80092029:
                return "HRES_CRYPT_E_VERIFY_USAGE_OFFLINE";
                break;
            case 0x8009202A:
                return "HRES_CRYPT_E_NOT_IN_CTL";
                break;
            case 0x8009202B:
                return "HRES_CRYPT_E_NO_TRUSTED_SIGNER";
                break;
            case 0x8009202C:
                return "HRES_CRYPT_E_MISSING_PUBKEY_PARA";
                break;
            case 0x80093000:
                return "HRES_CRYPT_E_OSS_ERROR";
                break;
            case 0x80093001:
                return "HRES_OSS_MORE_BUF";
                break;
            case 0x80093002:
                return "HRES_OSS_NEGATIVE_UINTEGER";
                break;
            case 0x80093003:
                return "HRES_OSS_PDU_RANGE";
                break;
            case 0x80093004:
                return "HRES_OSS_MORE_INPUT";
                break;
            case 0x80093005:
                return "HRES_OSS_DATA_ERROR";
                break;
            case 0x80093006:
                return "HRES_OSS_BAD_ARG";
                break;
            case 0x80093007:
                return "HRES_OSS_BAD_VERSION";
                break;
            case 0x80093008:
                return "HRES_OSS_OUT_MEMORY";
                break;
            case 0x80093009:
                return "HRES_OSS_PDU_MISMATCH";
                break;
            case 0x8009300A:
                return "HRES_OSS_LIMITED";
                break;
            case 0x8009300B:
                return "HRES_OSS_BAD_PTR";
                break;
            case 0x8009300C:
                return "HRES_OSS_BAD_TIME";
                break;
            case 0x8009300D:
                return "HRES_OSS_INDEFINITE_NOT_SUPPORTED";
                break;
            case 0x8009300E:
                return "HRES_OSS_MEM_ERROR";
                break;
            case 0x8009300F:
                return "HRES_OSS_BAD_TABLE";
                break;
            case 0x80093010:
                return "HRES_OSS_TOO_LONG";
                break;
            case 0x80093011:
                return "HRES_OSS_CONSTRAINT_VIOLATED";
                break;
            case 0x80093012:
                return "HRES_OSS_FATAL_ERROR";
                break;
            case 0x80093013:
                return "HRES_OSS_ACCESS_SERIALIZATION_ERROR";
                break;
            case 0x80093014:
                return "HRES_OSS_NULL_TBL";
                break;
            case 0x80093015:
                return "HRES_OSS_NULL_FCN";
                break;
            case 0x80093016:
                return "HRES_OSS_BAD_ENCRULES";
                break;
            case 0x80093017:
                return "HRES_OSS_UNAVAIL_ENCRULES";
                break;
            case 0x80093018:
                return "HRES_OSS_CANT_OPEN_TRACE_WINDOW";
                break;
            case 0x80093019:
                return "HRES_OSS_UNIMPLEMENTED";
                break;
            case 0x8009301A:
                return "HRES_OSS_OID_DLL_NOT_LINKED";
                break;
            case 0x8009301B:
                return "HRES_OSS_CANT_OPEN_TRACE_FILE";
                break;
            case 0x8009301C:
                return "HRES_OSS_TRACE_FILE_ALREADY_OPEN";
                break;
            case 0x8009301D:
                return "HRES_OSS_TABLE_MISMATCH";
                break;
            case 0x8009301E:
                return "HRES_OSS_TYPE_NOT_SUPPORTED";
                break;
            case 0x8009301F:
                return "HRES_OSS_REAL_DLL_NOT_LINKED";
                break;
            case 0x80093020:
                return "HRES_OSS_REAL_CODE_NOT_LINKED";
                break;
            case 0x80093021:
                return "HRES_OSS_OUT_OF_RANGE";
                break;
            case 0x80093022:
                return "HRES_OSS_COPIER_DLL_NOT_LINKED";
                break;
            case 0x80093023:
                return "HRES_OSS_CONSTRAINT_DLL_NOT_LINKED";
                break;
            case 0x80093024:
                return "HRES_OSS_COMPARATOR_DLL_NOT_LINKED";
                break;
            case 0x80093025:
                return "HRES_OSS_COMPARATOR_CODE_NOT_LINKED";
                break;
            case 0x80093026:
                return "HRES_OSS_MEM_MGR_DLL_NOT_LINKED";
                break;
            case 0x80093027:
                return "HRES_OSS_PDV_DLL_NOT_LINKED";
                break;
            case 0x80093028:
                return "HRES_OSS_PDV_CODE_NOT_LINKED";
                break;
            case 0x80093029:
                return "HRES_OSS_API_DLL_NOT_LINKED";
                break;
            case 0x8009302A:
                return "HRES_OSS_BERDER_DLL_NOT_LINKED";
                break;
            case 0x8009302B:
                return "HRES_OSS_PER_DLL_NOT_LINKED";
                break;
            case 0x8009302C:
                return "HRES_OSS_OPEN_TYPE_ERROR";
                break;
            case 0x8009302D:
                return "HRES_OSS_MUTEX_NOT_CREATED";
                break;
            case 0x8009302E:
                return "HRES_OSS_CANT_CLOSE_TRACE_FILE";
                break;
            case 0x80093100:
                return "HRES_CRYPT_E_ASN1_ERROR";
                break;
            case 0x80093101:
                return "HRES_CRYPT_E_ASN1_INTERNAL";
                break;
            case 0x80093102:
                return "HRES_CRYPT_E_ASN1_EOD";
                break;
            case 0x80093103:
                return "HRES_CRYPT_E_ASN1_CORRUPT";
                break;
            case 0x80093104:
                return "HRES_CRYPT_E_ASN1_LARGE";
                break;
            case 0x80093105:
                return "HRES_CRYPT_E_ASN1_CONSTRAINT";
                break;
            case 0x80093106:
                return "HRES_CRYPT_E_ASN1_MEMORY";
                break;
            case 0x80093107:
                return "HRES_CRYPT_E_ASN1_OVERFLOW";
                break;
            case 0x80093108:
                return "HRES_CRYPT_E_ASN1_BADPDU";
                break;
            case 0x80093109:
                return "HRES_CRYPT_E_ASN1_BADARGS";
                break;
            case 0x8009310A:
                return "HRES_CRYPT_E_ASN1_BADREAL";
                break;
            case 0x8009310B:
                return "HRES_CRYPT_E_ASN1_BADTAG";
                break;
            case 0x8009310C:
                return "HRES_CRYPT_E_ASN1_CHOICE";
                break;
            case 0x8009310D:
                return "HRES_CRYPT_E_ASN1_RULE";
                break;
            case 0x8009310E:
                return "HRES_CRYPT_E_ASN1_UTF8";
                break;
            case 0x80093133:
                return "HRES_CRYPT_E_ASN1_PDU_TYPE";
                break;
            case 0x80093134:
                return "HRES_CRYPT_E_ASN1_NYI";
                break;
            case 0x80093201:
                return "HRES_CRYPT_E_ASN1_EXTENDED";
                break;
            case 0x80093202:
                return "HRES_CRYPT_E_ASN1_NOEOD";
                break;
            case 0x80094001:
                return "HRES_CERTSRV_E_BAD_REQUESTSUBJECT";
                break;
            case 0x80094002:
                return "HRES_CERTSRV_E_NO_REQUEST";
                break;
            case 0x80094003:
                return "HRES_CERTSRV_E_BAD_REQUESTSTATUS";
                break;
            case 0x80094004:
                return "HRES_CERTSRV_E_PROPERTY_EMPTY";
                break;
            case 0x80094005:
                return "HRES_CERTSRV_E_INVALID_CA_CERTIFICATE";
                break;
            case 0x80094006:
                return "HRES_CERTSRV_E_SERVER_SUSPENDED";
                break;
            case 0x80094007:
                return "HRES_CERTSRV_E_ENCODING_LENGTH";
                break;
            case 0x80094008:
                return "HRES_CERTSRV_E_ROLECONFLICT";
                break;
            case 0x80094009:
                return "HRES_CERTSRV_E_RESTRICTEDOFFICER";
                break;
            case 0x8009400A:
                return "HRES_CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED";
                break;
            case 0x8009400B:
                return "HRES_CERTSRV_E_NO_VALID_KRA";
                break;
            case 0x8009400C:
                return "HRES_CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL";
                break;
            case 0x8009400D:
                return "HRES_CERTSRV_E_NO_CAADMIN_DEFINED";
                break;
            case 0x8009400E:
                return "HRES_CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE";
                break;
            case 0x8009400F:
                return "HRES_CERTSRV_E_NO_DB_SESSIONS";
                break;
            case 0x80094010:
                return "HRES_CERTSRV_E_ALIGNMENT_FAULT";
                break;
            case 0x80094011:
                return "HRES_CERTSRV_E_ENROLL_DENIED";
                break;
            case 0x80094012:
                return "HRES_CERTSRV_E_TEMPLATE_DENIED";
                break;
            case 0x80094013:
                return "HRES_CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE";
                break;
            case 0x80094800:
                return "HRES_CERTSRV_E_UNSUPPORTED_CERT_TYPE";
                break;
            case 0x80094801:
                return "HRES_CERTSRV_E_NO_CERT_TYPE";
                break;
            case 0x80094802:
                return "HRES_CERTSRV_E_TEMPLATE_CONFLICT";
                break;
            case 0x80094803:
                return "HRES_CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED";
                break;
            case 0x80094804:
                return "HRES_CERTSRV_E_ARCHIVED_KEY_REQUIRED";
                break;
            case 0x80094805:
                return "HRES_CERTSRV_E_SMIME_REQUIRED";
                break;
            case 0x80094806:
                return "HRES_CERTSRV_E_BAD_RENEWAL_SUBJECT";
                break;
            case 0x80094807:
                return "HRES_CERTSRV_E_BAD_TEMPLATE_VERSION";
                break;
            case 0x80094808:
                return "HRES_CERTSRV_E_TEMPLATE_POLICY_REQUIRED";
                break;
            case 0x80094809:
                return "HRES_CERTSRV_E_SIGNATURE_POLICY_REQUIRED";
                break;
            case 0x8009480A:
                return "HRES_CERTSRV_E_SIGNATURE_COUNT";
                break;
            case 0x8009480B:
                return "HRES_CERTSRV_E_SIGNATURE_REJECTED";
                break;
            case 0x8009480C:
                return "HRES_CERTSRV_E_ISSUANCE_POLICY_REQUIRED";
                break;
            case 0x8009480D:
                return "HRES_CERTSRV_E_SUBJECT_UPN_REQUIRED";
                break;
            case 0x8009480E:
                return "HRES_CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED";
                break;
            case 0x8009480F:
                return "HRES_CERTSRV_E_SUBJECT_DNS_REQUIRED";
                break;
            case 0x80094810:
                return "HRES_CERTSRV_E_ARCHIVED_KEY_UNEXPECTED";
                break;
            case 0x80094811:
                return "HRES_CERTSRV_E_KEY_LENGTH";
                break;
            case 0x80094812:
                return "HRES_CERTSRV_E_SUBJECT_EMAIL_REQUIRED";
                break;
            case 0x80094813:
                return "HRES_CERTSRV_E_UNKNOWN_CERT_TYPE";
                break;
            case 0x80094814:
                return "HRES_CERTSRV_E_CERT_TYPE_OVERLAP";
                break;
            case 0x80094815:
                return "HRES_CERTSRV_E_TOO_MANY_SIGNATURES";
                break;
            case 0x80094816:
                return "HRES_CERTSRV_E_RENEWAL_BAD_PUBLIC_KEY";
                break;
            case 0x80094817:
                return "HRES_CERTSRV_E_INVALID_EK";
                break;
            case 0x8009481A:
                return "HRES_CERTSRV_E_KEY_ATTESTATION";
                break;
            case 0x80095000:
                return "HRES_XENROLL_E_KEY_NOT_EXPORTABLE";
                break;
            case 0x80095001:
                return "HRES_XENROLL_E_CANNOT_ADD_ROOT_CERT";
                break;
            case 0x80095002:
                return "HRES_XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND";
                break;
            case 0x80095003:
                return "HRES_XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH";
                break;
            case 0x80095004:
                return "HRES_XENROLL_E_RESPONSE_KA_HASH_MISMATCH";
                break;
            case 0x80095005:
                return "HRES_XENROLL_E_KEYSPEC_SMIME_MISMATCH";
                break;
            case 0x80096001:
                return "HRES_TRUST_E_SYSTEM_ERROR";
                break;
            case 0x80096002:
                return "HRES_TRUST_E_NO_SIGNER_CERT";
                break;
            case 0x80096003:
                return "HRES_TRUST_E_COUNTER_SIGNER";
                break;
            case 0x80096004:
                return "HRES_TRUST_E_CERT_SIGNATURE";
                break;
            case 0x80096005:
                return "HRES_TRUST_E_TIME_STAMP";
                break;
            case 0x80096010:
                return "HRES_TRUST_E_BAD_DIGEST";
                break;
            case 0x80096019:
                return "HRES_TRUST_E_BASIC_CONSTRAINTS";
                break;
            case 0x8009601E:
                return "HRES_TRUST_E_FINANCIAL_CRITERIA";
                break;
            case 0x80097001:
                return "HRES_MSSIPOTF_E_OUTOFMEMRANGE";
                break;
            case 0x80097002:
                return "HRES_MSSIPOTF_E_CANTGETOBJECT";
                break;
            case 0x80097003:
                return "HRES_MSSIPOTF_E_NOHEADTABLE";
                break;
            case 0x80097004:
                return "HRES_MSSIPOTF_E_BAD_MAGICNUMBER";
                break;
            case 0x80097005:
                return "HRES_MSSIPOTF_E_BAD_OFFSET_TABLE";
                break;
            case 0x80097006:
                return "HRES_MSSIPOTF_E_TABLE_TAGORDER";
                break;
            case 0x80097007:
                return "HRES_MSSIPOTF_E_TABLE_LONGWORD";
                break;
            case 0x80097008:
                return "HRES_MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT";
                break;
            case 0x80097009:
                return "HRES_MSSIPOTF_E_TABLES_OVERLAP";
                break;
            case 0x8009700A:
                return "HRES_MSSIPOTF_E_TABLE_PADBYTES";
                break;
            case 0x8009700B:
                return "HRES_MSSIPOTF_E_FILETOOSMALL";
                break;
            case 0x8009700C:
                return "HRES_MSSIPOTF_E_TABLE_CHECKSUM";
                break;
            case 0x8009700D:
                return "HRES_MSSIPOTF_E_FILE_CHECKSUM";
                break;
            case 0x80097010:
                return "HRES_MSSIPOTF_E_FAILED_POLICY";
                break;
            case 0x80097011:
                return "HRES_MSSIPOTF_E_FAILED_HINTS_CHECK";
                break;
            case 0x80097012:
                return "HRES_MSSIPOTF_E_NOT_OPENTYPE";
                break;
            case 0x80097013:
                return "HRES_MSSIPOTF_E_FILE";
                break;
            case 0x80097014:
                return "HRES_MSSIPOTF_E_CRYPT";
                break;
            case 0x80097015:
                return "HRES_MSSIPOTF_E_BADVERSION";
                break;
            case 0x80097016:
                return "HRES_MSSIPOTF_E_DSIG_STRUCTURE";
                break;
            case 0x80097017:
                return "HRES_MSSIPOTF_E_PCONST_CHECK";
                break;
            case 0x80097018:
                return "HRES_MSSIPOTF_E_STRUCTURE";
                break;
            case 0x80097019:
                return "HRES_ERROR_CRED_REQUIRES_CONFIRMATION";
                break;
            case 0x800B0001:
                return "HRES_TRUST_E_PROVIDER_UNKNOWN";
                break;
            case 0x800B0002:
                return "HRES_TRUST_E_ACTION_UNKNOWN";
                break;
            case 0x800B0003:
                return "HRES_TRUST_E_SUBJECT_FORM_UNKNOWN";
                break;
            case 0x800B0004:
                return "HRES_TRUST_E_SUBJECT_NOT_TRUSTED";
                break;
            case 0x800B0005:
                return "HRES_DIGSIG_E_ENCODE";
                break;
            case 0x800B0006:
                return "HRES_DIGSIG_E_DECODE";
                break;
            case 0x800B0007:
                return "HRES_DIGSIG_E_EXTENSIBILITY";
                break;
            case 0x800B0008:
                return "HRES_DIGSIG_E_CRYPTO";
                break;
            case 0x800B0009:
                return "HRES_PERSIST_E_SIZEDEFINITE";
                break;
            case 0x800B000A:
                return "HRES_PERSIST_E_SIZEINDEFINITE";
                break;
            case 0x800B000B:
                return "HRES_PERSIST_E_NOTSELFSIZING";
                break;
            case 0x800B0100:
                return "HRES_TRUST_E_NOSIGNATURE";
                break;
            case 0x800B0101:
                return "HRES_CERT_E_EXPIRED";
                break;
            case 0x800B0102:
                return "HRES_CERT_E_VALIDITYPERIODNESTING";
                break;
            case 0x800B0103:
                return "HRES_CERT_E_ROLE";
                break;
            case 0x800B0104:
                return "HRES_CERT_E_PATHLENCONST";
                break;
            case 0x800B0105:
                return "HRES_CERT_E_CRITICAL";
                break;
            case 0x800B0106:
                return "HRES_CERT_E_PURPOSE";
                break;
            case 0x800B0107:
                return "HRES_CERT_E_ISSUERCHAINING";
                break;
            case 0x800B0108:
                return "HRES_CERT_E_MALFORMED";
                break;
            case 0x800B0109:
                return "HRES_CERT_E_UNTRUSTEDROOT";
                break;
            case 0x800B010A:
                return "HRES_CERT_E_CHAINING";
                break;
            case 0x800B010B:
                return "HRES_TRUST_E_FAIL";
                break;
            case 0x800B010C:
                return "HRES_CERT_E_REVOKED";
                break;
            case 0x800B010D:
                return "HRES_CERT_E_UNTRUSTEDTESTROOT";
                break;
            case 0x800B010E:
                return "HRES_CERT_E_REVOCATION_FAILURE";
                break;
            case 0x800B010F:
                return "HRES_CERT_E_CN_NO_MATCH";
                break;
            case 0x800B0110:
                return "HRES_CERT_E_WRONG_USAGE";
                break;
            case 0x800B0111:
                return "HRES_TRUST_E_EXPLICIT_DISTRUST";
                break;
            case 0x800B0112:
                return "HRES_CERT_E_UNTRUSTEDCA";
                break;
            case 0x800B0113:
                return "HRES_CERT_E_INVALID_POLICY";
                break;
            case 0x800B0114:
                return "HRES_CERT_E_INVALID_NAME";
                break;
            case 0x800D0003:
                return "HRES_NS_W_SERVER_BANDWIDTH_LIMIT";
                break;
            case 0x800D0004:
                return "HRES_NS_W_FILE_BANDWIDTH_LIMIT";
                break;
            case 0x800D0060:
                return "HRES_NS_W_UNKNOWN_EVENT";
                break;
            case 0x800D0199:
                return "HRES_NS_I_CATATONIC_FAILURE";
                break;
            case 0x800D019A:
                return "HRES_NS_I_CATATONIC_AUTO_UNFAIL";
                break;
            case 0x800F0000:
                return "HRES_SPAPI_E_EXPECTED_SECTION_NAME";
                break;
            case 0x800F0001:
                return "HRES_SPAPI_E_BAD_SECTION_NAME_LINE";
                break;
            case 0x800F0002:
                return "HRES_SPAPI_E_SECTION_NAME_TOO_LONG";
                break;
            case 0x800F0003:
                return "HRES_SPAPI_E_GENERAL_SYNTAX";
                break;
            case 0x800F0100:
                return "HRES_SPAPI_E_WRONG_INF_STYLE";
                break;
            case 0x800F0101:
                return "HRES_SPAPI_E_SECTION_NOT_FOUND";
                break;
            case 0x800F0102:
                return "HRES_SPAPI_E_LINE_NOT_FOUND";
                break;
            case 0x800F0103:
                return "HRES_SPAPI_E_NO_BACKUP";
                break;
            case 0x800F0200:
                return "HRES_SPAPI_E_NO_ASSOCIATED_CLASS";
                break;
            case 0x800F0201:
                return "HRES_SPAPI_E_CLASS_MISMATCH";
                break;
            case 0x800F0202:
                return "HRES_SPAPI_E_DUPLICATE_FOUND";
                break;
            case 0x800F0203:
                return "HRES_SPAPI_E_NO_DRIVER_SELECTED";
                break;
            case 0x800F0204:
                return "HRES_SPAPI_E_KEY_DOES_NOT_EXIST";
                break;
            case 0x800F0205:
                return "HRES_SPAPI_E_INVALID_DEVINST_NAME";
                break;
            case 0x800F0206:
                return "HRES_SPAPI_E_INVALID_CLASS";
                break;
            case 0x800F0207:
                return "HRES_SPAPI_E_DEVINST_ALREADY_EXISTS";
                break;
            case 0x800F0208:
                return "HRES_SPAPI_E_DEVINFO_NOT_REGISTERED";
                break;
            case 0x800F0209:
                return "HRES_SPAPI_E_INVALID_REG_PROPERTY";
                break;
            case 0x800F020A:
                return "HRES_SPAPI_E_NO_INF";
                break;
            case 0x800F020B:
                return "HRES_SPAPI_E_NO_SUCH_DEVINST";
                break;
            case 0x800F020C:
                return "HRES_SPAPI_E_CANT_LOAD_CLASS_ICON";
                break;
            case 0x800F020D:
                return "HRES_SPAPI_E_INVALID_CLASS_INSTALLER";
                break;
            case 0x800F020E:
                return "HRES_SPAPI_E_DI_DO_DEFAULT";
                break;
            case 0x800F020F:
                return "HRES_SPAPI_E_DI_NOFILECOPY";
                break;
            case 0x800F0210:
                return "HRES_SPAPI_E_INVALID_HWPROFILE";
                break;
            case 0x800F0211:
                return "HRES_SPAPI_E_NO_DEVICE_SELECTED";
                break;
            case 0x800F0212:
                return "HRES_SPAPI_E_DEVINFO_LIST_LOCKED";
                break;
            case 0x800F0213:
                return "HRES_SPAPI_E_DEVINFO_DATA_LOCKED";
                break;
            case 0x800F0214:
                return "HRES_SPAPI_E_DI_BAD_PATH";
                break;
            case 0x800F0215:
                return "HRES_SPAPI_E_NO_CLASSINSTALL_PARAMS";
                break;
            case 0x800F0216:
                return "HRES_SPAPI_E_FILEQUEUE_LOCKED";
                break;
            case 0x800F0217:
                return "HRES_SPAPI_E_BAD_SERVICE_INSTALLSECT";
                break;
            case 0x800F0218:
                return "HRES_SPAPI_E_NO_CLASS_DRIVER_LIST";
                break;
            case 0x800F0219:
                return "HRES_SPAPI_E_NO_ASSOCIATED_SERVICE";
                break;
            case 0x800F021A:
                return "HRES_SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE";
                break;
            case 0x800F021B:
                return "HRES_SPAPI_E_DEVICE_INTERFACE_ACTIVE";
                break;
            case 0x800F021C:
                return "HRES_SPAPI_E_DEVICE_INTERFACE_REMOVED";
                break;
            case 0x800F021D:
                return "HRES_SPAPI_E_BAD_INTERFACE_INSTALLSECT";
                break;
            case 0x800F021E:
                return "HRES_SPAPI_E_NO_SUCH_INTERFACE_CLASS";
                break;
            case 0x800F021F:
                return "HRES_SPAPI_E_INVALID_REFERENCE_STRING";
                break;
            case 0x800F0220:
                return "HRES_SPAPI_E_INVALID_MACHINENAME";
                break;
            case 0x800F0221:
                return "HRES_SPAPI_E_REMOTE_COMM_FAILURE";
                break;
            case 0x800F0222:
                return "HRES_SPAPI_E_MACHINE_UNAVAILABLE";
                break;
            case 0x800F0223:
                return "HRES_SPAPI_E_NO_CONFIGMGR_SERVICES";
                break;
            case 0x800F0224:
                return "HRES_SPAPI_E_INVALID_PROPPAGE_PROVIDER";
                break;
            case 0x800F0225:
                return "HRES_SPAPI_E_NO_SUCH_DEVICE_INTERFACE";
                break;
            case 0x800F0226:
                return "HRES_SPAPI_E_DI_POSTPROCESSING_REQUIRED";
                break;
            case 0x800F0227:
                return "HRES_SPAPI_E_INVALID_COINSTALLER";
                break;
            case 0x800F0228:
                return "HRES_SPAPI_E_NO_COMPAT_DRIVERS";
                break;
            case 0x800F0229:
                return "HRES_SPAPI_E_NO_DEVICE_ICON";
                break;
            case 0x800F022A:
                return "HRES_SPAPI_E_INVALID_INF_LOGCONFIG";
                break;
            case 0x800F022B:
                return "HRES_SPAPI_E_DI_DONT_INSTALL";
                break;
            case 0x800F022C:
                return "HRES_SPAPI_E_INVALID_FILTER_DRIVER";
                break;
            case 0x800F022D:
                return "HRES_SPAPI_E_NON_WINDOWS_NT_DRIVER";
                break;
            case 0x800F022E:
                return "HRES_SPAPI_E_NON_WINDOWS_DRIVER";
                break;
            case 0x800F022F:
                return "HRES_SPAPI_E_NO_CATALOG_FOR_OEM_INF";
                break;
            case 0x800F0230:
                return "HRES_SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE";
                break;
            case 0x800F0231:
                return "HRES_SPAPI_E_NOT_DISABLEABLE";
                break;
            case 0x800F0232:
                return "HRES_SPAPI_E_CANT_REMOVE_DEVINST";
                break;
            case 0x800F0233:
                return "HRES_SPAPI_E_INVALID_TARGET";
                break;
            case 0x800F0234:
                return "HRES_SPAPI_E_DRIVER_NONNATIVE";
                break;
            case 0x800F0235:
                return "HRES_SPAPI_E_IN_WOW64";
                break;
            case 0x800F0236:
                return "HRES_SPAPI_E_SET_SYSTEM_RESTORE_POINT";
                break;
            case 0x800F0237:
                return "HRES_SPAPI_E_INCORRECTLY_COPIED_INF";
                break;
            case 0x800F0238:
                return "HRES_SPAPI_E_SCE_DISABLED";
                break;
            case 0x800F0239:
                return "HRES_SPAPI_E_UNKNOWN_EXCEPTION";
                break;
            case 0x800F023A:
                return "HRES_SPAPI_E_PNP_REGISTRY_ERROR";
                break;
            case 0x800F023B:
                return "HRES_SPAPI_E_REMOTE_REQUEST_UNSUPPORTED";
                break;
            case 0x800F023C:
                return "HRES_SPAPI_E_NOT_AN_INSTALLED_OEM_INF";
                break;
            case 0x800F023D:
                return "HRES_SPAPI_E_INF_IN_USE_BY_DEVICES";
                break;
            case 0x800F023E:
                return "HRES_SPAPI_E_DI_FUNCTION_OBSOLETE";
                break;
            case 0x800F023F:
                return "HRES_SPAPI_E_NO_AUTHENTICODE_CATALOG";
                break;
            case 0x800F0240:
                return "HRES_SPAPI_E_AUTHENTICODE_DISALLOWED";
                break;
            case 0x800F0241:
                return "HRES_SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER";
                break;
            case 0x800F0242:
                return "HRES_SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED";
                break;
            case 0x800F0243:
                return "HRES_SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED";
                break;
            case 0x800F0244:
                return "HRES_SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH";
                break;
            case 0x800F0245:
                return "HRES_SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE";
                break;
            case 0x800F0246:
                return "HRES_SPAPI_E_DEVICE_INSTALLER_NOT_READY";
                break;
            case 0x800F0247:
                return "HRES_SPAPI_E_DRIVER_STORE_ADD_FAILED";
                break;
            case 0x800F0248:
                return "HRES_SPAPI_E_DEVICE_INSTALL_BLOCKED";
                break;
            case 0x800F0249:
                return "HRES_SPAPI_E_DRIVER_INSTALL_BLOCKED";
                break;
            case 0x800F024A:
                return "HRES_SPAPI_E_WRONG_INF_TYPE";
                break;
            case 0x800F024B:
                return "HRES_SPAPI_E_FILE_HASH_NOT_IN_CATALOG";
                break;
            case 0x800F024C:
                return "HRES_SPAPI_E_DRIVER_STORE_DELETE_FAILED";
                break;
            case 0x800F0300:
                return "HRES_SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW";
                break;
            case 0x800F1000:
                return "HRES_SPAPI_E_ERROR_NOT_INSTALLED";
                break;
            case 0x80100001:
                return "HRES_SCARD_F_INTERNAL_ERROR";
                break;
            case 0x80100002:
                return "HRES_SCARD_E_CANCELLED";
                break;
            case 0x80100003:
                return "HRES_SCARD_E_INVALID_HANDLE";
                break;
            case 0x80100004:
                return "HRES_SCARD_E_INVALID_PARAMETER";
                break;
            case 0x80100005:
                return "HRES_SCARD_E_INVALID_TARGET";
                break;
            case 0x80100006:
                return "HRES_SCARD_E_NO_MEMORY";
                break;
            case 0x80100007:
                return "HRES_SCARD_F_WAITED_TOO_LONG";
                break;
            case 0x80100008:
                return "HRES_SCARD_E_INSUFFICIENT_BUFFER";
                break;
            case 0x80100009:
                return "HRES_SCARD_E_UNKNOWN_READER";
                break;
            case 0x8010000A:
                return "HRES_SCARD_E_TIMEOUT";
                break;
            case 0x8010000B:
                return "HRES_SCARD_E_SHARING_VIOLATION";
                break;
            case 0x8010000C:
                return "HRES_SCARD_E_NO_SMARTCARD";
                break;
            case 0x8010000D:
                return "HRES_SCARD_E_UNKNOWN_CARD";
                break;
            case 0x8010000E:
                return "HRES_SCARD_E_CANT_DISPOSE";
                break;
            case 0x8010000F:
                return "HRES_SCARD_E_PROTO_MISMATCH";
                break;
            case 0x80100010:
                return "HRES_SCARD_E_NOT_READY";
                break;
            case 0x80100011:
                return "HRES_SCARD_E_INVALID_VALUE";
                break;
            case 0x80100012:
                return "HRES_SCARD_E_SYSTEM_CANCELLED";
                break;
            case 0x80100013:
                return "HRES_SCARD_F_COMM_ERROR";
                break;
            case 0x80100014:
                return "HRES_SCARD_F_UNKNOWN_ERROR";
                break;
            case 0x80100015:
                return "HRES_SCARD_E_INVALID_ATR";
                break;
            case 0x80100016:
                return "HRES_SCARD_E_NOT_TRANSACTED";
                break;
            case 0x80100017:
                return "HRES_SCARD_E_READER_UNAVAILABLE";
                break;
            case 0x80100018:
                return "HRES_SCARD_P_SHUTDOWN";
                break;
            case 0x80100019:
                return "HRES_SCARD_E_PCI_TOO_SMALL";
                break;
            case 0x8010001A:
                return "HRES_SCARD_E_READER_UNSUPPORTED";
                break;
            case 0x8010001B:
                return "HRES_SCARD_E_DUPLICATE_READER";
                break;
            case 0x8010001C:
                return "HRES_SCARD_E_CARD_UNSUPPORTED";
                break;
            case 0x8010001D:
                return "HRES_SCARD_E_NO_SERVICE";
                break;
            case 0x8010001E:
                return "HRES_SCARD_E_SERVICE_STOPPED";
                break;
            case 0x8010001F:
                return "HRES_SCARD_E_UNEXPECTED";
                break;
            case 0x80100020:
                return "HRES_SCARD_E_ICC_INSTALLATION";
                break;
            case 0x80100021:
                return "HRES_SCARD_E_ICC_CREATEORDER";
                break;
            case 0x80100022:
                return "HRES_SCARD_E_UNSUPPORTED_FEATURE";
                break;
            case 0x80100023:
                return "HRES_SCARD_E_DIR_NOT_FOUND";
                break;
            case 0x80100024:
                return "HRES_SCARD_E_FILE_NOT_FOUND";
                break;
            case 0x80100025:
                return "HRES_SCARD_E_NO_DIR";
                break;
            case 0x80100026:
                return "HRES_SCARD_E_NO_FILE";
                break;
            case 0x80100027:
                return "HRES_SCARD_E_NO_ACCESS";
                break;
            case 0x80100028:
                return "HRES_SCARD_E_WRITE_TOO_MANY";
                break;
            case 0x80100029:
                return "HRES_SCARD_E_BAD_SEEK";
                break;
            case 0x8010002A:
                return "HRES_SCARD_E_INVALID_CHV";
                break;
            case 0x8010002B:
                return "HRES_SCARD_E_UNKNOWN_RES_MNG";
                break;
            case 0x8010002C:
                return "HRES_SCARD_E_NO_SUCH_CERTIFICATE";
                break;
            case 0x8010002D:
                return "HRES_SCARD_E_CERTIFICATE_UNAVAILABLE";
                break;
            case 0x8010002E:
                return "HRES_SCARD_E_NO_READERS_AVAILABLE";
                break;
            case 0x8010002F:
                return "HRES_SCARD_E_COMM_DATA_LOST";
                break;
            case 0x80100030:
                return "HRES_SCARD_E_NO_KEY_CONTAINER";
                break;
            case 0x80100031:
                return "HRES_SCARD_E_SERVER_TOO_BUSY";
                break;
            case 0x80100065:
                return "HRES_SCARD_W_UNSUPPORTED_CARD";
                break;
            case 0x80100066:
                return "HRES_SCARD_W_UNRESPONSIVE_CARD";
                break;
            case 0x80100067:
                return "HRES_SCARD_W_UNPOWERED_CARD";
                break;
            case 0x80100068:
                return "HRES_SCARD_W_RESET_CARD";
                break;
            case 0x80100069:
                return "HRES_SCARD_W_REMOVED_CARD";
                break;
            case 0x8010006A:
                return "HRES_SCARD_W_SECURITY_VIOLATION";
                break;
            case 0x8010006B:
                return "HRES_SCARD_W_WRONG_CHV";
                break;
            case 0x8010006C:
                return "HRES_SCARD_W_CHV_BLOCKED";
                break;
            case 0x8010006D:
                return "HRES_SCARD_W_EOF";
                break;
            case 0x8010006E:
                return "HRES_SCARD_W_CANCELLED_BY_USER";
                break;
            case 0x8010006F:
                return "HRES_SCARD_W_CARD_NOT_AUTHENTICATED";
                break;
            case 0x80110401:
                return "HRES_COMADMIN_E_OBJECTERRORS";
                break;
            case 0x80110402:
                return "HRES_COMADMIN_E_OBJECTINVALID";
                break;
            case 0x80110403:
                return "HRES_COMADMIN_E_KEYMISSING";
                break;
            case 0x80110404:
                return "HRES_COMADMIN_E_ALREADYINSTALLED";
                break;
            case 0x80110407:
                return "HRES_COMADMIN_E_APP_FILE_WRITEFAIL";
                break;
            case 0x80110408:
                return "HRES_COMADMIN_E_APP_FILE_READFAIL";
                break;
            case 0x80110409:
                return "HRES_COMADMIN_E_APP_FILE_VERSION";
                break;
            case 0x8011040A:
                return "HRES_COMADMIN_E_BADPATH";
                break;
            case 0x8011040B:
                return "HRES_COMADMIN_E_APPLICATIONEXISTS";
                break;
            case 0x8011040C:
                return "HRES_COMADMIN_E_ROLEEXISTS";
                break;
            case 0x8011040D:
                return "HRES_COMADMIN_E_CANTCOPYFILE";
                break;
            case 0x8011040F:
                return "HRES_COMADMIN_E_NOUSER";
                break;
            case 0x80110410:
                return "HRES_COMADMIN_E_INVALIDUSERIDS";
                break;
            case 0x80110411:
                return "HRES_COMADMIN_E_NOREGISTRYCLSID";
                break;
            case 0x80110412:
                return "HRES_COMADMIN_E_BADREGISTRYPROGID";
                break;
            case 0x80110413:
                return "HRES_COMADMIN_E_AUTHENTICATIONLEVEL";
                break;
            case 0x80110414:
                return "HRES_COMADMIN_E_USERPASSWDNOTVALID";
                break;
            case 0x80110418:
                return "HRES_COMADMIN_E_CLSIDORIIDMISMATCH";
                break;
            case 0x80110419:
                return "HRES_COMADMIN_E_REMOTEINTERFACE";
                break;
            case 0x8011041A:
                return "HRES_COMADMIN_E_DLLREGISTERSERVER";
                break;
            case 0x8011041B:
                return "HRES_COMADMIN_E_NOSERVERSHARE";
                break;
            case 0x8011041D:
                return "HRES_COMADMIN_E_DLLLOADFAILED";
                break;
            case 0x8011041E:
                return "HRES_COMADMIN_E_BADREGISTRYLIBID";
                break;
            case 0x8011041F:
                return "HRES_COMADMIN_E_APPDIRNOTFOUND";
                break;
            case 0x80110423:
                return "HRES_COMADMIN_E_REGISTRARFAILED";
                break;
            case 0x80110424:
                return "HRES_COMADMIN_E_COMPFILE_DOESNOTEXIST";
                break;
            case 0x80110425:
                return "HRES_COMADMIN_E_COMPFILE_LOADDLLFAIL";
                break;
            case 0x80110426:
                return "HRES_COMADMIN_E_COMPFILE_GETCLASSOBJ";
                break;
            case 0x80110427:
                return "HRES_COMADMIN_E_COMPFILE_CLASSNOTAVAIL";
                break;
            case 0x80110428:
                return "HRES_COMADMIN_E_COMPFILE_BADTLB";
                break;
            case 0x80110429:
                return "HRES_COMADMIN_E_COMPFILE_NOTINSTALLABLE";
                break;
            case 0x8011042A:
                return "HRES_COMADMIN_E_NOTCHANGEABLE";
                break;
            case 0x8011042B:
                return "HRES_COMADMIN_E_NOTDELETEABLE";
                break;
            case 0x8011042C:
                return "HRES_COMADMIN_E_SESSION";
                break;
            case 0x8011042D:
                return "HRES_COMADMIN_E_COMP_MOVE_LOCKED";
                break;
            case 0x8011042E:
                return "HRES_COMADMIN_E_COMP_MOVE_BAD_DEST";
                break;
            case 0x80110430:
                return "HRES_COMADMIN_E_REGISTERTLB";
                break;
            case 0x80110433:
                return "HRES_COMADMIN_E_SYSTEMAPP";
                break;
            case 0x80110434:
                return "HRES_COMADMIN_E_COMPFILE_NOREGISTRAR";
                break;
            case 0x80110435:
                return "HRES_COMADMIN_E_COREQCOMPINSTALLED";
                break;
            case 0x80110436:
                return "HRES_COMADMIN_E_SERVICENOTINSTALLED";
                break;
            case 0x80110437:
                return "HRES_COMADMIN_E_PROPERTYSAVEFAILED";
                break;
            case 0x80110438:
                return "HRES_COMADMIN_E_OBJECTEXISTS";
                break;
            case 0x80110439:
                return "HRES_COMADMIN_E_COMPONENTEXISTS";
                break;
            case 0x8011043B:
                return "HRES_COMADMIN_E_REGFILE_CORRUPT";
                break;
            case 0x8011043C:
                return "HRES_COMADMIN_E_PROPERTY_OVERFLOW";
                break;
            case 0x8011043E:
                return "HRES_COMADMIN_E_NOTINREGISTRY";
                break;
            case 0x8011043F:
                return "HRES_COMADMIN_E_OBJECTNOTPOOLABLE";
                break;
            case 0x80110446:
                return "HRES_COMADMIN_E_APPLID_MATCHES_CLSID";
                break;
            case 0x80110447:
                return "HRES_COMADMIN_E_ROLE_DOES_NOT_EXIST";
                break;
            case 0x80110448:
                return "HRES_COMADMIN_E_START_APP_NEEDS_COMPONENTS";
                break;
            case 0x80110449:
                return "HRES_COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM";
                break;
            case 0x8011044A:
                return "HRES_COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY";
                break;
            case 0x8011044B:
                return "HRES_COMADMIN_E_CAN_NOT_START_APP";
                break;
            case 0x8011044C:
                return "HRES_COMADMIN_E_CAN_NOT_EXPORT_SYS_APP";
                break;
            case 0x8011044D:
                return "HRES_COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT";
                break;
            case 0x8011044E:
                return "HRES_COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER";
                break;
            case 0x8011044F:
                return "HRES_COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE";
                break;
            case 0x80110450:
                return "HRES_COMADMIN_E_BASE_PARTITION_ONLY";
                break;
            case 0x80110451:
                return "HRES_COMADMIN_E_START_APP_DISABLED";
                break;
            case 0x80110457:
                return "HRES_COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME";
                break;
            case 0x80110458:
                return "HRES_COMADMIN_E_CAT_INVALID_PARTITION_NAME";
                break;
            case 0x80110459:
                return "HRES_COMADMIN_E_CAT_PARTITION_IN_USE";
                break;
            case 0x8011045A:
                return "HRES_COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES";
                break;
            case 0x8011045B:
                return "HRES_COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED";
                break;
            case 0x8011045C:
                return "HRES_COMADMIN_E_AMBIGUOUS_APPLICATION_NAME";
                break;
            case 0x8011045D:
                return "HRES_COMADMIN_E_AMBIGUOUS_PARTITION_NAME";
                break;
            case 0x80110472:
                return "HRES_COMADMIN_E_REGDB_NOTINITIALIZED";
                break;
            case 0x80110473:
                return "HRES_COMADMIN_E_REGDB_NOTOPEN";
                break;
            case 0x80110474:
                return "HRES_COMADMIN_E_REGDB_SYSTEMERR";
                break;
            case 0x80110475:
                return "HRES_COMADMIN_E_REGDB_ALREADYRUNNING";
                break;
            case 0x80110480:
                return "HRES_COMADMIN_E_MIG_VERSIONNOTSUPPORTED";
                break;
            case 0x80110481:
                return "HRES_COMADMIN_E_MIG_SCHEMANOTFOUND";
                break;
            case 0x80110482:
                return "HRES_COMADMIN_E_CAT_BITNESSMISMATCH";
                break;
            case 0x80110483:
                return "HRES_COMADMIN_E_CAT_UNACCEPTABLEBITNESS";
                break;
            case 0x80110484:
                return "HRES_COMADMIN_E_CAT_WRONGAPPBITNESS";
                break;
            case 0x80110485:
                return "HRES_COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED";
                break;
            case 0x80110486:
                return "HRES_COMADMIN_E_CAT_SERVERFAULT";
                break;
            case 0x80110600:
                return "HRES_COMQC_E_APPLICATION_NOT_QUEUED";
                break;
            case 0x80110601:
                return "HRES_COMQC_E_NO_QUEUEABLE_INTERFACES";
                break;
            case 0x80110602:
                return "HRES_COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE";
                break;
            case 0x80110603:
                return "HRES_COMQC_E_NO_IPERSISTSTREAM";
                break;
            case 0x80110604:
                return "HRES_COMQC_E_BAD_MESSAGE";
                break;
            case 0x80110605:
                return "HRES_COMQC_E_UNAUTHENTICATED";
                break;
            case 0x80110606:
                return "HRES_COMQC_E_UNTRUSTED_ENQUEUER";
                break;
            case 0x80110701:
                return "HRES_MSDTC_E_DUPLICATE_RESOURCE";
                break;
            case 0x80110808:
                return "HRES_COMADMIN_E_OBJECT_PARENT_MISSING";
                break;
            case 0x80110809:
                return "HRES_COMADMIN_E_OBJECT_DOES_NOT_EXIST";
                break;
            case 0x8011080A:
                return "HRES_COMADMIN_E_APP_NOT_RUNNING";
                break;
            case 0x8011080B:
                return "HRES_COMADMIN_E_INVALID_PARTITION";
                break;
            case 0x8011080D:
                return "HRES_COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE";
                break;
            case 0x8011080E:
                return "HRES_COMADMIN_E_USER_IN_SET";
                break;
            case 0x8011080F:
                return "HRES_COMADMIN_E_CANTRECYCLELIBRARYAPPS";
                break;
            case 0x80110811:
                return "HRES_COMADMIN_E_CANTRECYCLESERVICEAPPS";
                break;
            case 0x80110812:
                return "HRES_COMADMIN_E_PROCESSALREADYRECYCLED";
                break;
            case 0x80110813:
                return "HRES_COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED";
                break;
            case 0x80110814:
                return "HRES_COMADMIN_E_CANTMAKEINPROCSERVICE";
                break;
            case 0x80110815:
                return "HRES_COMADMIN_E_PROGIDINUSEBYCLSID";
                break;
            case 0x80110816:
                return "HRES_COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET";
                break;
            case 0x80110817:
                return "HRES_COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED";
                break;
            case 0x80110818:
                return "HRES_COMADMIN_E_PARTITION_ACCESSDENIED";
                break;
            case 0x80110819:
                return "HRES_COMADMIN_E_PARTITION_MSI_ONLY";
                break;
            case 0x8011081A:
                return "HRES_COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT";
                break;
            case 0x8011081B:
                return "HRES_COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS";
                break;
            case 0x8011081C:
                return "HRES_COMADMIN_E_COMP_MOVE_SOURCE";
                break;
            case 0x8011081D:
                return "HRES_COMADMIN_E_COMP_MOVE_DEST";
                break;
            case 0x8011081E:
                return "HRES_COMADMIN_E_COMP_MOVE_PRIVATE";
                break;
            case 0x8011081F:
                return "HRES_COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET";
                break;
            case 0x80110820:
                return "HRES_COMADMIN_E_CANNOT_ALIAS_EVENTCLASS";
                break;
            case 0x80110821:
                return "HRES_COMADMIN_E_PRIVATE_ACCESSDENIED";
                break;
            case 0x80110822:
                return "HRES_COMADMIN_E_SAFERINVALID";
                break;
            case 0x80110823:
                return "HRES_COMADMIN_E_REGISTRY_ACCESSDENIED";
                break;
            case 0x80110824:
                return "HRES_COMADMIN_E_PARTITIONS_DISABLED";
                break;
            case 0x801F0001:
                return "HRES_ERROR_FLT_NO_HANDLER_DEFINED";
                break;
            case 0x801F0002:
                return "HRES_ERROR_FLT_CONTEXT_ALREADY_DEFINED";
                break;
            case 0x801F0003:
                return "HRES_ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST";
                break;
            case 0x801F0004:
                return "HRES_ERROR_FLT_DISALLOW_FAST_IO";
                break;
            case 0x801F0005:
                return "HRES_ERROR_FLT_INVALID_NAME_REQUEST";
                break;
            case 0x801F0006:
                return "HRES_ERROR_FLT_NOT_SAFE_TO_POST_OPERATION";
                break;
            case 0x801F0007:
                return "HRES_ERROR_FLT_NOT_INITIALIZED";
                break;
            case 0x801F0008:
                return "HRES_ERROR_FLT_FILTER_NOT_READY";
                break;
            case 0x801F0009:
                return "HRES_ERROR_FLT_POST_OPERATION_CLEANUP";
                break;
            case 0x801F000A:
                return "HRES_ERROR_FLT_INTERNAL_ERROR";
                break;
            case 0x801F000B:
                return "HRES_ERROR_FLT_DELETING_OBJECT";
                break;
            case 0x801F000C:
                return "HRES_ERROR_FLT_MUST_BE_NONPAGED_POOL";
                break;
            case 0x801F000D:
                return "HRES_ERROR_FLT_DUPLICATE_ENTRY";
                break;
            case 0x801F000E:
                return "HRES_ERROR_FLT_CBDQ_DISABLED";
                break;
            case 0x801F000F:
                return "HRES_ERROR_FLT_DO_NOT_ATTACH";
                break;
            case 0x801F0010:
                return "HRES_ERROR_FLT_DO_NOT_DETACH";
                break;
            case 0x801F0011:
                return "HRES_ERROR_FLT_INSTANCE_ALTITUDE_COLLISION";
                break;
            case 0x801F0012:
                return "HRES_ERROR_FLT_INSTANCE_NAME_COLLISION";
                break;
            case 0x801F0013:
                return "HRES_ERROR_FLT_FILTER_NOT_FOUND";
                break;
            case 0x801F0014:
                return "HRES_ERROR_FLT_VOLUME_NOT_FOUND";
                break;
            case 0x801F0015:
                return "HRES_ERROR_FLT_INSTANCE_NOT_FOUND";
                break;
            case 0x801F0016:
                return "HRES_ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND";
                break;
            case 0x801F0017:
                return "HRES_ERROR_FLT_INVALID_CONTEXT_REGISTRATION";
                break;
            case 0x801F0018:
                return "HRES_ERROR_FLT_NAME_CACHE_MISS";
                break;
            case 0x801F0019:
                return "HRES_ERROR_FLT_NO_DEVICE_OBJECT";
                break;
            case 0x801F001A:
                return "HRES_ERROR_FLT_VOLUME_ALREADY_MOUNTED";
                break;
            case 0x801F001B:
                return "HRES_ERROR_FLT_ALREADY_ENLISTED";
                break;
            case 0x801F001C:
                return "HRES_ERROR_FLT_CONTEXT_ALREADY_LINKED";
                break;
            case 0x801F0020:
                return "HRES_ERROR_FLT_NO_WAITER_FOR_REPLY";
                break;
            case 0x80260001:
                return "HRES_ERROR_HUNG_DISPLAY_DRIVER_THREAD";
                break;
            case 0x80261001:
                return "HRES_ERROR_MONITOR_NO_DESCRIPTOR";
                break;
            case 0x80261002:
                return "HRES_ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT";
                break;
            case 0x80263001:
                return "HRES_DWM_E_COMPOSITIONDISABLED";
                break;
            case 0x80263002:
                return "HRES_DWM_E_REMOTING_NOT_SUPPORTED";
                break;
            case 0x80263003:
                return "HRES_DWM_E_NO_REDIRECTION_SURFACE_AVAILABLE";
                break;
            case 0x80263004:
                return "HRES_DWM_E_NOT_QUEUING_PRESENTS";
                break;
            case 0x80280000:
                return "HRES_TPM_E_ERROR_MASK";
                break;
            case 0x80280001:
                return "HRES_TPM_E_AUTHFAIL";
                break;
            case 0x80280002:
                return "HRES_TPM_E_BADINDEX";
                break;
            case 0x80280003:
                return "HRES_TPM_E_BAD_PARAMETER";
                break;
            case 0x80280004:
                return "HRES_TPM_E_AUDITFAILURE";
                break;
            case 0x80280005:
                return "HRES_TPM_E_CLEAR_DISABLED";
                break;
            case 0x80280006:
                return "HRES_TPM_E_DEACTIVATED";
                break;
            case 0x80280007:
                return "HRES_TPM_E_DISABLED";
                break;
            case 0x80280008:
                return "HRES_TPM_E_DISABLED_CMD";
                break;
            case 0x80280009:
                return "HRES_TPM_E_FAIL";
                break;
            case 0x8028000A:
                return "HRES_TPM_E_BAD_ORDINAL";
                break;
            case 0x8028000B:
                return "HRES_TPM_E_INSTALL_DISABLED";
                break;
            case 0x8028000C:
                return "HRES_TPM_E_INVALID_KEYHANDLE";
                break;
            case 0x8028000D:
                return "HRES_TPM_E_KEYNOTFOUND";
                break;
            case 0x8028000E:
                return "HRES_TPM_E_INAPPROPRIATE_ENC";
                break;
            case 0x8028000F:
                return "HRES_TPM_E_MIGRATEFAIL";
                break;
            case 0x80280010:
                return "HRES_TPM_E_INVALID_PCR_INFO";
                break;
            case 0x80280011:
                return "HRES_TPM_E_NOSPACE";
                break;
            case 0x80280012:
                return "HRES_TPM_E_NOSRK";
                break;
            case 0x80280013:
                return "HRES_TPM_E_NOTSEALED_BLOB";
                break;
            case 0x80280014:
                return "HRES_TPM_E_OWNER_SET";
                break;
            case 0x80280015:
                return "HRES_TPM_E_RESOURCES";
                break;
            case 0x80280016:
                return "HRES_TPM_E_SHORTRANDOM";
                break;
            case 0x80280017:
                return "HRES_TPM_E_SIZE";
                break;
            case 0x80280018:
                return "HRES_TPM_E_WRONGPCRVAL";
                break;
            case 0x80280019:
                return "HRES_TPM_E_BAD_PARAM_SIZE";
                break;
            case 0x8028001A:
                return "HRES_TPM_E_SHA_THREAD";
                break;
            case 0x8028001B:
                return "HRES_TPM_E_SHA_ERROR";
                break;
            case 0x8028001C:
                return "HRES_TPM_E_FAILEDSELFTEST";
                break;
            case 0x8028001D:
                return "HRES_TPM_E_AUTH2FAIL";
                break;
            case 0x8028001E:
                return "HRES_TPM_E_BADTAG";
                break;
            case 0x8028001F:
                return "HRES_TPM_E_IOERROR";
                break;
            case 0x80280020:
                return "HRES_TPM_E_ENCRYPT_ERROR";
                break;
            case 0x80280021:
                return "HRES_TPM_E_DECRYPT_ERROR";
                break;
            case 0x80280022:
                return "HRES_TPM_E_INVALID_AUTHHANDLE";
                break;
            case 0x80280023:
                return "HRES_TPM_E_NO_ENDORSEMENT";
                break;
            case 0x80280024:
                return "HRES_TPM_E_INVALID_KEYUSAGE";
                break;
            case 0x80280025:
                return "HRES_TPM_E_WRONG_ENTITYTYPE";
                break;
            case 0x80280026:
                return "HRES_TPM_E_INVALID_POSTINIT";
                break;
            case 0x80280027:
                return "HRES_TPM_E_INAPPROPRIATE_SIG";
                break;
            case 0x80280028:
                return "HRES_TPM_E_BAD_KEY_PROPERTY";
                break;
            case 0x80280029:
                return "HRES_TPM_E_BAD_MIGRATION";
                break;
            case 0x8028002A:
                return "HRES_TPM_E_BAD_SCHEME";
                break;
            case 0x8028002B:
                return "HRES_TPM_E_BAD_DATASIZE";
                break;
            case 0x8028002C:
                return "HRES_TPM_E_BAD_MODE";
                break;
            case 0x8028002D:
                return "HRES_TPM_E_BAD_PRESENCE";
                break;
            case 0x8028002E:
                return "HRES_TPM_E_BAD_VERSION";
                break;
            case 0x8028002F:
                return "HRES_TPM_E_NO_WRAP_TRANSPORT";
                break;
            case 0x80280030:
                return "HRES_TPM_E_AUDITFAIL_UNSUCCESSFUL";
                break;
            case 0x80280031:
                return "HRES_TPM_E_AUDITFAIL_SUCCESSFUL";
                break;
            case 0x80280032:
                return "HRES_TPM_E_NOTRESETABLE";
                break;
            case 0x80280033:
                return "HRES_TPM_E_NOTLOCAL";
                break;
            case 0x80280034:
                return "HRES_TPM_E_BAD_TYPE";
                break;
            case 0x80280035:
                return "HRES_TPM_E_INVALID_RESOURCE";
                break;
            case 0x80280036:
                return "HRES_TPM_E_NOTFIPS";
                break;
            case 0x80280037:
                return "HRES_TPM_E_INVALID_FAMILY";
                break;
            case 0x80280038:
                return "HRES_TPM_E_NO_NV_PERMISSION";
                break;
            case 0x80280039:
                return "HRES_TPM_E_REQUIRES_SIGN";
                break;
            case 0x8028003A:
                return "HRES_TPM_E_KEY_NOTSUPPORTED";
                break;
            case 0x8028003B:
                return "HRES_TPM_E_AUTH_CONFLICT";
                break;
            case 0x8028003C:
                return "HRES_TPM_E_AREA_LOCKED";
                break;
            case 0x8028003D:
                return "HRES_TPM_E_BAD_LOCALITY";
                break;
            case 0x8028003E:
                return "HRES_TPM_E_READ_ONLY";
                break;
            case 0x8028003F:
                return "HRES_TPM_E_PER_NOWRITE";
                break;
            case 0x80280040:
                return "HRES_TPM_E_FAMILYCOUNT";
                break;
            case 0x80280041:
                return "HRES_TPM_E_WRITE_LOCKED";
                break;
            case 0x80280042:
                return "HRES_TPM_E_BAD_ATTRIBUTES";
                break;
            case 0x80280043:
                return "HRES_TPM_E_INVALID_STRUCTURE";
                break;
            case 0x80280044:
                return "HRES_TPM_E_KEY_OWNER_CONTROL";
                break;
            case 0x80280045:
                return "HRES_TPM_E_BAD_COUNTER";
                break;
            case 0x80280046:
                return "HRES_TPM_E_NOT_FULLWRITE";
                break;
            case 0x80280047:
                return "HRES_TPM_E_CONTEXT_GAP";
                break;
            case 0x80280048:
                return "HRES_TPM_E_MAXNVWRITES";
                break;
            case 0x80280049:
                return "HRES_TPM_E_NOOPERATOR";
                break;
            case 0x8028004A:
                return "HRES_TPM_E_RESOURCEMISSING";
                break;
            case 0x8028004B:
                return "HRES_TPM_E_DELEGATE_LOCK";
                break;
            case 0x8028004C:
                return "HRES_TPM_E_DELEGATE_FAMILY";
                break;
            case 0x8028004D:
                return "HRES_TPM_E_DELEGATE_ADMIN";
                break;
            case 0x8028004E:
                return "HRES_TPM_E_TRANSPORT_NOTEXCLUSIVE";
                break;
            case 0x8028004F:
                return "HRES_TPM_E_OWNER_CONTROL";
                break;
            case 0x80280050:
                return "HRES_TPM_E_DAA_RESOURCES";
                break;
            case 0x80280051:
                return "HRES_TPM_E_DAA_INPUT_DATA0";
                break;
            case 0x80280052:
                return "HRES_TPM_E_DAA_INPUT_DATA1";
                break;
            case 0x80280053:
                return "HRES_TPM_E_DAA_ISSUER_SETTINGS";
                break;
            case 0x80280054:
                return "HRES_TPM_E_DAA_TPM_SETTINGS";
                break;
            case 0x80280055:
                return "HRES_TPM_E_DAA_STAGE";
                break;
            case 0x80280056:
                return "HRES_TPM_E_DAA_ISSUER_VALIDITY";
                break;
            case 0x80280057:
                return "HRES_TPM_E_DAA_WRONG_W";
                break;
            case 0x80280058:
                return "HRES_TPM_E_BAD_HANDLE";
                break;
            case 0x80280059:
                return "HRES_TPM_E_BAD_DELEGATE";
                break;
            case 0x8028005A:
                return "HRES_TPM_E_BADCONTEXT";
                break;
            case 0x8028005B:
                return "HRES_TPM_E_TOOMANYCONTEXTS";
                break;
            case 0x8028005C:
                return "HRES_TPM_E_MA_TICKET_SIGNATURE";
                break;
            case 0x8028005D:
                return "HRES_TPM_E_MA_DESTINATION";
                break;
            case 0x8028005E:
                return "HRES_TPM_E_MA_SOURCE";
                break;
            case 0x8028005F:
                return "HRES_TPM_E_MA_AUTHORITY";
                break;
            case 0x80280061:
                return "HRES_TPM_E_PERMANENTEK";
                break;
            case 0x80280062:
                return "HRES_TPM_E_BAD_SIGNATURE";
                break;
            case 0x80280063:
                return "HRES_TPM_E_NOCONTEXTSPACE";
                break;
            case 0x80280400:
                return "HRES_TPM_E_COMMAND_BLOCKED";
                break;
            case 0x80280401:
                return "HRES_TPM_E_INVALID_HANDLE";
                break;
            case 0x80280402:
                return "HRES_TPM_E_DUPLICATE_VHANDLE";
                break;
            case 0x80280403:
                return "HRES_TPM_E_EMBEDDED_COMMAND_BLOCKED";
                break;
            case 0x80280404:
                return "HRES_TPM_E_EMBEDDED_COMMAND_UNSUPPORTED";
                break;
            case 0x80280800:
                return "HRES_TPM_E_RETRY";
                break;
            case 0x80280801:
                return "HRES_TPM_E_NEEDS_SELFTEST";
                break;
            case 0x80280802:
                return "HRES_TPM_E_DOING_SELFTEST";
                break;
            case 0x80280803:
                return "HRES_TPM_E_DEFEND_LOCK_RUNNING";
                break;
            case 0x80284001:
                return "HRES_TBS_E_INTERNAL_ERROR";
                break;
            case 0x80284002:
                return "HRES_TBS_E_BAD_PARAMETER";
                break;
            case 0x80284003:
                return "HRES_TBS_E_INVALID_OUTPUT_POINTER";
                break;
            case 0x80284004:
                return "HRES_TBS_E_INVALID_CONTEXT";
                break;
            case 0x80284005:
                return "HRES_TBS_E_INSUFFICIENT_BUFFER";
                break;
            case 0x80284006:
                return "HRES_TBS_E_IOERROR";
                break;
            case 0x80284007:
                return "HRES_TBS_E_INVALID_CONTEXT_PARAM";
                break;
            case 0x80284008:
                return "HRES_TBS_E_SERVICE_NOT_RUNNING";
                break;
            case 0x80284009:
                return "HRES_TBS_E_TOO_MANY_TBS_CONTEXTS";
                break;
            case 0x8028400A:
                return "HRES_TBS_E_TOO_MANY_RESOURCES";
                break;
            case 0x8028400B:
                return "HRES_TBS_E_SERVICE_START_PENDING";
                break;
            case 0x8028400C:
                return "HRES_TBS_E_PPI_NOT_SUPPORTED";
                break;
            case 0x8028400D:
                return "HRES_TBS_E_COMMAND_CANCELED";
                break;
            case 0x8028400E:
                return "HRES_TBS_E_BUFFER_TOO_LARGE";
                break;
            case 0x80290100:
                return "HRES_TPMAPI_E_INVALID_STATE";
                break;
            case 0x80290101:
                return "HRES_TPMAPI_E_NOT_ENOUGH_DATA";
                break;
            case 0x80290102:
                return "HRES_TPMAPI_E_TOO_MUCH_DATA";
                break;
            case 0x80290103:
                return "HRES_TPMAPI_E_INVALID_OUTPUT_POINTER";
                break;
            case 0x80290104:
                return "HRES_TPMAPI_E_INVALID_PARAMETER";
                break;
            case 0x80290105:
                return "HRES_TPMAPI_E_OUT_OF_MEMORY";
                break;
            case 0x80290106:
                return "HRES_TPMAPI_E_BUFFER_TOO_SMALL";
                break;
            case 0x80290107:
                return "HRES_TPMAPI_E_INTERNAL_ERROR";
                break;
            case 0x80290108:
                return "HRES_TPMAPI_E_ACCESS_DENIED";
                break;
            case 0x80290109:
                return "HRES_TPMAPI_E_AUTHORIZATION_FAILED";
                break;
            case 0x8029010A:
                return "HRES_TPMAPI_E_INVALID_CONTEXT_HANDLE";
                break;
            case 0x8029010B:
                return "HRES_TPMAPI_E_TBS_COMMUNICATION_ERROR";
                break;
            case 0x8029010C:
                return "HRES_TPMAPI_E_TPM_COMMAND_ERROR";
                break;
            case 0x8029010D:
                return "HRES_TPMAPI_E_MESSAGE_TOO_LARGE";
                break;
            case 0x8029010E:
                return "HRES_TPMAPI_E_INVALID_ENCODING";
                break;
            case 0x8029010F:
                return "HRES_TPMAPI_E_INVALID_KEY_SIZE";
                break;
            case 0x80290110:
                return "HRES_TPMAPI_E_ENCRYPTION_FAILED";
                break;
            case 0x80290111:
                return "HRES_TPMAPI_E_INVALID_KEY_PARAMS";
                break;
            case 0x80290112:
                return "HRES_TPMAPI_E_INVALID_MIGRATION_AUTHORIZATION_BLOB";
                break;
            case 0x80290113:
                return "HRES_TPMAPI_E_INVALID_PCR_INDEX";
                break;
            case 0x80290114:
                return "HRES_TPMAPI_E_INVALID_DELEGATE_BLOB";
                break;
            case 0x80290115:
                return "HRES_TPMAPI_E_INVALID_CONTEXT_PARAMS";
                break;
            case 0x80290116:
                return "HRES_TPMAPI_E_INVALID_KEY_BLOB";
                break;
            case 0x80290117:
                return "HRES_TPMAPI_E_INVALID_PCR_DATA";
                break;
            case 0x80290118:
                return "HRES_TPMAPI_E_INVALID_OWNER_AUTH";
                break;
            case 0x80290200:
                return "HRES_TBSIMP_E_BUFFER_TOO_SMALL";
                break;
            case 0x80290201:
                return "HRES_TBSIMP_E_CLEANUP_FAILED";
                break;
            case 0x80290202:
                return "HRES_TBSIMP_E_INVALID_CONTEXT_HANDLE";
                break;
            case 0x80290203:
                return "HRES_TBSIMP_E_INVALID_CONTEXT_PARAM";
                break;
            case 0x80290204:
                return "HRES_TBSIMP_E_TPM_ERROR";
                break;
            case 0x80290205:
                return "HRES_TBSIMP_E_HASH_BAD_KEY";
                break;
            case 0x80290206:
                return "HRES_TBSIMP_E_DUPLICATE_VHANDLE";
                break;
            case 0x80290207:
                return "HRES_TBSIMP_E_INVALID_OUTPUT_POINTER";
                break;
            case 0x80290208:
                return "HRES_TBSIMP_E_INVALID_PARAMETER";
                break;
            case 0x80290209:
                return "HRES_TBSIMP_E_RPC_INIT_FAILED";
                break;
            case 0x8029020A:
                return "HRES_TBSIMP_E_SCHEDULER_NOT_RUNNING";
                break;
            case 0x8029020B:
                return "HRES_TBSIMP_E_COMMAND_CANCELED";
                break;
            case 0x8029020C:
                return "HRES_TBSIMP_E_OUT_OF_MEMORY";
                break;
            case 0x8029020D:
                return "HRES_TBSIMP_E_LIST_NO_MORE_ITEMS";
                break;
            case 0x8029020E:
                return "HRES_TBSIMP_E_LIST_NOT_FOUND";
                break;
            case 0x8029020F:
                return "HRES_TBSIMP_E_NOT_ENOUGH_SPACE";
                break;
            case 0x80290210:
                return "HRES_TBSIMP_E_NOT_ENOUGH_TPM_CONTEXTS";
                break;
            case 0x80290211:
                return "HRES_TBSIMP_E_COMMAND_FAILED";
                break;
            case 0x80290212:
                return "HRES_TBSIMP_E_UNKNOWN_ORDINAL";
                break;
            case 0x80290213:
                return "HRES_TBSIMP_E_RESOURCE_EXPIRED";
                break;
            case 0x80290214:
                return "HRES_TBSIMP_E_INVALID_RESOURCE";
                break;
            case 0x80290215:
                return "HRES_TBSIMP_E_NOTHING_TO_UNLOAD";
                break;
            case 0x80290216:
                return "HRES_TBSIMP_E_HASH_TABLE_FULL";
                break;
            case 0x80290217:
                return "HRES_TBSIMP_E_TOO_MANY_TBS_CONTEXTS";
                break;
            case 0x80290218:
                return "HRES_TBSIMP_E_TOO_MANY_RESOURCES";
                break;
            case 0x80290219:
                return "HRES_TBSIMP_E_PPI_NOT_SUPPORTED";
                break;
            case 0x8029021A:
                return "HRES_TBSIMP_E_TPM_INCOMPATIBLE";
                break;
            case 0x80290300:
                return "HRES_TPM_E_PPI_ACPI_FAILURE";
                break;
            case 0x80290301:
                return "HRES_TPM_E_PPI_USER_ABORT";
                break;
            case 0x80290302:
                return "HRES_TPM_E_PPI_BIOS_FAILURE";
                break;
            case 0x80290303:
                return "HRES_TPM_E_PPI_NOT_SUPPORTED";
                break;
            case 0x80300002:
                return "HRES_PLA_E_DCS_NOT_FOUND";
                break;
            case 0x80300045:
                return "HRES_PLA_E_TOO_MANY_FOLDERS";
                break;
            case 0x80300070:
                return "HRES_PLA_E_NO_MIN_DISK";
                break;
            case 0x803000AA:
                return "HRES_PLA_E_DCS_IN_USE";
                break;
            case 0x803000B7:
                return "HRES_PLA_E_DCS_ALREADY_EXISTS";
                break;
            case 0x80300101:
                return "HRES_PLA_E_PROPERTY_CONFLICT";
                break;
            case 0x80300102:
                return "HRES_PLA_E_DCS_SINGLETON_REQUIRED";
                break;
            case 0x80300103:
                return "HRES_PLA_E_CREDENTIALS_REQUIRED";
                break;
            case 0x80300104:
                return "HRES_PLA_E_DCS_NOT_RUNNING";
                break;
            case 0x80300105:
                return "HRES_PLA_E_CONFLICT_INCL_EXCL_API";
                break;
            case 0x80300106:
                return "HRES_PLA_E_NETWORK_EXE_NOT_VALID";
                break;
            case 0x80300107:
                return "HRES_PLA_E_EXE_ALREADY_CONFIGURED";
                break;
            case 0x80300108:
                return "HRES_PLA_E_EXE_PATH_NOT_VALID";
                break;
            case 0x80300109:
                return "HRES_PLA_E_DC_ALREADY_EXISTS";
                break;
            case 0x8030010A:
                return "HRES_PLA_E_DCS_START_WAIT_TIMEOUT";
                break;
            case 0x8030010B:
                return "HRES_PLA_E_DC_START_WAIT_TIMEOUT";
                break;
            case 0x8030010C:
                return "HRES_PLA_E_REPORT_WAIT_TIMEOUT";
                break;
            case 0x8030010D:
                return "HRES_PLA_E_NO_DUPLICATES";
                break;
            case 0x8030010E:
                return "HRES_PLA_E_EXE_FULL_PATH_REQUIRED";
                break;
            case 0x8030010F:
                return "HRES_PLA_E_INVALID_SESSION_NAME";
                break;
            case 0x80300110:
                return "HRES_PLA_E_PLA_CHANNEL_NOT_ENABLED";
                break;
            case 0x80300111:
                return "HRES_PLA_E_TASKSCHED_CHANNEL_NOT_ENABLED";
                break;
            case 0x80310000:
                return "HRES_FVE_E_LOCKED_VOLUME";
                break;
            case 0x80310001:
                return "HRES_FVE_E_NOT_ENCRYPTED";
                break;
            case 0x80310002:
                return "HRES_FVE_E_NO_TPM_BIOS";
                break;
            case 0x80310003:
                return "HRES_FVE_E_NO_MBR_METRIC";
                break;
            case 0x80310004:
                return "HRES_FVE_E_NO_BOOTSECTOR_METRIC";
                break;
            case 0x80310005:
                return "HRES_FVE_E_NO_BOOTMGR_METRIC";
                break;
            case 0x80310006:
                return "HRES_FVE_E_WRONG_BOOTMGR";
                break;
            case 0x80310007:
                return "HRES_FVE_E_SECURE_KEY_REQUIRED";
                break;
            case 0x80310008:
                return "HRES_FVE_E_NOT_ACTIVATED";
                break;
            case 0x80310009:
                return "HRES_FVE_E_ACTION_NOT_ALLOWED";
                break;
            case 0x8031000A:
                return "HRES_FVE_E_AD_SCHEMA_NOT_INSTALLED";
                break;
            case 0x8031000B:
                return "HRES_FVE_E_AD_INVALID_DATATYPE";
                break;
            case 0x8031000C:
                return "HRES_FVE_E_AD_INVALID_DATASIZE";
                break;
            case 0x8031000D:
                return "HRES_FVE_E_AD_NO_VALUES";
                break;
            case 0x8031000E:
                return "HRES_FVE_E_AD_ATTR_NOT_SET";
                break;
            case 0x8031000F:
                return "HRES_FVE_E_AD_GUID_NOT_FOUND";
                break;
            case 0x80310010:
                return "HRES_FVE_E_BAD_INFORMATION";
                break;
            case 0x80310011:
                return "HRES_FVE_E_TOO_SMALL";
                break;
            case 0x80310012:
                return "HRES_FVE_E_SYSTEM_VOLUME";
                break;
            case 0x80310013:
                return "HRES_FVE_E_FAILED_WRONG_FS";
                break;
            case 0x80310014:
                return "HRES_FVE_E_FAILED_BAD_FS";
                break;
            case 0x80310015:
                return "HRES_FVE_E_NOT_SUPPORTED";
                break;
            case 0x80310016:
                return "HRES_FVE_E_BAD_DATA";
                break;
            case 0x80310017:
                return "HRES_FVE_E_VOLUME_NOT_BOUND";
                break;
            case 0x80310018:
                return "HRES_FVE_E_TPM_NOT_OWNED";
                break;
            case 0x80310019:
                return "HRES_FVE_E_NOT_DATA_VOLUME";
                break;
            case 0x8031001A:
                return "HRES_FVE_E_AD_INSUFFICIENT_BUFFER";
                break;
            case 0x8031001B:
                return "HRES_FVE_E_CONV_READ";
                break;
            case 0x8031001C:
                return "HRES_FVE_E_CONV_WRITE";
                break;
            case 0x8031001D:
                return "HRES_FVE_E_KEY_REQUIRED";
                break;
            case 0x8031001E:
                return "HRES_FVE_E_CLUSTERING_NOT_SUPPORTED";
                break;
            case 0x8031001F:
                return "HRES_FVE_E_VOLUME_BOUND_ALREADY";
                break;
            case 0x80310020:
                return "HRES_FVE_E_OS_NOT_PROTECTED";
                break;
            case 0x80310021:
                return "HRES_FVE_E_PROTECTION_DISABLED";
                break;
            case 0x80310022:
                return "HRES_FVE_E_RECOVERY_KEY_REQUIRED";
                break;
            case 0x80310023:
                return "HRES_FVE_E_FOREIGN_VOLUME";
                break;
            case 0x80310024:
                return "HRES_FVE_E_OVERLAPPED_UPDATE";
                break;
            case 0x80310025:
                return "HRES_FVE_E_TPM_SRK_AUTH_NOT_ZERO";
                break;
            case 0x80310026:
                return "HRES_FVE_E_FAILED_SECTOR_SIZE";
                break;
            case 0x80310027:
                return "HRES_FVE_E_FAILED_AUTHENTICATION";
                break;
            case 0x80310028:
                return "HRES_FVE_E_NOT_OS_VOLUME";
                break;
            case 0x80310029:
                return "HRES_FVE_E_AUTOUNLOCK_ENABLED";
                break;
            case 0x8031002A:
                return "HRES_FVE_E_WRONG_BOOTSECTOR";
                break;
            case 0x8031002B:
                return "HRES_FVE_E_WRONG_SYSTEM_FS";
                break;
            case 0x8031002C:
                return "HRES_FVE_E_POLICY_PASSWORD_REQUIRED";
                break;
            case 0x8031002D:
                return "HRES_FVE_E_CANNOT_SET_FVEK_ENCRYPTED";
                break;
            case 0x8031002E:
                return "HRES_FVE_E_CANNOT_ENCRYPT_NO_KEY";
                break;
            case 0x80310030:
                return "HRES_FVE_E_BOOTABLE_CDDVD";
                break;
            case 0x80310031:
                return "HRES_FVE_E_PROTECTOR_EXISTS";
                break;
            case 0x80310032:
                return "HRES_FVE_E_RELATIVE_PATH";
                break;
            case 0x80320001:
                return "HRES_FWP_E_CALLOUT_NOT_FOUND";
                break;
            case 0x80320002:
                return "HRES_FWP_E_CONDITION_NOT_FOUND";
                break;
            case 0x80320003:
                return "HRES_FWP_E_FILTER_NOT_FOUND";
                break;
            case 0x80320004:
                return "HRES_FWP_E_LAYER_NOT_FOUND";
                break;
            case 0x80320005:
                return "HRES_FWP_E_PROVIDER_NOT_FOUND";
                break;
            case 0x80320006:
                return "HRES_FWP_E_PROVIDER_CONTEXT_NOT_FOUND";
                break;
            case 0x80320007:
                return "HRES_FWP_E_SUBLAYER_NOT_FOUND";
                break;
            case 0x80320008:
                return "HRES_FWP_E_NOT_FOUND";
                break;
            case 0x80320009:
                return "HRES_FWP_E_ALREADY_EXISTS";
                break;
            case 0x8032000A:
                return "HRES_FWP_E_IN_USE";
                break;
            case 0x8032000B:
                return "HRES_FWP_E_DYNAMIC_SESSION_IN_PROGRESS";
                break;
            case 0x8032000C:
                return "HRES_FWP_E_WRONG_SESSION";
                break;
            case 0x8032000D:
                return "HRES_FWP_E_NO_TXN_IN_PROGRESS";
                break;
            case 0x8032000E:
                return "HRES_FWP_E_TXN_IN_PROGRESS";
                break;
            case 0x8032000F:
                return "HRES_FWP_E_TXN_ABORTED";
                break;
            case 0x80320010:
                return "HRES_FWP_E_SESSION_ABORTED";
                break;
            case 0x80320011:
                return "HRES_FWP_E_INCOMPATIBLE_TXN";
                break;
            case 0x80320012:
                return "HRES_FWP_E_TIMEOUT";
                break;
            case 0x80320013:
                return "HRES_FWP_E_NET_EVENTS_DISABLED";
                break;
            case 0x80320014:
                return "HRES_FWP_E_INCOMPATIBLE_LAYER";
                break;
            case 0x80320015:
                return "HRES_FWP_E_KM_CLIENTS_ONLY";
                break;
            case 0x80320016:
                return "HRES_FWP_E_LIFETIME_MISMATCH";
                break;
            case 0x80320017:
                return "HRES_FWP_E_BUILTIN_OBJECT";
                break;
            case 0x80320018:
                return "HRES_FWP_E_TOO_MANY_BOOTTIME_FILTERS";
                break;
            case 0x80320019:
                return "HRES_FWP_E_NOTIFICATION_DROPPED";
                break;
            case 0x8032001A:
                return "HRES_FWP_E_TRAFFIC_MISMATCH";
                break;
            case 0x8032001B:
                return "HRES_FWP_E_INCOMPATIBLE_SA_STATE";
                break;
            case 0x8032001C:
                return "HRES_FWP_E_NULL_POINTER";
                break;
            case 0x8032001D:
                return "HRES_FWP_E_INVALID_ENUMERATOR";
                break;
            case 0x8032001E:
                return "HRES_FWP_E_INVALID_FLAGS";
                break;
            case 0x8032001F:
                return "HRES_FWP_E_INVALID_NET_MASK";
                break;
            case 0x80320020:
                return "HRES_FWP_E_INVALID_RANGE";
                break;
            case 0x80320021:
                return "HRES_FWP_E_INVALID_INTERVAL";
                break;
            case 0x80320022:
                return "HRES_FWP_E_ZERO_LENGTH_ARRAY";
                break;
            case 0x80320023:
                return "HRES_FWP_E_NULL_DISPLAY_NAME";
                break;
            case 0x80320024:
                return "HRES_FWP_E_INVALID_ACTION_TYPE";
                break;
            case 0x80320025:
                return "HRES_FWP_E_INVALID_WEIGHT";
                break;
            case 0x80320026:
                return "HRES_FWP_E_MATCH_TYPE_MISMATCH";
                break;
            case 0x80320027:
                return "HRES_FWP_E_TYPE_MISMATCH";
                break;
            case 0x80320028:
                return "HRES_FWP_E_OUT_OF_BOUNDS";
                break;
            case 0x80320029:
                return "HRES_FWP_E_RESERVED";
                break;
            case 0x8032002A:
                return "HRES_FWP_E_DUPLICATE_CONDITION";
                break;
            case 0x8032002B:
                return "HRES_FWP_E_DUPLICATE_KEYMOD";
                break;
            case 0x8032002C:
                return "HRES_FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER";
                break;
            case 0x8032002D:
                return "HRES_FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER";
                break;
            case 0x8032002E:
                return "HRES_FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER";
                break;
            case 0x8032002F:
                return "HRES_FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT";
                break;
            case 0x80320030:
                return "HRES_FWP_E_INCOMPATIBLE_AUTH_METHOD";
                break;
            case 0x80320031:
                return "HRES_FWP_E_INCOMPATIBLE_DH_GROUP";
                break;
            case 0x80320032:
                return "HRES_FWP_E_EM_NOT_SUPPORTED";
                break;
            case 0x80320033:
                return "HRES_FWP_E_NEVER_MATCH";
                break;
            case 0x80320034:
                return "HRES_FWP_E_PROVIDER_CONTEXT_MISMATCH";
                break;
            case 0x80320035:
                return "HRES_FWP_E_INVALID_PARAMETER";
                break;
            case 0x80320036:
                return "HRES_FWP_E_TOO_MANY_SUBLAYERS";
                break;
            case 0x80320037:
                return "HRES_FWP_E_CALLOUT_NOTIFICATION_FAILED";
                break;
            case 0x80320038:
                return "HRES_FWP_E_INCOMPATIBLE_AUTH_CONFIG";
                break;
            case 0x80320039:
                return "HRES_FWP_E_INCOMPATIBLE_CIPHER_CONFIG";
                break;
            case 0x80340002:
                return "HRES_ERROR_NDIS_INTERFACE_CLOSING";
                break;
            case 0x80340004:
                return "HRES_ERROR_NDIS_BAD_VERSION";
                break;
            case 0x80340005:
                return "HRES_ERROR_NDIS_BAD_CHARACTERISTICS";
                break;
            case 0x80340006:
                return "HRES_ERROR_NDIS_ADAPTER_NOT_FOUND";
                break;
            case 0x80340007:
                return "HRES_ERROR_NDIS_OPEN_FAILED";
                break;
            case 0x80340008:
                return "HRES_ERROR_NDIS_DEVICE_FAILED";
                break;
            case 0x80340009:
                return "HRES_ERROR_NDIS_MULTICAST_FULL";
                break;
            case 0x8034000A:
                return "HRES_ERROR_NDIS_MULTICAST_EXISTS";
                break;
            case 0x8034000B:
                return "HRES_ERROR_NDIS_MULTICAST_NOT_FOUND";
                break;
            case 0x8034000C:
                return "HRES_ERROR_NDIS_REQUEST_ABORTED";
                break;
            case 0x8034000D:
                return "HRES_ERROR_NDIS_RESET_IN_PROGRESS";
                break;
            case 0x8034000F:
                return "HRES_ERROR_NDIS_INVALID_PACKET";
                break;
            case 0x80340010:
                return "HRES_ERROR_NDIS_INVALID_DEVICE_REQUEST";
                break;
            case 0x80340011:
                return "HRES_ERROR_NDIS_ADAPTER_NOT_READY";
                break;
            case 0x80340014:
                return "HRES_ERROR_NDIS_INVALID_LENGTH";
                break;
            case 0x80340015:
                return "HRES_ERROR_NDIS_INVALID_DATA";
                break;
            case 0x80340016:
                return "HRES_ERROR_NDIS_BUFFER_TOO_SHORT";
                break;
            case 0x80340017:
                return "HRES_ERROR_NDIS_INVALID_OID";
                break;
            case 0x80340018:
                return "HRES_ERROR_NDIS_ADAPTER_REMOVED";
                break;
            case 0x80340019:
                return "HRES_ERROR_NDIS_UNSUPPORTED_MEDIA";
                break;
            case 0x8034001A:
                return "HRES_ERROR_NDIS_GROUP_ADDRESS_IN_USE";
                break;
            case 0x8034001B:
                return "HRES_ERROR_NDIS_FILE_NOT_FOUND";
                break;
            case 0x8034001C:
                return "HRES_ERROR_NDIS_ERROR_READING_FILE";
                break;
            case 0x8034001D:
                return "HRES_ERROR_NDIS_ALREADY_MAPPED";
                break;
            case 0x8034001E:
                return "HRES_ERROR_NDIS_RESOURCE_CONFLICT";
                break;
            case 0x8034001F:
                return "HRES_ERROR_NDIS_MEDIA_DISCONNECTED";
                break;
            case 0x80340022:
                return "HRES_ERROR_NDIS_INVALID_ADDRESS";
                break;
            case 0x8034002A:
                return "HRES_ERROR_NDIS_PAUSED";
                break;
            case 0x8034002B:
                return "HRES_ERROR_NDIS_INTERFACE_NOT_FOUND";
                break;
            case 0x8034002C:
                return "HRES_ERROR_NDIS_UNSUPPORTED_REVISION";
                break;
            case 0x8034002D:
                return "HRES_ERROR_NDIS_INVALID_PORT";
                break;
            case 0x8034002E:
                return "HRES_ERROR_NDIS_INVALID_PORT_STATE";
                break;
            case 0x803400BB:
                return "HRES_ERROR_NDIS_NOT_SUPPORTED";
                break;
            case 0x80342000:
                return "HRES_ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED";
                break;
            case 0x80342001:
                return "HRES_ERROR_NDIS_DOT11_MEDIA_IN_USE";
                break;
            case 0x80342002:
                return "HRES_ERROR_NDIS_DOT11_POWER_STATE_INVALID";
                break;
            case 0x8DEAD01B:
                return "HRES_TRK_E_NOT_FOUND";
                break;
            case 0x8DEAD01C:
                return "HRES_TRK_E_VOLUME_QUOTA_EXCEEDED";
                break;
            case 0x8DEAD01E:
                return "HRES_TRK_SERVER_TOO_BUSY";
                break;
            case 0xC0090001:
                return "HRES_ERROR_AUDITING_DISABLED";
                break;
            case 0xC0090002:
                return "HRES_ERROR_ALL_SIDS_FILTERED";
                break;
            case 0xC0090003:
                return "HRES_ERROR_BIZRULES_NOT_ENABLED";
                break;
            case 0xC00D0005:
                return "HRES_NS_E_NOCONNECTION";
                break;
            case 0xC00D0006:
                return "HRES_NS_E_CANNOTCONNECT";
                break;
            case 0xC00D0007:
                return "HRES_NS_E_CANNOTDESTROYTITLE";
                break;
            case 0xC00D0008:
                return "HRES_NS_E_CANNOTRENAMETITLE";
                break;
            case 0xC00D0009:
                return "HRES_NS_E_CANNOTOFFLINEDISK";
                break;
            case 0xC00D000A:
                return "HRES_NS_E_CANNOTONLINEDISK";
                break;
            case 0xC00D000B:
                return "HRES_NS_E_NOREGISTEREDWALKER";
                break;
            case 0xC00D000C:
                return "HRES_NS_E_NOFUNNEL";
                break;
            case 0xC00D000D:
                return "HRES_NS_E_NO_LOCALPLAY";
                break;
            case 0xC00D000E:
                return "HRES_NS_E_NETWORK_BUSY";
                break;
            case 0xC00D000F:
                return "HRES_NS_E_TOO_MANY_SESS";
                break;
            case 0xC00D0010:
                return "HRES_NS_E_ALREADY_CONNECTED";
                break;
            case 0xC00D0011:
                return "HRES_NS_E_INVALID_INDEX";
                break;
            case 0xC00D0012:
                return "HRES_NS_E_PROTOCOL_MISMATCH";
                break;
            case 0xC00D0013:
                return "HRES_NS_E_TIMEOUT";
                break;
            case 0xC00D0014:
                return "HRES_NS_E_NET_WRITE";
                break;
            case 0xC00D0015:
                return "HRES_NS_E_NET_READ";
                break;
            case 0xC00D0016:
                return "HRES_NS_E_DISK_WRITE";
                break;
            case 0xC00D0017:
                return "HRES_NS_E_DISK_READ";
                break;
            case 0xC00D0018:
                return "HRES_NS_E_FILE_WRITE";
                break;
            case 0xC00D0019:
                return "HRES_NS_E_FILE_READ";
                break;
            case 0xC00D001A:
                return "HRES_NS_E_FILE_NOT_FOUND";
                break;
            case 0xC00D001B:
                return "HRES_NS_E_FILE_EXISTS";
                break;
            case 0xC00D001C:
                return "HRES_NS_E_INVALID_NAME";
                break;
            case 0xC00D001D:
                return "HRES_NS_E_FILE_OPEN_FAILED";
                break;
            case 0xC00D001E:
                return "HRES_NS_E_FILE_ALLOCATION_FAILED";
                break;
            case 0xC00D001F:
                return "HRES_NS_E_FILE_INIT_FAILED";
                break;
            case 0xC00D0020:
                return "HRES_NS_E_FILE_PLAY_FAILED";
                break;
            case 0xC00D0021:
                return "HRES_NS_E_SET_DISK_UID_FAILED";
                break;
            case 0xC00D0022:
                return "HRES_NS_E_INDUCED";
                break;
            case 0xC00D0023:
                return "HRES_NS_E_CCLINK_DOWN";
                break;
            case 0xC00D0024:
                return "HRES_NS_E_INTERNAL";
                break;
            case 0xC00D0025:
                return "HRES_NS_E_BUSY";
                break;
            case 0xC00D0026:
                return "HRES_NS_E_UNRECOGNIZED_STREAM_TYPE";
                break;
            case 0xC00D0027:
                return "HRES_NS_E_NETWORK_SERVICE_FAILURE";
                break;
            case 0xC00D0028:
                return "HRES_NS_E_NETWORK_RESOURCE_FAILURE";
                break;
            case 0xC00D0029:
                return "HRES_NS_E_CONNECTION_FAILURE";
                break;
            case 0xC00D002A:
                return "HRES_NS_E_SHUTDOWN";
                break;
            case 0xC00D002B:
                return "HRES_NS_E_INVALID_REQUEST";
                break;
            case 0xC00D002C:
                return "HRES_NS_E_INSUFFICIENT_BANDWIDTH";
                break;
            case 0xC00D002D:
                return "HRES_NS_E_NOT_REBUILDING";
                break;
            case 0xC00D002E:
                return "HRES_NS_E_LATE_OPERATION";
                break;
            case 0xC00D002F:
                return "HRES_NS_E_INVALID_DATA";
                break;
            case 0xC00D0030:
                return "HRES_NS_E_FILE_BANDWIDTH_LIMIT";
                break;
            case 0xC00D0031:
                return "HRES_NS_E_OPEN_FILE_LIMIT";
                break;
            case 0xC00D0032:
                return "HRES_NS_E_BAD_CONTROL_DATA";
                break;
            case 0xC00D0033:
                return "HRES_NS_E_NO_STREAM";
                break;
            case 0xC00D0034:
                return "HRES_NS_E_STREAM_END";
                break;
            case 0xC00D0035:
                return "HRES_NS_E_SERVER_NOT_FOUND";
                break;
            case 0xC00D0036:
                return "HRES_NS_E_DUPLICATE_NAME";
                break;
            case 0xC00D0037:
                return "HRES_NS_E_DUPLICATE_ADDRESS";
                break;
            case 0xC00D0038:
                return "HRES_NS_E_BAD_MULTICAST_ADDRESS";
                break;
            case 0xC00D0039:
                return "HRES_NS_E_BAD_ADAPTER_ADDRESS";
                break;
            case 0xC00D003A:
                return "HRES_NS_E_BAD_DELIVERY_MODE";
                break;
            case 0xC00D003B:
                return "HRES_NS_E_INVALID_CHANNEL";
                break;
            case 0xC00D003C:
                return "HRES_NS_E_INVALID_STREAM";
                break;
            case 0xC00D003D:
                return "HRES_NS_E_INVALID_ARCHIVE";
                break;
            case 0xC00D003E:
                return "HRES_NS_E_NOTITLES";
                break;
            case 0xC00D003F:
                return "HRES_NS_E_INVALID_CLIENT";
                break;
            case 0xC00D0040:
                return "HRES_NS_E_INVALID_BLACKHOLE_ADDRESS";
                break;
            case 0xC00D0041:
                return "HRES_NS_E_INCOMPATIBLE_FORMAT";
                break;
            case 0xC00D0042:
                return "HRES_NS_E_INVALID_KEY";
                break;
            case 0xC00D0043:
                return "HRES_NS_E_INVALID_PORT";
                break;
            case 0xC00D0044:
                return "HRES_NS_E_INVALID_TTL";
                break;
            case 0xC00D0045:
                return "HRES_NS_E_STRIDE_REFUSED";
                break;
            case 0xC00D0046:
                return "HRES_NS_E_MMSAUTOSERVER_CANTFINDWALKER";
                break;
            case 0xC00D0047:
                return "HRES_NS_E_MAX_BITRATE";
                break;
            case 0xC00D0048:
                return "HRES_NS_E_LOGFILEPERIOD";
                break;
            case 0xC00D0049:
                return "HRES_NS_E_MAX_CLIENTS";
                break;
            case 0xC00D004A:
                return "HRES_NS_E_LOG_FILE_SIZE";
                break;
            case 0xC00D004B:
                return "HRES_NS_E_MAX_FILERATE";
                break;
            case 0xC00D004C:
                return "HRES_NS_E_WALKER_UNKNOWN";
                break;
            case 0xC00D004D:
                return "HRES_NS_E_WALKER_SERVER";
                break;
            case 0xC00D004E:
                return "HRES_NS_E_WALKER_USAGE";
                break;
            case 0xC00D0050:
                return "HRES_NS_E_TIGER_FAIL";
                break;
            case 0xC00D0053:
                return "HRES_NS_E_CUB_FAIL";
                break;
            case 0xC00D0055:
                return "HRES_NS_E_DISK_FAIL";
                break;
            case 0xC00D0060:
                return "HRES_NS_E_MAX_FUNNELS_ALERT";
                break;
            case 0xC00D0061:
                return "HRES_NS_E_ALLOCATE_FILE_FAIL";
                break;
            case 0xC00D0062:
                return "HRES_NS_E_PAGING_ERROR";
                break;
            case 0xC00D0063:
                return "HRES_NS_E_BAD_BLOCK0_VERSION";
                break;
            case 0xC00D0064:
                return "HRES_NS_E_BAD_DISK_UID";
                break;
            case 0xC00D0065:
                return "HRES_NS_E_BAD_FSMAJOR_VERSION";
                break;
            case 0xC00D0066:
                return "HRES_NS_E_BAD_STAMPNUMBER";
                break;
            case 0xC00D0067:
                return "HRES_NS_E_PARTIALLY_REBUILT_DISK";
                break;
            case 0xC00D0068:
                return "HRES_NS_E_ENACTPLAN_GIVEUP";
                break;
            case 0xC00D006A:
                return "HRES_MCMADM_E_REGKEY_NOT_FOUND";
                break;
            case 0xC00D006B:
                return "HRES_NS_E_NO_FORMATS";
                break;
            case 0xC00D006C:
                return "HRES_NS_E_NO_REFERENCES";
                break;
            case 0xC00D006D:
                return "HRES_NS_E_WAVE_OPEN";
                break;
            case 0xC00D006F:
                return "HRES_NS_E_CANNOTCONNECTEVENTS";
                break;
            case 0xC00D0071:
                return "HRES_NS_E_NO_DEVICE";
                break;
            case 0xC00D0072:
                return "HRES_NS_E_NO_SPECIFIED_DEVICE";
                break;
            case 0xC00D00C8:
                return "HRES_NS_E_MONITOR_GIVEUP";
                break;
            case 0xC00D00C9:
                return "HRES_NS_E_REMIRRORED_DISK";
                break;
            case 0xC00D00CA:
                return "HRES_NS_E_INSUFFICIENT_DATA";
                break;
            case 0xC00D00CB:
                return "HRES_NS_E_ASSERT";
                break;
            case 0xC00D00CC:
                return "HRES_NS_E_BAD_ADAPTER_NAME";
                break;
            case 0xC00D00CD:
                return "HRES_NS_E_NOT_LICENSED";
                break;
            case 0xC00D00CE:
                return "HRES_NS_E_NO_SERVER_CONTACT";
                break;
            case 0xC00D00CF:
                return "HRES_NS_E_TOO_MANY_TITLES";
                break;
            case 0xC00D00D0:
                return "HRES_NS_E_TITLE_SIZE_EXCEEDED";
                break;
            case 0xC00D00D1:
                return "HRES_NS_E_UDP_DISABLED";
                break;
            case 0xC00D00D2:
                return "HRES_NS_E_TCP_DISABLED";
                break;
            case 0xC00D00D3:
                return "HRES_NS_E_HTTP_DISABLED";
                break;
            case 0xC00D00D4:
                return "HRES_NS_E_LICENSE_EXPIRED";
                break;
            case 0xC00D00D5:
                return "HRES_NS_E_TITLE_BITRATE";
                break;
            case 0xC00D00D6:
                return "HRES_NS_E_EMPTY_PROGRAM_NAME";
                break;
            case 0xC00D00D7:
                return "HRES_NS_E_MISSING_CHANNEL";
                break;
            case 0xC00D00D8:
                return "HRES_NS_E_NO_CHANNELS";
                break;
            case 0xC00D00D9:
                return "HRES_NS_E_INVALID_INDEX2";
                break;
            case 0xC00D0190:
                return "HRES_NS_E_CUB_FAIL_LINK";
                break;
            case 0xC00D0192:
                return "HRES_NS_E_BAD_CUB_UID";
                break;
            case 0xC00D0195:
                return "HRES_NS_E_GLITCH_MODE";
                break;
            case 0xC00D019B:
                return "HRES_NS_E_NO_MEDIA_PROTOCOL";
                break;
            case 0xC00D07F1:
                return "HRES_NS_E_NOTHING_TO_DO";
                break;
            case 0xC00D07F2:
                return "HRES_NS_E_NO_MULTICAST";
                break;
            case 0xC00D0BB8:
                return "HRES_NS_E_INVALID_INPUT_FORMAT";
                break;
            case 0xC00D0BB9:
                return "HRES_NS_E_MSAUDIO_NOT_INSTALLED";
                break;
            case 0xC00D0BBA:
                return "HRES_NS_E_UNEXPECTED_MSAUDIO_ERROR";
                break;
            case 0xC00D0BBB:
                return "HRES_NS_E_INVALID_OUTPUT_FORMAT";
                break;
            case 0xC00D0BBC:
                return "HRES_NS_E_NOT_CONFIGURED";
                break;
            case 0xC00D0BBD:
                return "HRES_NS_E_PROTECTED_CONTENT";
                break;
            case 0xC00D0BBE:
                return "HRES_NS_E_LICENSE_REQUIRED";
                break;
            case 0xC00D0BBF:
                return "HRES_NS_E_TAMPERED_CONTENT";
                break;
            case 0xC00D0BC0:
                return "HRES_NS_E_LICENSE_OUTOFDATE";
                break;
            case 0xC00D0BC1:
                return "HRES_NS_E_LICENSE_INCORRECT_RIGHTS";
                break;
            case 0xC00D0BC2:
                return "HRES_NS_E_AUDIO_CODEC_NOT_INSTALLED";
                break;
            case 0xC00D0BC3:
                return "HRES_NS_E_AUDIO_CODEC_ERROR";
                break;
            case 0xC00D0BC4:
                return "HRES_NS_E_VIDEO_CODEC_NOT_INSTALLED";
                break;
            case 0xC00D0BC5:
                return "HRES_NS_E_VIDEO_CODEC_ERROR";
                break;
            case 0xC00D0BC6:
                return "HRES_NS_E_INVALIDPROFILE";
                break;
            case 0xC00D0BC7:
                return "HRES_NS_E_INCOMPATIBLE_VERSION";
                break;
            case 0xC00D0BCA:
                return "HRES_NS_E_OFFLINE_MODE";
                break;
            case 0xC00D0BCB:
                return "HRES_NS_E_NOT_CONNECTED";
                break;
            case 0xC00D0BCC:
                return "HRES_NS_E_TOO_MUCH_DATA";
                break;
            case 0xC00D0BCD:
                return "HRES_NS_E_UNSUPPORTED_PROPERTY";
                break;
            case 0xC00D0BCE:
                return "HRES_NS_E_8BIT_WAVE_UNSUPPORTED";
                break;
            case 0xC00D0BCF:
                return "HRES_NS_E_NO_MORE_SAMPLES";
                break;
            case 0xC00D0BD0:
                return "HRES_NS_E_INVALID_SAMPLING_RATE";
                break;
            case 0xC00D0BD1:
                return "HRES_NS_E_MAX_PACKET_SIZE_TOO_SMALL";
                break;
            case 0xC00D0BD2:
                return "HRES_NS_E_LATE_PACKET";
                break;
            case 0xC00D0BD3:
                return "HRES_NS_E_DUPLICATE_PACKET";
                break;
            case 0xC00D0BD4:
                return "HRES_NS_E_SDK_BUFFERTOOSMALL";
                break;
            case 0xC00D0BD5:
                return "HRES_NS_E_INVALID_NUM_PASSES";
                break;
            case 0xC00D0BD6:
                return "HRES_NS_E_ATTRIBUTE_READ_ONLY";
                break;
            case 0xC00D0BD7:
                return "HRES_NS_E_ATTRIBUTE_NOT_ALLOWED";
                break;
            case 0xC00D0BD8:
                return "HRES_NS_E_INVALID_EDL";
                break;
            case 0xC00D0BD9:
                return "HRES_NS_E_DATA_UNIT_EXTENSION_TOO_LARGE";
                break;
            case 0xC00D0BDA:
                return "HRES_NS_E_CODEC_DMO_ERROR";
                break;
            case 0xC00D0BDC:
                return "HRES_NS_E_FEATURE_DISABLED_BY_GROUP_POLICY";
                break;
            case 0xC00D0BDD:
                return "HRES_NS_E_FEATURE_DISABLED_IN_SKU";
                break;
            case 0xC00D0FA0:
                return "HRES_NS_E_NO_CD";
                break;
            case 0xC00D0FA1:
                return "HRES_NS_E_CANT_READ_DIGITAL";
                break;
            case 0xC00D0FA2:
                return "HRES_NS_E_DEVICE_DISCONNECTED";
                break;
            case 0xC00D0FA3:
                return "HRES_NS_E_DEVICE_NOT_SUPPORT_FORMAT";
                break;
            case 0xC00D0FA4:
                return "HRES_NS_E_SLOW_READ_DIGITAL";
                break;
            case 0xC00D0FA5:
                return "HRES_NS_E_MIXER_INVALID_LINE";
                break;
            case 0xC00D0FA6:
                return "HRES_NS_E_MIXER_INVALID_CONTROL";
                break;
            case 0xC00D0FA7:
                return "HRES_NS_E_MIXER_INVALID_VALUE";
                break;
            case 0xC00D0FA8:
                return "HRES_NS_E_MIXER_UNKNOWN_MMRESULT";
                break;
            case 0xC00D0FA9:
                return "HRES_NS_E_USER_STOP";
                break;
            case 0xC00D0FAA:
                return "HRES_NS_E_MP3_FORMAT_NOT_FOUND";
                break;
            case 0xC00D0FAB:
                return "HRES_NS_E_CD_READ_ERROR_NO_CORRECTION";
                break;
            case 0xC00D0FAC:
                return "HRES_NS_E_CD_READ_ERROR";
                break;
            case 0xC00D0FAD:
                return "HRES_NS_E_CD_SLOW_COPY";
                break;
            case 0xC00D0FAE:
                return "HRES_NS_E_CD_COPYTO_CD";
                break;
            case 0xC00D0FAF:
                return "HRES_NS_E_MIXER_NODRIVER";
                break;
            case 0xC00D0FB0:
                return "HRES_NS_E_REDBOOK_ENABLED_WHILE_COPYING";
                break;
            case 0xC00D0FB1:
                return "HRES_NS_E_CD_REFRESH";
                break;
            case 0xC00D0FB2:
                return "HRES_NS_E_CD_DRIVER_PROBLEM";
                break;
            case 0xC00D0FB3:
                return "HRES_NS_E_WONT_DO_DIGITAL";
                break;
            case 0xC00D0FB4:
                return "HRES_NS_E_WMPXML_NOERROR";
                break;
            case 0xC00D0FB5:
                return "HRES_NS_E_WMPXML_ENDOFDATA";
                break;
            case 0xC00D0FB6:
                return "HRES_NS_E_WMPXML_PARSEERROR";
                break;
            case 0xC00D0FB7:
                return "HRES_NS_E_WMPXML_ATTRIBUTENOTFOUND";
                break;
            case 0xC00D0FB8:
                return "HRES_NS_E_WMPXML_PINOTFOUND";
                break;
            case 0xC00D0FB9:
                return "HRES_NS_E_WMPXML_EMPTYDOC";
                break;
            case 0xC00D0FBA:
                return "HRES_NS_E_WMP_PATH_ALREADY_IN_LIBRARY";
                break;
            case 0xC00D0FBE:
                return "HRES_NS_E_WMP_FILESCANALREADYSTARTED";
                break;
            case 0xC00D0FBF:
                return "HRES_NS_E_WMP_HME_INVALIDOBJECTID";
                break;
            case 0xC00D0FC0:
                return "HRES_NS_E_WMP_MF_CODE_EXPIRED";
                break;
            case 0xC00D0FC1:
                return "HRES_NS_E_WMP_HME_NOTSEARCHABLEFORITEMS";
                break;
            case 0xC00D0FC7:
                return "HRES_NS_E_WMP_ADDTOLIBRARY_FAILED";
                break;
            case 0xC00D0FC8:
                return "HRES_NS_E_WMP_WINDOWSAPIFAILURE";
                break;
            case 0xC00D0FC9:
                return "HRES_NS_E_WMP_RECORDING_NOT_ALLOWED";
                break;
            case 0xC00D0FCA:
                return "HRES_NS_E_DEVICE_NOT_READY";
                break;
            case 0xC00D0FCB:
                return "HRES_NS_E_DAMAGED_FILE";
                break;
            case 0xC00D0FCC:
                return "HRES_NS_E_MPDB_GENERIC";
                break;
            case 0xC00D0FCD:
                return "HRES_NS_E_FILE_FAILED_CHECKS";
                break;
            case 0xC00D0FCE:
                return "HRES_NS_E_MEDIA_LIBRARY_FAILED";
                break;
            case 0xC00D0FCF:
                return "HRES_NS_E_SHARING_VIOLATION";
                break;
            case 0xC00D0FD0:
                return "HRES_NS_E_NO_ERROR_STRING_FOUND";
                break;
            case 0xC00D0FD1:
                return "HRES_NS_E_WMPOCX_NO_REMOTE_CORE";
                break;
            case 0xC00D0FD2:
                return "HRES_NS_E_WMPOCX_NO_ACTIVE_CORE";
                break;
            case 0xC00D0FD3:
                return "HRES_NS_E_WMPOCX_NOT_RUNNING_REMOTELY";
                break;
            case 0xC00D0FD4:
                return "HRES_NS_E_WMPOCX_NO_REMOTE_WINDOW";
                break;
            case 0xC00D0FD5:
                return "HRES_NS_E_WMPOCX_ERRORMANAGERNOTAVAILABLE";
                break;
            case 0xC00D0FD6:
                return "HRES_NS_E_PLUGIN_NOTSHUTDOWN";
                break;
            case 0xC00D0FD7:
                return "HRES_NS_E_WMP_CANNOT_FIND_FOLDER";
                break;
            case 0xC00D0FD8:
                return "HRES_NS_E_WMP_STREAMING_RECORDING_NOT_ALLOWED";
                break;
            case 0xC00D0FD9:
                return "HRES_NS_E_WMP_PLUGINDLL_NOTFOUND";
                break;
            case 0xC00D0FDA:
                return "HRES_NS_E_NEED_TO_ASK_USER";
                break;
            case 0xC00D0FDB:
                return "HRES_NS_E_WMPOCX_PLAYER_NOT_DOCKED";
                break;
            case 0xC00D0FDC:
                return "HRES_NS_E_WMP_EXTERNAL_NOTREADY";
                break;
            case 0xC00D0FDD:
                return "HRES_NS_E_WMP_MLS_STALE_DATA";
                break;
            case 0xC00D0FDE:
                return "HRES_NS_E_WMP_UI_SUBCONTROLSNOTSUPPORTED";
                break;
            case 0xC00D0FDF:
                return "HRES_NS_E_WMP_UI_VERSIONMISMATCH";
                break;
            case 0xC00D0FE0:
                return "HRES_NS_E_WMP_UI_NOTATHEMEFILE";
                break;
            case 0xC00D0FE1:
                return "HRES_NS_E_WMP_UI_SUBELEMENTNOTFOUND";
                break;
            case 0xC00D0FE2:
                return "HRES_NS_E_WMP_UI_VERSIONPARSE";
                break;
            case 0xC00D0FE3:
                return "HRES_NS_E_WMP_UI_VIEWIDNOTFOUND";
                break;
            case 0xC00D0FE4:
                return "HRES_NS_E_WMP_UI_PASSTHROUGH";
                break;
            case 0xC00D0FE5:
                return "HRES_NS_E_WMP_UI_OBJECTNOTFOUND";
                break;
            case 0xC00D0FE6:
                return "HRES_NS_E_WMP_UI_SECONDHANDLER";
                break;
            case 0xC00D0FE7:
                return "HRES_NS_E_WMP_UI_NOSKININZIP";
                break;
            case 0xC00D0FEA:
                return "HRES_NS_E_WMP_URLDOWNLOADFAILED";
                break;
            case 0xC00D0FEB:
                return "HRES_NS_E_WMPOCX_UNABLE_TO_LOAD_SKIN";
                break;
            case 0xC00D0FEC:
                return "HRES_NS_E_WMP_INVALID_SKIN";
                break;
            case 0xC00D0FED:
                return "HRES_NS_E_WMP_SENDMAILFAILED";
                break;
            case 0xC00D0FEE:
                return "HRES_NS_E_WMP_LOCKEDINSKINMODE";
                break;
            case 0xC00D0FEF:
                return "HRES_NS_E_WMP_FAILED_TO_SAVE_FILE";
                break;
            case 0xC00D0FF0:
                return "HRES_NS_E_WMP_SAVEAS_READONLY";
                break;
            case 0xC00D0FF1:
                return "HRES_NS_E_WMP_FAILED_TO_SAVE_PLAYLIST";
                break;
            case 0xC00D0FF2:
                return "HRES_NS_E_WMP_FAILED_TO_OPEN_WMD";
                break;
            case 0xC00D0FF3:
                return "HRES_NS_E_WMP_CANT_PLAY_PROTECTED";
                break;
            case 0xC00D0FF4:
                return "HRES_NS_E_SHARING_STATE_OUT_OF_SYNC";
                break;
            case 0xC00D0FFA:
                return "HRES_NS_E_WMPOCX_REMOTE_PLAYER_ALREADY_RUNNING";
                break;
            case 0xC00D1004:
                return "HRES_NS_E_WMP_RBC_JPGMAPPINGIMAGE";
                break;
            case 0xC00D1005:
                return "HRES_NS_E_WMP_JPGTRANSPARENCY";
                break;
            case 0xC00D1009:
                return "HRES_NS_E_WMP_INVALID_MAX_VAL";
                break;
            case 0xC00D100A:
                return "HRES_NS_E_WMP_INVALID_MIN_VAL";
                break;
            case 0xC00D100E:
                return "HRES_NS_E_WMP_CS_JPGPOSITIONIMAGE";
                break;
            case 0xC00D100F:
                return "HRES_NS_E_WMP_CS_NOTEVENLYDIVISIBLE";
                break;
            case 0xC00D1018:
                return "HRES_NS_E_WMPZIP_NOTAZIPFILE";
                break;
            case 0xC00D1019:
                return "HRES_NS_E_WMPZIP_CORRUPT";
                break;
            case 0xC00D101A:
                return "HRES_NS_E_WMPZIP_FILENOTFOUND";
                break;
            case 0xC00D1022:
                return "HRES_NS_E_WMP_IMAGE_FILETYPE_UNSUPPORTED";
                break;
            case 0xC00D1023:
                return "HRES_NS_E_WMP_IMAGE_INVALID_FORMAT";
                break;
            case 0xC00D1024:
                return "HRES_NS_E_WMP_GIF_UNEXPECTED_ENDOFFILE";
                break;
            case 0xC00D1025:
                return "HRES_NS_E_WMP_GIF_INVALID_FORMAT";
                break;
            case 0xC00D1026:
                return "HRES_NS_E_WMP_GIF_BAD_VERSION_NUMBER";
                break;
            case 0xC00D1027:
                return "HRES_NS_E_WMP_GIF_NO_IMAGE_IN_FILE";
                break;
            case 0xC00D1028:
                return "HRES_NS_E_WMP_PNG_INVALIDFORMAT";
                break;
            case 0xC00D1029:
                return "HRES_NS_E_WMP_PNG_UNSUPPORTED_BITDEPTH";
                break;
            case 0xC00D102A:
                return "HRES_NS_E_WMP_PNG_UNSUPPORTED_COMPRESSION";
                break;
            case 0xC00D102B:
                return "HRES_NS_E_WMP_PNG_UNSUPPORTED_FILTER";
                break;
            case 0xC00D102C:
                return "HRES_NS_E_WMP_PNG_UNSUPPORTED_INTERLACE";
                break;
            case 0xC00D102D:
                return "HRES_NS_E_WMP_PNG_UNSUPPORTED_BAD_CRC";
                break;
            case 0xC00D102E:
                return "HRES_NS_E_WMP_BMP_INVALID_BITMASK";
                break;
            case 0xC00D102F:
                return "HRES_NS_E_WMP_BMP_TOPDOWN_DIB_UNSUPPORTED";
                break;
            case 0xC00D1030:
                return "HRES_NS_E_WMP_BMP_BITMAP_NOT_CREATED";
                break;
            case 0xC00D1031:
                return "HRES_NS_E_WMP_BMP_COMPRESSION_UNSUPPORTED";
                break;
            case 0xC00D1032:
                return "HRES_NS_E_WMP_BMP_INVALID_FORMAT";
                break;
            case 0xC00D1033:
                return "HRES_NS_E_WMP_JPG_JERR_ARITHCODING_NOTIMPL";
                break;
            case 0xC00D1034:
                return "HRES_NS_E_WMP_JPG_INVALID_FORMAT";
                break;
            case 0xC00D1035:
                return "HRES_NS_E_WMP_JPG_BAD_DCTSIZE";
                break;
            case 0xC00D1036:
                return "HRES_NS_E_WMP_JPG_BAD_VERSION_NUMBER";
                break;
            case 0xC00D1037:
                return "HRES_NS_E_WMP_JPG_BAD_PRECISION";
                break;
            case 0xC00D1038:
                return "HRES_NS_E_WMP_JPG_CCIR601_NOTIMPL";
                break;
            case 0xC00D1039:
                return "HRES_NS_E_WMP_JPG_NO_IMAGE_IN_FILE";
                break;
            case 0xC00D103A:
                return "HRES_NS_E_WMP_JPG_READ_ERROR";
                break;
            case 0xC00D103B:
                return "HRES_NS_E_WMP_JPG_FRACT_SAMPLE_NOTIMPL";
                break;
            case 0xC00D103C:
                return "HRES_NS_E_WMP_JPG_IMAGE_TOO_BIG";
                break;
            case 0xC00D103D:
                return "HRES_NS_E_WMP_JPG_UNEXPECTED_ENDOFFILE";
                break;
            case 0xC00D103E:
                return "HRES_NS_E_WMP_JPG_SOF_UNSUPPORTED";
                break;
            case 0xC00D103F:
                return "HRES_NS_E_WMP_JPG_UNKNOWN_MARKER";
                break;
            case 0xC00D1044:
                return "HRES_NS_E_WMP_FAILED_TO_OPEN_IMAGE";
                break;
            case 0xC00D1049:
                return "HRES_NS_E_WMP_DAI_SONGTOOSHORT";
                break;
            case 0xC00D104A:
                return "HRES_NS_E_WMG_RATEUNAVAILABLE";
                break;
            case 0xC00D104B:
                return "HRES_NS_E_WMG_PLUGINUNAVAILABLE";
                break;
            case 0xC00D104C:
                return "HRES_NS_E_WMG_CANNOTQUEUE";
                break;
            case 0xC00D104D:
                return "HRES_NS_E_WMG_PREROLLLICENSEACQUISITIONNOTALLOWED";
                break;
            case 0xC00D104E:
                return "HRES_NS_E_WMG_UNEXPECTEDPREROLLSTATUS";
                break;
            case 0xC00D1051:
                return "HRES_NS_E_WMG_INVALID_COPP_CERTIFICATE";
                break;
            case 0xC00D1052:
                return "HRES_NS_E_WMG_COPP_SECURITY_INVALID";
                break;
            case 0xC00D1053:
                return "HRES_NS_E_WMG_COPP_UNSUPPORTED";
                break;
            case 0xC00D1054:
                return "HRES_NS_E_WMG_INVALIDSTATE";
                break;
            case 0xC00D1055:
                return "HRES_NS_E_WMG_SINKALREADYEXISTS";
                break;
            case 0xC00D1056:
                return "HRES_NS_E_WMG_NOSDKINTERFACE";
                break;
            case 0xC00D1057:
                return "HRES_NS_E_WMG_NOTALLOUTPUTSRENDERED";
                break;
            case 0xC00D1058:
                return "HRES_NS_E_WMG_FILETRANSFERNOTALLOWED";
                break;
            case 0xC00D1059:
                return "HRES_NS_E_WMR_UNSUPPORTEDSTREAM";
                break;
            case 0xC00D105A:
                return "HRES_NS_E_WMR_PINNOTFOUND";
                break;
            case 0xC00D105B:
                return "HRES_NS_E_WMR_WAITINGONFORMATSWITCH";
                break;
            case 0xC00D105C:
                return "HRES_NS_E_WMR_NOSOURCEFILTER";
                break;
            case 0xC00D105D:
                return "HRES_NS_E_WMR_PINTYPENOMATCH";
                break;
            case 0xC00D105E:
                return "HRES_NS_E_WMR_NOCALLBACKAVAILABLE";
                break;
            case 0xC00D1062:
                return "HRES_NS_E_WMR_SAMPLEPROPERTYNOTSET";
                break;
            case 0xC00D1063:
                return "HRES_NS_E_WMR_CANNOT_RENDER_BINARY_STREAM";
                break;
            case 0xC00D1064:
                return "HRES_NS_E_WMG_LICENSE_TAMPERED";
                break;
            case 0xC00D1065:
                return "HRES_NS_E_WMR_WILLNOT_RENDER_BINARY_STREAM";
                break;
            case 0xC00D1068:
                return "HRES_NS_E_WMX_UNRECOGNIZED_PLAYLIST_FORMAT";
                break;
            case 0xC00D1069:
                return "HRES_NS_E_ASX_INVALIDFORMAT";
                break;
            case 0xC00D106A:
                return "HRES_NS_E_ASX_INVALIDVERSION";
                break;
            case 0xC00D106B:
                return "HRES_NS_E_ASX_INVALID_REPEAT_BLOCK";
                break;
            case 0xC00D106C:
                return "HRES_NS_E_ASX_NOTHING_TO_WRITE";
                break;
            case 0xC00D106D:
                return "HRES_NS_E_URLLIST_INVALIDFORMAT";
                break;
            case 0xC00D106E:
                return "HRES_NS_E_WMX_ATTRIBUTE_DOES_NOT_EXIST";
                break;
            case 0xC00D106F:
                return "HRES_NS_E_WMX_ATTRIBUTE_ALREADY_EXISTS";
                break;
            case 0xC00D1070:
                return "HRES_NS_E_WMX_ATTRIBUTE_UNRETRIEVABLE";
                break;
            case 0xC00D1071:
                return "HRES_NS_E_WMX_ITEM_DOES_NOT_EXIST";
                break;
            case 0xC00D1072:
                return "HRES_NS_E_WMX_ITEM_TYPE_ILLEGAL";
                break;
            case 0xC00D1073:
                return "HRES_NS_E_WMX_ITEM_UNSETTABLE";
                break;
            case 0xC00D1074:
                return "HRES_NS_E_WMX_PLAYLIST_EMPTY";
                break;
            case 0xC00D1075:
                return "HRES_NS_E_MLS_SMARTPLAYLIST_FILTER_NOT_REGISTERED";
                break;
            case 0xC00D1076:
                return "HRES_NS_E_WMX_INVALID_FORMAT_OVER_NESTING";
                break;
            case 0xC00D107C:
                return "HRES_NS_E_WMPCORE_NOSOURCEURLSTRING";
                break;
            case 0xC00D107D:
                return "HRES_NS_E_WMPCORE_COCREATEFAILEDFORGITOBJECT";
                break;
            case 0xC00D107E:
                return "HRES_NS_E_WMPCORE_FAILEDTOGETMARSHALLEDEVENTHANDLERINTERFACE";
                break;
            case 0xC00D107F:
                return "HRES_NS_E_WMPCORE_BUFFERTOOSMALL";
                break;
            case 0xC00D1080:
                return "HRES_NS_E_WMPCORE_UNAVAILABLE";
                break;
            case 0xC00D1081:
                return "HRES_NS_E_WMPCORE_INVALIDPLAYLISTMODE";
                break;
            case 0xC00D1086:
                return "HRES_NS_E_WMPCORE_ITEMNOTINPLAYLIST";
                break;
            case 0xC00D1087:
                return "HRES_NS_E_WMPCORE_PLAYLISTEMPTY";
                break;
            case 0xC00D1088:
                return "HRES_NS_E_WMPCORE_NOBROWSER";
                break;
            case 0xC00D1089:
                return "HRES_NS_E_WMPCORE_UNRECOGNIZED_MEDIA_URL";
                break;
            case 0xC00D108A:
                return "HRES_NS_E_WMPCORE_GRAPH_NOT_IN_LIST";
                break;
            case 0xC00D108B:
                return "HRES_NS_E_WMPCORE_PLAYLIST_EMPTY_OR_SINGLE_MEDIA";
                break;
            case 0xC00D108C:
                return "HRES_NS_E_WMPCORE_ERRORSINKNOTREGISTERED";
                break;
            case 0xC00D108D:
                return "HRES_NS_E_WMPCORE_ERRORMANAGERNOTAVAILABLE";
                break;
            case 0xC00D108E:
                return "HRES_NS_E_WMPCORE_WEBHELPFAILED";
                break;
            case 0xC00D108F:
                return "HRES_NS_E_WMPCORE_MEDIA_ERROR_RESUME_FAILED";
                break;
            case 0xC00D1090:
                return "HRES_NS_E_WMPCORE_NO_REF_IN_ENTRY";
                break;
            case 0xC00D1091:
                return "HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_EMPTY";
                break;
            case 0xC00D1092:
                return "HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_ILLEGAL";
                break;
            case 0xC00D1093:
                return "HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_EMPTY";
                break;
            case 0xC00D1094:
                return "HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_ILLEGAL";
                break;
            case 0xC00D1095:
                return "HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_EMPTY";
                break;
            case 0xC00D1096:
                return "HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_ILLEGAL";
                break;
            case 0xC00D1097:
                return "HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_VALUE_EMPTY";
                break;
            case 0xC00D1098:
                return "HRES_NS_E_WMPCORE_LIST_ENTRY_NO_REF";
                break;
            case 0xC00D1099:
                return "HRES_NS_E_WMPCORE_MISNAMED_FILE";
                break;
            case 0xC00D109A:
                return "HRES_NS_E_WMPCORE_CODEC_NOT_TRUSTED";
                break;
            case 0xC00D109B:
                return "HRES_NS_E_WMPCORE_CODEC_NOT_FOUND";
                break;
            case 0xC00D109C:
                return "HRES_NS_E_WMPCORE_CODEC_DOWNLOAD_NOT_ALLOWED";
                break;
            case 0xC00D109D:
                return "HRES_NS_E_WMPCORE_ERROR_DOWNLOADING_PLAYLIST";
                break;
            case 0xC00D109E:
                return "HRES_NS_E_WMPCORE_FAILED_TO_BUILD_PLAYLIST";
                break;
            case 0xC00D109F:
                return "HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NONE";
                break;
            case 0xC00D10A0:
                return "HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_EXHAUSTED";
                break;
            case 0xC00D10A1:
                return "HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NAME_NOT_FOUND";
                break;
            case 0xC00D10A2:
                return "HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_MORPH_FAILED";
                break;
            case 0xC00D10A3:
                return "HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_INIT_FAILED";
                break;
            case 0xC00D10A4:
                return "HRES_NS_E_WMPCORE_MEDIA_ALTERNATE_REF_EMPTY";
                break;
            case 0xC00D10A5:
                return "HRES_NS_E_WMPCORE_PLAYLIST_NO_EVENT_NAME";
                break;
            case 0xC00D10A6:
                return "HRES_NS_E_WMPCORE_PLAYLIST_EVENT_ATTRIBUTE_ABSENT";
                break;
            case 0xC00D10A7:
                return "HRES_NS_E_WMPCORE_PLAYLIST_EVENT_EMPTY";
                break;
            case 0xC00D10A8:
                return "HRES_NS_E_WMPCORE_PLAYLIST_STACK_EMPTY";
                break;
            case 0xC00D10A9:
                return "HRES_NS_E_WMPCORE_CURRENT_MEDIA_NOT_ACTIVE";
                break;
            case 0xC00D10AB:
                return "HRES_NS_E_WMPCORE_USER_CANCEL";
                break;
            case 0xC00D10AC:
                return "HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_EMPTY";
                break;
            case 0xC00D10AD:
                return "HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_START_MEDIA_NONE";
                break;
            case 0xC00D10AE:
                return "HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_END_MEDIA_NONE";
                break;
            case 0xC00D10AF:
                return "HRES_NS_E_WMPCORE_INVALID_PLAYLIST_URL";
                break;
            case 0xC00D10B0:
                return "HRES_NS_E_WMPCORE_MISMATCHED_RUNTIME";
                break;
            case 0xC00D10B1:
                return "HRES_NS_E_WMPCORE_PLAYLIST_IMPORT_FAILED_NO_ITEMS";
                break;
            case 0xC00D10B2:
                return "HRES_NS_E_WMPCORE_VIDEO_TRANSFORM_FILTER_INSERTION";
                break;
            case 0xC00D10B3:
                return "HRES_NS_E_WMPCORE_MEDIA_UNAVAILABLE";
                break;
            case 0xC00D10B4:
                return "HRES_NS_E_WMPCORE_WMX_ENTRYREF_NO_REF";
                break;
            case 0xC00D10B5:
                return "HRES_NS_E_WMPCORE_NO_PLAYABLE_MEDIA_IN_PLAYLIST";
                break;
            case 0xC00D10B6:
                return "HRES_NS_E_WMPCORE_PLAYLIST_EMPTY_NESTED_PLAYLIST_SKIPPED_ITEMS";
                break;
            case 0xC00D10B7:
                return "HRES_NS_E_WMPCORE_BUSY";
                break;
            case 0xC00D10B8:
                return "HRES_NS_E_WMPCORE_MEDIA_CHILD_PLAYLIST_UNAVAILABLE";
                break;
            case 0xC00D10B9:
                return "HRES_NS_E_WMPCORE_MEDIA_NO_CHILD_PLAYLIST";
                break;
            case 0xC00D10BA:
                return "HRES_NS_E_WMPCORE_FILE_NOT_FOUND";
                break;
            case 0xC00D10BB:
                return "HRES_NS_E_WMPCORE_TEMP_FILE_NOT_FOUND";
                break;
            case 0xC00D10BC:
                return "HRES_NS_E_WMDM_REVOKED";
                break;
            case 0xC00D10BD:
                return "HRES_NS_E_DDRAW_GENERIC";
                break;
            case 0xC00D10BE:
                return "HRES_NS_E_DISPLAY_MODE_CHANGE_FAILED";
                break;
            case 0xC00D10BF:
                return "HRES_NS_E_PLAYLIST_CONTAINS_ERRORS";
                break;
            case 0xC00D10C0:
                return "HRES_NS_E_CHANGING_PROXY_NAME";
                break;
            case 0xC00D10C1:
                return "HRES_NS_E_CHANGING_PROXY_PORT";
                break;
            case 0xC00D10C2:
                return "HRES_NS_E_CHANGING_PROXY_EXCEPTIONLIST";
                break;
            case 0xC00D10C3:
                return "HRES_NS_E_CHANGING_PROXYBYPASS";
                break;
            case 0xC00D10C4:
                return "HRES_NS_E_CHANGING_PROXY_PROTOCOL_NOT_FOUND";
                break;
            case 0xC00D10C5:
                return "HRES_NS_E_GRAPH_NOAUDIOLANGUAGE";
                break;
            case 0xC00D10C6:
                return "HRES_NS_E_GRAPH_NOAUDIOLANGUAGESELECTED";
                break;
            case 0xC00D10C7:
                return "HRES_NS_E_CORECD_NOTAMEDIACD";
                break;
            case 0xC00D10C8:
                return "HRES_NS_E_WMPCORE_MEDIA_URL_TOO_LONG";
                break;
            case 0xC00D10C9:
                return "HRES_NS_E_WMPFLASH_CANT_FIND_COM_SERVER";
                break;
            case 0xC00D10CA:
                return "HRES_NS_E_WMPFLASH_INCOMPATIBLEVERSION";
                break;
            case 0xC00D10CB:
                return "HRES_NS_E_WMPOCXGRAPH_IE_DISALLOWS_ACTIVEX_CONTROLS";
                break;
            case 0xC00D10CC:
                return "HRES_NS_E_NEED_CORE_REFERENCE";
                break;
            case 0xC00D10CD:
                return "HRES_NS_E_MEDIACD_READ_ERROR";
                break;
            case 0xC00D10CE:
                return "HRES_NS_E_IE_DISALLOWS_ACTIVEX_CONTROLS";
                break;
            case 0xC00D10CF:
                return "HRES_NS_E_FLASH_PLAYBACK_NOT_ALLOWED";
                break;
            case 0xC00D10D0:
                return "HRES_NS_E_UNABLE_TO_CREATE_RIP_LOCATION";
                break;
            case 0xC00D10D1:
                return "HRES_NS_E_WMPCORE_SOME_CODECS_MISSING";
                break;
            case 0xC00D10D2:
                return "HRES_NS_E_WMP_RIP_FAILED";
                break;
            case 0xC00D10D3:
                return "HRES_NS_E_WMP_FAILED_TO_RIP_TRACK";
                break;
            case 0xC00D10D4:
                return "HRES_NS_E_WMP_ERASE_FAILED";
                break;
            case 0xC00D10D5:
                return "HRES_NS_E_WMP_FORMAT_FAILED";
                break;
            case 0xC00D10D6:
                return "HRES_NS_E_WMP_CANNOT_BURN_NON_LOCAL_FILE";
                break;
            case 0xC00D10D7:
                return "HRES_NS_E_WMP_FILE_TYPE_CANNOT_BURN_TO_AUDIO_CD";
                break;
            case 0xC00D10D8:
                return "HRES_NS_E_WMP_FILE_DOES_NOT_FIT_ON_CD";
                break;
            case 0xC00D10D9:
                return "HRES_NS_E_WMP_FILE_NO_DURATION";
                break;
            case 0xC00D10DA:
                return "HRES_NS_E_PDA_FAILED_TO_BURN";
                break;
            case 0xC00D10DC:
                return "HRES_NS_E_FAILED_DOWNLOAD_ABORT_BURN";
                break;
            case 0xC00D10DD:
                return "HRES_NS_E_WMPCORE_DEVICE_DRIVERS_MISSING";
                break;
            case 0xC00D1126:
                return "HRES_NS_E_WMPIM_USEROFFLINE";
                break;
            case 0xC00D1127:
                return "HRES_NS_E_WMPIM_USERCANCELED";
                break;
            case 0xC00D1128:
                return "HRES_NS_E_WMPIM_DIALUPFAILED";
                break;
            case 0xC00D1129:
                return "HRES_NS_E_WINSOCK_ERROR_STRING";
                break;
            case 0xC00D1130:
                return "HRES_NS_E_WMPBR_NOLISTENER";
                break;
            case 0xC00D1131:
                return "HRES_NS_E_WMPBR_BACKUPCANCEL";
                break;
            case 0xC00D1132:
                return "HRES_NS_E_WMPBR_RESTORECANCEL";
                break;
            case 0xC00D1133:
                return "HRES_NS_E_WMPBR_ERRORWITHURL";
                break;
            case 0xC00D1134:
                return "HRES_NS_E_WMPBR_NAMECOLLISION";
                break;
            case 0xC00D1137:
                return "HRES_NS_E_WMPBR_DRIVE_INVALID";
                break;
            case 0xC00D1138:
                return "HRES_NS_E_WMPBR_BACKUPRESTOREFAILED";
                break;
            case 0xC00D1158:
                return "HRES_NS_E_WMP_CONVERT_FILE_FAILED";
                break;
            case 0xC00D1159:
                return "HRES_NS_E_WMP_CONVERT_NO_RIGHTS_ERRORURL";
                break;
            case 0xC00D115A:
                return "HRES_NS_E_WMP_CONVERT_NO_RIGHTS_NOERRORURL";
                break;
            case 0xC00D115B:
                return "HRES_NS_E_WMP_CONVERT_FILE_CORRUPT";
                break;
            case 0xC00D115C:
                return "HRES_NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_ERRORURL";
                break;
            case 0xC00D115D:
                return "HRES_NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_NOERRORURL";
                break;
            case 0xC00D115E:
                return "HRES_NS_E_WMP_CONVERT_PLUGIN_UNKNOWN_FILE_OWNER";
                break;
            case 0xC00D1160:
                return "HRES_NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_NS";
                break;
            case 0xC00D1161:
                return "HRES_NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_FAILED";
                break;
            case 0xC00D1162:
                return "HRES_NS_E_DVD_NO_SUBPICTURE_STREAM";
                break;
            case 0xC00D1163:
                return "HRES_NS_E_DVD_COPY_PROTECT";
                break;
            case 0xC00D1164:
                return "HRES_NS_E_DVD_AUTHORING_PROBLEM";
                break;
            case 0xC00D1165:
                return "HRES_NS_E_DVD_INVALID_DISC_REGION";
                break;
            case 0xC00D1166:
                return "HRES_NS_E_DVD_COMPATIBLE_VIDEO_CARD";
                break;
            case 0xC00D1167:
                return "HRES_NS_E_DVD_MACROVISION";
                break;
            case 0xC00D1168:
                return "HRES_NS_E_DVD_SYSTEM_DECODER_REGION";
                break;
            case 0xC00D1169:
                return "HRES_NS_E_DVD_DISC_DECODER_REGION";
                break;
            case 0xC00D116A:
                return "HRES_NS_E_DVD_NO_VIDEO_STREAM";
                break;
            case 0xC00D116B:
                return "HRES_NS_E_DVD_NO_AUDIO_STREAM";
                break;
            case 0xC00D116C:
                return "HRES_NS_E_DVD_GRAPH_BUILDING";
                break;
            case 0xC00D116D:
                return "HRES_NS_E_DVD_NO_DECODER";
                break;
            case 0xC00D116E:
                return "HRES_NS_E_DVD_PARENTAL";
                break;
            case 0xC00D116F:
                return "HRES_NS_E_DVD_CANNOT_JUMP";
                break;
            case 0xC00D1170:
                return "HRES_NS_E_DVD_DEVICE_CONTENTION";
                break;
            case 0xC00D1171:
                return "HRES_NS_E_DVD_NO_VIDEO_MEMORY";
                break;
            case 0xC00D1172:
                return "HRES_NS_E_DVD_CANNOT_COPY_PROTECTED";
                break;
            case 0xC00D1173:
                return "HRES_NS_E_DVD_REQUIRED_PROPERTY_NOT_SET";
                break;
            case 0xC00D1174:
                return "HRES_NS_E_DVD_INVALID_TITLE_CHAPTER";
                break;
            case 0xC00D1176:
                return "HRES_NS_E_NO_CD_BURNER";
                break;
            case 0xC00D1177:
                return "HRES_NS_E_DEVICE_IS_NOT_READY";
                break;
            case 0xC00D1178:
                return "HRES_NS_E_PDA_UNSUPPORTED_FORMAT";
                break;
            case 0xC00D1179:
                return "HRES_NS_E_NO_PDA";
                break;
            case 0xC00D117A:
                return "HRES_NS_E_PDA_UNSPECIFIED_ERROR";
                break;
            case 0xC00D117B:
                return "HRES_NS_E_MEMSTORAGE_BAD_DATA";
                break;
            case 0xC00D117C:
                return "HRES_NS_E_PDA_FAIL_SELECT_DEVICE";
                break;
            case 0xC00D117D:
                return "HRES_NS_E_PDA_FAIL_READ_WAVE_FILE";
                break;
            case 0xC00D117E:
                return "HRES_NS_E_IMAPI_LOSSOFSTREAMING";
                break;
            case 0xC00D117F:
                return "HRES_NS_E_PDA_DEVICE_FULL";
                break;
            case 0xC00D1180:
                return "HRES_NS_E_FAIL_LAUNCH_ROXIO_PLUGIN";
                break;
            case 0xC00D1181:
                return "HRES_NS_E_PDA_DEVICE_FULL_IN_SESSION";
                break;
            case 0xC00D1182:
                return "HRES_NS_E_IMAPI_MEDIUM_INVALIDTYPE";
                break;
            case 0xC00D1183:
                return "HRES_NS_E_PDA_MANUALDEVICE";
                break;
            case 0xC00D1184:
                return "HRES_NS_E_PDA_PARTNERSHIPNOTEXIST";
                break;
            case 0xC00D1185:
                return "HRES_NS_E_PDA_CANNOT_CREATE_ADDITIONAL_SYNC_RELATIONSHIP";
                break;
            case 0xC00D1186:
                return "HRES_NS_E_PDA_NO_TRANSCODE_OF_DRM";
                break;
            case 0xC00D1187:
                return "HRES_NS_E_PDA_TRANSCODECACHEFULL";
                break;
            case 0xC00D1188:
                return "HRES_NS_E_PDA_TOO_MANY_FILE_COLLISIONS";
                break;
            case 0xC00D1189:
                return "HRES_NS_E_PDA_CANNOT_TRANSCODE";
                break;
            case 0xC00D118A:
                return "HRES_NS_E_PDA_TOO_MANY_FILES_IN_DIRECTORY";
                break;
            case 0xC00D118B:
                return "HRES_NS_E_PROCESSINGSHOWSYNCWIZARD";
                break;
            case 0xC00D118C:
                return "HRES_NS_E_PDA_TRANSCODE_NOT_PERMITTED";
                break;
            case 0xC00D118D:
                return "HRES_NS_E_PDA_INITIALIZINGDEVICES";
                break;
            case 0xC00D118E:
                return "HRES_NS_E_PDA_OBSOLETE_SP";
                break;
            case 0xC00D118F:
                return "HRES_NS_E_PDA_TITLE_COLLISION";
                break;
            case 0xC00D1190:
                return "HRES_NS_E_PDA_DEVICESUPPORTDISABLED";
                break;
            case 0xC00D1191:
                return "HRES_NS_E_PDA_NO_LONGER_AVAILABLE";
                break;
            case 0xC00D1192:
                return "HRES_NS_E_PDA_ENCODER_NOT_RESPONDING";
                break;
            case 0xC00D1193:
                return "HRES_NS_E_PDA_CANNOT_SYNC_FROM_LOCATION";
                break;
            case 0xC00D1194:
                return "HRES_NS_E_WMP_PROTOCOL_PROBLEM";
                break;
            case 0xC00D1195:
                return "HRES_NS_E_WMP_NO_DISK_SPACE";
                break;
            case 0xC00D1196:
                return "HRES_NS_E_WMP_LOGON_FAILURE";
                break;
            case 0xC00D1197:
                return "HRES_NS_E_WMP_CANNOT_FIND_FILE";
                break;
            case 0xC00D1198:
                return "HRES_NS_E_WMP_SERVER_INACCESSIBLE";
                break;
            case 0xC00D1199:
                return "HRES_NS_E_WMP_UNSUPPORTED_FORMAT";
                break;
            case 0xC00D119A:
                return "HRES_NS_E_WMP_DSHOW_UNSUPPORTED_FORMAT";
                break;
            case 0xC00D119B:
                return "HRES_NS_E_WMP_PLAYLIST_EXISTS";
                break;
            case 0xC00D119C:
                return "HRES_NS_E_WMP_NONMEDIA_FILES";
                break;
            case 0xC00D119D:
                return "HRES_NS_E_WMP_INVALID_ASX";
                break;
            case 0xC00D119E:
                return "HRES_NS_E_WMP_ALREADY_IN_USE";
                break;
            case 0xC00D119F:
                return "HRES_NS_E_WMP_IMAPI_FAILURE";
                break;
            case 0xC00D11A0:
                return "HRES_NS_E_WMP_WMDM_FAILURE";
                break;
            case 0xC00D11A1:
                return "HRES_NS_E_WMP_CODEC_NEEDED_WITH_4CC";
                break;
            case 0xC00D11A2:
                return "HRES_NS_E_WMP_CODEC_NEEDED_WITH_FORMATTAG";
                break;
            case 0xC00D11A3:
                return "HRES_NS_E_WMP_MSSAP_NOT_AVAILABLE";
                break;
            case 0xC00D11A4:
                return "HRES_NS_E_WMP_WMDM_INTERFACEDEAD";
                break;
            case 0xC00D11A5:
                return "HRES_NS_E_WMP_WMDM_NOTCERTIFIED";
                break;
            case 0xC00D11A6:
                return "HRES_NS_E_WMP_WMDM_LICENSE_NOTEXIST";
                break;
            case 0xC00D11A7:
                return "HRES_NS_E_WMP_WMDM_LICENSE_EXPIRED";
                break;
            case 0xC00D11A8:
                return "HRES_NS_E_WMP_WMDM_BUSY";
                break;
            case 0xC00D11A9:
                return "HRES_NS_E_WMP_WMDM_NORIGHTS";
                break;
            case 0xC00D11AA:
                return "HRES_NS_E_WMP_WMDM_INCORRECT_RIGHTS";
                break;
            case 0xC00D11AB:
                return "HRES_NS_E_WMP_IMAPI_GENERIC";
                break;
            case 0xC00D11AD:
                return "HRES_NS_E_WMP_IMAPI_DEVICE_NOTPRESENT";
                break;
            case 0xC00D11AE:
                return "HRES_NS_E_WMP_IMAPI_DEVICE_BUSY";
                break;
            case 0xC00D11AF:
                return "HRES_NS_E_WMP_IMAPI_LOSS_OF_STREAMING";
                break;
            case 0xC00D11B0:
                return "HRES_NS_E_WMP_SERVER_UNAVAILABLE";
                break;
            case 0xC00D11B1:
                return "HRES_NS_E_WMP_FILE_OPEN_FAILED";
                break;
            case 0xC00D11B2:
                return "HRES_NS_E_WMP_VERIFY_ONLINE";
                break;
            case 0xC00D11B3:
                return "HRES_NS_E_WMP_SERVER_NOT_RESPONDING";
                break;
            case 0xC00D11B4:
                return "HRES_NS_E_WMP_DRM_CORRUPT_BACKUP";
                break;
            case 0xC00D11B5:
                return "HRES_NS_E_WMP_DRM_LICENSE_SERVER_UNAVAILABLE";
                break;
            case 0xC00D11B6:
                return "HRES_NS_E_WMP_NETWORK_FIREWALL";
                break;
            case 0xC00D11B7:
                return "HRES_NS_E_WMP_NO_REMOVABLE_MEDIA";
                break;
            case 0xC00D11B8:
                return "HRES_NS_E_WMP_PROXY_CONNECT_TIMEOUT";
                break;
            case 0xC00D11B9:
                return "HRES_NS_E_WMP_NEED_UPGRADE";
                break;
            case 0xC00D11BA:
                return "HRES_NS_E_WMP_AUDIO_HW_PROBLEM";
                break;
            case 0xC00D11BB:
                return "HRES_NS_E_WMP_INVALID_PROTOCOL";
                break;
            case 0xC00D11BC:
                return "HRES_NS_E_WMP_INVALID_LIBRARY_ADD";
                break;
            case 0xC00D11BD:
                return "HRES_NS_E_WMP_MMS_NOT_SUPPORTED";
                break;
            case 0xC00D11BE:
                return "HRES_NS_E_WMP_NO_PROTOCOLS_SELECTED";
                break;
            case 0xC00D11BF:
                return "HRES_NS_E_WMP_GOFULLSCREEN_FAILED";
                break;
            case 0xC00D11C0:
                return "HRES_NS_E_WMP_NETWORK_ERROR";
                break;
            case 0xC00D11C1:
                return "HRES_NS_E_WMP_CONNECT_TIMEOUT";
                break;
            case 0xC00D11C2:
                return "HRES_NS_E_WMP_MULTICAST_DISABLED";
                break;
            case 0xC00D11C3:
                return "HRES_NS_E_WMP_SERVER_DNS_TIMEOUT";
                break;
            case 0xC00D11C4:
                return "HRES_NS_E_WMP_PROXY_NOT_FOUND";
                break;
            case 0xC00D11C5:
                return "HRES_NS_E_WMP_TAMPERED_CONTENT";
                break;
            case 0xC00D11C6:
                return "HRES_NS_E_WMP_OUTOFMEMORY";
                break;
            case 0xC00D11C7:
                return "HRES_NS_E_WMP_AUDIO_CODEC_NOT_INSTALLED";
                break;
            case 0xC00D11C8:
                return "HRES_NS_E_WMP_VIDEO_CODEC_NOT_INSTALLED";
                break;
            case 0xC00D11C9:
                return "HRES_NS_E_WMP_IMAPI_DEVICE_INVALIDTYPE";
                break;
            case 0xC00D11CA:
                return "HRES_NS_E_WMP_DRM_DRIVER_AUTH_FAILURE";
                break;
            case 0xC00D11CB:
                return "HRES_NS_E_WMP_NETWORK_RESOURCE_FAILURE";
                break;
            case 0xC00D11CC:
                return "HRES_NS_E_WMP_UPGRADE_APPLICATION";
                break;
            case 0xC00D11CD:
                return "HRES_NS_E_WMP_UNKNOWN_ERROR";
                break;
            case 0xC00D11CE:
                return "HRES_NS_E_WMP_INVALID_KEY";
                break;
            case 0xC00D11CF:
                return "HRES_NS_E_WMP_CD_ANOTHER_USER";
                break;
            case 0xC00D11D0:
                return "HRES_NS_E_WMP_DRM_NEEDS_AUTHORIZATION";
                break;
            case 0xC00D11D1:
                return "HRES_NS_E_WMP_BAD_DRIVER";
                break;
            case 0xC00D11D2:
                return "HRES_NS_E_WMP_ACCESS_DENIED";
                break;
            case 0xC00D11D3:
                return "HRES_NS_E_WMP_LICENSE_RESTRICTS";
                break;
            case 0xC00D11D4:
                return "HRES_NS_E_WMP_INVALID_REQUEST";
                break;
            case 0xC00D11D5:
                return "HRES_NS_E_WMP_CD_STASH_NO_SPACE";
                break;
            case 0xC00D11D6:
                return "HRES_NS_E_WMP_DRM_NEW_HARDWARE";
                break;
            case 0xC00D11D7:
                return "HRES_NS_E_WMP_DRM_INVALID_SIG";
                break;
            case 0xC00D11D8:
                return "HRES_NS_E_WMP_DRM_CANNOT_RESTORE";
                break;
            case 0xC00D11D9:
                return "HRES_NS_E_WMP_BURN_DISC_OVERFLOW";
                break;
            case 0xC00D11DA:
                return "HRES_NS_E_WMP_DRM_GENERIC_LICENSE_FAILURE";
                break;
            case 0xC00D11DB:
                return "HRES_NS_E_WMP_DRM_NO_SECURE_CLOCK";
                break;
            case 0xC00D11DC:
                return "HRES_NS_E_WMP_DRM_NO_RIGHTS";
                break;
            case 0xC00D11DD:
                return "HRES_NS_E_WMP_DRM_INDIV_FAILED";
                break;
            case 0xC00D11DE:
                return "HRES_NS_E_WMP_SERVER_NONEWCONNECTIONS";
                break;
            case 0xC00D11DF:
                return "HRES_NS_E_WMP_MULTIPLE_ERROR_IN_PLAYLIST";
                break;
            case 0xC00D11E0:
                return "HRES_NS_E_WMP_IMAPI2_ERASE_FAIL";
                break;
            case 0xC00D11E1:
                return "HRES_NS_E_WMP_IMAPI2_ERASE_DEVICE_BUSY";
                break;
            case 0xC00D11E2:
                return "HRES_NS_E_WMP_DRM_COMPONENT_FAILURE";
                break;
            case 0xC00D11E3:
                return "HRES_NS_E_WMP_DRM_NO_DEVICE_CERT";
                break;
            case 0xC00D11E4:
                return "HRES_NS_E_WMP_SERVER_SECURITY_ERROR";
                break;
            case 0xC00D11E5:
                return "HRES_NS_E_WMP_AUDIO_DEVICE_LOST";
                break;
            case 0xC00D11E6:
                return "HRES_NS_E_WMP_IMAPI_MEDIA_INCOMPATIBLE";
                break;
            case 0xC00D11EE:
                return "HRES_NS_E_SYNCWIZ_DEVICE_FULL";
                break;
            case 0xC00D11EF:
                return "HRES_NS_E_SYNCWIZ_CANNOT_CHANGE_SETTINGS";
                break;
            case 0xC00D11F0:
                return "HRES_NS_E_TRANSCODE_DELETECACHEERROR";
                break;
            case 0xC00D11F8:
                return "HRES_NS_E_CD_NO_BUFFERS_READ";
                break;
            case 0xC00D11F9:
                return "HRES_NS_E_CD_EMPTY_TRACK_QUEUE";
                break;
            case 0xC00D11FA:
                return "HRES_NS_E_CD_NO_READER";
                break;
            case 0xC00D11FB:
                return "HRES_NS_E_CD_ISRC_INVALID";
                break;
            case 0xC00D11FC:
                return "HRES_NS_E_CD_MEDIA_CATALOG_NUMBER_INVALID";
                break;
            case 0xC00D11FD:
                return "HRES_NS_E_SLOW_READ_DIGITAL_WITH_ERRORCORRECTION";
                break;
            case 0xC00D11FE:
                return "HRES_NS_E_CD_SPEEDDETECT_NOT_ENOUGH_READS";
                break;
            case 0xC00D11FF:
                return "HRES_NS_E_CD_QUEUEING_DISABLED";
                break;
            case 0xC00D1202:
                return "HRES_NS_E_WMP_DRM_ACQUIRING_LICENSE";
                break;
            case 0xC00D1203:
                return "HRES_NS_E_WMP_DRM_LICENSE_EXPIRED";
                break;
            case 0xC00D1204:
                return "HRES_NS_E_WMP_DRM_LICENSE_NOTACQUIRED";
                break;
            case 0xC00D1205:
                return "HRES_NS_E_WMP_DRM_LICENSE_NOTENABLED";
                break;
            case 0xC00D1206:
                return "HRES_NS_E_WMP_DRM_LICENSE_UNUSABLE";
                break;
            case 0xC00D1207:
                return "HRES_NS_E_WMP_DRM_LICENSE_CONTENT_REVOKED";
                break;
            case 0xC00D1208:
                return "HRES_NS_E_WMP_DRM_LICENSE_NOSAP";
                break;
            case 0xC00D1209:
                return "HRES_NS_E_WMP_DRM_UNABLE_TO_ACQUIRE_LICENSE";
                break;
            case 0xC00D120A:
                return "HRES_NS_E_WMP_LICENSE_REQUIRED";
                break;
            case 0xC00D120B:
                return "HRES_NS_E_WMP_PROTECTED_CONTENT";
                break;
            case 0xC00D122A:
                return "HRES_NS_E_WMP_POLICY_VALUE_NOT_CONFIGURED";
                break;
            case 0xC00D1234:
                return "HRES_NS_E_PDA_CANNOT_SYNC_FROM_INTERNET";
                break;
            case 0xC00D1235:
                return "HRES_NS_E_PDA_CANNOT_SYNC_INVALID_PLAYLIST";
                break;
            case 0xC00D1236:
                return "HRES_NS_E_PDA_FAILED_TO_SYNCHRONIZE_FILE";
                break;
            case 0xC00D1237:
                return "HRES_NS_E_PDA_SYNC_FAILED";
                break;
            case 0xC00D1238:
                return "HRES_NS_E_PDA_DELETE_FAILED";
                break;
            case 0xC00D1239:
                return "HRES_NS_E_PDA_FAILED_TO_RETRIEVE_FILE";
                break;
            case 0xC00D123A:
                return "HRES_NS_E_PDA_DEVICE_NOT_RESPONDING";
                break;
            case 0xC00D123B:
                return "HRES_NS_E_PDA_FAILED_TO_TRANSCODE_PHOTO";
                break;
            case 0xC00D123C:
                return "HRES_NS_E_PDA_FAILED_TO_ENCRYPT_TRANSCODED_FILE";
                break;
            case 0xC00D123D:
                return "HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_AUDIO";
                break;
            case 0xC00D123E:
                return "HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_VIDEO";
                break;
            case 0xC00D123F:
                return "HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_IMAGE";
                break;
            case 0xC00D1240:
                return "HRES_NS_E_PDA_RETRIEVED_FILE_FILENAME_TOO_LONG";
                break;
            case 0xC00D1241:
                return "HRES_NS_E_PDA_CEWMDM_DRM_ERROR";
                break;
            case 0xC00D1242:
                return "HRES_NS_E_INCOMPLETE_PLAYLIST";
                break;
            case 0xC00D1243:
                return "HRES_NS_E_PDA_SYNC_RUNNING";
                break;
            case 0xC00D1244:
                return "HRES_NS_E_PDA_SYNC_LOGIN_ERROR";
                break;
            case 0xC00D1245:
                return "HRES_NS_E_PDA_TRANSCODE_CODEC_NOT_FOUND";
                break;
            case 0xC00D1246:
                return "HRES_NS_E_CANNOT_SYNC_DRM_TO_NON_JANUS_DEVICE";
                break;
            case 0xC00D1247:
                return "HRES_NS_E_CANNOT_SYNC_PREVIOUS_SYNC_RUNNING";
                break;
            case 0xC00D125C:
                return "HRES_NS_E_WMP_HWND_NOTFOUND";
                break;
            case 0xC00D125D:
                return "HRES_NS_E_BKGDOWNLOAD_WRONG_NO_FILES";
                break;
            case 0xC00D125E:
                return "HRES_NS_E_BKGDOWNLOAD_COMPLETECANCELLEDJOB";
                break;
            case 0xC00D125F:
                return "HRES_NS_E_BKGDOWNLOAD_CANCELCOMPLETEDJOB";
                break;
            case 0xC00D1260:
                return "HRES_NS_E_BKGDOWNLOAD_NOJOBPOINTER";
                break;
            case 0xC00D1261:
                return "HRES_NS_E_BKGDOWNLOAD_INVALIDJOBSIGNATURE";
                break;
            case 0xC00D1262:
                return "HRES_NS_E_BKGDOWNLOAD_FAILED_TO_CREATE_TEMPFILE";
                break;
            case 0xC00D1263:
                return "HRES_NS_E_BKGDOWNLOAD_PLUGIN_FAILEDINITIALIZE";
                break;
            case 0xC00D1264:
                return "HRES_NS_E_BKGDOWNLOAD_PLUGIN_FAILEDTOMOVEFILE";
                break;
            case 0xC00D1265:
                return "HRES_NS_E_BKGDOWNLOAD_CALLFUNCFAILED";
                break;
            case 0xC00D1266:
                return "HRES_NS_E_BKGDOWNLOAD_CALLFUNCTIMEOUT";
                break;
            case 0xC00D1267:
                return "HRES_NS_E_BKGDOWNLOAD_CALLFUNCENDED";
                break;
            case 0xC00D1268:
                return "HRES_NS_E_BKGDOWNLOAD_WMDUNPACKFAILED";
                break;
            case 0xC00D1269:
                return "HRES_NS_E_BKGDOWNLOAD_FAILEDINITIALIZE";
                break;
            case 0xC00D126A:
                return "HRES_NS_E_INTERFACE_NOT_REGISTERED_IN_GIT";
                break;
            case 0xC00D126B:
                return "HRES_NS_E_BKGDOWNLOAD_INVALID_FILE_NAME";
                break;
            case 0xC00D128E:
                return "HRES_NS_E_IMAGE_DOWNLOAD_FAILED";
                break;
            case 0xC00D12C0:
                return "HRES_NS_E_WMP_UDRM_NOUSERLIST";
                break;
            case 0xC00D12C1:
                return "HRES_NS_E_WMP_DRM_NOT_ACQUIRING";
                break;
            case 0xC00D12F2:
                return "HRES_NS_E_WMP_BSTR_TOO_LONG";
                break;
            case 0xC00D12FC:
                return "HRES_NS_E_WMP_AUTOPLAY_INVALID_STATE";
                break;
            case 0xC00D1306:
                return "HRES_NS_E_WMP_COMPONENT_REVOKED";
                break;
            case 0xC00D1324:
                return "HRES_NS_E_CURL_NOTSAFE";
                break;
            case 0xC00D1325:
                return "HRES_NS_E_CURL_INVALIDCHAR";
                break;
            case 0xC00D1326:
                return "HRES_NS_E_CURL_INVALIDHOSTNAME";
                break;
            case 0xC00D1327:
                return "HRES_NS_E_CURL_INVALIDPATH";
                break;
            case 0xC00D1328:
                return "HRES_NS_E_CURL_INVALIDSCHEME";
                break;
            case 0xC00D1329:
                return "HRES_NS_E_CURL_INVALIDURL";
                break;
            case 0xC00D132B:
                return "HRES_NS_E_CURL_CANTWALK";
                break;
            case 0xC00D132C:
                return "HRES_NS_E_CURL_INVALIDPORT";
                break;
            case 0xC00D132D:
                return "HRES_NS_E_CURLHELPER_NOTADIRECTORY";
                break;
            case 0xC00D132E:
                return "HRES_NS_E_CURLHELPER_NOTAFILE";
                break;
            case 0xC00D132F:
                return "HRES_NS_E_CURL_CANTDECODE";
                break;
            case 0xC00D1330:
                return "HRES_NS_E_CURLHELPER_NOTRELATIVE";
                break;
            case 0xC00D1331:
                return "HRES_NS_E_CURL_INVALIDBUFFERSIZE";
                break;
            case 0xC00D1356:
                return "HRES_NS_E_SUBSCRIPTIONSERVICE_PLAYBACK_DISALLOWED";
                break;
            case 0xC00D1357:
                return "HRES_NS_E_CANNOT_BUY_OR_DOWNLOAD_FROM_MULTIPLE_SERVICES";
                break;
            case 0xC00D1358:
                return "HRES_NS_E_CANNOT_BUY_OR_DOWNLOAD_CONTENT";
                break;
            case 0xC00D135A:
                return "HRES_NS_E_NOT_CONTENT_PARTNER_TRACK";
                break;
            case 0xC00D135B:
                return "HRES_NS_E_TRACK_DOWNLOAD_REQUIRES_ALBUM_PURCHASE";
                break;
            case 0xC00D135C:
                return "HRES_NS_E_TRACK_DOWNLOAD_REQUIRES_PURCHASE";
                break;
            case 0xC00D135D:
                return "HRES_NS_E_TRACK_PURCHASE_MAXIMUM_EXCEEDED";
                break;
            case 0xC00D135F:
                return "HRES_NS_E_SUBSCRIPTIONSERVICE_LOGIN_FAILED";
                break;
            case 0xC00D1360:
                return "HRES_NS_E_SUBSCRIPTIONSERVICE_DOWNLOAD_TIMEOUT";
                break;
            case 0xC00D1362:
                return "HRES_NS_E_CONTENT_PARTNER_STILL_INITIALIZING";
                break;
            case 0xC00D1363:
                return "HRES_NS_E_OPEN_CONTAINING_FOLDER_FAILED";
                break;
            case 0xC00D136A:
                return "HRES_NS_E_ADVANCEDEDIT_TOO_MANY_PICTURES";
                break;
            case 0xC00D1388:
                return "HRES_NS_E_REDIRECT";
                break;
            case 0xC00D1389:
                return "HRES_NS_E_STALE_PRESENTATION";
                break;
            case 0xC00D138A:
                return "HRES_NS_E_NAMESPACE_WRONG_PERSIST";
                break;
            case 0xC00D138B:
                return "HRES_NS_E_NAMESPACE_WRONG_TYPE";
                break;
            case 0xC00D138C:
                return "HRES_NS_E_NAMESPACE_NODE_CONFLICT";
                break;
            case 0xC00D138D:
                return "HRES_NS_E_NAMESPACE_NODE_NOT_FOUND";
                break;
            case 0xC00D138E:
                return "HRES_NS_E_NAMESPACE_BUFFER_TOO_SMALL";
                break;
            case 0xC00D138F:
                return "HRES_NS_E_NAMESPACE_TOO_MANY_CALLBACKS";
                break;
            case 0xC00D1390:
                return "HRES_NS_E_NAMESPACE_DUPLICATE_CALLBACK";
                break;
            case 0xC00D1391:
                return "HRES_NS_E_NAMESPACE_CALLBACK_NOT_FOUND";
                break;
            case 0xC00D1392:
                return "HRES_NS_E_NAMESPACE_NAME_TOO_LONG";
                break;
            case 0xC00D1393:
                return "HRES_NS_E_NAMESPACE_DUPLICATE_NAME";
                break;
            case 0xC00D1394:
                return "HRES_NS_E_NAMESPACE_EMPTY_NAME";
                break;
            case 0xC00D1395:
                return "HRES_NS_E_NAMESPACE_INDEX_TOO_LARGE";
                break;
            case 0xC00D1396:
                return "HRES_NS_E_NAMESPACE_BAD_NAME";
                break;
            case 0xC00D1397:
                return "HRES_NS_E_NAMESPACE_WRONG_SECURITY";
                break;
            case 0xC00D13EC:
                return "HRES_NS_E_CACHE_ARCHIVE_CONFLICT";
                break;
            case 0xC00D13ED:
                return "HRES_NS_E_CACHE_ORIGIN_SERVER_NOT_FOUND";
                break;
            case 0xC00D13EE:
                return "HRES_NS_E_CACHE_ORIGIN_SERVER_TIMEOUT";
                break;
            case 0xC00D13EF:
                return "HRES_NS_E_CACHE_NOT_BROADCAST";
                break;
            case 0xC00D13F0:
                return "HRES_NS_E_CACHE_CANNOT_BE_CACHED";
                break;
            case 0xC00D13F1:
                return "HRES_NS_E_CACHE_NOT_MODIFIED";
                break;
            case 0xC00D1450:
                return "HRES_NS_E_CANNOT_REMOVE_PUBLISHING_POINT";
                break;
            case 0xC00D1451:
                return "HRES_NS_E_CANNOT_REMOVE_PLUGIN";
                break;
            case 0xC00D1452:
                return "HRES_NS_E_WRONG_PUBLISHING_POINT_TYPE";
                break;
            case 0xC00D1453:
                return "HRES_NS_E_UNSUPPORTED_LOAD_TYPE";
                break;
            case 0xC00D1454:
                return "HRES_NS_E_INVALID_PLUGIN_LOAD_TYPE_CONFIGURATION";
                break;
            case 0xC00D1455:
                return "HRES_NS_E_INVALID_PUBLISHING_POINT_NAME";
                break;
            case 0xC00D1456:
                return "HRES_NS_E_TOO_MANY_MULTICAST_SINKS";
                break;
            case 0xC00D1457:
                return "HRES_NS_E_PUBLISHING_POINT_INVALID_REQUEST_WHILE_STARTED";
                break;
            case 0xC00D1458:
                return "HRES_NS_E_MULTICAST_PLUGIN_NOT_ENABLED";
                break;
            case 0xC00D1459:
                return "HRES_NS_E_INVALID_OPERATING_SYSTEM_VERSION";
                break;
            case 0xC00D145A:
                return "HRES_NS_E_PUBLISHING_POINT_REMOVED";
                break;
            case 0xC00D145B:
                return "HRES_NS_E_INVALID_PUSH_PUBLISHING_POINT_START_REQUEST";
                break;
            case 0xC00D145C:
                return "HRES_NS_E_UNSUPPORTED_LANGUAGE";
                break;
            case 0xC00D145D:
                return "HRES_NS_E_WRONG_OS_VERSION";
                break;
            case 0xC00D145E:
                return "HRES_NS_E_PUBLISHING_POINT_STOPPED";
                break;
            case 0xC00D14B4:
                return "HRES_NS_E_PLAYLIST_ENTRY_ALREADY_PLAYING";
                break;
            case 0xC00D14B5:
                return "HRES_NS_E_EMPTY_PLAYLIST";
                break;
            case 0xC00D14B6:
                return "HRES_NS_E_PLAYLIST_PARSE_FAILURE";
                break;
            case 0xC00D14B7:
                return "HRES_NS_E_PLAYLIST_UNSUPPORTED_ENTRY";
                break;
            case 0xC00D14B8:
                return "HRES_NS_E_PLAYLIST_ENTRY_NOT_IN_PLAYLIST";
                break;
            case 0xC00D14B9:
                return "HRES_NS_E_PLAYLIST_ENTRY_SEEK";
                break;
            case 0xC00D14BA:
                return "HRES_NS_E_PLAYLIST_RECURSIVE_PLAYLISTS";
                break;
            case 0xC00D14BB:
                return "HRES_NS_E_PLAYLIST_TOO_MANY_NESTED_PLAYLISTS";
                break;
            case 0xC00D14BC:
                return "HRES_NS_E_PLAYLIST_SHUTDOWN";
                break;
            case 0xC00D14BD:
                return "HRES_NS_E_PLAYLIST_END_RECEDING";
                break;
            case 0xC00D1518:
                return "HRES_NS_E_DATAPATH_NO_SINK";
                break;
            case 0xC00D151A:
                return "HRES_NS_E_INVALID_PUSH_TEMPLATE";
                break;
            case 0xC00D151B:
                return "HRES_NS_E_INVALID_PUSH_PUBLISHING_POINT";
                break;
            case 0xC00D151C:
                return "HRES_NS_E_CRITICAL_ERROR";
                break;
            case 0xC00D151D:
                return "HRES_NS_E_NO_NEW_CONNECTIONS";
                break;
            case 0xC00D151E:
                return "HRES_NS_E_WSX_INVALID_VERSION";
                break;
            case 0xC00D151F:
                return "HRES_NS_E_HEADER_MISMATCH";
                break;
            case 0xC00D1520:
                return "HRES_NS_E_PUSH_DUPLICATE_PUBLISHING_POINT_NAME";
                break;
            case 0xC00D157C:
                return "HRES_NS_E_NO_SCRIPT_ENGINE";
                break;
            case 0xC00D157D:
                return "HRES_NS_E_PLUGIN_ERROR_REPORTED";
                break;
            case 0xC00D157E:
                return "HRES_NS_E_SOURCE_PLUGIN_NOT_FOUND";
                break;
            case 0xC00D157F:
                return "HRES_NS_E_PLAYLIST_PLUGIN_NOT_FOUND";
                break;
            case 0xC00D1580:
                return "HRES_NS_E_DATA_SOURCE_ENUMERATION_NOT_SUPPORTED";
                break;
            case 0xC00D1581:
                return "HRES_NS_E_MEDIA_PARSER_INVALID_FORMAT";
                break;
            case 0xC00D1582:
                return "HRES_NS_E_SCRIPT_DEBUGGER_NOT_INSTALLED";
                break;
            case 0xC00D1583:
                return "HRES_NS_E_FEATURE_REQUIRES_ENTERPRISE_SERVER";
                break;
            case 0xC00D1584:
                return "HRES_NS_E_WIZARD_RUNNING";
                break;
            case 0xC00D1585:
                return "HRES_NS_E_INVALID_LOG_URL";
                break;
            case 0xC00D1586:
                return "HRES_NS_E_INVALID_MTU_RANGE";
                break;
            case 0xC00D1587:
                return "HRES_NS_E_INVALID_PLAY_STATISTICS";
                break;
            case 0xC00D1588:
                return "HRES_NS_E_LOG_NEED_TO_BE_SKIPPED";
                break;
            case 0xC00D1589:
                return "HRES_NS_E_HTTP_TEXT_DATACONTAINER_SIZE_LIMIT_EXCEEDED";
                break;
            case 0xC00D158A:
                return "HRES_NS_E_PORT_IN_USE";
                break;
            case 0xC00D158B:
                return "HRES_NS_E_PORT_IN_USE_HTTP";
                break;
            case 0xC00D158C:
                return "HRES_NS_E_HTTP_TEXT_DATACONTAINER_INVALID_SERVER_RESPONSE";
                break;
            case 0xC00D158D:
                return "HRES_NS_E_ARCHIVE_REACH_QUOTA";
                break;
            case 0xC00D158E:
                return "HRES_NS_E_ARCHIVE_ABORT_DUE_TO_BCAST";
                break;
            case 0xC00D158F:
                return "HRES_NS_E_ARCHIVE_GAP_DETECTED";
                break;
            case 0xC00D1590:
                return "HRES_NS_E_AUTHORIZATION_FILE_NOT_FOUND";
                break;
            case 0xC00D1B58:
                return "HRES_NS_E_BAD_MARKIN";
                break;
            case 0xC00D1B59:
                return "HRES_NS_E_BAD_MARKOUT";
                break;
            case 0xC00D1B5A:
                return "HRES_NS_E_NOMATCHING_MEDIASOURCE";
                break;
            case 0xC00D1B5B:
                return "HRES_NS_E_UNSUPPORTED_SOURCETYPE";
                break;
            case 0xC00D1B5C:
                return "HRES_NS_E_TOO_MANY_AUDIO";
                break;
            case 0xC00D1B5D:
                return "HRES_NS_E_TOO_MANY_VIDEO";
                break;
            case 0xC00D1B5E:
                return "HRES_NS_E_NOMATCHING_ELEMENT";
                break;
            case 0xC00D1B5F:
                return "HRES_NS_E_MISMATCHED_MEDIACONTENT";
                break;
            case 0xC00D1B60:
                return "HRES_NS_E_CANNOT_DELETE_ACTIVE_SOURCEGROUP";
                break;
            case 0xC00D1B61:
                return "HRES_NS_E_AUDIODEVICE_BUSY";
                break;
            case 0xC00D1B62:
                return "HRES_NS_E_AUDIODEVICE_UNEXPECTED";
                break;
            case 0xC00D1B63:
                return "HRES_NS_E_AUDIODEVICE_BADFORMAT";
                break;
            case 0xC00D1B64:
                return "HRES_NS_E_VIDEODEVICE_BUSY";
                break;
            case 0xC00D1B65:
                return "HRES_NS_E_VIDEODEVICE_UNEXPECTED";
                break;
            case 0xC00D1B66:
                return "HRES_NS_E_INVALIDCALL_WHILE_ENCODER_RUNNING";
                break;
            case 0xC00D1B67:
                return "HRES_NS_E_NO_PROFILE_IN_SOURCEGROUP";
                break;
            case 0xC00D1B68:
                return "HRES_NS_E_VIDEODRIVER_UNSTABLE";
                break;
            case 0xC00D1B69:
                return "HRES_NS_E_VIDCAPSTARTFAILED";
                break;
            case 0xC00D1B6A:
                return "HRES_NS_E_VIDSOURCECOMPRESSION";
                break;
            case 0xC00D1B6B:
                return "HRES_NS_E_VIDSOURCESIZE";
                break;
            case 0xC00D1B6C:
                return "HRES_NS_E_ICMQUERYFORMAT";
                break;
            case 0xC00D1B6D:
                return "HRES_NS_E_VIDCAPCREATEWINDOW";
                break;
            case 0xC00D1B6E:
                return "HRES_NS_E_VIDCAPDRVINUSE";
                break;
            case 0xC00D1B6F:
                return "HRES_NS_E_NO_MEDIAFORMAT_IN_SOURCE";
                break;
            case 0xC00D1B70:
                return "HRES_NS_E_NO_VALID_OUTPUT_STREAM";
                break;
            case 0xC00D1B71:
                return "HRES_NS_E_NO_VALID_SOURCE_PLUGIN";
                break;
            case 0xC00D1B72:
                return "HRES_NS_E_NO_ACTIVE_SOURCEGROUP";
                break;
            case 0xC00D1B73:
                return "HRES_NS_E_NO_SCRIPT_STREAM";
                break;
            case 0xC00D1B74:
                return "HRES_NS_E_INVALIDCALL_WHILE_ARCHIVAL_RUNNING";
                break;
            case 0xC00D1B75:
                return "HRES_NS_E_INVALIDPACKETSIZE";
                break;
            case 0xC00D1B76:
                return "HRES_NS_E_PLUGIN_CLSID_INVALID";
                break;
            case 0xC00D1B77:
                return "HRES_NS_E_UNSUPPORTED_ARCHIVETYPE";
                break;
            case 0xC00D1B78:
                return "HRES_NS_E_UNSUPPORTED_ARCHIVEOPERATION";
                break;
            case 0xC00D1B79:
                return "HRES_NS_E_ARCHIVE_FILENAME_NOTSET";
                break;
            case 0xC00D1B7A:
                return "HRES_NS_E_SOURCEGROUP_NOTPREPARED";
                break;
            case 0xC00D1B7B:
                return "HRES_NS_E_PROFILE_MISMATCH";
                break;
            case 0xC00D1B7C:
                return "HRES_NS_E_INCORRECTCLIPSETTINGS";
                break;
            case 0xC00D1B7D:
                return "HRES_NS_E_NOSTATSAVAILABLE";
                break;
            case 0xC00D1B7E:
                return "HRES_NS_E_NOTARCHIVING";
                break;
            case 0xC00D1B7F:
                return "HRES_NS_E_INVALIDCALL_WHILE_ENCODER_STOPPED";
                break;
            case 0xC00D1B80:
                return "HRES_NS_E_NOSOURCEGROUPS";
                break;
            case 0xC00D1B81:
                return "HRES_NS_E_INVALIDINPUTFPS";
                break;
            case 0xC00D1B82:
                return "HRES_NS_E_NO_DATAVIEW_SUPPORT";
                break;
            case 0xC00D1B83:
                return "HRES_NS_E_CODEC_UNAVAILABLE";
                break;
            case 0xC00D1B84:
                return "HRES_NS_E_ARCHIVE_SAME_AS_INPUT";
                break;
            case 0xC00D1B85:
                return "HRES_NS_E_SOURCE_NOTSPECIFIED";
                break;
            case 0xC00D1B86:
                return "HRES_NS_E_NO_REALTIME_TIMECOMPRESSION";
                break;
            case 0xC00D1B87:
                return "HRES_NS_E_UNSUPPORTED_ENCODER_DEVICE";
                break;
            case 0xC00D1B88:
                return "HRES_NS_E_UNEXPECTED_DISPLAY_SETTINGS";
                break;
            case 0xC00D1B89:
                return "HRES_NS_E_NO_AUDIODATA";
                break;
            case 0xC00D1B8A:
                return "HRES_NS_E_INPUTSOURCE_PROBLEM";
                break;
            case 0xC00D1B8B:
                return "HRES_NS_E_WME_VERSION_MISMATCH";
                break;
            case 0xC00D1B8C:
                return "HRES_NS_E_NO_REALTIME_PREPROCESS";
                break;
            case 0xC00D1B8D:
                return "HRES_NS_E_NO_REPEAT_PREPROCESS";
                break;
            case 0xC00D1B8E:
                return "HRES_NS_E_CANNOT_PAUSE_LIVEBROADCAST";
                break;
            case 0xC00D1B8F:
                return "HRES_NS_E_DRM_PROFILE_NOT_SET";
                break;
            case 0xC00D1B90:
                return "HRES_NS_E_DUPLICATE_DRMPROFILE";
                break;
            case 0xC00D1B91:
                return "HRES_NS_E_INVALID_DEVICE";
                break;
            case 0xC00D1B92:
                return "HRES_NS_E_SPEECHEDL_ON_NON_MIXEDMODE";
                break;
            case 0xC00D1B93:
                return "HRES_NS_E_DRM_PASSWORD_TOO_LONG";
                break;
            case 0xC00D1B94:
                return "HRES_NS_E_DEVCONTROL_FAILED_SEEK";
                break;
            case 0xC00D1B95:
                return "HRES_NS_E_INTERLACE_REQUIRE_SAMESIZE";
                break;
            case 0xC00D1B96:
                return "HRES_NS_E_TOO_MANY_DEVICECONTROL";
                break;
            case 0xC00D1B97:
                return "HRES_NS_E_NO_MULTIPASS_FOR_LIVEDEVICE";
                break;
            case 0xC00D1B98:
                return "HRES_NS_E_MISSING_AUDIENCE";
                break;
            case 0xC00D1B99:
                return "HRES_NS_E_AUDIENCE_CONTENTTYPE_MISMATCH";
                break;
            case 0xC00D1B9A:
                return "HRES_NS_E_MISSING_SOURCE_INDEX";
                break;
            case 0xC00D1B9B:
                return "HRES_NS_E_NUM_LANGUAGE_MISMATCH";
                break;
            case 0xC00D1B9C:
                return "HRES_NS_E_LANGUAGE_MISMATCH";
                break;
            case 0xC00D1B9D:
                return "HRES_NS_E_VBRMODE_MISMATCH";
                break;
            case 0xC00D1B9E:
                return "HRES_NS_E_INVALID_INPUT_AUDIENCE_INDEX";
                break;
            case 0xC00D1B9F:
                return "HRES_NS_E_INVALID_INPUT_LANGUAGE";
                break;
            case 0xC00D1BA0:
                return "HRES_NS_E_INVALID_INPUT_STREAM";
                break;
            case 0xC00D1BA1:
                return "HRES_NS_E_EXPECT_MONO_WAV_INPUT";
                break;
            case 0xC00D1BA2:
                return "HRES_NS_E_INPUT_WAVFORMAT_MISMATCH";
                break;
            case 0xC00D1BA3:
                return "HRES_NS_E_RECORDQ_DISK_FULL";
                break;
            case 0xC00D1BA4:
                return "HRES_NS_E_NO_PAL_INVERSE_TELECINE";
                break;
            case 0xC00D1BA5:
                return "HRES_NS_E_ACTIVE_SG_DEVICE_DISCONNECTED";
                break;
            case 0xC00D1BA6:
                return "HRES_NS_E_ACTIVE_SG_DEVICE_CONTROL_DISCONNECTED";
                break;
            case 0xC00D1BA7:
                return "HRES_NS_E_NO_FRAMES_SUBMITTED_TO_ANALYZER";
                break;
            case 0xC00D1BA8:
                return "HRES_NS_E_INPUT_DOESNOT_SUPPORT_SMPTE";
                break;
            case 0xC00D1BA9:
                return "HRES_NS_E_NO_SMPTE_WITH_MULTIPLE_SOURCEGROUPS";
                break;
            case 0xC00D1BAA:
                return "HRES_NS_E_BAD_CONTENTEDL";
                break;
            case 0xC00D1BAB:
                return "HRES_NS_E_INTERLACEMODE_MISMATCH";
                break;
            case 0xC00D1BAC:
                return "HRES_NS_E_NONSQUAREPIXELMODE_MISMATCH";
                break;
            case 0xC00D1BAD:
                return "HRES_NS_E_SMPTEMODE_MISMATCH";
                break;
            case 0xC00D1BAE:
                return "HRES_NS_E_END_OF_TAPE";
                break;
            case 0xC00D1BAF:
                return "HRES_NS_E_NO_MEDIA_IN_AUDIENCE";
                break;
            case 0xC00D1BB0:
                return "HRES_NS_E_NO_AUDIENCES";
                break;
            case 0xC00D1BB1:
                return "HRES_NS_E_NO_AUDIO_COMPAT";
                break;
            case 0xC00D1BB2:
                return "HRES_NS_E_INVALID_VBR_COMPAT";
                break;
            case 0xC00D1BB3:
                return "HRES_NS_E_NO_PROFILE_NAME";
                break;
            case 0xC00D1BB4:
                return "HRES_NS_E_INVALID_VBR_WITH_UNCOMP";
                break;
            case 0xC00D1BB5:
                return "HRES_NS_E_MULTIPLE_VBR_AUDIENCES";
                break;
            case 0xC00D1BB6:
                return "HRES_NS_E_UNCOMP_COMP_COMBINATION";
                break;
            case 0xC00D1BB7:
                return "HRES_NS_E_MULTIPLE_AUDIO_CODECS";
                break;
            case 0xC00D1BB8:
                return "HRES_NS_E_MULTIPLE_AUDIO_FORMATS";
                break;
            case 0xC00D1BB9:
                return "HRES_NS_E_AUDIO_BITRATE_STEPDOWN";
                break;
            case 0xC00D1BBA:
                return "HRES_NS_E_INVALID_AUDIO_PEAKRATE";
                break;
            case 0xC00D1BBB:
                return "HRES_NS_E_INVALID_AUDIO_PEAKRATE_2";
                break;
            case 0xC00D1BBC:
                return "HRES_NS_E_INVALID_AUDIO_BUFFERMAX";
                break;
            case 0xC00D1BBD:
                return "HRES_NS_E_MULTIPLE_VIDEO_CODECS";
                break;
            case 0xC00D1BBE:
                return "HRES_NS_E_MULTIPLE_VIDEO_SIZES";
                break;
            case 0xC00D1BBF:
                return "HRES_NS_E_INVALID_VIDEO_BITRATE";
                break;
            case 0xC00D1BC0:
                return "HRES_NS_E_VIDEO_BITRATE_STEPDOWN";
                break;
            case 0xC00D1BC1:
                return "HRES_NS_E_INVALID_VIDEO_PEAKRATE";
                break;
            case 0xC00D1BC2:
                return "HRES_NS_E_INVALID_VIDEO_PEAKRATE_2";
                break;
            case 0xC00D1BC3:
                return "HRES_NS_E_INVALID_VIDEO_WIDTH";
                break;
            case 0xC00D1BC4:
                return "HRES_NS_E_INVALID_VIDEO_HEIGHT";
                break;
            case 0xC00D1BC5:
                return "HRES_NS_E_INVALID_VIDEO_FPS";
                break;
            case 0xC00D1BC6:
                return "HRES_NS_E_INVALID_VIDEO_KEYFRAME";
                break;
            case 0xC00D1BC7:
                return "HRES_NS_E_INVALID_VIDEO_IQUALITY";
                break;
            case 0xC00D1BC8:
                return "HRES_NS_E_INVALID_VIDEO_CQUALITY";
                break;
            case 0xC00D1BC9:
                return "HRES_NS_E_INVALID_VIDEO_BUFFER";
                break;
            case 0xC00D1BCA:
                return "HRES_NS_E_INVALID_VIDEO_BUFFERMAX";
                break;
            case 0xC00D1BCB:
                return "HRES_NS_E_INVALID_VIDEO_BUFFERMAX_2";
                break;
            case 0xC00D1BCC:
                return "HRES_NS_E_INVALID_VIDEO_WIDTH_ALIGN";
                break;
            case 0xC00D1BCD:
                return "HRES_NS_E_INVALID_VIDEO_HEIGHT_ALIGN";
                break;
            case 0xC00D1BCE:
                return "HRES_NS_E_MULTIPLE_SCRIPT_BITRATES";
                break;
            case 0xC00D1BCF:
                return "HRES_NS_E_INVALID_SCRIPT_BITRATE";
                break;
            case 0xC00D1BD0:
                return "HRES_NS_E_MULTIPLE_FILE_BITRATES";
                break;
            case 0xC00D1BD1:
                return "HRES_NS_E_INVALID_FILE_BITRATE";
                break;
            case 0xC00D1BD2:
                return "HRES_NS_E_SAME_AS_INPUT_COMBINATION";
                break;
            case 0xC00D1BD3:
                return "HRES_NS_E_SOURCE_CANNOT_LOOP";
                break;
            case 0xC00D1BD4:
                return "HRES_NS_E_INVALID_FOLDDOWN_COEFFICIENTS";
                break;
            case 0xC00D1BD5:
                return "HRES_NS_E_DRMPROFILE_NOTFOUND";
                break;
            case 0xC00D1BD6:
                return "HRES_NS_E_INVALID_TIMECODE";
                break;
            case 0xC00D1BD7:
                return "HRES_NS_E_NO_AUDIO_TIMECOMPRESSION";
                break;
            case 0xC00D1BD8:
                return "HRES_NS_E_NO_TWOPASS_TIMECOMPRESSION";
                break;
            case 0xC00D1BD9:
                return "HRES_NS_E_TIMECODE_REQUIRES_VIDEOSTREAM";
                break;
            case 0xC00D1BDA:
                return "HRES_NS_E_NO_MBR_WITH_TIMECODE";
                break;
            case 0xC00D1BDB:
                return "HRES_NS_E_INVALID_INTERLACEMODE";
                break;
            case 0xC00D1BDC:
                return "HRES_NS_E_INVALID_INTERLACE_COMPAT";
                break;
            case 0xC00D1BDD:
                return "HRES_NS_E_INVALID_NONSQUAREPIXEL_COMPAT";
                break;
            case 0xC00D1BDE:
                return "HRES_NS_E_INVALID_SOURCE_WITH_DEVICE_CONTROL";
                break;
            case 0xC00D1BDF:
                return "HRES_NS_E_CANNOT_GENERATE_BROADCAST_INFO_FOR_QUALITYVBR";
                break;
            case 0xC00D1BE0:
                return "HRES_NS_E_EXCEED_MAX_DRM_PROFILE_LIMIT";
                break;
            case 0xC00D1BE1:
                return "HRES_NS_E_DEVICECONTROL_UNSTABLE";
                break;
            case 0xC00D1BE2:
                return "HRES_NS_E_INVALID_PIXEL_ASPECT_RATIO";
                break;
            case 0xC00D1BE3:
                return "HRES_NS_E_AUDIENCE__LANGUAGE_CONTENTTYPE_MISMATCH";
                break;
            case 0xC00D1BE4:
                return "HRES_NS_E_INVALID_PROFILE_CONTENTTYPE";
                break;
            case 0xC00D1BE5:
                return "HRES_NS_E_TRANSFORM_PLUGIN_NOT_FOUND";
                break;
            case 0xC00D1BE6:
                return "HRES_NS_E_TRANSFORM_PLUGIN_INVALID";
                break;
            case 0xC00D1BE7:
                return "HRES_NS_E_EDL_REQUIRED_FOR_DEVICE_MULTIPASS";
                break;
            case 0xC00D1BE8:
                return "HRES_NS_E_INVALID_VIDEO_WIDTH_FOR_INTERLACED_ENCODING";
                break;
            case 0xC00D1BE9:
                return "HRES_NS_E_MARKIN_UNSUPPORTED";
                break;
            case 0xC00D2711:
                return "HRES_NS_E_DRM_INVALID_APPLICATION";
                break;
            case 0xC00D2712:
                return "HRES_NS_E_DRM_LICENSE_STORE_ERROR";
                break;
            case 0xC00D2713:
                return "HRES_NS_E_DRM_SECURE_STORE_ERROR";
                break;
            case 0xC00D2714:
                return "HRES_NS_E_DRM_LICENSE_STORE_SAVE_ERROR";
                break;
            case 0xC00D2715:
                return "HRES_NS_E_DRM_SECURE_STORE_UNLOCK_ERROR";
                break;
            case 0xC00D2716:
                return "HRES_NS_E_DRM_INVALID_CONTENT";
                break;
            case 0xC00D2717:
                return "HRES_NS_E_DRM_UNABLE_TO_OPEN_LICENSE";
                break;
            case 0xC00D2718:
                return "HRES_NS_E_DRM_INVALID_LICENSE";
                break;
            case 0xC00D2719:
                return "HRES_NS_E_DRM_INVALID_MACHINE";
                break;
            case 0xC00D271B:
                return "HRES_NS_E_DRM_ENUM_LICENSE_FAILED";
                break;
            case 0xC00D271C:
                return "HRES_NS_E_DRM_INVALID_LICENSE_REQUEST";
                break;
            case 0xC00D271D:
                return "HRES_NS_E_DRM_UNABLE_TO_INITIALIZE";
                break;
            case 0xC00D271E:
                return "HRES_NS_E_DRM_UNABLE_TO_ACQUIRE_LICENSE";
                break;
            case 0xC00D271F:
                return "HRES_NS_E_DRM_INVALID_LICENSE_ACQUIRED";
                break;
            case 0xC00D2720:
                return "HRES_NS_E_DRM_NO_RIGHTS";
                break;
            case 0xC00D2721:
                return "HRES_NS_E_DRM_KEY_ERROR";
                break;
            case 0xC00D2722:
                return "HRES_NS_E_DRM_ENCRYPT_ERROR";
                break;
            case 0xC00D2723:
                return "HRES_NS_E_DRM_DECRYPT_ERROR";
                break;
            case 0xC00D2725:
                return "HRES_NS_E_DRM_LICENSE_INVALID_XML";
                break;
            case 0xC00D2728:
                return "HRES_NS_E_DRM_NEEDS_INDIVIDUALIZATION";
                break;
            case 0xC00D2729:
                return "HRES_NS_E_DRM_ALREADY_INDIVIDUALIZED";
                break;
            case 0xC00D272A:
                return "HRES_NS_E_DRM_ACTION_NOT_QUERIED";
                break;
            case 0xC00D272B:
                return "HRES_NS_E_DRM_ACQUIRING_LICENSE";
                break;
            case 0xC00D272C:
                return "HRES_NS_E_DRM_INDIVIDUALIZING";
                break;
            case 0xC00D272D:
                return "HRES_NS_E_BACKUP_RESTORE_FAILURE";
                break;
            case 0xC00D272E:
                return "HRES_NS_E_BACKUP_RESTORE_BAD_REQUEST_ID";
                break;
            case 0xC00D272F:
                return "HRES_NS_E_DRM_PARAMETERS_MISMATCHED";
                break;
            case 0xC00D2730:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_LICENSE_OBJECT";
                break;
            case 0xC00D2731:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_INDI_OBJECT";
                break;
            case 0xC00D2732:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_ENCRYPT_OBJECT";
                break;
            case 0xC00D2733:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_DECRYPT_OBJECT";
                break;
            case 0xC00D2734:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_PROPERTIES_OBJECT";
                break;
            case 0xC00D2735:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_BACKUP_OBJECT";
                break;
            case 0xC00D2736:
                return "HRES_NS_E_DRM_INDIVIDUALIZE_ERROR";
                break;
            case 0xC00D2737:
                return "HRES_NS_E_DRM_LICENSE_OPEN_ERROR";
                break;
            case 0xC00D2738:
                return "HRES_NS_E_DRM_LICENSE_CLOSE_ERROR";
                break;
            case 0xC00D2739:
                return "HRES_NS_E_DRM_GET_LICENSE_ERROR";
                break;
            case 0xC00D273A:
                return "HRES_NS_E_DRM_QUERY_ERROR";
                break;
            case 0xC00D273B:
                return "HRES_NS_E_DRM_REPORT_ERROR";
                break;
            case 0xC00D273C:
                return "HRES_NS_E_DRM_GET_LICENSESTRING_ERROR";
                break;
            case 0xC00D273D:
                return "HRES_NS_E_DRM_GET_CONTENTSTRING_ERROR";
                break;
            case 0xC00D273E:
                return "HRES_NS_E_DRM_MONITOR_ERROR";
                break;
            case 0xC00D273F:
                return "HRES_NS_E_DRM_UNABLE_TO_SET_PARAMETER";
                break;
            case 0xC00D2740:
                return "HRES_NS_E_DRM_INVALID_APPDATA";
                break;
            case 0xC00D2741:
                return "HRES_NS_E_DRM_INVALID_APPDATA_VERSION";
                break;
            case 0xC00D2742:
                return "HRES_NS_E_DRM_BACKUP_EXISTS";
                break;
            case 0xC00D2743:
                return "HRES_NS_E_DRM_BACKUP_CORRUPT";
                break;
            case 0xC00D2744:
                return "HRES_NS_E_DRM_BACKUPRESTORE_BUSY";
                break;
            case 0xC00D2745:
                return "HRES_NS_E_BACKUP_RESTORE_BAD_DATA";
                break;
            case 0xC00D2748:
                return "HRES_NS_E_DRM_LICENSE_UNUSABLE";
                break;
            case 0xC00D2749:
                return "HRES_NS_E_DRM_INVALID_PROPERTY";
                break;
            case 0xC00D274A:
                return "HRES_NS_E_DRM_SECURE_STORE_NOT_FOUND";
                break;
            case 0xC00D274B:
                return "HRES_NS_E_DRM_CACHED_CONTENT_ERROR";
                break;
            case 0xC00D274C:
                return "HRES_NS_E_DRM_INDIVIDUALIZATION_INCOMPLETE";
                break;
            case 0xC00D274D:
                return "HRES_NS_E_DRM_DRIVER_AUTH_FAILURE";
                break;
            case 0xC00D274E:
                return "HRES_NS_E_DRM_NEED_UPGRADE_MSSAP";
                break;
            case 0xC00D274F:
                return "HRES_NS_E_DRM_REOPEN_CONTENT";
                break;
            case 0xC00D2750:
                return "HRES_NS_E_DRM_DRIVER_DIGIOUT_FAILURE";
                break;
            case 0xC00D2751:
                return "HRES_NS_E_DRM_INVALID_SECURESTORE_PASSWORD";
                break;
            case 0xC00D2752:
                return "HRES_NS_E_DRM_APPCERT_REVOKED";
                break;
            case 0xC00D2753:
                return "HRES_NS_E_DRM_RESTORE_FRAUD";
                break;
            case 0xC00D2754:
                return "HRES_NS_E_DRM_HARDWARE_INCONSISTENT";
                break;
            case 0xC00D2755:
                return "HRES_NS_E_DRM_SDMI_TRIGGER";
                break;
            case 0xC00D2756:
                return "HRES_NS_E_DRM_SDMI_NOMORECOPIES";
                break;
            case 0xC00D2757:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_HEADER_OBJECT";
                break;
            case 0xC00D2758:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_KEYS_OBJECT";
                break;
            case 0xC00D2759:
                return "HRES_NS_E_DRM_LICENSE_NOTACQUIRED";
                break;
            case 0xC00D275A:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_CODING_OBJECT";
                break;
            case 0xC00D275B:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_STATE_DATA_OBJECT";
                break;
            case 0xC00D275C:
                return "HRES_NS_E_DRM_BUFFER_TOO_SMALL";
                break;
            case 0xC00D275D:
                return "HRES_NS_E_DRM_UNSUPPORTED_PROPERTY";
                break;
            case 0xC00D275E:
                return "HRES_NS_E_DRM_ERROR_BAD_NET_RESP";
                break;
            case 0xC00D275F:
                return "HRES_NS_E_DRM_STORE_NOTALLSTORED";
                break;
            case 0xC00D2760:
                return "HRES_NS_E_DRM_SECURITY_COMPONENT_SIGNATURE_INVALID";
                break;
            case 0xC00D2761:
                return "HRES_NS_E_DRM_INVALID_DATA";
                break;
            case 0xC00D2762:
                return "HRES_NS_E_DRM_POLICY_DISABLE_ONLINE";
                break;
            case 0xC00D2763:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_AUTHENTICATION_OBJECT";
                break;
            case 0xC00D2764:
                return "HRES_NS_E_DRM_NOT_CONFIGURED";
                break;
            case 0xC00D2765:
                return "HRES_NS_E_DRM_DEVICE_ACTIVATION_CANCELED";
                break;
            case 0xC00D2766:
                return "HRES_NS_E_BACKUP_RESTORE_TOO_MANY_RESETS";
                break;
            case 0xC00D2767:
                return "HRES_NS_E_DRM_DEBUGGING_NOT_ALLOWED";
                break;
            case 0xC00D2768:
                return "HRES_NS_E_DRM_OPERATION_CANCELED";
                break;
            case 0xC00D2769:
                return "HRES_NS_E_DRM_RESTRICTIONS_NOT_RETRIEVED";
                break;
            case 0xC00D276A:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_OBJECT";
                break;
            case 0xC00D276B:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_BURN_OBJECT";
                break;
            case 0xC00D276C:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_DEVICE_REGISTRATION_OBJECT";
                break;
            case 0xC00D276D:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_METERING_OBJECT";
                break;
            case 0xC00D2770:
                return "HRES_NS_E_DRM_TRACK_EXCEEDED_PLAYLIST_RESTICTION";
                break;
            case 0xC00D2771:
                return "HRES_NS_E_DRM_TRACK_EXCEEDED_TRACKBURN_RESTRICTION";
                break;
            case 0xC00D2772:
                return "HRES_NS_E_DRM_UNABLE_TO_GET_DEVICE_CERT";
                break;
            case 0xC00D2773:
                return "HRES_NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK";
                break;
            case 0xC00D2774:
                return "HRES_NS_E_DRM_UNABLE_TO_SET_SECURE_CLOCK";
                break;
            case 0xC00D2775:
                return "HRES_NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK_FROM_SERVER";
                break;
            case 0xC00D2776:
                return "HRES_NS_E_DRM_POLICY_METERING_DISABLED";
                break;
            case 0xC00D2777:
                return "HRES_NS_E_DRM_TRANSFER_CHAINED_LICENSES_UNSUPPORTED";
                break;
            case 0xC00D2778:
                return "HRES_NS_E_DRM_SDK_VERSIONMISMATCH";
                break;
            case 0xC00D2779:
                return "HRES_NS_E_DRM_LIC_NEEDS_DEVICE_CLOCK_SET";
                break;
            case 0xC00D277A:
                return "HRES_NS_E_LICENSE_HEADER_MISSING_URL";
                break;
            case 0xC00D277B:
                return "HRES_NS_E_DEVICE_NOT_WMDRM_DEVICE";
                break;
            case 0xC00D277C:
                return "HRES_NS_E_DRM_INVALID_APPCERT";
                break;
            case 0xC00D277D:
                return "HRES_NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_PETITION";
                break;
            case 0xC00D277E:
                return "HRES_NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_CHALLENGE";
                break;
            case 0xC00D277F:
                return "HRES_NS_E_DRM_CHECKPOINT_FAILED";
                break;
            case 0xC00D2780:
                return "HRES_NS_E_DRM_BB_UNABLE_TO_INITIALIZE";
                break;
            case 0xC00D2781:
                return "HRES_NS_E_DRM_UNABLE_TO_LOAD_HARDWARE_ID";
                break;
            case 0xC00D2782:
                return "HRES_NS_E_DRM_UNABLE_TO_OPEN_DATA_STORE";
                break;
            case 0xC00D2783:
                return "HRES_NS_E_DRM_DATASTORE_CORRUPT";
                break;
            case 0xC00D2784:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_INMEMORYSTORE_OBJECT";
                break;
            case 0xC00D2785:
                return "HRES_NS_E_DRM_STUBLIB_REQUIRED";
                break;
            case 0xC00D2786:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_CERTIFICATE_OBJECT";
                break;
            case 0xC00D2787:
                return "HRES_NS_E_DRM_MIGRATION_TARGET_NOT_ONLINE";
                break;
            case 0xC00D2788:
                return "HRES_NS_E_DRM_INVALID_MIGRATION_IMAGE";
                break;
            case 0xC00D2789:
                return "HRES_NS_E_DRM_MIGRATION_TARGET_STATES_CORRUPTED";
                break;
            case 0xC00D278A:
                return "HRES_NS_E_DRM_MIGRATION_IMPORTER_NOT_AVAILABLE";
                break;
            case 0xC00D278B:
                return "HRES_NS_DRM_E_MIGRATION_UPGRADE_WITH_DIFF_SID";
                break;
            case 0xC00D278C:
                return "HRES_NS_DRM_E_MIGRATION_SOURCE_MACHINE_IN_USE";
                break;
            case 0xC00D278D:
                return "HRES_NS_DRM_E_MIGRATION_TARGET_MACHINE_LESS_THAN_LH";
                break;
            case 0xC00D278E:
                return "HRES_NS_DRM_E_MIGRATION_IMAGE_ALREADY_EXISTS";
                break;
            case 0xC00D278F:
                return "HRES_NS_E_DRM_HARDWAREID_MISMATCH";
                break;
            case 0xC00D2790:
                return "HRES_NS_E_INVALID_DRMV2CLT_STUBLIB";
                break;
            case 0xC00D2791:
                return "HRES_NS_E_DRM_MIGRATION_INVALID_LEGACYV2_DATA";
                break;
            case 0xC00D2792:
                return "HRES_NS_E_DRM_MIGRATION_LICENSE_ALREADY_EXISTS";
                break;
            case 0xC00D2793:
                return "HRES_NS_E_DRM_MIGRATION_INVALID_LEGACYV2_SST_PASSWORD";
                break;
            case 0xC00D2794:
                return "HRES_NS_E_DRM_MIGRATION_NOT_SUPPORTED";
                break;
            case 0xC00D2795:
                return "HRES_NS_E_DRM_UNABLE_TO_CREATE_MIGRATION_IMPORTER_OBJECT";
                break;
            case 0xC00D2796:
                return "HRES_NS_E_DRM_CHECKPOINT_MISMATCH";
                break;
            case 0xC00D2797:
                return "HRES_NS_E_DRM_CHECKPOINT_CORRUPT";
                break;
            case 0xC00D2798:
                return "HRES_NS_E_REG_FLUSH_FAILURE";
                break;
            case 0xC00D2799:
                return "HRES_NS_E_HDS_KEY_MISMATCH";
                break;
            case 0xC00D279A:
                return "HRES_NS_E_DRM_MIGRATION_OPERATION_CANCELLED";
                break;
            case 0xC00D279B:
                return "HRES_NS_E_DRM_MIGRATION_OBJECT_IN_USE";
                break;
            case 0xC00D279C:
                return "HRES_NS_E_DRM_MALFORMED_CONTENT_HEADER";
                break;
            case 0xC00D27D8:
                return "HRES_NS_E_DRM_LICENSE_EXPIRED";
                break;
            case 0xC00D27D9:
                return "HRES_NS_E_DRM_LICENSE_NOTENABLED";
                break;
            case 0xC00D27DA:
                return "HRES_NS_E_DRM_LICENSE_APPSECLOW";
                break;
            case 0xC00D27DB:
                return "HRES_NS_E_DRM_STORE_NEEDINDI";
                break;
            case 0xC00D27DC:
                return "HRES_NS_E_DRM_STORE_NOTALLOWED";
                break;
            case 0xC00D27DD:
                return "HRES_NS_E_DRM_LICENSE_APP_NOTALLOWED";
                break;
            case 0xC00D27DF:
                return "HRES_NS_E_DRM_LICENSE_CERT_EXPIRED";
                break;
            case 0xC00D27E0:
                return "HRES_NS_E_DRM_LICENSE_SECLOW";
                break;
            case 0xC00D27E1:
                return "HRES_NS_E_DRM_LICENSE_CONTENT_REVOKED";
                break;
            case 0xC00D27E2:
                return "HRES_NS_E_DRM_DEVICE_NOT_REGISTERED";
                break;
            case 0xC00D280A:
                return "HRES_NS_E_DRM_LICENSE_NOSAP";
                break;
            case 0xC00D280B:
                return "HRES_NS_E_DRM_LICENSE_NOSVP";
                break;
            case 0xC00D280C:
                return "HRES_NS_E_DRM_LICENSE_NOWDM";
                break;
            case 0xC00D280D:
                return "HRES_NS_E_DRM_LICENSE_NOTRUSTEDCODEC";
                break;
            case 0xC00D280E:
                return "HRES_NS_E_DRM_SOURCEID_NOT_SUPPORTED";
                break;
            case 0xC00D283D:
                return "HRES_NS_E_DRM_NEEDS_UPGRADE_TEMPFILE";
                break;
            case 0xC00D283E:
                return "HRES_NS_E_DRM_NEED_UPGRADE_PD";
                break;
            case 0xC00D283F:
                return "HRES_NS_E_DRM_SIGNATURE_FAILURE";
                break;
            case 0xC00D2840:
                return "HRES_NS_E_DRM_LICENSE_SERVER_INFO_MISSING";
                break;
            case 0xC00D2841:
                return "HRES_NS_E_DRM_BUSY";
                break;
            case 0xC00D2842:
                return "HRES_NS_E_DRM_PD_TOO_MANY_DEVICES";
                break;
            case 0xC00D2843:
                return "HRES_NS_E_DRM_INDIV_FRAUD";
                break;
            case 0xC00D2844:
                return "HRES_NS_E_DRM_INDIV_NO_CABS";
                break;
            case 0xC00D2845:
                return "HRES_NS_E_DRM_INDIV_SERVICE_UNAVAILABLE";
                break;
            case 0xC00D2846:
                return "HRES_NS_E_DRM_RESTORE_SERVICE_UNAVAILABLE";
                break;
            case 0xC00D2847:
                return "HRES_NS_E_DRM_CLIENT_CODE_EXPIRED";
                break;
            case 0xC00D2848:
                return "HRES_NS_E_DRM_NO_UPLINK_LICENSE";
                break;
            case 0xC00D2849:
                return "HRES_NS_E_DRM_INVALID_KID";
                break;
            case 0xC00D284A:
                return "HRES_NS_E_DRM_LICENSE_INITIALIZATION_ERROR";
                break;
            case 0xC00D284C:
                return "HRES_NS_E_DRM_CHAIN_TOO_LONG";
                break;
            case 0xC00D284D:
                return "HRES_NS_E_DRM_UNSUPPORTED_ALGORITHM";
                break;
            case 0xC00D284E:
                return "HRES_NS_E_DRM_LICENSE_DELETION_ERROR";
                break;
            case 0xC00D28A0:
                return "HRES_NS_E_DRM_INVALID_CERTIFICATE";
                break;
            case 0xC00D28A1:
                return "HRES_NS_E_DRM_CERTIFICATE_REVOKED";
                break;
            case 0xC00D28A2:
                return "HRES_NS_E_DRM_LICENSE_UNAVAILABLE";
                break;
            case 0xC00D28A3:
                return "HRES_NS_E_DRM_DEVICE_LIMIT_REACHED";
                break;
            case 0xC00D28A4:
                return "HRES_NS_E_DRM_UNABLE_TO_VERIFY_PROXIMITY";
                break;
            case 0xC00D28A5:
                return "HRES_NS_E_DRM_MUST_REGISTER";
                break;
            case 0xC00D28A6:
                return "HRES_NS_E_DRM_MUST_APPROVE";
                break;
            case 0xC00D28A7:
                return "HRES_NS_E_DRM_MUST_REVALIDATE";
                break;
            case 0xC00D28A8:
                return "HRES_NS_E_DRM_INVALID_PROXIMITY_RESPONSE";
                break;
            case 0xC00D28A9:
                return "HRES_NS_E_DRM_INVALID_SESSION";
                break;
            case 0xC00D28AA:
                return "HRES_NS_E_DRM_DEVICE_NOT_OPEN";
                break;
            case 0xC00D28AB:
                return "HRES_NS_E_DRM_DEVICE_ALREADY_REGISTERED";
                break;
            case 0xC00D28AC:
                return "HRES_NS_E_DRM_UNSUPPORTED_PROTOCOL_VERSION";
                break;
            case 0xC00D28AD:
                return "HRES_NS_E_DRM_UNSUPPORTED_ACTION";
                break;
            case 0xC00D28AE:
                return "HRES_NS_E_DRM_CERTIFICATE_SECURITY_LEVEL_INADEQUATE";
                break;
            case 0xC00D28AF:
                return "HRES_NS_E_DRM_UNABLE_TO_OPEN_PORT";
                break;
            case 0xC00D28B0:
                return "HRES_NS_E_DRM_BAD_REQUEST";
                break;
            case 0xC00D28B1:
                return "HRES_NS_E_DRM_INVALID_CRL";
                break;
            case 0xC00D28B2:
                return "HRES_NS_E_DRM_ATTRIBUTE_TOO_LONG";
                break;
            case 0xC00D28B3:
                return "HRES_NS_E_DRM_EXPIRED_LICENSEBLOB";
                break;
            case 0xC00D28B4:
                return "HRES_NS_E_DRM_INVALID_LICENSEBLOB";
                break;
            case 0xC00D28B5:
                return "HRES_NS_E_DRM_INCLUSION_LIST_REQUIRED";
                break;
            case 0xC00D28B6:
                return "HRES_NS_E_DRM_DRMV2CLT_REVOKED";
                break;
            case 0xC00D28B7:
                return "HRES_NS_E_DRM_RIV_TOO_SMALL";
                break;
            case 0xC00D2904:
                return "HRES_NS_E_OUTPUT_PROTECTION_LEVEL_UNSUPPORTED";
                break;
            case 0xC00D2905:
                return "HRES_NS_E_COMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED";
                break;
            case 0xC00D2906:
                return "HRES_NS_E_UNCOMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED";
                break;
            case 0xC00D2907:
                return "HRES_NS_E_ANALOG_VIDEO_PROTECTION_LEVEL_UNSUPPORTED";
                break;
            case 0xC00D2908:
                return "HRES_NS_E_COMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED";
                break;
            case 0xC00D2909:
                return "HRES_NS_E_UNCOMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED";
                break;
            case 0xC00D290A:
                return "HRES_NS_E_OUTPUT_PROTECTION_SCHEME_UNSUPPORTED";
                break;
            case 0xC00D2AFA:
                return "HRES_NS_E_REBOOT_RECOMMENDED";
                break;
            case 0xC00D2AFB:
                return "HRES_NS_E_REBOOT_REQUIRED";
                break;
            case 0xC00D2AFC:
                return "HRES_NS_E_SETUP_INCOMPLETE";
                break;
            case 0xC00D2AFD:
                return "HRES_NS_E_SETUP_DRM_MIGRATION_FAILED";
                break;
            case 0xC00D2AFE:
                return "HRES_NS_E_SETUP_IGNORABLE_FAILURE";
                break;
            case 0xC00D2AFF:
                return "HRES_NS_E_SETUP_DRM_MIGRATION_FAILED_AND_IGNORABLE_FAILURE";
                break;
            case 0xC00D2B00:
                return "HRES_NS_E_SETUP_BLOCKED";
                break;
            case 0xC00D2EE0:
                return "HRES_NS_E_UNKNOWN_PROTOCOL";
                break;
            case 0xC00D2EE1:
                return "HRES_NS_E_REDIRECT_TO_PROXY";
                break;
            case 0xC00D2EE2:
                return "HRES_NS_E_INTERNAL_SERVER_ERROR";
                break;
            case 0xC00D2EE3:
                return "HRES_NS_E_BAD_REQUEST";
                break;
            case 0xC00D2EE4:
                return "HRES_NS_E_ERROR_FROM_PROXY";
                break;
            case 0xC00D2EE5:
                return "HRES_NS_E_PROXY_TIMEOUT";
                break;
            case 0xC00D2EE6:
                return "HRES_NS_E_SERVER_UNAVAILABLE";
                break;
            case 0xC00D2EE7:
                return "HRES_NS_E_REFUSED_BY_SERVER";
                break;
            case 0xC00D2EE8:
                return "HRES_NS_E_INCOMPATIBLE_SERVER";
                break;
            case 0xC00D2EE9:
                return "HRES_NS_E_MULTICAST_DISABLED";
                break;
            case 0xC00D2EEA:
                return "HRES_NS_E_INVALID_REDIRECT";
                break;
            case 0xC00D2EEB:
                return "HRES_NS_E_ALL_PROTOCOLS_DISABLED";
                break;
            case 0xC00D2EEC:
                return "HRES_NS_E_MSBD_NO_LONGER_SUPPORTED";
                break;
            case 0xC00D2EED:
                return "HRES_NS_E_PROXY_NOT_FOUND";
                break;
            case 0xC00D2EEE:
                return "HRES_NS_E_CANNOT_CONNECT_TO_PROXY";
                break;
            case 0xC00D2EEF:
                return "HRES_NS_E_SERVER_DNS_TIMEOUT";
                break;
            case 0xC00D2EF0:
                return "HRES_NS_E_PROXY_DNS_TIMEOUT";
                break;
            case 0xC00D2EF1:
                return "HRES_NS_E_CLOSED_ON_SUSPEND";
                break;
            case 0xC00D2EF2:
                return "HRES_NS_E_CANNOT_READ_PLAYLIST_FROM_MEDIASERVER";
                break;
            case 0xC00D2EF3:
                return "HRES_NS_E_SESSION_NOT_FOUND";
                break;
            case 0xC00D2EF4:
                return "HRES_NS_E_REQUIRE_STREAMING_CLIENT";
                break;
            case 0xC00D2EF5:
                return "HRES_NS_E_PLAYLIST_ENTRY_HAS_CHANGED";
                break;
            case 0xC00D2EF6:
                return "HRES_NS_E_PROXY_ACCESSDENIED";
                break;
            case 0xC00D2EF7:
                return "HRES_NS_E_PROXY_SOURCE_ACCESSDENIED";
                break;
            case 0xC00D2EF8:
                return "HRES_NS_E_NETWORK_SINK_WRITE";
                break;
            case 0xC00D2EF9:
                return "HRES_NS_E_FIREWALL";
                break;
            case 0xC00D2EFA:
                return "HRES_NS_E_MMS_NOT_SUPPORTED";
                break;
            case 0xC00D2EFB:
                return "HRES_NS_E_SERVER_ACCESSDENIED";
                break;
            case 0xC00D2EFC:
                return "HRES_NS_E_RESOURCE_GONE";
                break;
            case 0xC00D2EFD:
                return "HRES_NS_E_NO_EXISTING_PACKETIZER";
                break;
            case 0xC00D2EFE:
                return "HRES_NS_E_BAD_SYNTAX_IN_SERVER_RESPONSE";
                break;
            case 0xC00D2F00:
                return "HRES_NS_E_RESET_SOCKET_CONNECTION";
                break;
            case 0xC00D2F02:
                return "HRES_NS_E_TOO_MANY_HOPS";
                break;
            case 0xC00D2F05:
                return "HRES_NS_E_TOO_MUCH_DATA_FROM_SERVER";
                break;
            case 0xC00D2F06:
                return "HRES_NS_E_CONNECT_TIMEOUT";
                break;
            case 0xC00D2F07:
                return "HRES_NS_E_PROXY_CONNECT_TIMEOUT";
                break;
            case 0xC00D2F08:
                return "HRES_NS_E_SESSION_INVALID";
                break;
            case 0xC00D2F0A:
                return "HRES_NS_E_PACKETSINK_UNKNOWN_FEC_STREAM";
                break;
            case 0xC00D2F0B:
                return "HRES_NS_E_PUSH_CANNOTCONNECT";
                break;
            case 0xC00D2F0C:
                return "HRES_NS_E_INCOMPATIBLE_PUSH_SERVER";
                break;
            case 0xC00D32C8:
                return "HRES_NS_E_END_OF_PLAYLIST";
                break;
            case 0xC00D32C9:
                return "HRES_NS_E_USE_FILE_SOURCE";
                break;
            case 0xC00D32CA:
                return "HRES_NS_E_PROPERTY_NOT_FOUND";
                break;
            case 0xC00D32CC:
                return "HRES_NS_E_PROPERTY_READ_ONLY";
                break;
            case 0xC00D32CD:
                return "HRES_NS_E_TABLE_KEY_NOT_FOUND";
                break;
            case 0xC00D32CF:
                return "HRES_NS_E_INVALID_QUERY_OPERATOR";
                break;
            case 0xC00D32D0:
                return "HRES_NS_E_INVALID_QUERY_PROPERTY";
                break;
            case 0xC00D32D2:
                return "HRES_NS_E_PROPERTY_NOT_SUPPORTED";
                break;
            case 0xC00D32D4:
                return "HRES_NS_E_SCHEMA_CLASSIFY_FAILURE";
                break;
            case 0xC00D32D5:
                return "HRES_NS_E_METADATA_FORMAT_NOT_SUPPORTED";
                break;
            case 0xC00D32D6:
                return "HRES_NS_E_METADATA_NO_EDITING_CAPABILITY";
                break;
            case 0xC00D32D7:
                return "HRES_NS_E_METADATA_CANNOT_SET_LOCALE";
                break;
            case 0xC00D32D8:
                return "HRES_NS_E_METADATA_LANGUAGE_NOT_SUPORTED";
                break;
            case 0xC00D32D9:
                return "HRES_NS_E_METADATA_NO_RFC1766_NAME_FOR_LOCALE";
                break;
            case 0xC00D32DA:
                return "HRES_NS_E_METADATA_NOT_AVAILABLE";
                break;
            case 0xC00D32DB:
                return "HRES_NS_E_METADATA_CACHE_DATA_NOT_AVAILABLE";
                break;
            case 0xC00D32DC:
                return "HRES_NS_E_METADATA_INVALID_DOCUMENT_TYPE";
                break;
            case 0xC00D32DD:
                return "HRES_NS_E_METADATA_IDENTIFIER_NOT_AVAILABLE";
                break;
            case 0xC00D32DE:
                return "HRES_NS_E_METADATA_CANNOT_RETRIEVE_FROM_OFFLINE_CACHE";
                break;
            case 0xC0261003:
                return "HRES_ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM";
                break;
            case 0xC0261004:
                return "HRES_ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK";
                break;
            case 0xC0261005:
                return "HRES_ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED";
                break;
            case 0xC0261006:
                return "HRES_ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK";
                break;
            case 0xC0261007:
                return "HRES_ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK";
                break;
            case 0xC0261008:
                return "HRES_ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA";
                break;
            case 0xC0261009:
                return "HRES_ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK";
                break;
            case 0xC0262000:
                return "HRES_ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER";
                break;
            case 0xC0262001:
                return "HRES_ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER";
                break;
            case 0xC0262002:
                return "HRES_ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER";
                break;
            case 0xC0262003:
                return "HRES_ERROR_GRAPHICS_ADAPTER_WAS_RESET";
                break;
            case 0xC0262004:
                return "HRES_ERROR_GRAPHICS_INVALID_DRIVER_MODEL";
                break;
            case 0xC0262005:
                return "HRES_ERROR_GRAPHICS_PRESENT_MODE_CHANGED";
                break;
            case 0xC0262006:
                return "HRES_ERROR_GRAPHICS_PRESENT_OCCLUDED";
                break;
            case 0xC0262007:
                return "HRES_ERROR_GRAPHICS_PRESENT_DENIED";
                break;
            case 0xC0262008:
                return "HRES_ERROR_GRAPHICS_CANNOTCOLORCONVERT";
                break;
            case 0xC0262100:
                return "HRES_ERROR_GRAPHICS_NO_VIDEO_MEMORY";
                break;
            case 0xC0262101:
                return "HRES_ERROR_GRAPHICS_CANT_LOCK_MEMORY";
                break;
            case 0xC0262102:
                return "HRES_ERROR_GRAPHICS_ALLOCATION_BUSY";
                break;
            case 0xC0262103:
                return "HRES_ERROR_GRAPHICS_TOO_MANY_REFERENCES";
                break;
            case 0xC0262104:
                return "HRES_ERROR_GRAPHICS_TRY_AGAIN_LATER";
                break;
            case 0xC0262105:
                return "HRES_ERROR_GRAPHICS_TRY_AGAIN_NOW";
                break;
            case 0xC0262106:
                return "HRES_ERROR_GRAPHICS_ALLOCATION_INVALID";
                break;
            case 0xC0262107:
                return "HRES_ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE";
                break;
            case 0xC0262108:
                return "HRES_ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED";
                break;
            case 0xC0262109:
                return "HRES_ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION";
                break;
            case 0xC0262110:
                return "HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE";
                break;
            case 0xC0262111:
                return "HRES_ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION";
                break;
            case 0xC0262112:
                return "HRES_ERROR_GRAPHICS_ALLOCATION_CLOSED";
                break;
            case 0xC0262113:
                return "HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE";
                break;
            case 0xC0262114:
                return "HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE";
                break;
            case 0xC0262115:
                return "HRES_ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE";
                break;
            case 0xC0262116:
                return "HRES_ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST";
                break;
            case 0xC0262200:
                return "HRES_ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE";
                break;
            case 0xC0262300:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY";
                break;
            case 0xC0262301:
                return "HRES_ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED";
                break;
            case 0xC0262302:
                return "HRES_ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED";
                break;
            case 0xC0262303:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDPN";
                break;
            case 0xC0262304:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE";
                break;
            case 0xC0262305:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET";
                break;
            case 0xC0262306:
                return "HRES_ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED";
                break;
            case 0xC0262308:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET";
                break;
            case 0xC0262309:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET";
                break;
            case 0xC026230A:
                return "HRES_ERROR_GRAPHICS_INVALID_FREQUENCY";
                break;
            case 0xC026230B:
                return "HRES_ERROR_GRAPHICS_INVALID_ACTIVE_REGION";
                break;
            case 0xC026230C:
                return "HRES_ERROR_GRAPHICS_INVALID_TOTAL_REGION";
                break;
            case 0xC0262310:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE";
                break;
            case 0xC0262311:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE";
                break;
            case 0xC0262312:
                return "HRES_ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET";
                break;
            case 0xC0262313:
                return "HRES_ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY";
                break;
            case 0xC0262314:
                return "HRES_ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET";
                break;
            case 0xC0262315:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET";
                break;
            case 0xC0262316:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET";
                break;
            case 0xC0262317:
                return "HRES_ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET";
                break;
            case 0xC0262318:
                return "HRES_ERROR_GRAPHICS_TARGET_ALREADY_IN_SET";
                break;
            case 0xC0262319:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH";
                break;
            case 0xC026231A:
                return "HRES_ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY";
                break;
            case 0xC026231B:
                return "HRES_ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET";
                break;
            case 0xC026231C:
                return "HRES_ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE";
                break;
            case 0xC026231D:
                return "HRES_ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET";
                break;
            case 0xC026231F:
                return "HRES_ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET";
                break;
            case 0xC0262320:
                return "HRES_ERROR_GRAPHICS_STALE_MODESET";
                break;
            case 0xC0262321:
                return "HRES_ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET";
                break;
            case 0xC0262322:
                return "HRES_ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE";
                break;
            case 0xC0262323:
                return "HRES_ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN";
                break;
            case 0xC0262324:
                return "HRES_ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE";
                break;
            case 0xC0262325:
                return "HRES_ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION";
                break;
            case 0xC0262326:
                return "HRES_ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES";
                break;
            case 0xC0262327:
                return "HRES_ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY";
                break;
            case 0xC0262328:
                return "HRES_ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE";
                break;
            case 0xC0262329:
                return "HRES_ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET";
                break;
            case 0xC026232A:
                return "HRES_ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET";
                break;
            case 0xC026232B:
                return "HRES_ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR";
                break;
            case 0xC026232C:
                return "HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET";
                break;
            case 0xC026232D:
                return "HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET";
                break;
            case 0xC026232E:
                return "HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE";
                break;
            case 0xC026232F:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE";
                break;
            case 0xC0262330:
                return "HRES_ERROR_GRAPHICS_RESOURCES_NOT_RELATED";
                break;
            case 0xC0262331:
                return "HRES_ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE";
                break;
            case 0xC0262332:
                return "HRES_ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE";
                break;
            case 0xC0262333:
                return "HRES_ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET";
                break;
            case 0xC0262334:
                return "HRES_ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER";
                break;
            case 0xC0262335:
                return "HRES_ERROR_GRAPHICS_NO_VIDPNMGR";
                break;
            case 0xC0262336:
                return "HRES_ERROR_GRAPHICS_NO_ACTIVE_VIDPN";
                break;
            case 0xC0262337:
                return "HRES_ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY";
                break;
            case 0xC0262338:
                return "HRES_ERROR_GRAPHICS_MONITOR_NOT_CONNECTED";
                break;
            case 0xC0262339:
                return "HRES_ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY";
                break;
            case 0xC026233A:
                return "HRES_ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE";
                break;
            case 0xC026233B:
                return "HRES_ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE";
                break;
            case 0xC026233C:
                return "HRES_ERROR_GRAPHICS_INVALID_STRIDE";
                break;
            case 0xC026233D:
                return "HRES_ERROR_GRAPHICS_INVALID_PIXELFORMAT";
                break;
            case 0xC026233E:
                return "HRES_ERROR_GRAPHICS_INVALID_COLORBASIS";
                break;
            case 0xC026233F:
                return "HRES_ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE";
                break;
            case 0xC0262340:
                return "HRES_ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY";
                break;
            case 0xC0262341:
                return "HRES_ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT";
                break;
            case 0xC0262342:
                return "HRES_ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE";
                break;
            case 0xC0262343:
                return "HRES_ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN";
                break;
            case 0xC0262344:
                return "HRES_ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL";
                break;
            case 0xC0262345:
                return "HRES_ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION";
                break;
            case 0xC0262346:
                return "HRES_ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED";
                break;
            case 0xC0262347:
                return "HRES_ERROR_GRAPHICS_INVALID_GAMMA_RAMP";
                break;
            case 0xC0262348:
                return "HRES_ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED";
                break;
            case 0xC0262349:
                return "HRES_ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED";
                break;
            case 0xC026234A:
                return "HRES_ERROR_GRAPHICS_MODE_NOT_IN_MODESET";
                break;
            case 0xC026234D:
                return "HRES_ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON";
                break;
            case 0xC026234E:
                return "HRES_ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE";
                break;
            case 0xC026234F:
                return "HRES_ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE";
                break;
            case 0xC0262350:
                return "HRES_ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS";
                break;
            case 0xC0262352:
                return "HRES_ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING";
                break;
            case 0xC0262353:
                return "HRES_ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED";
                break;
            case 0xC0262354:
                return "HRES_ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS";
                break;
            case 0xC0262355:
                return "HRES_ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT";
                break;
            case 0xC0262356:
                return "HRES_ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM";
                break;
            case 0xC0262400:
                return "HRES_ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED";
                break;
            case 0xC0262401:
                return "HRES_ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED";
                break;
            case 0xC0262430:
                return "HRES_ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER";
                break;
            case 0xC0262431:
                return "HRES_ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED";
                break;
            case 0xC0262432:
                return "HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED";
                break;
            case 0xC0262433:
                return "HRES_ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY";
                break;
            case 0xC0262434:
                return "HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED";
                break;
            case 0xC0262435:
                return "HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON";
                break;
            case 0xC0262436:
                return "HRES_ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE";
                break;
            case 0xC0262438:
                return "HRES_ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER";
                break;
            case 0xC0262500:
                return "HRES_ERROR_GRAPHICS_OPM_NOT_SUPPORTED";
                break;
            case 0xC0262501:
                return "HRES_ERROR_GRAPHICS_COPP_NOT_SUPPORTED";
                break;
            case 0xC0262502:
                return "HRES_ERROR_GRAPHICS_UAB_NOT_SUPPORTED";
                break;
            case 0xC0262503:
                return "HRES_ERROR_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS";
                break;
            case 0xC0262504:
                return "HRES_ERROR_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL";
                break;
            case 0xC0262505:
                return "HRES_ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST";
                break;
            case 0xC0262506:
                return "HRES_ERROR_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME";
                break;
            case 0xC0262507:
                return "HRES_ERROR_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP";
                break;
            case 0xC0262508:
                return "HRES_ERROR_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED";
                break;
            case 0xC026250A:
                return "HRES_ERROR_GRAPHICS_OPM_INVALID_POINTER";
                break;
            case 0xC026250B:
                return "HRES_ERROR_GRAPHICS_OPM_INTERNAL_ERROR";
                break;
            case 0xC026250C:
                return "HRES_ERROR_GRAPHICS_OPM_INVALID_HANDLE";
                break;
            case 0xC026250D:
                return "HRES_ERROR_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE";
                break;
            case 0xC026250E:
                return "HRES_ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH";
                break;
            case 0xC026250F:
                return "HRES_ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED";
                break;
            case 0xC0262510:
                return "HRES_ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED";
                break;
            case 0xC0262511:
                return "HRES_ERROR_GRAPHICS_PVP_HFS_FAILED";
                break;
            case 0xC0262512:
                return "HRES_ERROR_GRAPHICS_OPM_INVALID_SRM";
                break;
            case 0xC0262513:
                return "HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP";
                break;
            case 0xC0262514:
                return "HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP";
                break;
            case 0xC0262515:
                return "HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA";
                break;
            case 0xC0262516:
                return "HRES_ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET";
                break;
            case 0xC0262517:
                return "HRES_ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH";
                break;
            case 0xC0262518:
                return "HRES_ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE";
                break;
            case 0xC0262519:
                return "HRES_ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS";
                break;
            case 0xC026251A:
                return "HRES_ERROR_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS";
                break;
            case 0xC0262580:
                return "HRES_ERROR_GRAPHICS_I2C_NOT_SUPPORTED";
                break;
            case 0xC0262581:
                return "HRES_ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST";
                break;
            case 0xC0262582:
                return "HRES_ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA";
                break;
            case 0xC0262583:
                return "HRES_ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA";
                break;
            case 0xC0262584:
                return "HRES_ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED";
                break;
            case 0xC0262585:
                return "HRES_ERROR_GRAPHICS_DDCCI_INVALID_DATA";
                break;
            case 0xC0262586:
                return "HRES_ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE";
                break;
            case 0xC0262587:
                return "HRES_ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING";
                break;
            case 0xC0262588:
                return "HRES_ERROR_GRAPHICS_MCA_INTERNAL_ERROR";
                break;
            case 0xC0262589:
                return "HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND";
                break;
            case 0xC026258A:
                return "HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH";
                break;
            case 0xC026258B:
                return "HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM";
                break;
            case 0xC02625D6:
                return "HRES_ERROR_GRAPHICS_PMEA_INVALID_MONITOR";
                break;
            case 0xC02625D7:
                return "HRES_ERROR_GRAPHICS_PMEA_INVALID_D3D_DEVICE";
                break;
            case 0xC02625D8:
                return "HRES_ERROR_GRAPHICS_DDCCI_CURRENT_CURRENT_VALUE_GREATER_THAN_MAXIMUM_VALUE";
                break;
            case 0xC02625D9:
                return "HRES_ERROR_GRAPHICS_MCA_INVALID_VCP_VERSION";
                break;
            case 0xC02625DA:
                return "HRES_ERROR_GRAPHICS_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION";
                break;
            case 0xC02625DB:
                return "HRES_ERROR_GRAPHICS_MCA_MCCS_VERSION_MISMATCH";
                break;
            case 0xC02625DC:
                return "HRES_ERROR_GRAPHICS_MCA_UNSUPPORTED_MCCS_VERSION";
                break;
            case 0xC02625DE:
                return "HRES_ERROR_GRAPHICS_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED";
                break;
            case 0xC02625DF:
                return "HRES_ERROR_GRAPHICS_MCA_UNSUPPORTED_COLOR_TEMPERATURE";
                break;
            case 0xC02625E0:
                return "HRES_ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED";
                break;
	}
	snprintf(msg, sizeof(msg), "HRES code 0x%08x", HRES_ERROR_V(err_code));
	return msg;
}
