/* localsearch-root-container.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-root-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <tinysparql.h>
#include <glib/gi18n-lib.h>
#include "rygel-server.h"
#include "rygel-core.h"

#define RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_LOCALSEARCH_SERVICE "org.freedesktop.LocalSearch3"
#define RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker3.Miner.Files"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_0_PROPERTY,
	RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_local_search_root_container_properties[RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_local_search_root_container_parent_class = NULL;
TrackerSparqlConnection* rygel_local_search_root_container_connection = NULL;
gchar* rygel_local_search_root_container_connected_service = NULL;

static gboolean rygel_local_search_root_container_get_bool_config_without_error (RygelLocalSearchRootContainer* self,
                                                                          const gchar* key);
static void rygel_local_search_root_container_finalize (GObject * obj);
static GType rygel_local_search_root_container_get_type_once (void);

RygelLocalSearchRootContainer*
rygel_local_search_root_container_construct (GType object_type,
                                             const gchar* title,
                                             GError** error)
{
	RygelLocalSearchRootContainer * self = NULL;
	TrackerSparqlConnection* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	{
		TrackerSparqlConnection* _tmp0_;
		_tmp0_ = rygel_local_search_root_container_connection;
		if (_tmp0_ == NULL) {
			TrackerSparqlConnection* _tmp1_ = NULL;
			TrackerSparqlConnection* _tmp2_;
			TrackerSparqlConnection* _tmp3_;
			gchar* _tmp4_;
			_tmp2_ = tracker_sparql_connection_bus_new (RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_LOCALSEARCH_SERVICE, NULL, NULL, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (rygel_local_search_root_container_connection);
			rygel_local_search_root_container_connection = _tmp3_;
			_tmp4_ = g_strdup (RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_LOCALSEARCH_SERVICE);
			_g_free0 (rygel_local_search_root_container_connected_service);
			rygel_local_search_root_container_connected_service = _tmp4_;
			_g_object_unref0 (_tmp1_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning (_ ("Could not connect to %s, falling back to old Tracker3 service"), RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_LOCALSEARCH_SERVICE);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp5_ = rygel_local_search_root_container_connection;
	if (_tmp5_ == NULL) {
		TrackerSparqlConnection* _tmp6_ = NULL;
		TrackerSparqlConnection* _tmp7_;
		TrackerSparqlConnection* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = tracker_sparql_connection_bus_new (RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_TRACKER_SERVICE, NULL, NULL, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (rygel_local_search_root_container_connection);
		rygel_local_search_root_container_connection = _tmp8_;
		_tmp9_ = g_strdup (RYGEL_LOCAL_SEARCH_ROOT_CONTAINER_TRACKER_SERVICE);
		_g_free0 (rygel_local_search_root_container_connected_service);
		rygel_local_search_root_container_connected_service = _tmp9_;
		_g_object_unref0 (_tmp6_);
	}
	self = (RygelLocalSearchRootContainer*) rygel_simple_container_construct_root (object_type, title);
	if (rygel_local_search_root_container_get_bool_config_without_error (self, "share-music")) {
		RygelLocalSearchMusic* _tmp10_;
		RygelLocalSearchMusic* _tmp11_;
		_tmp10_ = rygel_local_search_music_new ("Music", (RygelMediaContainer*) self, "Music");
		_tmp11_ = _tmp10_;
		rygel_simple_container_add_child_container ((RygelSimpleContainer*) self, (RygelMediaContainer*) _tmp11_);
		_g_object_unref0 (_tmp11_);
	}
	if (rygel_local_search_root_container_get_bool_config_without_error (self, "share-videos")) {
		RygelLocalSearchVideos* _tmp12_;
		RygelLocalSearchVideos* _tmp13_;
		_tmp12_ = rygel_local_search_videos_new ("Videos", (RygelMediaContainer*) self, "Videos");
		_tmp13_ = _tmp12_;
		rygel_simple_container_add_child_container ((RygelSimpleContainer*) self, (RygelMediaContainer*) _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	if (rygel_local_search_root_container_get_bool_config_without_error (self, "share-pictures")) {
		RygelLocalSearchPictures* _tmp14_;
		RygelLocalSearchPictures* _tmp15_;
		_tmp14_ = rygel_local_search_pictures_new ("Pictures", (RygelMediaContainer*) self, "Pictures");
		_tmp15_ = _tmp14_;
		rygel_simple_container_add_child_container ((RygelSimpleContainer*) self, (RygelMediaContainer*) _tmp15_);
		_g_object_unref0 (_tmp15_);
	}
	return self;
}

RygelLocalSearchRootContainer*
rygel_local_search_root_container_new (const gchar* title,
                                       GError** error)
{
	return rygel_local_search_root_container_construct (RYGEL_LOCAL_SEARCH_TYPE_ROOT_CONTAINER, title, error);
}

static gboolean
rygel_local_search_root_container_get_bool_config_without_error (RygelLocalSearchRootContainer* self,
                                                                 const gchar* key)
{
	gboolean value = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	value = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "LocalSearch", key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		value = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = value;
	_g_object_unref0 (config);
	return result;
}

static void
rygel_local_search_root_container_class_init (RygelLocalSearchRootContainerClass * klass,
                                              gpointer klass_data)
{
	rygel_local_search_root_container_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_local_search_root_container_finalize;
}

static void
rygel_local_search_root_container_instance_init (RygelLocalSearchRootContainer * self,
                                                 gpointer klass)
{
}

static void
rygel_local_search_root_container_finalize (GObject * obj)
{
	RygelLocalSearchRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LOCAL_SEARCH_TYPE_ROOT_CONTAINER, RygelLocalSearchRootContainer);
	G_OBJECT_CLASS (rygel_local_search_root_container_parent_class)->finalize (obj);
}

/**
 * Represents the root container for LocalSearch media content hierarchy.
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_root_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchRootContainer), 0, (GInstanceInitFunc) rygel_local_search_root_container_instance_init, NULL };
	GType rygel_local_search_root_container_type_id;
	rygel_local_search_root_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelLocalSearchRootContainer", &g_define_type_info, 0);
	return rygel_local_search_root_container_type_id;
}

GType
rygel_local_search_root_container_get_type (void)
{
	static volatile gsize rygel_local_search_root_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_root_container_type_id__once)) {
		GType rygel_local_search_root_container_type_id;
		rygel_local_search_root_container_type_id = rygel_local_search_root_container_get_type_once ();
		g_once_init_leave (&rygel_local_search_root_container_type_id__once, rygel_local_search_root_container_type_id);
	}
	return rygel_local_search_root_container_type_id__once;
}

