/* context.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from context.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Remove workaround once https://gitlab.gnome.org/GNOME/vala/-/issues/1429 is fixed. */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include "libgnome-games-support.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <adwaita.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>

#define GAMES_SCORES_DIALOG_STYLE "\n" \
"dialog.scores columnview {\n" \
"    background: transparent;\n" \
"}\n" \
"\n" \
"dialog.scores columnview header button,\n" \
"dialog.scores columnview row cell {\n" \
"    padding-left: 12px;\n" \
"    padding-right: 12px;\n" \
"}\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_SCORES_CONTEXT_0_PROPERTY,
	GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY,
	GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY,
	GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY,
	GAMES_SCORES_CONTEXT_STYLE_PROPERTY,
	GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY,
	GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY,
	GAMES_SCORES_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* games_scores_context_properties[GAMES_SCORES_CONTEXT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesScoresContextSaveScoreToFileData GamesScoresContextSaveScoreToFileData;
typedef struct _Block3Data Block3Data;

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresContextAddScoreInternalData GamesScoresContextAddScoreInternalData;
typedef struct _GamesScoresContextAddScoreData GamesScoresContextAddScoreData;
typedef struct _Block4Data Block4Data;
typedef struct _GamesScoresContextAddScoreFullData GamesScoresContextAddScoreFullData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
enum  {
	GAMES_SCORES_CONTEXT_DIALOG_CLOSED_SIGNAL,
	GAMES_SCORES_CONTEXT_NUM_SIGNALS
};
static guint games_scores_context_signals[GAMES_SCORES_CONTEXT_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesScoresContextPrivate {
	gchar* _app_name;
	gchar* _category_type;
	GtkWindow* _game_window;
	GamesScoresStyle _style;
	gchar* _icon_name;
	GamesScoresImporter* _importer;
	GamesScoresCategory* current_category;
	GeeHashMap* scores_per_category;
	gchar* user_score_dir;
	gboolean scores_loaded;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
	GDestroyNotify category_request_target_destroy_notify;
};

struct _Block2Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};

struct _GamesScoresContextSaveScoreToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresContext* self;
	GamesScoresScore* score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GFile* file;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFileOutputStream* stream;
	GFile* _tmp11_;
	GFileOutputStream* _tmp12_;
	gchar* line;
	glong _tmp13_;
	glong _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint64 _tmp17_;
	gint64 _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GFileOutputStream* _tmp26_;
	const gchar* _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	guint8* _tmp30_;
	gint _tmp30__length1;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	GamesScoresContext* self;
	gpointer _async_data_;
};

struct _GamesScoresContextAddScoreInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresContext* self;
	GamesScoresScore* score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	gboolean result;
	Block3Data* _data3_;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	GeeList* _tmp6_;
	gboolean _tmp7_;
	GamesScoresCategory* _tmp8_;
	gboolean high_score_added;
	glong _tmp9_;
	glong _tmp10_;
	gboolean _tmp11_;
	GtkWindow* _tmp12_;
	GamesScoresDialog* dialog;
	const gchar* _tmp13_;
	GamesScoresStyle _tmp14_;
	GamesScoresCategory* _tmp15_;
	const gchar* _tmp16_;
	GamesScoresDialog* _tmp17_;
	GamesScoresDialog* _tmp18_;
	GamesScoresDialog* _tmp19_;
	GtkWindow* _tmp20_;
	GError* _inner_error0_;
};

struct _GamesScoresContextAddScoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresContext* self;
	glong score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresScore* _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	GamesScoresContext* self;
	gpointer _async_data_;
};

struct _GamesScoresContextAddScoreFullData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresContext* self;
	glong score_value;
	GamesScoresCategory* category;
	GamesScoresContextNewGameFunc new_game_func;
	gpointer new_game_func_target;
	GamesScoresContextQuitAppFunc quit_app_func;
	gpointer quit_app_func_target;
	GCancellable* cancellable;
	gboolean result;
	Block4Data* _data4_;
	GamesScoresScore* score;
	GamesScoresScore* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_;
	GeeList* _tmp7_;
	GamesScoresScore* _tmp8_;
	gboolean _tmp9_;
	GamesScoresCategory* _tmp10_;
	gboolean high_score_added;
	GamesScoresScore* _tmp11_;
	glong _tmp12_;
	glong _tmp13_;
	GamesScoresDialog* dialog;
	const gchar* _tmp14_;
	GamesScoresStyle _tmp15_;
	GamesScoresScore* _tmp16_;
	GamesScoresCategory* _tmp17_;
	const gchar* _tmp18_;
	GamesScoresDialog* _tmp19_;
	GamesScoresDialog* _tmp20_;
	GamesScoresDialog* _tmp21_;
	GtkWindow* _tmp22_;
	GamesScoresDialog* _tmp23_;
	GamesScoresScore* _tmp24_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};

struct _Block6Data {
	int _ref_count_;
	GamesScoresContext* self;
	GMainLoop* main_loop;
};

static gint GamesScoresContext_private_offset;
static gpointer games_scores_context_parent_class = NULL;
static GeeHashDataFunc games_scores_context_category_hash;
static gpointer games_scores_context_category_hash_target;
static GDestroyNotify games_scores_context_category_hash_target_destroy_notify;
static GeeHashDataFunc games_scores_context_category_hash = NULL;
static gpointer games_scores_context_category_hash_target = NULL;
static GDestroyNotify games_scores_context_category_hash_target_destroy_notify = NULL;
static GeeEqualDataFunc games_scores_context_category_equal;
static gpointer games_scores_context_category_equal_target;
static GDestroyNotify games_scores_context_category_equal_target_destroy_notify;
static GeeEqualDataFunc games_scores_context_category_equal = NULL;
static gpointer games_scores_context_category_equal_target = NULL;
static GDestroyNotify games_scores_context_category_equal_target_destroy_notify = NULL;

static guint _games_scores_context_category_hash_lambda6_ (GamesScoresCategory* a);
static guint __games_scores_context_category_hash_lambda6__gee_hash_data_func (gconstpointer v,
                                                                        gpointer self);
static gboolean _games_scores_context_category_equal_lambda7_ (GamesScoresCategory* a,
                                                        GamesScoresCategory* b);
static gboolean __games_scores_context_category_equal_lambda7__gee_equal_data_func (gconstpointer a,
                                                                             gconstpointer b,
                                                                             gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda8_ (Block2Data* _data2_,
                                 const gchar* key);
static GamesScoresCategory* ___lambda8__games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self);
static void games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                                  GError** error);
static void games_scores_context_real_constructed (GObject* base);
VALA_EXTERN void games_scores_importer_run (GamesScoresImporter* self,
                                GamesScoresContext* context,
                                const gchar* new_scores_dir);
VALA_EXTERN GList* games_scores_context_get_categories (GamesScoresContext* self);
VALA_EXTERN void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
VALA_EXTERN gint games_scores_score_score_greater_sorter (GamesScoresScore* a,
                                              GamesScoresScore* b);
static gint _games_scores_score_score_greater_sorter_gcompare_data_func (gconstpointer a,
                                                                  gconstpointer b,
                                                                  gpointer self);
VALA_EXTERN gint games_scores_score_score_less_sorter (GamesScoresScore* a,
                                           GamesScoresScore* b);
static gint _games_scores_score_score_less_sorter_gcompare_data_func (gconstpointer a,
                                                               gconstpointer b,
                                                               gpointer self);
static gboolean games_scores_context_is_high_score (GamesScoresContext* self,
                                             glong score_value,
                                             GamesScoresCategory* category);
static void games_scores_context_save_score_to_file_data_free (gpointer _data);
static void games_scores_context_save_score_to_file (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static gboolean games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_);
static void games_scores_context_save_score_to_file_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void games_scores_context_add_score_internal_data_free (gpointer _data);
VALA_EXTERN void games_scores_context_add_score_internal (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN gboolean games_scores_context_add_score_internal_finish (GamesScoresContext* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static gboolean games_scores_context_add_score_internal_co (GamesScoresContextAddScoreInternalData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN GType games_scores_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            const gchar* icon_name);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  const gchar* icon_name);
static void ___lambda26_ (Block3Data* _data3_);
static void ____lambda26__adw_dialog_closed (AdwDialog* _sender,
                                      gpointer self);
static void games_scores_context_add_score_internal_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void games_scores_context_add_score_data_free (gpointer _data);
static gboolean games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_);
static void games_scores_context_add_score_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void games_scores_context_add_score_full_data_free (gpointer _data);
static gboolean games_scores_context_add_score_full_co (GamesScoresContextAddScoreFullData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda27_ (Block4Data* _data4_);
static void ____lambda27__adw_dialog_closed (AdwDialog* _sender,
                                      gpointer self);
VALA_EXTERN void games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self,
                                             GamesScoresContextNewGameFunc new_game_func,
                                             gpointer new_game_func_target,
                                             GamesScoresContextQuitAppFunc quit_app_func,
                                             gpointer quit_app_func_target);
static void games_scores_context_add_score_full_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                                 GFileInfo* file_info,
                                                 GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda28_ (Block5Data* _data5_,
                                  const gchar* key);
static GamesScoresCategory* ___lambda28__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda29_ (Block6Data* _data6_);
static void ___lambda29__adw_dialog_closed (AdwDialog* _sender,
                                     gpointer self);
static void __lambda30_ (GamesScoresContext* self);
static void ___lambda30__adw_dialog_closed (AdwDialog* _sender,
                                     gpointer self);
static void games_scores_context_finalize (GObject * obj);
static GType games_scores_context_get_type_once (void);
static void _vala_games_scores_context_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_scores_context_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
 * The style that a {@link Games.Scores.Score} uses.
 *
 * This tells the score dialog if it should display the scores as a time or as points.
 *
 * It also tells the score dialog if a larger or smaller score should get a higher ranking.
 *
 */
static GType
games_scores_style_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER", "points-greater-is-better"}, {GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER", "points-less-is-better"}, {GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER", "time-greater-is-better"}, {GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER, "GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER", "time-less-is-better"}, {0, NULL, NULL}};
	GType games_scores_style_type_id;
	games_scores_style_type_id = g_enum_register_static ("GamesScoresStyle", values);
	return games_scores_style_type_id;
}

GType
games_scores_style_get_type (void)
{
	static volatile gsize games_scores_style_type_id__once = 0;
	if (g_once_init_enter (&games_scores_style_type_id__once)) {
		GType games_scores_style_type_id;
		games_scores_style_type_id = games_scores_style_get_type_once ();
		g_once_init_leave (&games_scores_style_type_id__once, games_scores_style_type_id);
	}
	return games_scores_style_type_id__once;
}

static inline gpointer
games_scores_context_get_instance_private (GamesScoresContext* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresContext_private_offset);
}

static guint
_games_scores_context_category_hash_lambda6_ (GamesScoresCategory* a)
{
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint result;
	_tmp0_ = g_str_hash;
	_tmp1_ = games_scores_category_get_key (a);
	_tmp2_ = _tmp1_;
	result = _tmp0_ (_tmp2_);
	return result;
}

static guint
__games_scores_context_category_hash_lambda6__gee_hash_data_func (gconstpointer v,
                                                                  gpointer self)
{
	guint result;
	result = _games_scores_context_category_hash_lambda6_ ((GamesScoresCategory*) v);
	return result;
}

static gboolean
_games_scores_context_category_equal_lambda7_ (GamesScoresCategory* a,
                                               GamesScoresCategory* b)
{
	GEqualFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	_tmp0_ = g_str_equal;
	_tmp1_ = games_scores_category_get_key (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_scores_category_get_key (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gboolean
__games_scores_context_category_equal_lambda7__gee_equal_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self)
{
	gboolean result;
	result = _games_scores_context_category_equal_lambda7_ ((GamesScoresCategory*) a, (GamesScoresCategory*) b);
	return result;
}

/**
     * Creates a new Context.
     *
     * ``app_name`` is your App ID (eg. ``org.gnome.Mines``).
     *
     * ``category_type`` describes all of the categories, make sure to put a colon at the end (eg. "Minefield:", "Difficulty Level:").
     *
     * ``game_window`` is the window that the game will be inside of, this is the window the score dialog will be presented upon.
     *
     * ``category_request`` is a function that takes a category key and produces the user-facing name for it/
     *
     *
     */
GamesScoresContext*
games_scores_context_construct (GType object_type,
                                const gchar* app_name,
                                const gchar* category_type,
                                GtkWindow* game_window,
                                GamesScoresContextCategoryRequestFunc category_request,
                                gpointer category_request_target,
                                GamesScoresStyle style)
{
	GamesScoresContext * self = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	self = (GamesScoresContext*) games_scores_context_construct_with_importer_and_icon_name (object_type, app_name, category_type, game_window, category_request, category_request_target, style, NULL, NULL);
	return self;
}

GamesScoresContext*
games_scores_context_new (const gchar* app_name,
                          const gchar* category_type,
                          GtkWindow* game_window,
                          GamesScoresContextCategoryRequestFunc category_request,
                          gpointer category_request_target,
                          GamesScoresStyle style)
{
	return games_scores_context_construct (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style);
}

/**
     * Creates a new Context.
     *
     * ``app_name`` is your App ID (e.g. ``org.gnome.Mines``)
     *
     * ``category_type`` describes all of the categories (e.g. "Minefield", "Level").
     *
     * ``game_window`` is the window that the game will be inside of, this is the window the score dialog will be presented upon.
     *
     * ``category_request`` is a function that takes a category key and produces the user-facing name for it.
     *
     * ``style changes`` the way {@link Games.Scores.Score}s are presented.
     *
     * ``icon_name`` is the ID for your app's icon (e.g. ``org.gnome.Quadrapassel``).
     *
     */
GamesScoresContext*
games_scores_context_construct_with_icon_name (GType object_type,
                                               const gchar* app_name,
                                               const gchar* category_type,
                                               GtkWindow* game_window,
                                               GamesScoresContextCategoryRequestFunc category_request,
                                               gpointer category_request_target,
                                               GamesScoresStyle style,
                                               const gchar* icon_name)
{
	GamesScoresContext * self = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GamesScoresContext*) games_scores_context_construct_with_importer_and_icon_name (object_type, app_name, category_type, game_window, category_request, category_request_target, style, NULL, icon_name);
	return self;
}

GamesScoresContext*
games_scores_context_new_with_icon_name (const gchar* app_name,
                                         const gchar* category_type,
                                         GtkWindow* game_window,
                                         GamesScoresContextCategoryRequestFunc category_request,
                                         gpointer category_request_target,
                                         GamesScoresStyle style,
                                         const gchar* icon_name)
{
	return games_scores_context_construct_with_icon_name (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style, icon_name);
}

GamesScoresContext*
games_scores_context_construct_with_importer (GType object_type,
                                              const gchar* app_name,
                                              const gchar* category_type,
                                              GtkWindow* game_window,
                                              GamesScoresContextCategoryRequestFunc category_request,
                                              gpointer category_request_target,
                                              GamesScoresStyle style,
                                              GamesScoresImporter* importer)
{
	GamesScoresContext * self = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	self = (GamesScoresContext*) games_scores_context_construct_with_importer_and_icon_name (object_type, app_name, category_type, game_window, category_request, category_request_target, style, importer, NULL);
	return self;
}

GamesScoresContext*
games_scores_context_new_with_importer (const gchar* app_name,
                                        const gchar* category_type,
                                        GtkWindow* game_window,
                                        GamesScoresContextCategoryRequestFunc category_request,
                                        gpointer category_request_target,
                                        GamesScoresStyle style,
                                        GamesScoresImporter* importer)
{
	return games_scores_context_construct_with_importer (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style, importer);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static GamesScoresCategory*
__lambda8_ (Block2Data* _data2_,
            const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* result;
	self = _data2_->self;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = _data2_->category_request (key, _data2_->category_request_target);
	result = _tmp0_;
	return result;
}

static GamesScoresCategory*
___lambda8__games_scores_context_category_request_func (const gchar* category_key,
                                                        gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda8_ (self, category_key);
	return result;
}

GamesScoresContext*
games_scores_context_construct_with_importer_and_icon_name (GType object_type,
                                                            const gchar* app_name,
                                                            const gchar* category_type,
                                                            GtkWindow* game_window,
                                                            GamesScoresContextCategoryRequestFunc category_request,
                                                            gpointer category_request_target,
                                                            GamesScoresStyle style,
                                                            GamesScoresImporter* importer,
                                                            const gchar* icon_name)
{
	GamesScoresContext * self = NULL;
	Block2Data* _data2_;
	const gchar* _tmp0_ = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->category_request = category_request;
	_data2_->category_request_target = category_request_target;
	_tmp0_ = icon_name;
	if (_tmp0_ == NULL) {
		_tmp0_ = app_name;
	}
	self = (GamesScoresContext*) g_object_new (object_type, "app-name", app_name, "category-type", category_type, "game-window", game_window, "style", style, "importer", importer, "icon-name", _tmp0_, NULL);
	_data2_->self = g_object_ref (self);
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = ___lambda8__games_scores_context_category_request_func;
	self->priv->category_request_target = block2_data_ref (_data2_);
	self->priv->category_request_target_destroy_notify = block2_data_unref;
	{
		games_scores_context_load_scores_from_files (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("context.vala:229: Failed to load scores: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

GamesScoresContext*
games_scores_context_new_with_importer_and_icon_name (const gchar* app_name,
                                                      const gchar* category_type,
                                                      GtkWindow* game_window,
                                                      GamesScoresContextCategoryRequestFunc category_request,
                                                      gpointer category_request_target,
                                                      GamesScoresStyle style,
                                                      GamesScoresImporter* importer,
                                                      const gchar* icon_name)
{
	return games_scores_context_construct_with_importer_and_icon_name (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style, importer, icon_name);
}

static void
games_scores_context_real_constructed (GObject* base)
{
	GamesScoresContext * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GamesScoresImporter* _tmp3_;
	self = (GamesScoresContext*) base;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = self->priv->_app_name;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, "scores", NULL, NULL);
	_g_free0 (self->priv->user_score_dir);
	self->priv->user_score_dir = _tmp2_;
	_tmp3_ = self->priv->_importer;
	if (_tmp3_ != NULL) {
		GamesScoresImporter* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_importer;
		_tmp5_ = self->priv->user_score_dir;
		games_scores_importer_run (_tmp4_, self, _tmp5_);
	}
}

GList*
games_scores_context_get_categories (GamesScoresContext* self)
{
	GList* categories = NULL;
	GeeMapIterator* iterator = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	categories = NULL;
	_tmp0_ = self->priv->scores_per_category;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	iterator = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		_tmp2_ = iterator;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iterator;
		_tmp4_ = gee_map_iterator_get_key (_tmp3_);
		categories = g_list_append (categories, (GamesScoresCategory*) _tmp4_);
	}
	result = categories;
	_g_object_unref0 (iterator);
	return result;
}

void
games_scores_context_update_score_name (GamesScoresContext* self,
                                        GamesScoresScore* old_score,
                                        GamesScoresCategory* category,
                                        const gchar* new_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_score != NULL);
	g_return_if_fail (category != NULL);
	g_return_if_fail (new_name != NULL);
	{
		GeeList* _score_list = NULL;
		GeeHashMap* _tmp0_;
		gpointer _tmp1_;
		gint _score_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _score_index = 0;
		_tmp0_ = self->priv->scores_per_category;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, category);
		_score_list = (GeeList*) _tmp1_;
		_tmp2_ = _score_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_score_size = _tmp4_;
		_score_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GamesScoresScore* score = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GamesScoresScore* _tmp9_;
			_score_index = _score_index + 1;
			_tmp5_ = _score_index;
			_tmp6_ = _score_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _score_list;
			_tmp8_ = gee_list_get (_tmp7_, _score_index);
			score = (GamesScoresScore*) _tmp8_;
			_tmp9_ = score;
			if (games_scores_score_equals (_tmp9_, old_score)) {
				GamesScoresScore* _tmp10_;
				_tmp10_ = score;
				games_scores_score_set_user (_tmp10_, new_name);
				_g_object_unref0 (score);
				_g_object_unref0 (_score_list);
				return;
			}
			_g_object_unref0 (score);
		}
		_g_object_unref0 (_score_list);
	}
	g_assert_not_reached ();
}

/**
     * Get the best n scores from the given category, sorted.
     *
     */
static gint
_games_scores_score_score_greater_sorter_gcompare_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self)
{
	gint result;
	result = games_scores_score_score_greater_sorter ((GamesScoresScore*) a, (GamesScoresScore*) b);
	return result;
}

static gint
_games_scores_score_score_less_sorter_gcompare_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self)
{
	gint result;
	result = games_scores_score_score_less_sorter ((GamesScoresScore*) a, (GamesScoresScore*) b);
	return result;
}

GeeList*
games_scores_context_get_high_scores (GamesScoresContext* self,
                                      GamesScoresCategory* category,
                                      gint n)
{
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GamesScoresStyle _tmp3_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->scores_per_category;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, category)) {
		result = (GeeList*) _result_;
		return result;
	}
	_tmp3_ = self->priv->_style;
	if (_tmp3_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp2_ = TRUE;
	} else {
		GamesScoresStyle _tmp4_;
		_tmp4_ = self->priv->_style;
		_tmp2_ = _tmp4_ == GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER;
	}
	if (_tmp2_) {
		GeeHashMap* _tmp5_;
		gpointer _tmp6_;
		GeeList* _tmp7_;
		_tmp5_ = self->priv->scores_per_category;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, category);
		_tmp7_ = (GeeList*) _tmp6_;
		gee_list_sort (_tmp7_, _games_scores_score_score_greater_sorter_gcompare_data_func, NULL, NULL);
		_g_object_unref0 (_tmp7_);
	} else {
		GeeHashMap* _tmp8_;
		gpointer _tmp9_;
		GeeList* _tmp10_;
		_tmp8_ = self->priv->scores_per_category;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, category);
		_tmp10_ = (GeeList*) _tmp9_;
		gee_list_sort (_tmp10_, _games_scores_score_score_less_sorter_gcompare_data_func, NULL, NULL);
		_g_object_unref0 (_tmp10_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_ = FALSE;
				GamesScoresScore* score = NULL;
				GeeHashMap* _tmp19_;
				gpointer _tmp20_;
				GeeList* _tmp21_;
				gpointer _tmp22_;
				GamesScoresScore* _tmp23_;
				GamesScoresScore* _tmp24_;
				GeeArrayList* _tmp25_;
				GamesScoresScore* _tmp26_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (i < n) {
					GeeHashMap* _tmp14_;
					gpointer _tmp15_;
					GeeList* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp14_ = self->priv->scores_per_category;
					_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, category);
					_tmp16_ = (GeeList*) _tmp15_;
					_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp13_ = i < _tmp18_;
					_g_object_unref0 (_tmp16_);
				} else {
					_tmp13_ = FALSE;
				}
				if (!_tmp13_) {
					break;
				}
				_tmp19_ = self->priv->scores_per_category;
				_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, category);
				_tmp21_ = (GeeList*) _tmp20_;
				_tmp22_ = gee_list_get (_tmp21_, i);
				_tmp23_ = (GamesScoresScore*) _tmp22_;
				_g_object_unref0 (_tmp21_);
				score = _tmp23_;
				_tmp24_ = score;
				_tmp24_->rank = (guint) (i + 1);
				_tmp25_ = _result_;
				_tmp26_ = score;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
				_g_object_unref0 (score);
			}
		}
	}
	result = (GeeList*) _result_;
	return result;
}

static gboolean
games_scores_context_is_high_score (GamesScoresContext* self,
                                    glong score_value,
                                    GamesScoresCategory* category)
{
	GeeList* best_scores = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong lowest = 0L;
	GeeList* _tmp5_;
	gpointer _tmp6_;
	GamesScoresScore* _tmp7_;
	glong _tmp8_;
	glong _tmp9_;
	glong _tmp10_;
	gboolean _tmp11_ = FALSE;
	GamesScoresStyle _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (category != NULL, FALSE);
	_tmp0_ = games_scores_context_get_high_scores (self, category, 10);
	best_scores = _tmp0_;
	_tmp1_ = best_scores;
	if (_tmp1_ == NULL) {
		result = TRUE;
		_g_object_unref0 (best_scores);
		return result;
	}
	_tmp2_ = best_scores;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ < 10) {
		result = TRUE;
		_g_object_unref0 (best_scores);
		return result;
	}
	_tmp5_ = best_scores;
	_tmp6_ = gee_list_get (_tmp5_, 9);
	_tmp7_ = (GamesScoresScore*) _tmp6_;
	_tmp8_ = games_scores_score_get_score (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp7_);
	lowest = _tmp10_;
	_tmp12_ = self->priv->_style;
	if (_tmp12_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER) {
		_tmp11_ = TRUE;
	} else {
		GamesScoresStyle _tmp13_;
		_tmp13_ = self->priv->_style;
		_tmp11_ = _tmp13_ == GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER;
	}
	if (_tmp11_) {
		result = score_value < lowest;
		_g_object_unref0 (best_scores);
		return result;
	}
	result = score_value > lowest;
	_g_object_unref0 (best_scores);
	return result;
}

static void
games_scores_context_save_score_to_file_data_free (gpointer _data)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->score);
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextSaveScoreToFileData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_scores_context_save_score_to_file (GamesScoresContext* self,
                                         GamesScoresScore* score,
                                         GamesScoresCategory* category,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (score != NULL);
	g_return_if_fail (category != NULL);
	_data_ = g_slice_new0 (GamesScoresContextSaveScoreToFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_save_score_to_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (score);
	_g_object_unref0 (_data_->score);
	_data_->score = _tmp1_;
	_tmp2_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	games_scores_context_save_score_to_file_co (_data_);
}

static void
games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
games_scores_context_save_score_to_file_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_context_save_score_to_file_co (_data_);
}

static gboolean
games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->user_score_dir;
	if (g_mkdir_with_parents (_data_->_tmp0_, 0766) == -1) {
		_data_->_tmp1_ = _data_->self->priv->user_score_dir;
		_data_->_tmp2_ = g_strerror (errno);
		_data_->_tmp3_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Failed to create %s: %s", _data_->_tmp1_, _data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->user_score_dir;
	_data_->_tmp5_ = games_scores_category_get_key (_data_->category);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_build_filename (_data_->_tmp4_, _data_->_tmp6_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_file_new_for_path (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_free0 (_data_->_tmp8_);
	_data_->file = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->file;
	_data_->_tmp12_ = g_file_append_to (_data_->_tmp11_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error0_);
	_data_->stream = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = games_scores_score_get_score (_data_->score);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = g_strdup_printf ("%li", _data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = games_scores_score_get_time (_data_->score);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = games_scores_score_get_user (_data_->score);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = string_to_string (_data_->_tmp22_);
	_data_->_tmp24_ = g_strconcat (_data_->_tmp16_, " ", _data_->_tmp20_, " ", _data_->_tmp23_, "\n", NULL);
	_data_->_tmp25_ = _data_->_tmp24_;
	_g_free0 (_data_->_tmp20_);
	_g_free0 (_data_->_tmp16_);
	_data_->line = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->stream;
	_data_->_tmp27_ = _data_->line;
	_data_->_tmp29_ = 0;
	_data_->_tmp28_ = string_get_data (_data_->_tmp27_, &_data_->_tmp29_);
	_data_->_tmp28__length1 = _data_->_tmp29_;
	_data_->_tmp30_ = _data_->_tmp28_;
	_data_->_tmp30__length1 = _data_->_tmp28__length1;
	_data_->_state_ = 1;
	g_output_stream_write_all_async ((GOutputStream*) _data_->_tmp26_, _data_->_tmp30_, (gsize) _data_->_tmp30__length1, G_PRIORITY_DEFAULT, _data_->cancellable, games_scores_context_save_score_to_file_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_write_all_finish ((GOutputStream*) _data_->_tmp26_, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->stream);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->line);
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_scores_context_add_score_internal_data_free (gpointer _data)
{
	GamesScoresContextAddScoreInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->score);
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextAddScoreInternalData, _data_);
}

void
games_scores_context_add_score_internal (GamesScoresContext* self,
                                         GamesScoresScore* score,
                                         GamesScoresCategory* category,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GamesScoresContextAddScoreInternalData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (score != NULL);
	g_return_if_fail (category != NULL);
	_data_ = g_slice_new0 (GamesScoresContextAddScoreInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (score);
	_g_object_unref0 (_data_->score);
	_data_->score = _tmp1_;
	_tmp2_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	games_scores_context_add_score_internal_co (_data_);
}

gboolean
games_scores_context_add_score_internal_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda26_ (Block3Data* _data3_)
{
	GamesScoresContext* self;
	self = _data3_->self;
	games_scores_context_add_score_internal_co (_data3_->_async_data_);
}

static void
____lambda26__adw_dialog_closed (AdwDialog* _sender,
                                 gpointer self)
{
	___lambda26_ (self);
}

static void
games_scores_context_add_score_internal_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GamesScoresContextAddScoreInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_context_add_score_internal_co (_data_);
}

static gboolean
games_scores_context_add_score_internal_co (GamesScoresContextAddScoreInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->scores_per_category;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp0_, _data_->category)) {
		_data_->_tmp1_ = _data_->self->priv->scores_per_category;
		_data_->_tmp2_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_data_->_tmp3_ = _data_->_tmp2_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp1_, _data_->category, (GeeList*) _data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp3_);
	}
	_data_->_tmp4_ = _data_->self->priv->scores_per_category;
	_data_->_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp4_, _data_->category);
	_data_->_tmp6_ = (GeeList*) _data_->_tmp5_;
	_data_->_tmp7_ = gee_collection_add ((GeeCollection*) _data_->_tmp6_, _data_->score);
	_g_object_unref0 (_data_->_tmp6_);
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = _g_object_ref0 (_data_->category);
		_g_object_unref0 (_data_->self->priv->current_category);
		_data_->self->priv->current_category = _data_->_tmp8_;
	}
	_data_->_tmp9_ = games_scores_score_get_score (_data_->score);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->high_score_added = games_scores_context_is_high_score (_data_->self, _data_->_tmp10_, _data_->category);
	if (_data_->high_score_added) {
		_data_->_tmp12_ = _data_->self->priv->_game_window;
		_data_->_tmp11_ = _data_->_tmp12_ != NULL;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	if (_data_->_tmp11_) {
		_data_->_tmp13_ = _data_->self->priv->_category_type;
		_data_->_tmp14_ = _data_->self->priv->_style;
		_data_->_tmp15_ = _data_->self->priv->current_category;
		_data_->_tmp16_ = _data_->self->priv->_icon_name;
		_data_->_tmp17_ = games_scores_dialog_new (_data_->self, _data_->_tmp13_, _data_->_tmp14_, _data_->score, _data_->_tmp15_, _data_->_tmp16_);
		g_object_ref_sink (_data_->_tmp17_);
		_data_->dialog = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->dialog;
		g_signal_connect_data ((AdwDialog*) _data_->_tmp18_, "closed", (GCallback) ____lambda26__adw_dialog_closed, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
		_data_->_tmp19_ = _data_->dialog;
		_data_->_tmp20_ = _data_->self->priv->_game_window;
		adw_dialog_present ((AdwDialog*) _data_->_tmp19_, (GtkWidget*) _data_->_tmp20_);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_g_object_unref0 (_data_->dialog);
	}
	_data_->_state_ = 2;
	games_scores_context_save_score_to_file (_data_->self, _data_->score, _data_->category, _data_->cancellable, games_scores_context_add_score_internal_ready, _data_);
	return FALSE;
	_state_2:
	games_scores_context_save_score_to_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->high_score_added;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_scores_context_add_score_data_free (gpointer _data)
{
	GamesScoresContextAddScoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextAddScoreData, _data_);
}

void
games_scores_context_add_score (GamesScoresContext* self,
                                glong score,
                                GamesScoresCategory* category,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_data_ = g_slice_new0 (GamesScoresContextAddScoreData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->score = score;
	_tmp1_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	games_scores_context_add_score_co (_data_);
}

gboolean
games_scores_context_add_score_finish (GamesScoresContext* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Returns true if a dialog was launched on attaining high score.
     *
     */
static void
games_scores_context_add_score_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_context_add_score_co (_data_);
}

static gboolean
games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = games_scores_score_new (_data_->score, (gint64) 0, NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	games_scores_context_add_score_internal (_data_->self, _data_->_tmp2_, _data_->category, _data_->cancellable, games_scores_context_add_score_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = games_scores_context_add_score_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp0_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_scores_context_add_score_full_data_free (gpointer _data)
{
	GamesScoresContextAddScoreFullData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextAddScoreFullData, _data_);
}

void
games_scores_context_add_score_full (GamesScoresContext* self,
                                     glong score_value,
                                     GamesScoresCategory* category,
                                     GamesScoresContextNewGameFunc new_game_func,
                                     gpointer new_game_func_target,
                                     GamesScoresContextQuitAppFunc quit_app_func,
                                     gpointer quit_app_func_target,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GamesScoresContextAddScoreFullData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_data_ = g_slice_new0 (GamesScoresContextAddScoreFullData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_full_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->score_value = score_value;
	_tmp1_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp1_;
	_data_->new_game_func = new_game_func;
	_data_->new_game_func_target = new_game_func_target;
	_data_->quit_app_func = quit_app_func;
	_data_->quit_app_func_target = quit_app_func_target;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	games_scores_context_add_score_full_co (_data_);
}

gboolean
games_scores_context_add_score_full_finish (GamesScoresContext* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreFullData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Adds some buttons to the bottom of the dialog that aid the flow of a game that chooses to use it.
     *
     * ``new_game_func`` is called when the user presses the 'New Game' button on the dialog
     *
     * ``quit_app_func`` is called when the user presses the 'Quit' button on the dialog
     *
     */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda27_ (Block4Data* _data4_)
{
	GamesScoresContext* self;
	self = _data4_->self;
	games_scores_context_add_score_full_co (_data4_->_async_data_);
}

static void
____lambda27__adw_dialog_closed (AdwDialog* _sender,
                                 gpointer self)
{
	___lambda27_ (self);
}

static void
games_scores_context_add_score_full_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GamesScoresContextAddScoreFullData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_context_add_score_full_co (_data_);
}

static gboolean
games_scores_context_add_score_full_co (GamesScoresContextAddScoreFullData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = games_scores_score_new (_data_->score_value, (gint64) 0, NULL);
	_data_->score = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->scores_per_category;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp1_, _data_->category)) {
		_data_->_tmp2_ = _data_->self->priv->scores_per_category;
		_data_->_tmp3_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_data_->_tmp4_ = _data_->_tmp3_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp2_, _data_->category, (GeeList*) _data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp4_);
	}
	_data_->_tmp5_ = _data_->self->priv->scores_per_category;
	_data_->_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp5_, _data_->category);
	_data_->_tmp7_ = (GeeList*) _data_->_tmp6_;
	_data_->_tmp8_ = _data_->score;
	_data_->_tmp9_ = gee_collection_add ((GeeCollection*) _data_->_tmp7_, _data_->_tmp8_);
	_g_object_unref0 (_data_->_tmp7_);
	if (_data_->_tmp9_) {
		_data_->_tmp10_ = _g_object_ref0 (_data_->category);
		_g_object_unref0 (_data_->self->priv->current_category);
		_data_->self->priv->current_category = _data_->_tmp10_;
	}
	_data_->_tmp11_ = _data_->score;
	_data_->_tmp12_ = games_scores_score_get_score (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->high_score_added = games_scores_context_is_high_score (_data_->self, _data_->_tmp13_, _data_->category);
	if (_data_->high_score_added) {
		_data_->_tmp14_ = _data_->self->priv->_category_type;
		_data_->_tmp15_ = _data_->self->priv->_style;
		_data_->_tmp16_ = _data_->score;
		_data_->_tmp17_ = _data_->self->priv->current_category;
		_data_->_tmp18_ = _data_->self->priv->_icon_name;
		_data_->_tmp19_ = games_scores_dialog_new (_data_->self, _data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
		g_object_ref_sink (_data_->_tmp19_);
		_data_->dialog = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->dialog;
		g_signal_connect_data ((AdwDialog*) _data_->_tmp20_, "closed", (GCallback) ____lambda27__adw_dialog_closed, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
		_data_->_tmp21_ = _data_->dialog;
		_data_->_tmp22_ = _data_->self->priv->_game_window;
		adw_dialog_present ((AdwDialog*) _data_->_tmp21_, (GtkWidget*) _data_->_tmp22_);
		_data_->_tmp23_ = _data_->dialog;
		games_scores_dialog_add_bottom_buttons (_data_->_tmp23_, _data_->new_game_func, _data_->new_game_func_target, _data_->quit_app_func, _data_->quit_app_func_target);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_g_object_unref0 (_data_->dialog);
	}
	_data_->_tmp24_ = _data_->score;
	_data_->_state_ = 2;
	games_scores_context_save_score_to_file (_data_->self, _data_->_tmp24_, _data_->category, _data_->cancellable, games_scores_context_add_score_full_ready, _data_);
	return FALSE;
	_state_2:
	games_scores_context_save_score_to_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->score);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->high_score_added;
	_g_object_unref0 (_data_->score);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		((GString*) _tmp4_)->str = NULL;
		result = _tmp5_;
		_g_string_free0 (ret);
		return result;
	}
}

static glong
long_parse (const gchar* str,
            guint _base)
{
	glong result;
	g_return_val_if_fail (str != NULL, 0L);
	result = strtol (str, NULL, (gint) _base);
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static void
games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                            GFileInfo* file_info,
                                            GError** error)
{
	gchar* category_key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GamesScoresCategory* category = NULL;
	GamesScoresContextCategoryRequestFunc _tmp2_;
	gpointer _tmp2__target;
	const gchar* _tmp3_;
	GamesScoresCategory* _tmp4_;
	GamesScoresCategory* _tmp5_;
	gchar* filename = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GeeArrayList* scores_of_single_category = NULL;
	GeeArrayList* _tmp9_;
	FILE* stream = NULL;
	const gchar* _tmp10_;
	FILE* _tmp11_;
	gchar* line = NULL;
	GeeHashMap* _tmp44_;
	GamesScoresCategory* _tmp45_;
	GeeArrayList* _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_info != NULL);
	_tmp0_ = g_file_info_get_name (file_info);
	_tmp1_ = g_strdup (_tmp0_);
	category_key = _tmp1_;
	_tmp2_ = self->priv->category_request;
	_tmp2__target = self->priv->category_request_target;
	_tmp3_ = category_key;
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
	category = _tmp4_;
	_tmp5_ = category;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (category);
		_g_free0 (category_key);
		return;
	}
	_tmp6_ = self->priv->user_score_dir;
	_tmp7_ = category_key;
	_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
	filename = _tmp8_;
	_tmp9_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	scores_of_single_category = _tmp9_;
	_tmp10_ = filename;
	_tmp11_ = g_fopen (_tmp10_, "r");
	stream = _tmp11_;
	while (TRUE) {
		FILE* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar** tokens = NULL;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar* user = NULL;
		gchar** _tmp18_;
		gint _tmp18__length1;
		glong score_value = 0L;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gint64 time = 0LL;
		gchar** _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gchar** _tmp34_;
		gint _tmp34__length1;
		GeeArrayList* _tmp40_;
		const gchar* _tmp41_;
		GamesScoresScore* _tmp42_;
		GamesScoresScore* _tmp43_;
		_tmp12_ = stream;
		_tmp13_ = g_file_stream_read_line (_tmp12_);
		_g_free0 (line);
		line = _tmp13_;
		_tmp14_ = line;
		if (!(_tmp14_ != NULL)) {
			break;
		}
		_tmp15_ = line;
		_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, " ", 3);
		tokens = _tmp17_;
		tokens_length1 = _vala_array_length (_tmp16_);
		_tokens_size_ = tokens_length1;
		user = NULL;
		_tmp18_ = tokens;
		_tmp18__length1 = tokens_length1;
		if (_tmp18__length1 < 2) {
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = line;
			_tmp20_ = filename;
			g_warning ("context.vala:417: Failed to read malformed score %s in %s.", _tmp19_, _tmp20_);
			_g_free0 (user);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			continue;
		}
		_tmp21_ = tokens;
		_tmp21__length1 = tokens_length1;
		_tmp22_ = _tmp21_[0];
		score_value = long_parse (_tmp22_, (guint) 0);
		_tmp23_ = tokens;
		_tmp23__length1 = tokens_length1;
		_tmp24_ = _tmp23_[1];
		time = int64_parse (_tmp24_, (guint) 0);
		if (score_value == ((glong) 0)) {
			gchar** _tmp27_;
			gint _tmp27__length1;
			const gchar* _tmp28_;
			_tmp27_ = tokens;
			_tmp27__length1 = tokens_length1;
			_tmp28_ = _tmp27_[0];
			_tmp26_ = g_strcmp0 (_tmp28_, "0") != 0;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			_tmp25_ = TRUE;
		} else {
			gboolean _tmp29_ = FALSE;
			if (time == ((gint64) 0)) {
				gchar** _tmp30_;
				gint _tmp30__length1;
				const gchar* _tmp31_;
				_tmp30_ = tokens;
				_tmp30__length1 = tokens_length1;
				_tmp31_ = _tmp30_[1];
				_tmp29_ = g_strcmp0 (_tmp31_, "0") != 0;
			} else {
				_tmp29_ = FALSE;
			}
			_tmp25_ = _tmp29_;
		}
		if (_tmp25_) {
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp32_ = line;
			_tmp33_ = filename;
			g_warning ("context.vala:427: Failed to read malformed score %s in %s.", _tmp32_, _tmp33_);
			_g_free0 (user);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			continue;
		}
		_tmp34_ = tokens;
		_tmp34__length1 = tokens_length1;
		if (_tmp34__length1 == 3) {
			gchar** _tmp35_;
			gint _tmp35__length1;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp35_ = tokens;
			_tmp35__length1 = tokens_length1;
			_tmp36_ = _tmp35_[2];
			_tmp37_ = g_strdup (_tmp36_);
			_g_free0 (user);
			user = _tmp37_;
		} else {
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp38_ = line;
			_tmp39_ = filename;
			g_debug ("context.vala:434: Assuming current username for old score %s in %s.", _tmp38_, _tmp39_);
		}
		_tmp40_ = scores_of_single_category;
		_tmp41_ = user;
		_tmp42_ = games_scores_score_new (score_value, time, _tmp41_);
		_tmp43_ = _tmp42_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp43_);
		_g_object_unref0 (_tmp43_);
		_g_free0 (user);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp44_ = self->priv->scores_per_category;
	_tmp45_ = category;
	_tmp46_ = scores_of_single_category;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp44_, _tmp45_, (GeeList*) _tmp46_);
	_g_free0 (line);
	_fclose0 (stream);
	_g_object_unref0 (scores_of_single_category);
	_g_free0 (filename);
	_g_object_unref0 (category);
	_g_free0 (category_key);
}

static void
games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                             GError** error)
{
	gboolean _tmp0_ = FALSE;
	GtkWindow* _tmp1_;
	GFile* directory = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp8_;
	GFileEnumerator* _tmp9_;
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (!self->priv->scores_loaded, "!scores_loaded");
	self->priv->scores_loaded = TRUE;
	_tmp1_ = self->priv->_game_window;
	if (_tmp1_ != NULL) {
		GtkWindow* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_game_window;
		_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_error ("context.vala:449: %s", "The application window associated with the GamesScoresContext " "was set visible before loading scores. The Context performs " "synchronous I/O in the default main context to load scores, so " "so you should do this before showing your main window.");
	}
	_tmp5_ = self->priv->user_score_dir;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	directory = _tmp6_;
	_tmp7_ = directory;
	if (!g_file_query_exists (_tmp7_, NULL)) {
		_g_object_unref0 (directory);
		return;
	}
	_tmp8_ = directory;
	_tmp9_ = g_file_enumerate_children (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
	enumerator = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (directory);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp10_ = NULL;
		GFileEnumerator* _tmp11_;
		GFileInfo* _tmp12_;
		GFileInfo* _tmp13_;
		GFileInfo* _tmp14_;
		GFileInfo* _tmp15_;
		_tmp11_ = enumerator;
		_tmp12_ = g_file_enumerator_next_file (_tmp11_, NULL, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			return;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp13_;
		_tmp14_ = file_info;
		if (!(_tmp14_ != NULL)) {
			_g_object_unref0 (_tmp10_);
			break;
		}
		_tmp15_ = file_info;
		games_scores_context_load_scores_from_file (self, _tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			return;
		}
		_g_object_unref0 (_tmp10_);
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (directory);
}

/**
     * Must be called *immediately* after construction, if constructed using
     * g_object_new.
     *
     */
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static GamesScoresCategory*
__lambda28_ (Block5Data* _data5_,
             const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* result;
	self = _data5_->self;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = _data5_->category_request (key, _data5_->category_request_target);
	result = _tmp0_;
	return result;
}

static GamesScoresCategory*
___lambda28__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda28_ (self, category_key);
	return result;
}

void
games_scores_context_load_scores (GamesScoresContext* self,
                                  GamesScoresContextCategoryRequestFunc category_request,
                                  gpointer category_request_target,
                                  GError** error)
{
	GamesScoresContextCategoryRequestFunc _tmp0_;
	gpointer _tmp0__target;
	Block5Data* _data5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_request;
	_tmp0__target = self->priv->category_request_target;
	_vala_return_if_fail (_tmp0_ == NULL, "this.category_request == null");
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->category_request = category_request;
	_data5_->category_request_target = category_request_target;
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = ___lambda28__games_scores_context_category_request_func;
	self->priv->category_request_target = block5_data_ref (_data5_);
	self->priv->category_request_target_destroy_notify = block5_data_unref;
	games_scores_context_load_scores_from_files (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data6_->self;
		_g_main_loop_unref0 (_data6_->main_loop);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda29_ (Block6Data* _data6_)
{
	GamesScoresContext* self;
	self = _data6_->self;
	g_main_loop_quit (_data6_->main_loop);
}

static void
___lambda29__adw_dialog_closed (AdwDialog* _sender,
                                gpointer self)
{
	__lambda29_ (self);
}

void
games_scores_context_run_dialog (GamesScoresContext* self)
{
	GtkWindow* _tmp0_;
	Block6Data* _data6_;
	GMainLoop* _tmp1_;
	GamesScoresDialog* dialog = NULL;
	const gchar* _tmp2_;
	GamesScoresStyle _tmp3_;
	GamesScoresCategory* _tmp4_;
	const gchar* _tmp5_;
	GamesScoresDialog* _tmp6_;
	GtkWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_window;
	_vala_return_if_fail (_tmp0_ != NULL, "game_window != null");
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp1_ = g_main_loop_new (NULL, FALSE);
	_data6_->main_loop = _tmp1_;
	_tmp2_ = self->priv->_category_type;
	_tmp3_ = self->priv->_style;
	_tmp4_ = self->priv->current_category;
	_tmp5_ = self->priv->_icon_name;
	_tmp6_ = games_scores_dialog_new (self, _tmp2_, _tmp3_, NULL, _tmp4_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	dialog = _tmp6_;
	g_signal_connect_data ((AdwDialog*) dialog, "closed", (GCallback) ___lambda29__adw_dialog_closed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp7_ = self->priv->_game_window;
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) _tmp7_);
	g_main_loop_run (_data6_->main_loop);
	_g_object_unref0 (dialog);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

/**
     * Presents the score dialog on top of ``game_window``.
     *
     */
static void
__lambda30_ (GamesScoresContext* self)
{
	g_signal_emit (self, games_scores_context_signals[GAMES_SCORES_CONTEXT_DIALOG_CLOSED_SIGNAL], 0);
}

static void
___lambda30__adw_dialog_closed (AdwDialog* _sender,
                                gpointer self)
{
	__lambda30_ ((GamesScoresContext*) self);
}

void
games_scores_context_present_dialog (GamesScoresContext* self)
{
	GtkWindow* _tmp0_;
	GamesScoresDialog* dialog = NULL;
	const gchar* _tmp1_;
	GamesScoresStyle _tmp2_;
	GamesScoresCategory* _tmp3_;
	const gchar* _tmp4_;
	GamesScoresDialog* _tmp5_;
	GtkWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_window;
	_vala_return_if_fail (_tmp0_ != NULL, "game_window != null");
	_tmp1_ = self->priv->_category_type;
	_tmp2_ = self->priv->_style;
	_tmp3_ = self->priv->current_category;
	_tmp4_ = self->priv->_icon_name;
	_tmp5_ = games_scores_dialog_new (self, _tmp1_, _tmp2_, NULL, _tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	g_signal_connect_object ((AdwDialog*) dialog, "closed", (GCallback) ___lambda30__adw_dialog_closed, self, 0);
	_tmp6_ = self->priv->_game_window;
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) _tmp6_);
	_g_object_unref0 (dialog);
}

/**
     * Returns true if this contains {@link Games.Scores.Score}s.
     *
     */
gboolean
games_scores_context_has_scores (GamesScoresContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeIterator* _scores_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->scores_per_category;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_scores_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeList* scores = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp6_ = _scores_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _scores_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			scores = (GeeList*) _tmp8_;
			_tmp9_ = scores;
			_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ > 0) {
				result = TRUE;
				_g_object_unref0 (scores);
				_g_object_unref0 (_scores_it);
				return result;
			}
			_g_object_unref0 (scores);
		}
		_g_object_unref0 (_scores_it);
	}
	result = FALSE;
	return result;
}

const gchar*
games_scores_context_get_app_name (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_name;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_app_name (GamesScoresContext* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_app_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_name);
		self->priv->_app_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY]);
	}
}

const gchar*
games_scores_context_get_category_type (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category_type;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_category_type (GamesScoresContext* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_category_type (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category_type);
		self->priv->_category_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY]);
	}
}

GtkWindow*
games_scores_context_get_game_window (GamesScoresContext* self)
{
	GtkWindow* result;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game_window;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_game_window (GamesScoresContext* self,
                                      GtkWindow* value)
{
	GtkWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_game_window (self);
	if (old_value != value) {
		GtkWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_game_window);
		self->priv->_game_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY]);
	}
}

GamesScoresStyle
games_scores_context_get_style (GamesScoresContext* self)
{
	GamesScoresStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_style;
	return result;
}

static void
games_scores_context_set_style (GamesScoresContext* self,
                                GamesScoresStyle value)
{
	GamesScoresStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_style (self);
	if (old_value != value) {
		self->priv->_style = value;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY]);
	}
}

const gchar*
games_scores_context_get_icon_name (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_icon_name (GamesScoresContext* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY]);
	}
}

/**
     * The {@link [Games.Scores.Importer]} for the context (eg. HistoryFileImporter).
     *
     */
GamesScoresImporter*
games_scores_context_get_importer (GamesScoresContext* self)
{
	GamesScoresImporter* result;
	GamesScoresImporter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_importer;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_importer (GamesScoresContext* self,
                                   GamesScoresImporter* value)
{
	GamesScoresImporter* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_context_get_importer (self);
	if (old_value != value) {
		GamesScoresImporter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_importer);
		self->priv->_importer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY]);
	}
}

static void
games_scores_context_base_init (GamesScoresContextClass * klass)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ != NULL) {
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp3_;
		GtkCssProvider* _tmp4_;
		GdkDisplay* _tmp5_;
		GtkCssProvider* _tmp6_;
		_tmp3_ = gtk_css_provider_new ();
		provider = _tmp3_;
		_tmp4_ = provider;
		gtk_css_provider_load_from_string (_tmp4_, GAMES_SCORES_DIALOG_STYLE);
		_tmp5_ = display;
		_tmp6_ = provider;
		gtk_style_context_add_provider_for_display (_tmp5_, (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (provider);
	}
	_g_object_unref0 (display);
}

static void
games_scores_context_class_init (GamesScoresContextClass * klass,
                                 gpointer klass_data)
{
	games_scores_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresContext_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) games_scores_context_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_scores_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_scores_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_scores_context_finalize;
	/**
	     * An App ID (e.g. ``org.gnome.Mines``).
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Describes all of the categories (e.g. "Minefield", "Level").
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY] = g_param_spec_string ("category-type", "category-type", "category-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The window that the game will be inside of, this is the window the score dialog will be presented upon.
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY] = g_param_spec_object ("game-window", "game-window", "game-window", gtk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The {@link Games.Scores.Style} that the context should use.
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_STYLE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY] = g_param_spec_enum ("style", "style", "style", GAMES_SCORES_TYPE_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The ID for the icon that will be used in the score dialog's empty screen (e.g. ``org.gnome.Quadrapassel``).
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY] = g_param_spec_object ("importer", "importer", "importer", GAMES_SCORES_TYPE_IMPORTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_DEPRECATED));
	/**
	     * Emitted when the score dialog is closed.
	     *
	     */
	games_scores_context_signals[GAMES_SCORES_CONTEXT_DIALOG_CLOSED_SIGNAL] = g_signal_new ("dialog-closed", GAMES_SCORES_TYPE_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	games_scores_context_category_hash = __games_scores_context_category_hash_lambda6__gee_hash_data_func;
	games_scores_context_category_hash_target = NULL;
	games_scores_context_category_hash_target_destroy_notify = NULL;
	games_scores_context_category_equal = __games_scores_context_category_equal_lambda7__gee_equal_data_func;
	games_scores_context_category_equal_target = NULL;
	games_scores_context_category_equal_target_destroy_notify = NULL;
}

static void
games_scores_context_instance_init (GamesScoresContext * self,
                                    gpointer klass)
{
	GeeHashDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeHashMap* _tmp2_;
	self->priv = games_scores_context_get_instance_private (self);
	self->priv->current_category = NULL;
	_tmp0_ = games_scores_context_category_hash;
	_tmp0__target = games_scores_context_category_hash_target;
	_tmp0__target_destroy_notify = games_scores_context_category_hash_target_destroy_notify;
	games_scores_context_category_hash = NULL;
	games_scores_context_category_hash_target = NULL;
	games_scores_context_category_hash_target_destroy_notify = NULL;
	_tmp1_ = games_scores_context_category_equal;
	_tmp1__target = games_scores_context_category_equal_target;
	_tmp1__target_destroy_notify = games_scores_context_category_equal_target_destroy_notify;
	games_scores_context_category_equal = NULL;
	games_scores_context_category_equal_target = NULL;
	games_scores_context_category_equal_target_destroy_notify = NULL;
	_tmp2_ = gee_hash_map_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify, NULL, NULL, NULL);
	self->priv->scores_per_category = _tmp2_;
	self->priv->scores_loaded = FALSE;
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
}

static void
games_scores_context_finalize (GObject * obj)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	_g_free0 (self->priv->_app_name);
	_g_free0 (self->priv->_category_type);
	_g_object_unref0 (self->priv->_game_window);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->_importer);
	_g_object_unref0 (self->priv->current_category);
	_g_object_unref0 (self->priv->scores_per_category);
	_g_free0 (self->priv->user_score_dir);
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	G_OBJECT_CLASS (games_scores_context_parent_class)->finalize (obj);
}

/**
 * An object that holds information for using {@link Games.Scores.Score}s.
 *
 */
static GType
games_scores_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresContextClass), (GBaseInitFunc) games_scores_context_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresContext), 0, (GInstanceInitFunc) games_scores_context_instance_init, NULL };
	GType games_scores_context_type_id;
	games_scores_context_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesScoresContext", &g_define_type_info, 0);
	GamesScoresContext_private_offset = g_type_add_instance_private (games_scores_context_type_id, sizeof (GamesScoresContextPrivate));
	return games_scores_context_type_id;
}

GType
games_scores_context_get_type (void)
{
	static volatile gsize games_scores_context_type_id__once = 0;
	if (g_once_init_enter (&games_scores_context_type_id__once)) {
		GType games_scores_context_type_id;
		games_scores_context_type_id = games_scores_context_get_type_once ();
		g_once_init_leave (&games_scores_context_type_id__once, games_scores_context_type_id);
	}
	return games_scores_context_type_id__once;
}

static void
_vala_games_scores_context_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	switch (property_id) {
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
		g_value_set_string (value, games_scores_context_get_app_name (self));
		break;
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
		g_value_set_string (value, games_scores_context_get_category_type (self));
		break;
		case GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY:
		g_value_set_object (value, games_scores_context_get_game_window (self));
		break;
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
		g_value_set_enum (value, games_scores_context_get_style (self));
		break;
		case GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY:
		g_value_set_string (value, games_scores_context_get_icon_name (self));
		break;
		case GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_object (value, games_scores_context_get_importer (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_scores_context_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	switch (property_id) {
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
		games_scores_context_set_app_name (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
		games_scores_context_set_category_type (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY:
		games_scores_context_set_game_window (self, g_value_get_object (value));
		break;
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
		games_scores_context_set_style (self, g_value_get_enum (value));
		break;
		case GAMES_SCORES_CONTEXT_ICON_NAME_PROPERTY:
		games_scores_context_set_icon_name (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		games_scores_context_set_importer (self, g_value_get_object (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

