// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A0__F62

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_64_T_T_3_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx950)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xc9d76384u, 0x991b92dau, 442, 65 }, // c9d76384991b92da = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xdee90d86u, 0x41317536u, 442, 82 }, // dee90d8641317536 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0xbb3588a9u, 0xec39e00du, 442, 16 }, // bb3588a9ec39e00d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx950
    { 0xae14f587u, 0x69a55a79u, 297, 65 }, // ae14f58769a55a79 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x89123644u, 0xd0d22d0fu, 297, 178 }, // 89123644d0d22d0f = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x62102d7eu, 0xaf6d5891u, 297, 82 }, // 62102d7eaf6d5891 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x98acf116u, 0xac049535u, 297, 146 }, // 98acf116ac049535 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_True__CO__wave3_warp4_stg1--Arch_gfx950
    { 0x76ec55e4u, 0xd7f47fdbu, 297, 16 }, // 76ec55e4d7f47fdb = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_32_16_True__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x89499c8fu, 0xcd44edfeu, 312, 65 }, // 89499c8fcd44edfe = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_64_32_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xd003c3f2u, 0xa6dae7e3u, 343, 178 }, // d003c3f2a6dae7e3 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_64_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x17a43f50u, 0x33c3a6d0u, 359, 48 }, // 17a43f5033c3a6d0 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_64_64_True__CO__wave1_warp2_stg1--Arch_gfx950
    { 0x44f77f80u, 0x57c74e6eu, 359, 178 }, // 44f77f8057c74e6e = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_64_64_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x3472bc78u, 0x135b276eu, 374, 48 }, // 3472bc78135b276e = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_128_64_False__CO__wave1_warp2_stg1--Arch_gfx950
    { 0x14def888u, 0x36a42978u, 374, 263 }, // 14def88836a42978 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_128_64_False__CO__wave1_warp4_stg1--Arch_gfx950
    { 0x867eb319u, 0x3fb624e2u, 374, 178 }, // 867eb3193fb624e2 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_128_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x8f014b2fu, 0xa8003b5du, 391, 48 }, // 8f014b2fa8003b5d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_128_64_True__CO__wave1_warp2_stg1--Arch_gfx950
    { 0xf772beabu, 0xacfdec98u, 391, 263 }, // f772beabacfdec98 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_128_64_True__CO__wave1_warp4_stg1--Arch_gfx950
    { 0x7bf8b44eu, 0x1a119375u, 391, 178 }, // 7bf8b44e1a119375 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_128_64_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0xe47decebu, 0x2e75a2a2u, 425, 263 }, // e47deceb2e75a2a2 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx950__P__2_2_128_128_True__CO__wave1_warp4_stg1--Arch_gfx950
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx950_mod0
{{ 0, 7, 7, 3, 5, 7, 7, 7, 2, 6},
 { 4, 6, 3, 3, 8, 2, 3, 3, 3, 1},
 { 8, 8, 9, 9, 9, 9,11, 9, 9,11},
 {16,16,16,18,18,18,18,18,18,18},
 {15,15,15,15,15,15,15,15,15,15},
 {15,15,15,15,14,14,14,14,14,14},
 {15,15,15,12,14,17,14,14,14,14},
 {13,13,13,13,17,17,14,14,14,14},
 {13,13,13,13,12,17,14,14,14,14},
 {13,13,13,13,15,17,14,14,14,10}}
// End of GPU gfx950_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A0__F62 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 11;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 11;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 64
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 3
// Window_left = "i32"
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = "*i32"
// Num_CU = "i32"

// vim: set fileencoding=utf-8

