/* Generated by ./dbus-analyze-types.py.  Do not edit! */
typedef enum
{
	PURPLE_ACCOUNT_REQUEST_AUTHORIZATION = 0 /* Account authorization request */
} PurpleAccountRequestType;

typedef enum
{
	PURPLE_ACCOUNT_RESPONSE_IGNORE = -2,
	PURPLE_ACCOUNT_RESPONSE_DENY = -1,
	PURPLE_ACCOUNT_RESPONSE_PASS = 0,
	PURPLE_ACCOUNT_RESPONSE_ACCEPT = 1
} PurpleAccountRequestResponse;

typedef enum
{
	PURPLE_BLIST_GROUP_NODE,
	PURPLE_BLIST_CONTACT_NODE,
	PURPLE_BLIST_BUDDY_NODE,
	PURPLE_BLIST_CHAT_NODE,
	PURPLE_BLIST_OTHER_NODE

} PurpleBlistNodeType;

typedef enum
{
	PURPLE_BLIST_NODE_FLAG_NO_SAVE      = 1 << 0, /**< node should not be saved with the buddy list */
	PURPLE_BLIST_NODE_FLAG_INVISIBLE    = 1 << 1, /**< node should not be displayed */

} PurpleBlistNodeFlags;

typedef enum
{
	PURPLE_CERTIFICATE_INVALID = 0,
	PURPLE_CERTIFICATE_VALID = 1
} PurpleCertificateVerificationStatus;

typedef enum {
	PURPLE_CERTIFICATE_UNKNOWN_ERROR = -1,

	/* Not an error */
	PURPLE_CERTIFICATE_NO_PROBLEMS = 0,

	/* Non-fatal */
	PURPLE_CERTIFICATE_NON_FATALS_MASK = 0x0000FFFF,

	/* The certificate is self-signed. */
	PURPLE_CERTIFICATE_SELF_SIGNED = 0x01,

	/* The CA is not in libpurple's pool of certificates. */
	PURPLE_CERTIFICATE_CA_UNKNOWN = 0x02,

	/* The current time is before the certificate's specified
	 * activation time.
	 */
	PURPLE_CERTIFICATE_NOT_ACTIVATED = 0x04,

	/* The current time is after the certificate's specified expiration time */
	PURPLE_CERTIFICATE_EXPIRED = 0x08,

	/* The certificate's subject name doesn't match the expected */
	PURPLE_CERTIFICATE_NAME_MISMATCH = 0x10,

	/* No CA pool was found. This shouldn't happen... */
	PURPLE_CERTIFICATE_NO_CA_POOL = 0x20,

	/* Fatal */
	PURPLE_CERTIFICATE_FATALS_MASK = 0xFFFF0000,

	/* The signature chain could not be validated. Due to limitations in the
	 * the current API, this also indicates one of the CA certificates in the
	 * chain is expired (or not yet activated). FIXME 3.0.0 */
	PURPLE_CERTIFICATE_INVALID_CHAIN = 0x10000,

	/* The signature has been revoked. */
	PURPLE_CERTIFICATE_REVOKED = 0x20000,

	PURPLE_CERTIFICATE_LAST = 0x40000,
} PurpleCertificateInvalidityFlags;

typedef enum _PurpleCipherBatchMode {
	PURPLE_CIPHER_BATCH_MODE_ECB,
	PURPLE_CIPHER_BATCH_MODE_CBC
} PurpleCipherBatchMode;

typedef enum _PurpleCipherCaps {
	PURPLE_CIPHER_CAPS_SET_OPT          = 1 << 1,   /**< Set option flag	*/
	PURPLE_CIPHER_CAPS_GET_OPT          = 1 << 2,   /**< Get option flag	*/
	PURPLE_CIPHER_CAPS_INIT             = 1 << 3,   /**< Init flag			*/
	PURPLE_CIPHER_CAPS_RESET            = 1 << 4,   /**< Reset flag			*/
	PURPLE_CIPHER_CAPS_UNINIT           = 1 << 5,   /**< Uninit flag		*/
	PURPLE_CIPHER_CAPS_SET_IV           = 1 << 6,   /**< Set IV flag		*/
	PURPLE_CIPHER_CAPS_APPEND           = 1 << 7,   /**< Append flag		*/
	PURPLE_CIPHER_CAPS_DIGEST           = 1 << 8,   /**< Digest flag		*/
	PURPLE_CIPHER_CAPS_ENCRYPT          = 1 << 9,   /**< Encrypt flag		*/
	PURPLE_CIPHER_CAPS_DECRYPT          = 1 << 10,  /**< Decrypt flag		*/
	PURPLE_CIPHER_CAPS_SET_SALT         = 1 << 11,  /**< Set salt flag		*/
	PURPLE_CIPHER_CAPS_GET_SALT_SIZE    = 1 << 12,  /**< Get salt size flag	*/
	PURPLE_CIPHER_CAPS_SET_KEY          = 1 << 13,  /**< Set key flag		*/
	PURPLE_CIPHER_CAPS_GET_KEY_SIZE     = 1 << 14,  /**< Get key size flag	*/
	PURPLE_CIPHER_CAPS_SET_BATCH_MODE   = 1 << 15,  /**< Set batch mode flag */
	PURPLE_CIPHER_CAPS_GET_BATCH_MODE   = 1 << 16,  /**< Get batch mode flag */
	PURPLE_CIPHER_CAPS_GET_BLOCK_SIZE   = 1 << 17,  /**< The get block size flag */
	PURPLE_CIPHER_CAPS_SET_KEY_WITH_LEN = 1 << 18,  /**< The set key with length flag */
	PURPLE_CIPHER_CAPS_UNKNOWN          = 1 << 19   /**< Unknown			*/
} PurpleCipherCaps;

typedef enum _PurpleCmdStatus {
	PURPLE_CMD_STATUS_OK,
	PURPLE_CMD_STATUS_FAILED,
	PURPLE_CMD_STATUS_NOT_FOUND,
	PURPLE_CMD_STATUS_WRONG_ARGS,
	PURPLE_CMD_STATUS_WRONG_PRPL,
	PURPLE_CMD_STATUS_WRONG_TYPE
} PurpleCmdStatus;

typedef enum _PurpleCmdRet {
	PURPLE_CMD_RET_OK,       /**< Everything's okay; Don't look for another command to call. */
	PURPLE_CMD_RET_FAILED,   /**< The command failed, but stop looking.*/
	PURPLE_CMD_RET_CONTINUE /**< Continue, looking for other commands with the same name to call. */
} PurpleCmdRet;

typedef enum _PurpleCmdPriority {
	PURPLE_CMD_P_VERY_LOW  = -1000,
	PURPLE_CMD_P_LOW       =     0,
	PURPLE_CMD_P_DEFAULT   =  1000,
	PURPLE_CMD_P_PRPL      =  2000,
	PURPLE_CMD_P_PLUGIN    =  3000,
	PURPLE_CMD_P_ALIAS     =  4000,
	PURPLE_CMD_P_HIGH      =  5000,
	PURPLE_CMD_P_VERY_HIGH =  6000
} PurpleCmdPriority;

typedef enum _PurpleCmdFlag {
	/** Command is usable in IMs. */
	PURPLE_CMD_FLAG_IM               = 0x01,
	/** Command is usable in multi-user chats. */
	PURPLE_CMD_FLAG_CHAT             = 0x02,
	/** Command is usable only for a particular prpl. */
	PURPLE_CMD_FLAG_PRPL_ONLY        = 0x04,
	/** Incorrect arguments to this command should be accepted anyway. */
	PURPLE_CMD_FLAG_ALLOW_WRONG_ARGS = 0x08
} PurpleCmdFlag;

typedef enum
{
	PURPLE_CONNECTION_HTML       = 0x0001, /**< Connection sends/receives in 'HTML'. */
	PURPLE_CONNECTION_NO_BGCOLOR = 0x0002, /**< Connection does not send/receive
					           background colors.                  */
	PURPLE_CONNECTION_AUTO_RESP  = 0x0004,  /**< Send auto responses when away.       */
	PURPLE_CONNECTION_FORMATTING_WBFO = 0x0008, /**< The text buffer must be formatted as a whole */
	PURPLE_CONNECTION_NO_NEWLINES = 0x0010, /**< No new lines are allowed in outgoing messages */
	PURPLE_CONNECTION_NO_FONTSIZE = 0x0020, /**< Connection does not send/receive font sizes */
	PURPLE_CONNECTION_NO_URLDESC = 0x0040,  /**< Connection does not support descriptions with links */
	PURPLE_CONNECTION_NO_IMAGES = 0x0080,  /**< Connection does not support sending of images */
	PURPLE_CONNECTION_ALLOW_CUSTOM_SMILEY = 0x0100, /**< Connection supports sending and receiving custom smileys */
	PURPLE_CONNECTION_SUPPORT_MOODS = 0x0200, /**< Connection supports setting moods */
	PURPLE_CONNECTION_SUPPORT_MOOD_MESSAGES = 0x0400 /**< Connection supports setting a message on moods */
} PurpleConnectionFlags;

typedef enum
{
	PURPLE_DISCONNECTED = 0, /**< Disconnected. */
	PURPLE_CONNECTED,        /**< Connected.    */
	PURPLE_CONNECTING        /**< Connecting.   */

} PurpleConnectionState;

typedef enum
{
	/** There was an error sending or receiving on the network socket, or
	 *  there was some protocol error (such as the server sending malformed
	 *  data).
	 */
	PURPLE_CONNECTION_ERROR_NETWORK_ERROR = 0,
	/** The username supplied was not valid. */
	PURPLE_CONNECTION_ERROR_INVALID_USERNAME = 1,
	/** The username, password or some other credential was incorrect.  Use
	 *  #PURPLE_CONNECTION_ERROR_INVALID_USERNAME instead if the username
	 *  is known to be invalid.
	 */
	PURPLE_CONNECTION_ERROR_AUTHENTICATION_FAILED = 2,
	/** libpurple doesn't speak any of the authentication methods the
	 *  server offered.
	 */
	PURPLE_CONNECTION_ERROR_AUTHENTICATION_IMPOSSIBLE = 3,
	/** libpurple was built without SSL support, and the connection needs
	 *  SSL.
	 */
	PURPLE_CONNECTION_ERROR_NO_SSL_SUPPORT = 4,
	/** There was an error negotiating SSL on this connection, or the
	 *  server does not support encryption but an account option was set to
	 *  require it.
	 */
	PURPLE_CONNECTION_ERROR_ENCRYPTION_ERROR = 5,
	/** Someone is already connected to the server using the name you are
	 *  trying to connect with.
	 */
	PURPLE_CONNECTION_ERROR_NAME_IN_USE = 6,

	/** The username/server/other preference for the account isn't valid.
	 *  For instance, on IRC the username cannot contain white space.
	 *  This reason should not be used for incorrect passwords etc: use
	 *  #PURPLE_CONNECTION_ERROR_AUTHENTICATION_FAILED for that.
	 *
	 *  @todo This reason really shouldn't be necessary.  Usernames and
	 *        other account preferences should be validated when the
	 *        account is created.
	 */
	PURPLE_CONNECTION_ERROR_INVALID_SETTINGS = 7,

	/** The server did not provide a SSL certificate. */
	PURPLE_CONNECTION_ERROR_CERT_NOT_PROVIDED = 8,
	/** The server's SSL certificate could not be trusted. */
	PURPLE_CONNECTION_ERROR_CERT_UNTRUSTED = 9,
	/** The server's SSL certificate has expired. */
	PURPLE_CONNECTION_ERROR_CERT_EXPIRED = 10,
	/** The server's SSL certificate is not yet valid. */
	PURPLE_CONNECTION_ERROR_CERT_NOT_ACTIVATED = 11,
	/** The server's SSL certificate did not match its hostname. */
	PURPLE_CONNECTION_ERROR_CERT_HOSTNAME_MISMATCH = 12,
	/** The server's SSL certificate does not have the expected
	 *  fingerprint.
	 */
	PURPLE_CONNECTION_ERROR_CERT_FINGERPRINT_MISMATCH = 13,
	/** The server's SSL certificate is self-signed.  */
	PURPLE_CONNECTION_ERROR_CERT_SELF_SIGNED = 14,
	/** There was some other error validating the server's SSL certificate.
	 */
	PURPLE_CONNECTION_ERROR_CERT_OTHER_ERROR = 15,

	/** Some other error occurred which fits into none of the other
	 *  categories.
	 */
	/* purple_connection_error_reason() in connection.c uses the fact that
	 * this is the last member of the enum when sanity-checking; if other
	 * reasons are added after it, the check must be updated.
	 */
	PURPLE_CONNECTION_ERROR_OTHER_ERROR = 16
} PurpleConnectionError;

typedef enum
{
	PURPLE_CONV_TYPE_UNKNOWN = 0, /**< Unknown conversation type. */
	PURPLE_CONV_TYPE_IM,          /**< Instant Message.           */
	PURPLE_CONV_TYPE_CHAT,        /**< Chat room.                 */
	PURPLE_CONV_TYPE_MISC,        /**< A misc. conversation.      */
	PURPLE_CONV_TYPE_ANY          /**< Any type of conversation.  */

} PurpleConversationType;

typedef enum
{
	PURPLE_CONV_UPDATE_ADD = 0, /**< The buddy associated with the conversation
	                               was added.   */
	PURPLE_CONV_UPDATE_REMOVE,  /**< The buddy associated with the conversation
	                               was removed. */
	PURPLE_CONV_UPDATE_ACCOUNT, /**< The purple_account was changed. */
	PURPLE_CONV_UPDATE_TYPING,  /**< The typing state was updated. */
	PURPLE_CONV_UPDATE_UNSEEN,  /**< The unseen state was updated. */
	PURPLE_CONV_UPDATE_LOGGING, /**< Logging for this conversation was
	                               enabled or disabled. */
	PURPLE_CONV_UPDATE_TOPIC,   /**< The topic for a chat was updated. */
	/*
	 * XXX These need to go when we implement a more generic core/UI event
	 * system.
	 */
	PURPLE_CONV_ACCOUNT_ONLINE,  /**< One of the user's accounts went online.  */
	PURPLE_CONV_ACCOUNT_OFFLINE, /**< One of the user's accounts went offline. */
	PURPLE_CONV_UPDATE_AWAY,     /**< The other user went away.                */
	PURPLE_CONV_UPDATE_ICON,     /**< The other user's buddy icon changed.     */
	PURPLE_CONV_UPDATE_TITLE,
	PURPLE_CONV_UPDATE_CHATLEFT,

	PURPLE_CONV_UPDATE_FEATURES  /**< The features for a chat have changed */

} PurpleConvUpdateType;

typedef enum
{
	PURPLE_NOT_TYPING = 0,  /**< Not typing.                 */
	PURPLE_TYPING,          /**< Currently typing.           */
	PURPLE_TYPED            /**< Stopped typing momentarily. */

} PurpleTypingState;

typedef enum
{
	PURPLE_MESSAGE_SEND        = 0x0001, /**< Outgoing message.        */
	PURPLE_MESSAGE_RECV        = 0x0002, /**< Incoming message.        */
	PURPLE_MESSAGE_SYSTEM      = 0x0004, /**< System message.          */
	PURPLE_MESSAGE_AUTO_RESP   = 0x0008, /**< Auto response.           */
	PURPLE_MESSAGE_ACTIVE_ONLY = 0x0010,  /**< Hint to the UI that this
	                                        message should not be
	                                        shown in conversations
	                                        which are only open for
	                                        internal UI purposes
	                                        (e.g. for contact-aware
	                                         conversations).           */
	PURPLE_MESSAGE_NICK        = 0x0020, /**< Contains your nick.      */
	PURPLE_MESSAGE_NO_LOG      = 0x0040, /**< Do not log.              */
	PURPLE_MESSAGE_WHISPER     = 0x0080, /**< Whispered message.       */
	PURPLE_MESSAGE_ERROR       = 0x0200, /**< Error message.           */
	PURPLE_MESSAGE_DELAYED     = 0x0400, /**< Delayed message.         */
	PURPLE_MESSAGE_RAW         = 0x0800, /**< "Raw" message - don't
	                                        apply formatting         */
	PURPLE_MESSAGE_IMAGES      = 0x1000, /**< Message contains images  */
	PURPLE_MESSAGE_NOTIFY      = 0x2000, /**< Message is a notification */
	PURPLE_MESSAGE_NO_LINKIFY  = 0x4000, /**< Message should not be auto-
										   linkified @since 2.1.0 */
	PURPLE_MESSAGE_INVISIBLE   = 0x8000, /**< Message should not be displayed */
	PURPLE_MESSAGE_REMOTE_SEND = 0x10000 /**< Message sent from another location,
	                                       not an echo of a local one
	                                       @since 2.12.0 */
} PurpleMessageFlags;

typedef enum
{
	PURPLE_CBFLAGS_NONE          = 0x0000, /**< No flags                     */
	PURPLE_CBFLAGS_VOICE         = 0x0001, /**< Voiced user or "Participant" */
	PURPLE_CBFLAGS_HALFOP        = 0x0002, /**< Half-op                      */
	PURPLE_CBFLAGS_OP            = 0x0004, /**< Channel Op or Moderator      */
	PURPLE_CBFLAGS_FOUNDER       = 0x0008, /**< Channel Founder              */
	PURPLE_CBFLAGS_TYPING        = 0x0010, /**< Currently typing             */
	PURPLE_CBFLAGS_AWAY          = 0x0020  /**< Currently away. @since 2.8.0 */

} PurpleConvChatBuddyFlags;

typedef enum
{
	PURPLE_DEBUG_ALL = 0,  /**< All debug levels.              */
	PURPLE_DEBUG_MISC,     /**< General chatter.               */
	PURPLE_DEBUG_INFO,     /**< General operation Information. */
	PURPLE_DEBUG_WARNING,  /**< Warnings.                      */
	PURPLE_DEBUG_ERROR,    /**< Errors.                        */
	PURPLE_DEBUG_FATAL     /**< Fatal errors.                  */

} PurpleDebugLevel;

typedef enum {
	PURPLE_DESKTOP_ITEM_TYPE_NULL = 0 /* This means its NULL, that is, not
					  * set */,
	PURPLE_DESKTOP_ITEM_TYPE_OTHER /* This means it's not one of the below
					 strings types, and you must get the
					 Type attribute. */,

	/* These are the standard compliant types: */
	PURPLE_DESKTOP_ITEM_TYPE_APPLICATION,
	PURPLE_DESKTOP_ITEM_TYPE_LINK,
	PURPLE_DESKTOP_ITEM_TYPE_FSDEVICE,
	PURPLE_DESKTOP_ITEM_TYPE_MIME_TYPE,
	PURPLE_DESKTOP_ITEM_TYPE_DIRECTORY,
	PURPLE_DESKTOP_ITEM_TYPE_SERVICE,
	PURPLE_DESKTOP_ITEM_TYPE_SERVICE_TYPE
} PurpleDesktopItemType;

typedef enum
{
	PURPLE_INPUT_READ  = 1 << 0,  /**< A read condition.  */
	PURPLE_INPUT_WRITE = 1 << 1   /**< A write condition. */

} PurpleInputCondition;

typedef enum
{
	PURPLE_XFER_UNKNOWN = 0,  /**< Unknown file transfer type. */
	PURPLE_XFER_SEND,         /**< File sending.               */
	PURPLE_XFER_RECEIVE       /**< File receiving.             */

} PurpleXferType;

typedef enum
{
	PURPLE_XFER_STATUS_UNKNOWN = 0,   /**< Unknown, the xfer may be null. */
	PURPLE_XFER_STATUS_NOT_STARTED,   /**< It hasn't started yet. */
	PURPLE_XFER_STATUS_ACCEPTED,      /**< Receive accepted, but destination file not selected yet */
	PURPLE_XFER_STATUS_STARTED,       /**< purple_xfer_start has been called. */
	PURPLE_XFER_STATUS_DONE,          /**< The xfer completed successfully. */
	PURPLE_XFER_STATUS_CANCEL_LOCAL,  /**< The xfer was cancelled by us. */
	PURPLE_XFER_STATUS_CANCEL_REMOTE  /**< The xfer was cancelled by the other end, or we couldn't connect. */
} PurpleXferStatusType;

typedef enum {
	PURPLE_LOG_IM,
	PURPLE_LOG_CHAT,
	PURPLE_LOG_SYSTEM
} PurpleLogType;

typedef enum {
	PURPLE_LOG_READ_NO_NEWLINE = 1
} PurpleLogReadFlags;

typedef enum {
	PURPLE_MEDIA_ELEMENT_NONE = 0,			/** empty element */
	PURPLE_MEDIA_ELEMENT_AUDIO = 1,			/** supports audio */
	PURPLE_MEDIA_ELEMENT_VIDEO = 1 << 1,		/** supports video */
	PURPLE_MEDIA_ELEMENT_AUDIO_VIDEO = PURPLE_MEDIA_ELEMENT_AUDIO
			| PURPLE_MEDIA_ELEMENT_VIDEO, 	/** supports audio and video */

	PURPLE_MEDIA_ELEMENT_NO_SRCS = 0,		/** has no src pads */
	PURPLE_MEDIA_ELEMENT_ONE_SRC = 1 << 2,		/** has one src pad */
	PURPLE_MEDIA_ELEMENT_MULTI_SRC = 1 << 3, 	/** has multiple src pads */
	PURPLE_MEDIA_ELEMENT_REQUEST_SRC = 1 << 4, 	/** src pads must be requested */

	PURPLE_MEDIA_ELEMENT_NO_SINKS = 0,		/** has no sink pads */
	PURPLE_MEDIA_ELEMENT_ONE_SINK = 1 << 5, 	/** has one sink pad */
	PURPLE_MEDIA_ELEMENT_MULTI_SINK = 1 << 6, 	/** has multiple sink pads */
	PURPLE_MEDIA_ELEMENT_REQUEST_SINK = 1 << 7, 	/** sink pads must be requested */

	PURPLE_MEDIA_ELEMENT_UNIQUE = 1 << 8,		/** This element is unique and
							 only one instance of it should
							 be created at a time */

	PURPLE_MEDIA_ELEMENT_SRC = 1 << 9,		/** can be set as an active src */
	PURPLE_MEDIA_ELEMENT_SINK = 1 << 10,		/** can be set as an active sink */
	PURPLE_MEDIA_ELEMENT_APPLICATION = 1 << 11,	/** supports application data */
} PurpleMediaElementType;

typedef enum {
	PURPLE_PMP_TYPE_UDP,
	PURPLE_PMP_TYPE_TCP
} PurplePmpType;

typedef enum
{
	PURPLE_NOTIFY_MESSAGE = 0,   /**< Message notification.         */
	PURPLE_NOTIFY_EMAIL,         /**< Single email notification.   */
	PURPLE_NOTIFY_EMAILS,        /**< Multiple email notification. */
	PURPLE_NOTIFY_FORMATTED,     /**< Formatted text.               */
	PURPLE_NOTIFY_SEARCHRESULTS, /**< Buddy search results.         */
	PURPLE_NOTIFY_USERINFO,      /**< Formatted userinfo text.      */
	PURPLE_NOTIFY_URI            /**< URI notification or display.  */

} PurpleNotifyType;

typedef enum
{
	PURPLE_NOTIFY_MSG_ERROR   = 0, /**< Error notification.       */
	PURPLE_NOTIFY_MSG_WARNING,     /**< Warning notification.     */
	PURPLE_NOTIFY_MSG_INFO         /**< Information notification. */

} PurpleNotifyMsgType;

typedef enum
{
	PURPLE_NOTIFY_BUTTON_LABELED = 0,  /**< special use, see _button_add_labeled */
	PURPLE_NOTIFY_BUTTON_CONTINUE = 1,
	PURPLE_NOTIFY_BUTTON_ADD,
	PURPLE_NOTIFY_BUTTON_INFO,
	PURPLE_NOTIFY_BUTTON_IM,
	PURPLE_NOTIFY_BUTTON_JOIN,
	PURPLE_NOTIFY_BUTTON_INVITE
} PurpleNotifySearchButtonType;

typedef enum
{
	PURPLE_NOTIFY_USER_INFO_ENTRY_PAIR = 0,
	PURPLE_NOTIFY_USER_INFO_ENTRY_SECTION_BREAK,
	PURPLE_NOTIFY_USER_INFO_ENTRY_SECTION_HEADER
} PurpleNotifyUserInfoEntryType;

typedef enum
{
	PURPLE_PLUGIN_UNKNOWN  = -1,  /**< Unknown type.    */
	PURPLE_PLUGIN_STANDARD = 0,   /**< Standard plugin. */
	PURPLE_PLUGIN_LOADER,         /**< Loader plugin.   */
	PURPLE_PLUGIN_PROTOCOL        /**< Protocol plugin. */

} PurplePluginType;

typedef enum
{
	PURPLE_STRING_FORMAT_TYPE_NONE      = 0,          /**< The string is plain text. */
	PURPLE_STRING_FORMAT_TYPE_MULTILINE = 1 << 0,     /**< The string can have newlines. */
	PURPLE_STRING_FORMAT_TYPE_HTML      = 1 << 1      /**< The string can be in HTML. */
} PurpleStringFormatType;

typedef enum {
	PURPLE_PLUGIN_PREF_NONE,
	PURPLE_PLUGIN_PREF_CHOICE,
	PURPLE_PLUGIN_PREF_INFO,              /**< no-value label */
	PURPLE_PLUGIN_PREF_STRING_FORMAT      /**< The preference has a string value. */
} PurplePluginPrefType;

typedef enum
{
	PURPLE_POUNCE_NONE             = 0x000, /**< No events.                    */
	PURPLE_POUNCE_SIGNON           = 0x001, /**< The buddy signed on.          */
	PURPLE_POUNCE_SIGNOFF          = 0x002, /**< The buddy signed off.         */
	PURPLE_POUNCE_AWAY             = 0x004, /**< The buddy went away.          */
	PURPLE_POUNCE_AWAY_RETURN      = 0x008, /**< The buddy returned from away. */
	PURPLE_POUNCE_IDLE             = 0x010, /**< The buddy became idle.        */
	PURPLE_POUNCE_IDLE_RETURN      = 0x020, /**< The buddy is no longer idle.  */
	PURPLE_POUNCE_TYPING           = 0x040, /**< The buddy started typing.     */
	PURPLE_POUNCE_TYPED            = 0x080, /**< The buddy has entered text.   */
	PURPLE_POUNCE_TYPING_STOPPED   = 0x100, /**< The buddy stopped typing.     */
	PURPLE_POUNCE_MESSAGE_RECEIVED = 0x200  /**< The buddy sent a message      */

} PurplePounceEvent;

typedef enum
{
	PURPLE_POUNCE_OPTION_NONE		= 0x00, /**< No Option                */
	PURPLE_POUNCE_OPTION_AWAY		= 0x01  /**< Pounce only when away    */
} PurplePounceOption;

typedef enum _PurplePrefType
{
	PURPLE_PREF_NONE,        /**< No type.         */
	PURPLE_PREF_BOOLEAN,     /**< Boolean.         */
	PURPLE_PREF_INT,         /**< Integer.         */
	PURPLE_PREF_STRING,      /**< String.          */
	PURPLE_PREF_STRING_LIST, /**< List of strings. */
	PURPLE_PREF_PATH,        /**< Path.            */
	PURPLE_PREF_PATH_LIST    /**< List of paths.   */

} PurplePrefType;

typedef enum _PurplePrivacyType
{
	PURPLE_PRIVACY_ALLOW_ALL = 1,
	PURPLE_PRIVACY_DENY_ALL,
	PURPLE_PRIVACY_ALLOW_USERS,
	PURPLE_PRIVACY_DENY_USERS,
	PURPLE_PRIVACY_ALLOW_BUDDYLIST
} PurplePrivacyType;

typedef enum
{
	PURPLE_PROXY_USE_GLOBAL = -1,  /**< Use the global proxy information. */
	PURPLE_PROXY_NONE = 0,         /**< No proxy.                         */
	PURPLE_PROXY_HTTP,             /**< HTTP proxy.                       */
	PURPLE_PROXY_SOCKS4,           /**< SOCKS 4 proxy.                    */
	PURPLE_PROXY_SOCKS5,           /**< SOCKS 5 proxy.                    */
	PURPLE_PROXY_USE_ENVVAR,       /**< Use environmental settings.       */
	PURPLE_PROXY_TOR               /**< Use a Tor proxy (SOCKS 5 really)  */

} PurpleProxyType;

typedef enum {
	PURPLE_ICON_SCALE_DISPLAY = 0x01,		/**< We scale the icon when we display it */
	PURPLE_ICON_SCALE_SEND = 0x02			/**< We scale the icon before we send it to the server */
} PurpleIconScaleRules;

typedef enum
{
	/**
	 * User names are unique to a chat and are not shared between rooms.
	 *
	 * XMPP lets you choose what name you want in chats, so it shouldn't
	 * be pulling the aliases from the buddy list for the chat list;
	 * it gets annoying.
	 */
	OPT_PROTO_UNIQUE_CHATNAME = 0x00000004,

	/**
	 * Chat rooms have topics.
	 *
	 * IRC and XMPP support this.
	 */
	OPT_PROTO_CHAT_TOPIC = 0x00000008,

	/**
	 * Don't require passwords for sign-in.
	 *
	 * Zephyr doesn't require passwords, so there's no
	 * need for a password prompt.
	 */
	OPT_PROTO_NO_PASSWORD = 0x00000010,

	/**
	 * Notify on new mail.
	 *
	 * If a protocol notifies you when you have new mail.
	 */
	OPT_PROTO_MAIL_CHECK = 0x00000020,

	/**
	 * Images in IMs.
	 *
	 * Oscar lets you send images in direct IMs.
	 */
	OPT_PROTO_IM_IMAGE = 0x00000040,

	/**
	 * Allow passwords to be optional.
	 *
	 * Passwords in IRC are optional, and are needed for certain
	 * functionality.
	 */
	OPT_PROTO_PASSWORD_OPTIONAL = 0x00000080,

	/**
	 * Allows font size to be specified in sane point size
	 *
	 * Probably just XMPP and Y!M
	 */
	OPT_PROTO_USE_POINTSIZE = 0x00000100,

	/**
	 * Set the Register button active even when the username has not
	 * been specified.
	 *
	 * Gadu-Gadu doesn't need a username to register new account (because
	 * usernames are assigned by the server).
	 */
	OPT_PROTO_REGISTER_NOSCREENNAME = 0x00000200,

	/**
	 * Indicates that slash commands are native to this protocol.
	 * Used as a hint that unknown commands should not be sent as messages.
	 * @since 2.1.0
	 */
	OPT_PROTO_SLASH_COMMANDS_NATIVE = 0x00000400,

	/**
	 * Indicates that this protocol supports sending a user-supplied message
	 * along with an invitation.
	 * @since 2.8.0
	 */
	OPT_PROTO_INVITE_MESSAGE = 0x00000800,

	/**
	 * Indicates that this protocol supports creating invisible buddies for
	 * reporting presence/alias of IM peers.
	 * @since 2.14.0
	 */
	OPT_PROTO_TRANSIENT_BUDDIES = 0x00001000,

} PurpleProtocolOptions;

typedef enum
{
	PURPLE_REQUEST_INPUT = 0,  /**< Text input request.        */
	PURPLE_REQUEST_CHOICE,     /**< Multiple-choice request.   */
	PURPLE_REQUEST_ACTION,     /**< Action request.            */
	PURPLE_REQUEST_FIELDS,     /**< Multiple fields request.   */
	PURPLE_REQUEST_FILE,       /**< File open or save request. */
	PURPLE_REQUEST_FOLDER,     /**< Folder selection request.  */
	PURPLE_REQUEST_SCREENSHARE /**< Screenshare media request. */

} PurpleRequestType;

typedef enum
{
	PURPLE_REQUEST_FIELD_NONE,
	PURPLE_REQUEST_FIELD_STRING,
	PURPLE_REQUEST_FIELD_INTEGER,
	PURPLE_REQUEST_FIELD_BOOLEAN,
	PURPLE_REQUEST_FIELD_CHOICE,
	PURPLE_REQUEST_FIELD_LIST,
	PURPLE_REQUEST_FIELD_LABEL,
	PURPLE_REQUEST_FIELD_IMAGE,
	PURPLE_REQUEST_FIELD_ACCOUNT

} PurpleRequestFieldType;

typedef enum
{
	PURPLE_ROOMLIST_ROOMTYPE_CATEGORY = 0x01, /**< It's a category, but not a room you can join. */
	PURPLE_ROOMLIST_ROOMTYPE_ROOM = 0x02      /**< It's a room, like the kind you can join. */

} PurpleRoomlistRoomType;

typedef enum
{
	PURPLE_ROOMLIST_FIELD_BOOL,
	PURPLE_ROOMLIST_FIELD_INT,
	PURPLE_ROOMLIST_FIELD_STRING /**< We do a g_strdup on the passed value if it's this type. */

} PurpleRoomlistFieldType;

enum PurpleDnsType {
	PurpleDnsTypeTxt = 16,
	PurpleDnsTypeSrv = 33
};

typedef enum
{
	PURPLE_PRESENCE_CONTEXT_UNSET   = 0,
	PURPLE_PRESENCE_CONTEXT_ACCOUNT,
	PURPLE_PRESENCE_CONTEXT_CONV,
	PURPLE_PRESENCE_CONTEXT_BUDDY

} PurplePresenceContext;

typedef enum
{
	PURPLE_STATUS_UNSET = 0,
	PURPLE_STATUS_OFFLINE,
	PURPLE_STATUS_AVAILABLE,
	PURPLE_STATUS_UNAVAILABLE,
	PURPLE_STATUS_INVISIBLE,
	PURPLE_STATUS_AWAY,
	PURPLE_STATUS_EXTENDED_AWAY,
	PURPLE_STATUS_MOBILE,
	PURPLE_STATUS_TUNE,
	PURPLE_STATUS_MOOD,
	PURPLE_STATUS_NUM_PRIMITIVES
} PurpleStatusPrimitive;

typedef enum {
	PURPLE_STUN_STATUS_UNDISCOVERED = -1,
	PURPLE_STUN_STATUS_UNKNOWN, /* no STUN server reachable */
	PURPLE_STUN_STATUS_DISCOVERING,
	PURPLE_STUN_STATUS_DISCOVERED
} PurpleStunStatus;

typedef enum {
	PURPLE_STUN_NAT_TYPE_PUBLIC_IP,
	PURPLE_STUN_NAT_TYPE_UNKNOWN_NAT,
	PURPLE_STUN_NAT_TYPE_FULL_CONE,
	PURPLE_STUN_NAT_TYPE_RESTRICTED_CONE,
	PURPLE_STUN_NAT_TYPE_PORT_RESTRICTED_CONE,
	PURPLE_STUN_NAT_TYPE_SYMMETRIC
} PurpleStunNatType;

typedef enum _PurpleSoundEventID
{
	PURPLE_SOUND_BUDDY_ARRIVE = 0, /**< Buddy signs on.                       */
	PURPLE_SOUND_BUDDY_LEAVE,      /**< Buddy signs off.                      */
	PURPLE_SOUND_RECEIVE,          /**< Receive an IM.                        */
	PURPLE_SOUND_FIRST_RECEIVE,    /**< Receive an IM that starts a conv.     */
	PURPLE_SOUND_SEND,             /**< Send an IM.                           */
	PURPLE_SOUND_CHAT_JOIN,        /**< Someone joins a chat.                 */
	PURPLE_SOUND_CHAT_LEAVE,       /**< Someone leaves a chat.                */
	PURPLE_SOUND_CHAT_YOU_SAY,     /**< You say something in a chat.          */
	PURPLE_SOUND_CHAT_SAY,         /**< Someone else says somthing in a chat. */
	PURPLE_SOUND_POUNCE_DEFAULT,   /**< Default sound for a buddy pounce.     */
	PURPLE_SOUND_CHAT_NICK,        /**< Someone says your name in a chat.     */
	PURPLE_SOUND_GOT_ATTENTION,	   /**< Got an attention					  */
	PURPLE_NUM_SOUNDS              /**< Total number of sounds.               */

} PurpleSoundEventID;

typedef enum
{
	PURPLE_SSL_HANDSHAKE_FAILED = 1,
	PURPLE_SSL_CONNECT_FAILED = 2,
	PURPLE_SSL_CERTIFICATE_INVALID = 3
} PurpleSslErrorType;

typedef enum
{
	PURPLE_TYPE_UNKNOWN = 0,  /**< Unknown type.                     */
	PURPLE_TYPE_SUBTYPE,      /**< Subtype.                          */
	PURPLE_TYPE_CHAR,         /**< Character.                        */
	PURPLE_TYPE_UCHAR,        /**< Unsigned character.               */
	PURPLE_TYPE_BOOLEAN,      /**< Boolean.                          */
	PURPLE_TYPE_SHORT,        /**< Short integer.                    */
	PURPLE_TYPE_USHORT,       /**< Unsigned short integer.           */
	PURPLE_TYPE_INT,          /**< Integer.                          */
	PURPLE_TYPE_UINT,         /**< Unsigned integer.                 */
	PURPLE_TYPE_LONG,         /**< Long integer.                     */
	PURPLE_TYPE_ULONG,        /**< Unsigned long integer.            */
	PURPLE_TYPE_INT64,        /**< 64-bit integer.                   */
	PURPLE_TYPE_UINT64,       /**< 64-bit unsigned integer.          */
	PURPLE_TYPE_STRING,       /**< String.                           */
	PURPLE_TYPE_OBJECT,       /**< Object pointer.                   */
	PURPLE_TYPE_POINTER,      /**< Generic pointer.                  */
	PURPLE_TYPE_ENUM,         /**< Enum.                             */
	PURPLE_TYPE_BOXED         /**< Boxed pointer with specific type. */

} PurpleType;

typedef enum
{
	PURPLE_SUBTYPE_UNKNOWN = 0,
	PURPLE_SUBTYPE_ACCOUNT,
	PURPLE_SUBTYPE_BLIST,
	PURPLE_SUBTYPE_BLIST_BUDDY,
	PURPLE_SUBTYPE_BLIST_GROUP,
	PURPLE_SUBTYPE_BLIST_CHAT,
	PURPLE_SUBTYPE_BUDDY_ICON,
	PURPLE_SUBTYPE_CONNECTION,
	PURPLE_SUBTYPE_CONVERSATION,
	PURPLE_SUBTYPE_PLUGIN,
	PURPLE_SUBTYPE_BLIST_NODE,
	PURPLE_SUBTYPE_CIPHER,
	PURPLE_SUBTYPE_STATUS,
	PURPLE_SUBTYPE_LOG,
	PURPLE_SUBTYPE_XFER,
	PURPLE_SUBTYPE_SAVEDSTATUS,
	PURPLE_SUBTYPE_XMLNODE,
	PURPLE_SUBTYPE_USERINFO,
	PURPLE_SUBTYPE_STORED_IMAGE,
	PURPLE_SUBTYPE_CERTIFICATEPOOL,
	PURPLE_SUBTYPE_CHATBUDDY
} PurpleSubType;

typedef enum _XMLNodeType
{
	XMLNODE_TYPE_TAG,		/**< Just a tag */
	XMLNODE_TYPE_ATTRIB,		/**< Has attributes */
	XMLNODE_TYPE_DATA		/**< Has data */
} XMLNodeType;

typedef enum {
	PURPLE_MEDIA_CANDIDATE_TYPE_HOST,
	PURPLE_MEDIA_CANDIDATE_TYPE_SRFLX,
	PURPLE_MEDIA_CANDIDATE_TYPE_PRFLX,
	PURPLE_MEDIA_CANDIDATE_TYPE_RELAY,
	PURPLE_MEDIA_CANDIDATE_TYPE_MULTICAST
} PurpleMediaCandidateType;

typedef enum {
	PURPLE_MEDIA_CAPS_NONE = 0,
	PURPLE_MEDIA_CAPS_AUDIO = 1,
	PURPLE_MEDIA_CAPS_AUDIO_SINGLE_DIRECTION = 1 << 1,
	PURPLE_MEDIA_CAPS_VIDEO = 1 << 2,
	PURPLE_MEDIA_CAPS_VIDEO_SINGLE_DIRECTION = 1 << 3,
	PURPLE_MEDIA_CAPS_AUDIO_VIDEO = 1 << 4,
	PURPLE_MEDIA_CAPS_MODIFY_SESSION = 1 << 5,
	PURPLE_MEDIA_CAPS_CHANGE_DIRECTION = 1 << 6
} PurpleMediaCaps;

typedef enum {
	PURPLE_MEDIA_COMPONENT_NONE = 0,
	PURPLE_MEDIA_COMPONENT_RTP = 1,
	PURPLE_MEDIA_COMPONENT_RTCP = 2
} PurpleMediaComponentType;

typedef enum {
	PURPLE_MEDIA_INFO_HANGUP = 0,
	PURPLE_MEDIA_INFO_ACCEPT,
	PURPLE_MEDIA_INFO_REJECT,
	PURPLE_MEDIA_INFO_MUTE,
	PURPLE_MEDIA_INFO_UNMUTE,
	PURPLE_MEDIA_INFO_PAUSE,
	PURPLE_MEDIA_INFO_UNPAUSE,
	PURPLE_MEDIA_INFO_HOLD,
	PURPLE_MEDIA_INFO_UNHOLD
} PurpleMediaInfoType;

typedef enum {
	PURPLE_MEDIA_NETWORK_PROTOCOL_UDP,
	PURPLE_MEDIA_NETWORK_PROTOCOL_TCP_PASSIVE,
	PURPLE_MEDIA_NETWORK_PROTOCOL_TCP_ACTIVE,
	PURPLE_MEDIA_NETWORK_PROTOCOL_TCP_SO,
} PurpleMediaNetworkProtocol;

typedef enum {
	PURPLE_MEDIA_NONE	= 0,
	PURPLE_MEDIA_RECV_AUDIO = 1 << 0,
	PURPLE_MEDIA_SEND_AUDIO = 1 << 1,
	PURPLE_MEDIA_RECV_VIDEO = 1 << 2,
	PURPLE_MEDIA_SEND_VIDEO = 1 << 3,
	PURPLE_MEDIA_RECV_APPLICATION = 1 << 4,
	PURPLE_MEDIA_SEND_APPLICATION = 1 << 5,
	PURPLE_MEDIA_AUDIO = PURPLE_MEDIA_RECV_AUDIO | PURPLE_MEDIA_SEND_AUDIO,
	PURPLE_MEDIA_VIDEO = PURPLE_MEDIA_RECV_VIDEO | PURPLE_MEDIA_SEND_VIDEO,
	PURPLE_MEDIA_APPLICATION = PURPLE_MEDIA_RECV_APPLICATION |
                                   PURPLE_MEDIA_SEND_APPLICATION,
	PURPLE_MEDIA_SEND = PURPLE_MEDIA_SEND_AUDIO | PURPLE_MEDIA_SEND_VIDEO |
			    PURPLE_MEDIA_SEND_APPLICATION,
	PURPLE_MEDIA_RECV = PURPLE_MEDIA_RECV_AUDIO | PURPLE_MEDIA_RECV_VIDEO |
			    PURPLE_MEDIA_RECV_APPLICATION
} PurpleMediaSessionType;

typedef enum {
	PURPLE_MEDIA_STATE_NEW = 0,
	PURPLE_MEDIA_STATE_CONNECTED,
	PURPLE_MEDIA_STATE_END
} PurpleMediaState;

/* Generated by ./dbus-analyze-functions.py.  Do not edit! */
struct _PurpleAccount;
typedef struct _PurpleAccount PurpleAccount;
PurpleAccount* purple_accounts_find_any(const char *name, const char *protocol) ;
PurpleAccount* purple_accounts_find_connected(const char *name, const char *protocol) ;
struct _PurpleBlistNode;
typedef struct _PurpleBlistNode PurpleBlistNode;
gboolean PURPLE_BLIST_NODE_IS_CHAT(const PurpleBlistNode *node) ;
gboolean PURPLE_BLIST_NODE_IS_BUDDY(const PurpleBlistNode *node) ;
gboolean PURPLE_BLIST_NODE_IS_CONTACT(const PurpleBlistNode *node) ;
gboolean PURPLE_BLIST_NODE_IS_GROUP(const PurpleBlistNode *node) ;
struct _PurpleBuddy;
typedef struct _PurpleBuddy PurpleBuddy;
gboolean PURPLE_BUDDY_IS_ONLINE(const PurpleBuddy *buddy) ;
gboolean PURPLE_BLIST_NODE_HAS_FLAG(const PurpleBlistNode *node, int flags) ;
gboolean PURPLE_BLIST_NODE_SHOULD_SAVE(const PurpleBlistNode *node) ;
struct _PurpleConnection;
typedef struct _PurpleConnection PurpleConnection;
gboolean PURPLE_CONNECTION_IS_CONNECTED(const PurpleConnection *connection) ;
gboolean PURPLE_CONNECTION_IS_VALID(const PurpleConnection *connection) ;
struct _PurpleConversation;
typedef struct _PurpleConversation PurpleConversation;
struct _PurpleConvIm;
typedef struct _PurpleConvIm PurpleConvIm;
PurpleConvIm* PURPLE_CONV_IM(const PurpleConversation *conversation) ;
PurpleConvIm* PURPLE_CONV_CHAT(const PurpleConversation *conversation) ;
PurpleAccount* purple_account_new(const char *username, const char *protocol_id) ;
void purple_account_destroy(const PurpleAccount *account) ;
void purple_account_connect(const PurpleAccount *account) ;
void purple_account_register(const PurpleAccount *account) ;
void purple_account_disconnect(const PurpleAccount *account) ;
void purple_account_notify_added(const PurpleAccount *account, const char *remote_user, const char *id, const char *alias, const char *message) ;
void purple_account_request_add(const PurpleAccount *account, const char *remote_user, const char *id, const char *alias, const char *message) ;
void purple_account_request_close_with_account(const PurpleAccount *account) ;
void purple_account_request_close(const void *ui_handle_NULL) ;
void purple_account_request_change_password(const PurpleAccount *account) ;
void purple_account_request_change_user_info(const PurpleAccount *account) ;
void purple_account_set_username(const PurpleAccount *account, const char *username) ;
void purple_account_set_password(const PurpleAccount *account, const char *password) ;
void purple_account_set_alias(const PurpleAccount *account, const char *alias) ;
void purple_account_set_user_info(const PurpleAccount *account, const char *user_info) ;
void purple_account_set_buddy_icon_path(const PurpleAccount *account, const char *path) ;
void purple_account_set_protocol_id(const PurpleAccount *account, const char *protocol_id) ;
void purple_account_set_connection(const PurpleAccount *account, const PurpleConnection *gc) ;
void purple_account_set_remember_password(const PurpleAccount *account, gboolean value) ;
void purple_account_set_check_mail(const PurpleAccount *account, gboolean value) ;
void purple_account_set_enabled(const PurpleAccount *account, const char *ui, gboolean value) ;
struct _PurpleProxyInfo;
typedef struct _PurpleProxyInfo PurpleProxyInfo;
void purple_account_set_proxy_info(const PurpleAccount *account, const PurpleProxyInfo *info) ;
void purple_account_set_privacy_type(const PurpleAccount *account, PurplePrivacyType privacy_type) ;
void purple_account_set_status_types(const PurpleAccount *account, const GList *status_types_NULL) ;
void purple_account_set_status_list(const PurpleAccount *account, const char *status_id, gboolean active, const GList *attrs_NULL) ;
gboolean purple_account_get_silence_suppression(const PurpleAccount *account) ;
void purple_account_set_silence_suppression(const PurpleAccount *account, gboolean value) ;
void purple_account_clear_settings(const PurpleAccount *account) ;
void purple_account_remove_setting(const PurpleAccount *account, const char *setting) ;
void purple_account_set_int(const PurpleAccount *account, const char *name, int value) ;
void purple_account_set_string(const PurpleAccount *account, const char *name, const char *value) ;
void purple_account_set_bool(const PurpleAccount *account, const char *name, gboolean value) ;
void purple_account_set_ui_int(const PurpleAccount *account, const char *ui, const char *name, int value) ;
void purple_account_set_ui_string(const PurpleAccount *account, const char *ui, const char *name, const char *value) ;
void purple_account_set_ui_bool(const PurpleAccount *account, const char *ui, const char *name, gboolean value) ;
gboolean purple_account_is_connected(const PurpleAccount *account) ;
gboolean purple_account_is_connecting(const PurpleAccount *account) ;
gboolean purple_account_is_disconnected(const PurpleAccount *account) ;
char* purple_account_get_username(const PurpleAccount *account) ;
char* purple_account_get_password(const PurpleAccount *account) ;
char* purple_account_get_alias(const PurpleAccount *account) ;
char* purple_account_get_user_info(const PurpleAccount *account) ;
char* purple_account_get_buddy_icon_path(const PurpleAccount *account) ;
char* purple_account_get_protocol_id(const PurpleAccount *account) ;
char* purple_account_get_protocol_name(const PurpleAccount *account) ;
PurpleConnection* purple_account_get_connection(const PurpleAccount *account) ;
char* purple_account_get_name_for_display(const PurpleAccount *account) ;
gboolean purple_account_get_remember_password(const PurpleAccount *account) ;
gboolean purple_account_get_check_mail(const PurpleAccount *account) ;
gboolean purple_account_get_enabled(const PurpleAccount *account, const char *ui) ;
PurpleProxyInfo* purple_account_get_proxy_info(const PurpleAccount *account) ;
PurplePrivacyType purple_account_get_privacy_type(const PurpleAccount *account) ;
struct _PurpleStatus;
typedef struct _PurpleStatus PurpleStatus;
PurpleStatus* purple_account_get_active_status(const PurpleAccount *account) ;
PurpleStatus* purple_account_get_status(const PurpleAccount *account, const char *status_id) ;
struct _PurpleStatusType;
typedef struct _PurpleStatusType PurpleStatusType;
PurpleStatusType* purple_account_get_status_type(const PurpleAccount *account, const char *id) ;
PurpleStatusType* purple_account_get_status_type_with_primitive(const PurpleAccount *account, PurpleStatusPrimitive primitive) ;
struct _PurplePresence;
typedef struct _PurplePresence PurplePresence;
PurplePresence* purple_account_get_presence(const PurpleAccount *account) ;
gboolean purple_account_is_status_active(const PurpleAccount *account, const char *status_id) ;
GList* purple_account_get_status_types(const PurpleAccount *account) ;
int purple_account_get_int(const PurpleAccount *account, const char *name, int default_value) ;
char* purple_account_get_string(const PurpleAccount *account, const char *name, const char *default_value) ;
gboolean purple_account_get_bool(const PurpleAccount *account, const char *name, gboolean default_value) ;
int purple_account_get_ui_int(const PurpleAccount *account, const char *ui, const char *name, int default_value) ;
char* purple_account_get_ui_string(const PurpleAccount *account, const char *ui, const char *name, const char *default_value) ;
gboolean purple_account_get_ui_bool(const PurpleAccount *account, const char *ui, const char *name, gboolean default_value) ;
struct _PurpleLog;
typedef struct _PurpleLog PurpleLog;
PurpleLog* purple_account_get_log(const PurpleAccount *account, gboolean create) ;
void purple_account_destroy_log(const PurpleAccount *account) ;
void purple_account_add_buddy(const PurpleAccount *account, const PurpleBuddy *buddy) ;
void purple_account_add_buddy_with_invite(const PurpleAccount *account, const PurpleBuddy *buddy, const char *message) ;
void purple_account_add_buddies(const PurpleAccount *account, const GList *buddies_NULL) ;
void purple_account_add_buddies_with_invite(const PurpleAccount *account, const GList *buddies_NULL, const char *message) ;
struct _PurpleGroup;
typedef struct _PurpleGroup PurpleGroup;
void purple_account_remove_buddy(const PurpleAccount *account, const PurpleBuddy *buddy, const PurpleGroup *group) ;
void purple_account_remove_buddies(const PurpleAccount *account, const GList *buddies_NULL, const GList *groups_NULL) ;
void purple_account_remove_group(const PurpleAccount *account, const PurpleGroup *group) ;
void purple_account_change_password(const PurpleAccount *account, const char *orig_pw, const char *new_pw) ;
gboolean purple_account_supports_offline_message(const PurpleAccount *account, const PurpleBuddy *buddy) ;
struct _PurpleConnectionErrorInfo;
typedef struct _PurpleConnectionErrorInfo PurpleConnectionErrorInfo;
PurpleConnectionErrorInfo* purple_account_get_current_error(const PurpleAccount *account) ;
void purple_account_clear_current_error(const PurpleAccount *account) ;
void purple_accounts_add(const PurpleAccount *account) ;
void purple_accounts_remove(const PurpleAccount *account) ;
void purple_accounts_delete(const PurpleAccount *account) ;
void purple_accounts_reorder(const PurpleAccount *account, gint new_index) ;
GList* purple_accounts_get_all(void) ;
GList* purple_accounts_get_all_active(void) ;
PurpleAccount* purple_accounts_find(const char *name, const char *protocol) ;
void purple_accounts_restore_current_statuses(void) ;
struct _PurpleAccountUiOps;
typedef struct _PurpleAccountUiOps PurpleAccountUiOps;
void purple_accounts_set_ui_ops(const PurpleAccountUiOps *ops) ;
PurpleAccountUiOps* purple_accounts_get_ui_ops(void) ;
struct _PurpleAccountPrefsUiOps;
typedef struct _PurpleAccountPrefsUiOps PurpleAccountPrefsUiOps;
void purple_account_prefs_set_ui_ops(const PurpleAccountPrefsUiOps *ops) ;
PurpleAccountPrefsUiOps* purple_account_prefs_get_ui_ops(void) ;
void purple_accounts_init(void) ;
void purple_accounts_uninit(void) ;
struct _PurpleBuddyList;
typedef struct _PurpleBuddyList PurpleBuddyList;
PurpleBuddyList* purple_blist_new(void) ;
void purple_set_blist(const PurpleBuddyList *blist) ;
PurpleBuddyList* purple_get_blist(void) ;
PurpleBlistNode* purple_blist_get_root(void) ;
GSList* purple_blist_get_buddies(void) ;
PurpleBlistNode* purple_blist_node_next(const PurpleBlistNode *node, gboolean offline) ;
PurpleBlistNode* purple_blist_node_get_parent(const PurpleBlistNode *node) ;
PurpleBlistNode* purple_blist_node_get_first_child(const PurpleBlistNode *node) ;
PurpleBlistNode* purple_blist_node_get_sibling_next(const PurpleBlistNode *node) ;
PurpleBlistNode* purple_blist_node_get_sibling_prev(const PurpleBlistNode *node) ;
void purple_blist_show(void) ;
void purple_blist_destroy(void) ;
void purple_blist_set_visible(gboolean show) ;
void purple_blist_update_buddy_status(const PurpleBuddy *buddy, const PurpleStatus *old_status) ;
void purple_blist_update_node_icon(const PurpleBlistNode *node) ;
void purple_blist_update_buddy_icon(const PurpleBuddy *buddy) ;
void purple_blist_rename_buddy(const PurpleBuddy *buddy, const char *name) ;
struct _PurpleContact;
typedef struct _PurpleContact PurpleContact;
void purple_blist_alias_contact(const PurpleContact *contact, const char *alias) ;
void purple_blist_alias_buddy(const PurpleBuddy *buddy, const char *alias) ;
void purple_blist_server_alias_buddy(const PurpleBuddy *buddy, const char *alias) ;
struct _PurpleChat;
typedef struct _PurpleChat PurpleChat;
void purple_blist_alias_chat(const PurpleChat *chat, const char *alias) ;
void purple_blist_rename_group(const PurpleGroup *group, const char *name) ;
PurpleChat* purple_chat_new(const PurpleAccount *account, const char *alias, const GHashTable *components) ;
void purple_chat_destroy(const PurpleChat *chat) ;
void purple_blist_add_chat(const PurpleChat *chat, const PurpleGroup *group, const PurpleBlistNode *node) ;
PurpleBuddy* purple_buddy_new(const PurpleAccount *account, const char *name, const char *alias) ;
void purple_buddy_destroy(const PurpleBuddy *buddy) ;
struct _PurpleBuddyIcon;
typedef struct _PurpleBuddyIcon PurpleBuddyIcon;
void purple_buddy_set_icon(const PurpleBuddy *buddy, const PurpleBuddyIcon *icon) ;
PurpleAccount* purple_buddy_get_account(const PurpleBuddy *buddy) ;
char* purple_buddy_get_name(const PurpleBuddy *buddy) ;
PurpleBuddyIcon* purple_buddy_get_icon(const PurpleBuddy *buddy) ;
PurpleContact* purple_buddy_get_contact(const PurpleBuddy *buddy) ;
PurplePresence* purple_buddy_get_presence(const PurpleBuddy *buddy) ;
PurpleMediaCaps purple_buddy_get_media_caps(const PurpleBuddy *buddy) ;
void purple_buddy_set_media_caps(const PurpleBuddy *buddy, PurpleMediaCaps media_caps) ;
void purple_blist_add_buddy(const PurpleBuddy *buddy, const PurpleContact *contact, const PurpleGroup *group, const PurpleBlistNode *node) ;
PurpleGroup* purple_group_new(const char *name) ;
void purple_group_destroy(const PurpleGroup *group) ;
void purple_blist_add_group(const PurpleGroup *group, const PurpleBlistNode *node) ;
PurpleContact* purple_contact_new(void) ;
void purple_contact_destroy(const PurpleContact *contact) ;
PurpleGroup* purple_contact_get_group(const PurpleContact *contact) ;
void purple_blist_add_contact(const PurpleContact *contact, const PurpleGroup *group, const PurpleBlistNode *node) ;
void purple_blist_merge_contact(const PurpleContact *source, const PurpleBlistNode *node) ;
PurpleBuddy* purple_contact_get_priority_buddy(const PurpleContact *contact) ;
void purple_contact_set_alias(const PurpleContact *contact, const char *alias) ;
char* purple_contact_get_alias(const PurpleContact *contact) ;
gboolean purple_contact_on_account(const PurpleContact *contact, const PurpleAccount *account) ;
void purple_contact_invalidate_priority_buddy(const PurpleContact *contact) ;
void purple_blist_remove_buddy(const PurpleBuddy *buddy) ;
void purple_blist_remove_contact(const PurpleContact *contact) ;
void purple_blist_remove_chat(const PurpleChat *chat) ;
void purple_blist_remove_group(const PurpleGroup *group) ;
char* purple_buddy_get_alias_only(const PurpleBuddy *buddy) ;
char* purple_buddy_get_server_alias(const PurpleBuddy *buddy) ;
char* purple_buddy_get_contact_alias(const PurpleBuddy *buddy) ;
char* purple_buddy_get_local_alias(const PurpleBuddy *buddy) ;
char* purple_buddy_get_alias(const PurpleBuddy *buddy) ;
char* purple_buddy_get_local_buddy_alias(const PurpleBuddy *buddy) ;
char* purple_chat_get_name(const PurpleChat *chat) ;
PurpleBuddy* purple_find_buddy(const PurpleAccount *account, const char *name) ;
PurpleBuddy* purple_find_buddy_in_group(const PurpleAccount *account, const char *name, const PurpleGroup *group) ;
GSList* purple_find_buddies(const PurpleAccount *account, const char *name) ;
PurpleGroup* purple_find_group(const char *name) ;
PurpleChat* purple_blist_find_chat(const PurpleAccount *account, const char *name) ;
PurpleGroup* purple_chat_get_group(const PurpleChat *chat) ;
PurpleAccount* purple_chat_get_account(const PurpleChat *chat) ;
PurpleGroup* purple_buddy_get_group(const PurpleBuddy *buddy) ;
GSList* purple_group_get_accounts(const PurpleGroup *g) ;
gboolean purple_group_on_account(const PurpleGroup *g, const PurpleAccount *account) ;
char* purple_group_get_name(const PurpleGroup *group) ;
void purple_blist_add_account(const PurpleAccount *account) ;
void purple_blist_remove_account(const PurpleAccount *account) ;
int purple_blist_get_group_size(const PurpleGroup *group, gboolean offline) ;
int purple_blist_get_group_online_count(const PurpleGroup *group) ;
void purple_blist_load(void) ;
void purple_blist_schedule_save(void) ;
void purple_blist_request_add_buddy(const PurpleAccount *account, const char *username, const char *group, const char *alias) ;
void purple_blist_request_add_chat(const PurpleAccount *account, const PurpleGroup *group, const char *alias, const char *name) ;
void purple_blist_request_add_group(void) ;
void purple_blist_node_set_bool(const PurpleBlistNode *node, const char *key, gboolean value) ;
gboolean purple_blist_node_get_bool(const PurpleBlistNode *node, const char *key) ;
void purple_blist_node_set_int(const PurpleBlistNode *node, const char *key, int value) ;
int purple_blist_node_get_int(const PurpleBlistNode *node, const char *key) ;
void purple_blist_node_set_string(const PurpleBlistNode *node, const char *key, const char *value) ;
char* purple_blist_node_get_string(const PurpleBlistNode *node, const char *key) ;
void purple_blist_node_remove_setting(const PurpleBlistNode *node, const char *key) ;
void purple_blist_node_set_flags(const PurpleBlistNode *node, PurpleBlistNodeFlags flags) ;
PurpleBlistNodeFlags purple_blist_node_get_flags(const PurpleBlistNode *node) ;
PurpleBlistNodeType purple_blist_node_get_type(const PurpleBlistNode *node) ;
GList* purple_blist_node_get_extended_menu(const PurpleBlistNode *n) ;
struct _PurpleBlistUiOps;
typedef struct _PurpleBlistUiOps PurpleBlistUiOps;
void purple_blist_set_ui_ops(const PurpleBlistUiOps *ops) ;
PurpleBlistUiOps* purple_blist_get_ui_ops(void) ;
void purple_blist_init(void) ;
void purple_blist_uninit(void) ;
PurpleBuddyIcon* purple_buddy_icon_new(const PurpleAccount *account, const char *username, const void *icon_data_NULL, size_t icon_len, const char *checksum) ;
PurpleBuddyIcon* purple_buddy_icon_ref(const PurpleBuddyIcon *icon) ;
PurpleBuddyIcon* purple_buddy_icon_unref(const PurpleBuddyIcon *icon) ;
void purple_buddy_icon_update(const PurpleBuddyIcon *icon) ;
void purple_buddy_icon_set_data(const PurpleBuddyIcon *icon, const guchar *data_NULL, size_t len, const char *checksum) ;
PurpleAccount* purple_buddy_icon_get_account(const PurpleBuddyIcon *icon) ;
char* purple_buddy_icon_get_username(const PurpleBuddyIcon *icon) ;
char* purple_buddy_icon_get_checksum(const PurpleBuddyIcon *icon) ;
char* purple_buddy_icon_get_extension(const PurpleBuddyIcon *icon) ;
char* purple_buddy_icon_get_full_path(const PurpleBuddyIcon *icon) ;
void purple_buddy_icons_set_for_user(const PurpleAccount *account, const char *username, const void *icon_data_NULL, size_t icon_len, const char *checksum) ;
PurpleBuddyIcon* purple_buddy_icons_find(const PurpleAccount *account, const char *username) ;
struct _PurpleStoredImage;
typedef struct _PurpleStoredImage PurpleStoredImage;
PurpleStoredImage* purple_buddy_icons_find_account_icon(const PurpleAccount *account) ;
PurpleStoredImage* purple_buddy_icons_set_account_icon(const PurpleAccount *account, const guchar *icon_data_NULL, size_t icon_len) ;
time_t purple_buddy_icons_get_account_icon_timestamp(const PurpleAccount *account) ;
gboolean purple_buddy_icons_node_has_custom_icon(const PurpleBlistNode *node) ;
PurpleStoredImage* purple_buddy_icons_node_find_custom_icon(const PurpleBlistNode *node) ;
PurpleStoredImage* purple_buddy_icons_node_set_custom_icon(const PurpleBlistNode *node, const guchar *icon_data_NULL, size_t icon_len) ;
PurpleStoredImage* purple_buddy_icons_node_set_custom_icon_from_file(const PurpleBlistNode *node, const char *filename) ;
gboolean purple_buddy_icons_has_custom_icon(const PurpleContact *contact) ;
PurpleStoredImage* purple_buddy_icons_find_custom_icon(const PurpleContact *contact) ;
PurpleStoredImage* purple_buddy_icons_set_custom_icon(const PurpleContact *contact, const guchar *icon_data_NULL, size_t icon_len) ;
void purple_buddy_icons_set_caching(gboolean caching) ;
gboolean purple_buddy_icons_is_caching(void) ;
void purple_buddy_icons_set_cache_dir(const char *cache_dir) ;
char* purple_buddy_icons_get_cache_dir(void) ;
void purple_buddy_icons_init(void) ;
void purple_buddy_icons_uninit(void) ;
struct _PurpleBuddyIconSpec;
typedef struct _PurpleBuddyIconSpec PurpleBuddyIconSpec;
void purple_buddy_icon_get_scale_size(const PurpleBuddyIconSpec *spec, const int *width_NULL, const int *height_NULL) ;
void purple_connection_new(const PurpleAccount *account, gboolean regist, const char *password) ;
void purple_connection_destroy(const PurpleConnection *gc) ;
void purple_connection_set_state(const PurpleConnection *gc, PurpleConnectionState state) ;
void purple_connection_set_account(const PurpleConnection *gc, const PurpleAccount *account) ;
void purple_connection_set_display_name(const PurpleConnection *gc, const char *name) ;
void purple_connection_set_protocol_data(const PurpleConnection *connection, const void *proto_data_NULL) ;
PurpleConnectionState purple_connection_get_state(const PurpleConnection *gc) ;
PurpleAccount* purple_connection_get_account(const PurpleConnection *gc) ;
struct _PurplePlugin;
typedef struct _PurplePlugin PurplePlugin;
PurplePlugin* purple_connection_get_prpl(const PurpleConnection *gc) ;
char* purple_connection_get_password(const PurpleConnection *gc) ;
char* purple_connection_get_display_name(const PurpleConnection *gc) ;
void purple_connection_update_progress(const PurpleConnection *gc, const char *text, size_t step, size_t count) ;
void purple_connection_notice(const PurpleConnection *gc, const char *text) ;
void purple_connection_error(const PurpleConnection *gc, const char *reason) ;
void purple_connection_error_reason(const PurpleConnection *gc, PurpleConnectionError reason, const char *description) ;
void purple_connection_ssl_error(const PurpleConnection *gc, PurpleSslErrorType ssl_error) ;
gboolean purple_connection_error_is_fatal(PurpleConnectionError reason) ;
void purple_connections_disconnect_all(void) ;
GList* purple_connections_get_all(void) ;
GList* purple_connections_get_connecting(void) ;
struct _PurpleConnectionUiOps;
typedef struct _PurpleConnectionUiOps PurpleConnectionUiOps;
void purple_connections_set_ui_ops(const PurpleConnectionUiOps *ops) ;
PurpleConnectionUiOps* purple_connections_get_ui_ops(void) ;
void purple_connections_init(void) ;
void purple_connections_uninit(void) ;
PurpleConversation* purple_conversation_new(PurpleConversationType type, const PurpleAccount *account, const char *name) ;
void purple_conversation_destroy(const PurpleConversation *conv) ;
void purple_conversation_present(const PurpleConversation *conv) ;
PurpleConversationType purple_conversation_get_type(const PurpleConversation *conv) ;
struct _PurpleConversationUiOps;
typedef struct _PurpleConversationUiOps PurpleConversationUiOps;
void purple_conversation_set_ui_ops(const PurpleConversation *conv, const PurpleConversationUiOps *ops) ;
void purple_conversations_set_ui_ops(const PurpleConversationUiOps *ops) ;
PurpleConversationUiOps* purple_conversation_get_ui_ops(const PurpleConversation *conv) ;
void purple_conversation_set_account(const PurpleConversation *conv, const PurpleAccount *account) ;
PurpleAccount* purple_conversation_get_account(const PurpleConversation *conv) ;
PurpleConnection* purple_conversation_get_gc(const PurpleConversation *conv) ;
void purple_conversation_set_title(const PurpleConversation *conv, const char *title) ;
char* purple_conversation_get_title(const PurpleConversation *conv) ;
void purple_conversation_autoset_title(const PurpleConversation *conv) ;
void purple_conversation_set_name(const PurpleConversation *conv, const char *name) ;
char* purple_conversation_get_name(const PurpleConversation *conv) ;
struct _PurpleConvChatBuddy;
typedef struct _PurpleConvChatBuddy PurpleConvChatBuddy;
char* purple_conv_chat_cb_get_attribute(const PurpleConvChatBuddy *cb, const char *key) ;
GList* purple_conv_chat_cb_get_attribute_keys(const PurpleConvChatBuddy *cb) ;
struct _PurpleConvChat;
typedef struct _PurpleConvChat PurpleConvChat;
void purple_conv_chat_cb_set_attribute(const PurpleConvChat *chat, const PurpleConvChatBuddy *cb, const char *key, const char *value) ;
void purple_conv_chat_cb_set_attributes(const PurpleConvChat *chat, const PurpleConvChatBuddy *cb, const GList *keys_NULL, const GList *values_NULL) ;
void purple_conversation_set_logging(const PurpleConversation *conv, gboolean log) ;
gboolean purple_conversation_is_logging(const PurpleConversation *conv) ;
PurpleConvIm* purple_conversation_get_im_data(const PurpleConversation *conv) ;
PurpleConvChat* purple_conversation_get_chat_data(const PurpleConversation *conv) ;
GList* purple_get_conversations(void) ;
GList* purple_get_ims(void) ;
GList* purple_get_chats(void) ;
PurpleConversation* purple_find_conversation_with_account(PurpleConversationType type, const char *name, const PurpleAccount *account) ;
void purple_conversation_write(const PurpleConversation *conv, const char *who, const char *message, PurpleMessageFlags flags, time_t mtime) ;
void purple_conversation_set_features(const PurpleConversation *conv, PurpleConnectionFlags features) ;
PurpleConnectionFlags purple_conversation_get_features(const PurpleConversation *conv) ;
gboolean purple_conversation_has_focus(const PurpleConversation *conv) ;
void purple_conversation_update(const PurpleConversation *conv, PurpleConvUpdateType type) ;
GList* purple_conversation_get_message_history(const PurpleConversation *conv) ;
void purple_conversation_clear_message_history(const PurpleConversation *conv) ;
struct _PurpleConvMessage;
typedef struct _PurpleConvMessage PurpleConvMessage;
char* purple_conversation_message_get_sender(const PurpleConvMessage *msg) ;
char* purple_conversation_message_get_message(const PurpleConvMessage *msg) ;
PurpleMessageFlags purple_conversation_message_get_flags(const PurpleConvMessage *msg) ;
time_t purple_conversation_message_get_timestamp(const PurpleConvMessage *msg) ;
PurpleConversation* purple_conv_im_get_conversation(const PurpleConvIm *im) ;
void purple_conv_im_set_icon(const PurpleConvIm *im, const PurpleBuddyIcon *icon) ;
PurpleBuddyIcon* purple_conv_im_get_icon(const PurpleConvIm *im) ;
void purple_conv_im_set_typing_state(const PurpleConvIm *im, PurpleTypingState state) ;
PurpleTypingState purple_conv_im_get_typing_state(const PurpleConvIm *im) ;
void purple_conv_im_start_typing_timeout(const PurpleConvIm *im, int timeout) ;
void purple_conv_im_stop_typing_timeout(const PurpleConvIm *im) ;
guint purple_conv_im_get_typing_timeout(const PurpleConvIm *im) ;
void purple_conv_im_set_type_again(const PurpleConvIm *im, int val) ;
time_t purple_conv_im_get_type_again(const PurpleConvIm *im) ;
void purple_conv_im_start_send_typed_timeout(const PurpleConvIm *im) ;
void purple_conv_im_stop_send_typed_timeout(const PurpleConvIm *im) ;
guint purple_conv_im_get_send_typed_timeout(const PurpleConvIm *im) ;
void purple_conv_im_update_typing(const PurpleConvIm *im) ;
void purple_conv_im_write(const PurpleConvIm *im, const char *who, const char *message, PurpleMessageFlags flags, time_t mtime) ;
gboolean purple_conv_present_error(const char *who, const PurpleAccount *account, const char *what) ;
void purple_conv_im_send(const PurpleConvIm *im, const char *message) ;
void purple_conv_send_confirm(const PurpleConversation *conv, const char *message) ;
void purple_conv_im_send_with_flags(const PurpleConvIm *im, const char *message, PurpleMessageFlags flags) ;
gboolean purple_conv_custom_smiley_add(const PurpleConversation *conv, const char *smile, const char *cksum_type, const char *chksum, gboolean remote) ;
void purple_conv_custom_smiley_close(const PurpleConversation *conv, const char *smile) ;
PurpleConversation* purple_conv_chat_get_conversation(const PurpleConvChat *chat) ;
GList* purple_conv_chat_set_users(const PurpleConvChat *chat, const GList *users_NULL) ;
GList* purple_conv_chat_get_users(const PurpleConvChat *chat) ;
void purple_conv_chat_ignore(const PurpleConvChat *chat, const char *name) ;
void purple_conv_chat_unignore(const PurpleConvChat *chat, const char *name) ;
GList* purple_conv_chat_set_ignored(const PurpleConvChat *chat, const GList *ignored_NULL) ;
GList* purple_conv_chat_get_ignored(const PurpleConvChat *chat) ;
char* purple_conv_chat_get_ignored_user(const PurpleConvChat *chat, const char *user) ;
gboolean purple_conv_chat_is_user_ignored(const PurpleConvChat *chat, const char *user) ;
void purple_conv_chat_set_topic(const PurpleConvChat *chat, const char *who, const char *topic) ;
char* purple_conv_chat_get_topic(const PurpleConvChat *chat) ;
void purple_conv_chat_set_id(const PurpleConvChat *chat, int id) ;
int purple_conv_chat_get_id(const PurpleConvChat *chat) ;
void purple_conv_chat_write(const PurpleConvChat *chat, const char *who, const char *message, PurpleMessageFlags flags, time_t mtime) ;
void purple_conv_chat_send(const PurpleConvChat *chat, const char *message) ;
void purple_conv_chat_send_with_flags(const PurpleConvChat *chat, const char *message, PurpleMessageFlags flags) ;
void purple_conv_chat_add_user(const PurpleConvChat *chat, const char *user, const char *extra_msg, PurpleConvChatBuddyFlags flags, gboolean new_arrival) ;
void purple_conv_chat_add_users(const PurpleConvChat *chat, const GList *users_NULL, const GList *extra_msgs_NULL, const GList *flags_NULL, gboolean new_arrivals) ;
void purple_conv_chat_rename_user(const PurpleConvChat *chat, const char *old_user, const char *new_user) ;
void purple_conv_chat_remove_user(const PurpleConvChat *chat, const char *user, const char *reason) ;
void purple_conv_chat_remove_users(const PurpleConvChat *chat, const GList *users_NULL, const char *reason) ;
gboolean purple_conv_chat_find_user(const PurpleConvChat *chat, const char *user) ;
void purple_conv_chat_user_set_flags(const PurpleConvChat *chat, const char *user, PurpleConvChatBuddyFlags flags) ;
PurpleConvChatBuddyFlags purple_conv_chat_user_get_flags(const PurpleConvChat *chat, const char *user) ;
void purple_conv_chat_clear_users(const PurpleConvChat *chat) ;
void purple_conv_chat_set_nick(const PurpleConvChat *chat, const char *nick) ;
char* purple_conv_chat_get_nick(const PurpleConvChat *chat) ;
PurpleConversation* purple_find_chat(const PurpleConnection *gc, int id) ;
void purple_conv_chat_left(const PurpleConvChat *chat) ;
void purple_conv_chat_invite_user(const PurpleConvChat *chat, const char *user, const char *message, gboolean confirm) ;
gboolean purple_conv_chat_has_left(const PurpleConvChat *chat) ;
PurpleConvChatBuddy* purple_conv_chat_cb_new(const char *name, const char *alias, PurpleConvChatBuddyFlags flags) ;
PurpleConvChatBuddy* purple_conv_chat_cb_find(const PurpleConvChat *chat, const char *name) ;
char* purple_conv_chat_cb_get_name(const PurpleConvChatBuddy *cb) ;
void purple_conv_chat_cb_destroy(const PurpleConvChatBuddy *cb) ;
GList* purple_conversation_get_extended_menu(const PurpleConversation *conv) ;
void purple_conversations_init(void) ;
void purple_conversations_uninit(void) ;
gboolean purple_core_init(const char *ui) ;
void purple_core_quit(void) ;
char* purple_core_get_version(void) ;
char* purple_core_get_ui(void) ;
struct _PurpleCore;
typedef struct _PurpleCore PurpleCore;
PurpleCore* purple_get_core(void) ;
struct _PurpleCoreUiOps;
typedef struct _PurpleCoreUiOps PurpleCoreUiOps;
void purple_core_set_ui_ops(const PurpleCoreUiOps *ops) ;
PurpleCoreUiOps* purple_core_get_ui_ops(void) ;
gboolean purple_core_migrate(void) ;
gboolean purple_core_ensure_single_instance(void) ;
struct _PurpleXfer;
typedef struct _PurpleXfer PurpleXfer;
PurpleXfer* purple_xfer_new(const PurpleAccount *account, PurpleXferType type, const char *who) ;
GList* purple_xfers_get_all(void) ;
void purple_xfer_ref(const PurpleXfer *xfer) ;
void purple_xfer_unref(const PurpleXfer *xfer) ;
void purple_xfer_request(const PurpleXfer *xfer) ;
void purple_xfer_request_accepted(const PurpleXfer *xfer, const char *filename) ;
void purple_xfer_request_denied(const PurpleXfer *xfer) ;
PurpleXferType purple_xfer_get_type(const PurpleXfer *xfer) ;
PurpleAccount* purple_xfer_get_account(const PurpleXfer *xfer) ;
char* purple_xfer_get_remote_user(const PurpleXfer *xfer) ;
PurpleXferStatusType purple_xfer_get_status(const PurpleXfer *xfer) ;
gboolean purple_xfer_is_canceled(const PurpleXfer *xfer) ;
gboolean purple_xfer_is_completed(const PurpleXfer *xfer) ;
char* purple_xfer_get_filename(const PurpleXfer *xfer) ;
char* purple_xfer_get_local_filename(const PurpleXfer *xfer) ;
size_t purple_xfer_get_bytes_sent(const PurpleXfer *xfer) ;
size_t purple_xfer_get_bytes_remaining(const PurpleXfer *xfer) ;
size_t purple_xfer_get_size(const PurpleXfer *xfer) ;
int purple_xfer_get_local_port(const PurpleXfer *xfer) ;
char* purple_xfer_get_remote_ip(const PurpleXfer *xfer) ;
int purple_xfer_get_remote_port(const PurpleXfer *xfer) ;
time_t purple_xfer_get_start_time(const PurpleXfer *xfer) ;
time_t purple_xfer_get_end_time(const PurpleXfer *xfer) ;
void purple_xfer_set_completed(const PurpleXfer *xfer, gboolean completed) ;
void purple_xfer_set_message(const PurpleXfer *xfer, const char *message) ;
void purple_xfer_set_filename(const PurpleXfer *xfer, const char *filename) ;
void purple_xfer_set_local_filename(const PurpleXfer *xfer, const char *filename) ;
void purple_xfer_set_size(const PurpleXfer *xfer, size_t size) ;
void purple_xfer_set_bytes_sent(const PurpleXfer *xfer, size_t bytes_sent) ;
struct _PurpleXferUiOps;
typedef struct _PurpleXferUiOps PurpleXferUiOps;
PurpleXferUiOps* purple_xfer_get_ui_ops(const PurpleXfer *xfer) ;
void purple_xfer_start(const PurpleXfer *xfer, int fd, const char *ip, int port) ;
void purple_xfer_end(const PurpleXfer *xfer) ;
void purple_xfer_add(const PurpleXfer *xfer) ;
void purple_xfer_cancel_local(const PurpleXfer *xfer) ;
void purple_xfer_cancel_remote(const PurpleXfer *xfer) ;
void purple_xfer_error(PurpleXferType type, const PurpleAccount *account, const char *who, const char *msg) ;
void purple_xfer_update_progress(const PurpleXfer *xfer) ;
char* purple_xfer_get_thumbnail_mimetype(const PurpleXfer *xfer) ;
void purple_xfer_prepare_thumbnail(const PurpleXfer *xfer, const char *formats) ;
void purple_xfers_init(void) ;
void purple_xfers_uninit(void) ;
void purple_xfers_set_ui_ops(const PurpleXferUiOps *ops) ;
PurpleXferUiOps* purple_xfers_get_ui_ops(void) ;
void purple_log_free(const PurpleLog *log) ;
void purple_log_write(const PurpleLog *log, PurpleMessageFlags type, const char *from, time_t time, const char *message) ;
GList* purple_log_get_logs(PurpleLogType type, const char *name, const PurpleAccount *account) ;
GList* purple_log_get_system_logs(const PurpleAccount *account) ;
int purple_log_get_size(const PurpleLog *log) ;
int purple_log_get_total_size(PurpleLogType type, const char *name, const PurpleAccount *account) ;
int purple_log_get_activity_score(PurpleLogType type, const char *name, const PurpleAccount *account) ;
gboolean purple_log_is_deletable(const PurpleLog *log) ;
gboolean purple_log_delete(const PurpleLog *log) ;
char* purple_log_get_log_dir(PurpleLogType type, const char *name, const PurpleAccount *account) ;
struct _PurpleLogSet;
typedef struct _PurpleLogSet PurpleLogSet;
void purple_log_set_free(const PurpleLogSet *set) ;
void purple_log_common_writer(const PurpleLog *log, const char *ext) ;
struct _PurpleLogLogger;
typedef struct _PurpleLogLogger PurpleLogLogger;
GList* purple_log_common_lister(PurpleLogType type, const char *name, const PurpleAccount *account, const char *ext, const PurpleLogLogger *logger) ;
int purple_log_common_total_sizer(PurpleLogType type, const char *name, const PurpleAccount *account, const char *ext) ;
int purple_log_common_sizer(const PurpleLog *log) ;
gboolean purple_log_common_deleter(const PurpleLog *log) ;
gboolean purple_log_common_is_deletable(const PurpleLog *log) ;
void purple_log_logger_free(const PurpleLogLogger *logger) ;
void purple_log_logger_add(const PurpleLogLogger *logger) ;
void purple_log_logger_remove(const PurpleLogLogger *logger) ;
void purple_log_logger_set(const PurpleLogLogger *logger) ;
PurpleLogLogger* purple_log_logger_get(void) ;
GList* purple_log_logger_get_options(void) ;
void purple_log_init(void) ;
void purple_log_uninit(void) ;
struct _PurpleNotifySearchResults;
typedef struct _PurpleNotifySearchResults PurpleNotifySearchResults;
void purple_notify_searchresults_free(const PurpleNotifySearchResults *results) ;
void purple_notify_searchresults_new_rows(const PurpleConnection *gc, const PurpleNotifySearchResults *results, const void *data_NULL) ;
PurpleNotifySearchResults* purple_notify_searchresults_new(void) ;
struct _PurpleNotifySearchColumn;
typedef struct _PurpleNotifySearchColumn PurpleNotifySearchColumn;
PurpleNotifySearchColumn* purple_notify_searchresults_column_new(const char *title) ;
void purple_notify_searchresults_column_add(const PurpleNotifySearchResults *results, const PurpleNotifySearchColumn *column) ;
void purple_notify_searchresults_row_add(const PurpleNotifySearchResults *results, const GList *row_NULL) ;
guint purple_notify_searchresults_get_rows_count(const PurpleNotifySearchResults *results) ;
guint purple_notify_searchresults_get_columns_count(const PurpleNotifySearchResults *results) ;
GList* purple_notify_searchresults_row_get(const PurpleNotifySearchResults *results, int row_id) ;
char* purple_notify_searchresults_column_get_title(const PurpleNotifySearchResults *results, int column_id) ;
struct _PurpleNotifyUserInfo;
typedef struct _PurpleNotifyUserInfo PurpleNotifyUserInfo;
PurpleNotifyUserInfo* purple_notify_user_info_new(void) ;
void purple_notify_user_info_destroy(const PurpleNotifyUserInfo *user_info) ;
GList* purple_notify_user_info_get_entries(const PurpleNotifyUserInfo *user_info) ;
char* purple_notify_user_info_get_text_with_newline(const PurpleNotifyUserInfo *user_info, const char *newline) ;
void purple_notify_user_info_add_pair(const PurpleNotifyUserInfo *user_info, const char *label, const char *value) ;
void purple_notify_user_info_add_pair_plaintext(const PurpleNotifyUserInfo *user_info, const char *label, const char *value) ;
void purple_notify_user_info_prepend_pair(const PurpleNotifyUserInfo *user_info, const char *label, const char *value) ;
struct _PurpleNotifyUserInfoEntry;
typedef struct _PurpleNotifyUserInfoEntry PurpleNotifyUserInfoEntry;
void purple_notify_user_info_remove_entry(const PurpleNotifyUserInfo *user_info, const PurpleNotifyUserInfoEntry *user_info_entry) ;
PurpleNotifyUserInfoEntry* purple_notify_user_info_entry_new(const char *label, const char *value) ;
void purple_notify_user_info_add_section_break(const PurpleNotifyUserInfo *user_info) ;
void purple_notify_user_info_prepend_section_break(const PurpleNotifyUserInfo *user_info) ;
void purple_notify_user_info_add_section_header(const PurpleNotifyUserInfo *user_info, const char *label) ;
void purple_notify_user_info_prepend_section_header(const PurpleNotifyUserInfo *user_info, const char *label) ;
void purple_notify_user_info_remove_last_item(const PurpleNotifyUserInfo *user_info) ;
char* purple_notify_user_info_entry_get_label(const PurpleNotifyUserInfoEntry *user_info_entry) ;
void purple_notify_user_info_entry_set_label(const PurpleNotifyUserInfoEntry *user_info_entry, const char *label) ;
char* purple_notify_user_info_entry_get_value(const PurpleNotifyUserInfoEntry *user_info_entry) ;
void purple_notify_user_info_entry_set_value(const PurpleNotifyUserInfoEntry *user_info_entry, const char *value) ;
PurpleNotifyUserInfoEntryType purple_notify_user_info_entry_get_type(const PurpleNotifyUserInfoEntry *user_info_entry) ;
void purple_notify_user_info_entry_set_type(const PurpleNotifyUserInfoEntry *user_info_entry, PurpleNotifyUserInfoEntryType type) ;
void purple_notify_close(PurpleNotifyType type, const void *ui_handle_NULL) ;
void purple_notify_close_with_handle(const void *handle_NULL) ;
struct _PurpleNotifyUiOps;
typedef struct _PurpleNotifyUiOps PurpleNotifyUiOps;
void purple_notify_set_ui_ops(const PurpleNotifyUiOps *ops) ;
PurpleNotifyUiOps* purple_notify_get_ui_ops(void) ;
void purple_notify_init(void) ;
void purple_notify_uninit(void) ;
struct _PurplePrefsUiOps;
typedef struct _PurplePrefsUiOps PurplePrefsUiOps;
void purple_prefs_set_ui_ops(const PurplePrefsUiOps *ops) ;
PurplePrefsUiOps* purple_prefs_get_ui_ops(void) ;
void purple_prefs_init(void) ;
void purple_prefs_uninit(void) ;
void purple_prefs_add_none(const char *name) ;
void purple_prefs_add_bool(const char *name, gboolean value) ;
void purple_prefs_add_int(const char *name, int value) ;
void purple_prefs_add_string(const char *name, const char *value) ;
void purple_prefs_add_string_list(const char *name, const GList *value_NULL) ;
void purple_prefs_add_path(const char *name, const char *value) ;
void purple_prefs_add_path_list(const char *name, const GList *value_NULL) ;
void purple_prefs_remove(const char *name) ;
void purple_prefs_rename(const char *oldname, const char *newname) ;
void purple_prefs_rename_boolean_toggle(const char *oldname, const char *newname) ;
void purple_prefs_destroy(void) ;
void purple_prefs_set_bool(const char *name, gboolean value) ;
void purple_prefs_set_int(const char *name, int value) ;
void purple_prefs_set_string(const char *name, const char *value) ;
void purple_prefs_set_string_list(const char *name, const GList *value_NULL) ;
void purple_prefs_set_path(const char *name, const char *value) ;
void purple_prefs_set_path_list(const char *name, const GList *value_NULL) ;
gboolean purple_prefs_exists(const char *name) ;
PurplePrefType purple_prefs_get_type(const char *name) ;
gboolean purple_prefs_get_bool(const char *name) ;
int purple_prefs_get_int(const char *name) ;
char* purple_prefs_get_string(const char *name) ;
GList* purple_prefs_get_string_list(const char *name) ;
char* purple_prefs_get_path(const char *name) ;
GList* purple_prefs_get_path_list(const char *name) ;
GList* purple_prefs_get_children_names(const char *name) ;
void purple_prefs_disconnect_callback(guint callback_id) ;
void purple_prefs_disconnect_by_handle(const void *handle_NULL) ;
void purple_prefs_trigger_callback(const char *name) ;
struct _PurplePrefCallbackData;
typedef struct _PurplePrefCallbackData PurplePrefCallbackData;
void purple_prefs_trigger_callback_object(const PurplePrefCallbackData *data) ;
gboolean purple_prefs_load(void) ;
void purple_prefs_update_old(void) ;
void purple_roomlist_show_with_account(const PurpleAccount *account) ;
struct _PurpleRoomlist;
typedef struct _PurpleRoomlist PurpleRoomlist;
PurpleRoomlist* purple_roomlist_new(const PurpleAccount *account) ;
void purple_roomlist_ref(const PurpleRoomlist *list) ;
void purple_roomlist_unref(const PurpleRoomlist *list) ;
void purple_roomlist_set_fields(const PurpleRoomlist *list, const GList *fields_NULL) ;
void purple_roomlist_set_in_progress(const PurpleRoomlist *list, gboolean in_progress) ;
gboolean purple_roomlist_get_in_progress(const PurpleRoomlist *list) ;
struct _PurpleRoomlistRoom;
typedef struct _PurpleRoomlistRoom PurpleRoomlistRoom;
void purple_roomlist_room_add(const PurpleRoomlist *list, const PurpleRoomlistRoom *room) ;
PurpleRoomlist* purple_roomlist_get_list(const PurpleConnection *gc) ;
void purple_roomlist_cancel_get_list(const PurpleRoomlist *list) ;
void purple_roomlist_expand_category(const PurpleRoomlist *list, const PurpleRoomlistRoom *category) ;
GList* purple_roomlist_get_fields(const PurpleRoomlist *roomlist) ;
PurpleRoomlistRoom* purple_roomlist_room_new(PurpleRoomlistRoomType type, const char *name, const PurpleRoomlistRoom *parent) ;
void purple_roomlist_room_join(const PurpleRoomlist *list, const PurpleRoomlistRoom *room) ;
PurpleRoomlistRoomType purple_roomlist_room_get_type(const PurpleRoomlistRoom *room) ;
char* purple_roomlist_room_get_name(const PurpleRoomlistRoom *room) ;
PurpleRoomlistRoom* purple_roomlist_room_get_parent(const PurpleRoomlistRoom *room) ;
GList* purple_roomlist_room_get_fields(const PurpleRoomlistRoom *room) ;
struct _PurpleRoomlistField;
typedef struct _PurpleRoomlistField PurpleRoomlistField;
PurpleRoomlistField* purple_roomlist_field_new(PurpleRoomlistFieldType type, const char *label, const char *name, gboolean hidden) ;
PurpleRoomlistFieldType purple_roomlist_field_get_type(const PurpleRoomlistField *field) ;
char* purple_roomlist_field_get_label(const PurpleRoomlistField *field) ;
gboolean purple_roomlist_field_get_hidden(const PurpleRoomlistField *field) ;
struct _PurpleRoomlistUiOps;
typedef struct _PurpleRoomlistUiOps PurpleRoomlistUiOps;
void purple_roomlist_set_ui_ops(const PurpleRoomlistUiOps *ops) ;
PurpleRoomlistUiOps* purple_roomlist_get_ui_ops(void) ;
struct _PurpleSavedStatus;
typedef struct _PurpleSavedStatus PurpleSavedStatus;
PurpleSavedStatus* purple_savedstatus_new(const char *title, PurpleStatusPrimitive type) ;
void purple_savedstatus_set_title(const PurpleSavedStatus *status, const char *title) ;
void purple_savedstatus_set_type(const PurpleSavedStatus *status, PurpleStatusPrimitive type) ;
void purple_savedstatus_set_message(const PurpleSavedStatus *status, const char *message) ;
void purple_savedstatus_set_substatus(const PurpleSavedStatus *status, const PurpleAccount *account, const PurpleStatusType *type, const char *message) ;
void purple_savedstatus_unset_substatus(const PurpleSavedStatus *saved_status, const PurpleAccount *account) ;
gboolean purple_savedstatus_delete(const char *title) ;
void purple_savedstatus_delete_by_status(const PurpleSavedStatus *saved_status) ;
GList* purple_savedstatuses_get_all(void) ;
GList* purple_savedstatuses_get_popular(int how_many) ;
PurpleSavedStatus* purple_savedstatus_get_current(void) ;
PurpleSavedStatus* purple_savedstatus_get_default(void) ;
PurpleSavedStatus* purple_savedstatus_get_idleaway(void) ;
gboolean purple_savedstatus_is_idleaway(void) ;
void purple_savedstatus_set_idleaway(gboolean idleaway) ;
PurpleSavedStatus* purple_savedstatus_get_startup(void) ;
PurpleSavedStatus* purple_savedstatus_find(const char *title) ;
PurpleSavedStatus* purple_savedstatus_find_by_creation_time(time_t creation_time) ;
PurpleSavedStatus* purple_savedstatus_find_transient_by_type_and_message(PurpleStatusPrimitive type, const char *message) ;
gboolean purple_savedstatus_is_transient(const PurpleSavedStatus *saved_status) ;
char* purple_savedstatus_get_title(const PurpleSavedStatus *saved_status) ;
PurpleStatusPrimitive purple_savedstatus_get_type(const PurpleSavedStatus *saved_status) ;
char* purple_savedstatus_get_message(const PurpleSavedStatus *saved_status) ;
time_t purple_savedstatus_get_creation_time(const PurpleSavedStatus *saved_status) ;
gboolean purple_savedstatus_has_substatuses(const PurpleSavedStatus *saved_status) ;
struct _PurpleSavedStatusSub;
typedef struct _PurpleSavedStatusSub PurpleSavedStatusSub;
PurpleSavedStatusSub* purple_savedstatus_get_substatus(const PurpleSavedStatus *saved_status, const PurpleAccount *account) ;
PurpleStatusType* purple_savedstatus_substatus_get_type(const PurpleSavedStatusSub *substatus) ;
char* purple_savedstatus_substatus_get_message(const PurpleSavedStatusSub *substatus) ;
void purple_savedstatus_activate(const PurpleSavedStatus *saved_status) ;
void purple_savedstatus_activate_for_account(const PurpleSavedStatus *saved_status, const PurpleAccount *account) ;
void purple_savedstatuses_init(void) ;
void purple_savedstatuses_uninit(void) ;
struct _PurpleSmiley;
typedef struct _PurpleSmiley PurpleSmiley;
PurpleSmiley* purple_smiley_new(const PurpleStoredImage *img, const char *shortcut) ;
PurpleSmiley* purple_smiley_new_from_file(const char *shortcut, const char *filepath) ;
void purple_smiley_delete(const PurpleSmiley *smiley) ;
gboolean purple_smiley_set_shortcut(const PurpleSmiley *smiley, const char *shortcut) ;
void purple_smiley_set_data(const PurpleSmiley *smiley, const guchar *smiley_data_NULL, size_t smiley_data_len) ;
char* purple_smiley_get_shortcut(const PurpleSmiley *smiley) ;
char* purple_smiley_get_checksum(const PurpleSmiley *smiley) ;
PurpleStoredImage* purple_smiley_get_stored_image(const PurpleSmiley *smiley) ;
char* purple_smiley_get_extension(const PurpleSmiley *smiley) ;
char* purple_smiley_get_full_path(const PurpleSmiley *smiley) ;
GList* purple_smileys_get_all(void) ;
PurpleSmiley* purple_smileys_find_by_shortcut(const char *shortcut) ;
PurpleSmiley* purple_smileys_find_by_checksum(const char *checksum) ;
char* purple_smileys_get_storing_dir(void) ;
void purple_smileys_init(void) ;
void purple_smileys_uninit(void) ;
char* purple_primitive_get_id_from_type(PurpleStatusPrimitive type) ;
char* purple_primitive_get_name_from_type(PurpleStatusPrimitive type) ;
PurpleStatusPrimitive purple_primitive_get_type_from_id(const char *id) ;
PurpleStatusType* purple_status_type_new_full(PurpleStatusPrimitive primitive, const char *id, const char *name, gboolean saveable, gboolean user_settable, gboolean independent) ;
PurpleStatusType* purple_status_type_new(PurpleStatusPrimitive primitive, const char *id, const char *name, gboolean user_settable) ;
void purple_status_type_destroy(const PurpleStatusType *status_type) ;
void purple_status_type_set_primary_attr(const PurpleStatusType *status_type, const char *attr_id) ;
struct _PurpleValue;
typedef struct _PurpleValue PurpleValue;
void purple_status_type_add_attr(const PurpleStatusType *status_type, const char *id, const char *name, const PurpleValue *value) ;
PurpleStatusPrimitive purple_status_type_get_primitive(const PurpleStatusType *status_type) ;
char* purple_status_type_get_id(const PurpleStatusType *status_type) ;
char* purple_status_type_get_name(const PurpleStatusType *status_type) ;
gboolean purple_status_type_is_saveable(const PurpleStatusType *status_type) ;
gboolean purple_status_type_is_user_settable(const PurpleStatusType *status_type) ;
gboolean purple_status_type_is_independent(const PurpleStatusType *status_type) ;
gboolean purple_status_type_is_exclusive(const PurpleStatusType *status_type) ;
gboolean purple_status_type_is_available(const PurpleStatusType *status_type) ;
char* purple_status_type_get_primary_attr(const PurpleStatusType *type) ;
struct _PurpleStatusAttr;
typedef struct _PurpleStatusAttr PurpleStatusAttr;
PurpleStatusAttr* purple_status_type_get_attr(const PurpleStatusType *status_type, const char *id) ;
GList* purple_status_type_get_attrs(const PurpleStatusType *status_type) ;
PurpleStatusType* purple_status_type_find_with_id(const GList *status_types_NULL, const char *id) ;
PurpleStatusAttr* purple_status_attr_new(const char *id, const char *name, const PurpleValue *value_type) ;
void purple_status_attr_destroy(const PurpleStatusAttr *attr) ;
char* purple_status_attr_get_id(const PurpleStatusAttr *attr) ;
char* purple_status_attr_get_name(const PurpleStatusAttr *attr) ;
PurpleValue* purple_status_attr_get_value(const PurpleStatusAttr *attr) ;
PurpleStatus* purple_status_new(const PurpleStatusType *status_type, const PurplePresence *presence) ;
void purple_status_destroy(const PurpleStatus *status) ;
void purple_status_set_active(const PurpleStatus *status, gboolean active) ;
void purple_status_set_active_with_attrs_list(const PurpleStatus *status, gboolean active, const GList *attrs_NULL) ;
void purple_status_set_attr_boolean(const PurpleStatus *status, const char *id, gboolean value) ;
void purple_status_set_attr_int(const PurpleStatus *status, const char *id, int value) ;
void purple_status_set_attr_string(const PurpleStatus *status, const char *id, const char *value) ;
PurpleStatusType* purple_status_get_type(const PurpleStatus *status) ;
PurplePresence* purple_status_get_presence(const PurpleStatus *status) ;
char* purple_status_get_id(const PurpleStatus *status) ;
char* purple_status_get_name(const PurpleStatus *status) ;
gboolean purple_status_is_independent(const PurpleStatus *status) ;
gboolean purple_status_is_exclusive(const PurpleStatus *status) ;
gboolean purple_status_is_available(const PurpleStatus *status) ;
gboolean purple_status_is_active(const PurpleStatus *status) ;
gboolean purple_status_is_online(const PurpleStatus *status) ;
PurpleValue* purple_status_get_attr_value(const PurpleStatus *status, const char *id) ;
gboolean purple_status_get_attr_boolean(const PurpleStatus *status, const char *id) ;
int purple_status_get_attr_int(const PurpleStatus *status, const char *id) ;
char* purple_status_get_attr_string(const PurpleStatus *status, const char *id) ;
gint purple_status_compare(const PurpleStatus *status1, const PurpleStatus *status2) ;
PurplePresence* purple_presence_new(PurplePresenceContext context) ;
PurplePresence* purple_presence_new_for_account(const PurpleAccount *account) ;
PurplePresence* purple_presence_new_for_conv(const PurpleConversation *conv) ;
PurplePresence* purple_presence_new_for_buddy(const PurpleBuddy *buddy) ;
void purple_presence_destroy(const PurplePresence *presence) ;
void purple_presence_add_status(const PurplePresence *presence, const PurpleStatus *status) ;
void purple_presence_set_status_active(const PurplePresence *presence, const char *status_id, gboolean active) ;
void purple_presence_switch_status(const PurplePresence *presence, const char *status_id) ;
void purple_presence_set_idle(const PurplePresence *presence, gboolean idle, time_t idle_time) ;
void purple_presence_set_login_time(const PurplePresence *presence, time_t login_time) ;
PurplePresenceContext purple_presence_get_context(const PurplePresence *presence) ;
PurpleAccount* purple_presence_get_account(const PurplePresence *presence) ;
PurpleConversation* purple_presence_get_conversation(const PurplePresence *presence) ;
char* purple_presence_get_chat_user(const PurplePresence *presence) ;
PurpleBuddy* purple_presence_get_buddy(const PurplePresence *presence) ;
GList* purple_presence_get_statuses(const PurplePresence *presence) ;
PurpleStatus* purple_presence_get_status(const PurplePresence *presence, const char *status_id) ;
PurpleStatus* purple_presence_get_active_status(const PurplePresence *presence) ;
gboolean purple_presence_is_available(const PurplePresence *presence) ;
gboolean purple_presence_is_online(const PurplePresence *presence) ;
gboolean purple_presence_is_status_active(const PurplePresence *presence, const char *status_id) ;
gboolean purple_presence_is_status_primitive_active(const PurplePresence *presence, PurpleStatusPrimitive primitive) ;
gboolean purple_presence_is_idle(const PurplePresence *presence) ;
time_t purple_presence_get_idle_time(const PurplePresence *presence) ;
time_t purple_presence_get_login_time(const PurplePresence *presence) ;
gint purple_presence_compare(const PurplePresence *presence1, const PurplePresence *presence2) ;
void purple_status_init(void) ;
void purple_status_uninit(void) ;
int serv_send_typing(const PurpleConnection *gc, const char *name, PurpleTypingState state) ;
void serv_move_buddy(const PurpleBuddy *param0, const PurpleGroup *param1, const PurpleGroup *param2) ;
int serv_send_im(const PurpleConnection *param0, const char *param1, const char *param2, PurpleMessageFlags flags) ;
struct _PurpleAttentionType;
typedef struct _PurpleAttentionType PurpleAttentionType;
PurpleAttentionType* purple_get_attention_type_from_code(const PurpleAccount *account, guint type_code) ;
void serv_send_attention(const PurpleConnection *gc, const char *who, guint type_code) ;
void serv_got_attention(const PurpleConnection *gc, const char *who, guint type_code) ;
void serv_get_info(const PurpleConnection *param0, const char *param1) ;
void serv_set_info(const PurpleConnection *param0, const char *param1) ;
void serv_add_permit(const PurpleConnection *param0, const char *param1) ;
void serv_add_deny(const PurpleConnection *param0, const char *param1) ;
void serv_rem_permit(const PurpleConnection *param0, const char *param1) ;
void serv_rem_deny(const PurpleConnection *param0, const char *param1) ;
void serv_set_permit_deny(const PurpleConnection *param0) ;
void serv_chat_invite(const PurpleConnection *param0, int param1, const char *param2, const char *param3) ;
void serv_chat_leave(const PurpleConnection *param0, int param1) ;
void serv_chat_whisper(const PurpleConnection *param0, int param1, const char *param2, const char *param3) ;
int serv_chat_send(const PurpleConnection *param0, int param1, const char *param2, PurpleMessageFlags flags) ;
void serv_alias_buddy(const PurpleBuddy *param0) ;
void serv_got_alias(const PurpleConnection *gc, const char *who, const char *alias) ;
void purple_serv_got_private_alias(const PurpleConnection *gc, const char *who, const char *alias) ;
void serv_got_typing(const PurpleConnection *gc, const char *name, int timeout, PurpleTypingState state) ;
void serv_got_typing_stopped(const PurpleConnection *gc, const char *name) ;
void serv_got_im(const PurpleConnection *gc, const char *who, const char *msg, PurpleMessageFlags flags, time_t mtime) ;
void serv_join_chat(const PurpleConnection *param0, const GHashTable *data) ;
void serv_reject_chat(const PurpleConnection *param0, const GHashTable *data) ;
void serv_got_chat_invite(const PurpleConnection *gc, const char *name, const char *who, const char *message, const GHashTable *data) ;
PurpleConversation* serv_got_joined_chat(const PurpleConnection *gc, int id, const char *name) ;
void purple_serv_got_join_chat_failed(const PurpleConnection *gc, const GHashTable *data) ;
void serv_got_chat_left(const PurpleConnection *g, int id) ;
void serv_got_chat_in(const PurpleConnection *g, int id, const char *who, PurpleMessageFlags flags, const char *message, time_t mtime) ;
void serv_send_file(const PurpleConnection *gc, const char *who, const char *file) ;
void serv_chat_send_file(const PurpleConnection *gc, int id, const char *file) ;
struct _PurpleMenuAction;
typedef struct _PurpleMenuAction PurpleMenuAction;
void purple_menu_action_free(const PurpleMenuAction *act) ;
void purple_util_set_current_song(const char *title, const char *artist, const char *album) ;
void purple_util_init(void) ;
void purple_util_uninit(void) ;
char* purple_mime_decode_field(const char *str) ;
time_t purple_time_build(int year, int month, int day, int hour, int min, int sec) ;
char* purple_markup_escape_text(const char *text, gssize length) ;
char* purple_markup_strip_html(const char *str) ;
char* purple_markup_linkify(const char *str) ;
char* purple_unescape_text(const char *text) ;
char* purple_unescape_html(const char *html) ;
char* purple_markup_slice(const char *str, guint x, guint y) ;
char* purple_markup_get_tag_name(const char *tag) ;
char* purple_markup_unescape_entity(const char *text, const int *length_NULL) ;
char* purple_markup_get_css_property(const char *style, const char *opt) ;
gboolean purple_markup_is_rtl(const char *html) ;
char* purple_home_dir(void) ;
char* purple_user_dir(void) ;
void purple_util_set_user_dir(const char *dir) ;
int purple_build_dir(const char *path, int mode) ;
gboolean purple_util_write_data_to_file(const char *filename, const char *data, gssize size) ;
gboolean purple_util_write_data_to_file_absolute(const char *filename_full, const char *data, gssize size) ;
gboolean purple_program_is_valid(const char *program) ;
gboolean purple_running_gnome(void) ;
gboolean purple_running_kde(void) ;
gboolean purple_running_osx(void) ;
char* purple_fd_get_ip(int fd) ;
int purple_socket_get_family(int fd) ;
gboolean purple_socket_speaks_ipv4(int fd) ;
gboolean purple_strequal(const char *left, const char *right) ;
char* purple_normalize(const PurpleAccount *account, const char *str) ;
char* purple_normalize_nocase(const PurpleAccount *account, const char *str) ;
gboolean purple_str_has_prefix(const char *s, const char *p) ;
gboolean purple_str_has_suffix(const char *s, const char *x) ;
char* purple_strdup_withhtml(const char *src) ;
char* purple_str_add_cr(const char *str) ;
char* purple_strreplace(const char *string, const char *delimiter, const char *replacement) ;
char* purple_utf8_ncr_encode(const char *in) ;
char* purple_utf8_ncr_decode(const char *in) ;
char* purple_strcasereplace(const char *string, const char *delimiter, const char *replacement) ;
char* purple_strcasestr(const char *haystack, const char *needle) ;
char* purple_str_size_to_units(size_t size) ;
char* purple_str_seconds_to_string(guint sec) ;
char* purple_str_binary_to_ascii(const unsigned char *binary, guint len) ;
void purple_got_protocol_handler_uri(const char *uri) ;
struct _PurpleUtilFetchUrlData;
typedef struct _PurpleUtilFetchUrlData PurpleUtilFetchUrlData;
void purple_util_fetch_url_cancel(const PurpleUtilFetchUrlData *url_data) ;
char* purple_url_decode(const char *str) ;
char* purple_url_encode(const char *str) ;
gboolean purple_email_is_valid(const char *address) ;
gboolean purple_ip_address_is_valid(const char *ip) ;
gboolean purple_ipv4_address_is_valid(const char *ip) ;
gboolean purple_ipv6_address_is_valid(const char *ip) ;
GList* purple_uri_list_extract_uris(const char *uri_list) ;
GList* purple_uri_list_extract_filenames(const char *uri_list) ;
char* purple_uri_escape_for_open(const char *unescaped) ;
char* purple_utf8_try_convert(const char *str) ;
char* purple_utf8_salvage(const char *str) ;
char* purple_utf8_strip_unprintables(const char *str) ;
char* purple_gai_strerror(gint errnum) ;
int purple_utf8_strcasecmp(const char *a, const char *b) ;
gboolean purple_utf8_has_word(const char *haystack, const char *needle) ;
char* purple_text_strip_mnemonic(const char *in) ;
char* purple_unescape_filename(const char *str) ;
char* purple_escape_filename(const char *str) ;
char* _purple_oscar_convert(const char *act, const char *protocol) ;
void purple_restore_default_signal_handlers(void) ;
char* purple_get_host_name(void) ;
char* purple_uuid_random(void) ;
struct _xmlnode;
typedef struct _xmlnode xmlnode;
void xmlnode_insert_child(const xmlnode *parent, const xmlnode *child) ;
void xmlnode_insert_data(const xmlnode *node, const char *data, gssize size) ;
char* xmlnode_get_data(const xmlnode *node) ;
char* xmlnode_get_data_unescaped(const xmlnode *node) ;
void xmlnode_set_attrib(const xmlnode *node, const char *attr, const char *value) ;
void xmlnode_set_attrib_with_prefix(const xmlnode *node, const char *attr, const char *prefix, const char *value) ;
void xmlnode_set_attrib_with_namespace(const xmlnode *node, const char *attr, const char *xmlns, const char *value) ;
void xmlnode_set_attrib_full(const xmlnode *node, const char *attr, const char *xmlns, const char *prefix, const char *value) ;
char* xmlnode_get_attrib(const xmlnode *node, const char *attr) ;
char* xmlnode_get_attrib_with_namespace(const xmlnode *node, const char *attr, const char *xmlns) ;
void xmlnode_remove_attrib(const xmlnode *node, const char *attr) ;
void xmlnode_remove_attrib_with_namespace(const xmlnode *node, const char *attr, const char *xmlns) ;
void xmlnode_set_namespace(const xmlnode *node, const char *xmlns) ;
char* xmlnode_get_namespace(const xmlnode *node) ;
void xmlnode_set_prefix(const xmlnode *node, const char *prefix) ;
char* xmlnode_get_prefix(const xmlnode *node) ;
char* xmlnode_to_str(const xmlnode *node, const int *len_NULL) ;
char* xmlnode_to_formatted_str(const xmlnode *node, const int *len_NULL) ;
void xmlnode_free(const xmlnode *node) ;
PurpleAttentionType* purple_attention_type_new(const char *ulname, const char *name, const char *inc_desc, const char *out_desc) ;
void purple_attention_type_set_name(const PurpleAttentionType *type, const char *name) ;
void purple_attention_type_set_incoming_desc(const PurpleAttentionType *type, const char *desc) ;
void purple_attention_type_set_outgoing_desc(const PurpleAttentionType *type, const char *desc) ;
void purple_attention_type_set_icon_name(const PurpleAttentionType *type, const char *name) ;
void purple_attention_type_set_unlocalized_name(const PurpleAttentionType *type, const char *ulname) ;
char* purple_attention_type_get_name(const PurpleAttentionType *type) ;
char* purple_attention_type_get_incoming_desc(const PurpleAttentionType *type) ;
char* purple_attention_type_get_outgoing_desc(const PurpleAttentionType *type) ;
char* purple_attention_type_get_icon_name(const PurpleAttentionType *type) ;
char* purple_attention_type_get_unlocalized_name(const PurpleAttentionType *type) ;
void purple_prpl_got_account_idle(const PurpleAccount *account, gboolean idle, time_t idle_time) ;
void purple_prpl_got_account_login_time(const PurpleAccount *account, time_t login_time) ;
void purple_prpl_got_account_actions(const PurpleAccount *account) ;
void purple_prpl_got_user_idle(const PurpleAccount *account, const char *name, gboolean idle, time_t idle_time) ;
void purple_prpl_got_user_login_time(const PurpleAccount *account, const char *name, time_t login_time) ;
void purple_prpl_got_user_status_deactive(const PurpleAccount *account, const char *name, const char *status_id) ;
void purple_prpl_change_account_status(const PurpleAccount *account, const PurpleStatus *old_status, const PurpleStatus *new_status) ;
GList* purple_prpl_get_statuses(const PurpleAccount *account, const PurplePresence *presence) ;
void purple_prpl_send_attention(const PurpleConnection *gc, const char *who, guint type_code) ;
void purple_prpl_got_attention(const PurpleConnection *gc, const char *who, guint type_code) ;
void purple_prpl_got_attention_in_chat(const PurpleConnection *gc, int id, const char *who, guint type_code) ;
PurpleMediaCaps purple_prpl_get_media_caps(const PurpleAccount *account, const char *who) ;
gboolean purple_prpl_initiate_media(const PurpleAccount *account, const char *who, PurpleMediaSessionType type) ;
void purple_prpl_got_media_caps(const PurpleAccount *account, const char *who) ;
PurplePlugin* purple_find_prpl(const char *id) ;
