// python wrapper for vtkImageVolumeRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkImageVolumeRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkImageVolumeRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkImageVolumeRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkVolumeRepresentation_ClassNew
extern "C" { PyObject *PyvtkVolumeRepresentation_ClassNew(); }
#define DECLARED_PyvtkVolumeRepresentation_ClassNew
#endif

static PyObject *
PyvtkImageVolumeRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkImageVolumeRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkImageVolumeRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkImageVolumeRepresentation *tempr = vtkImageVolumeRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageVolumeRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkImageVolumeRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkImageVolumeRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkImageVolumeRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkImageVolumeRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetAmbient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAmbient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAmbient(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetAmbient(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetDiffuse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDiffuse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDiffuse(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetDiffuse(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetSpecular(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecular");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecular(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetSpecular(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetSpecularPower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularPower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecularPower(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetSpecularPower(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetShade(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShade");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShade(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetShade(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetAnisotropy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnisotropy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnisotropy(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetAnisotropy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetSliceFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSliceFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  vtkImplicitFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImplicitFunction"))
  {
    if (ap.IsBound())
    {
      op->SetSliceFunction(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetSliceFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetCoordinateSystem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoordinateSystem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoordinateSystem(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetCoordinateSystem(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetIsosurfaceValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsosurfaceValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetIsosurfaceValue(temp0, temp1);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetIsosurfaceValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetNumberOfIsosurfaces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfIsosurfaces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfIsosurfaces(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetNumberOfIsosurfaces(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetRequestedRenderMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestedRenderMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRequestedRenderMode(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetRequestedRenderMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetBlendMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlendMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlendMode(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetBlendMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetCropping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCropping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCropping(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetCropping(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetGlobalIlluminationReach(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGlobalIlluminationReach");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGlobalIlluminationReach(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetGlobalIlluminationReach(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetVolumetricScatteringBlending(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVolumetricScatteringBlending");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVolumetricScatteringBlending(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetVolumetricScatteringBlending(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetCroppingOrigin_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCroppingOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCroppingOrigin(temp0, temp1, temp2);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetCroppingOrigin(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkImageVolumeRepresentation_SetCroppingOrigin_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCroppingOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCroppingOrigin(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetCroppingOrigin(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkImageVolumeRepresentation_SetCroppingOrigin(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkImageVolumeRepresentation_SetCroppingOrigin_s1(self, args);
    case 1:
      return PyvtkImageVolumeRepresentation_SetCroppingOrigin_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCroppingOrigin");
  return nullptr;
}


static PyObject *
PyvtkImageVolumeRepresentation_GetCroppingOrigin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCroppingOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCroppingOrigin() :
      op->vtkImageVolumeRepresentation::GetCroppingOrigin());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetCroppingScale_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCroppingScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCroppingScale(temp0, temp1, temp2);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetCroppingScale(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkImageVolumeRepresentation_SetCroppingScale_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCroppingScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCroppingScale(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetCroppingScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkImageVolumeRepresentation_SetCroppingScale(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkImageVolumeRepresentation_SetCroppingScale_s1(self, args);
    case 1:
      return PyvtkImageVolumeRepresentation_SetCroppingScale_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCroppingScale");
  return nullptr;
}


static PyObject *
PyvtkImageVolumeRepresentation_GetCroppingScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCroppingScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCroppingScale() :
      op->vtkImageVolumeRepresentation::GetCroppingScale());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetUseTransfer2D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseTransfer2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseTransfer2D(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetUseTransfer2D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetUseGradientForTransfer2D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseGradientForTransfer2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseGradientForTransfer2D(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetUseGradientForTransfer2D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SelectColorArray2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectColorArray2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SelectColorArray2(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SelectColorArray2(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SelectColorArray2Component(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectColorArray2Component");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectColorArray2Component(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SelectColorArray2Component(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkImageVolumeRepresentation_SetTransferFunction2D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTransferFunction2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkImageVolumeRepresentation *op = static_cast<vtkImageVolumeRepresentation *>(vp);

  vtkPVTransferFunction2D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVTransferFunction2D"))
  {
    if (ap.IsBound())
    {
      op->SetTransferFunction2D(temp0);
    }
    else
    {
      op->vtkImageVolumeRepresentation::SetTransferFunction2D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkImageVolumeRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkImageVolumeRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkImageVolumeRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkImageVolumeRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkImageVolumeRepresentation\nC++: static vtkImageVolumeRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkImageVolumeRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkImageVolumeRepresentation\nC++: vtkImageVolumeRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkImageVolumeRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkImageVolumeRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ProcessViewRequest", PyvtkImageVolumeRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n"},
  {"SetAmbient", PyvtkImageVolumeRepresentation_SetAmbient, METH_VARARGS,
   "SetAmbient(self, __a:float) -> None\nC++: void SetAmbient(double)\n\n"},
  {"SetDiffuse", PyvtkImageVolumeRepresentation_SetDiffuse, METH_VARARGS,
   "SetDiffuse(self, __a:float) -> None\nC++: void SetDiffuse(double)\n\n"},
  {"SetSpecular", PyvtkImageVolumeRepresentation_SetSpecular, METH_VARARGS,
   "SetSpecular(self, __a:float) -> None\nC++: void SetSpecular(double)\n\n"},
  {"SetSpecularPower", PyvtkImageVolumeRepresentation_SetSpecularPower, METH_VARARGS,
   "SetSpecularPower(self, __a:float) -> None\nC++: void SetSpecularPower(double)\n\n"},
  {"SetShade", PyvtkImageVolumeRepresentation_SetShade, METH_VARARGS,
   "SetShade(self, __a:bool) -> None\nC++: void SetShade(bool)\n\n"},
  {"SetAnisotropy", PyvtkImageVolumeRepresentation_SetAnisotropy, METH_VARARGS,
   "SetAnisotropy(self, __a:float) -> None\nC++: void SetAnisotropy(float)\n\n"},
  {"SetSliceFunction", PyvtkImageVolumeRepresentation_SetSliceFunction, METH_VARARGS,
   "SetSliceFunction(self, slice:vtkImplicitFunction) -> None\nC++: void SetSliceFunction(vtkImplicitFunction *slice)\n\n"},
  {"SetCoordinateSystem", PyvtkImageVolumeRepresentation_SetCoordinateSystem, METH_VARARGS,
   "SetCoordinateSystem(self, __a:int) -> None\nC++: virtual void SetCoordinateSystem(int)\n\n"},
  {"SetIsosurfaceValue", PyvtkImageVolumeRepresentation_SetIsosurfaceValue, METH_VARARGS,
   "SetIsosurfaceValue(self, i:int, value:float) -> None\nC++: void SetIsosurfaceValue(int i, double value)\n\nMethods to set isosurface values.\n"},
  {"SetNumberOfIsosurfaces", PyvtkImageVolumeRepresentation_SetNumberOfIsosurfaces, METH_VARARGS,
   "SetNumberOfIsosurfaces(self, number:int) -> None\nC++: void SetNumberOfIsosurfaces(int number)\n\n"},
  {"SetRequestedRenderMode", PyvtkImageVolumeRepresentation_SetRequestedRenderMode, METH_VARARGS,
   "SetRequestedRenderMode(self, __a:int) -> None\nC++: void SetRequestedRenderMode(int)\n\n"},
  {"SetBlendMode", PyvtkImageVolumeRepresentation_SetBlendMode, METH_VARARGS,
   "SetBlendMode(self, __a:int) -> None\nC++: void SetBlendMode(int)\n\n"},
  {"SetCropping", PyvtkImageVolumeRepresentation_SetCropping, METH_VARARGS,
   "SetCropping(self, __a:int) -> None\nC++: void SetCropping(int)\n\n"},
  {"SetGlobalIlluminationReach", PyvtkImageVolumeRepresentation_SetGlobalIlluminationReach, METH_VARARGS,
   "SetGlobalIlluminationReach(self, __a:float) -> None\nC++: void SetGlobalIlluminationReach(float)\n\n"},
  {"SetVolumetricScatteringBlending", PyvtkImageVolumeRepresentation_SetVolumetricScatteringBlending, METH_VARARGS,
   "SetVolumetricScatteringBlending(self, __a:float) -> None\nC++: void SetVolumetricScatteringBlending(float)\n\n"},
  {"SetCroppingOrigin", PyvtkImageVolumeRepresentation_SetCroppingOrigin, METH_VARARGS,
   "SetCroppingOrigin(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetCroppingOrigin(double _arg1, double _arg2,\n    double _arg3)\nSetCroppingOrigin(self, _arg:(float, float, float)) -> None\nC++: virtual void SetCroppingOrigin(const double _arg[3])\n\nGet/Set the cropping origin.\n"},
  {"GetCroppingOrigin", PyvtkImageVolumeRepresentation_GetCroppingOrigin, METH_VARARGS,
   "GetCroppingOrigin(self) -> (float, float, float)\nC++: virtual double *GetCroppingOrigin()\n\n"},
  {"SetCroppingScale", PyvtkImageVolumeRepresentation_SetCroppingScale, METH_VARARGS,
   "SetCroppingScale(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetCroppingScale(double _arg1, double _arg2,\n    double _arg3)\nSetCroppingScale(self, _arg:(float, float, float)) -> None\nC++: virtual void SetCroppingScale(const double _arg[3])\n\nGet/Set the cropping scale.\n"},
  {"GetCroppingScale", PyvtkImageVolumeRepresentation_GetCroppingScale, METH_VARARGS,
   "GetCroppingScale(self) -> (float, float, float)\nC++: virtual double *GetCroppingScale()\n\n"},
  {"SetUseTransfer2D", PyvtkImageVolumeRepresentation_SetUseTransfer2D, METH_VARARGS,
   "SetUseTransfer2D(self, __a:bool) -> None\nC++: void SetUseTransfer2D(bool)\n\n"},
  {"SetUseGradientForTransfer2D", PyvtkImageVolumeRepresentation_SetUseGradientForTransfer2D, METH_VARARGS,
   "SetUseGradientForTransfer2D(self, __a:bool) -> None\nC++: void SetUseGradientForTransfer2D(bool)\n\n"},
  {"SelectColorArray2", PyvtkImageVolumeRepresentation_SelectColorArray2, METH_VARARGS,
   "SelectColorArray2(self, __a:int, __b:int, __c:int, __d:int,\n    name:str) -> None\nC++: void SelectColorArray2(int, int, int, int, const char *name)\n\n"},
  {"SelectColorArray2Component", PyvtkImageVolumeRepresentation_SelectColorArray2Component, METH_VARARGS,
   "SelectColorArray2Component(self, component:int) -> None\nC++: void SelectColorArray2Component(int component)\n\n"},
  {"SetTransferFunction2D", PyvtkImageVolumeRepresentation_SetTransferFunction2D, METH_VARARGS,
   "SetTransferFunction2D(self, transfer2d:vtkPVTransferFunction2D)\n    -> None\nC++: void SetTransferFunction2D(\n    vtkPVTransferFunction2D *transfer2d)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkImageVolumeRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("ambient"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetAmbient(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetAmbient(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAmbient\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("diffuse"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetDiffuse(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetDiffuse(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDiffuse\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetSpecular(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetSpecular(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecular\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_power"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetSpecularPower(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetSpecularPower(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecularPower\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("shade"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetShade(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetShade(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetShade\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("anisotropy"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetAnisotropy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetAnisotropy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAnisotropy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("slice_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetSliceFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetSliceFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSliceFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coordinate_system"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetCoordinateSystem(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetCoordinateSystem(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoordinateSystem\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("requested_render_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetRequestedRenderMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetRequestedRenderMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRequestedRenderMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("blend_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetBlendMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetBlendMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBlendMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cropping"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetCropping(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetCropping(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCropping\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_illumination_reach"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetGlobalIlluminationReach(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetGlobalIlluminationReach(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGlobalIlluminationReach\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("volumetric_scattering_blending"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetVolumetricScatteringBlending(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetVolumetricScatteringBlending(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVolumetricScatteringBlending\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cropping_origin"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkImageVolumeRepresentation_GetCroppingOrigin(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetCroppingOrigin(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetCroppingOrigin(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCroppingOrigin/SetCroppingOrigin\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cropping_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkImageVolumeRepresentation_GetCroppingScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetCroppingScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetCroppingScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCroppingScale/SetCroppingScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_transfer2d"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetUseTransfer2D(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetUseTransfer2D(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseTransfer2D\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_gradient_for_transfer2d"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetUseGradientForTransfer2D(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetUseGradientForTransfer2D(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseGradientForTransfer2D\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("transfer_function2d"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetTransferFunction2D(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetTransferFunction2D(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTransferFunction2D\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_isosurfaces"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkImageVolumeRepresentation_SetNumberOfIsosurfaces(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkImageVolumeRepresentation_SetNumberOfIsosurfaces(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfIsosurfaces\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkImageVolumeRepresentation_Doc =
  "vtkImageVolumeRepresentation - representation for showing image\ndatasets as a volume.\n\n"
  "Superclass: vtkVolumeRepresentation\n\n"
  "vtkImageVolumeRepresentation is a representation for volume rendering\n"
  "vtkImageData. Unlike other data-representations used by ParaView,\n"
  "this representation does not support delivery to client (or render\n"
  "server) nodes. In those configurations, it merely delivers a outline\n"
  "for the image to the client and render-server and those nodes simply\n"
  "render the outline.\n\n"
  "vtkImageVolumeRepresentation has a few caveats:\n\n"
  "1. It only supports vtkImageData and vtkPartitionedDataSet comprising\n"
  "of vtkImageData. In case of latter, any partition not a vtkImageData\n"
  "   will be silently skipped.\n\n"
  "2. In distributed mode, bounds on each rank as assumed to be\n"
  "   non-overlapping.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkImageVolumeRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkImageVolumeRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkImageVolumeRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkImageVolumeRepresentation_StaticNew()
{
  return vtkImageVolumeRepresentation::New();
}

PyObject *PyvtkImageVolumeRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkImageVolumeRepresentation_Type, PyvtkImageVolumeRepresentation_Methods,
    "vtkImageVolumeRepresentation",
 &PyvtkImageVolumeRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkVolumeRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkImageVolumeRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkImageVolumeRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkImageVolumeRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkImageVolumeRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

