/* FileHandler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FileHandler.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SCRATCH_SERVICES_FILE_OPTION_EXISTS,
	SCRATCH_SERVICES_FILE_OPTION_IS_DIR,
	SCRATCH_SERVICES_FILE_OPTION_IS_EXECUTABLE
} ScratchServicesFileOption;

#define SCRATCH_SERVICES_TYPE_FILE_OPTION (scratch_services_file_option_get_type ())

#define SCRATCH_SERVICES_TYPE_FILE_HANDLER (scratch_services_file_handler_get_type ())
#define SCRATCH_SERVICES_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_FILE_HANDLER, ScratchServicesFileHandler))
#define SCRATCH_SERVICES_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_FILE_HANDLER, ScratchServicesFileHandlerClass))
#define SCRATCH_SERVICES_IS_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_FILE_HANDLER))
#define SCRATCH_SERVICES_IS_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_FILE_HANDLER))
#define SCRATCH_SERVICES_FILE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_FILE_HANDLER, ScratchServicesFileHandlerClass))

typedef struct _ScratchServicesFileHandler ScratchServicesFileHandler;
typedef struct _ScratchServicesFileHandlerClass ScratchServicesFileHandlerClass;
typedef struct _ScratchServicesFileHandlerPrivate ScratchServicesFileHandlerPrivate;
enum  {
	SCRATCH_SERVICES_FILE_HANDLER_0_PROPERTY,
	SCRATCH_SERVICES_FILE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* scratch_services_file_handler_properties[SCRATCH_SERVICES_FILE_HANDLER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScratchServicesFileHandlerLoadContentFromFileData ScratchServicesFileHandlerLoadContentFromFileData;

struct _ScratchServicesFileHandler {
	GObject parent_instance;
	ScratchServicesFileHandlerPrivate * priv;
};

struct _ScratchServicesFileHandlerClass {
	GObjectClass parent_class;
};

struct _ScratchServicesFileHandlerLoadContentFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	gchar* result;
	GString* text;
	GString* _tmp0_;
	GFileInputStream* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* dis;
	GDataInputStream* _tmp3_;
	gchar* line;
	gchar* _tmp4_;
	GDataInputStream* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	GString* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError* e;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_;
};

static gpointer scratch_services_file_handler_parent_class = NULL;

VALA_EXTERN GType scratch_services_file_option_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scratch_services_file_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesFileHandler, g_object_unref)
VALA_EXTERN gboolean scratch_services_file_handler_can_open_file (GFile* file,
                                                      gboolean* is_folder);
static void scratch_services_file_handler_load_content_from_file_data_free (gpointer _data);
VALA_EXTERN void scratch_services_file_handler_load_content_from_file (GFile* file,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN gchar* scratch_services_file_handler_load_content_from_file_finish (GAsyncResult* _res_);
static gboolean scratch_services_file_handler_load_content_from_file_co (ScratchServicesFileHandlerLoadContentFromFileData* _data_);
static void scratch_services_file_handler_load_content_from_file_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
VALA_EXTERN gchar* scratch_services_file_handler_load_content_from_file_sync (GFile* file);
VALA_EXTERN gboolean scratch_services_file_handler_move (const gchar* path,
                                             const gchar* new_path);
VALA_EXTERN gboolean scratch_services_file_handler_move_uri (const gchar* uri,
                                                 const gchar* new_uri);
VALA_EXTERN gboolean scratch_services_file_handler_copy (const gchar* path,
                                             const gchar* new_path);
VALA_EXTERN ScratchServicesFileHandler* scratch_services_file_handler_new (void);
VALA_EXTERN ScratchServicesFileHandler* scratch_services_file_handler_construct (GType object_type);
static GType scratch_services_file_handler_get_type_once (void);

 G_GNUC_NO_INLINE static GType
scratch_services_file_option_get_type_once (void)
{
	static const GEnumValue values[] = {{SCRATCH_SERVICES_FILE_OPTION_EXISTS, "SCRATCH_SERVICES_FILE_OPTION_EXISTS", "exists"}, {SCRATCH_SERVICES_FILE_OPTION_IS_DIR, "SCRATCH_SERVICES_FILE_OPTION_IS_DIR", "is-dir"}, {SCRATCH_SERVICES_FILE_OPTION_IS_EXECUTABLE, "SCRATCH_SERVICES_FILE_OPTION_IS_EXECUTABLE", "is-executable"}, {0, NULL, NULL}};
	GType scratch_services_file_option_type_id;
	scratch_services_file_option_type_id = g_enum_register_static ("ScratchServicesFileOption", values);
	return scratch_services_file_option_type_id;
}

GType
scratch_services_file_option_get_type (void)
{
	static gsize scratch_services_file_option_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_file_option_type_id__once)) {
		GType scratch_services_file_option_type_id;
		scratch_services_file_option_type_id = scratch_services_file_option_get_type_once ();
		g_once_init_leave (&scratch_services_file_option_type_id__once, scratch_services_file_option_type_id);
	}
	return scratch_services_file_option_type_id__once;
}

gboolean
scratch_services_file_handler_can_open_file (GFile* file,
                                             gboolean* is_folder)
{
	gboolean _vala_is_folder = FALSE;
	gboolean _tmp0_ = FALSE;
	GFileType type = 0;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_vala_is_folder = FALSE;
	if (file == NULL) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_path (file);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == NULL;
		_g_free0 (_tmp2_);
	}
	if (_tmp0_) {
		gchar* _tmp3_ = NULL;
		if (file != NULL) {
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp7_;
			_tmp5_ = g_file_get_uri (file);
			_tmp4_ = _tmp5_;
			if (_tmp4_ == NULL) {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("null");
				_g_free0 (_tmp4_);
				_tmp4_ = _tmp6_;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp7_;
			_g_free0 (_tmp4_);
		} else {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("null");
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp8_;
		}
		g_warning ("FileHandler.vala:33: Ignoring  file %s. Cannot determine path", _tmp3_);
		result = FALSE;
		_g_free0 (_tmp3_);
		if (is_folder) {
			*is_folder = _vala_is_folder;
		}
		return result;
	}
	type = g_file_query_file_type (file, G_FILE_QUERY_INFO_NONE, NULL);
	switch (type) {
		case G_FILE_TYPE_DIRECTORY:
		{
			_vala_is_folder = TRUE;
			result = TRUE;
			if (is_folder) {
				*is_folder = _vala_is_folder;
			}
			return result;
		}
		case G_FILE_TYPE_REGULAR:
		case G_FILE_TYPE_UNKNOWN:
		{
			result = TRUE;
			if (is_folder) {
				*is_folder = _vala_is_folder;
			}
			return result;
		}
		default:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = g_file_get_path (file);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_enum_to_string (g_file_type_get_type (), type);
			g_warning ("FileHandler.vala:51: Cannot open %s. Cannot handle file type %s", _tmp10_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp10_);
			result = FALSE;
			if (is_folder) {
				*is_folder = _vala_is_folder;
			}
			return result;
		}
	}
}

static void
scratch_services_file_handler_load_content_from_file_data_free (gpointer _data)
{
	ScratchServicesFileHandlerLoadContentFromFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->result);
	g_slice_free (ScratchServicesFileHandlerLoadContentFromFileData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
scratch_services_file_handler_load_content_from_file (GFile* file,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	ScratchServicesFileHandlerLoadContentFromFileData* _data_;
	GFile* _tmp0_;
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (ScratchServicesFileHandlerLoadContentFromFileData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_file_handler_load_content_from_file_data_free);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp0_;
	scratch_services_file_handler_load_content_from_file_co (_data_);
}

gchar*
scratch_services_file_handler_load_content_from_file_finish (GAsyncResult* _res_)
{
	gchar* result;
	ScratchServicesFileHandlerLoadContentFromFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
scratch_services_file_handler_load_content_from_file_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	ScratchServicesFileHandlerLoadContentFromFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	scratch_services_file_handler_load_content_from_file_co (_data_);
}

static gboolean
scratch_services_file_handler_load_content_from_file_co (ScratchServicesFileHandlerLoadContentFromFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_string_new ("");
	_data_->text = _data_->_tmp0_;
	{
		_data_->_tmp2_ = g_file_read (_data_->file, NULL, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp1_);
		_data_->dis = _data_->_tmp3_;
		_data_->line = NULL;
		while (TRUE) {
			_data_->_tmp5_ = _data_->dis;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, scratch_services_file_handler_load_content_from_file_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = g_data_input_stream_read_line_finish (_data_->_tmp5_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp4_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->dis);
				_g_object_unref0 (_data_->_tmp1_);
				goto __catch0_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp4_;
			_data_->_tmp4_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp7_;
			_data_->_tmp8_ = _data_->line;
			if (!(_data_->_tmp8_ != NULL)) {
				_g_free0 (_data_->_tmp4_);
				break;
			}
			_data_->_tmp9_ = _data_->text;
			if (_data_->_tmp9_->len != ((gssize) 0)) {
				_data_->_tmp10_ = _data_->text;
				g_string_append_c (_data_->_tmp10_, '\n');
			}
			_data_->_tmp11_ = _data_->text;
			_data_->_tmp12_ = _data_->line;
			g_string_append (_data_->_tmp11_, _data_->_tmp12_);
			_g_free0 (_data_->_tmp4_);
		}
		_data_->_tmp13_ = _data_->text;
		_data_->_tmp14_ = _data_->_tmp13_->str;
		_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
		_data_->result = _data_->_tmp15_;
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->_tmp1_);
		_g_string_free0 (_data_->text);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = g_file_get_basename (_data_->file);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("FileHandler.vala:70: Cannot read \"%s\": %s", _data_->_tmp17_, _data_->_tmp19_);
		_g_free0 (_data_->_tmp17_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_string_free0 (_data_->text);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_string_free0 (_data_->text);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
scratch_services_file_handler_load_content_from_file_sync (GFile* file)
{
	GString* text = NULL;
	GString* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_string_new ("");
	text = _tmp0_;
	{
		GFileInputStream* _tmp1_ = NULL;
		GFileInputStream* _tmp2_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp3_;
		gchar* line = NULL;
		GString* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp2_ = g_file_read (file, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp1_);
		dis = _tmp3_;
		line = NULL;
		while (TRUE) {
			gchar* _tmp4_ = NULL;
			GDataInputStream* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp5_ = dis;
			_tmp6_ = g_data_input_stream_read_line (_tmp5_, NULL, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp1_);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_free0 (line);
			line = _tmp7_;
			_tmp8_ = line;
			if (!(_tmp8_ != NULL)) {
				_g_free0 (_tmp4_);
				break;
			}
			_tmp9_ = line;
			if (g_strcmp0 (_tmp9_, "\n") != 0) {
				GString* _tmp10_;
				GString* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = text;
				if (_tmp10_->len != ((gssize) 0)) {
					GString* _tmp11_;
					_tmp11_ = text;
					g_string_append_c (_tmp11_, '\n');
				}
				_tmp12_ = text;
				_tmp13_ = line;
				g_string_append (_tmp12_, _tmp13_);
			}
			_g_free0 (_tmp4_);
		}
		_tmp14_ = text;
		_tmp15_ = _tmp14_->str;
		_tmp16_ = g_strdup (_tmp15_);
		result = _tmp16_;
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp1_);
		_g_string_free0 (text);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = g_file_get_basename (file);
		_tmp18_ = _tmp17_;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("FileHandler.vala:91: Cannot read \"%s\": %s", _tmp18_, _tmp20_);
		_g_free0 (_tmp18_);
		result = NULL;
		_g_error_free0 (e);
		_g_string_free0 (text);
		return result;
	}
	__finally0:
	_g_string_free0 (text);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
scratch_services_file_handler_move (const gchar* path,
                                    const gchar* new_path)
{
	GFile* old = NULL;
	GFile* _tmp0_;
	GFile* newpath = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (new_path != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (path);
	old = _tmp0_;
	_tmp1_ = g_file_new_for_path (new_path);
	newpath = _tmp1_;
	_tmp2_ = newpath;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		gboolean _tmp7_ = FALSE;
		{
			GFile* _tmp3_;
			GFile* _tmp4_;
			_tmp3_ = old;
			_tmp4_ = newpath;
			g_file_move (_tmp3_, _tmp4_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = TRUE;
			_g_object_unref0 (newpath);
			_g_object_unref0 (old);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("FileHandler.vala:105: %s", _tmp6_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (newpath);
			_g_object_unref0 (old);
			return result;
		}
		__finally0:
		_g_object_unref0 (newpath);
		_g_object_unref0 (old);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	} else {
		result = FALSE;
		_g_object_unref0 (newpath);
		_g_object_unref0 (old);
		return result;
	}
}

gboolean
scratch_services_file_handler_move_uri (const gchar* uri,
                                        const gchar* new_uri)
{
	GFile* old = NULL;
	GFile* _tmp0_;
	GFile* newuri = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (new_uri != NULL, FALSE);
	_tmp0_ = g_file_new_for_uri (uri);
	old = _tmp0_;
	_tmp1_ = g_file_new_for_uri (new_uri);
	newuri = _tmp1_;
	_tmp2_ = newuri;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		gboolean _tmp7_ = FALSE;
		{
			GFile* _tmp3_;
			GFile* _tmp4_;
			_tmp3_ = old;
			_tmp4_ = newuri;
			g_file_move (_tmp3_, _tmp4_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = TRUE;
			_g_object_unref0 (newuri);
			_g_object_unref0 (old);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("FileHandler.vala:122: %s", _tmp6_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (newuri);
			_g_object_unref0 (old);
			return result;
		}
		__finally0:
		_g_object_unref0 (newuri);
		_g_object_unref0 (old);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	} else {
		result = FALSE;
		_g_object_unref0 (newuri);
		_g_object_unref0 (old);
		return result;
	}
}

gboolean
scratch_services_file_handler_copy (const gchar* path,
                                    const gchar* new_path)
{
	GFile* old = NULL;
	GFile* _tmp0_;
	GFile* newpath = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (new_path != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (path);
	old = _tmp0_;
	_tmp1_ = g_file_new_for_path (new_path);
	newpath = _tmp1_;
	_tmp2_ = newpath;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		gboolean _tmp7_ = FALSE;
		{
			GFile* _tmp3_;
			GFile* _tmp4_;
			_tmp3_ = old;
			_tmp4_ = newpath;
			g_file_copy (_tmp3_, _tmp4_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = TRUE;
			_g_object_unref0 (newpath);
			_g_object_unref0 (old);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("FileHandler.vala:139: %s", _tmp6_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (newpath);
			_g_object_unref0 (old);
			return result;
		}
		__finally0:
		_g_object_unref0 (newpath);
		_g_object_unref0 (old);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	} else {
		result = FALSE;
		_g_object_unref0 (newpath);
		_g_object_unref0 (old);
		return result;
	}
}

ScratchServicesFileHandler*
scratch_services_file_handler_construct (GType object_type)
{
	ScratchServicesFileHandler * self = NULL;
	self = (ScratchServicesFileHandler*) g_object_new (object_type, NULL);
	return self;
}

ScratchServicesFileHandler*
scratch_services_file_handler_new (void)
{
	return scratch_services_file_handler_construct (SCRATCH_SERVICES_TYPE_FILE_HANDLER);
}

static void
scratch_services_file_handler_class_init (ScratchServicesFileHandlerClass * klass,
                                          gpointer klass_data)
{
	scratch_services_file_handler_parent_class = g_type_class_peek_parent (klass);
}

static void
scratch_services_file_handler_instance_init (ScratchServicesFileHandler * self,
                                             gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
scratch_services_file_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesFileHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_file_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesFileHandler), 0, (GInstanceInitFunc) scratch_services_file_handler_instance_init, NULL };
	GType scratch_services_file_handler_type_id;
	scratch_services_file_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchServicesFileHandler", &g_define_type_info, 0);
	return scratch_services_file_handler_type_id;
}

GType
scratch_services_file_handler_get_type (void)
{
	static gsize scratch_services_file_handler_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_file_handler_type_id__once)) {
		GType scratch_services_file_handler_type_id;
		scratch_services_file_handler_type_id = scratch_services_file_handler_get_type_once ();
		g_once_init_leave (&scratch_services_file_handler_type_id__once, scratch_services_file_handler_type_id);
	}
	return scratch_services_file_handler_type_id__once;
}

