// Code generated by tools/cmd/genjwa/main.go. DO NOT EDIT.

package jwa

import (
	"fmt"
	"sort"
	"sync"
)

// ContentEncryptionAlgorithm represents the various encryption algorithms as described in https://tools.ietf.org/html/rfc7518#section-5
type ContentEncryptionAlgorithm string

// Supported values for ContentEncryptionAlgorithm
const (
	A128CBC_HS256 ContentEncryptionAlgorithm = "A128CBC-HS256" // AES-CBC + HMAC-SHA256 (128)
	A128GCM       ContentEncryptionAlgorithm = "A128GCM"       // AES-GCM (128)
	A192CBC_HS384 ContentEncryptionAlgorithm = "A192CBC-HS384" // AES-CBC + HMAC-SHA384 (192)
	A192GCM       ContentEncryptionAlgorithm = "A192GCM"       // AES-GCM (192)
	A256CBC_HS512 ContentEncryptionAlgorithm = "A256CBC-HS512" // AES-CBC + HMAC-SHA512 (256)
	A256GCM       ContentEncryptionAlgorithm = "A256GCM"       // AES-GCM (256)
)

var muContentEncryptionAlgorithms sync.RWMutex
var allContentEncryptionAlgorithms map[ContentEncryptionAlgorithm]struct{}
var listContentEncryptionAlgorithm []ContentEncryptionAlgorithm

func init() {
	muContentEncryptionAlgorithms.Lock()
	defer muContentEncryptionAlgorithms.Unlock()
	allContentEncryptionAlgorithms = make(map[ContentEncryptionAlgorithm]struct{})
	allContentEncryptionAlgorithms[A128CBC_HS256] = struct{}{}
	allContentEncryptionAlgorithms[A128GCM] = struct{}{}
	allContentEncryptionAlgorithms[A192CBC_HS384] = struct{}{}
	allContentEncryptionAlgorithms[A192GCM] = struct{}{}
	allContentEncryptionAlgorithms[A256CBC_HS512] = struct{}{}
	allContentEncryptionAlgorithms[A256GCM] = struct{}{}
	rebuildContentEncryptionAlgorithm()
}

// RegisterContentEncryptionAlgorithm registers a new ContentEncryptionAlgorithm so that the jwx can properly handle the new value.
// Duplicates will silently be ignored
func RegisterContentEncryptionAlgorithm(v ContentEncryptionAlgorithm) {
	muContentEncryptionAlgorithms.Lock()
	defer muContentEncryptionAlgorithms.Unlock()
	if _, ok := allContentEncryptionAlgorithms[v]; !ok {
		allContentEncryptionAlgorithms[v] = struct{}{}
		rebuildContentEncryptionAlgorithm()
	}
}

// UnregisterContentEncryptionAlgorithm unregisters a ContentEncryptionAlgorithm from its known database.
// Non-existent entries will silently be ignored
func UnregisterContentEncryptionAlgorithm(v ContentEncryptionAlgorithm) {
	muContentEncryptionAlgorithms.Lock()
	defer muContentEncryptionAlgorithms.Unlock()
	if _, ok := allContentEncryptionAlgorithms[v]; ok {
		delete(allContentEncryptionAlgorithms, v)
		rebuildContentEncryptionAlgorithm()
	}
}

func rebuildContentEncryptionAlgorithm() {
	listContentEncryptionAlgorithm = make([]ContentEncryptionAlgorithm, 0, len(allContentEncryptionAlgorithms))
	for v := range allContentEncryptionAlgorithms {
		listContentEncryptionAlgorithm = append(listContentEncryptionAlgorithm, v)
	}
	sort.Slice(listContentEncryptionAlgorithm, func(i, j int) bool {
		return string(listContentEncryptionAlgorithm[i]) < string(listContentEncryptionAlgorithm[j])
	})
}

// ContentEncryptionAlgorithms returns a list of all available values for ContentEncryptionAlgorithm
func ContentEncryptionAlgorithms() []ContentEncryptionAlgorithm {
	muContentEncryptionAlgorithms.RLock()
	defer muContentEncryptionAlgorithms.RUnlock()
	return listContentEncryptionAlgorithm
}

// Accept is used when conversion from values given by
// outside sources (such as JSON payloads) is required
func (v *ContentEncryptionAlgorithm) Accept(value interface{}) error {
	var tmp ContentEncryptionAlgorithm
	if x, ok := value.(ContentEncryptionAlgorithm); ok {
		tmp = x
	} else {
		var s string
		switch x := value.(type) {
		case fmt.Stringer:
			s = x.String()
		case string:
			s = x
		default:
			return fmt.Errorf(`invalid type for jwa.ContentEncryptionAlgorithm: %T`, value)
		}
		tmp = ContentEncryptionAlgorithm(s)
	}
	if _, ok := allContentEncryptionAlgorithms[tmp]; !ok {
		return fmt.Errorf(`invalid jwa.ContentEncryptionAlgorithm value`)
	}

	*v = tmp
	return nil
}

// String returns the string representation of a ContentEncryptionAlgorithm
func (v ContentEncryptionAlgorithm) String() string {
	return string(v)
}
