// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "iCalendar-valtypes.hxx"

namespace icalendar_2_0
{
  // CalAddressType
  //


  // DateTimeType
  //


  // UTCDateTimeType
  //


  // DurationValueType
  //


  // PeriodType
  //

  const PeriodType::start_type& PeriodType::
  start () const
  {
    return this->start_.get ();
  }

  PeriodType::start_type& PeriodType::
  start ()
  {
    return this->start_.get ();
  }

  void PeriodType::
  start (const start_type& x)
  {
    this->start_.set (x);
  }

  void PeriodType::
  start (::std::unique_ptr< start_type > x)
  {
    this->start_.set (std::move (x));
  }

  const PeriodType::end_optional& PeriodType::
  end () const
  {
    return this->end_;
  }

  PeriodType::end_optional& PeriodType::
  end ()
  {
    return this->end_;
  }

  void PeriodType::
  end (const end_type& x)
  {
    this->end_.set (x);
  }

  void PeriodType::
  end (const end_optional& x)
  {
    this->end_ = x;
  }

  void PeriodType::
  end (::std::unique_ptr< end_type > x)
  {
    this->end_.set (std::move (x));
  }

  const PeriodType::duration_optional& PeriodType::
  duration () const
  {
    return this->duration_;
  }

  PeriodType::duration_optional& PeriodType::
  duration ()
  {
    return this->duration_;
  }

  void PeriodType::
  duration (const duration_type& x)
  {
    this->duration_.set (x);
  }

  void PeriodType::
  duration (const duration_optional& x)
  {
    this->duration_ = x;
  }

  void PeriodType::
  duration (::std::unique_ptr< duration_type > x)
  {
    this->duration_.set (std::move (x));
  }


  // RecurType
  //

  const RecurType::freq_type& RecurType::
  freq () const
  {
    return this->freq_.get ();
  }

  RecurType::freq_type& RecurType::
  freq ()
  {
    return this->freq_.get ();
  }

  void RecurType::
  freq (const freq_type& x)
  {
    this->freq_.set (x);
  }

  void RecurType::
  freq (::std::unique_ptr< freq_type > x)
  {
    this->freq_.set (std::move (x));
  }

  const RecurType::until_optional& RecurType::
  until () const
  {
    return this->until_;
  }

  RecurType::until_optional& RecurType::
  until ()
  {
    return this->until_;
  }

  void RecurType::
  until (const until_type& x)
  {
    this->until_.set (x);
  }

  void RecurType::
  until (const until_optional& x)
  {
    this->until_ = x;
  }

  void RecurType::
  until (::std::unique_ptr< until_type > x)
  {
    this->until_.set (std::move (x));
  }

  const RecurType::count_optional& RecurType::
  count () const
  {
    return this->count_;
  }

  RecurType::count_optional& RecurType::
  count ()
  {
    return this->count_;
  }

  void RecurType::
  count (const count_type& x)
  {
    this->count_.set (x);
  }

  void RecurType::
  count (const count_optional& x)
  {
    this->count_ = x;
  }

  const RecurType::interval_optional& RecurType::
  interval () const
  {
    return this->interval_;
  }

  RecurType::interval_optional& RecurType::
  interval ()
  {
    return this->interval_;
  }

  void RecurType::
  interval (const interval_type& x)
  {
    this->interval_.set (x);
  }

  void RecurType::
  interval (const interval_optional& x)
  {
    this->interval_ = x;
  }

  const RecurType::bysecond_sequence& RecurType::
  bysecond () const
  {
    return this->bysecond_;
  }

  RecurType::bysecond_sequence& RecurType::
  bysecond ()
  {
    return this->bysecond_;
  }

  void RecurType::
  bysecond (const bysecond_sequence& s)
  {
    this->bysecond_ = s;
  }

  const RecurType::byminute_sequence& RecurType::
  byminute () const
  {
    return this->byminute_;
  }

  RecurType::byminute_sequence& RecurType::
  byminute ()
  {
    return this->byminute_;
  }

  void RecurType::
  byminute (const byminute_sequence& s)
  {
    this->byminute_ = s;
  }

  const RecurType::byhour_sequence& RecurType::
  byhour () const
  {
    return this->byhour_;
  }

  RecurType::byhour_sequence& RecurType::
  byhour ()
  {
    return this->byhour_;
  }

  void RecurType::
  byhour (const byhour_sequence& s)
  {
    this->byhour_ = s;
  }

  const RecurType::byday_sequence& RecurType::
  byday () const
  {
    return this->byday_;
  }

  RecurType::byday_sequence& RecurType::
  byday ()
  {
    return this->byday_;
  }

  void RecurType::
  byday (const byday_sequence& s)
  {
    this->byday_ = s;
  }

  const RecurType::byyearday_sequence& RecurType::
  byyearday () const
  {
    return this->byyearday_;
  }

  RecurType::byyearday_sequence& RecurType::
  byyearday ()
  {
    return this->byyearday_;
  }

  void RecurType::
  byyearday (const byyearday_sequence& s)
  {
    this->byyearday_ = s;
  }

  const RecurType::bymonthday_sequence& RecurType::
  bymonthday () const
  {
    return this->bymonthday_;
  }

  RecurType::bymonthday_sequence& RecurType::
  bymonthday ()
  {
    return this->bymonthday_;
  }

  void RecurType::
  bymonthday (const bymonthday_sequence& s)
  {
    this->bymonthday_ = s;
  }

  const RecurType::byweekno_sequence& RecurType::
  byweekno () const
  {
    return this->byweekno_;
  }

  RecurType::byweekno_sequence& RecurType::
  byweekno ()
  {
    return this->byweekno_;
  }

  void RecurType::
  byweekno (const byweekno_sequence& s)
  {
    this->byweekno_ = s;
  }

  const RecurType::bymonth_sequence& RecurType::
  bymonth () const
  {
    return this->bymonth_;
  }

  RecurType::bymonth_sequence& RecurType::
  bymonth ()
  {
    return this->bymonth_;
  }

  void RecurType::
  bymonth (const bymonth_sequence& s)
  {
    this->bymonth_ = s;
  }

  const RecurType::bysetpos_sequence& RecurType::
  bysetpos () const
  {
    return this->bysetpos_;
  }

  RecurType::bysetpos_sequence& RecurType::
  bysetpos ()
  {
    return this->bysetpos_;
  }

  void RecurType::
  bysetpos (const bysetpos_sequence& s)
  {
    this->bysetpos_ = s;
  }

  const RecurType::wkst_optional& RecurType::
  wkst () const
  {
    return this->wkst_;
  }

  RecurType::wkst_optional& RecurType::
  wkst ()
  {
    return this->wkst_;
  }

  void RecurType::
  wkst (const wkst_type& x)
  {
    this->wkst_.set (x);
  }

  void RecurType::
  wkst (const wkst_optional& x)
  {
    this->wkst_ = x;
  }

  void RecurType::
  wkst (::std::unique_ptr< wkst_type > x)
  {
    this->wkst_.set (std::move (x));
  }


  // FreqRecurType
  //

  FreqRecurType::
  FreqRecurType (value v)
  : ::xml_schema::token (_xsd_FreqRecurType_literals_[v])
  {
  }

  FreqRecurType::
  FreqRecurType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  FreqRecurType::
  FreqRecurType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  FreqRecurType::
  FreqRecurType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  FreqRecurType::
  FreqRecurType (const FreqRecurType& v,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  FreqRecurType& FreqRecurType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_FreqRecurType_literals_[v]);

    return *this;
  }


  // UntilRecurType
  //

  const UntilRecurType::date_optional& UntilRecurType::
  date () const
  {
    return this->date_;
  }

  UntilRecurType::date_optional& UntilRecurType::
  date ()
  {
    return this->date_;
  }

  void UntilRecurType::
  date (const date_type& x)
  {
    this->date_.set (x);
  }

  void UntilRecurType::
  date (const date_optional& x)
  {
    this->date_ = x;
  }

  void UntilRecurType::
  date (::std::unique_ptr< date_type > x)
  {
    this->date_.set (std::move (x));
  }

  const UntilRecurType::date_time_optional& UntilRecurType::
  date_time () const
  {
    return this->date_time_;
  }

  UntilRecurType::date_time_optional& UntilRecurType::
  date_time ()
  {
    return this->date_time_;
  }

  void UntilRecurType::
  date_time (const date_time_type& x)
  {
    this->date_time_.set (x);
  }

  void UntilRecurType::
  date_time (const date_time_optional& x)
  {
    this->date_time_ = x;
  }

  void UntilRecurType::
  date_time (::std::unique_ptr< date_time_type > x)
  {
    this->date_time_.set (std::move (x));
  }


  // WeekdayRecurType
  //

  WeekdayRecurType::
  WeekdayRecurType (value v)
  : ::xml_schema::token (_xsd_WeekdayRecurType_literals_[v])
  {
  }

  WeekdayRecurType::
  WeekdayRecurType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  WeekdayRecurType::
  WeekdayRecurType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  WeekdayRecurType::
  WeekdayRecurType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  WeekdayRecurType::
  WeekdayRecurType (const WeekdayRecurType& v,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  WeekdayRecurType& WeekdayRecurType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_WeekdayRecurType_literals_[v]);

    return *this;
  }


  // BysecondRecurType
  //


  // ByminuteRecurType
  //


  // ByhourRecurType
  //


  // BydayRecurType
  //


  // ByyeardayRecurType
  //


  // BymonthdayRecurType
  //


  // ByweeknoRecurType
  //


  // BymonthRecurType
  //


  // UriType
  //


  // UtcOffsetType
  //
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

#include <xsd/cxx/tree/type-factory-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_factory_plate< 0, char >
  type_factory_plate_init;
}

namespace icalendar_2_0
{
  // CalAddressType
  //

  CalAddressType::
  CalAddressType ()
  : ::xml_schema::string ()
  {
  }

  CalAddressType::
  CalAddressType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  CalAddressType::
  CalAddressType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  CalAddressType::
  CalAddressType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  CalAddressType::
  CalAddressType (const CalAddressType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  CalAddressType::
  CalAddressType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  CalAddressType::
  CalAddressType (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  CalAddressType::
  CalAddressType (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  CalAddressType* CalAddressType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CalAddressType (*this, f, c);
  }

  CalAddressType::
  ~CalAddressType ()
  {
  }

  // DateTimeType
  //

  DateTimeType::
  DateTimeType (const ::xml_schema::date_time& _xsd_date_time_base)
  : ::xml_schema::date_time (_xsd_date_time_base)
  {
  }

  DateTimeType::
  DateTimeType (const DateTimeType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::date_time (x, f, c)
  {
  }

  DateTimeType::
  DateTimeType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::date_time (e, f, c)
  {
  }

  DateTimeType::
  DateTimeType (const ::xercesc::DOMAttr& a,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::date_time (a, f, c)
  {
  }

  DateTimeType::
  DateTimeType (const ::std::string& s,
                const ::xercesc::DOMElement* e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::date_time (s, e, f, c)
  {
  }

  DateTimeType* DateTimeType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DateTimeType (*this, f, c);
  }

  DateTimeType::
  ~DateTimeType ()
  {
  }

  // UTCDateTimeType
  //

  UTCDateTimeType::
  UTCDateTimeType (const ::xml_schema::date_time& _xsd_date_time_base)
  : ::xml_schema::date_time (_xsd_date_time_base)
  {
  }

  UTCDateTimeType::
  UTCDateTimeType (const UTCDateTimeType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::date_time (x, f, c)
  {
  }

  UTCDateTimeType::
  UTCDateTimeType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::date_time (e, f, c)
  {
  }

  UTCDateTimeType::
  UTCDateTimeType (const ::xercesc::DOMAttr& a,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::date_time (a, f, c)
  {
  }

  UTCDateTimeType::
  UTCDateTimeType (const ::std::string& s,
                   const ::xercesc::DOMElement* e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::date_time (s, e, f, c)
  {
  }

  UTCDateTimeType* UTCDateTimeType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UTCDateTimeType (*this, f, c);
  }

  UTCDateTimeType::
  ~UTCDateTimeType ()
  {
  }

  // DurationValueType
  //

  DurationValueType::
  DurationValueType ()
  : ::xml_schema::string ()
  {
  }

  DurationValueType::
  DurationValueType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DurationValueType::
  DurationValueType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DurationValueType::
  DurationValueType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DurationValueType::
  DurationValueType (const DurationValueType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  DurationValueType::
  DurationValueType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  DurationValueType::
  DurationValueType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  DurationValueType::
  DurationValueType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  DurationValueType* DurationValueType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DurationValueType (*this, f, c);
  }

  DurationValueType::
  ~DurationValueType ()
  {
  }

  // PeriodType
  //

  PeriodType::
  PeriodType (const start_type& start)
  : ::xml_schema::type (),
    start_ (start, this),
    end_ (this),
    duration_ (this)
  {
  }

  PeriodType::
  PeriodType (const PeriodType& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    start_ (x.start_, f, this),
    end_ (x.end_, f, this),
    duration_ (x.duration_, f, this)
  {
  }

  PeriodType::
  PeriodType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    start_ (this),
    end_ (this),
    duration_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void PeriodType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // start
      //
      if (n.name () == "start" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< start_type > r (
          start_traits::create (i, f, this));

        if (!start_.present ())
        {
          this->start_.set (::std::move (r));
          continue;
        }
      }

      // end
      //
      if (n.name () == "end" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< end_type > r (
          end_traits::create (i, f, this));

        if (!this->end_)
        {
          this->end_.set (::std::move (r));
          continue;
        }
      }

      // duration
      //
      if (n.name () == "duration" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< duration_type > r (
          duration_traits::create (i, f, this));

        if (!this->duration_)
        {
          this->duration_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!start_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "start",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  PeriodType* PeriodType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class PeriodType (*this, f, c);
  }

  PeriodType& PeriodType::
  operator= (const PeriodType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->start_ = x.start_;
      this->end_ = x.end_;
      this->duration_ = x.duration_;
    }

    return *this;
  }

  PeriodType::
  ~PeriodType ()
  {
  }

  // RecurType
  //

  RecurType::
  RecurType (const freq_type& freq)
  : ::xml_schema::type (),
    freq_ (freq, this),
    until_ (this),
    count_ (this),
    interval_ (this),
    bysecond_ (this),
    byminute_ (this),
    byhour_ (this),
    byday_ (this),
    byyearday_ (this),
    bymonthday_ (this),
    byweekno_ (this),
    bymonth_ (this),
    bysetpos_ (this),
    wkst_ (this)
  {
  }

  RecurType::
  RecurType (const RecurType& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    freq_ (x.freq_, f, this),
    until_ (x.until_, f, this),
    count_ (x.count_, f, this),
    interval_ (x.interval_, f, this),
    bysecond_ (x.bysecond_, f, this),
    byminute_ (x.byminute_, f, this),
    byhour_ (x.byhour_, f, this),
    byday_ (x.byday_, f, this),
    byyearday_ (x.byyearday_, f, this),
    bymonthday_ (x.bymonthday_, f, this),
    byweekno_ (x.byweekno_, f, this),
    bymonth_ (x.bymonth_, f, this),
    bysetpos_ (x.bysetpos_, f, this),
    wkst_ (x.wkst_, f, this)
  {
  }

  RecurType::
  RecurType (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    freq_ (this),
    until_ (this),
    count_ (this),
    interval_ (this),
    bysecond_ (this),
    byminute_ (this),
    byhour_ (this),
    byday_ (this),
    byyearday_ (this),
    bymonthday_ (this),
    byweekno_ (this),
    bymonth_ (this),
    bysetpos_ (this),
    wkst_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void RecurType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // freq
      //
      if (n.name () == "freq" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< freq_type > r (
          freq_traits::create (i, f, this));

        if (!freq_.present ())
        {
          this->freq_.set (::std::move (r));
          continue;
        }
      }

      // until
      //
      if (n.name () == "until" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< until_type > r (
          until_traits::create (i, f, this));

        if (!this->until_)
        {
          this->until_.set (::std::move (r));
          continue;
        }
      }

      // count
      //
      if (n.name () == "count" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        if (!this->count_)
        {
          this->count_.set (count_traits::create (i, f, this));
          continue;
        }
      }

      // interval
      //
      if (n.name () == "interval" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        if (!this->interval_)
        {
          this->interval_.set (interval_traits::create (i, f, this));
          continue;
        }
      }

      // bysecond
      //
      if (n.name () == "bysecond" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< bysecond_type > r (
          bysecond_traits::create (i, f, this));

        this->bysecond_.push_back (::std::move (r));
        continue;
      }

      // byminute
      //
      if (n.name () == "byminute" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< byminute_type > r (
          byminute_traits::create (i, f, this));

        this->byminute_.push_back (::std::move (r));
        continue;
      }

      // byhour
      //
      if (n.name () == "byhour" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< byhour_type > r (
          byhour_traits::create (i, f, this));

        this->byhour_.push_back (::std::move (r));
        continue;
      }

      // byday
      //
      if (n.name () == "byday" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< byday_type > r (
          byday_traits::create (i, f, this));

        this->byday_.push_back (::std::move (r));
        continue;
      }

      // byyearday
      //
      if (n.name () == "byyearday" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< byyearday_type > r (
          byyearday_traits::create (i, f, this));

        this->byyearday_.push_back (::std::move (r));
        continue;
      }

      // bymonthday
      //
      if (n.name () == "bymonthday" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< bymonthday_type > r (
          bymonthday_traits::create (i, f, this));

        this->bymonthday_.push_back (::std::move (r));
        continue;
      }

      // byweekno
      //
      if (n.name () == "byweekno" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< byweekno_type > r (
          byweekno_traits::create (i, f, this));

        this->byweekno_.push_back (::std::move (r));
        continue;
      }

      // bymonth
      //
      if (n.name () == "bymonth" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< bymonth_type > r (
          bymonth_traits::create (i, f, this));

        this->bymonth_.push_back (::std::move (r));
        continue;
      }

      // bysetpos
      //
      if (n.name () == "bysetpos" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        this->bysetpos_.push_back (bysetpos_traits::create (i, f, this));
        continue;
      }

      // wkst
      //
      if (n.name () == "wkst" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< wkst_type > r (
          wkst_traits::create (i, f, this));

        if (!this->wkst_)
        {
          this->wkst_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!freq_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "freq",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  RecurType* RecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RecurType (*this, f, c);
  }

  RecurType& RecurType::
  operator= (const RecurType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->freq_ = x.freq_;
      this->until_ = x.until_;
      this->count_ = x.count_;
      this->interval_ = x.interval_;
      this->bysecond_ = x.bysecond_;
      this->byminute_ = x.byminute_;
      this->byhour_ = x.byhour_;
      this->byday_ = x.byday_;
      this->byyearday_ = x.byyearday_;
      this->bymonthday_ = x.bymonthday_;
      this->byweekno_ = x.byweekno_;
      this->bymonth_ = x.bymonth_;
      this->bysetpos_ = x.bysetpos_;
      this->wkst_ = x.wkst_;
    }

    return *this;
  }

  RecurType::
  ~RecurType ()
  {
  }

  // FreqRecurType
  //

  FreqRecurType::
  FreqRecurType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_FreqRecurType_convert ();
  }

  FreqRecurType::
  FreqRecurType (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_FreqRecurType_convert ();
  }

  FreqRecurType::
  FreqRecurType (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_FreqRecurType_convert ();
  }

  FreqRecurType* FreqRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FreqRecurType (*this, f, c);
  }

  FreqRecurType::value FreqRecurType::
  _xsd_FreqRecurType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_FreqRecurType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_FreqRecurType_indexes_,
                      _xsd_FreqRecurType_indexes_ + 7,
                      *this,
                      c));

    if (i == _xsd_FreqRecurType_indexes_ + 7 || _xsd_FreqRecurType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const FreqRecurType::
  _xsd_FreqRecurType_literals_[7] =
  {
    "SECONDLY",
    "MINUTELY",
    "HOURLY",
    "DAILY",
    "WEEKLY",
    "MONTHLY",
    "YEARLY"
  };

  const FreqRecurType::value FreqRecurType::
  _xsd_FreqRecurType_indexes_[7] =
  {
    ::icalendar_2_0::FreqRecurType::DAILY,
    ::icalendar_2_0::FreqRecurType::HOURLY,
    ::icalendar_2_0::FreqRecurType::MINUTELY,
    ::icalendar_2_0::FreqRecurType::MONTHLY,
    ::icalendar_2_0::FreqRecurType::SECONDLY,
    ::icalendar_2_0::FreqRecurType::WEEKLY,
    ::icalendar_2_0::FreqRecurType::YEARLY
  };

  // UntilRecurType
  //

  UntilRecurType::
  UntilRecurType ()
  : ::xml_schema::type (),
    date_ (this),
    date_time_ (this)
  {
  }

  UntilRecurType::
  UntilRecurType (const UntilRecurType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    date_ (x.date_, f, this),
    date_time_ (x.date_time_, f, this)
  {
  }

  UntilRecurType::
  UntilRecurType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    date_ (this),
    date_time_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void UntilRecurType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // date
      //
      if (n.name () == "date" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_type > r (
          date_traits::create (i, f, this));

        if (!this->date_)
        {
          this->date_.set (::std::move (r));
          continue;
        }
      }

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        if (!this->date_time_)
        {
          this->date_time_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  UntilRecurType* UntilRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UntilRecurType (*this, f, c);
  }

  UntilRecurType& UntilRecurType::
  operator= (const UntilRecurType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->date_ = x.date_;
      this->date_time_ = x.date_time_;
    }

    return *this;
  }

  UntilRecurType::
  ~UntilRecurType ()
  {
  }

  // WeekdayRecurType
  //

  WeekdayRecurType::
  WeekdayRecurType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_WeekdayRecurType_convert ();
  }

  WeekdayRecurType::
  WeekdayRecurType (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_WeekdayRecurType_convert ();
  }

  WeekdayRecurType::
  WeekdayRecurType (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_WeekdayRecurType_convert ();
  }

  WeekdayRecurType* WeekdayRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class WeekdayRecurType (*this, f, c);
  }

  WeekdayRecurType::value WeekdayRecurType::
  _xsd_WeekdayRecurType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_WeekdayRecurType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_WeekdayRecurType_indexes_,
                      _xsd_WeekdayRecurType_indexes_ + 7,
                      *this,
                      c));

    if (i == _xsd_WeekdayRecurType_indexes_ + 7 || _xsd_WeekdayRecurType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const WeekdayRecurType::
  _xsd_WeekdayRecurType_literals_[7] =
  {
    "SU",
    "MO",
    "TU",
    "WE",
    "TH",
    "FR",
    "SA"
  };

  const WeekdayRecurType::value WeekdayRecurType::
  _xsd_WeekdayRecurType_indexes_[7] =
  {
    ::icalendar_2_0::WeekdayRecurType::FR,
    ::icalendar_2_0::WeekdayRecurType::MO,
    ::icalendar_2_0::WeekdayRecurType::SA,
    ::icalendar_2_0::WeekdayRecurType::SU,
    ::icalendar_2_0::WeekdayRecurType::TH,
    ::icalendar_2_0::WeekdayRecurType::TU,
    ::icalendar_2_0::WeekdayRecurType::WE
  };

  // BysecondRecurType
  //

  BysecondRecurType::
  BysecondRecurType (const ::xml_schema::non_negative_integer& _xsd_non_negative_integer_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (_xsd_non_negative_integer_base)
  {
  }

  BysecondRecurType::
  BysecondRecurType (const BysecondRecurType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  BysecondRecurType::
  BysecondRecurType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  BysecondRecurType::
  BysecondRecurType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  BysecondRecurType::
  BysecondRecurType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  BysecondRecurType* BysecondRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class BysecondRecurType (*this, f, c);
  }

  BysecondRecurType::
  ~BysecondRecurType ()
  {
  }

  // ByminuteRecurType
  //

  ByminuteRecurType::
  ByminuteRecurType (const ::xml_schema::non_negative_integer& _xsd_non_negative_integer_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (_xsd_non_negative_integer_base)
  {
  }

  ByminuteRecurType::
  ByminuteRecurType (const ByminuteRecurType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  ByminuteRecurType::
  ByminuteRecurType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  ByminuteRecurType::
  ByminuteRecurType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  ByminuteRecurType::
  ByminuteRecurType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  ByminuteRecurType* ByminuteRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ByminuteRecurType (*this, f, c);
  }

  ByminuteRecurType::
  ~ByminuteRecurType ()
  {
  }

  // ByhourRecurType
  //

  ByhourRecurType::
  ByhourRecurType (const ::xml_schema::non_negative_integer& _xsd_non_negative_integer_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (_xsd_non_negative_integer_base)
  {
  }

  ByhourRecurType::
  ByhourRecurType (const ByhourRecurType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  ByhourRecurType::
  ByhourRecurType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  ByhourRecurType::
  ByhourRecurType (const ::xercesc::DOMAttr& a,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  ByhourRecurType::
  ByhourRecurType (const ::std::string& s,
                   const ::xercesc::DOMElement* e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  ByhourRecurType* ByhourRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ByhourRecurType (*this, f, c);
  }

  ByhourRecurType::
  ~ByhourRecurType ()
  {
  }

  // BydayRecurType
  //

  BydayRecurType::
  BydayRecurType ()
  : ::xml_schema::string ()
  {
  }

  BydayRecurType::
  BydayRecurType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  BydayRecurType::
  BydayRecurType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  BydayRecurType::
  BydayRecurType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  BydayRecurType::
  BydayRecurType (const BydayRecurType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  BydayRecurType::
  BydayRecurType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  BydayRecurType::
  BydayRecurType (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  BydayRecurType::
  BydayRecurType (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  BydayRecurType* BydayRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class BydayRecurType (*this, f, c);
  }

  BydayRecurType::
  ~BydayRecurType ()
  {
  }

  // ByyeardayRecurType
  //

  ByyeardayRecurType::
  ByyeardayRecurType (const ::xml_schema::integer& _xsd_integer_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (_xsd_integer_base)
  {
  }

  ByyeardayRecurType::
  ByyeardayRecurType (const ByyeardayRecurType& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  ByyeardayRecurType::
  ByyeardayRecurType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  ByyeardayRecurType::
  ByyeardayRecurType (const ::xercesc::DOMAttr& a,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  ByyeardayRecurType::
  ByyeardayRecurType (const ::std::string& s,
                      const ::xercesc::DOMElement* e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  ByyeardayRecurType* ByyeardayRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ByyeardayRecurType (*this, f, c);
  }

  ByyeardayRecurType::
  ~ByyeardayRecurType ()
  {
  }

  // BymonthdayRecurType
  //

  BymonthdayRecurType::
  BymonthdayRecurType (const ::xml_schema::integer& _xsd_integer_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (_xsd_integer_base)
  {
  }

  BymonthdayRecurType::
  BymonthdayRecurType (const BymonthdayRecurType& x,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  BymonthdayRecurType::
  BymonthdayRecurType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  BymonthdayRecurType::
  BymonthdayRecurType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  BymonthdayRecurType::
  BymonthdayRecurType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  BymonthdayRecurType* BymonthdayRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class BymonthdayRecurType (*this, f, c);
  }

  BymonthdayRecurType::
  ~BymonthdayRecurType ()
  {
  }

  // ByweeknoRecurType
  //

  ByweeknoRecurType::
  ByweeknoRecurType (const ::xml_schema::integer& _xsd_integer_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (_xsd_integer_base)
  {
  }

  ByweeknoRecurType::
  ByweeknoRecurType (const ByweeknoRecurType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  ByweeknoRecurType::
  ByweeknoRecurType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  ByweeknoRecurType::
  ByweeknoRecurType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  ByweeknoRecurType::
  ByweeknoRecurType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  ByweeknoRecurType* ByweeknoRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ByweeknoRecurType (*this, f, c);
  }

  ByweeknoRecurType::
  ~ByweeknoRecurType ()
  {
  }

  // BymonthRecurType
  //

  BymonthRecurType::
  BymonthRecurType (const ::xml_schema::integer& _xsd_integer_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (_xsd_integer_base)
  {
  }

  BymonthRecurType::
  BymonthRecurType (const BymonthRecurType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  BymonthRecurType::
  BymonthRecurType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  BymonthRecurType::
  BymonthRecurType (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  BymonthRecurType::
  BymonthRecurType (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  BymonthRecurType* BymonthRecurType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class BymonthRecurType (*this, f, c);
  }

  BymonthRecurType::
  ~BymonthRecurType ()
  {
  }

  // UriType
  //

  UriType::
  UriType ()
  : ::xml_schema::string ()
  {
  }

  UriType::
  UriType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  UriType::
  UriType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  UriType::
  UriType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  UriType::
  UriType (const UriType& x,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  UriType::
  UriType (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  UriType::
  UriType (const ::xercesc::DOMAttr& a,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  UriType::
  UriType (const ::std::string& s,
           const ::xercesc::DOMElement* e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  UriType* UriType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UriType (*this, f, c);
  }

  UriType::
  ~UriType ()
  {
  }

  // UtcOffsetType
  //

  UtcOffsetType::
  UtcOffsetType ()
  : ::xml_schema::string ()
  {
  }

  UtcOffsetType::
  UtcOffsetType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  UtcOffsetType::
  UtcOffsetType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  UtcOffsetType::
  UtcOffsetType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  UtcOffsetType::
  UtcOffsetType (const UtcOffsetType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  UtcOffsetType::
  UtcOffsetType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  UtcOffsetType::
  UtcOffsetType (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  UtcOffsetType::
  UtcOffsetType (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  UtcOffsetType* UtcOffsetType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UtcOffsetType (*this, f, c);
  }

  UtcOffsetType::
  ~UtcOffsetType ()
  {
  }
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace icalendar_2_0
{
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

#include <xsd/cxx/tree/type-serializer-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_serializer_plate< 0, char >
  type_serializer_plate_init;
}

namespace icalendar_2_0
{
  void
  operator<< (::xercesc::DOMElement& e, const CalAddressType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const CalAddressType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const CalAddressType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const DateTimeType& i)
  {
    e << static_cast< const ::xml_schema::date_time& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const DateTimeType& i)
  {
    a << static_cast< const ::xml_schema::date_time& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const DateTimeType& i)
  {
    l << static_cast< const ::xml_schema::date_time& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const UTCDateTimeType& i)
  {
    e << static_cast< const ::xml_schema::date_time& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const UTCDateTimeType& i)
  {
    a << static_cast< const ::xml_schema::date_time& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const UTCDateTimeType& i)
  {
    l << static_cast< const ::xml_schema::date_time& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const DurationValueType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const DurationValueType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const DurationValueType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const PeriodType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // start
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "start",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.start ();
    }

    // end
    //
    if (i.end ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "end",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.end ();
    }

    // duration
    //
    if (i.duration ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "duration",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.duration ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const RecurType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // freq
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "freq",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.freq ();
    }

    // until
    //
    if (i.until ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "until",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.until ();
    }

    // count
    //
    if (i.count ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "count",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.count ();
    }

    // interval
    //
    if (i.interval ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "interval",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.interval ();
    }

    // bysecond
    //
    for (RecurType::bysecond_const_iterator
         b (i.bysecond ().begin ()), n (i.bysecond ().end ());
         b != n; ++b)
    {
      const RecurType::bysecond_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "bysecond",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // byminute
    //
    for (RecurType::byminute_const_iterator
         b (i.byminute ().begin ()), n (i.byminute ().end ());
         b != n; ++b)
    {
      const RecurType::byminute_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "byminute",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // byhour
    //
    for (RecurType::byhour_const_iterator
         b (i.byhour ().begin ()), n (i.byhour ().end ());
         b != n; ++b)
    {
      const RecurType::byhour_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "byhour",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // byday
    //
    for (RecurType::byday_const_iterator
         b (i.byday ().begin ()), n (i.byday ().end ());
         b != n; ++b)
    {
      const RecurType::byday_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "byday",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // byyearday
    //
    for (RecurType::byyearday_const_iterator
         b (i.byyearday ().begin ()), n (i.byyearday ().end ());
         b != n; ++b)
    {
      const RecurType::byyearday_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "byyearday",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // bymonthday
    //
    for (RecurType::bymonthday_const_iterator
         b (i.bymonthday ().begin ()), n (i.bymonthday ().end ());
         b != n; ++b)
    {
      const RecurType::bymonthday_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "bymonthday",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // byweekno
    //
    for (RecurType::byweekno_const_iterator
         b (i.byweekno ().begin ()), n (i.byweekno ().end ());
         b != n; ++b)
    {
      const RecurType::byweekno_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "byweekno",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // bymonth
    //
    for (RecurType::bymonth_const_iterator
         b (i.bymonth ().begin ()), n (i.bymonth ().end ());
         b != n; ++b)
    {
      const RecurType::bymonth_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "bymonth",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // bysetpos
    //
    for (RecurType::bysetpos_const_iterator
         b (i.bysetpos ().begin ()), n (i.bysetpos ().end ());
         b != n; ++b)
    {
      const RecurType::bysetpos_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "bysetpos",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }

    // wkst
    //
    if (i.wkst ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "wkst",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.wkst ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const FreqRecurType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const FreqRecurType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const FreqRecurType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const UntilRecurType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // date
    //
    if (i.date ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.date ();
    }

    // date-time
    //
    if (i.date_time ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << *i.date_time ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const WeekdayRecurType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const WeekdayRecurType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const WeekdayRecurType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const BysecondRecurType& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const BysecondRecurType& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const BysecondRecurType& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const ByminuteRecurType& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const ByminuteRecurType& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const ByminuteRecurType& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const ByhourRecurType& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const ByhourRecurType& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const ByhourRecurType& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::non_negative_integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const BydayRecurType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const BydayRecurType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const BydayRecurType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const ByyeardayRecurType& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const ByyeardayRecurType& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const ByyeardayRecurType& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const BymonthdayRecurType& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const BymonthdayRecurType& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const BymonthdayRecurType& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const ByweeknoRecurType& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const ByweeknoRecurType& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const ByweeknoRecurType& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const BymonthRecurType& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const BymonthRecurType& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const BymonthRecurType& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const UriType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const UriType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const UriType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const UtcOffsetType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const UtcOffsetType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const UtcOffsetType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

