/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-trigger.h"
#include "libical-glib-private.h"
#include "i-cal-duration.h"
#include "i-cal-time.h"

G_DEFINE_TYPE (ICalTrigger, i_cal_trigger, I_CAL_TYPE_OBJECT)

static void i_cal_trigger_class_init (G_GNUC_UNUSED ICalTriggerClass *klass)
{
}

static void i_cal_trigger_init (G_GNUC_UNUSED ICalTrigger *self)
{
}

/**
 * i_cal_trigger_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalTrigger *
i_cal_trigger_new_full (struct icaltriggertype native)
{
    ICalTrigger *object;
    struct icaltriggertype *clone;
    
    
    clone = g_new (struct icaltriggertype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_TRIGGER,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_trigger_new_from_int:
 * @reltime: An integer
 *
 * Creates a #ICalTrigger from integer.
 *
 * Returns: (transfer full): The newly created #ICalTrigger.
 *
 * Since: 1.0
 *
 **/
ICalTrigger *
i_cal_trigger_new_from_int (const gint reltime)
{
	return i_cal_trigger_new_full (icaltriggertype_from_int (reltime));
}

/**
 * i_cal_trigger_new_from_string:
 * @str: A string
 *
 * Creates a #ICalTrigger from a string.
 *
 * Returns: (transfer full): The newly created #ICalTrigger.
 *
 * Since: 1.0
 *
 **/
ICalTrigger *
i_cal_trigger_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_trigger_new_full (icaltriggertype_from_string (str));
}

/**
 * i_cal_trigger_is_null_trigger:
 * @tr: A #ICalTrigger
 *
 * Checks if a #ICalTrigger is a null trigger.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_trigger_is_null_trigger (ICalTrigger *tr)
{
	g_return_val_if_fail (I_CAL_IS_TRIGGER (tr), FALSE);

	return icaltriggertype_is_null_trigger (* (struct icaltriggertype *)i_cal_object_get_native (I_CAL_OBJECT (tr)));
}

/**
 * i_cal_trigger_is_bad_trigger:
 * @tr: A #ICalTrigger
 *
 * Checks if a #ICalTrigger is a bad trigger.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_trigger_is_bad_trigger (ICalTrigger *tr)
{
	g_return_val_if_fail (I_CAL_IS_TRIGGER (tr), FALSE);

	return icaltriggertype_is_bad_trigger (* (struct icaltriggertype *)i_cal_object_get_native (I_CAL_OBJECT (tr)));
}

/**
 * i_cal_trigger_get_time:
 * @trigger: The #ICalTrigger
 *
 * Gets the time from #ICalTrigger.
 *
 * Returns: (transfer full): The time of #ICalTrigger.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_trigger_get_time (ICalTrigger *trigger)
{
	g_return_val_if_fail (trigger != NULL && I_CAL_IS_TRIGGER (trigger), NULL);
	return i_cal_time_new_full (((struct icaltriggertype *)i_cal_object_get_native ((ICalObject *)trigger))->time);
}

/**
 * i_cal_trigger_set_time:
 * @trigger: The #ICalTrigger
 * @time: The time of #ICalTrigger
 *
 * Sets the time from #ICalTrigger.
 *
 * Since: 1.0
 *
 **/
void
i_cal_trigger_set_time (ICalTrigger *trigger, 
                        ICalTime *time)
{
	g_return_if_fail (trigger != NULL && I_CAL_IS_TRIGGER (trigger));
	g_return_if_fail (time != NULL && I_CAL_IS_TIME(time));
	((struct icaltriggertype *)i_cal_object_get_native ((ICalObject *)trigger))->time = *(struct icaltimetype *)i_cal_object_get_native ((ICalObject *)time);
}

/**
 * i_cal_trigger_get_duration:
 * @trigger: The #ICalTrigger
 *
 * Gets the duration from #ICalTrigger.
 *
 * Returns: (transfer full): The duration of #ICalTrigger.
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_trigger_get_duration (ICalTrigger *trigger)
{
	g_return_val_if_fail (trigger != NULL && I_CAL_IS_TRIGGER (trigger), NULL);
	return i_cal_duration_new_full (((struct icaltriggertype *)i_cal_object_get_native ((ICalObject *)trigger))->duration);
}

/**
 * i_cal_trigger_set_duration:
 * @trigger: The #ICalTrigger
 * @duration: The duration of #ICalTrigger
 *
 * Sets the duration from #ICalTrigger.
 *
 * Since: 1.0
 *
 **/
void
i_cal_trigger_set_duration (ICalTrigger *trigger, 
                            ICalDuration *duration)
{
	g_return_if_fail (trigger != NULL && I_CAL_IS_TRIGGER (trigger));
	g_return_if_fail (duration != NULL && I_CAL_IS_DURATION (duration));
	((struct icaltriggertype *)i_cal_object_get_native ((ICalObject *)trigger))->duration = *(struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration);
}
