/*
 * Copyright (C) 2025 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/source/xe3_core/hw_cmds_base.h"

#include "opencl/source/helpers/enable_family_full_ocl.h"

namespace NEO {
using Family = Xe3CoreFamily;

struct EnableOCLXe3Core {
    EnableOCLXe3Core() {
        populateFactoryTable<BufferHw<Family>>();
        populateFactoryTable<ClGfxCoreHelperHw<Family>>();
        populateFactoryTable<CommandQueueHw<Family>>();
        populateFactoryTable<ImageHw<Family>>();
        populateFactoryTable<SamplerHw<Family>>();
    }
};

static EnableOCLXe3Core enable;
} // namespace NEO
