{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrString@ structure is used to represent attributes with
-- a string value.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrString
    ( 

-- * Exported types
    AttrString(..)                          ,
    newZeroAttrString                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrStringMethod                 ,
#endif



 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrString_attr                         ,
#endif
    getAttrStringAttr                       ,


-- ** value #attr:value#
-- | the string which is the value of the attribute

#if defined(ENABLE_OVERLOADING)
    attrString_value                        ,
#endif
    clearAttrStringValue                    ,
    getAttrStringValue                      ,
    setAttrStringValue                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute

#endif

-- | Memory-managed wrapper type.
newtype AttrString = AttrString (SP.ManagedPtr AttrString)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrString where
    toManagedPtr (AttrString p) = p

instance BoxedPtr AttrString where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrString)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrString where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrString' struct initialized to zero.
newZeroAttrString :: MonadIO m => m AttrString
newZeroAttrString = liftIO $ boxedPtrCalloc >>= wrapPtr AttrString

instance tag ~ 'AttrSet => Constructible AttrString tag where
    new _ attrs = do
        o <- newZeroAttrString
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrString #attr
-- @
getAttrStringAttr :: MonadIO m => AttrString -> m Pango.Attribute.Attribute
getAttrStringAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrStringAttrFieldInfo
instance AttrInfo AttrStringAttrFieldInfo where
    type AttrBaseTypeConstraint AttrStringAttrFieldInfo = (~) AttrString
    type AttrAllowedOps AttrStringAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrStringAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrStringAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrStringAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrStringAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrStringAttrFieldInfo = "attr"
    type AttrOrigin AttrStringAttrFieldInfo = AttrString
    attrGet = getAttrStringAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrString.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrString.html#g:attr:attr"
        })

attrString_attr :: AttrLabelProxy "attr"
attrString_attr = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrString #value
-- @
getAttrStringValue :: MonadIO m => AttrString -> m (Maybe T.Text)
getAttrStringValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrString [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrStringValue :: MonadIO m => AttrString -> CString -> m ()
setAttrStringValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #value
-- @
clearAttrStringValue :: MonadIO m => AttrString -> m ()
clearAttrStringValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data AttrStringValueFieldInfo
instance AttrInfo AttrStringValueFieldInfo where
    type AttrBaseTypeConstraint AttrStringValueFieldInfo = (~) AttrString
    type AttrAllowedOps AttrStringValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrStringValueFieldInfo = (~) CString
    type AttrTransferTypeConstraint AttrStringValueFieldInfo = (~)CString
    type AttrTransferType AttrStringValueFieldInfo = CString
    type AttrGetType AttrStringValueFieldInfo = Maybe T.Text
    type AttrLabel AttrStringValueFieldInfo = "value"
    type AttrOrigin AttrStringValueFieldInfo = AttrString
    attrGet = getAttrStringValue
    attrSet = setAttrStringValue
    attrConstruct = undefined
    attrClear = clearAttrStringValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrString.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrString.html#g:attr:value"
        })

attrString_value :: AttrLabelProxy "value"
attrString_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrString
type instance O.AttributeList AttrString = AttrStringAttributeList
type AttrStringAttributeList = ('[ '("attr", AttrStringAttrFieldInfo), '("value", AttrStringValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrStringMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrStringMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrStringMethod t AttrString, O.OverloadedMethod info AttrString p) => OL.IsLabel t (AttrString -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrStringMethod t AttrString, O.OverloadedMethod info AttrString p, R.HasField t AttrString p) => R.HasField t AttrString p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrStringMethod t AttrString, O.OverloadedMethodInfo info AttrString) => OL.IsLabel t (O.MethodProxy info AttrString) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


