/* puzzle.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from puzzle.vala, do not modify */

/*
   This file is part of GNOME Klotski.

   Copyright (C) 2010-2013 Robert Ancell

   GNOME Klotski is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Klotski is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Klotski.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
typedef struct _PuzzlePrivate PuzzlePrivate;
enum  {
	PUZZLE_0_PROPERTY,
	PUZZLE_WIDTH_PROPERTY,
	PUZZLE_HEIGHT_PROPERTY,
	PUZZLE_INITIAL_MAP_PROPERTY,
	PUZZLE_MOVES_PROPERTY,
	PUZZLE_NUM_PROPERTIES
};
static GParamSpec* puzzle_properties[PUZZLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PUZZLE_CHANGED_SIGNAL,
	PUZZLE_MOVED_SIGNAL,
	PUZZLE_NUM_SIGNALS
};
static guint puzzle_signals[PUZZLE_NUM_SIGNALS] = {0};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gchar* map;
	gint map_length1;
	gint _map_size_;
	gchar* move_map;
	gint move_map_length1;
	gint _move_map_size_;
	gchar* orig_map;
	gint orig_map_length1;
	gint _orig_map_size_;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gint _lastmove_map_size_;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint _undomove_map_size_;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};

struct _PuzzlePrivate {
	guint8 image_map_length;
	guint8 _width;
	guint8 _height;
	gchar* _initial_map;
	guint16 _moves;
};

static gint Puzzle_private_offset;
static gpointer puzzle_parent_class = NULL;

VALA_EXTERN GType puzzle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Puzzle, g_object_unref)
VALA_EXTERN Puzzle* puzzle_new (guint8 width,
                    guint8 height,
                    const gchar* initial_map);
VALA_EXTERN Puzzle* puzzle_construct (GType object_type,
                          guint8 width,
                          guint8 height,
                          const gchar* initial_map);
VALA_EXTERN gchar puzzle_get_piece_id (Puzzle* self,
                           gchar* src,
                           gint src_length1,
                           guint8 x,
                           guint8 y);
VALA_EXTERN guint8 puzzle_get_width (Puzzle* self);
static void puzzle_set_piece_id (Puzzle* self,
                          gchar* src,
                          gint src_length1,
                          guint8 x,
                          guint8 y,
                          gchar id);
VALA_EXTERN gint puzzle_get_piece_nr (Puzzle* self,
                          guint8 x,
                          guint8 y);
VALA_EXTERN gboolean puzzle_game_over (Puzzle* self);
VALA_EXTERN guint8 puzzle_get_height (Puzzle* self);
VALA_EXTERN gboolean puzzle_mapcmp (Puzzle* self,
                        gchar* m1,
                        gint m1_length1,
                        gchar* m2,
                        gint m2_length1);
VALA_EXTERN gboolean puzzle_is_static_tile (gchar id);
VALA_EXTERN gboolean puzzle_move_piece (Puzzle* self,
                            gchar id,
                            guint8 x1,
                            guint8 y1,
                            guint8 x2,
                            guint8 y2);
static gboolean puzzle_check_valid_move (Puzzle* self,
                                  gchar id,
                                  gint8 dx,
                                  gint8 dy);
static gboolean puzzle_do_move_piece (Puzzle* self,
                               gchar id,
                               gint8 dx,
                               gint8 dy);
VALA_EXTERN gboolean puzzle_can_be_moved (Puzzle* self,
                              gchar id);
static gchar* _vala_array_dup1 (gchar* self,
                         gssize length);
static gchar* _vala_array_dup2 (gchar* self,
                         gssize length);
static void puzzle_set_width (Puzzle* self,
                       guint8 value);
static void puzzle_set_height (Puzzle* self,
                        guint8 value);
static const gchar* puzzle_get_initial_map (Puzzle* self);
static void puzzle_set_initial_map (Puzzle* self,
                             const gchar* value);
VALA_EXTERN guint16 puzzle_get_moves (Puzzle* self);
VALA_EXTERN void puzzle_set_moves (Puzzle* self,
                       guint16 value);
static GObject * puzzle_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties);
static gchar* _vala_array_dup3 (gchar* self,
                         gssize length);
static gchar* _vala_array_dup4 (gchar* self,
                         gssize length);
static gchar* _vala_array_dup5 (gchar* self,
                         gssize length);
static gchar* _vala_array_dup6 (gchar* self,
                         gssize length);
static void puzzle_finalize (GObject * obj);
static GType puzzle_get_type_once (void);
static void _vala_puzzle_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_puzzle_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const guint8 PUZZLE_image_map[108] = {(guint8) 0, (guint8) 0, (guint8) 64, (guint8) 1, (guint8) 66, (guint8) 2, (guint8) 2, (guint8) 3, (guint8) 16, (guint8) 4, (guint8) 24, (guint8) 5, (guint8) 8, (guint8) 6, (guint8) 208, (guint8) 7, (guint8) 248, (guint8) 8, (guint8) 104, (guint8) 9, (guint8) 214, (guint8) 10, (guint8) 255, (guint8) 11, (guint8) 107, (guint8) 12, (guint8) 22, (guint8) 13, (guint8) 31, (guint8) 14, (guint8) 11, (guint8) 15, (guint8) 18, (guint8) 16, (guint8) 10, (guint8) 17, (guint8) 80, (guint8) 18, (guint8) 72, (guint8) 19, (guint8) 25, (guint8) 5, (guint8) 28, (guint8) 5, (guint8) 56, (guint8) 5, (guint8) 152, (guint8) 5, (guint8) 184, (guint8) 5, (guint8) 29, (guint8) 5, (guint8) 67, (guint8) 2, (guint8) 70, (guint8) 2, (guint8) 98, (guint8) 2, (guint8) 194, (guint8) 2, (guint8) 99, (guint8) 2, (guint8) 198, (guint8) 2, (guint8) 9, (guint8) 6, (guint8) 40, (guint8) 6, (guint8) 20, (guint8) 4, (guint8) 144, (guint8) 4, (guint8) 3, (guint8) 3, (guint8) 6, (guint8) 3, (guint8) 96, (guint8) 1, (guint8) 192, (guint8) 1, (guint8) 224, (guint8) 1, (guint8) 14, (guint8) 17, (guint8) 42, (guint8) 17, (guint8) 46, (guint8) 17, (guint8) 19, (guint8) 16, (guint8) 146, (guint8) 16, (guint8) 147, (guint8) 16, (guint8) 73, (guint8) 19, (guint8) 200, (guint8) 19, (guint8) 201, (guint8) 19, (guint8) 84, (guint8) 18, (guint8) 112, (guint8) 18, (guint8) 116, (guint8) 18, (guint8) 26, (guint8) 25};

static inline gpointer
puzzle_get_instance_private (Puzzle* self)
{
	return G_STRUCT_MEMBER_P (self, Puzzle_private_offset);
}

Puzzle*
puzzle_construct (GType object_type,
                  guint8 width,
                  guint8 height,
                  const gchar* initial_map)
{
	Puzzle * self = NULL;
	g_return_val_if_fail (initial_map != NULL, NULL);
	self = (Puzzle*) g_object_new (object_type, "width", width, "height", height, "initial-map", initial_map, NULL);
	return self;
}

Puzzle*
puzzle_new (guint8 width,
            guint8 height,
            const gchar* initial_map)
{
	return puzzle_construct (TYPE_PUZZLE, width, height, initial_map);
}

gchar
puzzle_get_piece_id (Puzzle* self,
                     gchar* src,
                     gint src_length1,
                     guint8 x,
                     guint8 y)
{
	guint8 _tmp0_;
	gchar _tmp1_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = self->priv->_width;
	_tmp1_ = src[(((guint16) x) + 1) + ((((guint16) y) + 1) * (((guint16) _tmp0_) + 2))];
	result = _tmp1_;
	return result;
}

static void
puzzle_set_piece_id (Puzzle* self,
                     gchar* src,
                     gint src_length1,
                     guint8 x,
                     guint8 y,
                     gchar id)
{
	guint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_width;
	src[(((guint16) x) + 1) + ((((guint16) y) + 1) * (((guint16) _tmp0_) + 2))] = id;
}

gint
puzzle_get_piece_nr (Puzzle* self,
                     guint8 x,
                     guint8 y)
{
	guint8 _tmp0_;
	guint8 _tmp1_;
	gchar c = '\0';
	gchar* _tmp2_;
	gint _tmp2__length1;
	guint8 _tmp3_;
	gchar _tmp4_;
	guint8 nr = 0U;
	gchar* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	gchar _tmp7_;
	gchar* _tmp8_;
	gint _tmp8__length1;
	guint8 _tmp9_;
	gchar _tmp10_;
	gchar* _tmp11_;
	gint _tmp11__length1;
	guint8 _tmp12_;
	gchar _tmp13_;
	gchar* _tmp14_;
	gint _tmp14__length1;
	guint8 _tmp15_;
	gchar _tmp16_;
	gchar* _tmp17_;
	gint _tmp17__length1;
	guint8 _tmp18_;
	gchar _tmp19_;
	gchar* _tmp20_;
	gint _tmp20__length1;
	guint8 _tmp21_;
	gchar _tmp22_;
	gchar* _tmp23_;
	gint _tmp23__length1;
	guint8 _tmp24_;
	gchar _tmp25_;
	gchar* _tmp26_;
	gint _tmp26__length1;
	guint8 _tmp27_;
	gchar _tmp28_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	x = _tmp0_ + 1;
	_tmp1_ = y;
	y = _tmp1_ + 1;
	_tmp2_ = self->map;
	_tmp2__length1 = self->map_length1;
	_tmp3_ = self->priv->_width;
	_tmp4_ = _tmp2_[((guint16) x) + (((guint16) y) * (((guint16) _tmp3_) + 2))];
	c = _tmp4_;
	if (c == '-') {
		result = 23;
		return result;
	}
	if (c == ' ') {
		result = 21;
		return result;
	}
	if (c == '.') {
		result = 20;
		return result;
	}
	nr = (guint8) 0;
	_tmp5_ = self->map;
	_tmp5__length1 = self->map_length1;
	_tmp6_ = self->priv->_width;
	_tmp7_ = _tmp5_[(((guint16) x) - 1) + ((((guint16) y) - 1) * (((guint16) _tmp6_) + 2))];
	if (_tmp7_ == c) {
		nr += (guint8) 1;
	}
	_tmp8_ = self->map;
	_tmp8__length1 = self->map_length1;
	_tmp9_ = self->priv->_width;
	_tmp10_ = _tmp8_[((guint16) x) + ((((guint16) y) - 1) * (((guint16) _tmp9_) + 2))];
	if (_tmp10_ == c) {
		nr += (guint8) 2;
	}
	_tmp11_ = self->map;
	_tmp11__length1 = self->map_length1;
	_tmp12_ = self->priv->_width;
	_tmp13_ = _tmp11_[(((guint16) x) + 1) + ((((guint16) y) - 1) * (((guint16) _tmp12_) + 2))];
	if (_tmp13_ == c) {
		nr += (guint8) 4;
	}
	_tmp14_ = self->map;
	_tmp14__length1 = self->map_length1;
	_tmp15_ = self->priv->_width;
	_tmp16_ = _tmp14_[(((guint16) x) - 1) + (((guint16) y) * (((guint16) _tmp15_) + 2))];
	if (_tmp16_ == c) {
		nr += (guint8) 8;
	}
	_tmp17_ = self->map;
	_tmp17__length1 = self->map_length1;
	_tmp18_ = self->priv->_width;
	_tmp19_ = _tmp17_[(((guint16) x) + 1) + (((guint16) y) * (((guint16) _tmp18_) + 2))];
	if (_tmp19_ == c) {
		nr += (guint8) 16;
	}
	_tmp20_ = self->map;
	_tmp20__length1 = self->map_length1;
	_tmp21_ = self->priv->_width;
	_tmp22_ = _tmp20_[(((guint16) x) - 1) + ((((guint16) y) + 1) * (((guint16) _tmp21_) + 2))];
	if (_tmp22_ == c) {
		nr += (guint8) 32;
	}
	_tmp23_ = self->map;
	_tmp23__length1 = self->map_length1;
	_tmp24_ = self->priv->_width;
	_tmp25_ = _tmp23_[((guint16) x) + ((((guint16) y) + 1) * (((guint16) _tmp24_) + 2))];
	if (_tmp25_ == c) {
		nr += (guint8) 64;
	}
	_tmp26_ = self->map;
	_tmp26__length1 = self->map_length1;
	_tmp27_ = self->priv->_width;
	_tmp28_ = _tmp26_[(((guint16) x) + 1) + ((((guint16) y) + 1) * (((guint16) _tmp27_) + 2))];
	if (_tmp28_ == c) {
		nr += (guint8) 128;
	}
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				guint8 _tmp30_;
				if (!_tmp29_) {
					i += (guint8) 2;
				}
				_tmp29_ = FALSE;
				if (!(((gint) i) < (self->priv->image_map_length * 2))) {
					break;
				}
				_tmp30_ = PUZZLE_image_map[i];
				if (nr == _tmp30_) {
					guint8 _tmp31_;
					_tmp31_ = PUZZLE_image_map[i + 1];
					result = (gint) _tmp31_;
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}

gboolean
puzzle_game_over (Puzzle* self)
{
	gboolean over = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	over = TRUE;
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint8 _tmp2_;
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_height;
				if (!(y < _tmp2_)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							guint8 _tmp5_;
							gboolean _tmp6_ = FALSE;
							gchar* _tmp7_;
							gint _tmp7__length1;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = x;
								x = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_width;
							if (!(x < _tmp5_)) {
								break;
							}
							_tmp7_ = self->map;
							_tmp7__length1 = self->map_length1;
							if (puzzle_get_piece_id (self, _tmp7_, (gint) _tmp7__length1, x, y) == '*') {
								gchar* _tmp8_;
								gint _tmp8__length1;
								_tmp8_ = self->orig_map;
								_tmp8__length1 = self->orig_map_length1;
								_tmp6_ = puzzle_get_piece_id (self, _tmp8_, (gint) _tmp8__length1, x, y) != '.';
							} else {
								_tmp6_ = FALSE;
							}
							if (_tmp6_) {
								over = FALSE;
							}
						}
					}
				}
			}
		}
	}
	result = over;
	return result;
}

gboolean
puzzle_mapcmp (Puzzle* self,
               gchar* m1,
               gint m1_length1,
               gchar* m2,
               gint m2_length1)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint8 _tmp2_;
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_height;
				if (!(y < _tmp2_)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							guint8 _tmp5_;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = x;
								x = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_width;
							if (!(x < _tmp5_)) {
								break;
							}
							if (puzzle_get_piece_id (self, m1, (gint) m1_length1, x, y) != puzzle_get_piece_id (self, m2, (gint) m2_length1, x, y)) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

inline gboolean
puzzle_is_static_tile (gchar id)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	if (id == '#') {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = id == '.';
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = id == ' ';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = id == '-';
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
puzzle_move_piece (Puzzle* self,
                   gchar id,
                   guint8 x1,
                   guint8 y1,
                   guint8 x2,
                   guint8 y2)
{
	gboolean return_value = FALSE;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	return_value = FALSE;
	if (puzzle_is_static_tile (id)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->map;
	_tmp0__length1 = self->map_length1;
	if (puzzle_get_piece_id (self, _tmp0_, (gint) _tmp0__length1, x2, y2) == id) {
		return_value = TRUE;
	}
	if (y1 == y2) {
		_tmp2_ = abs (((gint) x1) - ((gint) x2)) == 1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (x1 == x2) {
			_tmp3_ = abs (((gint) y1) - ((gint) y2)) == 1;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	if (abs (((gint) y1) - ((gint) y2)) == 1) {
		if (y1 < y2) {
			if (puzzle_check_valid_move (self, id, (gint8) 0, (gint8) 1)) {
				result = puzzle_do_move_piece (self, id, (gint8) 0, (gint8) 1);
				return result;
			}
		} else {
			if (y1 > y2) {
				if (puzzle_check_valid_move (self, id, (gint8) 0, (gint8) -1)) {
					result = puzzle_do_move_piece (self, id, (gint8) 0, (gint8) -1);
					return result;
				}
			}
		}
	}
	if (abs (((gint) x1) - ((gint) x2)) == 1) {
		if (x1 < x2) {
			if (puzzle_check_valid_move (self, id, (gint8) 1, (gint8) 0)) {
				result = puzzle_do_move_piece (self, id, (gint8) 1, (gint8) 0);
				return result;
			}
		} else {
			if (x1 > x2) {
				if (puzzle_check_valid_move (self, id, (gint8) -1, (gint8) 0)) {
					result = puzzle_do_move_piece (self, id, (gint8) -1, (gint8) 0);
					return result;
				}
			}
		}
	}
	result = return_value;
	return result;
}

gboolean
puzzle_can_be_moved (Puzzle* self,
                     gchar id)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (puzzle_is_static_tile (id)) {
		result = FALSE;
		return result;
	}
	if (puzzle_check_valid_move (self, id, (gint8) 0, (gint8) 1)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = puzzle_check_valid_move (self, id, (gint8) 0, (gint8) -1);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = puzzle_check_valid_move (self, id, (gint8) 1, (gint8) 0);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = puzzle_check_valid_move (self, id, (gint8) -1, (gint8) 0);
	}
	result = _tmp0_;
	return result;
}

static gboolean
puzzle_check_valid_move (Puzzle* self,
                         gchar id,
                         gint8 dx,
                         gint8 dy)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint8 y = 0;
		y = (gint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint8 _tmp2_;
				if (!_tmp0_) {
					gint8 _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_height;
				if (!(((guint8) y) < _tmp2_)) {
					break;
				}
				{
					gint8 x = 0;
					x = (gint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							guint8 _tmp5_;
							gchar* _tmp6_;
							gint _tmp6__length1;
							if (!_tmp3_) {
								gint8 _tmp4_;
								_tmp4_ = x;
								x = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_width;
							if (!(((guint8) x) < _tmp5_)) {
								break;
							}
							_tmp6_ = self->map;
							_tmp6__length1 = self->map_length1;
							if (puzzle_get_piece_id (self, _tmp6_, (gint) _tmp6__length1, (guint8) x, (guint8) y) == id) {
								gchar z = '\0';
								gchar* _tmp7_;
								gint _tmp7__length1;
								gboolean _tmp8_ = FALSE;
								gboolean _tmp9_ = FALSE;
								gboolean _tmp10_ = FALSE;
								_tmp7_ = self->map;
								_tmp7__length1 = self->map_length1;
								z = puzzle_get_piece_id (self, _tmp7_, (gint) _tmp7__length1, (guint8) (x + dx), (guint8) (y + dy));
								if (z == ' ') {
									_tmp10_ = TRUE;
								} else {
									_tmp10_ = z == '.';
								}
								if (_tmp10_) {
									_tmp9_ = TRUE;
								} else {
									_tmp9_ = z == id;
								}
								if (_tmp9_) {
									_tmp8_ = TRUE;
								} else {
									gboolean _tmp11_ = FALSE;
									if (id == '*') {
										_tmp11_ = z == '-';
									} else {
										_tmp11_ = FALSE;
									}
									_tmp8_ = _tmp11_;
								}
								if (!_tmp8_) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
_vala_array_dup1 (gchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static gchar*
_vala_array_dup2 (gchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static gboolean
puzzle_do_move_piece (Puzzle* self,
                      gchar id,
                      gint8 dx,
                      gint8 dy)
{
	gchar* tmpmap = NULL;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint tmpmap_length1;
	gint _tmpmap_size_;
	gchar* _tmp32_;
	gint _tmp32__length1;
	gchar* _tmp33_;
	gint _tmp33__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->map;
	_tmp0__length1 = self->map_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	tmpmap = _tmp1_;
	tmpmap_length1 = _tmp1__length1;
	_tmpmap_size_ = tmpmap_length1;
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint8 _tmp4_;
				if (!_tmp2_) {
					guint8 _tmp3_;
					_tmp3_ = y;
					y = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->_height;
				if (!(y < _tmp4_)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							guint8 _tmp7_;
							gchar* _tmp8_;
							gint _tmp8__length1;
							if (!_tmp5_) {
								guint8 _tmp6_;
								_tmp6_ = x;
								x = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = self->priv->_width;
							if (!(x < _tmp7_)) {
								break;
							}
							_tmp8_ = tmpmap;
							_tmp8__length1 = tmpmap_length1;
							if (puzzle_get_piece_id (self, _tmp8_, (gint) _tmp8__length1, x, y) == id) {
								gchar* _tmp9_;
								gint _tmp9__length1;
								_tmp9_ = tmpmap;
								_tmp9__length1 = tmpmap_length1;
								puzzle_set_piece_id (self, _tmp9_, (gint) _tmp9__length1, x, y, ' ');
							}
						}
					}
				}
			}
		}
	}
	{
		gint8 y = 0;
		y = (gint8) 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				guint8 _tmp12_;
				if (!_tmp10_) {
					gint8 _tmp11_;
					_tmp11_ = y;
					y = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = self->priv->_height;
				if (!(((guint8) y) < _tmp12_)) {
					break;
				}
				{
					gint8 x = 0;
					x = (gint8) 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							guint8 _tmp15_;
							gchar* _tmp16_;
							gint _tmp16__length1;
							if (!_tmp13_) {
								gint8 _tmp14_;
								_tmp14_ = x;
								x = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = self->priv->_width;
							if (!(((guint8) x) < _tmp15_)) {
								break;
							}
							_tmp16_ = self->map;
							_tmp16__length1 = self->map_length1;
							if (puzzle_get_piece_id (self, _tmp16_, (gint) _tmp16__length1, (guint8) x, (guint8) y) == id) {
								gchar* _tmp17_;
								gint _tmp17__length1;
								_tmp17_ = tmpmap;
								_tmp17__length1 = tmpmap_length1;
								puzzle_set_piece_id (self, _tmp17_, (gint) _tmp17__length1, (guint8) (x + dx), (guint8) (y + dy), id);
							}
						}
					}
				}
			}
		}
	}
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				guint8 _tmp20_;
				if (!_tmp18_) {
					guint8 _tmp19_;
					_tmp19_ = y;
					y = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = self->priv->_height;
				if (!(y < _tmp20_)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							guint8 _tmp23_;
							gboolean _tmp24_ = FALSE;
							gchar* _tmp25_;
							gint _tmp25__length1;
							gboolean _tmp28_ = FALSE;
							gchar* _tmp29_;
							gint _tmp29__length1;
							if (!_tmp21_) {
								guint8 _tmp22_;
								_tmp22_ = x;
								x = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp23_ = self->priv->_width;
							if (!(x < _tmp23_)) {
								break;
							}
							_tmp25_ = tmpmap;
							_tmp25__length1 = tmpmap_length1;
							if (puzzle_get_piece_id (self, _tmp25_, (gint) _tmp25__length1, x, y) == ' ') {
								gchar* _tmp26_;
								gint _tmp26__length1;
								_tmp26_ = self->orig_map;
								_tmp26__length1 = self->orig_map_length1;
								_tmp24_ = puzzle_get_piece_id (self, _tmp26_, (gint) _tmp26__length1, x, y) == '.';
							} else {
								_tmp24_ = FALSE;
							}
							if (_tmp24_) {
								gchar* _tmp27_;
								gint _tmp27__length1;
								_tmp27_ = tmpmap;
								_tmp27__length1 = tmpmap_length1;
								puzzle_set_piece_id (self, _tmp27_, (gint) _tmp27__length1, x, y, '.');
							}
							_tmp29_ = tmpmap;
							_tmp29__length1 = tmpmap_length1;
							if (puzzle_get_piece_id (self, _tmp29_, (gint) _tmp29__length1, x, y) == ' ') {
								gchar* _tmp30_;
								gint _tmp30__length1;
								_tmp30_ = self->orig_map;
								_tmp30__length1 = self->orig_map_length1;
								_tmp28_ = puzzle_get_piece_id (self, _tmp30_, (gint) _tmp30__length1, x, y) == '-';
							} else {
								_tmp28_ = FALSE;
							}
							if (_tmp28_) {
								gchar* _tmp31_;
								gint _tmp31__length1;
								_tmp31_ = tmpmap;
								_tmp31__length1 = tmpmap_length1;
								puzzle_set_piece_id (self, _tmp31_, (gint) _tmp31__length1, x, y, '-');
							}
						}
					}
				}
			}
		}
	}
	g_signal_emit (self, puzzle_signals[PUZZLE_CHANGED_SIGNAL], 0);
	_tmp32_ = tmpmap;
	_tmp32__length1 = tmpmap_length1;
	_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup2 (_tmp32_, _tmp32__length1) : _tmp32_;
	_tmp33__length1 = _tmp32__length1;
	self->map = (g_free (self->map), NULL);
	self->map = _tmp33_;
	self->map_length1 = _tmp33__length1;
	self->_map_size_ = self->map_length1;
	result = TRUE;
	tmpmap = (g_free (tmpmap), NULL);
	return result;
}

guint8
puzzle_get_width (Puzzle* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_width;
	return result;
}

static void
puzzle_set_width (Puzzle* self,
                  guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
}

guint8
puzzle_get_height (Puzzle* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_height;
	return result;
}

static void
puzzle_set_height (Puzzle* self,
                   guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_height = value;
}

static const gchar*
puzzle_get_initial_map (Puzzle* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initial_map;
	result = _tmp0_;
	return result;
}

static void
puzzle_set_initial_map (Puzzle* self,
                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_initial_map);
	self->priv->_initial_map = _tmp0_;
}

guint16
puzzle_get_moves (Puzzle* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_moves;
	return result;
}

void
puzzle_set_moves (Puzzle* self,
                  guint16 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_moves = value;
}

static gchar*
_vala_array_dup3 (gchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static gchar*
_vala_array_dup4 (gchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
_vala_array_dup5 (gchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static gchar*
_vala_array_dup6 (gchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static GObject *
puzzle_constructor (GType type,
                    guint n_construct_properties,
                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Puzzle * self;
	guint8 _tmp0_;
	guint8 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gint _tmp6__length1;
	guint16 i = 0U;
	gchar* _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gint _tmp19__length1;
	parent_class = G_OBJECT_CLASS (puzzle_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE, Puzzle);
	_tmp0_ = self->priv->_width;
	_tmp1_ = self->priv->_height;
	_tmp2_ = g_new0 (gchar, (_tmp0_ + 2) * (_tmp1_ + 2));
	self->map = (g_free (self->map), NULL);
	self->map = _tmp2_;
	self->map_length1 = (_tmp0_ + 2) * (_tmp1_ + 2);
	self->_map_size_ = self->map_length1;
	_tmp3_ = self->map;
	_tmp3__length1 = self->map_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup3 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	self->move_map = (g_free (self->move_map), NULL);
	self->move_map = _tmp4_;
	self->move_map_length1 = _tmp4__length1;
	self->_move_map_size_ = self->move_map_length1;
	_tmp5_ = self->map;
	_tmp5__length1 = self->map_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup4 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	self->undomove_map = (g_free (self->undomove_map), NULL);
	self->undomove_map = _tmp6_;
	self->undomove_map_length1 = _tmp6__length1;
	self->_undomove_map_size_ = self->undomove_map_length1;
	i = (guint16) 0;
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				guint8 _tmp9_;
				if (!_tmp7_) {
					guint8 _tmp8_;
					_tmp8_ = y;
					y = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = self->priv->_height;
				if (!(y < _tmp9_)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							guint8 _tmp12_;
							gchar* _tmp13_;
							gint _tmp13__length1;
							const gchar* _tmp14_;
							guint16 _tmp15_;
							if (!_tmp10_) {
								guint8 _tmp11_;
								_tmp11_ = x;
								x = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = self->priv->_width;
							if (!(x < _tmp12_)) {
								break;
							}
							_tmp13_ = self->map;
							_tmp13__length1 = self->map_length1;
							_tmp14_ = self->priv->_initial_map;
							puzzle_set_piece_id (self, _tmp13_, (gint) _tmp13__length1, x, y, string_get (_tmp14_, (glong) i));
							_tmp15_ = i;
							i = _tmp15_ + 1;
						}
					}
				}
			}
		}
	}
	_tmp16_ = self->map;
	_tmp16__length1 = self->map_length1;
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup5 (_tmp16_, _tmp16__length1) : _tmp16_;
	_tmp17__length1 = _tmp16__length1;
	self->orig_map = (g_free (self->orig_map), NULL);
	self->orig_map = _tmp17_;
	self->orig_map_length1 = _tmp17__length1;
	self->_orig_map_size_ = self->orig_map_length1;
	_tmp18_ = self->map;
	_tmp18__length1 = self->map_length1;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup6 (_tmp18_, _tmp18__length1) : _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
	self->lastmove_map = _tmp19_;
	self->lastmove_map_length1 = _tmp19__length1;
	self->_lastmove_map_size_ = self->lastmove_map_length1;
	return obj;
}

static void
puzzle_class_init (PuzzleClass * klass,
                   gpointer klass_data)
{
	puzzle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Puzzle_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_set_property;
	G_OBJECT_CLASS (klass)->constructor = puzzle_constructor;
	G_OBJECT_CLASS (klass)->finalize = puzzle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_WIDTH_PROPERTY, puzzle_properties[PUZZLE_WIDTH_PROPERTY] = g_param_spec_uchar ("width", "width", "width", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_HEIGHT_PROPERTY, puzzle_properties[PUZZLE_HEIGHT_PROPERTY] = g_param_spec_uchar ("height", "height", "height", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_INITIAL_MAP_PROPERTY, puzzle_properties[PUZZLE_INITIAL_MAP_PROPERTY] = g_param_spec_string ("initial-map", "initial-map", "initial-map", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_MOVES_PROPERTY, puzzle_properties[PUZZLE_MOVES_PROPERTY] = g_param_spec_uint ("moves", "moves", "moves", 0, G_MAXUINT, (guint16) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	puzzle_signals[PUZZLE_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	puzzle_signals[PUZZLE_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
puzzle_instance_init (Puzzle * self,
                      gpointer klass)
{
	self->priv = puzzle_get_instance_private (self);
	self->priv->image_map_length = (guint8) 54;
	self->priv->_moves = (guint16) 0;
}

static void
puzzle_finalize (GObject * obj)
{
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE, Puzzle);
	_g_free0 (self->priv->_initial_map);
	self->map = (g_free (self->map), NULL);
	self->move_map = (g_free (self->move_map), NULL);
	self->orig_map = (g_free (self->orig_map), NULL);
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
	self->undomove_map = (g_free (self->undomove_map), NULL);
	G_OBJECT_CLASS (puzzle_parent_class)->finalize (obj);
}

static GType
puzzle_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PuzzleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Puzzle), 0, (GInstanceInitFunc) puzzle_instance_init, NULL };
	GType puzzle_type_id;
	puzzle_type_id = g_type_register_static (G_TYPE_OBJECT, "Puzzle", &g_define_type_info, 0);
	Puzzle_private_offset = g_type_add_instance_private (puzzle_type_id, sizeof (PuzzlePrivate));
	return puzzle_type_id;
}

GType
puzzle_get_type (void)
{
	static volatile gsize puzzle_type_id__once = 0;
	if (g_once_init_enter (&puzzle_type_id__once)) {
		GType puzzle_type_id;
		puzzle_type_id = puzzle_get_type_once ();
		g_once_init_leave (&puzzle_type_id__once, puzzle_type_id);
	}
	return puzzle_type_id__once;
}

static void
_vala_puzzle_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE, Puzzle);
	switch (property_id) {
		case PUZZLE_WIDTH_PROPERTY:
		g_value_set_uchar (value, puzzle_get_width (self));
		break;
		case PUZZLE_HEIGHT_PROPERTY:
		g_value_set_uchar (value, puzzle_get_height (self));
		break;
		case PUZZLE_INITIAL_MAP_PROPERTY:
		g_value_set_string (value, puzzle_get_initial_map (self));
		break;
		case PUZZLE_MOVES_PROPERTY:
		g_value_set_uint (value, puzzle_get_moves (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_puzzle_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE, Puzzle);
	switch (property_id) {
		case PUZZLE_WIDTH_PROPERTY:
		puzzle_set_width (self, g_value_get_uchar (value));
		break;
		case PUZZLE_HEIGHT_PROPERTY:
		puzzle_set_height (self, g_value_get_uchar (value));
		break;
		case PUZZLE_INITIAL_MAP_PROPERTY:
		puzzle_set_initial_map (self, g_value_get_string (value));
		break;
		case PUZZLE_MOVES_PROPERTY:
		puzzle_set_moves (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

