/* currency-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from currency-provider.vala, do not modify */

#include "calculator.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <sys/stat.h>
#include <time.h>
#include <libsoup/soup.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CURRENCY_PROVIDER_UPDATED_SIGNAL,
	CURRENCY_PROVIDER_NUM_SIGNALS
};
static guint currency_provider_signals[CURRENCY_PROVIDER_NUM_SIGNALS] = {0};
enum  {
	ABSTRACT_CURRENCY_PROVIDER_0_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_BASE_CURRENCY_SYMBOL_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_LOADED_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AbstractCurrencyProviderDownloadFileAsyncData AbstractCurrencyProviderDownloadFileAsyncData;

struct _AbstractCurrencyProviderPrivate {
	gchar* _base_currency_symbol;
	gint _refresh_interval;
	gboolean _loaded;
	CurrencyManager* _currency_manager;
};

struct _AbstractCurrencyProviderDownloadFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AbstractCurrencyProvider* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest;
	GFile* _tmp2_;
	SoupSession* session;
	SoupSession* _tmp3_;
	SoupMessage* message;
	SoupMessage* _tmp4_;
	GFileOutputStream* output;
	GFile* _tmp5_;
	GFileOutputStream* _tmp6_;
	SoupSession* _tmp7_;
	SoupMessage* _tmp8_;
	GFileOutputStream* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

static gint AbstractCurrencyProvider_private_offset;
static gpointer abstract_currency_provider_parent_class = NULL;
static CurrencyProviderIface * abstract_currency_provider_currency_provider_parent_iface = NULL;

static GType currency_provider_get_type_once (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void abstract_currency_provider_real_clear (CurrencyProvider* base);
static GDateTime* abstract_currency_provider_real_parse_date (AbstractCurrencyProvider* self,
                                                       const gchar* date);
static void abstract_currency_provider_real_update_rates (CurrencyProvider* base,
                                                   gboolean async_load,
                                                   gboolean force);
static gboolean abstract_currency_provider_file_needs_update (AbstractCurrencyProvider* self,
                                                       const gchar* filename,
                                                       gdouble max_age);
static void ___lambda13_ (AbstractCurrencyProvider* self,
                   const gchar* symbol);
static gboolean ___lambda14_ (AbstractCurrencyProvider* self);
static gboolean ____lambda14__gsource_func (gpointer self);
static void ____lambda13__currency_manager_updated (CurrencyManager* _sender,
                                             const gchar* symbol,
                                             gpointer self);
static gboolean abstract_currency_provider_real_do_load_rates (AbstractCurrencyProvider* self);
static void abstract_currency_provider_real_download_file_sync (AbstractCurrencyProvider* self,
                                                         const gchar* uri,
                                                         const gchar* filename,
                                                         const gchar* source);
static void abstract_currency_provider_real_download_file_async_data_free (gpointer _data);
static void abstract_currency_provider_real_download_file_async (AbstractCurrencyProvider* self,
                                                          const gchar* uri,
                                                          const gchar* filename,
                                                          const gchar* source,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static gboolean abstract_currency_provider_real_download_file_async_co (AbstractCurrencyProviderDownloadFileAsyncData* _data_);
static void abstract_currency_provider_download_file_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void abstract_currency_provider_finalize (GObject * obj);
static GType abstract_currency_provider_get_type_once (void);
static void _vala_abstract_currency_provider_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_abstract_currency_provider_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
currency_provider_update_rates (CurrencyProvider* self,
                                gboolean async_load,
                                gboolean force)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->update_rates) {
		_iface_->update_rates (self, async_load, force);
	}
}

void
currency_provider_clear (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->clear) {
		_iface_->clear (self);
	}
}

GDateTime*
currency_provider_parse_date (CurrencyProvider* self,
                              const gchar* date)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->parse_date) {
		return _iface_->parse_date (self, date);
	}
	return NULL;
}

gint
currency_provider_get_refresh_interval (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->get_refresh_interval) {
		return _iface_->get_refresh_interval (self);
	}
	return -1;
}

void
currency_provider_set_refresh_interval (CurrencyProvider* self,
                                        gint value)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->set_refresh_interval) {
		_iface_->set_refresh_interval (self, value);
	}
}

gchar*
currency_provider_get_attribution_link (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->get_attribution_link) {
		return _iface_->get_attribution_link (self);
	}
	return NULL;
}

const gchar*
currency_provider_get_provider_name (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->get_provider_name) {
		return _iface_->get_provider_name (self);
	}
	return NULL;
}

gboolean
currency_provider_get_loaded (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->get_loaded) {
		return _iface_->get_loaded (self);
	}
	return FALSE;
}

void
currency_provider_set_loaded (CurrencyProvider* self,
                              gboolean value)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->set_loaded) {
		_iface_->set_loaded (self, value);
	}
}

static void
currency_provider_default_init (CurrencyProviderIface * iface,
                                gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_int ("refresh-interval", "refresh-interval", "refresh-interval", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL] = g_signal_new ("updated", TYPE_CURRENCY_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static GType
currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CurrencyProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType currency_provider_type_id;
	currency_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "CurrencyProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (currency_provider_type_id, G_TYPE_OBJECT);
	return currency_provider_type_id;
}

GType
currency_provider_get_type (void)
{
	static volatile gsize currency_provider_type_id__once = 0;
	if (g_once_init_enter (&currency_provider_type_id__once)) {
		GType currency_provider_type_id;
		currency_provider_type_id = currency_provider_get_type_once ();
		g_once_init_leave (&currency_provider_type_id__once, currency_provider_type_id);
	}
	return currency_provider_type_id__once;
}

static inline gpointer
abstract_currency_provider_get_instance_private (AbstractCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, AbstractCurrencyProvider_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
abstract_currency_provider_real_clear (CurrencyProvider* base)
{
	AbstractCurrencyProvider * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (AbstractCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_rate_filepath (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Currency*
abstract_currency_provider_register_currency (AbstractCurrencyProvider* self,
                                              const gchar* symbol,
                                              const gchar* source,
                                              Number* value,
                                              const gchar* date)
{
	Currency* currency = NULL;
	CurrencyManager* _tmp0_;
	Currency* _tmp1_;
	gchar* _tmp2_;
	Currency* _tmp3_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	_tmp1_ = currency_manager_add_currency (_tmp0_, symbol, source);
	currency = _tmp1_;
	currency_set_value (currency, value);
	_tmp2_ = g_strdup (date);
	currency_set_date (currency, _tmp2_);
	currency_set_provider (currency, (CurrencyProvider*) self);
	_tmp3_ = _g_object_ref0 (currency);
	self->currencies = g_list_append (self->currencies, _tmp3_);
	g_signal_emit ((CurrencyProvider*) self, currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL], 0, symbol);
	result = currency;
	return result;
}

static GDateTime*
abstract_currency_provider_real_parse_date (AbstractCurrencyProvider* self,
                                            const gchar* date)
{
	GDateTime* result;
	result = NULL;
	return result;
}

GDateTime*
abstract_currency_provider_parse_date (AbstractCurrencyProvider* self,
                                       const gchar* date)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->parse_date) {
		return _klass_->parse_date (self, date);
	}
	return NULL;
}

static void
abstract_currency_provider_real_update_rates (CurrencyProvider* base,
                                              gboolean async_load,
                                              gboolean force)
{
	AbstractCurrencyProvider * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	self = (AbstractCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_source_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("Updating %s rates ", _tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("currency-provider.vala:70: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	currency_provider_set_loaded ((CurrencyProvider*) self, FALSE);
	if (self->loading) {
		return;
	}
	self->loading = TRUE;
	_tmp5_ = abstract_currency_provider_get_source_name (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("Checking %s rates ", _tmp7_);
	_tmp9_ = _tmp8_;
	g_debug ("currency-provider.vala:77: %s", _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	if (!force) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp11_ = abstract_currency_provider_get_rate_filepath (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = currency_provider_get_refresh_interval ((CurrencyProvider*) self);
		_tmp15_ = _tmp14_;
		_tmp10_ = !abstract_currency_provider_file_needs_update (self, _tmp13_, (gdouble) _tmp15_);
		_g_free0 (_tmp13_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		self->loading = FALSE;
		abstract_currency_provider_do_load_rates (self);
		return;
	}
	_tmp16_ = abstract_currency_provider_get_source_name (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("Loading %s rates ", _tmp18_);
	_tmp20_ = _tmp19_;
	g_debug ("currency-provider.vala:85: %s", _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	if (async_load) {
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp21_ = abstract_currency_provider_get_source_name (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup_printf ("Downloading %s rates async from %s", _tmp23_, _tmp26_);
		_tmp28_ = _tmp27_;
		g_debug ("currency-provider.vala:88: %s", _tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp23_);
		_tmp29_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		_tmp32_ = abstract_currency_provider_get_rate_filepath (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_;
		_tmp35_ = abstract_currency_provider_get_source_name (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = _tmp36_;
		abstract_currency_provider_download_file_async (self, _tmp31_, _tmp34_, _tmp37_, NULL, NULL);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp31_);
	} else {
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp38_ = abstract_currency_provider_get_source_name (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp39_;
		_tmp41_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf ("Downloading %s rates sync from %s", _tmp40_, _tmp43_);
		_tmp45_ = _tmp44_;
		g_debug ("currency-provider.vala:91: %s", _tmp45_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp40_);
		_tmp46_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_;
		_tmp49_ = abstract_currency_provider_get_rate_filepath (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_;
		_tmp52_ = abstract_currency_provider_get_source_name (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = _tmp53_;
		abstract_currency_provider_download_file_sync (self, _tmp48_, _tmp51_, _tmp54_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp48_);
		self->loading = FALSE;
		abstract_currency_provider_do_load_rates (self);
	}
}

static gboolean
___lambda14_ (AbstractCurrencyProvider* self)
{
	gboolean result;
	self->loading = FALSE;
	result = !abstract_currency_provider_do_load_rates (self);
	return result;
}

static gboolean
____lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda14_ ((AbstractCurrencyProvider*) self);
	return result;
}

static void
___lambda13_ (AbstractCurrencyProvider* self,
              const gchar* symbol)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->_base_currency_symbol;
	if (g_strcmp0 (symbol, _tmp0_) == 0) {
		if (self->update_callback > ((guint) 0)) {
			g_source_remove (self->update_callback);
		}
		self->update_callback = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ____lambda14__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
____lambda13__currency_manager_updated (CurrencyManager* _sender,
                                        const gchar* symbol,
                                        gpointer self)
{
	___lambda13_ ((AbstractCurrencyProvider*) self, symbol);
}

Currency*
abstract_currency_provider_get_base_currency (AbstractCurrencyProvider* self)
{
	const gchar* _tmp0_;
	Currency* base_rate = NULL;
	const gchar* _tmp1_;
	Currency* _tmp2_;
	Currency* _tmp3_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_currency_symbol;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_base_currency_symbol;
	_tmp2_ = abstract_currency_provider_get_currency (self, _tmp1_);
	base_rate = _tmp2_;
	_tmp3_ = base_rate;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		CurrencyManager* _tmp9_;
		_tmp4_ = currency_provider_get_provider_name ((CurrencyProvider*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->_base_currency_symbol;
		_tmp7_ = g_strdup_printf ("Cannot use %s rates as we don't have %s rate yet, retrying", _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		g_warning ("currency-provider.vala:105: %s", _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = self->priv->_currency_manager;
		g_signal_connect_object (_tmp9_, "updated", (GCallback) ____lambda13__currency_manager_updated, self, 0);
		result = NULL;
		_g_object_unref0 (base_rate);
		return result;
	}
	result = base_rate;
	return result;
}

Currency*
abstract_currency_provider_get_currency (AbstractCurrencyProvider* self,
                                         const gchar* name)
{
	CurrencyManager* _tmp0_;
	Currency* _tmp1_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	_tmp1_ = currency_manager_get_currency (_tmp0_, name);
	result = _tmp1_;
	return result;
}

static gboolean
abstract_currency_provider_real_do_load_rates (AbstractCurrencyProvider* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	_tmp0_ = abstract_currency_provider_get_source_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("Loaded %s rates ", _tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("currency-provider.vala:129: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	currency_provider_set_loaded ((CurrencyProvider*) self, TRUE);
	g_signal_emit ((CurrencyProvider*) self, currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL], 0, NULL);
	_tmp5_ = currency_provider_get_loaded ((CurrencyProvider*) self);
	_tmp6_ = _tmp5_;
	result = _tmp6_;
	return result;
}

gboolean
abstract_currency_provider_do_load_rates (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->do_load_rates) {
		return _klass_->do_load_rates (self);
	}
	return FALSE;
}

static gboolean
abstract_currency_provider_file_needs_update (AbstractCurrencyProvider* self,
                                              const gchar* filename,
                                              gdouble max_age)
{
	struct stat buf = {0};
	struct stat _tmp0_ = {0};
	gint _tmp1_;
	time_t modify_time = 0;
	struct stat _tmp2_;
	time_t now = 0;
	time_t _tmp3_;
	struct stat _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (max_age == ((gdouble) 0)) {
		result = FALSE;
		return result;
	}
	if (!g_file_test (filename, G_FILE_TEST_IS_REGULAR)) {
		result = TRUE;
		return result;
	}
	memset (&buf, 0, sizeof (struct stat));
	_tmp1_ = stat (filename, &_tmp0_);
	buf = _tmp0_;
	if (_tmp1_ == -1) {
		result = TRUE;
		return result;
	}
	_tmp2_ = buf;
	modify_time = _tmp2_.st_mtime;
	_tmp3_ = time (NULL);
	now = _tmp3_;
	if (((gdouble) (now - modify_time)) > max_age) {
		result = TRUE;
		return result;
	}
	_tmp4_ = buf;
	if (_tmp4_.st_size == ((gsize) 0)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
abstract_currency_provider_real_download_file_sync (AbstractCurrencyProvider* self,
                                                    const gchar* uri,
                                                    const gchar* filename,
                                                    const gchar* source)
{
	gchar* directory = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = g_path_get_dirname (filename);
	directory = _tmp0_;
	_tmp1_ = directory;
	g_mkdir_with_parents (_tmp1_, 0755);
	{
		GFile* dest = NULL;
		GFile* _tmp2_;
		SoupSession* session = NULL;
		SoupSession* _tmp3_;
		SoupMessage* message = NULL;
		SoupMessage* _tmp4_;
		GFileOutputStream* output = NULL;
		GFile* _tmp5_;
		GFileOutputStream* _tmp6_;
		SoupSession* _tmp7_;
		SoupMessage* _tmp8_;
		GFileOutputStream* _tmp9_;
		GCancellable* _tmp10_;
		GCancellable* _tmp11_;
		_tmp2_ = g_file_new_for_path (filename);
		dest = _tmp2_;
		_tmp3_ = soup_session_new ();
		session = _tmp3_;
		_tmp4_ = soup_message_new ("GET", uri);
		message = _tmp4_;
		_tmp5_ = dest;
		_tmp6_ = g_file_replace (_tmp5_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		output = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_object_unref0 (dest);
			goto __catch0_g_error;
		}
		_tmp7_ = session;
		_tmp8_ = message;
		_tmp9_ = output;
		_tmp10_ = g_cancellable_new ();
		_tmp11_ = _tmp10_;
		soup_session_send_and_splice (_tmp7_, _tmp8_, (GOutputStream*) _tmp9_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, _tmp11_, &_inner_error0_);
		_g_object_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (output);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_object_unref0 (dest);
			goto __catch0_g_error;
		}
		self->loading = FALSE;
		abstract_currency_provider_do_load_rates (self);
		g_debug ("currency-provider.vala:178: %s rates updated", source);
		_g_object_unref0 (output);
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_object_unref0 (dest);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("currency-provider.vala:182: Couldn't download %s currency rate file: %" \
"s", source, _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (directory);
}

void
abstract_currency_provider_download_file_sync (AbstractCurrencyProvider* self,
                                               const gchar* uri,
                                               const gchar* filename,
                                               const gchar* source)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_sync) {
		_klass_->download_file_sync (self, uri, filename, source);
	}
}

static void
abstract_currency_provider_real_download_file_async_data_free (gpointer _data)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (AbstractCurrencyProviderDownloadFileAsyncData, _data_);
}

static void
abstract_currency_provider_real_download_file_async (AbstractCurrencyProvider* self,
                                                     const gchar* uri,
                                                     const gchar* filename,
                                                     const gchar* source,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	AbstractCurrencyProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (AbstractCurrencyProviderDownloadFileAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, abstract_currency_provider_real_download_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	_tmp3_ = g_strdup (source);
	_g_free0 (_data_->source);
	_data_->source = _tmp3_;
	abstract_currency_provider_real_download_file_async_co (_data_);
}

static void
abstract_currency_provider_real_download_file_finish (AbstractCurrencyProvider* self,
                                                      GAsyncResult* _res_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
abstract_currency_provider_download_file_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	abstract_currency_provider_real_download_file_async_co (_data_);
}

static gboolean
abstract_currency_provider_real_download_file_async_co (AbstractCurrencyProviderDownloadFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_path_get_dirname (_data_->filename);
	_data_->directory = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp1_, 0755);
	{
		_data_->_tmp2_ = g_file_new_for_path (_data_->filename);
		_data_->dest = _data_->_tmp2_;
		_data_->_tmp3_ = soup_session_new ();
		_data_->session = _data_->_tmp3_;
		_data_->_tmp4_ = soup_message_new ("GET", _data_->uri);
		_data_->message = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->dest;
		_data_->_state_ = 1;
		g_file_replace_async (_data_->_tmp5_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, abstract_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = g_file_replace_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->output = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->session);
			_g_object_unref0 (_data_->dest);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->session;
		_data_->_tmp8_ = _data_->message;
		_data_->_tmp9_ = _data_->output;
		_data_->_tmp10_ = g_cancellable_new ();
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 2;
		soup_session_send_and_splice_async (_data_->_tmp7_, _data_->_tmp8_, (GOutputStream*) _data_->_tmp9_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, _data_->_tmp11_, abstract_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_2:
		soup_session_send_and_splice_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp11_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->session);
			_g_object_unref0 (_data_->dest);
			goto __catch0_g_error;
		}
		_data_->self->loading = FALSE;
		abstract_currency_provider_do_load_rates (_data_->self);
		g_debug ("currency-provider.vala:203: %s rates updated", _data_->source);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->dest);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("currency-provider.vala:207: Couldn't download %s currency rate file: %" \
"s", _data_->source, _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
abstract_currency_provider_download_file_async (AbstractCurrencyProvider* self,
                                                const gchar* uri,
                                                const gchar* filename,
                                                const gchar* source,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	AbstractCurrencyProviderClass* _klass_;
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_async) {
		_klass_->download_file_async (self, uri, filename, source, _callback_, _user_data_);
	}
}

void
abstract_currency_provider_download_file_finish (AbstractCurrencyProvider* self,
                                                 GAsyncResult* _res_)
{
	AbstractCurrencyProviderClass* _klass_;
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_finish) {
		_klass_->download_file_finish (self, _res_);
	}
}

AbstractCurrencyProvider*
abstract_currency_provider_construct (GType object_type)
{
	AbstractCurrencyProvider * self = NULL;
	self = (AbstractCurrencyProvider*) g_object_new (object_type, NULL);
	return self;
}

gchar*
abstract_currency_provider_get_attribution_link (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_attribution_link) {
		return _klass_->get_attribution_link (self);
	}
	return NULL;
}

const gchar*
abstract_currency_provider_get_provider_name (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_provider_name) {
		return _klass_->get_provider_name (self);
	}
	return NULL;
}

gchar*
abstract_currency_provider_get_rate_filepath (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_rate_filepath) {
		return _klass_->get_rate_filepath (self);
	}
	return NULL;
}

gchar*
abstract_currency_provider_get_rate_source_url (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_rate_source_url) {
		return _klass_->get_rate_source_url (self);
	}
	return NULL;
}

gchar*
abstract_currency_provider_get_source_name (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_source_name) {
		return _klass_->get_source_name (self);
	}
	return NULL;
}

const gchar*
abstract_currency_provider_get_base_currency_symbol (AbstractCurrencyProvider* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_currency_symbol;
	result = _tmp0_;
	return result;
}

void
abstract_currency_provider_set_base_currency_symbol (AbstractCurrencyProvider* self,
                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = abstract_currency_provider_get_base_currency_symbol (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_base_currency_symbol);
		self->priv->_base_currency_symbol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_BASE_CURRENCY_SYMBOL_PROPERTY]);
	}
}

static gint
abstract_currency_provider_real_get_refresh_interval (CurrencyProvider* base)
{
	gint result;
	AbstractCurrencyProvider* self;
	self = (AbstractCurrencyProvider*) base;
	result = self->priv->_refresh_interval;
	return result;
}

static void
abstract_currency_provider_real_set_refresh_interval (CurrencyProvider* base,
                                                      gint value)
{
	AbstractCurrencyProvider* self;
	gint old_value;
	self = (AbstractCurrencyProvider*) base;
	old_value = abstract_currency_provider_real_get_refresh_interval (base);
	if (old_value != value) {
		self->priv->_refresh_interval = value;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY]);
	}
}

static gboolean
abstract_currency_provider_real_get_loaded (CurrencyProvider* base)
{
	gboolean result;
	AbstractCurrencyProvider* self;
	self = (AbstractCurrencyProvider*) base;
	result = self->priv->_loaded;
	return result;
}

static void
abstract_currency_provider_real_set_loaded (CurrencyProvider* base,
                                            gboolean value)
{
	AbstractCurrencyProvider* self;
	gboolean old_value;
	self = (AbstractCurrencyProvider*) base;
	old_value = abstract_currency_provider_real_get_loaded (base);
	if (old_value != value) {
		self->priv->_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_LOADED_PROPERTY]);
	}
}

CurrencyManager*
abstract_currency_provider_get_currency_manager (AbstractCurrencyProvider* self)
{
	CurrencyManager* result;
	CurrencyManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	result = _tmp0_;
	return result;
}

static void
abstract_currency_provider_set_currency_manager (AbstractCurrencyProvider* self,
                                                 CurrencyManager* value)
{
	CurrencyManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = abstract_currency_provider_get_currency_manager (self);
	if (old_value != value) {
		CurrencyManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_currency_manager);
		self->priv->_currency_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY]);
	}
}

static void
abstract_currency_provider_class_init (AbstractCurrencyProviderClass * klass,
                                       gpointer klass_data)
{
	abstract_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AbstractCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->parse_date = (GDateTime* (*) (AbstractCurrencyProvider*, const gchar*)) abstract_currency_provider_real_parse_date;
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (gboolean (*) (AbstractCurrencyProvider*)) abstract_currency_provider_real_do_load_rates;
	((AbstractCurrencyProviderClass *) klass)->download_file_sync = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*)) abstract_currency_provider_real_download_file_sync;
	((AbstractCurrencyProviderClass *) klass)->download_file_async = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*, GAsyncReadyCallback, gpointer)) abstract_currency_provider_real_download_file_async;
	((AbstractCurrencyProviderClass *) klass)->download_file_finish = (void (*) (AbstractCurrencyProvider*, GAsyncResult*)) abstract_currency_provider_real_download_file_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_abstract_currency_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_abstract_currency_provider_set_property;
	G_OBJECT_CLASS (klass)->finalize = abstract_currency_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_BASE_CURRENCY_SYMBOL_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_BASE_CURRENCY_SYMBOL_PROPERTY] = g_param_spec_string ("base-currency-symbol", "base-currency-symbol", "base-currency-symbol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY] = g_param_spec_int ("refresh-interval", "refresh-interval", "refresh-interval", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_LOADED_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY] = g_param_spec_object ("currency-manager", "currency-manager", "currency-manager", TYPE_CURRENCY_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
abstract_currency_provider_currency_provider_interface_init (CurrencyProviderIface * iface,
                                                             gpointer iface_data)
{
	abstract_currency_provider_currency_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->clear = (void (*) (CurrencyProvider*)) abstract_currency_provider_real_clear;
	iface->parse_date = (GDateTime* (*) (CurrencyProvider*, const gchar*)) abstract_currency_provider_parse_date;
	iface->update_rates = (void (*) (CurrencyProvider*, gboolean, gboolean)) abstract_currency_provider_real_update_rates;
	iface->get_attribution_link = (gchar* (*) (CurrencyProvider*)) abstract_currency_provider_get_attribution_link;
	iface->get_provider_name = (const gchar* (*) (CurrencyProvider*)) abstract_currency_provider_get_provider_name;
	iface->get_refresh_interval = abstract_currency_provider_real_get_refresh_interval;
	iface->set_refresh_interval = abstract_currency_provider_real_set_refresh_interval;
	iface->get_loaded = abstract_currency_provider_real_get_loaded;
	iface->set_loaded = abstract_currency_provider_real_set_loaded;
}

static void
abstract_currency_provider_instance_init (AbstractCurrencyProvider * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	self->priv = abstract_currency_provider_get_instance_private (self);
	_tmp0_ = g_strdup ("Jan");
	_tmp1_ = g_strdup ("Feb");
	_tmp2_ = g_strdup ("Mar");
	_tmp3_ = g_strdup ("Apr");
	_tmp4_ = g_strdup ("May");
	_tmp5_ = g_strdup ("Jun");
	_tmp6_ = g_strdup ("Jul");
	_tmp7_ = g_strdup ("Aug");
	_tmp8_ = g_strdup ("Sep");
	_tmp9_ = g_strdup ("Oct");
	_tmp10_ = g_strdup ("Nov");
	_tmp11_ = g_strdup ("Dec");
	_tmp12_ = g_new0 (gchar*, 12 + 1);
	_tmp12_[0] = _tmp0_;
	_tmp12_[1] = _tmp1_;
	_tmp12_[2] = _tmp2_;
	_tmp12_[3] = _tmp3_;
	_tmp12_[4] = _tmp4_;
	_tmp12_[5] = _tmp5_;
	_tmp12_[6] = _tmp6_;
	_tmp12_[7] = _tmp7_;
	_tmp12_[8] = _tmp8_;
	_tmp12_[9] = _tmp9_;
	_tmp12_[10] = _tmp10_;
	_tmp12_[11] = _tmp11_;
	self->MONTHS_ABBREVIATED = _tmp12_;
	self->MONTHS_ABBREVIATED_length1 = 12;
	_tmp13_ = g_strdup ("January");
	_tmp14_ = g_strdup ("February");
	_tmp15_ = g_strdup ("March");
	_tmp16_ = g_strdup ("April");
	_tmp17_ = g_strdup ("May");
	_tmp18_ = g_strdup ("June");
	_tmp19_ = g_strdup ("July");
	_tmp20_ = g_strdup ("August");
	_tmp21_ = g_strdup ("September");
	_tmp22_ = g_strdup ("October");
	_tmp23_ = g_strdup ("November");
	_tmp24_ = g_strdup ("December");
	_tmp25_ = g_new0 (gchar*, 12 + 1);
	_tmp25_[0] = _tmp13_;
	_tmp25_[1] = _tmp14_;
	_tmp25_[2] = _tmp15_;
	_tmp25_[3] = _tmp16_;
	_tmp25_[4] = _tmp17_;
	_tmp25_[5] = _tmp18_;
	_tmp25_[6] = _tmp19_;
	_tmp25_[7] = _tmp20_;
	_tmp25_[8] = _tmp21_;
	_tmp25_[9] = _tmp22_;
	_tmp25_[10] = _tmp23_;
	_tmp25_[11] = _tmp24_;
	self->MONTHS_FULL = _tmp25_;
	self->MONTHS_FULL_length1 = 12;
	self->update_callback = (guint) 0;
}

static void
abstract_currency_provider_finalize (GObject * obj)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	_g_free0 (self->priv->_base_currency_symbol);
	self->MONTHS_ABBREVIATED = (_vala_array_free (self->MONTHS_ABBREVIATED, self->MONTHS_ABBREVIATED_length1, (GDestroyNotify) g_free), NULL);
	self->MONTHS_FULL = (_vala_array_free (self->MONTHS_FULL, self->MONTHS_FULL_length1, (GDestroyNotify) g_free), NULL);
	(self->currencies == NULL) ? NULL : (self->currencies = (_g_list_free__g_object_unref0_ (self->currencies), NULL));
	_g_object_unref0 (self->priv->_currency_manager);
	G_OBJECT_CLASS (abstract_currency_provider_parent_class)->finalize (obj);
}

static GType
abstract_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AbstractCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) abstract_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbstractCurrencyProvider), 0, (GInstanceInitFunc) abstract_currency_provider_instance_init, NULL };
	static const GInterfaceInfo currency_provider_info = { (GInterfaceInitFunc) abstract_currency_provider_currency_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType abstract_currency_provider_type_id;
	abstract_currency_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "AbstractCurrencyProvider", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (abstract_currency_provider_type_id, TYPE_CURRENCY_PROVIDER, &currency_provider_info);
	AbstractCurrencyProvider_private_offset = g_type_add_instance_private (abstract_currency_provider_type_id, sizeof (AbstractCurrencyProviderPrivate));
	return abstract_currency_provider_type_id;
}

GType
abstract_currency_provider_get_type (void)
{
	static volatile gsize abstract_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&abstract_currency_provider_type_id__once)) {
		GType abstract_currency_provider_type_id;
		abstract_currency_provider_type_id = abstract_currency_provider_get_type_once ();
		g_once_init_leave (&abstract_currency_provider_type_id__once, abstract_currency_provider_type_id);
	}
	return abstract_currency_provider_type_id__once;
}

static void
_vala_abstract_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	switch (property_id) {
		case ABSTRACT_CURRENCY_PROVIDER_BASE_CURRENCY_SYMBOL_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_base_currency_symbol (self));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY:
		g_value_set_int (value, currency_provider_get_refresh_interval ((CurrencyProvider*) self));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_LOADED_PROPERTY:
		g_value_set_boolean (value, currency_provider_get_loaded ((CurrencyProvider*) self));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY:
		g_value_set_object (value, abstract_currency_provider_get_currency_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_abstract_currency_provider_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	switch (property_id) {
		case ABSTRACT_CURRENCY_PROVIDER_BASE_CURRENCY_SYMBOL_PROPERTY:
		abstract_currency_provider_set_base_currency_symbol (self, g_value_get_string (value));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY:
		currency_provider_set_refresh_interval ((CurrencyProvider*) self, g_value_get_int (value));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_LOADED_PROPERTY:
		currency_provider_set_loaded ((CurrencyProvider*) self, g_value_get_boolean (value));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY:
		abstract_currency_provider_set_currency_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

