/* gitg-files.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-files.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "files.h"
#include "libgitg-ext.h"
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include "libgitg.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <libgit2-glib/ggit.h>
#include <glib-object.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

#define GITG_FILES_PANEL_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_FILES_PANEL_0_PROPERTY,
	GITG_FILES_PANEL_APPLICATION_PROPERTY,
	GITG_FILES_PANEL_HISTORY_PROPERTY,
	GITG_FILES_PANEL_ID_PROPERTY,
	GITG_FILES_PANEL_AVAILABLE_PROPERTY,
	GITG_FILES_PANEL_DISPLAY_NAME_PROPERTY,
	GITG_FILES_PANEL_DESCRIPTION_PROPERTY,
	GITG_FILES_PANEL_ICON_PROPERTY,
	GITG_FILES_PANEL_WIDGET_PROPERTY,
	GITG_FILES_PANEL_ENABLED_PROPERTY,
	GITG_FILES_PANEL_NUM_PROPERTIES
};
static GParamSpec* gitg_files_panel_properties[GITG_FILES_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gitg_when_mapped_unref0(var) ((var == NULL) ? NULL : (var = (gitg_when_mapped_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

struct _GitgFilesPanelPrivate {
	GitgExtApplication* _application;
	GitgExtHistory* _history;
	GitgFilesTreeStore* d_model;
	GtkPaned* d_paned;
	GtkSourceView* d_source;
	GSettings* d_stylesettings;
	GtkScrolledWindow* d_scrolled_files;
	GtkScrolledWindow* d_scrolled;
	GtkViewport* d_imagevp;
	GtkImage* d_image;
	GitgWhenMapped* d_whenMapped;
	GitgFontManager* d_font_manager;
};

struct _Block1Data {
	int _ref_count_;
	GitgFilesPanel* self;
	GgitCommit* commit;
};

struct _Block2Data {
	int _ref_count_;
	GitgFilesPanel* self;
	GtkTreeView* tv;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GtkTreePath* path;
};

static gint GitgFilesPanel_private_offset;
static gpointer gitg_files_panel_parent_class = NULL;
static GitgExtUIElementIface * gitg_files_panel_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtHistoryPanelIface * gitg_files_panel_gitg_ext_history_panel_parent_iface = NULL;
static GType gitg_files_panel_type_id = 0;

static void gitg_files_panel_on_selection_changed (GitgFilesPanel* self,
                                            GitgExtHistory* history);
static gboolean __lambda7_ (GitgFilesPanel* self,
                     GgitCommit* commit);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda8_ (Block1Data* _data1_);
static void ___lambda8__gitg_when_mapped_on_mapped (gpointer self);
static gboolean ___lambda7__gitg_ext_foreach_commit_selection_func (GgitCommit* object,
                                                             gpointer self);
static void gitg_files_panel_update_style (GitgFilesPanel* self);
static GSettings* gitg_files_panel_try_settings (GitgFilesPanel* self,
                                          const gchar* schema_id);
static void gitg_files_panel_build_ui (GitgFilesPanel* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void gitg_files_panel_selection_changed (GitgFilesPanel* self,
                                         GtkTreeSelection* selection);
static void _gitg_files_panel_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                     gpointer self);
static void gitg_files_panel_open_file_externally (GitgFilesPanel* self,
                                            GtkTreePath* path,
                                            GtkTreeViewColumn* column);
static void _gitg_files_panel_open_file_externally_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                         GtkTreePath* path,
                                                                         GtkTreeViewColumn* column,
                                                                         gpointer self);
static gboolean __lambda9_ (Block2Data* _data2_,
                     GdkEventButton* event);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void block3_data_unref (void * _userdata_);
static void ___lambda10_ (Block3Data* _data3_);
static void ____lambda10__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static gboolean ___lambda9__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void ___lambda11_ (GitgFilesPanel* self,
                   GSettings* s,
                   const gchar* k);
static void ____lambda11__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void gitg_files_panel_set_viewer (GitgFilesPanel* self,
                                  GtkWidget* wid);
static void _vala_GgitOId_free (GgitOId* self);
static gint gitg_files_panel_real_negotiate_order (GitgExtUIElement* base,
                                            GitgExtUIElement* other);
static guint* _uint_dup (guint* self);
static GObject * gitg_files_panel_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _gitg_files_panel_on_selection_changed_gitg_ext_history_selection_changed (GitgExtHistory* _sender,
                                                                                gpointer self);
static void gitg_files_panel_finalize (GObject * obj);
static void _vala_gitg_files_panel_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_gitg_files_panel_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
GType gitg_files_tree_store_register_type (GTypeModule * module);

static inline gpointer
gitg_files_panel_get_instance_private (GitgFilesPanel* self)
{
	return G_STRUCT_MEMBER_P (self, GitgFilesPanel_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GitgFilesPanel* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->commit);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda8_ (Block1Data* _data1_)
{
	GitgFilesPanel* self;
	GitgFilesTreeStore* _tmp0_;
	GgitTree* _tmp1_;
	GgitTree* _tmp2_;
	self = _data1_->self;
	_tmp0_ = self->priv->d_model;
	_tmp1_ = ggit_commit_get_tree (_data1_->commit);
	_tmp2_ = _tmp1_;
	gitg_files_tree_store_set_tree (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
___lambda8__gitg_when_mapped_on_mapped (gpointer self)
{
	__lambda8_ (self);
}

static gboolean
__lambda7_ (GitgFilesPanel* self,
            GgitCommit* commit)
{
	Block1Data* _data1_;
	GgitCommit* _tmp0_;
	GitgWhenMapped* _tmp1_;
	gboolean result;
	g_return_val_if_fail (commit != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (commit);
	_g_object_unref0 (_data1_->commit);
	_data1_->commit = _tmp0_;
	_tmp1_ = self->priv->d_whenMapped;
	gitg_when_mapped_update (_tmp1_, ___lambda8__gitg_when_mapped_on_mapped, block1_data_ref (_data1_), block1_data_unref, (GObject*) self);
	result = FALSE;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static gboolean
___lambda7__gitg_ext_foreach_commit_selection_func (GgitCommit* object,
                                                    gpointer self)
{
	gboolean result;
	result = __lambda7_ ((GitgFilesPanel*) self, object);
	return result;
}

static void
gitg_files_panel_on_selection_changed (GitgFilesPanel* self,
                                       GitgExtHistory* history)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (history != NULL);
	gitg_ext_history_foreach_selected (history, ___lambda7__gitg_ext_foreach_commit_selection_func, self);
}

static void
gitg_files_panel_update_style (GitgFilesPanel* self)
{
	gchar* scheme = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GtkSourceStyleSchemeManager* manager = NULL;
	GtkSourceStyleSchemeManager* _tmp2_;
	GtkSourceStyleSchemeManager* _tmp3_;
	GtkSourceStyleScheme* s = NULL;
	GtkSourceStyleSchemeManager* _tmp4_;
	const gchar* _tmp5_;
	GtkSourceStyleScheme* _tmp6_;
	GtkSourceStyleScheme* _tmp7_;
	GtkSourceStyleScheme* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_stylesettings;
	_tmp1_ = g_settings_get_string (_tmp0_, "style-scheme");
	scheme = _tmp1_;
	_tmp2_ = gtk_source_style_scheme_manager_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	manager = _tmp3_;
	_tmp4_ = manager;
	_tmp5_ = scheme;
	_tmp6_ = gtk_source_style_scheme_manager_get_scheme (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	s = _tmp7_;
	_tmp8_ = s;
	if (_tmp8_ != NULL) {
		GtkSourceBuffer* buf = NULL;
		GtkSourceView* _tmp9_;
		GtkTextBuffer* _tmp10_;
		GtkSourceBuffer* _tmp11_;
		GtkSourceBuffer* _tmp12_;
		GtkSourceStyleScheme* _tmp13_;
		_tmp9_ = self->priv->d_source;
		_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp9_);
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp10_) : NULL);
		buf = _tmp11_;
		_tmp12_ = buf;
		_tmp13_ = s;
		gtk_source_buffer_set_style_scheme (_tmp12_, _tmp13_);
		_g_object_unref0 (buf);
	}
	_g_object_unref0 (s);
	_g_object_unref0 (manager);
	_g_free0 (scheme);
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static GSettings*
gitg_files_panel_try_settings (GitgFilesPanel* self,
                               const gchar* schema_id)
{
	GSettingsSchemaSource* source = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSettingsSchema* _tmp4_;
	GSettingsSchema* _tmp5_;
	gboolean _tmp6_;
	GSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (schema_id != NULL, NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	source = _tmp1_;
	_tmp2_ = source;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_settings_schema_source_unref0 (source);
		return result;
	}
	_tmp3_ = source;
	_tmp4_ = g_settings_schema_source_lookup (_tmp3_, schema_id, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_settings_schema_unref0 (_tmp5_);
	if (_tmp6_) {
		GSettings* _tmp7_;
		_tmp7_ = g_settings_new (schema_id);
		result = _tmp7_;
		_g_settings_schema_source_unref0 (source);
		return result;
	}
	result = NULL;
	_g_settings_schema_source_unref0 (source);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GitgFilesPanel* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->tv);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_gitg_files_panel_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                gpointer self)
{
	gitg_files_panel_selection_changed ((GitgFilesPanel*) self, _sender);
}

static void
_gitg_files_panel_open_file_externally_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                    GtkTreePath* path,
                                                                    GtkTreeViewColumn* column,
                                                                    gpointer self)
{
	gitg_files_panel_open_file_externally ((GitgFilesPanel*) self, path, column);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GitgFilesPanel* self;
		self = _data3_->_data2_->self;
		__vala_GtkTreePath_free0 (_data3_->path);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda10_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	GitgFilesPanel* self;
	GtkTreePath* _tmp0_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data3_->path;
	gitg_files_panel_open_file_externally (self, _tmp0_, NULL);
}

static void
____lambda10__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda10_ (self);
}

static gboolean
__lambda9_ (Block2Data* _data2_,
            GdkEventButton* event)
{
	GitgFilesPanel* self;
	GdkEvent* ev = NULL;
	GdkEvent* _tmp0_;
	gboolean result;
	self = _data2_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	ev = (GdkEvent*) event;
	_tmp0_ = ev;
	if (gdk_event_triggers_context_menu (_tmp0_)) {
		Block3Data* _data3_;
		GtkTreeView* _tmp1_;
		GtkTreePath* _tmp2_ = NULL;
		GtkTreeView* _tmp3_;
		GtkTreeSelection* _tmp4_;
		GtkTreePath* _tmp5_;
		GtkMenu* menu = NULL;
		GtkMenu* _tmp6_;
		GtkMenuItem* menu_item = NULL;
		GtkMenuItem* _tmp7_;
		GtkMenuItem* _tmp8_;
		GtkMenu* _tmp9_;
		GtkTreeView* _tmp10_;
		GtkMenu* _tmp11_;
		GtkMenuItem* _tmp12_;
		GtkMenu* _tmp13_;
		GtkMenu* _tmp14_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp1_ = _data2_->tv;
		gtk_tree_view_get_path_at_pos (_tmp1_, (gint) event->x, (gint) event->y, &_tmp2_, NULL, NULL, NULL);
		__vala_GtkTreePath_free0 (_data3_->path);
		_data3_->path = _tmp2_;
		_tmp3_ = _data2_->tv;
		_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
		_tmp5_ = _data3_->path;
		gtk_tree_selection_select_path (_tmp4_, _tmp5_);
		_tmp6_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp6_);
		menu = _tmp6_;
		_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Open externally");
		g_object_ref_sink (_tmp7_);
		menu_item = _tmp7_;
		_tmp8_ = menu_item;
		g_signal_connect_data (_tmp8_, "activate", (GCallback) ____lambda10__gtk_menu_item_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp9_ = menu;
		_tmp10_ = _data2_->tv;
		gtk_menu_attach_to_widget (_tmp9_, (GtkWidget*) _tmp10_, NULL);
		_tmp11_ = menu;
		_tmp12_ = menu_item;
		gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
		_tmp13_ = menu;
		gtk_widget_show_all ((GtkWidget*) _tmp13_);
		_tmp14_ = menu;
		gtk_menu_popup_at_pointer (_tmp14_, (GdkEvent*) event);
		result = TRUE;
		_g_object_unref0 (menu_item);
		_g_object_unref0 (menu);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda9_ (self, event);
	return result;
}

static void
___lambda11_ (GitgFilesPanel* self,
              GSettings* s,
              const gchar* k)
{
	g_return_if_fail (s != NULL);
	g_return_if_fail (k != NULL);
	gitg_files_panel_update_style (self);
}

static void
____lambda11__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda11_ ((GitgFilesPanel*) self, _sender, key);
}

static void
gitg_files_panel_build_ui (GitgFilesPanel* self)
{
	Block2Data* _data2_;
	GeeHashMap* ret = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GObject* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreeView* _tmp5_;
	GitgFilesTreeStore* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	GeeHashMap* _tmp11_;
	gpointer _tmp12_;
	GObject* _tmp13_;
	GtkScrolledWindow* _tmp14_;
	GeeHashMap* _tmp15_;
	gpointer _tmp16_;
	GObject* _tmp17_;
	GtkSourceView* _tmp18_;
	GeeHashMap* _tmp19_;
	gpointer _tmp20_;
	GObject* _tmp21_;
	GtkPaned* _tmp22_;
	GeeHashMap* _tmp23_;
	gpointer _tmp24_;
	GObject* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkSourceView* _tmp27_;
	GitgFontManager* _tmp28_;
	GtkViewport* _tmp29_;
	GtkImage* _tmp30_;
	GtkViewport* _tmp31_;
	GtkImage* _tmp32_;
	GtkViewport* _tmp33_;
	GSettings* _tmp34_;
	GSettings* _tmp35_;
	GtkPaned* _tmp45_;
	GitgWhenMapped* _tmp46_;
	GitgExtHistory* _tmp47_;
	GitgExtHistory* _tmp48_;
	GitgExtHistory* _tmp49_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = gitg_ext_ui_from_builder ("files/view-files.ui", "paned_files", "scrolled_window_files", "tree_view_files", "source_view_file", "scrolled_window_file", NULL);
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, "tree_view_files");
	_tmp3_ = (GObject*) _tmp2_;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_tree_view_get_type ()) ? ((GtkTreeView*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	_data2_->tv = _tmp4_;
	_tmp5_ = _data2_->tv;
	_tmp6_ = self->priv->d_model;
	gtk_tree_view_set_model (_tmp5_, (GtkTreeModel*) _tmp6_);
	_tmp7_ = _data2_->tv;
	_tmp8_ = gtk_tree_view_get_selection (_tmp7_);
	g_signal_connect_object (_tmp8_, "changed", (GCallback) _gitg_files_panel_selection_changed_gtk_tree_selection_changed, self, 0);
	_tmp9_ = _data2_->tv;
	g_signal_connect_object (_tmp9_, "row-activated", (GCallback) _gitg_files_panel_open_file_externally_gtk_tree_view_row_activated, self, 0);
	_tmp10_ = _data2_->tv;
	g_signal_connect_data ((GtkWidget*) _tmp10_, "button-press-event", (GCallback) ___lambda9__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp11_ = ret;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, "scrolled_window_files");
	_tmp13_ = (GObject*) _tmp12_;
	_tmp14_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_scrolled_window_get_type ()) ? ((GtkScrolledWindow*) _tmp13_) : NULL;
	if (_tmp14_ == NULL) {
		_g_object_unref0 (_tmp13_);
	}
	_g_object_unref0 (self->priv->d_scrolled_files);
	self->priv->d_scrolled_files = _tmp14_;
	_tmp15_ = ret;
	_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, "source_view_file");
	_tmp17_ = (GObject*) _tmp16_;
	_tmp18_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_source_view_get_type ()) ? ((GtkSourceView*) _tmp17_) : NULL;
	if (_tmp18_ == NULL) {
		_g_object_unref0 (_tmp17_);
	}
	_g_object_unref0 (self->priv->d_source);
	self->priv->d_source = _tmp18_;
	_tmp19_ = ret;
	_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, "paned_files");
	_tmp21_ = (GObject*) _tmp20_;
	_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_paned_get_type ()) ? ((GtkPaned*) _tmp21_) : NULL;
	if (_tmp22_ == NULL) {
		_g_object_unref0 (_tmp21_);
	}
	_g_object_unref0 (self->priv->d_paned);
	self->priv->d_paned = _tmp22_;
	_tmp23_ = ret;
	_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, "scrolled_window_file");
	_tmp25_ = (GObject*) _tmp24_;
	_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_scrolled_window_get_type ()) ? ((GtkScrolledWindow*) _tmp25_) : NULL;
	if (_tmp26_ == NULL) {
		_g_object_unref0 (_tmp25_);
	}
	_g_object_unref0 (self->priv->d_scrolled);
	self->priv->d_scrolled = _tmp26_;
	_tmp27_ = self->priv->d_source;
	_tmp28_ = gitg_font_manager_new ((GtkTextView*) _tmp27_, TRUE);
	_g_object_unref0 (self->priv->d_font_manager);
	self->priv->d_font_manager = _tmp28_;
	_tmp29_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->d_imagevp);
	self->priv->d_imagevp = _tmp29_;
	_tmp30_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->d_image);
	self->priv->d_image = _tmp30_;
	_tmp31_ = self->priv->d_imagevp;
	_tmp32_ = self->priv->d_image;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->d_imagevp;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = gitg_files_panel_try_settings (self, APPLICATION_ID ".preferences.interface");
	_g_object_unref0 (self->priv->d_stylesettings);
	self->priv->d_stylesettings = _tmp34_;
	_tmp35_ = self->priv->d_stylesettings;
	if (_tmp35_ != NULL) {
		GSettings* _tmp36_;
		_tmp36_ = self->priv->d_stylesettings;
		g_signal_connect_object (_tmp36_, "changed::style-scheme", (GCallback) ____lambda11__g_settings_changed, self, 0);
		gitg_files_panel_update_style (self);
	} else {
		GtkSourceBuffer* buf = NULL;
		GtkSourceView* _tmp37_;
		GtkTextBuffer* _tmp38_;
		GtkSourceBuffer* _tmp39_;
		GtkSourceStyleSchemeManager* style_scheme_manager = NULL;
		GtkSourceStyleSchemeManager* _tmp40_;
		GtkSourceStyleSchemeManager* _tmp41_;
		GtkSourceBuffer* _tmp42_;
		GtkSourceStyleSchemeManager* _tmp43_;
		GtkSourceStyleScheme* _tmp44_;
		_tmp37_ = self->priv->d_source;
		_tmp38_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp37_);
		_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp38_) : NULL);
		buf = _tmp39_;
		_tmp40_ = gtk_source_style_scheme_manager_get_default ();
		_tmp41_ = _g_object_ref0 (_tmp40_);
		style_scheme_manager = _tmp41_;
		_tmp42_ = buf;
		_tmp43_ = style_scheme_manager;
		_tmp44_ = gtk_source_style_scheme_manager_get_scheme (_tmp43_, "classic");
		gtk_source_buffer_set_style_scheme (_tmp42_, _tmp44_);
		_g_object_unref0 (style_scheme_manager);
		_g_object_unref0 (buf);
	}
	_tmp45_ = self->priv->d_paned;
	_tmp46_ = gitg_when_mapped_new ((GtkWidget*) _tmp45_);
	_gitg_when_mapped_unref0 (self->priv->d_whenMapped);
	self->priv->d_whenMapped = _tmp46_;
	_tmp47_ = gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = _tmp48_;
	gitg_files_panel_on_selection_changed (self, _tmp49_);
	_g_object_unref0 (_tmp49_);
	_g_object_unref0 (ret);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
gitg_files_panel_set_viewer (GitgFilesPanel* self,
                             GtkWidget* wid)
{
	GtkWidget* child = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_scrolled;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	child = _tmp2_;
	_tmp3_ = child;
	if (_tmp3_ != wid) {
		GtkWidget* _tmp4_;
		_tmp4_ = child;
		if (_tmp4_ != NULL) {
			GtkScrolledWindow* _tmp5_;
			GtkScrolledWindow* _tmp6_;
			GtkWidget* _tmp7_;
			_tmp5_ = self->priv->d_scrolled;
			_tmp6_ = self->priv->d_scrolled;
			_tmp7_ = gtk_bin_get_child ((GtkBin*) _tmp6_);
			gtk_container_remove ((GtkContainer*) _tmp5_, _tmp7_);
		}
		if (wid != NULL) {
			GtkScrolledWindow* _tmp8_;
			_tmp8_ = self->priv->d_scrolled;
			gtk_container_add ((GtkContainer*) _tmp8_, wid);
		}
	}
	_g_object_unref0 (child);
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
gitg_files_panel_selection_changed (GitgFilesPanel* self,
                                    GtkTreeSelection* selection)
{
	GtkTreeModel* mod = NULL;
	GtkTreeIter iter = {0};
	GtkSourceBuffer* buf = NULL;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	GtkTreeModel* _tmp8_;
	GgitOId* id = NULL;
	GitgFilesTreeStore* _tmp12_;
	GtkTreeIter _tmp13_;
	GgitOId* _tmp14_;
	GgitBlob* blob = NULL;
	gchar* fname = NULL;
	GitgFilesTreeStore* _tmp27_;
	GtkTreeIter _tmp28_;
	gchar* _tmp29_;
	guint8* content = NULL;
	GgitBlob* _tmp30_;
	gsize _tmp31_ = 0;
	guint8* _tmp32_;
	gint content_length1;
	gint _content_size_;
	gchar* ct = NULL;
	const gchar* _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	GtkWidget* wid = NULL;
	const gchar* _tmp36_;
	GtkWidget* _tmp65_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_tmp0_ = self->priv->d_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp1_) : NULL);
	buf = _tmp2_;
	_tmp3_ = buf;
	gtk_text_buffer_set_text ((GtkTextBuffer*) _tmp3_, "", -1);
	_tmp7_ = gtk_tree_selection_get_selected (selection, &_tmp5_, &_tmp6_);
	_g_object_unref0 (mod);
	_tmp8_ = _g_object_ref0 (_tmp5_);
	mod = _tmp8_;
	iter = _tmp6_;
	if (!_tmp7_) {
		_tmp4_ = TRUE;
	} else {
		GitgFilesTreeStore* _tmp9_;
		GtkTreeIter _tmp10_;
		_tmp9_ = self->priv->d_model;
		_tmp10_ = iter;
		_tmp4_ = gitg_files_tree_store_get_isdir (_tmp9_, &_tmp10_);
	}
	if (_tmp4_) {
		GtkSourceView* _tmp11_;
		_tmp11_ = self->priv->d_source;
		gitg_files_panel_set_viewer (self, (GtkWidget*) _tmp11_);
		_g_object_unref0 (buf);
		_g_object_unref0 (mod);
		return;
	}
	_tmp12_ = self->priv->d_model;
	_tmp13_ = iter;
	_tmp14_ = gitg_files_tree_store_get_id (_tmp12_, &_tmp13_);
	id = _tmp14_;
	{
		GgitBlob* _tmp15_ = NULL;
		GitgExtApplication* _tmp16_;
		GitgExtApplication* _tmp17_;
		GitgExtApplication* _tmp18_;
		GitgRepository* _tmp19_;
		GitgRepository* _tmp20_;
		GitgRepository* _tmp21_;
		GgitOId* _tmp22_;
		gpointer _tmp23_;
		GgitBlob* _tmp24_;
		GgitBlob* _tmp25_;
		_tmp16_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp19_ = gitg_ext_application_get_repository (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = id;
		_tmp23_ = gitg_repository_lookup (_tmp21_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp22_, &_inner_error0_);
		_tmp24_ = (GgitBlob*) _tmp23_;
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (_tmp18_);
		_tmp15_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp25_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (blob);
		blob = _tmp25_;
		_g_object_unref0 (_tmp15_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GtkSourceView* _tmp26_;
		g_clear_error (&_inner_error0_);
		_tmp26_ = self->priv->d_source;
		gitg_files_panel_set_viewer (self, (GtkWidget*) _tmp26_);
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		_g_object_unref0 (buf);
		_g_object_unref0 (mod);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		_g_object_unref0 (buf);
		_g_object_unref0 (mod);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp27_ = self->priv->d_model;
	_tmp28_ = iter;
	_tmp29_ = gitg_files_tree_store_get_full_path (_tmp27_, &_tmp28_);
	fname = _tmp29_;
	_tmp30_ = blob;
	_tmp32_ = ggit_blob_get_raw_content (_tmp30_, &_tmp31_);
	content = _tmp32_;
	content_length1 = _tmp31_;
	_content_size_ = content_length1;
	_tmp33_ = fname;
	_tmp34_ = content;
	_tmp34__length1 = content_length1;
	_tmp35_ = g_content_type_guess (_tmp33_, _tmp34_, (gsize) _tmp34__length1, NULL);
	ct = _tmp35_;
	wid = NULL;
	_tmp36_ = ct;
	if (g_content_type_is_a (_tmp36_, "image/*")) {
		GtkViewport* _tmp37_;
		GtkWidget* _tmp38_;
		gchar* mtype = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		GtkImage* _tmp41_;
		_tmp37_ = self->priv->d_imagevp;
		_tmp38_ = _g_object_ref0 ((GtkWidget*) _tmp37_);
		_g_object_unref0 (wid);
		wid = _tmp38_;
		_tmp39_ = ct;
		_tmp40_ = g_content_type_get_mime_type (_tmp39_);
		mtype = _tmp40_;
		_tmp41_ = self->priv->d_image;
		g_object_set (_tmp41_, "pixbuf", NULL, NULL);
		{
			GdkPixbufLoader* loader = NULL;
			const gchar* _tmp42_;
			GdkPixbufLoader* _tmp43_;
			gboolean _tmp44_ = FALSE;
			gboolean _tmp45_ = FALSE;
			GdkPixbufLoader* _tmp46_;
			guint8* _tmp47_;
			gint _tmp47__length1;
			_tmp42_ = mtype;
			_tmp43_ = gdk_pixbuf_loader_new_with_mime_type (_tmp42_, &_inner_error0_);
			loader = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp46_ = loader;
			_tmp47_ = content;
			_tmp47__length1 = content_length1;
			_tmp45_ = gdk_pixbuf_loader_write (_tmp46_, _tmp47_, (gsize) _tmp47__length1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (loader);
				goto __catch1_g_error;
			}
			if (_tmp45_) {
				gboolean _tmp48_ = FALSE;
				GdkPixbufLoader* _tmp49_;
				_tmp49_ = loader;
				_tmp48_ = gdk_pixbuf_loader_close (_tmp49_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (loader);
					goto __catch1_g_error;
				}
				_tmp44_ = _tmp48_;
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				GtkImage* _tmp50_;
				GdkPixbufLoader* _tmp51_;
				GdkPixbuf* _tmp52_;
				_tmp50_ = self->priv->d_image;
				_tmp51_ = loader;
				_tmp52_ = gdk_pixbuf_loader_get_pixbuf (_tmp51_);
				g_object_set (_tmp50_, "pixbuf", _tmp52_, NULL);
			}
			_g_object_unref0 (loader);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (mtype);
			_g_object_unref0 (wid);
			_g_free0 (ct);
			_g_free0 (fname);
			_g_object_unref0 (blob);
			__vala_GgitOId_free0 (id);
			_g_object_unref0 (buf);
			_g_object_unref0 (mod);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (mtype);
	} else {
		const gchar* _tmp53_;
		_tmp53_ = ct;
		if (g_content_type_is_a (_tmp53_, "text/plain")) {
			GtkSourceLanguageManager* manager = NULL;
			GtkSourceLanguageManager* _tmp54_;
			GtkSourceLanguageManager* _tmp55_;
			GtkSourceBuffer* _tmp56_;
			guint8* _tmp57_;
			gint _tmp57__length1;
			GtkSourceBuffer* _tmp58_;
			GtkSourceLanguageManager* _tmp59_;
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			GtkSourceLanguage* _tmp62_;
			GtkSourceView* _tmp63_;
			GtkWidget* _tmp64_;
			_tmp54_ = gtk_source_language_manager_get_default ();
			_tmp55_ = _g_object_ref0 (_tmp54_);
			manager = _tmp55_;
			_tmp56_ = buf;
			_tmp57_ = content;
			_tmp57__length1 = content_length1;
			gtk_text_buffer_set_text ((GtkTextBuffer*) _tmp56_, (const gchar*) _tmp57_, -1);
			_tmp58_ = buf;
			_tmp59_ = manager;
			_tmp60_ = fname;
			_tmp61_ = ct;
			_tmp62_ = gtk_source_language_manager_guess_language (_tmp59_, _tmp60_, _tmp61_);
			gtk_source_buffer_set_language (_tmp58_, _tmp62_);
			_tmp63_ = self->priv->d_source;
			_tmp64_ = _g_object_ref0 ((GtkWidget*) _tmp63_);
			_g_object_unref0 (wid);
			wid = _tmp64_;
			_g_object_unref0 (manager);
		}
	}
	_tmp65_ = wid;
	gitg_files_panel_set_viewer (self, _tmp65_);
	_g_object_unref0 (wid);
	_g_free0 (ct);
	_g_free0 (fname);
	_g_object_unref0 (blob);
	__vala_GgitOId_free0 (id);
	_g_object_unref0 (buf);
	_g_object_unref0 (mod);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_files_panel_open_file_externally (GitgFilesPanel* self,
                                       GtkTreePath* path,
                                       GtkTreeViewColumn* column)
{
	GtkTreeIter iter = {0};
	gboolean path_is_valid = FALSE;
	GitgFilesTreeStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	GgitOId* id = NULL;
	GitgFilesTreeStore* _tmp6_;
	GtkTreeIter _tmp7_;
	GgitOId* _tmp8_;
	GgitBlob* blob = NULL;
	guint8* content = NULL;
	GgitBlob* _tmp20_;
	gsize _tmp21_ = 0;
	guint8* _tmp22_;
	gint content_length1;
	gint _content_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->d_model;
	_tmp2_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp1_, path);
	iter = _tmp1_;
	path_is_valid = _tmp2_;
	if (!path_is_valid) {
		_tmp3_ = TRUE;
	} else {
		GitgFilesTreeStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->d_model;
		_tmp5_ = iter;
		_tmp3_ = gitg_files_tree_store_get_isdir (_tmp4_, &_tmp5_);
	}
	if (_tmp3_) {
		return;
	}
	_tmp6_ = self->priv->d_model;
	_tmp7_ = iter;
	_tmp8_ = gitg_files_tree_store_get_id (_tmp6_, &_tmp7_);
	id = _tmp8_;
	{
		GgitBlob* _tmp9_ = NULL;
		GitgExtApplication* _tmp10_;
		GitgExtApplication* _tmp11_;
		GitgExtApplication* _tmp12_;
		GitgRepository* _tmp13_;
		GitgRepository* _tmp14_;
		GitgRepository* _tmp15_;
		GgitOId* _tmp16_;
		gpointer _tmp17_;
		GgitBlob* _tmp18_;
		GgitBlob* _tmp19_;
		_tmp10_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gitg_ext_application_get_repository (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = id;
		_tmp17_ = gitg_repository_lookup (_tmp15_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp16_, &_inner_error0_);
		_tmp18_ = (GgitBlob*) _tmp17_;
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (_tmp12_);
		_tmp9_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp19_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (blob);
		blob = _tmp19_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = blob;
	_tmp22_ = ggit_blob_get_raw_content (_tmp20_, &_tmp21_);
	content = _tmp22_;
	content_length1 = _tmp21_;
	_content_size_ = content_length1;
	{
		gchar* filename = NULL;
		GgitOId* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		GitgFilesTreeStore* _tmp27_;
		GtkTreeIter _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* temp_dir = NULL;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* file_path = NULL;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		GFile* file = NULL;
		const gchar* _tmp42_;
		GFile* _tmp43_;
		GFile* _tmp44_;
		GIOStream* iostream = NULL;
		GFile* _tmp46_;
		GFileIOStream* _tmp47_;
		GOutputStream* ostream = NULL;
		GIOStream* _tmp48_;
		GOutputStream* _tmp49_;
		GOutputStream* _tmp50_;
		GOutputStream* _tmp51_;
		gboolean success = FALSE;
		_tmp23_ = id;
		_tmp24_ = ggit_oid_to_string (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = self->priv->d_model;
		_tmp28_ = iter;
		_tmp29_ = gitg_files_tree_store_get_name (_tmp27_, &_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat (_tmp26_, "-", _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp30_);
		_g_free0 (_tmp25_);
		filename = _tmp33_;
		_tmp34_ = g_get_tmp_dir ();
		_tmp35_ = g_strdup (_tmp34_);
		temp_dir = _tmp35_;
		_tmp36_ = temp_dir;
		_tmp37_ = g_strconcat (_tmp36_, "/", NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = filename;
		_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp38_);
		file_path = _tmp41_;
		_tmp42_ = file_path;
		_tmp43_ = g_file_new_for_path (_tmp42_);
		file = _tmp43_;
		_tmp44_ = file;
		if (g_file_query_exists (_tmp44_, NULL)) {
			GFile* _tmp45_;
			_tmp45_ = file;
			g_file_delete (_tmp45_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (file_path);
				_g_free0 (temp_dir);
				_g_free0 (filename);
				goto __catch1_g_error;
			}
		}
		_tmp46_ = file;
		_tmp47_ = g_file_create_readwrite (_tmp46_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		iostream = (GIOStream*) _tmp47_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (file_path);
			_g_free0 (temp_dir);
			_g_free0 (filename);
			goto __catch1_g_error;
		}
		_tmp48_ = iostream;
		_tmp49_ = g_io_stream_get_output_stream (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _g_object_ref0 (_tmp50_);
		ostream = _tmp51_;
		{
			GOutputStream* _tmp52_;
			guint8* _tmp53_;
			gint _tmp53__length1;
			GOutputStream* _tmp54_;
			GOutputStream* _tmp55_;
			_tmp52_ = ostream;
			_tmp53_ = content;
			_tmp53__length1 = content_length1;
			g_output_stream_write (_tmp52_, _tmp53_, (gsize) _tmp53__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp54_ = ostream;
			g_output_stream_flush (_tmp54_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp55_ = ostream;
			g_output_stream_close (_tmp55_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			FILE* _tmp56_;
			g_clear_error (&_inner_error0_);
			_tmp56_ = stderr;
			fprintf (_tmp56_, "Could not write to temp file\n");
			_g_object_unref0 (ostream);
			_g_object_unref0 (iostream);
			_g_object_unref0 (file);
			_g_free0 (file_path);
			_g_free0 (temp_dir);
			_g_free0 (filename);
			_g_object_unref0 (blob);
			__vala_GgitOId_free0 (id);
			return;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ostream);
			_g_object_unref0 (iostream);
			_g_object_unref0 (file);
			_g_free0 (file_path);
			_g_free0 (temp_dir);
			_g_free0 (filename);
			goto __catch1_g_error;
		}
		success = FALSE;
		{
			gboolean _tmp57_ = FALSE;
			GtkPaned* _tmp58_;
			GtkWidget* _tmp59_;
			GFile* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gboolean _tmp63_;
			_tmp58_ = self->priv->d_paned;
			_tmp59_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp58_);
			_tmp60_ = file;
			_tmp61_ = g_file_get_uri (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = gtk_show_uri_on_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_window_get_type (), GtkWindow), _tmp62_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
			_g_free0 (_tmp62_);
			_tmp57_ = _tmp63_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			success = _tmp57_;
		}
		goto __finally3;
		__catch3_g_error:
		{
			FILE* _tmp64_;
			g_clear_error (&_inner_error0_);
			_tmp64_ = stderr;
			fprintf (_tmp64_, "Failed to open application \n");
			_g_object_unref0 (ostream);
			_g_object_unref0 (iostream);
			_g_object_unref0 (file);
			_g_free0 (file_path);
			_g_free0 (temp_dir);
			_g_free0 (filename);
			_g_object_unref0 (blob);
			__vala_GgitOId_free0 (id);
			return;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ostream);
			_g_object_unref0 (iostream);
			_g_object_unref0 (file);
			_g_free0 (file_path);
			_g_free0 (temp_dir);
			_g_free0 (filename);
			goto __catch1_g_error;
		}
		if (!success) {
			FILE* _tmp65_;
			_tmp65_ = stderr;
			fprintf (_tmp65_, "Failed to open application\n");
		}
		_g_object_unref0 (ostream);
		_g_object_unref0 (iostream);
		_g_object_unref0 (file);
		_g_free0 (file_path);
		_g_free0 (temp_dir);
		_g_free0 (filename);
	}
	goto __finally1;
	__catch1_g_error:
	{
		FILE* _tmp66_;
		g_clear_error (&_inner_error0_);
		_tmp66_ = stderr;
		fprintf (_tmp66_, "Unable to create file\n");
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (blob);
	__vala_GgitOId_free0 (id);
}

static gint
gitg_files_panel_real_negotiate_order (GitgExtUIElement* base,
                                       GitgExtUIElement* other)
{
	GitgFilesPanel * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gint result;
	self = (GitgFilesPanel*) base;
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = gitg_ext_ui_element_get_id (other);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "/org/gnome/gitg/Panels/Diff") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = 1;
		return result;
	} else {
		result = 0;
		return result;
	}
}

GitgFilesPanel*
gitg_files_panel_construct (GType object_type)
{
	GitgFilesPanel * self = NULL;
	self = (GitgFilesPanel*) g_object_new (object_type, NULL);
	return self;
}

GitgFilesPanel*
gitg_files_panel_new (void)
{
	return gitg_files_panel_construct (GITG_FILES_TYPE_PANEL);
}

static GitgExtApplication*
gitg_files_panel_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgFilesPanel* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgFilesPanel*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_files_panel_real_set_application (GitgExtUIElement* base,
                                       GitgExtApplication* value)
{
	GitgFilesPanel* self;
	GitgExtApplication* old_value;
	self = (GitgFilesPanel*) base;
	old_value = gitg_files_panel_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_files_panel_properties[GITG_FILES_PANEL_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtHistory*
gitg_files_panel_real_get_history (GitgExtHistoryPanel* base)
{
	GitgExtHistory* result;
	GitgFilesPanel* self;
	GitgExtHistory* _tmp0_;
	GitgExtHistory* _tmp1_;
	self = (GitgFilesPanel*) base;
	_tmp0_ = self->priv->_history;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_files_panel_real_set_history (GitgExtHistoryPanel* base,
                                   GitgExtHistory* value)
{
	GitgFilesPanel* self;
	GitgExtHistory* old_value;
	self = (GitgFilesPanel*) base;
	old_value = gitg_files_panel_real_get_history (base);
	if (old_value != value) {
		GitgExtHistory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_history);
		self->priv->_history = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_files_panel_properties[GITG_FILES_PANEL_HISTORY_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

guint*
gitg_files_panel_get_shortcut (GitgFilesPanel* self)
{
	GitgFilesPanelClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = GITG_FILES_PANEL_GET_CLASS (self);
	if (_klass_->get_shortcut) {
		return _klass_->get_shortcut (self);
	}
	return NULL;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static guint*
gitg_files_panel_real_get_shortcut (GitgFilesPanel* base)
{
	guint* result;
	GitgFilesPanel* self;
	guint _tmp0_;
	guint* _tmp1_;
	self = base;
	_tmp0_ = GDK_KEY_f;
	_tmp1_ = __uint_dup0 (&_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
gitg_files_panel_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgFilesPanel* self;
	gchar* _tmp0_;
	self = (GitgFilesPanel*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/Panels/Files");
	result = _tmp0_;
	return result;
}

static gboolean
gitg_files_panel_real_get_available (GitgExtUIElement* base)
{
	gboolean result;
	GitgFilesPanel* self;
	self = (GitgFilesPanel*) base;
	result = TRUE;
	return result;
}

static gchar*
gitg_files_panel_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgFilesPanel* self;
	gchar* _tmp0_;
	self = (GitgFilesPanel*) base;
	_tmp0_ = g_strdup (_ ("Files"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_files_panel_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgFilesPanel* self;
	gchar* _tmp0_;
	self = (GitgFilesPanel*) base;
	_tmp0_ = g_strdup (_ ("Show the files in the tree of the selected commit"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_files_panel_real_get_icon (GitgExtUIElement* base)
{
	gchar* result;
	GitgFilesPanel* self;
	gchar* _tmp0_;
	self = (GitgFilesPanel*) base;
	_tmp0_ = g_strdup ("system-file-manager-symbolic");
	result = _tmp0_;
	return result;
}

static GtkWidget*
gitg_files_panel_real_get_widget (GitgExtUIElement* base)
{
	GtkWidget* result;
	GitgFilesPanel* self;
	GtkPaned* _tmp0_;
	GtkPaned* _tmp1_;
	GtkWidget* _tmp2_;
	self = (GitgFilesPanel*) base;
	_tmp0_ = self->priv->d_paned;
	if (_tmp0_ == NULL) {
		gitg_files_panel_build_ui (self);
	}
	_tmp1_ = self->priv->d_paned;
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
gitg_files_panel_real_get_enabled (GitgExtUIElement* base)
{
	gboolean result;
	GitgFilesPanel* self;
	self = (GitgFilesPanel*) base;
	result = TRUE;
	return result;
}

static void
_gitg_files_panel_on_selection_changed_gitg_ext_history_selection_changed (GitgExtHistory* _sender,
                                                                           gpointer self)
{
	gitg_files_panel_on_selection_changed ((GitgFilesPanel*) self, _sender);
}

static GObject *
gitg_files_panel_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgFilesPanel * self;
	GitgFilesTreeStore* _tmp0_;
	GitgExtHistory* _tmp1_;
	GitgExtHistory* _tmp2_;
	GitgExtHistory* _tmp3_;
	parent_class = G_OBJECT_CLASS (gitg_files_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_FILES_TYPE_PANEL, GitgFilesPanel);
	_tmp0_ = gitg_files_tree_store_new ();
	_g_object_unref0 (self->priv->d_model);
	self->priv->d_model = _tmp0_;
	_tmp1_ = gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "selection-changed", (GCallback) _gitg_files_panel_on_selection_changed_gitg_ext_history_selection_changed, self, 0);
	_g_object_unref0 (_tmp3_);
	return obj;
}

static void
gitg_files_panel_class_init (GitgFilesPanelClass * klass,
                             gpointer klass_data)
{
	gitg_files_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgFilesPanel_private_offset);
	GITG_FILES_PANEL_CLASS (klass)->get_shortcut = (guint* (*) (GitgFilesPanel*)) gitg_files_panel_real_get_shortcut;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_files_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_files_panel_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_files_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_files_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_APPLICATION_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_HISTORY_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_HISTORY_PROPERTY] = g_param_spec_object ("history", "history", "history", GITG_EXT_TYPE_HISTORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_ID_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_AVAILABLE_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_AVAILABLE_PROPERTY] = g_param_spec_boolean ("available", "available", "available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_DISPLAY_NAME_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_DESCRIPTION_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_ICON_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_WIDGET_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_PANEL_ENABLED_PROPERTY, gitg_files_panel_properties[GITG_FILES_PANEL_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_files_panel_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                     gpointer iface_data)
{
	gitg_files_panel_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->negotiate_order = (gint (*) (GitgExtUIElement*, GitgExtUIElement*)) gitg_files_panel_real_negotiate_order;
	iface->get_application = gitg_files_panel_real_get_application;
	iface->set_application = gitg_files_panel_real_set_application;
	iface->get_shortcut = (guint* (*) (GitgExtUIElement*)) gitg_files_panel_get_shortcut;
	iface->get_id = gitg_files_panel_real_get_id;
	iface->get_available = gitg_files_panel_real_get_available;
	iface->get_display_name = gitg_files_panel_real_get_display_name;
	iface->get_description = gitg_files_panel_real_get_description;
	iface->get_icon = gitg_files_panel_real_get_icon;
	iface->get_widget = gitg_files_panel_real_get_widget;
	iface->get_enabled = gitg_files_panel_real_get_enabled;
}

static void
gitg_files_panel_gitg_ext_history_panel_interface_init (GitgExtHistoryPanelIface * iface,
                                                        gpointer iface_data)
{
	gitg_files_panel_gitg_ext_history_panel_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_history = gitg_files_panel_real_get_history;
	iface->set_history = gitg_files_panel_real_set_history;
}

static void
gitg_files_panel_instance_init (GitgFilesPanel * self,
                                gpointer klass)
{
	self->priv = gitg_files_panel_get_instance_private (self);
}

static void
gitg_files_panel_finalize (GObject * obj)
{
	GitgFilesPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_FILES_TYPE_PANEL, GitgFilesPanel);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_history);
	_g_object_unref0 (self->priv->d_model);
	_g_object_unref0 (self->priv->d_paned);
	_g_object_unref0 (self->priv->d_source);
	_g_object_unref0 (self->priv->d_stylesettings);
	_g_object_unref0 (self->priv->d_scrolled_files);
	_g_object_unref0 (self->priv->d_scrolled);
	_g_object_unref0 (self->priv->d_imagevp);
	_g_object_unref0 (self->priv->d_image);
	_gitg_when_mapped_unref0 (self->priv->d_whenMapped);
	_g_object_unref0 (self->priv->d_font_manager);
	G_OBJECT_CLASS (gitg_files_panel_parent_class)->finalize (obj);
}

GType
gitg_files_panel_get_type (void)
{
	return gitg_files_panel_type_id;
}

GType
gitg_files_panel_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgFilesPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_files_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgFilesPanel), 0, (GInstanceInitFunc) gitg_files_panel_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_files_panel_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_history_panel_info = { (GInterfaceInitFunc) gitg_files_panel_gitg_ext_history_panel_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gitg_files_panel_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GitgFilesPanel", &g_define_type_info, 0);
	g_type_module_add_interface (module, gitg_files_panel_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_module_add_interface (module, gitg_files_panel_type_id, GITG_EXT_TYPE_HISTORY_PANEL, &gitg_ext_history_panel_info);
	GitgFilesPanel_private_offset = sizeof (GitgFilesPanelPrivate);
	return gitg_files_panel_type_id;
}

static void
_vala_gitg_files_panel_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GitgFilesPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_FILES_TYPE_PANEL, GitgFilesPanel);
	switch (property_id) {
		case GITG_FILES_PANEL_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_FILES_PANEL_HISTORY_PROPERTY:
		g_value_take_object (value, gitg_ext_history_panel_get_history ((GitgExtHistoryPanel*) self));
		break;
		case GITG_FILES_PANEL_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_FILES_PANEL_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_available ((GitgExtUIElement*) self));
		break;
		case GITG_FILES_PANEL_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_FILES_PANEL_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_FILES_PANEL_ICON_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_icon ((GitgExtUIElement*) self));
		break;
		case GITG_FILES_PANEL_WIDGET_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_widget ((GitgExtUIElement*) self));
		break;
		case GITG_FILES_PANEL_ENABLED_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_files_panel_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GitgFilesPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_FILES_TYPE_PANEL, GitgFilesPanel);
	switch (property_id) {
		case GITG_FILES_PANEL_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_FILES_PANEL_HISTORY_PROPERTY:
		gitg_ext_history_panel_set_history ((GitgExtHistoryPanel*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* mod = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	gitg_files_panel_register_type (module);
	gitg_files_tree_store_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	mod = _tmp0_;
	peas_object_module_register_extension_type (mod, GITG_EXT_TYPE_HISTORY_PANEL, GITG_FILES_TYPE_PANEL);
	_g_object_unref0 (mod);
}

