/* gitg-date.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-date.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdesktop-enums.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_DATE_0_PROPERTY,
	GITG_DATE_DATE_STRING_PROPERTY,
	GITG_DATE_DATE_PROPERTY,
	GITG_DATE_NUM_PROPERTIES
};
static GParamSpec* gitg_date_properties[GITG_DATE_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgDatePrivate {
	GDateTime* d_datetime;
	gchar* _date_string;
};

static gint GitgDate_private_offset;
static gpointer gitg_date_parent_class = NULL;
static GRegex* gitg_date_s_rfc2822;
static GRegex* gitg_date_s_rfc2822 = NULL;
static GRegex* gitg_date_s_iso8601;
static GRegex* gitg_date_s_iso8601 = NULL;
static GRegex* gitg_date_s_internal;
static GRegex* gitg_date_s_internal = NULL;
static GSettings* gitg_date_s_gnome_interface_settings;
static GSettings* gitg_date_s_gnome_interface_settings = NULL;
static gboolean gitg_date_s_tried_gnome_interface_settings;
static gboolean gitg_date_s_tried_gnome_interface_settings = FALSE;
static gchar** gitg_date_s_months;
static gint gitg_date_s_months_length1;
static gchar** gitg_date_s_months = NULL;
static gint gitg_date_s_months_length1 = 0;
static gint _gitg_date_s_months_size_ = 0;
static GInitableIface * gitg_date_g_initable_parent_iface = NULL;

static gboolean gitg_date_fetch_and_set_int (GMatchInfo* info,
                                      const gchar* name,
                                      gint* retval);
static gboolean gitg_date_fetch_and_set_double (GMatchInfo* info,
                                         const gchar* name,
                                         gdouble* retval);
static GDateTime* gitg_date_parse_internal (GMatchInfo* info,
                                     GError** error);
static GDateTime* gitg_date_parse_iso8601 (GMatchInfo* info,
                                    GError** error);
static GDateTime* gitg_date_parse_rfc2822 (GMatchInfo* info,
                                    GError** error);
static gboolean gitg_date_real_init (GInitable* base,
                              GCancellable* cancellable,
                              GError** error);
static gboolean gitg_date_get_is_24h (GitgDate* self);
static void gitg_date_finalize (GObject * obj);
static GType gitg_date_get_type_once (void);
static void _vala_gitg_date_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_gitg_date_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

GQuark
gitg_date_error_quark (void)
{
	return g_quark_from_static_string ("gitg-date-error-quark");
}

 G_GNUC_NO_INLINE static GType
gitg_date_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_DATE_ERROR_INVALID_FORMAT, "GITG_DATE_ERROR_INVALID_FORMAT", "invalid-format"}, {0, NULL, NULL}};
	GType gitg_date_error_type_id;
	gitg_date_error_type_id = g_enum_register_static ("GitgDateError", values);
	return gitg_date_error_type_id;
}

GType
gitg_date_error_get_type (void)
{
	static gsize gitg_date_error_type_id__once = 0;
	if (g_once_init_enter (&gitg_date_error_type_id__once)) {
		GType gitg_date_error_type_id;
		gitg_date_error_type_id = gitg_date_error_get_type_once ();
		g_once_init_leave (&gitg_date_error_type_id__once, gitg_date_error_type_id);
	}
	return gitg_date_error_type_id__once;
}

static inline gpointer
gitg_date_get_instance_private (GitgDate* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDate_private_offset);
}

static gboolean
gitg_date_fetch_and_set_int (GMatchInfo* info,
                             const gchar* name,
                             gint* retval)
{
	gchar* val = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_match_info_fetch_named (info, name);
	val = _tmp0_;
	_tmp2_ = val;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = val;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_free0 (val);
		return result;
	}
	_tmp4_ = val;
	*retval = atoi (_tmp4_);
	result = TRUE;
	_g_free0 (val);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gboolean
gitg_date_fetch_and_set_double (GMatchInfo* info,
                                const gchar* name,
                                gdouble* retval)
{
	gchar* val = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_match_info_fetch_named (info, name);
	val = _tmp0_;
	_tmp1_ = val;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_free0 (val);
		return result;
	}
	_tmp2_ = val;
	*retval = double_parse (_tmp2_);
	result = TRUE;
	_g_free0 (val);
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static GTimeZone*
vala_g_time_zone_new_identifier (const gchar* identifier,
                                 GError** error)
{
	GTimeZone* self;
	GError* _inner_error0_ = NULL;
	self = (GTimeZone*) g_time_zone_new_identifier (identifier);
	if (((GTimeZone*) self) == NULL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE, "Invalid identifier argument");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		_g_time_zone_unref0 (self);
		return NULL;
	}
	return self;
}

static GDateTime*
gitg_date_parse_internal (GMatchInfo* info,
                          GError** error)
{
	gchar* timestamp = NULL;
	gchar* _tmp0_;
	gint64 unixt = 0LL;
	const gchar* _tmp1_;
	gchar* tzs = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = g_match_info_fetch_named (info, "timestamp");
	timestamp = _tmp0_;
	_tmp1_ = timestamp;
	unixt = int64_parse (_tmp1_, (guint) 0);
	_tmp2_ = g_match_info_fetch_named (info, "tz");
	tzs = _tmp2_;
	_tmp4_ = tzs;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = tzs;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GDateTime* ret = NULL;
		GDateTime* _tmp6_;
		GTimeZone* _tmp7_ = NULL;
		const gchar* _tmp8_;
		GTimeZone* _tmp9_;
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		_tmp6_ = g_date_time_new_from_unix_utc (unixt);
		ret = _tmp6_;
		_tmp8_ = tzs;
		_tmp9_ = vala_g_time_zone_new_identifier (_tmp8_, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_date_time_unref0 (ret);
			_g_free0 (tzs);
			_g_free0 (timestamp);
			return NULL;
		}
		_tmp10_ = ret;
		_tmp11_ = g_date_time_to_timezone (_tmp10_, _tmp7_);
		result = _tmp11_;
		_g_time_zone_unref0 (_tmp7_);
		_g_date_time_unref0 (ret);
		_g_free0 (tzs);
		_g_free0 (timestamp);
		return result;
	} else {
		GDateTime* _tmp12_;
		_tmp12_ = g_date_time_new_from_unix_local (unixt);
		result = _tmp12_;
		_g_free0 (tzs);
		_g_free0 (timestamp);
		return result;
	}
}

static GDateTime*
gitg_date_parse_iso8601 (GMatchInfo* info,
                         GError** error)
{
	GTimeZone* tz = NULL;
	GTimeZone* _tmp0_;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gdouble seconds = 0.0;
	gchar* tzs = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GTimeZone* _tmp10_;
	GDateTime* _tmp11_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = g_time_zone_new_utc ();
	tz = _tmp0_;
	year = 0;
	month = 1;
	day = 1;
	hour = 0;
	minute = 0;
	seconds = 0.0;
	gitg_date_fetch_and_set_int (info, "year", &year);
	gitg_date_fetch_and_set_int (info, "month", &month);
	gitg_date_fetch_and_set_int (info, "day", &day);
	gitg_date_fetch_and_set_int (info, "hour", &hour);
	gitg_date_fetch_and_set_int (info, "minute", &minute);
	gitg_date_fetch_and_set_double (info, "seconds", &seconds);
	_tmp1_ = g_match_info_fetch_named (info, "tz");
	tzs = _tmp1_;
	_tmp3_ = tzs;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = tzs;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GTimeZone* _tmp5_ = NULL;
		const gchar* _tmp6_;
		GTimeZone* _tmp7_;
		GTimeZone* _tmp8_;
		_tmp6_ = tzs;
		_tmp7_ = vala_g_time_zone_new_identifier (_tmp6_, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (tzs);
			_g_time_zone_unref0 (tz);
			return NULL;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_time_zone_unref0 (tz);
		tz = _tmp8_;
		_g_time_zone_unref0 (_tmp5_);
	} else {
		GTimeZone* _tmp9_;
		_tmp9_ = g_time_zone_new_local ();
		_g_time_zone_unref0 (tz);
		tz = _tmp9_;
	}
	_tmp10_ = tz;
	_tmp11_ = g_date_time_new (_tmp10_, year, month, day, hour, minute, seconds);
	result = _tmp11_;
	_g_free0 (tzs);
	_g_time_zone_unref0 (tz);
	return result;
}

static GDateTime*
gitg_date_parse_rfc2822 (GMatchInfo* info,
                         GError** error)
{
	GTimeZone* tz = NULL;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gdouble seconds = 0.0;
	gchar* monthstr = NULL;
	gchar* _tmp0_;
	gchar* tzs = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	GTimeZone* _tmp20_;
	GDateTime* _tmp21_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (info != NULL, NULL);
	year = 0;
	month = 0;
	day = 1;
	hour = 0;
	minute = 0;
	seconds = (gdouble) 0;
	gitg_date_fetch_and_set_int (info, "year", &year);
	_tmp0_ = g_match_info_fetch_named (info, "month");
	monthstr = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar** _tmp3_;
				gint _tmp3__length1;
				gboolean _tmp4_ = FALSE;
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					i = i + 1;
					_tmp2_ = i;
				}
				_tmp1_ = FALSE;
				_tmp3_ = gitg_date_s_months;
				_tmp3__length1 = gitg_date_s_months_length1;
				if (!(i < _tmp3__length1)) {
					break;
				}
				_tmp5_ = gitg_date_s_months;
				_tmp5__length1 = gitg_date_s_months_length1;
				_tmp6_ = _tmp5_[i];
				if (_tmp6_ != NULL) {
					gchar** _tmp7_;
					gint _tmp7__length1;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					_tmp7_ = gitg_date_s_months;
					_tmp7__length1 = gitg_date_s_months_length1;
					_tmp8_ = _tmp7_[i];
					_tmp9_ = monthstr;
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					month = i;
					break;
				}
			}
		}
	}
	if (month == 0) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (GITG_DATE_ERROR, GITG_DATE_ERROR_INVALID_FORMAT, "Invalid month specified");
		_inner_error0_ = _tmp10_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (monthstr);
		_g_time_zone_unref0 (tz);
		return NULL;
	}
	gitg_date_fetch_and_set_int (info, "day", &day);
	gitg_date_fetch_and_set_int (info, "hour", &hour);
	gitg_date_fetch_and_set_int (info, "minute", &minute);
	gitg_date_fetch_and_set_double (info, "seconds", &seconds);
	_tmp11_ = g_match_info_fetch_named (info, "tz");
	tzs = _tmp11_;
	_tmp13_ = tzs;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = tzs;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GTimeZone* _tmp15_ = NULL;
		const gchar* _tmp16_;
		GTimeZone* _tmp17_;
		GTimeZone* _tmp18_;
		_tmp16_ = tzs;
		_tmp17_ = vala_g_time_zone_new_identifier (_tmp16_, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (tzs);
			_g_free0 (monthstr);
			_g_time_zone_unref0 (tz);
			return NULL;
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_g_time_zone_unref0 (tz);
		tz = _tmp18_;
		_g_time_zone_unref0 (_tmp15_);
	} else {
		GTimeZone* _tmp19_;
		_tmp19_ = g_time_zone_new_local ();
		_g_time_zone_unref0 (tz);
		tz = _tmp19_;
	}
	_tmp20_ = tz;
	_tmp21_ = g_date_time_new (_tmp20_, year, month, day, hour, minute, seconds);
	result = _tmp21_;
	_g_free0 (tzs);
	_g_free0 (monthstr);
	_g_time_zone_unref0 (tz);
	return result;
}

static gboolean
gitg_date_real_init (GInitable* base,
                     GCancellable* cancellable,
                     GError** error)
{
	GitgDate * self;
	GMatchInfo* info = NULL;
	GRegex* _tmp0_;
	const gchar* _tmp1_;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_;
	GRegex* _tmp9_;
	const gchar* _tmp10_;
	GMatchInfo* _tmp11_ = NULL;
	gboolean _tmp12_;
	GRegex* _tmp18_;
	const gchar* _tmp19_;
	GMatchInfo* _tmp20_ = NULL;
	gboolean _tmp21_;
	GError* _tmp27_;
	gboolean _tmp28_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (GitgDate*) base;
	_tmp0_ = gitg_date_s_internal;
	_tmp1_ = self->priv->_date_string;
	_tmp3_ = g_regex_match (_tmp0_, _tmp1_, 0, &_tmp2_);
	_g_match_info_unref0 (info);
	info = _tmp2_;
	if (_tmp3_) {
		GDateTime* _tmp4_ = NULL;
		GMatchInfo* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp8_;
		_tmp5_ = info;
		_tmp6_ = gitg_date_parse_internal (_tmp5_, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_match_info_unref0 (info);
			return _tmp7_;
		}
		_tmp8_ = _tmp4_;
		_tmp4_ = NULL;
		_g_date_time_unref0 (self->priv->d_datetime);
		self->priv->d_datetime = _tmp8_;
		result = TRUE;
		_g_date_time_unref0 (_tmp4_);
		_g_match_info_unref0 (info);
		return result;
	}
	_tmp9_ = gitg_date_s_iso8601;
	_tmp10_ = self->priv->_date_string;
	_tmp12_ = g_regex_match (_tmp9_, _tmp10_, 0, &_tmp11_);
	_g_match_info_unref0 (info);
	info = _tmp11_;
	if (_tmp12_) {
		GDateTime* _tmp13_ = NULL;
		GMatchInfo* _tmp14_;
		GDateTime* _tmp15_;
		GDateTime* _tmp17_;
		_tmp14_ = info;
		_tmp15_ = gitg_date_parse_iso8601 (_tmp14_, &_inner_error0_);
		_tmp13_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_match_info_unref0 (info);
			return _tmp16_;
		}
		_tmp17_ = _tmp13_;
		_tmp13_ = NULL;
		_g_date_time_unref0 (self->priv->d_datetime);
		self->priv->d_datetime = _tmp17_;
		result = TRUE;
		_g_date_time_unref0 (_tmp13_);
		_g_match_info_unref0 (info);
		return result;
	}
	_tmp18_ = gitg_date_s_rfc2822;
	_tmp19_ = self->priv->_date_string;
	_tmp21_ = g_regex_match (_tmp18_, _tmp19_, 0, &_tmp20_);
	_g_match_info_unref0 (info);
	info = _tmp20_;
	if (_tmp21_) {
		GDateTime* _tmp22_ = NULL;
		GMatchInfo* _tmp23_;
		GDateTime* _tmp24_;
		GDateTime* _tmp26_;
		_tmp23_ = info;
		_tmp24_ = gitg_date_parse_rfc2822 (_tmp23_, &_inner_error0_);
		_tmp22_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp25_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_match_info_unref0 (info);
			return _tmp25_;
		}
		_tmp26_ = _tmp22_;
		_tmp22_ = NULL;
		_g_date_time_unref0 (self->priv->d_datetime);
		self->priv->d_datetime = _tmp26_;
		result = TRUE;
		_g_date_time_unref0 (_tmp22_);
		_g_match_info_unref0 (info);
		return result;
	}
	_tmp27_ = g_error_new_literal (GITG_DATE_ERROR, GITG_DATE_ERROR_INVALID_FORMAT, "Invalid date format");
	_inner_error0_ = _tmp27_;
	g_propagate_error (error, _inner_error0_);
	_g_match_info_unref0 (info);
	return _tmp28_;
}

GitgDate*
gitg_date_construct (GType object_type,
                     const gchar* date,
                     GError** error)
{
	GitgDate * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (date != NULL, NULL);
	self = (GitgDate*) g_object_new (object_type, "date-string", date, NULL);
	g_initable_init (G_TYPE_CHECK_INSTANCE_CAST (self, g_initable_get_type (), GInitable), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

GitgDate*
gitg_date_new (const gchar* date,
               GError** error)
{
	return gitg_date_construct (GITG_TYPE_DATE, date, error);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

gchar*
gitg_date_for_display (GitgDate* self)
{
	GDateTime* dt = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GTimeSpan t = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GTimeSpan _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_datetime;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	dt = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = _tmp2_;
	_tmp4_ = dt;
	_tmp5_ = g_date_time_difference (_tmp3_, _tmp4_);
	_g_date_time_unref0 (_tmp3_);
	t = _tmp5_;
	if (((gdouble) t) < (G_TIME_SPAN_MINUTE * 29.5)) {
		gint rounded_minutes = 0;
		rounded_minutes = (gint) round ((gdouble) (((gfloat) t) / G_TIME_SPAN_MINUTE));
		if (rounded_minutes == 0) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Now"));
			result = _tmp6_;
			_g_date_time_unref0 (dt);
			return result;
		} else {
			gchar* _tmp7_;
			_tmp7_ = g_strdup_printf (ngettext ("A minute ago", "%d minutes ago", (gulong) rounded_minutes), rounded_minutes);
			result = _tmp7_;
			_g_date_time_unref0 (dt);
			return result;
		}
	} else {
		if (t < (G_TIME_SPAN_MINUTE * 45)) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Half an hour ago"));
			result = _tmp8_;
			_g_date_time_unref0 (dt);
			return result;
		} else {
			if (((gdouble) t) < (G_TIME_SPAN_HOUR * 23.5)) {
				gint rounded_hours = 0;
				gchar* _tmp9_;
				rounded_hours = (gint) round ((gdouble) (((gfloat) t) / G_TIME_SPAN_HOUR));
				_tmp9_ = g_strdup_printf (ngettext ("An hour ago", "%d hours ago", (gulong) rounded_hours), rounded_hours);
				result = _tmp9_;
				_g_date_time_unref0 (dt);
				return result;
			} else {
				if (t < (G_TIME_SPAN_DAY * 7)) {
					gint rounded_days = 0;
					gchar* _tmp10_;
					rounded_days = (gint) round ((gdouble) (((gfloat) t) / G_TIME_SPAN_DAY));
					_tmp10_ = g_strdup_printf (ngettext ("A day ago", "%d days ago", (gulong) rounded_days), rounded_days);
					result = _tmp10_;
					_g_date_time_unref0 (dt);
					return result;
				} else {
					GDateTime* _tmp11_;
					GDateTime* _tmp12_;
					GDateTime* _tmp13_;
					gboolean _tmp14_;
					_tmp11_ = dt;
					_tmp12_ = g_date_time_new_now_local ();
					_tmp13_ = _tmp12_;
					_tmp14_ = g_date_time_get_year (_tmp11_) == g_date_time_get_year (_tmp13_);
					_g_date_time_unref0 (_tmp13_);
					if (_tmp14_) {
						gboolean _tmp15_;
						gboolean _tmp16_;
						_tmp15_ = gitg_date_get_is_24h (self);
						_tmp16_ = _tmp15_;
						if (_tmp16_) {
							GDateTime* _tmp17_;
							gchar* _tmp18_;
							_tmp17_ = dt;
							_tmp18_ = g_date_time_format (_tmp17_, _ ("%b %e, %H∶%M"));
							result = _tmp18_;
							_g_date_time_unref0 (dt);
							return result;
						} else {
							GDateTime* _tmp19_;
							gchar* _tmp20_;
							_tmp19_ = dt;
							_tmp20_ = g_date_time_format (_tmp19_, _ ("%b %e, %I∶%M %p"));
							result = _tmp20_;
							_g_date_time_unref0 (dt);
							return result;
						}
					} else {
						gboolean _tmp21_;
						gboolean _tmp22_;
						_tmp21_ = gitg_date_get_is_24h (self);
						_tmp22_ = _tmp21_;
						if (_tmp22_) {
							GDateTime* _tmp23_;
							gchar* _tmp24_;
							_tmp23_ = dt;
							_tmp24_ = g_date_time_format (_tmp23_, _ ("%b %e %Y, %H∶%M"));
							result = _tmp24_;
							_g_date_time_unref0 (dt);
							return result;
						} else {
							GDateTime* _tmp25_;
							gchar* _tmp26_;
							_tmp25_ = dt;
							_tmp26_ = g_date_time_format (_tmp25_, _ ("%b %e %Y, %I∶%M %p"));
							result = _tmp26_;
							_g_date_time_unref0 (dt);
							return result;
						}
					}
				}
			}
		}
	}
}

GitgDate*
gitg_date_construct_for_date_time (GType object_type,
                                   GDateTime* dt)
{
	GitgDate * self = NULL;
	GDateTime* _tmp0_;
	g_return_val_if_fail (dt != NULL, NULL);
	self = (GitgDate*) g_object_new (object_type, NULL);
	_tmp0_ = _g_date_time_ref0 (dt);
	_g_date_time_unref0 (self->priv->d_datetime);
	self->priv->d_datetime = _tmp0_;
	return self;
}

GitgDate*
gitg_date_new_for_date_time (GDateTime* dt)
{
	return gitg_date_construct_for_date_time (GITG_TYPE_DATE, dt);
}

GDateTime*
gitg_date_parse (const gchar* date,
                 GError** error)
{
	GitgDate* _tmp0_ = NULL;
	GitgDate* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp1_ = gitg_date_new (date, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = gitg_date_get_date (_tmp0_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

const gchar*
gitg_date_get_date_string (GitgDate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_string;
	result = _tmp0_;
	return result;
}

void
gitg_date_set_date_string (GitgDate* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_date_get_date_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_date_string);
		self->priv->_date_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_date_properties[GITG_DATE_DATE_STRING_PROPERTY]);
	}
}

GDateTime*
gitg_date_get_date (GitgDate* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_datetime;
	result = _tmp0_;
	return result;
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static gboolean
gitg_date_get_is_24h (GitgDate* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gitg_date_s_gnome_interface_settings;
	if (_tmp1_ == NULL) {
		_tmp0_ = !gitg_date_s_tried_gnome_interface_settings;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSettingsSchemaSource* source = NULL;
		GSettingsSchemaSource* _tmp2_;
		GSettingsSchemaSource* _tmp3_;
		gchar* schema_id = NULL;
		gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GSettingsSchemaSource* _tmp6_;
		_tmp2_ = g_settings_schema_source_get_default ();
		_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
		source = _tmp3_;
		gitg_date_s_tried_gnome_interface_settings = TRUE;
		_tmp4_ = g_strdup ("org.gnome.desktop.interface");
		schema_id = _tmp4_;
		_tmp6_ = source;
		if (_tmp6_ != NULL) {
			GSettingsSchemaSource* _tmp7_;
			const gchar* _tmp8_;
			GSettingsSchema* _tmp9_;
			GSettingsSchema* _tmp10_;
			_tmp7_ = source;
			_tmp8_ = schema_id;
			_tmp9_ = g_settings_schema_source_lookup (_tmp7_, _tmp8_, TRUE);
			_tmp10_ = _tmp9_;
			_tmp5_ = _tmp10_ != NULL;
			_g_settings_schema_unref0 (_tmp10_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			const gchar* _tmp11_;
			GSettings* _tmp12_;
			_tmp11_ = schema_id;
			_tmp12_ = g_settings_new (_tmp11_);
			_g_object_unref0 (gitg_date_s_gnome_interface_settings);
			gitg_date_s_gnome_interface_settings = _tmp12_;
		}
		_g_free0 (schema_id);
		_g_settings_schema_source_unref0 (source);
	}
	_tmp13_ = gitg_date_s_gnome_interface_settings;
	if (_tmp13_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp14_ = gitg_date_s_gnome_interface_settings;
	result = g_settings_get_enum (_tmp14_, "clock-format") == ((gint) G_DESKTOP_CLOCK_FORMAT_24H);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_date_class_init (GitgDateClass * klass,
                      gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	GError* _inner_error0_ = NULL;
	gitg_date_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDate_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_date_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_date_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_date_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DATE_DATE_STRING_PROPERTY, gitg_date_properties[GITG_DATE_DATE_STRING_PROPERTY] = g_param_spec_string ("date-string", "date-string", "date-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DATE_DATE_PROPERTY, gitg_date_properties[GITG_DATE_DATE_PROPERTY] = g_param_spec_boxed ("date", "date", "date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_strdup ("Jan");
	_tmp1_ = g_strdup ("Feb");
	_tmp2_ = g_strdup ("Mar");
	_tmp3_ = g_strdup ("Apr");
	_tmp4_ = g_strdup ("May");
	_tmp5_ = g_strdup ("Jun");
	_tmp6_ = g_strdup ("Jul");
	_tmp7_ = g_strdup ("Aug");
	_tmp8_ = g_strdup ("Sep");
	_tmp9_ = g_strdup ("Oct");
	_tmp10_ = g_strdup ("Nov");
	_tmp11_ = g_strdup ("Dec");
	_tmp12_ = g_new0 (gchar*, 13 + 1);
	_tmp12_[0] = NULL;
	_tmp12_[1] = _tmp0_;
	_tmp12_[2] = _tmp1_;
	_tmp12_[3] = _tmp2_;
	_tmp12_[4] = _tmp3_;
	_tmp12_[5] = _tmp4_;
	_tmp12_[6] = _tmp5_;
	_tmp12_[7] = _tmp6_;
	_tmp12_[8] = _tmp7_;
	_tmp12_[9] = _tmp8_;
	_tmp12_[10] = _tmp9_;
	_tmp12_[11] = _tmp10_;
	_tmp12_[12] = _tmp11_;
	gitg_date_s_months = _tmp12_;
	gitg_date_s_months_length1 = 13;
	_gitg_date_s_months_size_ = gitg_date_s_months_length1;
	{
		GRegex* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		GRegex* _tmp18_;
		GRegex* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GRegex* _tmp22_;
		GRegex* _tmp23_;
		GRegex* _tmp24_;
		GRegex* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GRegex* _tmp28_;
		GRegex* _tmp29_;
		GRegex* _tmp30_;
		_tmp14_ = g_strconcat ("^\n" \
"			(?<year>[0-9]{4})\n" \
"			(?:\n" \
"				[-.]?(?:\n" \
"					(?<month>[0-9]{2})\n" \
"					(?:\n" \
"						[-.]?(?<day>[0-9]{2})\n" \
"					)?\n" \
"				|\n" \
"					W(?<week>[0-9]{2})\n" \
"					(?:\n" \
"						[-.]?(?<weekday>[0-9])\n" \
"					)?\n" \
"				)\n" \
"				(?:\n" \
"					[T ](?<hour>[0-9]{2})\n" \
"					(?:\n" \
"						:?\n" \
"						(?<minute>[0-9]{2})\n" \
"						(?:\n" \
"							:?\n" \
"							(?<seconds>[0-9]{2})\n" \
"							(?<tz>\n" \
"								(?<tzutc>Z) |\n" \
"								[+-](?<tzhour>[0-9]{2})\n" \
"								(?:\n" \
"									:?\n" \
"									(?<tzminute>[0-9]{2})\n" \
"								)?\n" \
"							)?\n" \
"						)?\n" \
"					)?\n" \
"				)?\n" \
"			)?\n" \
"		", "$", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_regex_new (_tmp15_, G_REGEX_EXTENDED, 0, &_inner_error0_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_tmp13_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp18_ = _tmp13_;
		_tmp13_ = NULL;
		_g_regex_unref0 (gitg_date_s_iso8601);
		gitg_date_s_iso8601 = _tmp18_;
		_tmp20_ = g_strconcat ("^\n" \
"			(?:\n" \
"				[\\s]*(?<dayofweek>Mon|Tue|Wed|Thu|Fri|Sat|Sun)\n" \
"				,\n" \
"			)?\n" \
"			[\\s]*(?<day>[0-9]{1,2})\n" \
"			[\\s]+\n" \
"				(?<month>Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\n" \
"			[\\s]+\n" \
"				(?<year>[0-9]{4})\n" \
"			[\\s]+\n" \
"				(?<hour>[0-9]{2})\n" \
"				:\n" \
"				(?<minute>[0-9]{2})\n" \
"				(?:\n" \
"					:\n" \
"					(?<seconds>[0-9]{2})\n" \
"				)?\n" \
"			[\\s]+\n" \
"			(?<tz>\n" \
"				[+-]\n" \
"				(?<tzhour>[0-9]{2})\n" \
"				(?<tzminute>[0-9]{2})\n" \
"			)\n" \
"		", "$", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_regex_new (_tmp21_, G_REGEX_EXTENDED, 0, &_inner_error0_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_tmp19_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp13_);
			goto __catch0_g_error;
		}
		_tmp24_ = _tmp19_;
		_tmp19_ = NULL;
		_g_regex_unref0 (gitg_date_s_rfc2822);
		gitg_date_s_rfc2822 = _tmp24_;
		_tmp26_ = g_strconcat ("^\n" \
"			@?\n" \
"			(?<timestamp>[0-9]+)\n" \
"			[ ](?<tz>\n" \
"				[+-](?<tzhour>[0-9]{2})\n" \
"				(?:\n" \
"					:?\n" \
"					(?<tzminute>[0-9]{2})?\n" \
"				)\n" \
"			)\n" \
"		", "$", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_regex_new (_tmp27_, G_REGEX_EXTENDED, 0, &_inner_error0_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_tmp25_ = _tmp29_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp19_);
			_g_regex_unref0 (_tmp13_);
			goto __catch0_g_error;
		}
		_tmp30_ = _tmp25_;
		_tmp25_ = NULL;
		_g_regex_unref0 (gitg_date_s_internal);
		gitg_date_s_internal = _tmp30_;
		_g_regex_unref0 (_tmp25_);
		_g_regex_unref0 (_tmp19_);
		_g_regex_unref0 (_tmp13_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Failed to compile date regex: ", _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		g_warning ("gitg-date.vala:135: %s", _tmp35_);
		_g_free0 (_tmp35_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
gitg_date_g_initable_interface_init (GInitableIface * iface,
                                     gpointer iface_data)
{
	gitg_date_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) gitg_date_real_init;
}

static void
gitg_date_instance_init (GitgDate * self,
                         gpointer klass)
{
	self->priv = gitg_date_get_instance_private (self);
}

static void
gitg_date_finalize (GObject * obj)
{
	GitgDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DATE, GitgDate);
	_g_date_time_unref0 (self->priv->d_datetime);
	_g_free0 (self->priv->_date_string);
	G_OBJECT_CLASS (gitg_date_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_date_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDate), 0, (GInstanceInitFunc) gitg_date_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) gitg_date_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_date_type_id;
	gitg_date_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgDate", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_date_type_id, g_initable_get_type (), &g_initable_info);
	GitgDate_private_offset = g_type_add_instance_private (gitg_date_type_id, sizeof (GitgDatePrivate));
	return gitg_date_type_id;
}

GType
gitg_date_get_type (void)
{
	static gsize gitg_date_type_id__once = 0;
	if (g_once_init_enter (&gitg_date_type_id__once)) {
		GType gitg_date_type_id;
		gitg_date_type_id = gitg_date_get_type_once ();
		g_once_init_leave (&gitg_date_type_id__once, gitg_date_type_id);
	}
	return gitg_date_type_id__once;
}

static void
_vala_gitg_date_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GitgDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DATE, GitgDate);
	switch (property_id) {
		case GITG_DATE_DATE_STRING_PROPERTY:
		g_value_set_string (value, gitg_date_get_date_string (self));
		break;
		case GITG_DATE_DATE_PROPERTY:
		g_value_set_boxed (value, gitg_date_get_date (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_date_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GitgDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DATE, GitgDate);
	switch (property_id) {
		case GITG_DATE_DATE_STRING_PROPERTY:
		gitg_date_set_date_string (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

