/* imap-engine-replay-update.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-engine-replay-update.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;
typedef struct _GearyImapEngineReplayOperationPrivate GearyImapEngineReplayOperationPrivate;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE
} GearyImapEngineReplayOperationStatus;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_STATUS (geary_imap_engine_replay_operation_status_get_type ())

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE (geary_imap_engine_replay_update_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_UPDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE, GearyImapEngineReplayUpdate))
#define GEARY_IMAP_ENGINE_REPLAY_UPDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE, GearyImapEngineReplayUpdateClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_UPDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE))
#define GEARY_IMAP_ENGINE_IS_REPLAY_UPDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE))
#define GEARY_IMAP_ENGINE_REPLAY_UPDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE, GearyImapEngineReplayUpdateClass))

typedef struct _GearyImapEngineReplayUpdate GearyImapEngineReplayUpdate;
typedef struct _GearyImapEngineReplayUpdateClass GearyImapEngineReplayUpdateClass;
typedef struct _GearyImapEngineReplayUpdatePrivate GearyImapEngineReplayUpdatePrivate;

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
enum  {
	GEARY_IMAP_ENGINE_REPLAY_UPDATE_0_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_UPDATE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_replay_update_properties[GEARY_IMAP_ENGINE_REPLAY_UPDATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_AND_REMOTE,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY
} GearyImapEngineReplayOperationScope;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_SCOPE (geary_imap_engine_replay_operation_scope_get_type ())
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE
} GearyImapEngineReplayOperationOnError;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR (geary_imap_engine_replay_operation_on_error_get_type ())

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;
typedef enum  {
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE = 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_PARTIAL_OK = 1 << 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDE_MARKED_FOR_REMOVE = 1 << 1,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDING_ID = 1 << 2,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST = 1 << 3,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_ONLY_INCOMPLETE = 1 << 4
} GearyImapDBFolderListFlags;

#define GEARY_IMAP_DB_FOLDER_TYPE_LIST_FLAGS (geary_imap_db_folder_list_flags_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapEngineReplayUpdateReplayRemoteAsyncData GearyImapEngineReplayUpdateReplayRemoteAsyncData;

struct _GearyImapEngineReplayOperation {
	GearyBaseObject parent_instance;
	GearyImapEngineReplayOperationPrivate * priv;
};

struct _GearyImapEngineReplayOperationClass {
	GearyBaseObjectClass parent_class;
	void (*notify_remote_removed_position) (GearyImapEngineReplayOperation* self, GearyImapSequenceNumber* removed);
	void (*notify_remote_removed_ids) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*get_ids_to_be_remote_removed) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*replay_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyImapEngineReplayOperationStatus (*replay_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*replay_remote_async) (GearyImapEngineReplayOperation* self, GearyImapFolderSession* remote, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*replay_remote_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*backout_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*backout_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	gchar* (*describe_state) (GearyImapEngineReplayOperation* self);
};

struct _GearyImapEngineReplayUpdate {
	GearyImapEngineReplayOperation parent_instance;
	GearyImapEngineReplayUpdatePrivate * priv;
};

struct _GearyImapEngineReplayUpdateClass {
	GearyImapEngineReplayOperationClass parent_class;
};

struct _GearyImapEngineReplayUpdatePrivate {
	GearyImapEngineMinimalFolder* owner;
	gint remote_count;
	GearyImapSequenceNumber* position;
	GearyImapFetchedData* data;
};

struct _GearyImapEngineReplayUpdateReplayRemoteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayUpdate* self;
	GearyImapFolderSession* remote;
	GearyImapMessageFlags* message_flags;
	GearyImapFetchedData* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	gpointer _tmp3_;
	GearyImapMessageData* _tmp4_;
	GearyImapMessageFlags* _tmp5_;
	GearyImapMessageFlags* _tmp6_;
	gint local_count;
	gint64 local_position;
	gint _tmp7_;
	GearyImapEngineMinimalFolder* _tmp8_;
	GearyImapDBFolder* _tmp9_;
	GearyImapDBFolder* _tmp10_;
	GearyImapSequenceNumber* _tmp11_;
	gint64 _tmp12_;
	gint64 _tmp13_;
	GearyImapDBEmailIdentifier* id;
	GearyImapDBEmailIdentifier* _tmp14_;
	GearyImapEngineMinimalFolder* _tmp15_;
	GearyImapDBFolder* _tmp16_;
	GearyImapDBFolder* _tmp17_;
	GearyImapDBEmailIdentifier* _tmp18_;
	GearyImapDBEmailIdentifier* _tmp19_;
	GearyImapDBEmailIdentifier* _tmp20_;
	GeeMap* changed_map;
	GeeHashMap* _tmp21_;
	GeeMap* _tmp22_;
	GearyImapDBEmailIdentifier* _tmp23_;
	GearyImapMessageFlags* _tmp24_;
	GearyImapEmailFlags* _tmp25_;
	GearyImapEmailFlags* _tmp26_;
	GearyImapEngineMinimalFolder* _tmp27_;
	GearyImapDBFolder* _tmp28_;
	GearyImapDBFolder* _tmp29_;
	GeeMap* _tmp30_;
	GearyImapEngineMinimalFolder* _tmp31_;
	GearyImapDBFolder* _tmp32_;
	GearyImapDBFolder* _tmp33_;
	GearyImapDBEmailIdentifier* _tmp34_;
	GearyEmail* _tmp35_;
	GearyEmail* _tmp36_;
	GearyImapEngineMinimalFolder* _tmp37_;
	GeeMap* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GearyImapFetchedData* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GError* _inner_error0_;
};

static gint GearyImapEngineReplayUpdate_private_offset;
static gpointer geary_imap_engine_replay_update_parent_class = NULL;

VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_update_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self);
VALA_EXTERN GearyImapEngineReplayUpdate* geary_imap_engine_replay_update_new (GearyImapEngineMinimalFolder* owner,
                                                                  gint remote_count,
                                                                  GearyImapSequenceNumber* position,
                                                                  GearyImapFetchedData* data);
VALA_EXTERN GearyImapEngineReplayUpdate* geary_imap_engine_replay_update_construct (GType object_type,
                                                                        GearyImapEngineMinimalFolder* owner,
                                                                        gint remote_count,
                                                                        GearyImapSequenceNumber* position,
                                                                        GearyImapFetchedData* data);
VALA_EXTERN GType geary_imap_engine_replay_operation_scope_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_on_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineReplayOperation* geary_imap_engine_replay_operation_construct (GType object_type,
                                                                              const gchar* name,
                                                                              GearyImapEngineReplayOperationScope scope,
                                                                              GearyImapEngineReplayOperationOnError on_remote_error);
static void geary_imap_engine_replay_update_real_replay_remote_async_data_free (gpointer _data);
static void geary_imap_engine_replay_update_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                               GearyImapFolderSession* remote,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static gboolean geary_imap_engine_replay_update_real_replay_remote_async_co (GearyImapEngineReplayUpdateReplayRemoteAsyncData* _data_);
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBFolder* geary_imap_engine_minimal_folder_get_local_folder (GearyImapEngineMinimalFolder* self);
VALA_EXTERN GType geary_imap_db_folder_list_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_folder_get_email_count_async (GearyImapDBFolder* self,
                                                 GearyImapDBFolderListFlags flags,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN gint geary_imap_db_folder_get_email_count_finish (GearyImapDBFolder* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void geary_imap_engine_replay_update_replay_remote_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
VALA_EXTERN void geary_imap_db_folder_get_id_at_async (GearyImapDBFolder* self,
                                           gint64 pos,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_folder_get_id_at_finish (GearyImapDBFolder* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
VALA_EXTERN void geary_imap_db_folder_set_email_flags_async (GearyImapDBFolder* self,
                                                 GeeMap* map,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void geary_imap_db_folder_set_email_flags_finish (GearyImapDBFolder* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
VALA_EXTERN void geary_imap_db_folder_fetch_email_async (GearyImapDBFolder* self,
                                             GearyImapDBEmailIdentifier* id,
                                             GearyEmailField required_fields,
                                             GearyImapDBFolderListFlags flags,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN GearyEmail* geary_imap_db_folder_fetch_email_finish (GearyImapDBFolder* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
VALA_EXTERN void geary_imap_engine_minimal_folder_replay_notify_email_flags_changed (GearyImapEngineMinimalFolder* self,
                                                                         GeeMap* flag_map);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_to_string (GearyImapEngineReplayOperation* self);
static gchar* geary_imap_engine_replay_update_real_describe_state (GearyImapEngineReplayOperation* base);
static void geary_imap_engine_replay_update_finalize (GObject * obj);
static GType geary_imap_engine_replay_update_get_type_once (void);

static inline gpointer
geary_imap_engine_replay_update_get_instance_private (GearyImapEngineReplayUpdate* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineReplayUpdate_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapEngineReplayUpdate*
geary_imap_engine_replay_update_construct (GType object_type,
                                           GearyImapEngineMinimalFolder* owner,
                                           gint remote_count,
                                           GearyImapSequenceNumber* position,
                                           GearyImapFetchedData* data)
{
	GearyImapEngineReplayUpdate * self = NULL;
	GearyImapEngineMinimalFolder* _tmp0_;
	GearyImapSequenceNumber* _tmp1_;
	GearyImapFetchedData* _tmp2_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (owner), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (position), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_FETCHED_DATA (data), NULL);
	self = (GearyImapEngineReplayUpdate*) geary_imap_engine_replay_operation_construct (object_type, "Update", GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY, GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY);
	_tmp0_ = _g_object_ref0 (owner);
	_g_object_unref0 (self->priv->owner);
	self->priv->owner = _tmp0_;
	self->priv->remote_count = remote_count;
	_tmp1_ = _g_object_ref0 (position);
	_g_object_unref0 (self->priv->position);
	self->priv->position = _tmp1_;
	_tmp2_ = _g_object_ref0 (data);
	_g_object_unref0 (self->priv->data);
	self->priv->data = _tmp2_;
	return self;
}

GearyImapEngineReplayUpdate*
geary_imap_engine_replay_update_new (GearyImapEngineMinimalFolder* owner,
                                     gint remote_count,
                                     GearyImapSequenceNumber* position,
                                     GearyImapFetchedData* data)
{
	return geary_imap_engine_replay_update_construct (GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE, owner, remote_count, position, data);
}

static void
geary_imap_engine_replay_update_real_replay_remote_async_data_free (gpointer _data)
{
	GearyImapEngineReplayUpdateReplayRemoteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayUpdateReplayRemoteAsyncData, _data_);
}

static void
geary_imap_engine_replay_update_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                          GearyImapFolderSession* remote,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	GearyImapEngineReplayUpdate * self;
	GearyImapEngineReplayUpdateReplayRemoteAsyncData* _data_;
	GearyImapEngineReplayUpdate* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE, GearyImapEngineReplayUpdate);
	_data_ = g_slice_new0 (GearyImapEngineReplayUpdateReplayRemoteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_update_real_replay_remote_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_replay_update_real_replay_remote_async_co (_data_);
}

static void
geary_imap_engine_replay_update_replay_remote_finish (GearyImapEngineReplayOperation* base,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	GearyImapEngineReplayUpdateReplayRemoteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_replay_update_replay_remote_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	GearyImapEngineReplayUpdateReplayRemoteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_replay_update_real_replay_remote_async_co (_data_);
}

static gboolean
geary_imap_engine_replay_update_real_replay_remote_async_co (GearyImapEngineReplayUpdateReplayRemoteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->data;
	_data_->_tmp1_ = geary_imap_fetched_data_get_data_map (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gee_map_get (_data_->_tmp2_, (gpointer) ((gintptr) GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS));
	_data_->_tmp4_ = (GearyImapMessageData*) _data_->_tmp3_;
	_data_->_tmp5_ = GEARY_IMAP_IS_MESSAGE_FLAGS (_data_->_tmp4_) ? ((GearyImapMessageFlags*) _data_->_tmp4_) : NULL;
	if (_data_->_tmp5_ == NULL) {
		_g_object_unref0 (_data_->_tmp4_);
	}
	_data_->message_flags = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->message_flags;
	if (_data_->_tmp6_ != NULL) {
		_data_->local_count = -1;
		_data_->local_position = (gint64) -1;
		_data_->_tmp8_ = _data_->self->priv->owner;
		_data_->_tmp9_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_state_ = 1;
		geary_imap_db_folder_get_email_count_async (_data_->_tmp10_, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDE_MARKED_FOR_REMOVE, NULL, geary_imap_engine_replay_update_replay_remote_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = geary_imap_db_folder_get_email_count_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->message_flags);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->local_count = _data_->_tmp7_;
		_data_->_tmp11_ = _data_->self->priv->position;
		_data_->_tmp12_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->local_position = _data_->_tmp13_ - (_data_->self->priv->remote_count - _data_->local_count);
		_data_->id = NULL;
		if (_data_->local_position > ((gint64) 0)) {
			_data_->_tmp15_ = _data_->self->priv->owner;
			_data_->_tmp16_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_state_ = 2;
			geary_imap_db_folder_get_id_at_async (_data_->_tmp17_, _data_->local_position, NULL, geary_imap_engine_replay_update_replay_remote_async_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp18_ = geary_imap_db_folder_get_id_at_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp14_ = _data_->_tmp18_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->id);
				_g_object_unref0 (_data_->message_flags);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp19_ = _data_->_tmp14_;
			_data_->_tmp14_ = NULL;
			_g_object_unref0 (_data_->id);
			_data_->id = _data_->_tmp19_;
			_g_object_unref0 (_data_->_tmp14_);
		}
		_data_->_tmp20_ = _data_->id;
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = gee_hash_map_new (GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_EMAIL_FLAGS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_data_->changed_map = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, GEE_TYPE_MAP, GeeMap);
			_data_->_tmp22_ = _data_->changed_map;
			_data_->_tmp23_ = _data_->id;
			_data_->_tmp24_ = _data_->message_flags;
			_data_->_tmp25_ = geary_imap_email_flags_new (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			gee_map_set (_data_->_tmp22_, _data_->_tmp23_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, GEARY_TYPE_EMAIL_FLAGS, GearyEmailFlags));
			_g_object_unref0 (_data_->_tmp26_);
			_data_->_tmp27_ = _data_->self->priv->owner;
			_data_->_tmp28_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp27_);
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = _data_->changed_map;
			_data_->_state_ = 3;
			geary_imap_db_folder_set_email_flags_async (_data_->_tmp29_, _data_->_tmp30_, NULL, geary_imap_engine_replay_update_replay_remote_async_ready, _data_);
			return FALSE;
			_state_3:
			geary_imap_db_folder_set_email_flags_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->changed_map);
				_g_object_unref0 (_data_->id);
				_g_object_unref0 (_data_->message_flags);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			{
				_data_->_tmp31_ = _data_->self->priv->owner;
				_data_->_tmp32_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp31_);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = _data_->id;
				_data_->_state_ = 4;
				geary_imap_db_folder_fetch_email_async (_data_->_tmp33_, _data_->_tmp34_, GEARY_EMAIL_FIELD_NONE, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE, NULL, geary_imap_engine_replay_update_replay_remote_async_ready, _data_);
				return FALSE;
				_state_4:
				_data_->_tmp35_ = geary_imap_db_folder_fetch_email_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp36_ = _data_->_tmp35_;
				_g_object_unref0 (_data_->_tmp36_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if (g_error_matches (_data_->_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
						goto __catch0_geary_engine_error_not_found;
					}
					goto __finally0;
				}
				_data_->_tmp37_ = _data_->self->priv->owner;
				_data_->_tmp38_ = _data_->changed_map;
				geary_imap_engine_minimal_folder_replay_notify_email_flags_changed (_data_->_tmp37_, _data_->_tmp38_);
			}
			goto __finally0;
			__catch0_geary_engine_error_not_found:
			{
				g_clear_error (&_data_->_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->changed_map);
				_g_object_unref0 (_data_->id);
				_g_object_unref0 (_data_->message_flags);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->changed_map);
		} else {
			_data_->_tmp39_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
			_data_->_tmp40_ = _data_->_tmp39_;
			g_debug ("imap-engine-replay-update.vala:74: %s replay_local_async id is null!", _data_->_tmp40_);
			_g_free0 (_data_->_tmp40_);
		}
		_g_object_unref0 (_data_->id);
	} else {
		_data_->_tmp41_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_tmp43_ = _data_->self->priv->data;
		_data_->_tmp44_ = geary_imap_fetched_data_to_string (_data_->_tmp43_);
		_data_->_tmp45_ = _data_->_tmp44_;
		g_debug ("imap-engine-replay-update.vala:77: %s Don't know what to do without an" \
"y FLAGS: %s", _data_->_tmp42_, _data_->_tmp45_);
		_g_free0 (_data_->_tmp45_);
		_g_free0 (_data_->_tmp42_);
	}
	_g_object_unref0 (_data_->message_flags);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
geary_imap_engine_replay_update_real_describe_state (GearyImapEngineReplayOperation* base)
{
	GearyImapEngineReplayUpdate * self;
	GearyImapMessageData* fetch_flags = NULL;
	GearyImapFetchedData* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_ = NULL;
	GearyImapMessageData* _tmp5_;
	GearyImapSequenceNumber* _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE, GearyImapEngineReplayUpdate);
	_tmp0_ = self->priv->data;
	_tmp1_ = geary_imap_fetched_data_get_data_map (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get (_tmp2_, (gpointer) ((gintptr) GEARY_IMAP_FETCH_DATA_SPECIFIER_FLAGS));
	fetch_flags = (GearyImapMessageData*) _tmp3_;
	_tmp5_ = fetch_flags;
	if (_tmp5_ != NULL) {
		GearyImapMessageData* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = fetch_flags;
		_tmp7_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp7_;
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("null");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp8_;
	}
	_tmp9_ = self->priv->position;
	_tmp10_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("position.value=%lld, flags=%s", _tmp11_, _tmp4_);
	result = _tmp12_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (fetch_flags);
	return result;
}

static void
geary_imap_engine_replay_update_class_init (GearyImapEngineReplayUpdateClass * klass,
                                            gpointer klass_data)
{
	geary_imap_engine_replay_update_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineReplayUpdate_private_offset);
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_async = (void (*) (GearyImapEngineReplayOperation*, GearyImapFolderSession*, GAsyncReadyCallback, gpointer)) geary_imap_engine_replay_update_real_replay_remote_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_replay_update_replay_remote_finish;
	((GearyImapEngineReplayOperationClass *) klass)->describe_state = (gchar* (*) (GearyImapEngineReplayOperation*)) geary_imap_engine_replay_update_real_describe_state;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_replay_update_finalize;
}

static void
geary_imap_engine_replay_update_instance_init (GearyImapEngineReplayUpdate * self,
                                               gpointer klass)
{
	self->priv = geary_imap_engine_replay_update_get_instance_private (self);
}

static void
geary_imap_engine_replay_update_finalize (GObject * obj)
{
	GearyImapEngineReplayUpdate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_REPLAY_UPDATE, GearyImapEngineReplayUpdate);
	_g_object_unref0 (self->priv->owner);
	_g_object_unref0 (self->priv->position);
	_g_object_unref0 (self->priv->data);
	G_OBJECT_CLASS (geary_imap_engine_replay_update_parent_class)->finalize (obj);
}

/**
 * Updates an existing message locally after an unsolicited FETCH.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_engine_replay_update_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineReplayUpdateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_replay_update_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineReplayUpdate), 0, (GInstanceInitFunc) geary_imap_engine_replay_update_instance_init, NULL };
	GType geary_imap_engine_replay_update_type_id;
	geary_imap_engine_replay_update_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, "GearyImapEngineReplayUpdate", &g_define_type_info, 0);
	GearyImapEngineReplayUpdate_private_offset = g_type_add_instance_private (geary_imap_engine_replay_update_type_id, sizeof (GearyImapEngineReplayUpdatePrivate));
	return geary_imap_engine_replay_update_type_id;
}

GType
geary_imap_engine_replay_update_get_type (void)
{
	static gsize geary_imap_engine_replay_update_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_replay_update_type_id__once)) {
		GType geary_imap_engine_replay_update_type_id;
		geary_imap_engine_replay_update_type_id = geary_imap_engine_replay_update_get_type_once ();
		g_once_init_leave (&geary_imap_engine_replay_update_type_id__once, geary_imap_engine_replay_update_type_id);
	}
	return geary_imap_engine_replay_update_type_id__once;
}

