/* plugin-application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin-application.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLUGIN_APPLICATION_COMPOSER_REGISTERED_SIGNAL,
	PLUGIN_APPLICATION_COMPOSER_DEREGISTERED_SIGNAL,
	PLUGIN_APPLICATION_NUM_SIGNALS
};
static guint plugin_application_signals[PLUGIN_APPLICATION_NUM_SIGNALS] = {0};

static GType plugin_application_get_type_once (void);

void
plugin_application_compose_blank (PluginApplication* self,
                                  PluginAccount* send_from,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	PluginApplicationIface* _iface_;
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->compose_blank) {
		_iface_->compose_blank (self, send_from, _callback_, _user_data_);
	}
}

PluginComposer*
plugin_application_compose_blank_finish (PluginApplication* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	PluginApplicationIface* _iface_;
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->compose_blank_finish) {
		return _iface_->compose_blank_finish (self, _res_, error);
	}
	return NULL;
}

void
plugin_application_compose_with_context (PluginApplication* self,
                                         PluginAccount* send_from,
                                         PluginComposerContextType type,
                                         PluginEmailIdentifier* context,
                                         const gchar* quote,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	PluginApplicationIface* _iface_;
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->compose_with_context) {
		_iface_->compose_with_context (self, send_from, type, context, quote, _callback_, _user_data_);
	}
}

PluginComposer*
plugin_application_compose_with_context_finish (PluginApplication* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	PluginApplicationIface* _iface_;
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->compose_with_context_finish) {
		return _iface_->compose_with_context_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Registers a plugin action with the application.
     *
     * Once registered, the action will be available for use in user
     * interface elements such as {@link Actionable}.
     *
     * @see deregister_action
     */
void
plugin_application_register_action (PluginApplication* self,
                                    GAction* action)
{
	PluginApplicationIface* _iface_;
	g_return_if_fail (PLUGIN_IS_APPLICATION (self));
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->register_action) {
		_iface_->register_action (self, action);
	}
}

/**
     * De-registers a plugin action with the application.
     *
     * Makes a previously registered no longer available.
     *
     * @see register_action
     */
void
plugin_application_deregister_action (PluginApplication* self,
                                      GAction* action)
{
	PluginApplicationIface* _iface_;
	g_return_if_fail (PLUGIN_IS_APPLICATION (self));
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->deregister_action) {
		_iface_->deregister_action (self, action);
	}
}

/** Displays a folder in the most recently used main window. */
void
plugin_application_show_folder (PluginApplication* self,
                                PluginFolder* folder)
{
	PluginApplicationIface* _iface_;
	g_return_if_fail (PLUGIN_IS_APPLICATION (self));
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->show_folder) {
		_iface_->show_folder (self, folder);
	}
}

void
plugin_application_empty_folder (PluginApplication* self,
                                 PluginFolder* folder,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	PluginApplicationIface* _iface_;
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->empty_folder) {
		_iface_->empty_folder (self, folder, _callback_, _user_data_);
	}
}

void
plugin_application_empty_folder_finish (PluginApplication* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	PluginApplicationIface* _iface_;
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->empty_folder_finish) {
		_iface_->empty_folder_finish (self, _res_, error);
	}
}

/**
     * Sends a problem report to the application.
     *
     * Calling this method will display a problem report for the
     * plugin with a given error so that both people using the
     * application are aware that an error condition exists, and that
     * they may report the problem to developers.
     *
     * Since displaying an error report causes visual and workflow
     * disruptions, and as such this method called with care and only
     * when necessary. For logging, use {@link GLib.debug} and related
     * methods and these will appear in Geary's Inspector.
     */
void
plugin_application_report_problem (PluginApplication* self,
                                   GearyProblemReport* problem)
{
	PluginApplicationIface* _iface_;
	g_return_if_fail (PLUGIN_IS_APPLICATION (self));
	_iface_ = PLUGIN_APPLICATION_GET_INTERFACE (self);
	if (_iface_->report_problem) {
		_iface_->report_problem (self, problem);
	}
}

static void
plugin_application_default_init (PluginApplicationIface * iface,
                                 gpointer iface_data)
{
	/**
	     * Emitted when a new composer is registered with the application.
	     *
	     * A composer is registered when it is first constructed.
	     *
	     * @see Composer.present
	     */
	plugin_application_signals[PLUGIN_APPLICATION_COMPOSER_REGISTERED_SIGNAL] = g_signal_new ("composer-registered", PLUGIN_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PLUGIN_TYPE_COMPOSER);
	/**
	     * Emitted when an existing composer is de-registered.
	     *
	     * A composer is deregistered when it is destroyed, either after
	     * being sent, closed, or discarded.
	     */
	plugin_application_signals[PLUGIN_APPLICATION_COMPOSER_DEREGISTERED_SIGNAL] = g_signal_new ("composer-deregistered", PLUGIN_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PLUGIN_TYPE_COMPOSER);
}

/**
 * An object representing the client application for use by plugins.
 *
 * Plugins may obtain instances of this object from the {@link
 * PluginBase.plugin_application} property.
 */
static GType
plugin_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginApplicationIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_application_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_application_type_id;
	plugin_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginApplication", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_application_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_application_type_id;
}

GType
plugin_application_get_type (void)
{
	static volatile gsize plugin_application_type_id__once = 0;
	if (g_once_init_enter (&plugin_application_type_id__once)) {
		GType plugin_application_type_id;
		plugin_application_type_id = plugin_application_get_type_once ();
		g_once_init_leave (&plugin_application_type_id__once, plugin_application_type_id);
	}
	return plugin_application_type_id__once;
}

