/* components-search-bar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from components-search-bar.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gtk/gtk.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <handy.h>

#define SEARCH_BAR_DEFAULT_SEARCH_TEXT _ ("Search")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEARCH_BAR_0_PROPERTY,
	SEARCH_BAR_ENTRY_PROPERTY,
	SEARCH_BAR_NUM_PROPERTIES
};
static GParamSpec* search_bar_properties[SEARCH_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SEARCH_BAR_SEARCH_TEXT_CHANGED_SIGNAL,
	SEARCH_BAR_NUM_SIGNALS
};
static guint search_bar_signals[SEARCH_BAR_NUM_SIGNALS] = {0};

struct _SearchBarPrivate {
	GtkSearchEntry* _entry;
	ComponentsEntryUndo* search_undo;
	GearyAccount* current_account;
	GearyEngine* engine;
};

static gint SearchBar_private_offset;
static gpointer search_bar_parent_class = NULL;

static void search_bar_set_entry (SearchBar* self,
                           GtkSearchEntry* value);
static void search_bar_on_search_mode_changed (SearchBar* self);
static void _search_bar_on_search_mode_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void __lambda93_ (SearchBar* self);
static void ___lambda93__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                   gpointer self);
static void __lambda94_ (SearchBar* self);
static void ___lambda94__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void search_bar_real_grab_focus (GtkWidget* base);
static void search_bar_on_information_changed (SearchBar* self);
static void _search_bar_on_information_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                           gpointer self);
static void search_bar_finalize (GObject * obj);
static GType search_bar_get_type_once (void);
static void _vala_search_bar_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_search_bar_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static inline gpointer
search_bar_get_instance_private (SearchBar* self)
{
	return G_STRUCT_MEMBER_P (self, SearchBar_private_offset);
}

GtkSearchEntry*
search_bar_get_entry (SearchBar* self)
{
	GtkSearchEntry* result;
	GtkSearchEntry* _tmp0_;
	g_return_val_if_fail (IS_SEARCH_BAR (self), NULL);
	_tmp0_ = self->priv->_entry;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
search_bar_set_entry (SearchBar* self,
                      GtkSearchEntry* value)
{
	GtkSearchEntry* old_value;
	g_return_if_fail (IS_SEARCH_BAR (self));
	old_value = search_bar_get_entry (self);
	if (old_value != value) {
		GtkSearchEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_entry);
		self->priv->_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, search_bar_properties[SEARCH_BAR_ENTRY_PROPERTY]);
	}
}

static void
_search_bar_on_search_mode_changed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	search_bar_on_search_mode_changed ((SearchBar*) self);
}

static void
__lambda93_ (SearchBar* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	_tmp2_ = _tmp1_;
	g_signal_emit (self, search_bar_signals[SEARCH_BAR_SEARCH_TEXT_CHANGED_SIGNAL], 0, _tmp2_);
}

static void
___lambda93__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                              gpointer self)
{
	__lambda93_ ((SearchBar*) self);
}

static void
__lambda94_ (SearchBar* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	_tmp2_ = _tmp1_;
	g_signal_emit (self, search_bar_signals[SEARCH_BAR_SEARCH_TEXT_CHANGED_SIGNAL], 0, _tmp2_);
}

static void
___lambda94__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda94_ ((SearchBar*) self);
}

SearchBar*
search_bar_construct (GType object_type,
                      GearyEngine* engine)
{
	SearchBar * self = NULL;
	GearyEngine* _tmp0_;
	GtkSearchEntry* _tmp1_;
	ComponentsEntryUndo* _tmp2_;
	GtkSearchEntry* _tmp3_;
	GtkSearchEntry* _tmp4_;
	GtkSearchEntry* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkSearchEntry* _tmp7_;
	HdyClamp* column = NULL;
	HdyClamp* _tmp8_;
	GtkSearchEntry* _tmp9_;
	GtkSearchEntry* _tmp10_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (engine, GEARY_TYPE_ENGINE), NULL);
	self = (SearchBar*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (engine);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	_tmp1_ = self->priv->_entry;
	_tmp2_ = components_entry_undo_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->search_undo);
	self->priv->search_undo = _tmp2_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::search-mode-enabled", (GCallback) _search_bar_on_search_mode_changed_g_object_notify, self, 0);
	_tmp3_ = self->priv->_entry;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _ ("Search all mail in account for keywords"));
	_tmp4_ = self->priv->_entry;
	g_signal_connect_object (_tmp4_, "search-changed", (GCallback) ___lambda93__gtk_search_entry_search_changed, self, 0);
	_tmp5_ = self->priv->_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_entry_get_type (), GtkEntry), "activate", (GCallback) ___lambda94__gtk_entry_activate, self, 0);
	_tmp6_ = self->priv->_entry;
	gtk_entry_set_placeholder_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_entry_get_type (), GtkEntry), SEARCH_BAR_DEFAULT_SEARCH_TEXT);
	_tmp7_ = self->priv->_entry;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), "has-focus", TRUE, NULL);
	_tmp8_ = (HdyClamp*) hdy_clamp_new ();
	g_object_ref_sink (_tmp8_);
	column = _tmp8_;
	hdy_clamp_set_maximum_size (column, 400);
	_tmp9_ = self->priv->_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (column, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->_entry;
	hdy_search_bar_connect_entry (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_search_bar_get_type (), HdySearchBar), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_entry_get_type (), GtkEntry));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (column, gtk_widget_get_type (), GtkWidget));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (column);
	return self;
}

SearchBar*
search_bar_new (GearyEngine* engine)
{
	return search_bar_construct (TYPE_SEARCH_BAR, engine);
}

static void
search_bar_real_grab_focus (GtkWidget* base)
{
	SearchBar * self;
	GtkSearchEntry* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_BAR, SearchBar);
	hdy_search_bar_set_search_mode (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_search_bar_get_type (), HdySearchBar), TRUE);
	_tmp0_ = self->priv->_entry;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

static void
_search_bar_on_information_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                      gpointer self)
{
	search_bar_on_information_changed ((SearchBar*) self);
}

void
search_bar_set_account (SearchBar* self,
                        GearyAccount* account)
{
	GearyAccount* _tmp0_;
	GearyAccount* _tmp7_;
	g_return_if_fail (IS_SEARCH_BAR (self));
	g_return_if_fail ((account == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	_tmp0_ = self->priv->current_account;
	if (_tmp0_ != NULL) {
		GearyAccount* _tmp1_;
		GearyAccountInformation* _tmp2_;
		GearyAccountInformation* _tmp3_;
		guint _tmp4_;
		_tmp1_ = self->priv->current_account;
		_tmp2_ = geary_account_get_information (_tmp1_);
		_tmp3_ = _tmp2_;
		g_signal_parse_name ("changed", GEARY_TYPE_ACCOUNT_INFORMATION, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _search_bar_on_information_changed_geary_account_information_changed, self);
	}
	if (account != NULL) {
		GearyAccountInformation* _tmp5_;
		GearyAccountInformation* _tmp6_;
		_tmp5_ = geary_account_get_information (account);
		_tmp6_ = _tmp5_;
		g_signal_connect_object (_tmp6_, "changed", (GCallback) _search_bar_on_information_changed_geary_account_information_changed, self, 0);
	}
	_tmp7_ = _g_object_ref0 (account);
	_g_object_unref0 (self->priv->current_account);
	self->priv->current_account = _tmp7_;
	search_bar_on_information_changed (self);
}

static void
search_bar_on_information_changed (SearchBar* self)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GearyAccount* _tmp2_;
	GtkSearchEntry* _tmp13_;
	g_return_if_fail (IS_SEARCH_BAR (self));
	_tmp2_ = self->priv->current_account;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GearyEngine* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp3_ = self->priv->engine;
		_tmp4_ = geary_engine_get_accounts_count (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == ((guint) 1);
	}
	if (_tmp1_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (SEARCH_BAR_DEFAULT_SEARCH_TEXT);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	} else {
		GearyAccount* _tmp7_;
		GearyAccountInformation* _tmp8_;
		GearyAccountInformation* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = self->priv->current_account;
		_tmp8_ = geary_account_get_information (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = geary_account_information_get_display_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf (_ ("Search %s account"), _tmp11_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp12_;
	}
	_tmp13_ = self->priv->_entry;
	gtk_entry_set_placeholder_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_entry_get_type (), GtkEntry), _tmp0_);
	_g_free0 (_tmp0_);
}

static void
search_bar_on_search_mode_changed (SearchBar* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (IS_SEARCH_BAR (self));
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (self, hdy_search_bar_get_type (), HdySearchBar), "search-mode-enabled", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		ComponentsEntryUndo* _tmp2_;
		_tmp2_ = self->priv->search_undo;
		components_entry_undo_reset (_tmp2_);
	}
}

static void
search_bar_class_init (SearchBarClass * klass,
                       gpointer klass_data)
{
	search_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchBar_private_offset);
	((GtkWidgetClass *) klass)->grab_focus = (void (*) (GtkWidget*)) search_bar_real_grab_focus;
	G_OBJECT_CLASS (klass)->get_property = _vala_search_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_search_bar_set_property;
	G_OBJECT_CLASS (klass)->finalize = search_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_BAR_ENTRY_PROPERTY, search_bar_properties[SEARCH_BAR_ENTRY_PROPERTY] = g_param_spec_object ("entry", "entry", "entry", gtk_search_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	search_bar_signals[SEARCH_BAR_SEARCH_TEXT_CHANGED_SIGNAL] = g_signal_new ("search-text-changed", TYPE_SEARCH_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
search_bar_instance_init (SearchBar * self,
                          gpointer klass)
{
	GtkSearchEntry* _tmp0_;
	self->priv = search_bar_get_instance_private (self);
	_tmp0_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->_entry = _tmp0_;
	self->priv->current_account = NULL;
}

static void
search_bar_finalize (GObject * obj)
{
	SearchBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_BAR, SearchBar);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->search_undo);
	_g_object_unref0 (self->priv->current_account);
	_g_object_unref0 (self->priv->engine);
	G_OBJECT_CLASS (search_bar_parent_class)->finalize (obj);
}

static GType
search_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchBar), 0, (GInstanceInitFunc) search_bar_instance_init, NULL };
	GType search_bar_type_id;
	search_bar_type_id = g_type_register_static (hdy_search_bar_get_type (), "SearchBar", &g_define_type_info, 0);
	SearchBar_private_offset = g_type_add_instance_private (search_bar_type_id, sizeof (SearchBarPrivate));
	return search_bar_type_id;
}

GType
search_bar_get_type (void)
{
	static volatile gsize search_bar_type_id__once = 0;
	if (g_once_init_enter (&search_bar_type_id__once)) {
		GType search_bar_type_id;
		search_bar_type_id = search_bar_get_type_once ();
		g_once_init_leave (&search_bar_type_id__once, search_bar_type_id);
	}
	return search_bar_type_id__once;
}

static void
_vala_search_bar_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	SearchBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_BAR, SearchBar);
	switch (property_id) {
		case SEARCH_BAR_ENTRY_PROPERTY:
		g_value_set_object (value, search_bar_get_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_search_bar_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	SearchBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_BAR, SearchBar);
	switch (property_id) {
		case SEARCH_BAR_ENTRY_PROPERTY:
		search_bar_set_entry (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

