/* PanelWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PanelWindow.vala, do not modify */

/*
 * Copyright 2024-2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <mtk/mtk.h>
#include <glib.h>
#include "gala.h"
#include <float.h>
#include <math.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <meta/window.h>
#include <meta/boxes.h>
#include <meta/display.h>
#include <clutter/clutter.h>
#include <meta/workspace.h>
#include <meta/common.h>
#include <string.h>
#include <meta/meta-plugin.h>
#include <meta/meta-workspace-manager.h>
#include <stdlib.h>
#include <meta/meta-window-actor.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;
typedef struct _GalaPositionedWindowPrivate GalaPositionedWindowPrivate;

#define GALA_TYPE_SHELL_WINDOW (gala_shell_window_get_type ())
#define GALA_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindow))
#define GALA_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))
#define GALA_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_WINDOW))
#define GALA_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_WINDOW))
#define GALA_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))

typedef struct _GalaShellWindow GalaShellWindow;
typedef struct _GalaShellWindowClass GalaShellWindowClass;
typedef struct _GalaShellWindowPrivate GalaShellWindowPrivate;

#define GALA_TYPE_PANEL_WINDOW (gala_panel_window_get_type ())
#define GALA_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindow))
#define GALA_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))
#define GALA_IS_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PANEL_WINDOW))
#define GALA_IS_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PANEL_WINDOW))
#define GALA_PANEL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))

typedef struct _GalaPanelWindow GalaPanelWindow;
typedef struct _GalaPanelWindowClass GalaPanelWindowClass;
typedef struct _GalaPanelWindowPrivate GalaPanelWindowPrivate;

#define GALA_TYPE_HIDE_TRACKER (gala_hide_tracker_get_type ())
#define GALA_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTracker))
#define GALA_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))
#define GALA_IS_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_HIDE_TRACKER))
#define GALA_IS_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_HIDE_TRACKER))
#define GALA_HIDE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))

typedef struct _GalaHideTracker GalaHideTracker;
typedef struct _GalaHideTrackerClass GalaHideTrackerClass;
enum  {
	GALA_PANEL_WINDOW_0_PROPERTY,
	GALA_PANEL_WINDOW_ACTOR_PROPERTY,
	GALA_PANEL_WINDOW_WM_PROPERTY,
	GALA_PANEL_WINDOW_ANCHOR_PROPERTY,
	GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY,
	GALA_PANEL_WINDOW_VISIBLE_IN_MULTITASKING_VIEW_PROPERTY,
	GALA_PANEL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_panel_window_properties[GALA_PANEL_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaPositionedWindow {
	GObject parent_instance;
	GalaPositionedWindowPrivate * priv;
};

struct _GalaPositionedWindowClass {
	GObjectClass parent_class;
	void (*get_window_position) (GalaPositionedWindow* self, MtkRectangle* window_rect, gint* x, gint* y);
};

struct _GalaShellWindow {
	GalaPositionedWindow parent_instance;
	GalaShellWindowPrivate * priv;
};

struct _GalaShellWindowClass {
	GalaPositionedWindowClass parent_class;
	void (*propagate) (GalaShellWindow* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	gdouble (*get_hidden_progress) (GalaShellWindow* self);
};

struct _GalaPanelWindow {
	GalaShellWindow parent_instance;
	GalaPanelWindowPrivate * priv;
};

struct _GalaPanelWindowClass {
	GalaShellWindowClass parent_class;
};

struct _GalaPanelWindowPrivate {
	GalaWindowManager* _wm;
	enum io_elementary_pantheon_panel_v1_anchor _anchor;
	enum io_elementary_pantheon_panel_v1_hide_mode _hide_mode;
	gboolean _visible_in_multitasking_view;
	GalaGestureController* user_gesture_controller;
	GalaHideTracker* hide_tracker;
	GalaGestureController* workspace_gesture_controller;
	GalaWorkspaceHideTracker* workspace_hide_tracker;
	gint width;
	gint height;
	gboolean starting;
};

static gint GalaPanelWindow_private_offset;
static gpointer gala_panel_window_parent_class = NULL;
static GHashTable* gala_panel_window_window_struts;
static GHashTable* gala_panel_window_window_struts = NULL;
static GalaRootTargetIface * gala_panel_window_gala_root_target_parent_iface = NULL;

VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellWindow, g_object_unref)
VALA_EXTERN GType gala_panel_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPanelWindow, g_object_unref)
VALA_EXTERN GType gala_hide_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaHideTracker, g_object_unref)
VALA_EXTERN gdouble gala_shell_window_get_hidden_progress (GalaShellWindow* self);
VALA_EXTERN void gala_shell_window_propagate (GalaShellWindow* self,
                                  GalaGestureTargetUpdateType update_type,
                                  GalaGestureAction action,
                                  gdouble progress);
VALA_EXTERN void gala_positioned_window_get_window_position (GalaPositionedWindow* self,
                                                 MtkRectangle* window_rect,
                                                 gint* x,
                                                 gint* y);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
VALA_EXTERN GalaPanelWindow* gala_panel_window_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN GalaPanelWindow* gala_panel_window_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN void gala_panel_window_get_custom_window_rect (GalaPanelWindow* self,
                                               MtkRectangle* result);
VALA_EXTERN MetaWindow* gala_positioned_window_get_window (GalaPositionedWindow* self);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_anchor gala_panel_window_get_anchor (GalaPanelWindow* self);
VALA_EXTERN void gala_panel_window_set_size (GalaPanelWindow* self,
                                 gint width,
                                 gint height);
VALA_EXTERN void gala_positioned_window_position_window (GalaPositionedWindow* self);
VALA_EXTERN void gala_panel_window_request_visible_in_multitasking_view (GalaPanelWindow* self);
static void gala_panel_window_set_visible_in_multitasking_view (GalaPanelWindow* self,
                                                         gboolean value);
VALA_EXTERN void gala_panel_window_animate_start (GalaPanelWindow* self);
static gdouble gala_panel_window_real_get_hidden_progress (GalaShellWindow* base);
VALA_EXTERN gboolean gala_panel_window_get_visible_in_multitasking_view (GalaPanelWindow* self);
static void gala_panel_window_real_propagate (GalaShellWindow* base,
                                       GalaGestureTargetUpdateType update_type,
                                       GalaGestureAction action,
                                       gdouble progress);
static void gala_panel_window_hide (GalaPanelWindow* self);
static void gala_panel_window_show (GalaPanelWindow* self);
static gboolean gala_panel_window_update_overlap (GalaPanelWindow* self,
                                           MetaWorkspace* workspace);
VALA_EXTERN MetaWindow* gala_internal_utils_get_mru_window (MetaWorkspace* workspace,
                                                MetaWindow** any_window);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_hide_mode gala_panel_window_get_hide_mode (GalaPanelWindow* self);
static void gala_panel_window_make_exclusive (GalaPanelWindow* self);
static void gala_panel_window_update_strut (GalaPanelWindow* self);
static MetaSide gala_panel_window_side_from_anchor (GalaPanelWindow* self,
                                             enum io_elementary_pantheon_panel_v1_anchor anchor);
static MetaStrut* _meta_strut_dup (MetaStrut* self);
static void gala_panel_window_update_struts (GalaPanelWindow* self);
VALA_EXTERN GalaWindowManager* gala_panel_window_get_wm (GalaPanelWindow* self);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void gala_panel_window_unmake_exclusive (GalaPanelWindow* self);
static void gala_panel_window_real_get_window_position (GalaPositionedWindow* base,
                                                 MtkRectangle* window_rect,
                                                 gint* x,
                                                 gint* y);
static const char* _pantheon_desktop_anchor_to_string (enum io_elementary_pantheon_panel_v1_anchor value);
static void gala_panel_window_update_target (GalaPanelWindow* self);
VALA_EXTERN void gala_shell_window_set_hide_target (GalaShellWindow* self,
                                        GalaGestureTarget* value);
static void gala_panel_window_update_clip (GalaPanelWindow* self);
static void gala_panel_window_set_wm (GalaPanelWindow* self,
                               GalaWindowManager* value);
VALA_EXTERN void gala_panel_window_set_anchor (GalaPanelWindow* self,
                                   enum io_elementary_pantheon_panel_v1_anchor value);
VALA_EXTERN void gala_panel_window_set_hide_mode (GalaPanelWindow* self,
                                      enum io_elementary_pantheon_panel_v1_hide_mode value);
static GObject * gala_panel_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _gala_panel_window___lambda19_ (GalaPanelWindow* self);
static void __gala_panel_window___lambda19__meta_window_unmanaging (MetaWindow* _sender,
                                                             gpointer self);
static void _gala_positioned_window_position_window_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _gala_panel_window_update_strut_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                             gint object,
                                                                             gpointer self);
static void _gala_panel_window_update_strut_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                               gint object,
                                                                               gpointer self);
static void _gala_panel_window_update_strut_meta_window_size_changed (MetaWindow* _sender,
                                                               gpointer self);
static void _gala_panel_window_update_strut_meta_window_position_changed (MetaWindow* _sender,
                                                                   gpointer self);
static void _gala_panel_window_update_strut_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
VALA_EXTERN GalaHideTracker* gala_hide_tracker_new (MetaDisplay* display,
                                        GalaPanelWindow* panel);
VALA_EXTERN GalaHideTracker* gala_hide_tracker_construct (GType object_type,
                                              MetaDisplay* display,
                                              GalaPanelWindow* panel);
static void _gala_panel_window_hide_gala_hide_tracker_hide (GalaHideTracker* _sender,
                                                     gpointer self);
static void _gala_panel_window_show_gala_hide_tracker_show (GalaHideTracker* _sender,
                                                     gpointer self);
static gboolean _gala_panel_window_update_overlap_gala_workspace_hide_tracker_compute_should_hide_on_workspace (MetaWorkspace* workspace,
                                                                                                         gpointer self);
static void _gala_panel_window___lambda20_ (GalaPanelWindow* self,
                                     gdouble value);
static void __gala_panel_window___lambda20__gala_workspace_hide_tracker_switching_workspace_progress_updated (GalaWorkspaceHideTracker* _sender,
                                                                                                       gdouble new_progress,
                                                                                                       gpointer self);
static void _gala_gesture_controller_goto_gala_workspace_hide_tracker_window_state_changed_progress_updated (GalaWorkspaceHideTracker* _sender,
                                                                                                      gdouble new_progress,
                                                                                                      gpointer self);
static void _gala_panel_window_update_target_meta_window_size_changed (MetaWindow* _sender,
                                                                gpointer self);
static void _gala_panel_window_update_target_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _gala_panel_window_update_clip_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void gala_panel_window_finalize (GObject * obj);
static GType gala_panel_window_get_type_once (void);
static void _vala_gala_panel_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_panel_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_panel_window_get_instance_private (GalaPanelWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPanelWindow_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

GalaPanelWindow*
gala_panel_window_construct (GType object_type,
                             GalaWindowManager* wm,
                             MetaWindow* window,
                             enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	GalaPanelWindow * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaPanelWindow*) g_object_new (object_type, "wm", wm, "window", window, "anchor", anchor, NULL);
	return self;
}

GalaPanelWindow*
gala_panel_window_new (GalaWindowManager* wm,
                       MetaWindow* window,
                       enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	return gala_panel_window_construct (GALA_TYPE_PANEL_WINDOW, wm, window, anchor);
}

void
gala_panel_window_get_custom_window_rect (GalaPanelWindow* self,
                                          MtkRectangle* result)
{
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	meta_window_get_frame_rect (_tmp1_, &_tmp2_);
	window_rect = _tmp2_;
	if (self->priv->width > 0) {
		window_rect.width = self->priv->width;
	}
	if (self->priv->height > 0) {
		enum io_elementary_pantheon_panel_v1_anchor _tmp3_;
		window_rect.height = self->priv->height;
		_tmp3_ = self->priv->_anchor;
		if (_tmp3_ == IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM) {
			MtkRectangle geom = {0};
			MetaWindow* _tmp4_;
			MetaWindow* _tmp5_;
			MetaDisplay* _tmp6_;
			MetaDisplay* _tmp7_;
			MetaWindow* _tmp8_;
			MetaWindow* _tmp9_;
			MtkRectangle _tmp10_ = {0};
			MtkRectangle _tmp11_;
			MtkRectangle _tmp12_;
			_tmp4_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
			_tmp5_ = _tmp4_;
			_tmp6_ = meta_window_get_display (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
			_tmp9_ = _tmp8_;
			meta_display_get_monitor_geometry (_tmp7_, meta_window_get_monitor (_tmp9_), &_tmp10_);
			geom = _tmp10_;
			_tmp11_ = geom;
			_tmp12_ = geom;
			window_rect.y = (_tmp11_.y + _tmp12_.height) - self->priv->height;
		}
	}
	*result = window_rect;
	return;
}

void
gala_panel_window_set_size (GalaPanelWindow* self,
                            gint width,
                            gint height)
{
	g_return_if_fail (self != NULL);
	self->priv->width = width;
	self->priv->height = height;
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

void
gala_panel_window_request_visible_in_multitasking_view (GalaPanelWindow* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	GalaDragDropAction* _tmp2_;
	GalaDragDropAction* _tmp3_;
	g_return_if_fail (self != NULL);
	gala_panel_window_set_visible_in_multitasking_view (self, TRUE);
	_tmp0_ = gala_root_target_get_actor ((GalaRootTarget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	clutter_actor_add_action (_tmp1_, (ClutterAction*) _tmp3_);
	_g_object_unref0 (_tmp3_);
}

void
gala_panel_window_animate_start (GalaPanelWindow* self)
{
	GalaWorkspaceHideTracker* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->starting = FALSE;
	_tmp0_ = self->priv->workspace_hide_tracker;
	gala_workspace_hide_tracker_recalculate_all_workspaces (_tmp0_);
}

static gdouble
gala_panel_window_real_get_hidden_progress (GalaShellWindow* base)
{
	GalaPanelWindow * self;
	gdouble user_workspace_hidden_progress = 0.0;
	GalaGestureController* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GalaGestureController* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gboolean _tmp6_;
	gdouble result;
	self = (GalaPanelWindow*) base;
	_tmp0_ = self->priv->user_gesture_controller;
	_tmp1_ = gala_gesture_controller_get_progress (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->workspace_gesture_controller;
	_tmp4_ = gala_gesture_controller_get_progress (_tmp3_);
	_tmp5_ = _tmp4_;
	user_workspace_hidden_progress = MIN (_tmp2_, _tmp5_);
	_tmp6_ = self->priv->_visible_in_multitasking_view;
	if (_tmp6_) {
		result = MIN (user_workspace_hidden_progress, 1 - GALA_SHELL_WINDOW_CLASS (gala_panel_window_parent_class)->get_hidden_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_SHELL_WINDOW, GalaShellWindow)));
		return result;
	} else {
		result = MAX (user_workspace_hidden_progress, GALA_SHELL_WINDOW_CLASS (gala_panel_window_parent_class)->get_hidden_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_SHELL_WINDOW, GalaShellWindow)));
		return result;
	}
}

static void
gala_panel_window_real_propagate (GalaShellWindow* base,
                                  GalaGestureTargetUpdateType update_type,
                                  GalaGestureAction action,
                                  gdouble progress)
{
	GalaPanelWindow * self;
	GalaWorkspaceHideTracker* _tmp0_;
	self = (GalaPanelWindow*) base;
	_tmp0_ = self->priv->workspace_hide_tracker;
	gala_workspace_hide_tracker_update (_tmp0_, update_type, action, progress);
	GALA_SHELL_WINDOW_CLASS (gala_panel_window_parent_class)->propagate (G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_SHELL_WINDOW, GalaShellWindow), update_type, action, progress);
}

static void
gala_panel_window_hide (GalaPanelWindow* self)
{
	GalaGestureController* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->user_gesture_controller;
	gala_gesture_controller_goto (_tmp0_, (gdouble) 1);
}

static void
gala_panel_window_show (GalaPanelWindow* self)
{
	GalaGestureController* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->user_gesture_controller;
	gala_gesture_controller_goto (_tmp0_, (gdouble) 0);
}

static gboolean
gala_panel_window_update_overlap (GalaPanelWindow* self,
                                  MetaWorkspace* workspace)
{
	gboolean overlap = FALSE;
	gboolean focus_overlap = FALSE;
	gboolean focus_maximized_overlap = FALSE;
	gboolean focus_fullscreen_overlap = FALSE;
	MetaWindow* normal_mru_window = NULL;
	MetaWindow* any_mru_window = NULL;
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_;
	GList* _tmp2_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp27_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp28_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (workspace != NULL, FALSE);
	if (self->priv->starting) {
		result = TRUE;
		return result;
	}
	overlap = FALSE;
	focus_overlap = FALSE;
	focus_maximized_overlap = FALSE;
	focus_fullscreen_overlap = FALSE;
	_tmp1_ = gala_internal_utils_get_mru_window (workspace, &_tmp0_);
	_g_object_unref0 (any_mru_window);
	any_mru_window = _tmp0_;
	_g_object_unref0 (normal_mru_window);
	normal_mru_window = _tmp1_;
	_tmp2_ = meta_workspace_list_windows (workspace);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				MetaWindow* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				MetaWindowType type = 0;
				MetaWindow* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				MtkRectangle _tmp13_ = {0};
				MetaWindow* _tmp14_;
				MtkRectangle _tmp15_ = {0};
				gboolean _tmp16_ = FALSE;
				MetaWindow* _tmp17_;
				MetaWindow* _tmp18_;
				MetaWindow* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				MetaWindow* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp3_ = window;
				_tmp4_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
				_tmp5_ = _tmp4_;
				if (_tmp3_ == _tmp5_) {
					continue;
				}
				_tmp6_ = window;
				g_object_get (_tmp6_, "minimized", &_tmp7_, NULL);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					continue;
				}
				_tmp9_ = window;
				type = meta_window_get_window_type (_tmp9_);
				if (type == META_WINDOW_DESKTOP) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = type == META_WINDOW_DOCK;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = type == META_WINDOW_MENU;
				}
				if (_tmp11_) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = type == META_WINDOW_SPLASHSCREEN;
				}
				if (_tmp10_) {
					continue;
				}
				gala_panel_window_get_custom_window_rect (self, &_tmp13_);
				_tmp14_ = window;
				meta_window_get_frame_rect (_tmp14_, &_tmp15_);
				if (!mtk_rectangle_overlap (&_tmp13_, &_tmp15_)) {
					continue;
				}
				overlap = TRUE;
				_tmp17_ = window;
				_tmp18_ = normal_mru_window;
				if (_tmp17_ != _tmp18_) {
					MetaWindow* _tmp19_;
					MetaWindow* _tmp20_;
					_tmp19_ = window;
					_tmp20_ = any_mru_window;
					_tmp16_ = _tmp19_ != _tmp20_;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					continue;
				}
				focus_overlap = TRUE;
				_tmp21_ = window;
				g_object_get (_tmp21_, "maximized-vertically", &_tmp22_, NULL);
				_tmp23_ = _tmp22_;
				focus_maximized_overlap = _tmp23_;
				_tmp24_ = window;
				g_object_get (_tmp24_, "fullscreen", &_tmp25_, NULL);
				_tmp26_ = _tmp25_;
				focus_fullscreen_overlap = _tmp26_;
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	_tmp27_ = gala_panel_window_get_hide_mode (self);
	_tmp28_ = _tmp27_;
	switch (_tmp28_) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_MAXIMIZED_FOCUS_WINDOW:
		{
			result = focus_maximized_overlap;
			_g_object_unref0 (any_mru_window);
			_g_object_unref0 (normal_mru_window);
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_FOCUS_WINDOW:
		{
			result = focus_overlap;
			_g_object_unref0 (any_mru_window);
			_g_object_unref0 (normal_mru_window);
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_WINDOW:
		{
			result = overlap;
			_g_object_unref0 (any_mru_window);
			_g_object_unref0 (normal_mru_window);
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ALWAYS:
		{
			result = TRUE;
			_g_object_unref0 (any_mru_window);
			_g_object_unref0 (normal_mru_window);
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER:
		{
			result = focus_fullscreen_overlap;
			_g_object_unref0 (any_mru_window);
			_g_object_unref0 (normal_mru_window);
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	_g_object_unref0 (any_mru_window);
	_g_object_unref0 (normal_mru_window);
	return result;
}

static void
gala_panel_window_make_exclusive (GalaPanelWindow* self)
{
	g_return_if_fail (self != NULL);
	gala_panel_window_update_strut (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static MetaStrut*
_meta_strut_dup (MetaStrut* self)
{
	MetaStrut* dup;
	dup = g_new0 (MetaStrut, 1);
	memcpy (dup, self, sizeof (MetaStrut));
	return dup;
}

static gpointer
__meta_strut_dup0 (gpointer self)
{
	return self ? _meta_strut_dup (self) : NULL;
}

static void
gala_panel_window_update_strut (GalaPanelWindow* self)
{
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp0_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp1_;
	MtkRectangle rect = {0};
	MtkRectangle _tmp2_ = {0};
	MetaStrut strut = {0};
	MtkRectangle _tmp3_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp4_;
	MetaStrut _tmp5_ = {0};
	GHashTable* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	MetaWindow* _tmp9_;
	MetaStrut _tmp10_;
	MetaStrut* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_panel_window_get_hide_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER) {
		return;
	}
	gala_panel_window_get_custom_window_rect (self, &_tmp2_);
	rect = _tmp2_;
	_tmp3_ = rect;
	_tmp4_ = self->priv->_anchor;
	_tmp5_.rect = _tmp3_;
	_tmp5_.side = gala_panel_window_side_from_anchor (self, _tmp4_);
	strut = _tmp5_;
	_tmp6_ = gala_panel_window_window_struts;
	_tmp7_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_tmp10_ = strut;
	_tmp11_ = __meta_strut_dup0 (&_tmp10_);
	g_hash_table_insert (_tmp6_, _tmp9_, _tmp11_);
	gala_panel_window_update_struts (self);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
gala_panel_window_update_struts (GalaPanelWindow* self)
{
	GSList* list = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GalaWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	list = NULL;
	_tmp0_ = gala_panel_window_window_struts;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* window_strut_collection = NULL;
		GList* window_strut_it = NULL;
		window_strut_collection = _tmp1_;
		for (window_strut_it = window_strut_collection; window_strut_it != NULL; window_strut_it = window_strut_it->next) {
			MetaStrut* window_strut = NULL;
			window_strut = (MetaStrut*) window_strut_it->data;
			{
				MetaStrut* _tmp2_;
				MetaStrut* _tmp3_;
				_tmp2_ = window_strut;
				_tmp3_ = __meta_strut_dup0 (_tmp2_);
				list = g_slist_append (list, _tmp3_);
			}
		}
		(window_strut_collection == NULL) ? NULL : (window_strut_collection = (g_list_free (window_strut_collection), NULL));
	}
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
	_tmp7_ = meta_workspace_manager_get_workspaces (_tmp6_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp7_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp8_;
			MetaWorkspace* workspace = NULL;
			_tmp8_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp8_;
			{
				MetaWorkspace* _tmp9_;
				GSList* _tmp10_;
				_tmp9_ = workspace;
				_tmp10_ = list;
				meta_workspace_set_builtin_struts (_tmp9_, _tmp10_);
				_g_object_unref0 (workspace);
			}
		}
	}
	(list == NULL) ? NULL : (list = (_g_slist_free__g_free0_ (list), NULL));
}

static void
gala_panel_window_unmake_exclusive (GalaPanelWindow* self)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_panel_window_window_struts;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp2_ = _tmp1_;
	if (g_hash_table_contains (_tmp0_, _tmp2_)) {
		GHashTable* _tmp3_;
		MetaWindow* _tmp4_;
		MetaWindow* _tmp5_;
		_tmp3_ = gala_panel_window_window_struts;
		_tmp4_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
		_tmp5_ = _tmp4_;
		g_hash_table_remove (_tmp3_, _tmp5_);
		gala_panel_window_update_struts (self);
	}
}

static MetaSide
gala_panel_window_side_from_anchor (GalaPanelWindow* self,
                                    enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	MetaSide result;
	g_return_val_if_fail (self != NULL, 0);
	switch (anchor) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		{
			result = META_SIDE_BOTTOM;
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT:
		{
			result = META_SIDE_LEFT;
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT:
		{
			result = META_SIDE_RIGHT;
			return result;
		}
		default:
		{
			result = META_SIDE_TOP;
			return result;
		}
	}
}

static const char*
_pantheon_desktop_anchor_to_string (enum io_elementary_pantheon_panel_v1_anchor value)
{
	switch (value) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT";
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT:
		return "IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT";
	}
	return NULL;
}

static void
gala_panel_window_real_get_window_position (GalaPositionedWindow* base,
                                            MtkRectangle* window_rect,
                                            gint* x,
                                            gint* y)
{
	GalaPanelWindow * self;
	gint _vala_x = 0;
	gint _vala_y = 0;
	MtkRectangle monitor_rect = {0};
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaDisplay* _tmp6_;
	MetaDisplay* _tmp7_;
	MtkRectangle _tmp8_ = {0};
	enum io_elementary_pantheon_panel_v1_anchor _tmp9_;
	self = (GalaPanelWindow*) base;
	g_return_if_fail (window_rect != NULL);
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = meta_window_get_display (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = meta_window_get_display (_tmp5_);
	_tmp7_ = _tmp6_;
	meta_display_get_monitor_geometry (_tmp3_, meta_display_get_primary_monitor (_tmp7_), &_tmp8_);
	monitor_rect = _tmp8_;
	_tmp9_ = self->priv->_anchor;
	switch (_tmp9_) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		{
			MtkRectangle _tmp10_;
			MtkRectangle _tmp11_;
			MtkRectangle _tmp12_;
			MtkRectangle _tmp13_;
			_tmp10_ = monitor_rect;
			_tmp11_ = monitor_rect;
			_tmp12_ = *window_rect;
			_vala_x = _tmp10_.x + ((_tmp11_.width - _tmp12_.width) / 2);
			_tmp13_ = monitor_rect;
			_vala_y = _tmp13_.y;
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		{
			MtkRectangle _tmp14_;
			MtkRectangle _tmp15_;
			MtkRectangle _tmp16_;
			MtkRectangle _tmp17_;
			MtkRectangle _tmp18_;
			MtkRectangle _tmp19_;
			_tmp14_ = monitor_rect;
			_tmp15_ = monitor_rect;
			_tmp16_ = *window_rect;
			_vala_x = _tmp14_.x + ((_tmp15_.width - _tmp16_.width) / 2);
			_tmp17_ = monitor_rect;
			_tmp18_ = monitor_rect;
			_tmp19_ = *window_rect;
			_vala_y = (_tmp17_.y + _tmp18_.height) - _tmp19_.height;
			break;
		}
		default:
		{
			enum io_elementary_pantheon_panel_v1_anchor _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = self->priv->_anchor;
			_tmp21_ = _pantheon_desktop_anchor_to_string (_tmp20_);
			g_warning ("PanelWindow.vala:281: Unsupported anchor %s for PanelWindow", _tmp21_);
			_vala_x = 0;
			_vala_y = 0;
			break;
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

static void
gala_panel_window_update_target (GalaPanelWindow* self)
{
	gint _tmp0_ = 0;
	enum io_elementary_pantheon_panel_v1_anchor _tmp1_;
	gint to_value = 0;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	GalaPropertyTarget* _tmp8_;
	GalaPropertyTarget* _tmp9_;
	GalaWorkspaceHideTracker* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_anchor;
	if (_tmp1_ == IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP) {
		MtkRectangle _tmp2_ = {0};
		gala_panel_window_get_custom_window_rect (self, &_tmp2_);
		_tmp0_ = -_tmp2_.height;
	} else {
		MtkRectangle _tmp3_ = {0};
		gala_panel_window_get_custom_window_rect (self, &_tmp3_);
		_tmp0_ = _tmp3_.height;
	}
	to_value = _tmp0_;
	_tmp4_ = gala_root_target_get_actor ((GalaRootTarget*) self);
	_tmp5_ = _tmp4_;
	g_value_init (&_tmp6_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp6_, 0.f);
	g_value_init (&_tmp7_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp7_, (gfloat) to_value);
	_tmp8_ = gala_property_target_new (GALA_GESTURE_ACTION_CUSTOM, (GObject*) _tmp5_, "translation-y", G_TYPE_FLOAT, &_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_;
	gala_shell_window_set_hide_target ((GalaShellWindow*) self, (GalaGestureTarget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
	_tmp10_ = self->priv->workspace_hide_tracker;
	gala_workspace_hide_tracker_recalculate_all_workspaces (_tmp10_);
}

static void
gala_panel_window_update_clip (GalaPanelWindow* self)
{
	MtkRectangle monitor_geom = {0};
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MtkRectangle _tmp6_ = {0};
	MetaWindowActor* window_actor = NULL;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	GObject* _tmp9_;
	MetaWindowActor* _tmp10_;
	gfloat y = 0.0F;
	MetaWindowActor* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	MetaWindowActor* _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	MetaWindowActor* _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	MtkRectangle _tmp20_;
	MtkRectangle _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = meta_window_get_display (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp5_ = _tmp4_;
	meta_display_get_monitor_geometry (_tmp3_, meta_window_get_monitor (_tmp5_), &_tmp6_);
	monitor_geom = _tmp6_;
	_tmp7_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = meta_window_get_compositor_private (_tmp8_);
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, meta_window_actor_get_type (), MetaWindowActor));
	window_actor = _tmp10_;
	_tmp11_ = window_actor;
	_tmp12_ = clutter_actor_get_y ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = window_actor;
	g_object_get ((ClutterActor*) _tmp14_, "translation-y", &_tmp15_, NULL);
	_tmp16_ = _tmp15_;
	y = _tmp13_ + _tmp16_;
	_tmp17_ = window_actor;
	_tmp18_ = clutter_actor_get_height ((ClutterActor*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = monitor_geom;
	_tmp21_ = monitor_geom;
	if ((y + _tmp19_) > ((gfloat) (_tmp20_.y + _tmp21_.height))) {
		MetaWindowActor* _tmp22_;
		MetaWindowActor* _tmp23_;
		gfloat _tmp24_;
		gfloat _tmp25_;
		MtkRectangle _tmp26_;
		MtkRectangle _tmp27_;
		_tmp22_ = window_actor;
		_tmp23_ = window_actor;
		_tmp24_ = clutter_actor_get_width ((ClutterActor*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = monitor_geom;
		_tmp27_ = monitor_geom;
		clutter_actor_set_clip ((ClutterActor*) _tmp22_, (gfloat) 0, (gfloat) 0, _tmp25_, (_tmp26_.y + _tmp27_.height) - y);
	} else {
		MtkRectangle _tmp28_;
		_tmp28_ = monitor_geom;
		if (y < ((gfloat) _tmp28_.y)) {
			MetaWindowActor* _tmp29_;
			MtkRectangle _tmp30_;
			MetaWindowActor* _tmp31_;
			gfloat _tmp32_;
			gfloat _tmp33_;
			MetaWindowActor* _tmp34_;
			gfloat _tmp35_;
			gfloat _tmp36_;
			_tmp29_ = window_actor;
			_tmp30_ = monitor_geom;
			_tmp31_ = window_actor;
			_tmp32_ = clutter_actor_get_width ((ClutterActor*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = window_actor;
			_tmp35_ = clutter_actor_get_height ((ClutterActor*) _tmp34_);
			_tmp36_ = _tmp35_;
			clutter_actor_set_clip ((ClutterActor*) _tmp29_, (gfloat) 0, _tmp30_.y - y, _tmp33_, _tmp36_);
		} else {
			MetaWindowActor* _tmp37_;
			_tmp37_ = window_actor;
			clutter_actor_remove_clip ((ClutterActor*) _tmp37_);
		}
	}
	_g_object_unref0 (window_actor);
}

static ClutterActor*
gala_panel_window_real_get_actor (GalaRootTarget* base)
{
	ClutterActor* result;
	GalaPanelWindow* self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	GObject* _tmp2_;
	self = (GalaPanelWindow*) base;
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = meta_window_get_compositor_private (_tmp1_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, clutter_actor_get_type (), ClutterActor);
	return result;
}

GalaWindowManager*
gala_panel_window_get_wm (GalaPanelWindow* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_panel_window_set_wm (GalaPanelWindow* self,
                          GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_panel_window_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_panel_window_properties[GALA_PANEL_WINDOW_WM_PROPERTY]);
	}
}

enum io_elementary_pantheon_panel_v1_anchor
gala_panel_window_get_anchor (GalaPanelWindow* self)
{
	enum io_elementary_pantheon_panel_v1_anchor result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_anchor;
	return result;
}

void
gala_panel_window_set_anchor (GalaPanelWindow* self,
                              enum io_elementary_pantheon_panel_v1_anchor value)
{
	enum io_elementary_pantheon_panel_v1_anchor old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_panel_window_get_anchor (self);
	if (old_value != value) {
		self->priv->_anchor = value;
		g_object_notify_by_pspec ((GObject *) self, gala_panel_window_properties[GALA_PANEL_WINDOW_ANCHOR_PROPERTY]);
	}
}

enum io_elementary_pantheon_panel_v1_hide_mode
gala_panel_window_get_hide_mode (GalaPanelWindow* self)
{
	enum io_elementary_pantheon_panel_v1_hide_mode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_hide_mode;
	return result;
}

void
gala_panel_window_set_hide_mode (GalaPanelWindow* self,
                                 enum io_elementary_pantheon_panel_v1_hide_mode value)
{
	g_return_if_fail (self != NULL);
	self->priv->_hide_mode = value;
	if (value == IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER) {
		gala_panel_window_make_exclusive (self);
	} else {
		gala_panel_window_unmake_exclusive (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_panel_window_properties[GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY]);
}

gboolean
gala_panel_window_get_visible_in_multitasking_view (GalaPanelWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_visible_in_multitasking_view;
	return result;
}

static void
gala_panel_window_set_visible_in_multitasking_view (GalaPanelWindow* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_panel_window_get_visible_in_multitasking_view (self);
	if (old_value != value) {
		self->priv->_visible_in_multitasking_view = value;
		g_object_notify_by_pspec ((GObject *) self, gala_panel_window_properties[GALA_PANEL_WINDOW_VISIBLE_IN_MULTITASKING_VIEW_PROPERTY]);
	}
}

static void
_gala_panel_window___lambda19_ (GalaPanelWindow* self)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	_tmp0_ = gala_panel_window_window_struts;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp2_ = _tmp1_;
	if (g_hash_table_remove (_tmp0_, _tmp2_)) {
		gala_panel_window_update_struts (self);
	}
}

static void
__gala_panel_window___lambda19__meta_window_unmanaging (MetaWindow* _sender,
                                                        gpointer self)
{
	_gala_panel_window___lambda19_ ((GalaPanelWindow*) self);
}

static void
_gala_positioned_window_position_window_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	gala_positioned_window_position_window ((GalaPositionedWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                        gint object,
                                                                        gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                          gint object,
                                                                          gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_window_size_changed (MetaWindow* _sender,
                                                          gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_window_position_changed (MetaWindow* _sender,
                                                              gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_hide_gala_hide_tracker_hide (GalaHideTracker* _sender,
                                                gpointer self)
{
	gala_panel_window_hide ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_show_gala_hide_tracker_show (GalaHideTracker* _sender,
                                                gpointer self)
{
	gala_panel_window_show ((GalaPanelWindow*) self);
}

static gboolean
_gala_panel_window_update_overlap_gala_workspace_hide_tracker_compute_should_hide_on_workspace (MetaWorkspace* workspace,
                                                                                                gpointer self)
{
	gboolean result;
	result = gala_panel_window_update_overlap ((GalaPanelWindow*) self, workspace);
	return result;
}

static void
_gala_panel_window___lambda20_ (GalaPanelWindow* self,
                                gdouble value)
{
	GalaGestureController* _tmp0_;
	_tmp0_ = self->priv->workspace_gesture_controller;
	gala_gesture_controller_set_progress (_tmp0_, value);
}

static void
__gala_panel_window___lambda20__gala_workspace_hide_tracker_switching_workspace_progress_updated (GalaWorkspaceHideTracker* _sender,
                                                                                                  gdouble new_progress,
                                                                                                  gpointer self)
{
	_gala_panel_window___lambda20_ ((GalaPanelWindow*) self, new_progress);
}

static void
_gala_gesture_controller_goto_gala_workspace_hide_tracker_window_state_changed_progress_updated (GalaWorkspaceHideTracker* _sender,
                                                                                                 gdouble new_progress,
                                                                                                 gpointer self)
{
	gala_gesture_controller_goto ((GalaGestureController*) self, new_progress);
}

static void
_gala_panel_window_update_target_meta_window_size_changed (MetaWindow* _sender,
                                                           gpointer self)
{
	gala_panel_window_update_target ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_target_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	gala_panel_window_update_target ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_clip_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	gala_panel_window_update_clip ((GalaPanelWindow*) self);
}

static GObject *
gala_panel_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPanelWindow * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	MetaWorkspaceManager* _tmp7_;
	MetaWorkspaceManager* _tmp8_;
	MetaWindow* _tmp9_;
	MetaWindow* _tmp10_;
	MetaWindow* _tmp11_;
	MetaWindow* _tmp12_;
	GalaWindowManager* _tmp13_;
	GalaGestureController* _tmp14_ = NULL;
	GalaWindowManager* _tmp15_;
	MetaDisplay* _tmp16_;
	GalaHideTracker* _tmp17_;
	GalaHideTracker* _tmp18_;
	GalaHideTracker* _tmp19_;
	GalaWindowManager* _tmp20_;
	GalaGestureController* _tmp21_ = NULL;
	MetaWindow* _tmp22_;
	MetaWindow* _tmp23_;
	MetaDisplay* _tmp24_;
	MetaDisplay* _tmp25_;
	GalaWorkspaceHideTracker* _tmp26_;
	GalaWorkspaceHideTracker* _tmp27_;
	GalaWorkspaceHideTracker* _tmp28_;
	GalaGestureController* _tmp29_;
	MetaWindow* _tmp30_;
	MetaWindow* _tmp31_;
	GalaGestureController* _tmp32_;
	GalaGestureController* _tmp33_;
	MetaWindowActor* window_actor = NULL;
	MetaWindow* _tmp34_;
	MetaWindow* _tmp35_;
	GObject* _tmp36_;
	MetaWindowActor* _tmp37_;
	MetaWindowActor* _tmp38_;
	MetaWindowActor* _tmp39_;
	MetaWindowActor* _tmp40_;
	parent_class = G_OBJECT_CLASS (gala_panel_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "unmanaging", (GCallback) __gala_panel_window___lambda19__meta_window_unmanaging, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::anchor", (GCallback) _gala_positioned_window_position_window_g_object_notify, (GalaPositionedWindow*) self, 0);
	_tmp2_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = meta_window_get_display (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
	workspace_manager = _tmp6_;
	_tmp7_ = workspace_manager;
	g_signal_connect_object (_tmp7_, "workspace-added", (GCallback) _gala_panel_window_update_strut_meta_workspace_manager_workspace_added, self, 0);
	_tmp8_ = workspace_manager;
	g_signal_connect_object (_tmp8_, "workspace-removed", (GCallback) _gala_panel_window_update_strut_meta_workspace_manager_workspace_removed, self, 0);
	_tmp9_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "size-changed", (GCallback) _gala_panel_window_update_strut_meta_window_size_changed, self, 0);
	_tmp11_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "position-changed", (GCallback) _gala_panel_window_update_strut_meta_window_position_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::width", (GCallback) _gala_panel_window_update_strut_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::height", (GCallback) _gala_panel_window_update_strut_g_object_notify, self, 0);
	_tmp13_ = self->priv->_wm;
	_tmp14_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_CUSTOM, _tmp13_, GALA_GESTURE_CONTROLLER_GROUP_NONE);
	gala_gesture_controller_set_progress (_tmp14_, 1.0);
	_g_object_unref0 (self->priv->user_gesture_controller);
	self->priv->user_gesture_controller = _tmp14_;
	_tmp15_ = self->priv->_wm;
	_tmp16_ = meta_plugin_get_display ((MetaPlugin*) _tmp15_);
	_tmp17_ = gala_hide_tracker_new (_tmp16_, self);
	_g_object_unref0 (self->priv->hide_tracker);
	self->priv->hide_tracker = _tmp17_;
	_tmp18_ = self->priv->hide_tracker;
	g_signal_connect_object (_tmp18_, "hide", (GCallback) _gala_panel_window_hide_gala_hide_tracker_hide, self, 0);
	_tmp19_ = self->priv->hide_tracker;
	g_signal_connect_object (_tmp19_, "show", (GCallback) _gala_panel_window_show_gala_hide_tracker_show, self, 0);
	_tmp20_ = self->priv->_wm;
	_tmp21_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_CUSTOM, _tmp20_, GALA_GESTURE_CONTROLLER_GROUP_NONE);
	gala_gesture_controller_set_progress (_tmp21_, 1.0);
	_g_object_unref0 (self->priv->workspace_gesture_controller);
	self->priv->workspace_gesture_controller = _tmp21_;
	_tmp22_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = meta_window_get_display (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = gala_workspace_hide_tracker_new (_tmp25_, _gala_panel_window_update_overlap_gala_workspace_hide_tracker_compute_should_hide_on_workspace, self);
	_g_object_unref0 (self->priv->workspace_hide_tracker);
	self->priv->workspace_hide_tracker = _tmp26_;
	_tmp27_ = self->priv->workspace_hide_tracker;
	g_signal_connect_object (_tmp27_, "switching-workspace-progress-updated", (GCallback) __gala_panel_window___lambda20__gala_workspace_hide_tracker_switching_workspace_progress_updated, self, 0);
	_tmp28_ = self->priv->workspace_hide_tracker;
	_tmp29_ = self->priv->workspace_gesture_controller;
	g_signal_connect_object (_tmp28_, "window-state-changed-progress-updated", (GCallback) _gala_gesture_controller_goto_gala_workspace_hide_tracker_window_state_changed_progress_updated, _tmp29_, 0);
	_tmp30_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp31_ = _tmp30_;
	g_signal_connect_object (_tmp31_, "size-changed", (GCallback) _gala_panel_window_update_target_meta_window_size_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::anchor", (GCallback) _gala_panel_window_update_target_g_object_notify, self, 0);
	gala_panel_window_update_target (self);
	_tmp32_ = self->priv->user_gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp32_);
	_tmp33_ = self->priv->workspace_gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp33_);
	_tmp34_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = meta_window_get_compositor_private (_tmp35_);
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, meta_window_actor_get_type (), MetaWindowActor));
	window_actor = _tmp37_;
	_tmp38_ = window_actor;
	g_signal_connect_object ((GObject*) _tmp38_, "notify::width", (GCallback) _gala_panel_window_update_clip_g_object_notify, self, 0);
	_tmp39_ = window_actor;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::height", (GCallback) _gala_panel_window_update_clip_g_object_notify, self, 0);
	_tmp40_ = window_actor;
	g_signal_connect_object ((GObject*) _tmp40_, "notify::translation-y", (GCallback) _gala_panel_window_update_clip_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::anchor", (GCallback) _gala_panel_window_update_clip_g_object_notify, self, 0);
	_g_object_unref0 (window_actor);
	return obj;
}

static void
gala_panel_window_class_init (GalaPanelWindowClass * klass,
                              gpointer klass_data)
{
	GHashTable* _tmp0_;
	gala_panel_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPanelWindow_private_offset);
	((GalaShellWindowClass *) klass)->get_hidden_progress = (gdouble (*) (GalaShellWindow*)) gala_panel_window_real_get_hidden_progress;
	((GalaShellWindowClass *) klass)->propagate = (void (*) (GalaShellWindow*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_panel_window_real_propagate;
	((GalaPositionedWindowClass *) klass)->get_window_position = (void (*) (GalaPositionedWindow*, MtkRectangle*, gint*, gint*)) gala_panel_window_real_get_window_position;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_panel_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_panel_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_panel_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_panel_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_ACTOR_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_WM_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_ANCHOR_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_ANCHOR_PROPERTY] = g_param_spec_int ("anchor", "anchor", "anchor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY] = g_param_spec_int ("hide-mode", "hide-mode", "hide-mode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_VISIBLE_IN_MULTITASKING_VIEW_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_VISIBLE_IN_MULTITASKING_VIEW_PROPERTY] = g_param_spec_boolean ("visible-in-multitasking-view", "visible-in-multitasking-view", "visible-in-multitasking-view", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_free0_);
	gala_panel_window_window_struts = _tmp0_;
}

static void
gala_panel_window_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                   gpointer iface_data)
{
	gala_panel_window_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_actor = gala_panel_window_real_get_actor;
}

static void
gala_panel_window_instance_init (GalaPanelWindow * self,
                                 gpointer klass)
{
	self->priv = gala_panel_window_get_instance_private (self);
	self->priv->_visible_in_multitasking_view = FALSE;
	self->priv->width = -1;
	self->priv->height = -1;
	self->priv->starting = TRUE;
}

static void
gala_panel_window_finalize (GObject * obj)
{
	GalaPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->user_gesture_controller);
	_g_object_unref0 (self->priv->hide_tracker);
	_g_object_unref0 (self->priv->workspace_gesture_controller);
	_g_object_unref0 (self->priv->workspace_hide_tracker);
	G_OBJECT_CLASS (gala_panel_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_panel_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPanelWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_panel_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPanelWindow), 0, (GInstanceInitFunc) gala_panel_window_instance_init, NULL };
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_panel_window_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_panel_window_type_id;
	gala_panel_window_type_id = g_type_register_static (GALA_TYPE_SHELL_WINDOW, "GalaPanelWindow", &g_define_type_info, 0);
	g_type_add_interface_static (gala_panel_window_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	GalaPanelWindow_private_offset = g_type_add_instance_private (gala_panel_window_type_id, sizeof (GalaPanelWindowPrivate));
	return gala_panel_window_type_id;
}

GType
gala_panel_window_get_type (void)
{
	static gsize gala_panel_window_type_id__once = 0;
	if (g_once_init_enter (&gala_panel_window_type_id__once)) {
		GType gala_panel_window_type_id;
		gala_panel_window_type_id = gala_panel_window_get_type_once ();
		g_once_init_leave (&gala_panel_window_type_id__once, gala_panel_window_type_id);
	}
	return gala_panel_window_type_id__once;
}

static void
_vala_gala_panel_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	switch (property_id) {
		case GALA_PANEL_WINDOW_ACTOR_PROPERTY:
		g_value_set_object (value, gala_root_target_get_actor ((GalaRootTarget*) self));
		break;
		case GALA_PANEL_WINDOW_WM_PROPERTY:
		g_value_set_object (value, gala_panel_window_get_wm (self));
		break;
		case GALA_PANEL_WINDOW_ANCHOR_PROPERTY:
		g_value_set_int (value, gala_panel_window_get_anchor (self));
		break;
		case GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY:
		g_value_set_int (value, gala_panel_window_get_hide_mode (self));
		break;
		case GALA_PANEL_WINDOW_VISIBLE_IN_MULTITASKING_VIEW_PROPERTY:
		g_value_set_boolean (value, gala_panel_window_get_visible_in_multitasking_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_panel_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	switch (property_id) {
		case GALA_PANEL_WINDOW_WM_PROPERTY:
		gala_panel_window_set_wm (self, g_value_get_object (value));
		break;
		case GALA_PANEL_WINDOW_ANCHOR_PROPERTY:
		gala_panel_window_set_anchor (self, g_value_get_int (value));
		break;
		case GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY:
		gala_panel_window_set_hide_mode (self, g_value_get_int (value));
		break;
		case GALA_PANEL_WINDOW_VISIBLE_IN_MULTITASKING_VIEW_PROPERTY:
		gala_panel_window_set_visible_in_multitasking_view (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

