/* DBus.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DBus.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include "gala.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <handy.h>
#include <gdk/gdk.h>

#define GALA_DAEMON_DBUS_DBUS_NAME "org.pantheon.gala"
#define GALA_DAEMON_DBUS_DBUS_OBJECT_PATH "/org/pantheon/gala"
#define GALA_DAEMON_DBUS_DAEMON_DBUS_NAME "org.pantheon.gala.daemon"
#define GALA_DAEMON_DBUS_DAEMON_DBUS_OBJECT_PATH "/org/pantheon/gala/daemon"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WMD_BUS (gala_wmd_bus_get_type ())
#define GALA_WMD_BUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WMD_BUS, GalaWMDBus))
#define GALA_IS_WMD_BUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WMD_BUS))
#define GALA_WMD_BUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_WMD_BUS, GalaWMDBusIface))

typedef struct _GalaWMDBus GalaWMDBus;
typedef struct _GalaWMDBusIface GalaWMDBusIface;

#define GALA_TYPE_WMD_BUS_PROXY (gala_wmd_bus_proxy_get_type ())
typedef GDBusProxy GalaWMDBusProxy;
typedef GDBusProxyClass GalaWMDBusProxyClass;

#define GALA_DAEMON_TYPE_MONITOR_LABEL_INFO (gala_daemon_monitor_label_info_get_type ())
typedef struct _GalaDaemonMonitorLabelInfo GalaDaemonMonitorLabelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_DAEMON_TYPE_DBUS (gala_daemon_dbus_get_type ())
#define GALA_DAEMON_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_DBUS, GalaDaemonDBus))
#define GALA_DAEMON_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_DBUS, GalaDaemonDBusClass))
#define GALA_DAEMON_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_DBUS))
#define GALA_DAEMON_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_DBUS))
#define GALA_DAEMON_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_DBUS, GalaDaemonDBusClass))

typedef struct _GalaDaemonDBus GalaDaemonDBus;
typedef struct _GalaDaemonDBusClass GalaDaemonDBusClass;
typedef struct _GalaDaemonDBusPrivate GalaDaemonDBusPrivate;

#define GALA_DAEMON_TYPE_WINDOW_MENU (gala_daemon_window_menu_get_type ())
#define GALA_DAEMON_WINDOW_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_WINDOW_MENU, GalaDaemonWindowMenu))
#define GALA_DAEMON_WINDOW_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_WINDOW_MENU, GalaDaemonWindowMenuClass))
#define GALA_DAEMON_IS_WINDOW_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_WINDOW_MENU))
#define GALA_DAEMON_IS_WINDOW_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_WINDOW_MENU))
#define GALA_DAEMON_WINDOW_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_WINDOW_MENU, GalaDaemonWindowMenuClass))

typedef struct _GalaDaemonWindowMenu GalaDaemonWindowMenu;
typedef struct _GalaDaemonWindowMenuClass GalaDaemonWindowMenuClass;

#define GALA_DAEMON_TYPE_BACKGROUND_MENU (gala_daemon_background_menu_get_type ())
#define GALA_DAEMON_BACKGROUND_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_BACKGROUND_MENU, GalaDaemonBackgroundMenu))
#define GALA_DAEMON_BACKGROUND_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_BACKGROUND_MENU, GalaDaemonBackgroundMenuClass))
#define GALA_DAEMON_IS_BACKGROUND_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_BACKGROUND_MENU))
#define GALA_DAEMON_IS_BACKGROUND_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_BACKGROUND_MENU))
#define GALA_DAEMON_BACKGROUND_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_BACKGROUND_MENU, GalaDaemonBackgroundMenuClass))

typedef struct _GalaDaemonBackgroundMenu GalaDaemonBackgroundMenu;
typedef struct _GalaDaemonBackgroundMenuClass GalaDaemonBackgroundMenuClass;

#define GALA_DAEMON_TYPE_MONITOR_LABEL (gala_daemon_monitor_label_get_type ())
#define GALA_DAEMON_MONITOR_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_MONITOR_LABEL, GalaDaemonMonitorLabel))
#define GALA_DAEMON_MONITOR_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_MONITOR_LABEL, GalaDaemonMonitorLabelClass))
#define GALA_DAEMON_IS_MONITOR_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_MONITOR_LABEL))
#define GALA_DAEMON_IS_MONITOR_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_MONITOR_LABEL))
#define GALA_DAEMON_MONITOR_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_MONITOR_LABEL, GalaDaemonMonitorLabelClass))

typedef struct _GalaDaemonMonitorLabel GalaDaemonMonitorLabel;
typedef struct _GalaDaemonMonitorLabelClass GalaDaemonMonitorLabelClass;
enum  {
	GALA_DAEMON_DBUS_0_PROPERTY,
	GALA_DAEMON_DBUS_NUM_PROPERTIES
};
static GParamSpec* gala_daemon_dbus_properties[GALA_DAEMON_DBUS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GALA_DAEMON_TYPE_WINDOW (gala_daemon_window_get_type ())
#define GALA_DAEMON_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_WINDOW, GalaDaemonWindow))
#define GALA_DAEMON_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_WINDOW, GalaDaemonWindowClass))
#define GALA_DAEMON_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_WINDOW))
#define GALA_DAEMON_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_WINDOW))
#define GALA_DAEMON_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_WINDOW, GalaDaemonWindowClass))

typedef struct _GalaDaemonWindow GalaDaemonWindow;
typedef struct _GalaDaemonWindowClass GalaDaemonWindowClass;
typedef struct _Block2Data Block2Data;

struct _GalaWMDBusIface {
	GTypeInterface parent_iface;
	void (*perform_action) (GalaWMDBus* self, GalaActionType type, GError** error);
};

struct _GalaDaemonMonitorLabelInfo {
	gint monitor;
	gchar* label;
	gchar* background_color;
	gchar* text_color;
	gint x;
	gint y;
};

struct _GalaDaemonDBus {
	GObject parent_instance;
	GalaDaemonDBusPrivate * priv;
};

struct _GalaDaemonDBusClass {
	GObjectClass parent_class;
};

struct _GalaDaemonDBusPrivate {
	GalaWMDBus* wm_proxy;
	GalaDaemonWindowMenu* window_menu;
	GalaDaemonBackgroundMenu* background_menu;
	GList* monitor_labels;
};

struct _Block2Data {
	int _ref_count_;
	GalaDaemonDBus* self;
	gboolean first;
};

static gint GalaDaemonDBus_private_offset;
static gpointer gala_daemon_dbus_parent_class = NULL;

VALA_EXTERN GType gala_wmd_bus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint gala_wmd_bus_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType gala_wmd_bus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWMDBus, g_object_unref)
VALA_EXTERN void gala_wmd_bus_perform_action (GalaWMDBus* self,
                                  GalaActionType type,
                                  GError** error);
static GType gala_wmd_bus_get_type_once (void);
static void gala_wmd_bus_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void gala_wmd_bus_proxy_perform_action (GalaWMDBus* self,
                                        GalaActionType type,
                                        GError** error);
static void gala_wmd_bus_proxy_gala_wmd_bus_interface_init (GalaWMDBusIface* iface);
static void _dbus_gala_wmd_bus_perform_action (GalaWMDBus* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void gala_wmd_bus_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* gala_wmd_bus_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean gala_wmd_bus_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _gala_wmd_bus_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_daemon_monitor_label_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaDaemonMonitorLabelInfo* gala_daemon_monitor_label_info_dup (const GalaDaemonMonitorLabelInfo* self);
VALA_EXTERN void gala_daemon_monitor_label_info_free (GalaDaemonMonitorLabelInfo* self);
VALA_EXTERN void gala_daemon_monitor_label_info_copy (const GalaDaemonMonitorLabelInfo* self,
                                          GalaDaemonMonitorLabelInfo* dest);
VALA_EXTERN void gala_daemon_monitor_label_info_destroy (GalaDaemonMonitorLabelInfo* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaDaemonMonitorLabelInfo, gala_daemon_monitor_label_info_destroy)
VALA_EXTERN GType gala_daemon_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonDBus, g_object_unref)
VALA_EXTERN guint gala_daemon_dbus_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType gala_daemon_window_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonWindowMenu, g_object_unref)
VALA_EXTERN GType gala_daemon_background_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonBackgroundMenu, g_object_unref)
VALA_EXTERN GType gala_daemon_monitor_label_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonMonitorLabel, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void gala_daemon_dbus_on_gala_get (GalaDaemonDBus* self,
                                   GObject* obj,
                                   GAsyncResult* res);
static void gala_daemon_dbus_lost_gala (GalaDaemonDBus* self);
static void gala_daemon_dbus_gala_appeared (GalaDaemonDBus* self);
static void _gala_daemon_dbus_on_gala_get_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self);
static void gala_daemon_dbus_perform_action (GalaDaemonDBus* self,
                                      GalaActionType type);
VALA_EXTERN void gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                        GalaWindowFlags flags,
                                        gint display_width,
                                        gint display_height,
                                        gint x,
                                        gint y,
                                        GError** error);
VALA_EXTERN GalaDaemonWindowMenu* gala_daemon_window_menu_new (void);
VALA_EXTERN GalaDaemonWindowMenu* gala_daemon_window_menu_construct (GType object_type);
static void _gala_daemon_dbus_perform_action_gala_daemon_window_menu_perform_action (GalaDaemonWindowMenu* _sender,
                                                                              GalaActionType type,
                                                                              gpointer self);
VALA_EXTERN void gala_daemon_window_menu_update (GalaDaemonWindowMenu* self,
                                     GalaWindowFlags flags);
static void gala_daemon_dbus_show_menu (GalaDaemonDBus* self,
                                 GtkMenu* menu,
                                 gint display_width,
                                 gint display_height,
                                 gint x,
                                 gint y,
                                 gboolean ignore_first_release);
VALA_EXTERN void gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                         gint display_width,
                                         gint display_height,
                                         gint x,
                                         gint y,
                                         GError** error);
VALA_EXTERN GalaDaemonBackgroundMenu* gala_daemon_background_menu_new (void);
VALA_EXTERN GalaDaemonBackgroundMenu* gala_daemon_background_menu_construct (GType object_type);
VALA_EXTERN GType gala_daemon_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonWindow, g_object_unref)
VALA_EXTERN GalaDaemonWindow* gala_daemon_window_new (gint width,
                                          gint height);
VALA_EXTERN GalaDaemonWindow* gala_daemon_window_construct (GType object_type,
                                                gint width,
                                                gint height);
VALA_EXTERN GtkBox* gala_daemon_window_get_content (GalaDaemonWindow* self);
static void _gtk_window_close_gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                                  gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda16_ (Block2Data* _data2_);
static gboolean ____lambda16__gtk_widget_button_release_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
VALA_EXTERN void gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                           GalaDaemonMonitorLabelInfo* label_infos,
                                           gint label_infos_length1,
                                           GError** error);
VALA_EXTERN void gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                           GError** error);
VALA_EXTERN GalaDaemonMonitorLabel* gala_daemon_monitor_label_new (GalaDaemonMonitorLabelInfo* info);
VALA_EXTERN GalaDaemonMonitorLabel* gala_daemon_monitor_label_construct (GType object_type,
                                                             GalaDaemonMonitorLabelInfo* info);
VALA_EXTERN GalaDaemonDBus* gala_daemon_dbus_new (void);
VALA_EXTERN GalaDaemonDBus* gala_daemon_dbus_construct (GType object_type);
static GObject * gala_daemon_dbus_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  const gchar* name_owner,
                                                                  gpointer self);
static void _gala_daemon_dbus_lost_gala_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self);
static void gala_daemon_dbus_finalize (GObject * obj);
static GType gala_daemon_dbus_get_type_once (void);
static void _dbus_gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _vala_GalaDaemonMonitorLabelInfo_array_free (GalaDaemonMonitorLabelInfo * array,
                                                  gssize array_length);
static void _dbus_gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void gala_daemon_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* gala_daemon_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean gala_daemon_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _gala_daemon_dbus_unregister_object (gpointer user_data);

static const GDBusArgInfo _gala_wmd_bus_dbus_arg_info_perform_action_type = {-1, "type", "i", NULL};
static const GDBusArgInfo * const _gala_wmd_bus_dbus_arg_info_perform_action_in[] = {&_gala_wmd_bus_dbus_arg_info_perform_action_type, NULL};
static const GDBusArgInfo * const _gala_wmd_bus_dbus_arg_info_perform_action_out[] = {NULL};
static const GDBusMethodInfo _gala_wmd_bus_dbus_method_info_perform_action = {-1, "PerformAction", (GDBusArgInfo **) (&_gala_wmd_bus_dbus_arg_info_perform_action_in), (GDBusArgInfo **) (&_gala_wmd_bus_dbus_arg_info_perform_action_out), NULL};
static const GDBusMethodInfo * const _gala_wmd_bus_dbus_method_info[] = {&_gala_wmd_bus_dbus_method_info_perform_action, NULL};
static const GDBusSignalInfo * const _gala_wmd_bus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_wmd_bus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_wmd_bus_dbus_interface_info = {-1, "org.pantheon.gala", (GDBusMethodInfo **) (&_gala_wmd_bus_dbus_method_info), (GDBusSignalInfo **) (&_gala_wmd_bus_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_wmd_bus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_wmd_bus_dbus_interface_vtable = {gala_wmd_bus_dbus_interface_method_call, gala_wmd_bus_dbus_interface_get_property, gala_wmd_bus_dbus_interface_set_property};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_display_width = {-1, "display_width", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_display_height = {-1, "display_height", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_window_menu_in[] = {&_gala_daemon_dbus_dbus_arg_info_show_window_menu_flags, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_display_width, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_display_height, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_x, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_y, NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_window_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_show_window_menu = {-1, "ShowWindowMenu", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_window_menu_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_window_menu_out), NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_width = {-1, "display_width", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_height = {-1, "display_height", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_in[] = {&_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_width, &_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_height, &_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_x, &_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_y, NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_show_desktop_menu = {-1, "ShowDesktopMenu", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_out), NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_monitor_labels_label_infos = {-1, "label_infos", "a(isssii)", NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_monitor_labels_in[] = {&_gala_daemon_dbus_dbus_arg_info_show_monitor_labels_label_infos, NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_monitor_labels_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_show_monitor_labels = {-1, "ShowMonitorLabels", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_monitor_labels_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_monitor_labels_out), NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_in[] = {NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_hide_monitor_labels = {-1, "HideMonitorLabels", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_out), NULL};
static const GDBusMethodInfo * const _gala_daemon_dbus_dbus_method_info[] = {&_gala_daemon_dbus_dbus_method_info_show_window_menu, &_gala_daemon_dbus_dbus_method_info_show_desktop_menu, &_gala_daemon_dbus_dbus_method_info_show_monitor_labels, &_gala_daemon_dbus_dbus_method_info_hide_monitor_labels, NULL};
static const GDBusSignalInfo * const _gala_daemon_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_daemon_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_daemon_dbus_dbus_interface_info = {-1, "org.pantheon.gala.daemon", (GDBusMethodInfo **) (&_gala_daemon_dbus_dbus_method_info), (GDBusSignalInfo **) (&_gala_daemon_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_daemon_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_daemon_dbus_dbus_interface_vtable = {gala_daemon_dbus_dbus_interface_method_call, gala_daemon_dbus_dbus_interface_get_property, gala_daemon_dbus_dbus_interface_set_property};

void
gala_wmd_bus_perform_action (GalaWMDBus* self,
                             GalaActionType type,
                             GError** error)
{
	GalaWMDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WMD_BUS_GET_INTERFACE (self);
	if (_iface_->perform_action) {
		_iface_->perform_action (self, type, error);
	}
}

static void
gala_wmd_bus_default_init (GalaWMDBusIface * iface,
                           gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
gala_wmd_bus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWMDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_wmd_bus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_wmd_bus_type_id;
	gala_wmd_bus_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaWMDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_wmd_bus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_wmd_bus_proxy_get_type);
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.pantheon.gala");
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_wmd_bus_dbus_interface_info));
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_wmd_bus_register_object);
	return gala_wmd_bus_type_id;
}

GType
gala_wmd_bus_get_type (void)
{
	static gsize gala_wmd_bus_type_id__once = 0;
	if (g_once_init_enter (&gala_wmd_bus_type_id__once)) {
		GType gala_wmd_bus_type_id;
		gala_wmd_bus_type_id = gala_wmd_bus_get_type_once ();
		g_once_init_leave (&gala_wmd_bus_type_id__once, gala_wmd_bus_type_id);
	}
	return gala_wmd_bus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaWMDBusProxy, gala_wmd_bus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_WMD_BUS, gala_wmd_bus_proxy_gala_wmd_bus_interface_init) )
static void
gala_wmd_bus_proxy_class_init (GalaWMDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_wmd_bus_proxy_g_signal;
}

static void
gala_wmd_bus_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
}

static void
gala_wmd_bus_proxy_init (GalaWMDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_wmd_bus_dbus_interface_info));
}

static void
gala_wmd_bus_proxy_perform_action (GalaWMDBus* self,
                                   GalaActionType type,
                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala", "PerformAction");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_wmd_bus_proxy_gala_wmd_bus_interface_init (GalaWMDBusIface* iface)
{
	iface->perform_action = gala_wmd_bus_proxy_perform_action;
}

static void
_dbus_gala_wmd_bus_perform_action (GalaWMDBus* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaActionType type = 0;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	gala_wmd_bus_perform_action (self, type, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_wmd_bus_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PerformAction") == 0) {
		_dbus_gala_wmd_bus_perform_action (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_wmd_bus_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_wmd_bus_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_wmd_bus_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_wmd_bus_dbus_interface_info), &_gala_wmd_bus_dbus_interface_vtable, data, _gala_wmd_bus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_wmd_bus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
gala_daemon_monitor_label_info_copy (const GalaDaemonMonitorLabelInfo* self,
                                     GalaDaemonMonitorLabelInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	(*dest).monitor = (*self).monitor;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).background_color;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).background_color);
	(*dest).background_color = _tmp3_;
	_tmp4_ = (*self).text_color;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).text_color);
	(*dest).text_color = _tmp5_;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
}

void
gala_daemon_monitor_label_info_destroy (GalaDaemonMonitorLabelInfo* self)
{
	_g_free0 ((*self).label);
	_g_free0 ((*self).background_color);
	_g_free0 ((*self).text_color);
}

GalaDaemonMonitorLabelInfo*
gala_daemon_monitor_label_info_dup (const GalaDaemonMonitorLabelInfo* self)
{
	GalaDaemonMonitorLabelInfo* dup;
	dup = g_new0 (GalaDaemonMonitorLabelInfo, 1);
	gala_daemon_monitor_label_info_copy (self, dup);
	return dup;
}

void
gala_daemon_monitor_label_info_free (GalaDaemonMonitorLabelInfo* self)
{
	gala_daemon_monitor_label_info_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gala_daemon_monitor_label_info_get_type_once (void)
{
	GType gala_daemon_monitor_label_info_type_id;
	gala_daemon_monitor_label_info_type_id = g_boxed_type_register_static ("GalaDaemonMonitorLabelInfo", (GBoxedCopyFunc) gala_daemon_monitor_label_info_dup, (GBoxedFreeFunc) gala_daemon_monitor_label_info_free);
	return gala_daemon_monitor_label_info_type_id;
}

GType
gala_daemon_monitor_label_info_get_type (void)
{
	static gsize gala_daemon_monitor_label_info_type_id__once = 0;
	if (g_once_init_enter (&gala_daemon_monitor_label_info_type_id__once)) {
		GType gala_daemon_monitor_label_info_type_id;
		gala_daemon_monitor_label_info_type_id = gala_daemon_monitor_label_info_get_type_once ();
		g_once_init_leave (&gala_daemon_monitor_label_info_type_id__once, gala_daemon_monitor_label_info_type_id);
	}
	return gala_daemon_monitor_label_info_type_id__once;
}

static inline gpointer
gala_daemon_dbus_get_instance_private (GalaDaemonDBus* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDaemonDBus_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
gala_daemon_dbus_on_gala_get (GalaDaemonDBus* self,
                              GObject* obj,
                              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GalaWMDBus* _tmp0_ = NULL;
		GalaWMDBus* _tmp1_;
		GalaWMDBus* _tmp2_;
		GalaWMDBus* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (GalaWMDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (GalaWMDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->wm_proxy);
		self->priv->wm_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("DBus.vala:43: Failed to get Gala proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
gala_daemon_dbus_lost_gala (GalaDaemonDBus* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->wm_proxy);
	self->priv->wm_proxy = NULL;
}

static void
_gala_daemon_dbus_on_gala_get_gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self)
{
	gala_daemon_dbus_on_gala_get ((GalaDaemonDBus*) self, source_object, res);
	g_object_unref (self);
}

static void
gala_daemon_dbus_gala_appeared (GalaDaemonDBus* self)
{
	GalaWMDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (GALA_TYPE_WMD_BUS_PROXY, 0, NULL, _gala_daemon_dbus_on_gala_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", GALA_DAEMON_DBUS_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GALA_DAEMON_DBUS_DBUS_OBJECT_PATH, "g-interface-name", "org.pantheon.gala", NULL);
	}
}

static void
gala_daemon_dbus_perform_action (GalaDaemonDBus* self,
                                 GalaActionType type)
{
	GalaWMDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ != NULL) {
		{
			GalaWMDBus* _tmp1_;
			_tmp1_ = self->priv->wm_proxy;
			gala_wmd_bus_perform_action (_tmp1_, type, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("DBus.vala:62: Failed to perform Gala action over DBus: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
_gala_daemon_dbus_perform_action_gala_daemon_window_menu_perform_action (GalaDaemonWindowMenu* _sender,
                                                                         GalaActionType type,
                                                                         gpointer self)
{
	gala_daemon_dbus_perform_action ((GalaDaemonDBus*) self, type);
}

void
gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                   GalaWindowFlags flags,
                                   gint display_width,
                                   gint display_height,
                                   gint x,
                                   gint y,
                                   GError** error)
{
	GalaDaemonWindowMenu* _tmp0_;
	GalaDaemonWindowMenu* _tmp3_;
	GalaDaemonWindowMenu* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_menu;
	if (_tmp0_ == NULL) {
		GalaDaemonWindowMenu* _tmp1_;
		GalaDaemonWindowMenu* _tmp2_;
		_tmp1_ = gala_daemon_window_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->window_menu);
		self->priv->window_menu = _tmp1_;
		_tmp2_ = self->priv->window_menu;
		g_signal_connect_object (_tmp2_, "perform-action", (GCallback) _gala_daemon_dbus_perform_action_gala_daemon_window_menu_perform_action, self, 0);
	}
	_tmp3_ = self->priv->window_menu;
	gala_daemon_window_menu_update (_tmp3_, flags);
	_tmp4_ = self->priv->window_menu;
	gala_daemon_dbus_show_menu (self, (GtkMenu*) _tmp4_, display_width, display_height, x, y, TRUE);
}

void
gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                    gint display_width,
                                    gint display_height,
                                    gint x,
                                    gint y,
                                    GError** error)
{
	GalaDaemonBackgroundMenu* _tmp0_;
	GalaDaemonBackgroundMenu* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background_menu;
	if (_tmp0_ == NULL) {
		GalaDaemonBackgroundMenu* _tmp1_;
		_tmp1_ = gala_daemon_background_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->background_menu);
		self->priv->background_menu = _tmp1_;
	}
	_tmp2_ = self->priv->background_menu;
	gala_daemon_dbus_show_menu (self, (GtkMenu*) _tmp2_, display_width, display_height, x, y, FALSE);
}

static void
_gtk_window_close_gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                             gpointer self)
{
	gtk_window_close ((GtkWindow*) self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GalaDaemonDBus* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
___lambda16_ (Block2Data* _data2_)
{
	GalaDaemonDBus* self;
	gboolean result;
	self = _data2_->self;
	if (_data2_->first) {
		_data2_->first = FALSE;
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda16__gtk_widget_button_release_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = ___lambda16_ (self);
	return result;
}

static void
gala_daemon_dbus_show_menu (GalaDaemonDBus* self,
                            GtkMenu* menu,
                            gint display_width,
                            gint display_height,
                            gint x,
                            gint y,
                            gboolean ignore_first_release)
{
	GalaDaemonWindow* window = NULL;
	GalaDaemonWindow* _tmp0_;
	GalaDaemonWindow* _tmp1_;
	GalaDaemonWindow* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GdkRectangle rect = {0};
	GdkRectangle _tmp5_ = {0};
	GalaDaemonWindow* _tmp6_;
	GdkWindow* _tmp7_;
	GdkRectangle _tmp8_;
	GalaDaemonWindow* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = gala_daemon_window_new (display_width, display_height);
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	_tmp1_ = window;
	gtk_window_present ((GtkWindow*) _tmp1_);
	_tmp2_ = window;
	_tmp3_ = gala_daemon_window_get_content (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_menu_attach_to_widget (menu, (GtkWidget*) _tmp4_, NULL);
	_tmp5_.x = x;
	_tmp5_.y = y;
	_tmp5_.width = 0;
	_tmp5_.height = 0;
	rect = _tmp5_;
	gtk_widget_show_all ((GtkWidget*) menu);
	_tmp6_ = window;
	_tmp7_ = gtk_widget_get_window ((GtkWidget*) _tmp6_);
	_tmp8_ = rect;
	gtk_menu_popup_at_rect (menu, _tmp7_, &_tmp8_, GDK_GRAVITY_NORTH, GDK_GRAVITY_NORTH_WEST, NULL);
	_tmp9_ = window;
	g_signal_connect_object ((GtkMenuShell*) menu, "deactivate", (GCallback) _gtk_window_close_gtk_menu_shell_deactivate, (GtkWindow*) _tmp9_, 0);
	if (ignore_first_release) {
		Block2Data* _data2_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->self = g_object_ref (self);
		_data2_->first = TRUE;
		g_signal_connect_data ((GtkWidget*) menu, "button-release-event", (GCallback) ____lambda16__gtk_widget_button_release_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_g_object_unref0 (window);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                      GalaDaemonMonitorLabelInfo* label_infos,
                                      gint label_infos_length1,
                                      GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	gala_daemon_dbus_hide_monitor_labels (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	(self->priv->monitor_labels == NULL) ? NULL : (self->priv->monitor_labels = (_g_list_free__g_object_unref0_ (self->priv->monitor_labels), NULL));
	self->priv->monitor_labels = NULL;
	{
		GalaDaemonMonitorLabelInfo* info_collection = NULL;
		gint info_collection_length1 = 0;
		gint _info_collection_size_ = 0;
		gint info_it = 0;
		info_collection = label_infos;
		info_collection_length1 = label_infos_length1;
		for (info_it = 0; info_it < info_collection_length1; info_it = info_it + 1) {
			GalaDaemonMonitorLabelInfo _tmp0_;
			GalaDaemonMonitorLabelInfo _tmp1_ = {0};
			GalaDaemonMonitorLabelInfo info = {0};
			_tmp0_ = info_collection[info_it];
			gala_daemon_monitor_label_info_copy (&_tmp0_, &_tmp1_);
			info = _tmp1_;
			{
				GalaDaemonMonitorLabel* label = NULL;
				GalaDaemonMonitorLabelInfo _tmp2_;
				GalaDaemonMonitorLabel* _tmp3_;
				GalaDaemonMonitorLabel* _tmp4_;
				GalaDaemonMonitorLabel* _tmp5_;
				GalaDaemonMonitorLabel* _tmp6_;
				_tmp2_ = info;
				_tmp3_ = gala_daemon_monitor_label_new (&_tmp2_);
				g_object_ref_sink (_tmp3_);
				label = _tmp3_;
				_tmp4_ = label;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				self->priv->monitor_labels = g_list_append (self->priv->monitor_labels, _tmp5_);
				_tmp6_ = label;
				gtk_window_present ((GtkWindow*) _tmp6_);
				_g_object_unref0 (label);
				gala_daemon_monitor_label_info_destroy (&info);
			}
		}
	}
}

void
gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                      GError** error)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor_labels;
	{
		GList* monitor_label_collection = NULL;
		GList* monitor_label_it = NULL;
		monitor_label_collection = _tmp0_;
		for (monitor_label_it = monitor_label_collection; monitor_label_it != NULL; monitor_label_it = monitor_label_it->next) {
			GalaDaemonMonitorLabel* _tmp1_;
			GalaDaemonMonitorLabel* monitor_label = NULL;
			_tmp1_ = _g_object_ref0 ((GalaDaemonMonitorLabel*) monitor_label_it->data);
			monitor_label = _tmp1_;
			{
				GalaDaemonMonitorLabel* _tmp2_;
				_tmp2_ = monitor_label;
				gtk_window_close ((GtkWindow*) _tmp2_);
				_g_object_unref0 (monitor_label);
			}
		}
	}
}

GalaDaemonDBus*
gala_daemon_dbus_construct (GType object_type)
{
	GalaDaemonDBus * self = NULL;
	self = (GalaDaemonDBus*) g_object_new (object_type, NULL);
	return self;
}

GalaDaemonDBus*
gala_daemon_dbus_new (void)
{
	return gala_daemon_dbus_construct (GALA_DAEMON_TYPE_DBUS);
}

static void
_gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             const gchar* name_owner,
                                                             gpointer self)
{
	gala_daemon_dbus_gala_appeared ((GalaDaemonDBus*) self);
}

static void
_gala_daemon_dbus_lost_gala_gbus_name_vanished_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         gpointer self)
{
	gala_daemon_dbus_lost_gala ((GalaDaemonDBus*) self);
}

static GObject *
gala_daemon_dbus_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaDaemonDBus * self;
	parent_class = G_OBJECT_CLASS (gala_daemon_dbus_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_DAEMON_TYPE_DBUS, GalaDaemonDBus);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, GALA_DAEMON_DBUS_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_gala_daemon_dbus_lost_gala_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_daemon_dbus_lost_gala_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	return obj;
}

static void
gala_daemon_dbus_class_init (GalaDaemonDBusClass * klass,
                             gpointer klass_data)
{
	gala_daemon_dbus_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDaemonDBus_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_daemon_dbus_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_daemon_dbus_finalize;
}

static void
gala_daemon_dbus_instance_init (GalaDaemonDBus * self,
                                gpointer klass)
{
	self->priv = gala_daemon_dbus_get_instance_private (self);
	self->priv->wm_proxy = NULL;
	self->priv->monitor_labels = NULL;
}

static void
gala_daemon_dbus_finalize (GObject * obj)
{
	GalaDaemonDBus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_DAEMON_TYPE_DBUS, GalaDaemonDBus);
	_g_object_unref0 (self->priv->wm_proxy);
	_g_object_unref0 (self->priv->window_menu);
	_g_object_unref0 (self->priv->background_menu);
	(self->priv->monitor_labels == NULL) ? NULL : (self->priv->monitor_labels = (_g_list_free__g_object_unref0_ (self->priv->monitor_labels), NULL));
	G_OBJECT_CLASS (gala_daemon_dbus_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_daemon_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDaemonDBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_daemon_dbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDaemonDBus), 0, (GInstanceInitFunc) gala_daemon_dbus_instance_init, NULL };
	GType gala_daemon_dbus_type_id;
	gala_daemon_dbus_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDaemonDBus", &g_define_type_info, 0);
	g_type_set_qdata (gala_daemon_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_daemon_dbus_register_object);
	GalaDaemonDBus_private_offset = g_type_add_instance_private (gala_daemon_dbus_type_id, sizeof (GalaDaemonDBusPrivate));
	return gala_daemon_dbus_type_id;
}

GType
gala_daemon_dbus_get_type (void)
{
	static gsize gala_daemon_dbus_type_id__once = 0;
	if (g_once_init_enter (&gala_daemon_dbus_type_id__once)) {
		GType gala_daemon_dbus_type_id;
		gala_daemon_dbus_type_id = gala_daemon_dbus_get_type_once ();
		g_once_init_leave (&gala_daemon_dbus_type_id__once, gala_daemon_dbus_type_id);
	}
	return gala_daemon_dbus_type_id__once;
}

static void
_dbus_gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaWindowFlags flags = 0U;
	GVariant* _tmp1_;
	gint display_width = 0;
	GVariant* _tmp2_;
	gint display_height = 0;
	GVariant* _tmp3_;
	gint x = 0;
	GVariant* _tmp4_;
	gint y = 0;
	GVariant* _tmp5_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	display_width = g_variant_get_int32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	display_height = g_variant_get_int32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp4_);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp5_);
	g_variant_unref (_tmp5_);
	gala_daemon_dbus_show_window_menu (self, flags, display_width, display_height, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint display_width = 0;
	GVariant* _tmp6_;
	gint display_height = 0;
	GVariant* _tmp7_;
	gint x = 0;
	GVariant* _tmp8_;
	gint y = 0;
	GVariant* _tmp9_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	display_width = g_variant_get_int32 (_tmp6_);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	display_height = g_variant_get_int32 (_tmp7_);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp9_);
	g_variant_unref (_tmp9_);
	gala_daemon_dbus_show_desktop_menu (self, display_width, display_height, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_vala_GalaDaemonMonitorLabelInfo_array_free (GalaDaemonMonitorLabelInfo * array,
                                             gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gala_daemon_monitor_label_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaDaemonMonitorLabelInfo* label_infos = NULL;
	gint label_infos_length1 = 0;
	GVariant* _tmp10_;
	GalaDaemonMonitorLabelInfo* _tmp11_;
	gint _tmp11__length;
	gint _tmp11__size;
	gint _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp11_ = g_new (GalaDaemonMonitorLabelInfo, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
	g_variant_iter_init (&_tmp12_, _tmp10_);
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
		GalaDaemonMonitorLabelInfo _tmp14_;
		GVariantIter _tmp15_;
		GVariant* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		GVariant* _tmp19_;
		GVariant* _tmp20_;
		GVariant* _tmp21_;
		if (_tmp11__size == _tmp11__length) {
			_tmp11__size = 2 * _tmp11__size;
			_tmp11_ = g_renew (GalaDaemonMonitorLabelInfo, _tmp11_, _tmp11__size + 1);
		}
		g_variant_iter_init (&_tmp15_, _tmp13_);
		_tmp16_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.monitor = g_variant_get_int32 (_tmp16_);
		g_variant_unref (_tmp16_);
		_tmp17_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.label = g_variant_dup_string (_tmp17_, NULL);
		g_variant_unref (_tmp17_);
		_tmp18_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.background_color = g_variant_dup_string (_tmp18_, NULL);
		g_variant_unref (_tmp18_);
		_tmp19_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.text_color = g_variant_dup_string (_tmp19_, NULL);
		g_variant_unref (_tmp19_);
		_tmp20_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.x = g_variant_get_int32 (_tmp20_);
		g_variant_unref (_tmp20_);
		_tmp21_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.y = g_variant_get_int32 (_tmp21_);
		g_variant_unref (_tmp21_);
		_tmp11_[_tmp11__length++] = _tmp14_;
		g_variant_unref (_tmp13_);
	}
	label_infos_length1 = _tmp11__length1;
	label_infos = _tmp11_;
	g_variant_unref (_tmp10_);
	gala_daemon_dbus_show_monitor_labels (self, label_infos, label_infos_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	label_infos = (_vala_GalaDaemonMonitorLabelInfo_array_free (label_infos, label_infos_length1), NULL);
	;
}

static void
_dbus_gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	gala_daemon_dbus_hide_monitor_labels (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_daemon_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowWindowMenu") == 0) {
		_dbus_gala_daemon_dbus_show_window_menu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowDesktopMenu") == 0) {
		_dbus_gala_daemon_dbus_show_desktop_menu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowMonitorLabels") == 0) {
		_dbus_gala_daemon_dbus_show_monitor_labels (object, parameters, invocation);
	} else if (strcmp (method_name, "HideMonitorLabels") == 0) {
		_dbus_gala_daemon_dbus_hide_monitor_labels (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_daemon_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_daemon_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_daemon_dbus_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_daemon_dbus_dbus_interface_info), &_gala_daemon_dbus_dbus_interface_vtable, data, _gala_daemon_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_daemon_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

