/*
 * Deskflow -- mouse and keyboard sharing utility
 * SPDX-FileCopyrightText: (C) 2025 Deskflow Developers
 * SPDX-FileCopyrightText: (C) 2012 - 2016 Symless Ltd.
 * SPDX-FileCopyrightText: (C) 2002 Chris Schoeneman
 * SPDX-License-Identifier: GPL-2.0-only WITH LicenseRef-OpenSSL-Exception
 */

#pragma once

#include "base/Log.h"
#include "base/LogLevel.h"

//! Outputter interface
/*!
Type of outputter interface.  The logger performs all output through
outputters.  ILogOutputter overrides must not call any log functions
directly or indirectly.
*/
class ILogOutputter
{
public:
  virtual ~ILogOutputter() = default;

  //! @name manipulators
  //@{

  //! Open the outputter
  /*!
  Opens the outputter for writing.  Calling this method on an
  already open outputter must have no effect.
  */
  virtual void open(const QString &title) = 0;

  //! Close the outputter
  /*!
  Close the outputter.  Calling this method on an already closed
  outputter must have no effect.
  */
  virtual void close() = 0;

  //! Write a message with level
  /*!
  Writes \c message, which has the given \c level, to a log.
  If this method returns true then Log will stop passing the
  message to all outputters in the outputter chain, otherwise
  it continues.  Most implementations should return true.
  */
  virtual bool write(LogLevel level, const QString &message) = 0;

  //@}
};
