/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration represents a declarative configuration of the ACMEIssuerDNS01ProviderRFC2136 type for use
// with apply.
type ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration struct {
	Nameserver    *string                                     `json:"nameserver,omitempty"`
	TSIGSecret    *metav1.SecretKeySelectorApplyConfiguration `json:"tsigSecretSecretRef,omitempty"`
	TSIGKeyName   *string                                     `json:"tsigKeyName,omitempty"`
	TSIGAlgorithm *string                                     `json:"tsigAlgorithm,omitempty"`
	Protocol      *acmev1.RFC2136UpdateProtocol               `json:"protocol,omitempty"`
}

// ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration constructs a declarative configuration of the ACMEIssuerDNS01ProviderRFC2136 type for use with
// apply.
func ACMEIssuerDNS01ProviderRFC2136() *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration {
	return &ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration{}
}

// WithNameserver sets the Nameserver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Nameserver field is set to the value of the last call.
func (b *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration) WithNameserver(value string) *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration {
	b.Nameserver = &value
	return b
}

// WithTSIGSecret sets the TSIGSecret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TSIGSecret field is set to the value of the last call.
func (b *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration) WithTSIGSecret(value *metav1.SecretKeySelectorApplyConfiguration) *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration {
	b.TSIGSecret = value
	return b
}

// WithTSIGKeyName sets the TSIGKeyName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TSIGKeyName field is set to the value of the last call.
func (b *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration) WithTSIGKeyName(value string) *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration {
	b.TSIGKeyName = &value
	return b
}

// WithTSIGAlgorithm sets the TSIGAlgorithm field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TSIGAlgorithm field is set to the value of the last call.
func (b *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration) WithTSIGAlgorithm(value string) *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration {
	b.TSIGAlgorithm = &value
	return b
}

// WithProtocol sets the Protocol field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Protocol field is set to the value of the last call.
func (b *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration) WithProtocol(value acmev1.RFC2136UpdateProtocol) *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration {
	b.Protocol = &value
	return b
}
