/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "cs-consolekit-session-proxy.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ConsoleKit.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CsConsoleKitSession
 * @title: CsConsoleKitSession
 * @short_description: Generated C code for the org.freedesktop.ConsoleKit.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ConsoleKit-Session.top_of_page">org.freedesktop.ConsoleKit.Session</link> D-Bus interface in C.
 */

enum
{
  CS__CONSOLE_KIT_SESSION_ACTIVE_CHANGED,
  CS__CONSOLE_KIT_SESSION_LOCK,
  CS__CONSOLE_KIT_SESSION_UNLOCK,
};

static unsigned CS__CONSOLE_KIT_SESSION_SIGNALS[3] = { 0 };

/* ---- Introspection data for org.freedesktop.ConsoleKit.Session ---- */

static const GDBusAnnotationInfo _cs_console_kit_session_method_lock_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _cs_console_kit_session_method_lock_annotation_info_pointers[] =
{
  &_cs_console_kit_session_method_lock_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _cs_console_kit_session_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_cs_console_kit_session_method_lock_annotation_info_pointers
  },
  "handle-lock",
  FALSE
};

static const GDBusAnnotationInfo _cs_console_kit_session_method_unlock_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _cs_console_kit_session_method_unlock_annotation_info_pointers[] =
{
  &_cs_console_kit_session_method_unlock_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _cs_console_kit_session_method_info_unlock =
{
  {
    -1,
    (gchar *) "Unlock",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_cs_console_kit_session_method_unlock_annotation_info_pointers
  },
  "handle-unlock",
  FALSE
};

static const GDBusMethodInfo * const _cs_console_kit_session_method_info_pointers[] =
{
  &_cs_console_kit_session_method_info_lock.parent_struct,
  &_cs_console_kit_session_method_info_unlock.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _cs_console_kit_session_signal_info_active_changed_ARG_is_active =
{
  {
    -1,
    (gchar *) "is_active",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cs_console_kit_session_signal_info_active_changed_ARG_pointers[] =
{
  &_cs_console_kit_session_signal_info_active_changed_ARG_is_active.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _cs_console_kit_session_signal_info_active_changed =
{
  {
    -1,
    (gchar *) "ActiveChanged",
    (GDBusArgInfo **) &_cs_console_kit_session_signal_info_active_changed_ARG_pointers,
    NULL
  },
  "active-changed"
};

static const _ExtendedGDBusSignalInfo _cs_console_kit_session_signal_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL
  },
  "lock"
};

static const _ExtendedGDBusSignalInfo _cs_console_kit_session_signal_info_unlock =
{
  {
    -1,
    (gchar *) "Unlock",
    NULL,
    NULL
  },
  "unlock"
};

static const GDBusSignalInfo * const _cs_console_kit_session_signal_info_pointers[] =
{
  &_cs_console_kit_session_signal_info_active_changed.parent_struct,
  &_cs_console_kit_session_signal_info_lock.parent_struct,
  &_cs_console_kit_session_signal_info_unlock.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cs_console_kit_session_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ConsoleKit.Session",
    (GDBusMethodInfo **) &_cs_console_kit_session_method_info_pointers,
    (GDBusSignalInfo **) &_cs_console_kit_session_signal_info_pointers,
    NULL,
    NULL
  },
  "console-kit-session",
};


/**
 * cs_console_kit_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ConsoleKit-Session.top_of_page">org.freedesktop.ConsoleKit.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cs_console_kit_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cs_console_kit_session_interface_info.parent_struct;
}

/**
 * cs_console_kit_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CsConsoleKitSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cs_console_kit_session_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
cs_console_kit_session_signal_marshal_active_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_console_kit_session_signal_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_console_kit_session_signal_marshal_unlock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_console_kit_session_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_console_kit_session_method_marshal_unlock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CsConsoleKitSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ConsoleKit-Session.top_of_page">org.freedesktop.ConsoleKit.Session</link>.
 */

/**
 * CsConsoleKitSessionIface:
 * @parent_iface: The parent interface.
 * @handle_lock: Handler for the #CsConsoleKitSession::handle-lock signal.
 * @handle_unlock: Handler for the #CsConsoleKitSession::handle-unlock signal.
 * @active_changed: Handler for the #CsConsoleKitSession::active-changed signal.
 * @lock: Handler for the #CsConsoleKitSession::lock signal.
 * @unlock: Handler for the #CsConsoleKitSession::unlock signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ConsoleKit-Session.top_of_page">org.freedesktop.ConsoleKit.Session</link>.
 */

typedef CsConsoleKitSessionIface CsConsoleKitSessionInterface;
G_DEFINE_INTERFACE (CsConsoleKitSession, cs_console_kit_session, G_TYPE_OBJECT)

static void
cs_console_kit_session_default_init (CsConsoleKitSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CsConsoleKitSession::handle-lock:
   * @object: A #CsConsoleKitSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_console_kit_session_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsConsoleKitSessionIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      cs_console_kit_session_method_marshal_lock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CsConsoleKitSession::handle-unlock:
   * @object: A #CsConsoleKitSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Unlock">Unlock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_console_kit_session_complete_unlock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unlock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsConsoleKitSessionIface, handle_unlock),
    g_signal_accumulator_true_handled,
    NULL,
      cs_console_kit_session_method_marshal_unlock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * CsConsoleKitSession::active-changed:
   * @object: A #CsConsoleKitSession.
   * @arg_is_active: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ConsoleKit-Session.ActiveChanged">"ActiveChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CS__CONSOLE_KIT_SESSION_SIGNALS[CS__CONSOLE_KIT_SESSION_ACTIVE_CHANGED] =
    g_signal_new ("active-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CsConsoleKitSessionIface, active_changed),
      NULL,
      NULL,
      cs_console_kit_session_signal_marshal_active_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /**
   * CsConsoleKitSession::lock:
   * @object: A #CsConsoleKitSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ConsoleKit-Session.Lock">"Lock"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CS__CONSOLE_KIT_SESSION_SIGNALS[CS__CONSOLE_KIT_SESSION_LOCK] =
    g_signal_new ("lock",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CsConsoleKitSessionIface, lock),
      NULL,
      NULL,
      cs_console_kit_session_signal_marshal_lock,
      G_TYPE_NONE,
      0);

  /**
   * CsConsoleKitSession::unlock:
   * @object: A #CsConsoleKitSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ConsoleKit-Session.Unlock">"Unlock"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CS__CONSOLE_KIT_SESSION_SIGNALS[CS__CONSOLE_KIT_SESSION_UNLOCK] =
    g_signal_new ("unlock",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CsConsoleKitSessionIface, unlock),
      NULL,
      NULL,
      cs_console_kit_session_signal_marshal_unlock,
      G_TYPE_NONE,
      0);

}

/**
 * cs_console_kit_session_emit_active_changed:
 * @object: A #CsConsoleKitSession.
 * @arg_is_active: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ConsoleKit-Session.ActiveChanged">"ActiveChanged"</link> D-Bus signal.
 */
void
cs_console_kit_session_emit_active_changed (
    CsConsoleKitSession *object,
    gboolean arg_is_active)
{
  g_signal_emit (object, CS__CONSOLE_KIT_SESSION_SIGNALS[CS__CONSOLE_KIT_SESSION_ACTIVE_CHANGED], 0, arg_is_active);
}

/**
 * cs_console_kit_session_emit_lock:
 * @object: A #CsConsoleKitSession.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ConsoleKit-Session.Lock">"Lock"</link> D-Bus signal.
 */
void
cs_console_kit_session_emit_lock (
    CsConsoleKitSession *object)
{
  g_signal_emit (object, CS__CONSOLE_KIT_SESSION_SIGNALS[CS__CONSOLE_KIT_SESSION_LOCK], 0);
}

/**
 * cs_console_kit_session_emit_unlock:
 * @object: A #CsConsoleKitSession.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ConsoleKit-Session.Unlock">"Unlock"</link> D-Bus signal.
 */
void
cs_console_kit_session_emit_unlock (
    CsConsoleKitSession *object)
{
  g_signal_emit (object, CS__CONSOLE_KIT_SESSION_SIGNALS[CS__CONSOLE_KIT_SESSION_UNLOCK], 0);
}

/**
 * cs_console_kit_session_call_lock:
 * @proxy: A #CsConsoleKitSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_console_kit_session_call_lock_finish() to get the result of the operation.
 *
 * See cs_console_kit_session_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
cs_console_kit_session_call_lock (
    CsConsoleKitSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_console_kit_session_call_lock_finish:
 * @proxy: A #CsConsoleKitSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_console_kit_session_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_console_kit_session_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_console_kit_session_call_lock_finish (
    CsConsoleKitSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_console_kit_session_call_lock_sync:
 * @proxy: A #CsConsoleKitSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_console_kit_session_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_console_kit_session_call_lock_sync (
    CsConsoleKitSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_console_kit_session_call_unlock:
 * @proxy: A #CsConsoleKitSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Unlock">Unlock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_console_kit_session_call_unlock_finish() to get the result of the operation.
 *
 * See cs_console_kit_session_call_unlock_sync() for the synchronous, blocking version of this method.
 */
void
cs_console_kit_session_call_unlock (
    CsConsoleKitSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_console_kit_session_call_unlock_finish:
 * @proxy: A #CsConsoleKitSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_console_kit_session_call_unlock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_console_kit_session_call_unlock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_console_kit_session_call_unlock_finish (
    CsConsoleKitSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_console_kit_session_call_unlock_sync:
 * @proxy: A #CsConsoleKitSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Unlock">Unlock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_console_kit_session_call_unlock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_console_kit_session_call_unlock_sync (
    CsConsoleKitSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_console_kit_session_complete_lock:
 * @object: A #CsConsoleKitSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_console_kit_session_complete_lock (
    CsConsoleKitSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_console_kit_session_complete_unlock:
 * @object: A #CsConsoleKitSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ConsoleKit-Session.Unlock">Unlock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_console_kit_session_complete_unlock (
    CsConsoleKitSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CsConsoleKitSessionProxy:
 *
 * The #CsConsoleKitSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CsConsoleKitSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CsConsoleKitSessionProxy.
 */

struct _CsConsoleKitSessionProxyPrivate
{
  GData *qdata;
};

static void cs_console_kit_session_proxy_iface_init (CsConsoleKitSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CsConsoleKitSessionProxy, cs_console_kit_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CsConsoleKitSessionProxy)
                         G_IMPLEMENT_INTERFACE (CS_TYPE_CONSOLE_KIT_SESSION, cs_console_kit_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CsConsoleKitSessionProxy, cs_console_kit_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CS_TYPE_CONSOLE_KIT_SESSION, cs_console_kit_session_proxy_iface_init))

#endif
static void
cs_console_kit_session_proxy_finalize (GObject *object)
{
  CsConsoleKitSessionProxy *proxy = CS_CONSOLE_KIT_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cs_console_kit_session_proxy_parent_class)->finalize (object);
}

static void
cs_console_kit_session_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
cs_console_kit_session_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
cs_console_kit_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cs_console_kit_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CS_TYPE_CONSOLE_KIT_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CS_TYPE_CONSOLE_KIT_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cs_console_kit_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CsConsoleKitSessionProxy *proxy = CS_CONSOLE_KIT_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_console_kit_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_console_kit_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
cs_console_kit_session_proxy_init (CsConsoleKitSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cs_console_kit_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CS_TYPE_CONSOLE_KIT_SESSION_PROXY, CsConsoleKitSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cs_console_kit_session_interface_info ());
}

static void
cs_console_kit_session_proxy_class_init (CsConsoleKitSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cs_console_kit_session_proxy_finalize;
  gobject_class->get_property = cs_console_kit_session_proxy_get_property;
  gobject_class->set_property = cs_console_kit_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cs_console_kit_session_proxy_g_signal;
  proxy_class->g_properties_changed = cs_console_kit_session_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CsConsoleKitSessionProxyPrivate));
#endif
}

static void
cs_console_kit_session_proxy_iface_init (CsConsoleKitSessionIface *iface G_GNUC_UNUSED)
{
}

/**
 * cs_console_kit_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ConsoleKit-Session.top_of_page">org.freedesktop.ConsoleKit.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_console_kit_session_proxy_new_finish() to get the result of the operation.
 *
 * See cs_console_kit_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cs_console_kit_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CS_TYPE_CONSOLE_KIT_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ConsoleKit.Session", NULL);
}

/**
 * cs_console_kit_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_console_kit_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cs_console_kit_session_proxy_new().
 *
 * Returns: (transfer full) (type CsConsoleKitSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
CsConsoleKitSession *
cs_console_kit_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CS_CONSOLE_KIT_SESSION (ret);
  else
    return NULL;
}

/**
 * cs_console_kit_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ConsoleKit-Session.top_of_page">org.freedesktop.ConsoleKit.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cs_console_kit_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CsConsoleKitSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
CsConsoleKitSession *
cs_console_kit_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CS_TYPE_CONSOLE_KIT_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ConsoleKit.Session", NULL);
  if (ret != NULL)
    return CS_CONSOLE_KIT_SESSION (ret);
  else
    return NULL;
}


/**
 * cs_console_kit_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cs_console_kit_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_console_kit_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cs_console_kit_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cs_console_kit_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CS_TYPE_CONSOLE_KIT_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ConsoleKit.Session", NULL);
}

/**
 * cs_console_kit_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_console_kit_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cs_console_kit_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CsConsoleKitSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
CsConsoleKitSession *
cs_console_kit_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CS_CONSOLE_KIT_SESSION (ret);
  else
    return NULL;
}

/**
 * cs_console_kit_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cs_console_kit_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cs_console_kit_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CsConsoleKitSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
CsConsoleKitSession *
cs_console_kit_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CS_TYPE_CONSOLE_KIT_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ConsoleKit.Session", NULL);
  if (ret != NULL)
    return CS_CONSOLE_KIT_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CsConsoleKitSessionSkeleton:
 *
 * The #CsConsoleKitSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CsConsoleKitSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CsConsoleKitSessionSkeleton.
 */

struct _CsConsoleKitSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cs_console_kit_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CS_TYPE_CONSOLE_KIT_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CS_TYPE_CONSOLE_KIT_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cs_console_kit_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_console_kit_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cs_console_kit_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_console_kit_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cs_console_kit_session_skeleton_vtable =
{
  _cs_console_kit_session_skeleton_handle_method_call,
  _cs_console_kit_session_skeleton_handle_get_property,
  _cs_console_kit_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cs_console_kit_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cs_console_kit_session_interface_info ();
}

static GDBusInterfaceVTable *
cs_console_kit_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cs_console_kit_session_skeleton_vtable;
}

static GVariant *
cs_console_kit_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cs_console_kit_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cs_console_kit_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cs_console_kit_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cs_console_kit_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ConsoleKit.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
cs_console_kit_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_cs_console_kit_session_on_signal_active_changed (
    CsConsoleKitSession *object,
    gboolean arg_is_active)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_is_active));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ConsoleKit.Session", "ActiveChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_cs_console_kit_session_on_signal_lock (
    CsConsoleKitSession *object)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ConsoleKit.Session", "Lock",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_cs_console_kit_session_on_signal_unlock (
    CsConsoleKitSession *object)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ConsoleKit.Session", "Unlock",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void cs_console_kit_session_skeleton_iface_init (CsConsoleKitSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CsConsoleKitSessionSkeleton, cs_console_kit_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CsConsoleKitSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (CS_TYPE_CONSOLE_KIT_SESSION, cs_console_kit_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CsConsoleKitSessionSkeleton, cs_console_kit_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CS_TYPE_CONSOLE_KIT_SESSION, cs_console_kit_session_skeleton_iface_init))

#endif
static void
cs_console_kit_session_skeleton_finalize (GObject *object)
{
  CsConsoleKitSessionSkeleton *skeleton = CS_CONSOLE_KIT_SESSION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cs_console_kit_session_skeleton_parent_class)->finalize (object);
}

static void
cs_console_kit_session_skeleton_init (CsConsoleKitSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cs_console_kit_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CS_TYPE_CONSOLE_KIT_SESSION_SKELETON, CsConsoleKitSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
cs_console_kit_session_skeleton_class_init (CsConsoleKitSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cs_console_kit_session_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cs_console_kit_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cs_console_kit_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cs_console_kit_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cs_console_kit_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CsConsoleKitSessionSkeletonPrivate));
#endif
}

static void
cs_console_kit_session_skeleton_iface_init (CsConsoleKitSessionIface *iface)
{
  iface->active_changed = _cs_console_kit_session_on_signal_active_changed;
  iface->lock = _cs_console_kit_session_on_signal_lock;
  iface->unlock = _cs_console_kit_session_on_signal_unlock;
}

/**
 * cs_console_kit_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ConsoleKit-Session.top_of_page">org.freedesktop.ConsoleKit.Session</link>.
 *
 * Returns: (transfer full) (type CsConsoleKitSessionSkeleton): The skeleton object.
 */
CsConsoleKitSession *
cs_console_kit_session_skeleton_new (void)
{
  return CS_CONSOLE_KIT_SESSION (g_object_new (CS_TYPE_CONSOLE_KIT_SESSION_SKELETON, NULL));
}

